import icartt
import pathlib

# load a new dataset from an existing file
wd = pathlib.Path(__file__).parent
ict = icartt.Dataset(
    wd / ".." / "example_data" / "expect_warn" / "AR_DC8_20050203_R0.ict"
)

# list variable names
[x for x in ict.variables]

# independent, independent bounded, dependent, auxiliary variables?
ict.independentVariable.shortname
ict.independentBoundedVariable.shortname
", ".join([x for x in ict.auxiliaryVariables])
", ".join([x for x in ict.dependentVariables])

# some info on a variable (units, missing value of "Latitude")
ict.variables["Latitude"].units
ict.variables["Latitude"].miss

# get steps for which data is available:
tsteps = [x for x in ict.data]

# let's look at the first time step data
ict.data[tsteps[0]]

# auxiliary data at this time step:
ict.data[tsteps[0]]["AUX"][:]

# dependent data at this time step:
tstepdata = ict.data[tsteps[0]]["DEP"][:]

# get the ozone mixing ratio for those data where Altitude < 10000.0:
tstepdata[tstepdata["Altitude[]"] < 10000.0]["O3_MR[]"]
