import icartt
import pathlib

# load a new dataset from an existing file
wd = pathlib.Path(__file__).parent
ict = icartt.Dataset(wd / ".." / "example_data" / "expect_ok" / "DC8-20160517.ict")

# read some metadata
ict.PIName
ict.PIAffiliation
ict.missionName
ict.dataSourceDescription
ict.dataID
ict.locationID

# list variable names
[x for x in ict.variables]

# some info on a variable
ict.variables["Alt_ft"].units
ict.variables["Alt_ft"].miss

# get data for variable 'UTC':
ict.data["UTC"]

# get all data (NumPy array):
ict.data[:]

# get the altitude in feet for those data where UTC < 86400.0:
ict.data[ict.data["UTC"] < 86400.0]["Alt_ft"]
