gh issue list --json author,body,comments,createdAt,labels,title,url --state all > issue_data.json

python3 - << EOF
import json

with open("issue_data.json", "r") as f:
    j = json.load(f)

import csv

with open("issue_data.csv", "w", encoding="utf-8", newline='') as f:
    writer = csv.writer(f, quoting=csv.QUOTE_ALL)
    writer.writerow(["title", "description"])
    for issue in j:
        row = [ issue['title'] ]
        comments = [ f"<h2>Comment by {comment['author']['login']} on {comment['createdAt']}:</h2>\n{comment['body']}\n" for comment in issue['comments'] ]
        row.append( f"*Issue imported from ULeeds Github: {issue['url']}*\n\n{issue['body']}\n\n*(created {issue['createdAt']} by {issue['author']['login']})*{''.join(comments)}\n\n" )
        writer.writerow( [ x.replace('\n', '<br/>') for x in row ] )
EOF
