import datetime
import numpy as np
from collections import deque

class Status:
    def __init__(self, name, n, report_percentage=1.0):
        self.name               = name
        self.i                  = 0
        self.n                  = n

        self.navg               = int(report_percentage * n / 100.0)
        self.report_percentage  = report_percentage

        self.t                  = deque( [ datetime.datetime.now() ] )

        self.reporting_steps    = [ int(x * n / 100.0)+1 for x in np.arange(0.0, 100.0, report_percentage) ]

        maxlen                  = len(str(self.n)) + 1
        self.report_string      = "{{:s}}: {{:>{maxlen:d}d}} of {{:>{maxlen:d}d}} ({{:3.0f}}%, {{:7.0f}} seconds left)".format(maxlen=maxlen)

    def iterate(self):
        self.i                 += 1
        self.t.append(datetime.datetime.now())

        if len(self.t) > self.navg:
            nul = self.t.popleft()
        
        if self.i in self.reporting_steps:
            avg_dt = np.sum ( np.diff(self.t) ) / len(self.t) if len(self.t) > 1 else datetime.timedelta(seconds=1)
            print(self.report_string.format(self.name, self.i+1, self.n, self.i/self.n*100, avg_dt.total_seconds() * (self.n-self.i) ))
