import argparse
import datetime

def valid_date(s):
    try:
        return datetime.datetime.strptime(s, "%Y-%m-%d_%H:%M:%S")
    except ValueError:
        msg = "Not a valid date: '{0}'.".format(s)
        raise argparse.ArgumentTypeError(msg)

parser = argparse.ArgumentParser(description='Emissary')
parser.add_argument('input_file_path', type=str)
parser.add_argument('output_date', type=valid_date, help="YYYY-mm-dd_HH:MM:SS")
parser.add_argument('output_file_path',  type=str)
#parser.add_argument('--time_profile_data_path', type=str, default='time_profiles')
#parser.add_argument('--country_code_A3', type=str, default='DEU')

args = parser.parse_args()
#args = parser.parse_args(['/Users/lechriso/Desktop/wrfchemi_d02', '2022-01-25 13:00:00', '/Users/lechriso/Desktop/OUT_wrfchemi_d02_{date:s}'])

import numpy as np
import os

if False:
    hourly_profiles = np.genfromtxt( os.path.join(args.time_profile_data_path, 'hourly_profiles.csv'), skip_header=1,
                                    delimiter=',', dtype=[('Country_code_A3','S3'),('activity_code','S3'),('month_id','i8'),('Daytype_id','i8'),*[("h{:d}".format(i),'f8') for i in range(1,25)]])

    weekly_profiles = np.genfromtxt( os.path.join(args.time_profile_data_path, 'weekly_profiles.csv'), skip_header=1,
                                    delimiter=',', dtype=[('Country_code_A3','S3'),('activity_code','S3'),('Weekday_id','i8'), ("daily_factor",'f8')])

    weekdays        = np.genfromtxt( os.path.join(args.time_profile_data_path, 'weekdays.csv'), skip_header=1,
                                    delimiter=';', dtype=[('Weekend_type_id','i8'),('weekday_name','S10'),('Weekday_id','i8'),('Daytype_id','i8')])

    weekenddays     = np.genfromtxt( os.path.join(args.time_profile_data_path, 'weekenddays.csv'), skip_header=1,
                                    delimiter=';', dtype=[('Weekend_type_id','i8'),('Country_code_A3','S3')])

    # limit to country of interest
    hourly_profiles = hourly_profiles[ hourly_profiles['Country_code_A3'] == str.encode(args.country_code_A3) ]
    weekly_profiles = weekly_profiles[ weekly_profiles['Country_code_A3'] == str.encode(args.country_code_A3) ]
    weekenddays     = weekenddays[ weekenddays['Country_code_A3'] == str.encode(args.country_code_A3) ]
    weekdays        = weekdays[ weekdays['Weekend_type_id'] == weekenddays['Weekend_type_id'] ]

datestring = args.output_date.strftime('%Y-%m-%d_%H:%M:%S')

import netCDF4

nc_in   = netCDF4.Dataset(args.input_file_path)
nc_out  = netCDF4.Dataset(args.output_file_path, 'w')

# copy global attributes
for name in nc_in.ncattrs():
    nc_out.setncattr(name, nc_in.getncattr(name))
# copy dimensions
for name, dimension in nc_in.dimensions.items():
    nc_out.createDimension(
        name, (len(dimension) if not dimension.isunlimited() else None))
# copy all file data except for the excluded
for name, variable in nc_in.variables.items():
    x = nc_out.createVariable(name, variable.datatype, variable.dimensions)
    nc_out.variables[name][:] = nc_in.variables[name][:]
    nc_out.variables[name].setncatts(nc_in.variables[name].__dict__)

for i, v in enumerate(list(datestring)):
    nc_out['Times'][0,i] = str.encode(v)

nc_out.setncattr("GMT", args.output_date.strftime("%H"))
nc_out.setncattr("JULYR", args.output_date.strftime("%Y"))
nc_out.setncattr("JULDAY", args.output_date.strftime("%j"))

nc_in.close()
nc_out.close()
