import netCDF4

import yaml

import numpy as np

with open("CAMS_split.yaml", "r") as stream:
    config = yaml.safe_load(stream)

nc_blueprint_total = netCDF4.Dataset(config["blueprints_path_pattern"].format(varname=config["blueprint_sum_var"]))

out = {}

for species in config["blueprint_frac_vars"]:
    nc_blueprint_var = netCDF4.Dataset(config["blueprints_path_pattern"].format(varname=species))
    out[species] = {}
    for in_sector, out_sector in config["sector_translator"].items():
        if not out_sector in out[species]:
            out[species][out_sector] = np.zeros_like(nc_blueprint_total[in_sector][:])
        if in_sector in nc_blueprint_var.variables:
            out[species][out_sector] += nc_blueprint_var[in_sector][:] / nc_blueprint_total[in_sector][:]
            print(f"{species} / {in_sector} / {out_sector}: { np.mean(out[species][out_sector]) }")
    nc_blueprint_var.close()

nc_blueprint_total.close()




total_species = "nmvoc"
total_species_varname = "SumAllSectors"


