# --- Modules and other things ---

module load wrf wrf-chem wps nco netcdf-c netcdf-fortran anthro_emis fire_emis megan_bio_emiss mozbc wesely-exo_coldens python gdal py-requests py-cdsapi py-cartopy py-matplotlib py-netcdf4 py-numpy py-pyproj py-rasterio py-scipy py-shapely py-simplekml py-xarray py-pyshp py-pandas

ulimit -s unlimited

export OMPI_MCA_PML=ucx
export UCX_TLS=tcp,sm
export UCX_NET_DEVICES=eth5

# --- MPI settings ---

mpiCommandPre="mpirun"
#mpiCommandMain="mpirun -mca pml ucx -mca coll ^hcoll -x UCX_TLS=tcp,shm -x UCX_NET_DEVICES=eth5 /usr/bin/time -v"
mpiCommandMain="mpirun"
mpiCommandReal=${mpiCommandPre}

nNodesMain=3
nTasksPerNodeMain=28

nNodesSpinup=1
nTasksPerNodeSpinup=28

# --- Batch system ---

# argument to submit a job in a held state
batchHoldArgument="--hold"
# command to release a held job
batchReleaseCommand="scontrol release"
# command to submit jobs to the queueing system
batchSubmitCommand=sbatch
# dependency argument for chaining runs upon submission
batchDepArgument="--dependency=afterok:__id__"
# sed command ("used as s/__command/\1/") to retrieve job run PID upon
# submission with $batchSubmitCommand
batchPidSedCommand="Submitted batch job \(.*\)"
