# -----------------------------------------------------------------------------
# move output data to staging directory
# -----------------------------------------------------------------------------

for domain in $(seq -f "0%g" 1 ${max_dom})
do
  firstFileDate=__refYear____refMonth____refDay____refHour__0000
  lastFileDate=__endYear____endMonth____endDay____endHour__0000

  for aWrfOutFile in wrfout_d${domain}*[0-9]
  do
    thisFileDate=$(echo ${aWrfOutFile/wrfout_d${domain}//} | tr -dc '0-9')

    if [ "$thisFileDate" -gt "$firstFileDate" ] && [ "$thisFileDate" -le "$lastFileDate" ]
    then
        mv ${aWrfOutFile} ${stagingDir}/
        chmod 0644 ${stagingDir}/${aWrfOutFile}
      fi
  done

  for aWrfRstFile in wrfrst_d${domain}*[0-9]
  do
    thisFileDate=$(echo ${aWrfRstFile/wrfrst_d${domain}//} | tr -dc '0-9')

    if [ "$thisFileDate" -gt "$firstFileDate" ] && [ "$thisFileDate" -le "$lastFileDate" ]
    then
        mv ${aWrfRstFile} ${restartDir}/
        chmod 0644 ${restartDir}/${aWrfRstFile}
      fi
  done
  
  trackFile=wrfout_track_d${domain}
  if [ -e "$trackFile" ]
  then
    mv ${trackFile} ${stagingDir}/wrftrack_d${domain}___refYear__-__refMonth__-__refDay_____refHour__:00:00-__endYear__-__endMonth__-__endDay_____endHour__:00:00.nc
  fi
done
