# -----------------------------------------------------------------------------
# update restart file for WRF-Chem restart
# -----------------------------------------------------------------------------

# we will re-use this in the main job...
echo "isColdStart=0" >> config.bash

for domain in $(seq -f "0%g" 1 ${max_dom})
do

newRunRstFile=wrfrst_d${domain}___refYear__-__refMonth__-__refDay_____refHour__:00:00
prevRunRstFile=${restartDir}/${newRunRstFile}

if [ -f ${prevRunRstFile} ]
then

echo "substituting initial data with ${prevRunRstFile}"

# listing variables in old (chemistry) and new (met-only) restart files
ncks --trd -m ${prevRunRstFile} | grep -E ': type' | cut -f 1 -d ' ' | sed 's/://' | sort > chemVarList
ncks --trd -m ${newRunRstFile}  | grep -E ': type' | cut -f 1 -d ' ' | sed 's/://' | sort > metVarList

# determining arrays only in old (chemistry) restart file
chemVarsArr=( $(awk 'FNR==NR{a[$0]++;next}!a[$0]' metVarList chemVarList) )
# converting to comma-separated string
chemVarsLst=${chemVarsArr[@]}
chemVarsTxt=${chemVarsLst// /,}

# adding chemistry variables to new restart file
ncks -A -v ${chemVarsTxt} ${prevRunRstFile} ${newRunRstFile}

# only if this all works, we do a warm start!
# we will re-use this in the main job...
echo "isColdStart=1" >> config.bash

fi

done
