# -----------------------------------------------------------------------------
# MOZART / IC/BC
# -----------------------------------------------------------------------------

if [ -f mozbc_outer.inp ]
then

let totDays="((spinupTime+fcstTime)/24)+2"
i=0
for day in $(seq -w -1 $totDays)
do
  # date format stupidity
  txty="${day} days"
  if [ $day -lt 0 ]
  then
    txty="${day/-/} days ago"
  fi

  curFile=$(date -u --date="__refYear__-__refMonth__-__refDay__ __refHour__:00:00 ${txty}" "+${chembcFilePattern}")

  ln -s ${curFile} ./moz$(printf "%04d" $i).nc
  let i=i+1
done

# first domain, always
${mozbcBin} < mozbc_outer.inp > mozbc.log

for domain in $(seq 2 ${max_dom})
do
  /bin/sed -s "s/__domain__/${domain}/" < mozbc_inner.inp > mozbc_inner_d${domain}.inp
  ${mozbcBin} < mozbc_inner_d${domain}.inp >> mozbc.log
done
fi
