
# -----------------------------------------------------------------------------
# fire emissions
# -----------------------------------------------------------------------------

# using fire_emis:
if [ -f fire_emis.inp ]
then
  
  ln -s $(dirname ${fireFilePattern})/*nc .
  
  # put contents of first day source file into local file "FINN_FIRES.txt"
  curFile=$(date -u --date="__startYear__-__startMonth__-__startDay__" "+${fireFilePattern}")
  [ -n "$(ls -1 ${curFile} 2> /dev/null | head -1)" ] || echo "No fire input files found."
  
  cat < ${curFile} > ./FINN_FIRES.txt

  # loop over following days - if not found, take last existing one and replace date
  # reason: no fire files for the future, assume persistence...
  let totTime="fcstTime+spinupTime+metInc+24"
  for hour in $(seq -w 24 24 ${totTime})
  do
    nextFile=$(date -u --date="__startYear__-__startMonth__-__startDay__ ${hour} hours" "+${fireFilePattern}")
    nextJDay=$(date -u --date="__startYear__-__startMonth__-__startDay__ ${hour} hours" "+%j")
    if [ -n "$(ls -1 ${nextFile} 2> /dev/null | head -1)" ]
    then
      tail -n+2 < ${nextFile} >> ./FINN_FIRES.txt
      curFile=${nextFile}
    else
      echo "${nextFile} fire input expected, but missing. Assuming persistence based on $(basename ${curFile})."
      # replace Julian Day in file (first field) with current Julian day
      pattern=$(printf "%6d" $((10#${nextJDay})) )
      sed -E -s "s/^[ ]*[0-9]+,/${pattern},/g" ${curFile} | tail -n+2 >> ./FINN_FIRES.txt
    fi
  done

  # now, fires might not be available, so create a fake input file in that case so
  # the run does not crap out lateron
  nlines=$(wc -l FINN_FIRES.txt | grep -Eo "^[0-9]+")

  if [ "$nlines" -lt 2 ]
  then

    echo "Fire input empty - creating fake input file!"

    cat > FINN_FIRES.txt << EOF
DAY,TIME,GENVEG,LATI,LONGI,AREA,CO2,CO,H2,NO,NO2,SO2,NH3,CH4,NMOC,BIGALD,BIGALK,BIGENE,C10H16,C2H4,C2H5OH,C2H6,C3H6,C3H8,CH2O,CH3CHO,CH3CN,CH3COCH3,CH3COCHO,CH3COOH,CH3OH,CRESOL,GLYALD,HCN,HYAC,ISOP,MACR,MEK,MVK,TOLUENE,HCOOH,C2H2,OC,BC,PM10,PM25
EOF

    for julday in $(seq 1 365)
    do
      cat >> FINN_FIRES.txt << EOF
   ${julday},  1200,     1,    0.9622529984D+01,   -0.6373534012D+02,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,    0.0000000000D+00,
EOF
    done

  fi

  /bin/sed -s "s/__domain__/${max_dom}/" -i fire_emis.inp
  ${fire_emisBin} < fire_emis.inp > fire_emis.out
fi
