# -----------------------------------------------------------------------------
# emissions (anthropogenic / gridded)
# -----------------------------------------------------------------------------

if [ "$emissUseAnthroEmiss" = "true" ]
then
  if [ -f anthro_emis.inp ]
  then
    # difference in years for emission offset
    emissYearOffset=0
    let "emissYearOffset = __startYear__ - emissYear"
    sed -e "s/__emissYearOffset__/${emissYearOffset}/g" -i anthro_emis.inp
    ${anthro_emisBin} < anthro_emis.inp > anthro_emis.out
  fi
else
if [ -f anthro_emis.inp ]
  then
    ubaEmissionsDBPath=/alcc/gpfs2/home/mbees/data/emissions/anthropogenic/GRETA/UniAugsburg_2018_Sub2020_Inlandsprinzip_Greta1.1.4.gdb
    gretaMergeScript=/alcc/gpfs2/home/u/knotechr/wrfotron/tools/emissary/merge_with_GRETA.py
    applyTimeProfileScript=/alcc/gpfs2/home/u/knotechr/wrfotron/tools/emissary/apply_time_profile.py

    if [ ${chainDir}/blueprints/${experiment}/namelist.wps -nt ${workDir}/${experiment}/wrfchemi_d01 ]
    then
        rm -f ${workDir}/${experiment}/wrfchemi_d0[0-9]
    fi

    if [ ! -f ${workDir}/${experiment}/wrfchemi_d01 ]
    then
        # difference in years for emission offset
        emissYearOffset=0
        let "emissYearOffset = __startYear__ - emissYear"
        sed -e "s/__emissYearOffset__/${emissYearOffset}/g" -i anthro_emis.inp
        ${anthro_emisBin} < anthro_emis.inp > anthro_emis.out

        for domain in $(seq -f "0%g" 1 ${max_dom})
        do
            mv wrfchemi_d${domain}* wrfchemi_d${domain}_ORIG
            # supplement GRETA over Germany, save to workdir...
            python3 ${gretaMergeScript} --grid_mappings_path=${workDir}/${experiment} ${ubaEmissionsDBPath} wrfinput_d${domain} wrfchemi_d${domain}_ORIG ${workDir}/${experiment}/wrfchemi_d${domain}
        done
    fi

    for domain in $(seq -f "0%g" 1 ${max_dom})
    do
        outputFilePattern="wrfchemi_d${domain}_%Y-%m-%d_%H:%M:%S"

        let totalTime="fcstTime+spinupTime"
        for addHours in $(seq 0 ${totalTime})
        do
            aWrfChemiFile=$(date -u --date="__startYear__-__startMonth__-__startDay__ __startHour__:00:00 ${addHours} hours" "+${outputFilePattern}")
            anOutputDate=$(date -u --date="__startYear__-__startMonth__-__startDay__ __startHour__:00:00 ${addHours} hours" "+%Y-%m-%d_%H:%M:%S")
            python3 ${applyTimeProfileScript} ${workDir}/${experiment}/wrfchemi_d${domain} ${anOutputDate} ${aWrfChemiFile}
        done
    done

    # replace vertical dimension in namelist
    kemitLine=$(ncdump -h ${workDir}/${experiment}/wrfchemi_d01 | grep "emissions_zdim_stag =")
    # convert to namelist line
    kemitLine=${kemitLine/emissions_zdim_stag/kemit}
    kemitLine=${kemitLine/;/,}
    for aFile in namelist.*
    do
      sed -E -e "s/.*kemit[ ]+=.*/${kemitLine}/" -i $aFile
    done
  fi
fi

#  # preparing existing wrfchemi_files
#  for domain in $(seq 1 ${max_dom})
#  do
#    if [ -f ${emissDir}/wrfchemi_00z_d0${domain} ]
#    then
#      rm -f wrfchemi_00z_d0${domain} wrfchemi_12z_d0${domain}
#      ncks -v XLAT wrfinput_d0${domain} wrfchemi_00z_d0${domain}
#      cp wrfchemi_00z_d0${domain} wrfchemi_12z_d0${domain}
#      ncks -A ${emissDir}/wrfchemi_00z_d0${domain} wrfchemi_00z_d0${domain}
#      ncks -A ${emissDir}/wrfchemi_12z_d0${domain} wrfchemi_12z_d0${domain}
#    fi
#  done