# -----------------------------------------------------------------------------
# Adapt MEGAN files to current sim
# -----------------------------------------------------------------------------

if [ -f megan_bio_emiss.inp ]
then

julday=$(date -u --date="__refDateTxt__" '+%-j')
for domain in $(seq -f "0%g" 1 ${max_dom})
do
  meganDataFile=${workDir}/${experiment}/wrfbiochemi_d${domain}
  rm -f wrfbiochemi_d${domain}
  ncatted -a START_DATE,global,o,c,"__refDate__" \
          -a SIMULATION_START_DATE,global,o,c,"__refDate__" \
          -a JULYR,global,o,i,__refYear__ \
          -a JULDAY,global,o,i,${julday} \
          ${meganDataFile} wrfbiochemi_d${domain}
  ncks -A -v Times wrfinput_d${domain} wrfbiochemi_d${domain}
done

fi
