# -----------------------------------------------------------------------------
# Recreate MEGAN data if necessary, and cache 'em
# -----------------------------------------------------------------------------

# MEGAN takes a long time, but does not really depend on the time of simulation.
# Hence we create one file for the whole year (that is - LAI for all months)
# and lateron only replace start date etc ...

if [ -f megan_bio_emiss.inp ]
then

# in case the namelist.wps is newer (i.e., probably the domain setup has changed, we need to
# recreate the files
if [ ${chainDir}/blueprints/${experiment}/namelist.wps -nt ${workDir}/${experiment}/wrfbiochemi_d01 ]
then
  rm -f ${workDir}/${experiment}/wrfbiochemi_d0[0-9]
fi

# assume if one is missing, all are missing!
if [ ! -f ${workDir}/${experiment}/wrfbiochemi_d01 ]
then
  echo "MEGAN input files do not not exist - recreating from scratch. Grab a coffee..."
  ${meganBioEmissBin} < megan_bio_emiss.inp > megan_bio_emiss.out
  for domain in $(seq -f "0%g" 1 ${max_dom})
  do
    meganDataFile=${workDir}/${experiment}/wrfbiochemi_d${domain}
    mv wrfbiochemi_d${domain} ${meganDataFile}
  done
fi

fi
