# -----------------------------------------------------------------------------
# project-specific preparation scripts
# -----------------------------------------------------------------------------

if [ -f special_pre_actions.bash ]
then
  . special_pre_actions.bash > special_pre_actions.log
fi

# -----------------------------------------------------------------------------
# WPS prep
# -----------------------------------------------------------------------------

for aFile in util geogrid geogrid.exe ungrib ungrib.exe link_grib.csh metgrid metgrid.exe
do
  cp -fr ${WPSDir}/$aFile .
done

ln -s ${metVtableFile} Vtable

# -----------------------------------------------------------------------------
# link meteo data
# -----------------------------------------------------------------------------

fileList=( )
let totTime="fcstTime+spinupTime+metInc"
for hour in $(seq -w 00 ${metInc} ${totTime})
do
  curFile=$(date -u --date="__startYear__-__startMonth__-__startDay__ __startHour__:00:00 ${hour} hours" "+${metFilePattern}")
  if [ -n "$(ls -1 ${curFile} 2> /dev/null | head -1)" ]
  then
    fileList=( ${fileList[@]} ${curFile} )
  else
    echo ${curFile} meteo input expected, but missing...
  fi
done

/bin/csh ./link_grib.csh ${fileList[@]}

# -----------------------------------------------------------------------------
# ungrib
# -----------------------------------------------------------------------------

cp namelist.wps.prep namelist.wps

./ungrib.exe > ungrib.log

rm GRIBFILE*

# -----------------------------------------------------------------------------
# average surface temperatures
# -----------------------------------------------------------------------------

./util/avg_tsfc.exe > avg_tsfc.log

# -----------------------------------------------------------------------------
# geogrid, metgrid
# -----------------------------------------------------------------------------

${mpiCommandPre} ./geogrid.exe

${mpiCommandPre} ./metgrid.exe

rm FILE*

# -----------------------------------------------------------------------------
# real
# -----------------------------------------------------------------------------

cp -r ${WRFDir}/run/* .
rm *.exe
cp -r ${WRFDir}/main/*.exe .

cp namelist.wrf.real namelist.input
cp iofields.met      iofields

${mpiCommandReal} ./real.exe

mkdir -p real_out
mv rsl* real_out/

