# -----------------------------------------------------------------------------
# postprocessing
# -----------------------------------------------------------------------------

. __configDir__config.bash

mkdir -p ${archiveDir}

if [ -f special_post_actions.bash ]
then
  . special_post_actions.bash > special_post_actions.log
fi

cd ${stagingDir}

for domain in $(seq -f "0%g" 1 ${max_dom})
do
  firstFileDate=__refYear____refMonth____refDay____refHour__0000
  lastFileDate=__endYear____endMonth____endDay____endHour__0000

  for aWrfOutFile in wrfout_d${domain}*[0-9]
  do
    thisFileDate=$(echo ${aWrfOutFile/wrfout_d${domain}//} | tr -dc '0-9')

    if [ "$thisFileDate" -gt "$firstFileDate" ] && [ "$thisFileDate" -le "$lastFileDate" ]
    then
      # --------------------- per file postprocessing ----------------------------

      processedWrfOutFile=${aWrfOutFile}_processed.nc

      # include arbitrary pp actions in postScriptPath, and use e.g. like this:
      if [ -f ${postPerFileScriptPath} ]
      then
        . ${postPerFileScriptPath} $aWrfOutFile $processedWrfOutFile
      else
        cp ${aWrfOutFile} ${processedWrfOutFile}
      fi

      # apply compression and save to archive, use input filename
      # k3 --> NetCDF-4 format
      # d9 --> max compression level
      # s  --> shuffling (can improve compression)
      nccopy -k3 -d1 -s $processedWrfOutFile ${archiveDir}/${aWrfOutFile}

      # set more relaxed permissions on output file
      chmod 0644 ${archiveDir}/${aWrfOutFile}

      # remove file from staging area
      rm $processedWrfOutFile
    fi
  done
  
  # copy track file
  trackFile=${stagingDir}/wrftrack_d${domain}___refYear__-__refMonth__-__refDay_____refHour__:00:00-__endYear__-__endMonth__-__endDay_____endHour__:00:00.nc
  if [ -e "$trackFile" ]
  then
    cp ${trackFile} ${archiveDir}
  fi

done

# remove the run directory
if __removeRunDir__
then
  cd ${runDir}
  tar cvzf ../${runDir%/}.tar.gz *_out *.out *.err
  cd ${stagingDir}
  rm -rf ${runDir}
fi



