#!/bin/bash -l
#SBATCH --partition=alcc1,alcc3,epyc
#SBATCH -o /alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/maps/%j.%N.out
#SBATCH -J maps
#SBATCH --ntasks=1
#SBATCH --mem=10G
#SBATCH --mail-type=FAIL
#SBATCH --mail-user=christoph.knote@med.uni-augsburg.de
#SBATCH --time=01:00:00

module load gnu geos ffmpeg

export MPLBACKEND="agg"

scriptPath=/alcc/gpfs2/home/u/knotechr/wrfotron/blueprints/operational_chemistry/pp/plotting/maps/run.py
wrfDataPathPattern="/alcc/gpfs2/scratch/mbees/knotechr/archive/WRF/operational_chemistry/wrfout_d{domain:02d}_%Y-%m-%d_%H:%M:%S"
tmpWorkDir="/alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/maps/movie"
plotPathPattern="${tmpWorkDir}/{plot:s}_d{domain:02d}_%Y%m%d%H.png"
webDir="/alcc/gpfs2/scratch/mbees/knotechr/plots/WRF/operational_chemistry/__domain__/maps/%Y/%m"
dateToProcess="today"
fcstIntervalHours=1
fcstRangeHours=72
nSecondsWait=2

mkdir -p ${tmpWorkDir}
rm -f ${tmpWorkDir}/*

python3 $scriptPath ${wrfDataPathPattern} $(date -u --date="${dateToProcess}" "+%Y-%m-%d") ${fcstIntervalHours} ${fcstRangeHours} ${plotPathPattern}

frameRate=3

for domain in d01 d02
do
  # get all plot type names ("500hpa_d01, o3_d02", ...)
  typs=$(ls -1 ${tmpWorkDir}/*${domain}*.png | sed -e "s|${tmpWorkDir}/||" | sed -E -e "s/_[0-9]+.png//g" | uniq)

  for typ in ${typs}
  do
    echo ""
    echo $typ $domain
    outFilePath=$(date --date="${dateToProcess} 0 UTC" "+${webDir/__domain__/${domain}}/${typ/_${domain}/}_%Y%m%d.mp4")
    mkdir -p $(dirname $outFilePath)
    rm -f ${outFilePath}
    # see here for why we need vf argument https://stackoverflow.com/questions/20847674/ffmpeg-libx264-height-not-divisible-by-2
    cat ${tmpWorkDir}/${typ}_*.png | ffmpeg -y -r ${frameRate} -f image2pipe -i - -vcodec libx264 -crf 18 -preset slow -pix_fmt yuv420p -vf "pad=ceil(iw/2)*2:ceil(ih/2)*2, tpad=stop_mode=clone:stop_duration=2, fps=fps=${frameRate}" ${outFilePath}
  done
done

rm -f ${tmpWorkDir}/*

