#!/bin/bash -l
#SBATCH --partition=alcc1
#SBATCH -o /alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/geotiffs.%j.%N.out
#SBATCH -J geotiffs
#SBATCH --ntasks=1
#SBATCH --mem=5G
#SBATCH --mail-type=FAIL
#SBATCH --mail-user=christoph.knote@med.uni-augsburg.de
#SBATCH --time=00:30:00

module load gnu gdal geos proj

scriptPath=/alcc/gpfs2/home/u/knotechr/wrfotron/tools/nc_2_geotiff.py
wrfDataPathPattern="/alcc/gpfs2/scratch/mbees/knotechr/archive/WRF/operational_chemistry/wrfout___domain___%Y-%m-%d_%H:%M:%S"
firstDateToProcess=`date --date="2 days ago" "+%Y-%m-%d"`
intervalHours=1
rangeHours=120
plotDirPattern="/alcc/gpfs2/scratch/mbees/knotechr/plots/WRF/operational_chemistry/__domain__/geotiffs/%Y/%m/%d"

for domain in d01 d02
do
  plotPathPattern="${plotDirPattern/__domain__/${domain}}/{species:s}_%Y-%m-%d_%H-%M.tif"

  for anHour in $(seq 0 ${intervalHours} ${rangeHours})
  do
    aWRFDataPath=$(date -u --date="${firstDateToProcess} 0 UTC +${anHour} hours" "+${wrfDataPathPattern/__domain__/${domain}}")

    aPlotDir=$(date -u --date="${firstDateToProcess} 0 UTC +${anHour} hours" "+${plotDirPattern/__domain__/${domain}}")
    aPlotPath=$(date -u --date="${firstDateToProcess} 0 UTC +${anHour} hours" "+${plotPathPattern}")

    if [ -f ${aWRFDataPath} ]
    then
      mkdir -p $aPlotDir
      python3 $scriptPath -s "o3,O3" -s "no2,NO2" -s "co,CO" -s "PM2_5_DRY,PM2.5" -s "PM10,PM10" "${aWRFDataPath}" "${aPlotPath}"
    fi
  done
done
