#!/bin/bash
# ------------------------------------------------------------------------------
# WRFOTRON v 2.0b
# Christoph Knote (LMU Munich, Germany)
# 06/2016
# christoph.knote@lmu.de
# ------------------------------------------------------------------------------

# path to the WRFotron installation
chainDir=${HOME}/wrfotron

# --- Executable locations ---

# WPS installation directory
WPSDir=${WPS_SRC_PATH}
# WRF installation directory
WRFDir=${WRF_SRC_PATH}

# --- Input data settings ---

# path to geogrid input data
geogDir=/alcc/gpfs2/home/mbees/data/geog/

# meteo input
# Vtable for the chosen meteo input
metVtableFile=${WPS_SRC_PATH}/ungrib/Variable_Tables/Vtable.GFS
# time increment in hours
metInc=1
# full path to a met input file - you can use any "%<>" abbreviations known
# to the "date" command
metFilePattern="/alcc/gpfs2/home/mbees/data/meteo/GFS_OPR/GF%Y%m%d%H"
# example:
# "/glade/p/rda/data/ds083.2/grib2/%Y/%Y.%m/fnl_%Y%m%d_%H_00.grib2"

# --- Pre/Postprocessing settings ---

# prepararation script
preScriptPath=NONEXISTENT.bash

# postprocessing scripts (arbitrary)
postScriptPath=NONEXISTENT.bash
# postprocessing scripts (actions for each wrfout file)
postPerFileScriptPath=NONEXISTENT.bash

# --- Working directories ---

# where the WRF will be run (some fast, large disk like "scratch" or similar)
workDir=${SCRATCH}/WRF/work/

# where the unprocessed WRF output will be stored
stagingRootDir=${SCRATCH}/WRF/staging/
# where the WRF output will be stored
archiveRootDir=${SCRATCH}/archive/WRF/
# where the WRF restart files will be stored
restartRootDir=${SCRATCH}/WRF/restart/

# remove run directory after run is finished?
removeRunDir=false

# --- Chemistry ---

withChemistry=true

# WRF-Chem installation directory
WRFChemDir=${WRF_CHEM_SRC_PATH}

# path to utility executables
meganBioEmissBin=megan_bio_emiss
mozbcBin=mozbc
weselyBin=wesely
exo_coldensBin=exo_coldens
anthro_emisBin=anthro_emis
fire_emisBin=fire_emis

# path to Wesely and Exo_Coldens input data
wesColdensDataPath=${WESELY_EXO_COLDENS_DATA}

# path to MEGAN input data
MEGANdir=/alcc/gpfs2/home/mbees/data/emissions/biogenic/MEGAN

# use anthro_emiss or predefined files?
emissUseAnthroEmiss=false
# raw emission input - the files you read in with anthro_emiss
emissDir=/alcc/gpfs2/home/mbees/data/emissions/anthropogenic/EDGARv5/MOZART_MOSAIC
# emission conversion script for anthro_emis - must match emissions in emissDir
emissInpFile=emis_edgarv5_mozmos.inp
# year the emissions are valid for (for offset calculation)
emissYear=2015

# FINN fires
fireFilePattern="/alcc/gpfs2/home/mbees/data/emissions/fires/FINN/GLOB_MOZ4_%Y%j.txt"
fireInpFile=finn_fires.inp

# boundary condition input
chembcFilePattern="/alcc/gpfs2/home/mbees/data/chembc/WACCM/WACCM%Y%m%d"
chembcInpFile=waccm.inp

# TUV photolysis option 4 data file
TUVDataPath="/alcc/gpfs2/home/mbees/data/tuv/TUV.phot.bz2"
