#!/bin/bash
# ------------------------------------------------------------------------------
# WRFOTRON v 2.0b
# Christoph Knote (LMU Munich, Germany)
# 06/2016
# christoph.knote@lmu.de
# ------------------------------------------------------------------------------

# path to the WRFotron installation
chainDir=${HOME}/wrfotron_dev

# --- Executable locations ---

# WPS installation directory
WPSDir=${WPS_SRC_PATH}
# WRF installation directory
WRFDir=${WRF_SRC_PATH}

# --- Input data settings ---

# path to geogrid input data
geogDir=${WRF_GEOG_PATH}

# meteo input
# Vtable for the chosen meteo input
metVtableFile=${WPS_SRC_PATH}/ungrib/Variable_Tables/Vtable.GFS
# time increment in hours
metInc=1
# full path to a met input file - you can use any "%<>" abbreviations known
# to the "date" command
metFilePattern="${WRF_GFS_METEO_PATH}/GF%Y%m%d%H"
# example:
# "/glade/p/rda/data/ds083.2/grib2/%Y/%Y.%m/fnl_%Y%m%d_%H_00.grib2"

# --- Pre/Postprocessing settings ---

# prepararation script
preScriptPath=NONEXISTENT.bash

# postprocessing scripts (arbitrary)
postScriptPath=NONEXISTENT.bash
# postprocessing scripts (actions for each wrfout file)
postPerFileScriptPath=NONEXISTENT.bash

# --- Working directories ---

# where the WRF will be run (some fast, large disk like "scratch" or similar)
workDir=${SCRATCH}/work/WRF/work/

# where the unprocessed WRF output will be stored
stagingRootDir=${SCRATCH}/work/WRF/staging/
# where the WRF output will be stored
archiveRootDir=${SCRATCH}/archive/WRF/
# where the WRF restart files will be stored
restartRootDir=${SCRATCH}/work/WRF/restart/

# remove run directory after run is finished?
removeRunDir=false

# --- MPI settings ---

# mental note for GNU:
#mpirun  -mca pml ucx -x UCX_TLS=rc,shm  -N $SLURM_NTASKS_PER_NODE -hostfile $MACHINEFILE 
mpiCommandPre="mpirun -mca pml ucx -x UCX_TLS=rc,shm -hostfile $MACHINEFILE"
mpiCommandMain="mpirun -mca pml ucx -x UCX_TLS=rc,shm -N $SLURM_NTASKS_PER_NODE -hostfile $MACHINEFILE"
mpiCommandReal=${mpiCommandPre}

# mental note for INTEL:
#mpiCommandPre="srun /usr/bin/time -v"
#mpiCommandMain="srun /usr/bin/time -v"
#mpiCommandReal="srun /usr/bin/time -v"

# --- Batch system ---

# argument to submit a job in a held state
batchHoldArgument="--hold"
# command to release a held job
batchReleaseCommand="scontrol release"
# command to submit jobs to the queueing system
batchSubmitCommand=sbatch
# dependency argument for chaining runs upon submission
batchDepArgument="--dependency=afterany:__id__"
# sed command ("used as s/__command/\1/") to retrieve job run PID upon
# submission with $batchSubmitCommand
batchPidSedCommand="Submitted batch job \(.*\)"

# --- Ndown settings ---

useNdown=false
ndownDomain=1
ndownTotalDomainCount=5

wrfOutInc=1 # wrf out increment in hours
wrfOutFilePattern="/alcc/gpfs2/scratch/mbees/knotechr/archive/WRF/nako_met_only___parentDomain__/wrfout_d01_%Y-%m-%d_%H:%M:%S"

# --- Chemistry ---

withChemistry=false
