#!/bin/bash -l
#SBATCH --partition=alcc1
#SBATCH -o /alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/meteograms.%j.%N.out
#SBATCH -J meteograms
#SBATCH --ntasks=1
#SBATCH --mem=10G
#SBATCH --mail-type=FAIL
#SBATCH --mail-user=christoph.knote@med.uni-augsburg.de
#SBATCH --time=00:30:00

module load gnu geos

export MPLBACKEND="agg"

scriptPath=/alcc/gpfs2/home/u/knotechr/wrfotron/blueprints/operational_chemistry/pp/plotting/meteograms/plot.py
wrfDataPathPattern="/alcc/gpfs2/scratch/mbees/knotechr/archive/WRF/operational_chemistry/wrfout_d{domain:02d}_%Y-%m-%d_%H:%M:%S"
firstDateToProcess=`date --date="2 days ago" "+%Y-%m-%d"`
lastDateToProcess=`date --date="3 days" "+%Y-%m-%d"`
intervalHours=1
domain=1
plotDir="/alcc/gpfs2/scratch/mbees/knotechr/plots/WRF/operational_chemistry/meteograms"
plotPathPattern="${plotDir}/{plot:s}_%Y%m%d%H.png"

mkdir -p $plotDir

python3 $scriptPath "$wrfDataPathPattern" "$firstDateToProcess" "$lastDateToProcess" "$intervalHours" "$domain" "$plotPathPattern"
