#!/bin/bash -l
#SBATCH --partition=alcc1
#SBATCH -o /alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/maps.%j.%N.out
#SBATCH -J maps
##SBATCH --nodelist=alcc131
#SBATCH --ntasks=1
#SBATCH --mem=5G
#SBATCH --mail-type=FAIL
#SBATCH --mail-user=christoph.knote@med.uni-augsburg.de
#SBATCH --time=00:30:00

module load gnu geos ffmpeg

export MPLBACKEND="agg"

scriptPath=/alcc/gpfs2/home/u/knotechr/wrfotron/blueprints/operational_chemistry/pp/plotting/maps/plot.py
wrfDataPathPattern="/alcc/gpfs2/scratch/mbees/knotechr/archive/WRF/operational_chemistry/wrfout_d{domain:02d}_%Y-%m-%d_%H:%M:%S"
tmpWorkDir="/alcc/gpfs2/scratch/mbees/knotechr/WRF/postprocessing/fcst_movie"
plotPathPattern="${tmpWorkDir}/{plot:s}_%Y%m%d%H.png"
webDir="/alcc/gpfs2/scratch/mbees/knotechr/plots/WRF/operational_chemistry/maps"
dateToProcess="today"
fcstIntervalHours=1
fcstRangeHours=72
nSecondsWait=2

mkdir -p ${tmpWorkDir}
rm -f ${tmpWorkDir}/*

python3 $scriptPath ${wrfDataPathPattern} $(date -u --date="${dateToProcess}" "+%Y-%m-%d") ${fcstIntervalHours} ${fcstRangeHours} ${plotPathPattern}

# once ffmpeg gets updated (to something > 2 Nov 2018), we can add still frames at the end with this -vf filter:
#tpad=stop_mode=clone:stop_duration=2

# see here for why we need vf argument https://stackoverflow.com/questions/20847674/ffmpeg-libx264-height-not-divisible-by-2
frameRate=3
# get all plot type names ("500hpa_Europe, o3_Europe", ...)
typs=$(ls -1 ${tmpWorkDir}/*.png | sed -e "s|${tmpWorkDir}/||" | sed -E -e "s/_[0-9]+.png//g" | uniq)
for typ in ${typs}
do
  # super ugly hack: copy last image seconds*framerate times to another name that ensures they are at the end (using big number as date here)
  # to make video "hold" on last image for 'seconds'
  allFiles=( $(ls -r1 ${tmpWorkDir}/${typ}_*.png) )
  lastFile=${allFiles[0]}
  for iter in $(seq 0 ${nSecondsWait})
  do
    for frm in $(seq 0 ${frameRate})
    do 
      let bignum='300000000000+iter*frm'
      cp ${lastFile} ${tmpWorkDir}/${typ}_${bignum}.png
    done
  done
  outFilePath=$(date --date="${dateToProcess} 0 UTC" "+${webDir}/%Y%m%d_${typ}.mp4")
  ffmpeg -y -r ${frameRate} -pattern_type glob  -i "${tmpWorkDir}/${typ}_*.png" -vcodec libx264 -crf 18 -preset slow -pix_fmt yuv420p -vf "pad=ceil(iw/2)*2:ceil(ih/2)*2" ${outFilePath} > /dev/null
done


for anHour in $(seq 0 ${fcstIntervalHours} ${fcstRangeHours})
do
  # get path to plots which we created in tmpdir
  plotPath=$(date -u --date="${dateToProcess} 0 UTC +${anHour} hours" "+${plotPathPattern}")
  # replace "type" placeholder with wildcard to match all
  allPlotPath=${plotPath/\{plot:s\}/\*}
  
  # where to put them on the web
  plotWebDir=$(date -u --date="${dateToProcess} 0 UTC +${anHour} hours" "+${webDir}/%Y/%m/%d")
  mkdir -p $plotWebDir
  
  mv ${allPlotPath} ${plotWebDir}
done
