#!/bin/bash
# ------------------------------------------------------------------------------
# WRFOTRON v 2.0b
# Christoph Knote (LMU Munich, Germany)
# 06/2016
# christoph.knote@lmu.de
# ------------------------------------------------------------------------------

# path to the WRFotron installation
chainDir=${HOME}/wrfotron

# --- Executable locations ---

# WPS installation directory
WPSDir=${WPS_SRC_PATH}
# WRF installation directory
WRFDir=${WRF_SRC_PATH}

# --- Input data settings ---

# path to geogrid input data
geogDir=${WRF_GEOG_PATH}

# meteo input
# Vtable for the chosen meteo input
metVtableFile=${WPS_SRC_PATH}/ungrib/Variable_Tables/Vtable.GFS
# time increment in hours
metInc=1
# full path to a met input file - you can use any "%<>" abbreviations known
# to the "date" command
metFilePattern="${WRF_GFS_METEO_PATH}/GF%Y%m%d%H"
# example:
# "/glade/p/rda/data/ds083.2/grib2/%Y/%Y.%m/fnl_%Y%m%d_%H_00.grib2"

# --- Pre/Postprocessing settings ---

# prepararation script
preScriptPath=NONEXISTENT.bash

# postprocessing scripts (arbitrary)
postScriptPath=NONEXISTENT.bash
# postprocessing scripts (actions for each wrfout file)
postPerFileScriptPath=NONEXISTENT.bash

# --- Working directories ---

# where the WRF will be run (some fast, large disk like "scratch" or similar)
workDir=${SCRATCH}/WRF/work/

# where the unprocessed WRF output will be stored
stagingRootDir=${SCRATCH}/WRF/staging/
# where the WRF output will be stored
archiveRootDir=${SCRATCH}/archive/WRF/
# where the WRF restart files will be stored
restartRootDir=${SCRATCH}/WRF/restart/

# remove run directory after run is finished?
removeRunDir=false

# --- MPI settings ---

# mental note for GNU:
#mpirun  -mca pml ucx -x UCX_TLS=rc,shm  -N $SLURM_NTASKS_PER_NODE -hostfile $MACHINEFILE 
mpiCommandPre="mpirun -mca pml ucx -x UCX_TLS=rc,shm -hostfile $MACHINEFILE /usr/bin/time -v"
mpiCommandMain="mpirun -mca pml ucx -x UCX_TLS=rc,shm -N $SLURM_NTASKS_PER_NODE -hostfile $MACHINEFILE /usr/bin/time -v"
mpiCommandReal=${mpiCommandPre}

# mental note for INTEL:
#mpiCommandPre="srun /usr/bin/time -v"
#mpiCommandMain="srun /usr/bin/time -v"
#mpiCommandReal="srun /usr/bin/time -v"

# --- Batch system ---

# argument to submit a job in a held state
batchHoldArgument="--hold"
# command to release a held job
batchReleaseCommand="scontrol release"
# command to submit jobs to the queueing system
batchSubmitCommand=sbatch
# dependency argument for chaining runs upon submission
batchDepArgument="--dependency=afterany:__id__"
# sed command ("used as s/__command/\1/") to retrieve job run PID upon
# submission with $batchSubmitCommand
batchPidSedCommand="Submitted batch job \(.*\)"

# --- Chemistry ---

withChemistry=true

# WRF-Chem installation directory
WRFChemDir=${WRF_CHEM_SRC_PATH}

# megan_bio_emiss installation directory
WRFMEGANdir=${WRF_CHEM_MEGAN_BIO_EMISS_PATH}
# mozbc installation directory
WRFMOZARTdir=${WRF_CHEM_MOZBC_PATH}
# wesley/exocoldens installation directory
WRFmztoolsdir=${WRF_CHEM_WES_COLDENS_PATH}
# anthro_emiss installation directory
WRFanthrodir=${WRF_CHEM_ANTHRO_EMIS_PATH}
# fire_emis installation directory
WRFfiredir=${WRF_CHEM_FIRE_EMIS_PATH}

# path to MEGAN input data
MEGANdir=/alcc/gpfs2/home/mbees/data/emissions/biogenic/MEGAN

# use anthro_emiss or predefined files?
emissUseAnthroEmiss=true
# raw emission input - the files you read in with anthro_emiss
emissDir=/alcc/gpfs2/home/mbees/data/emissions/anthropogenic/EDGAR-HTAP/MOZART_MOSAIC
# emission conversion script for anthro_emis - must match emissions in emissDir
emissInpFile=emis_edgarhtap_mozmos.inp
# year the emissions are valid for (for offset calculation)
emissYear=2010

# FINN fires
fireFilePattern="/alcc/gpfs2/home/mbees/data/emissions/fires/FINN/GLOB_MOZ4_%Y%j.txt"
fireInpFile=finn_fires.inp

# boundary condition input
chembcFilePattern="/alcc/gpfs2/home/mbees/data/chembc/WACCM/WACCM%Y%m%d"
chembcInpFile=waccm.inp

# TUV photolysis option 4 data file
TUVDataPath="/alcc/gpfs2/home/mbees/data/tuv/TUV.phot.bz2"
