#!/bin/bash
# ------------------------------------------------------------------------------
# WRFOTRON v 2.0b
# Christoph Knote (LMU Munich, Germany)
# 06/2016
# christoph.knote@lmu.de
# ------------------------------------------------------------------------------

# path to the WRFotron installation
chainDir=${HOME}/WRFotron

# --- Executable locations ---

# WPS installation directory
WPSDir=${WPS_SRC_PATH}
# WRF installation directory
WRFDir=${WRF_SRC_PATH}

# --- Input data settings ---

# path to geogrid input data
geogDir=${WRF_GEOG_PATH}

# meteo input
# Vtable for the chosen meteo input
metVtableFile=${chainDir}/blueprints/bbflux_ifs/Vtable_IFS
# time increment in hours
metInc=1
# full path to a met input file - you can use any "%<>" abbreviations known
# to the "date" command
metFilePattern="/project/meteo/data/wrf/meteo/IFS/BBFLUX_WRF/hourly/EN%Y%m%d_*_%H.grb"
# example:
# "/glade/p/rda/data/ds083.2/grib2/%Y/%Y.%m/fnl_%Y%m%d_%H_00.grib2"

# --- Pre/Postprocessing settings ---

# prepararation script
preScriptPath=NONEXISTENT.bash

# postprocessing scripts (arbitrary)
postScriptPath=NONEXISTENT.bash
# postprocessing scripts (actions for each wrfout file)
postPerFileScriptPath=NONEXISTENT.bash

# --- Working directories ---

# where the WRF will be run (some fast, large disk like "scratch" or similar)
workDir=${SCRATCH}/WRF/work/

# where the unprocessed WRF output will be stored
stagingRootDir=${SCRATCH}/WRF/staging/
# where the WRF output will be stored
archiveRootDir=${WORK}/WRF/
# where the WRF restart files will be stored
restartRootDir=${SCRATCH}/WRF/restart/

# remove run directory after run is finished?
removeRunDir=false

# --- MPI settings ---

mpiCommandPre=srun
mpiCommandMain=srun
mpiCommandReal=${mpiCommandMain}

# --- Batch system ---

# batch acronym for selecting the preamble scripts
# see batch.$batchSystem subdirectories in blueprints folder
batchSystem=slurm_mim
# argument to submit a job in a held state
batchHoldArgument="--hold"
# command to release a held job
batchReleaseCommand="scontrol release"
# command to submit jobs to the queueing system
batchSubmitCommand=sbatch
# dependency argument for chaining runs upon submission
batchDepArgument="--dependency=afterany:__id__"
# sed command ("used as s/__command/\1/") to retrieve job run PID upon
# submission with $batchSubmitCommand
batchPidSedCommand="Submitted batch job \(.*\)"
