#!/bin/bash -l
# ------------------------------------------------------------------------------
# WRFOTRON v 2.1
# Christoph Knote (MBEES, University Augsburg)
# 04/2022 v 2.1
# 09/2019 v 2.0
# 02/2016 v 1.0
# christoph.knote@med.uni-augsburg.de
# ------------------------------------------------------------------------------
#
# Batch script to execute multiple chained WRF-Chem simulations
# with meteo spinup and carried-on meteorology from 
# previous runs.
#

if [ $# -ne 11 ]
then
  echo "Call with arguments <experiment> <start year (YYYY)> <start month (MM)> <start day (DD)> <start hour (hh)> <end year (YYYY)> <end month (MM)> <end day (DD)> <end hour (hh)> <forecast time (h)> <spinup time (h)>"
  return 1
fi

experiment=$1

batchStartYear=$2
batchStartMonth=$3
batchStartDay=$4
batchStartHour=$5

batchEndYear=$6
batchEndMonth=$7
batchEndDay=$8
batchEndHour=$9

fcstTime=${10}
spinupTime=${11}

# ------

batchEndDate=$(date -u --date="${batchEndYear}-${batchEndMonth}-${batchEndDay} ${batchEndHour}:00:00" "+%s")
batchCurDate=$(date -u --date="${batchStartYear}-${batchStartMonth}-${batchStartDay} ${batchStartHour}:00:00" "+%s")

let nRuns="(batchEndDate-batchCurDate)/(fcstTime*3600)"

lastjobnr=""
i=1
while [ $batchCurDate -lt $batchEndDate ]
do
  curYear=$(date -u --date="1970-01-01 ${batchCurDate} sec GMT" "+%Y")
  curMonth=$(date -u --date="1970-01-01 ${batchCurDate} sec GMT" "+%m")
  curDay=$(date -u --date="1970-01-01 ${batchCurDate} sec GMT" "+%d")
  curHour=$(date -u --date="1970-01-01 ${batchCurDate} sec GMT" "+%H")

  echo "Batch run ${curYear}-${curMonth}-${curDay} ${curHour}:00:00 +${fcstTime} -${spinupTime} (run $i of $nRuns)"

  lastjobnr=$(. master.bash ${experiment} ${curYear} ${curMonth} ${curDay} ${curHour} ${fcstTime} ${spinupTime} ${lastjobnr})
  
  let batchCurDate="batchCurDate+fcstTime*3600"
  let i=i+1
done