# WRFotron

WRFotron is a bunch of shell scripts to automate WRF(-Chem) simulations (on a cluster with job scheduling system), including the necessary preprocessing steps. Special focus is set to be able to chain simulations, allowing to create free-running (i.e., no nuding) simulations for chemistry-aerosol-meteorology interactions over longer time periods.

## Contributing

We are looking forward to receiving your [new issue report](https://mbees.med.uni-augsburg.de/gitlab/mbees/wrfotron/-/issues/new).

If you'd like to contribute source code directly, please [create a fork](https://mbees.med.uni-augsburg.de/gitlab/mbees/wrfotron), make your changes and then [submit a merge request](https://mbees.med.uni-augsburg.de/gitlab/mbees/wrfotron/-/merge_requests/new) to the original project.

## License and acknowledgment

WRFotron is open source and available under the Gnu Public License (GPL) in version 3. In case WRFotron was used in scientific publications, please acknowledge as follows:

*We acknowledge the use of WRFotron created by the Chair of Model-Based Environmental Exposure Science at University Augsburg, Germany, to automatise WRF(-Chem) simulations.*

The existing model configurations under blueprints are tailored for various past and current projects, and we suggest you contact us before making simulations that are to be used in scientific publications.

## Prerequisites

* A working installation of WRF (and WRF-Chem, separately) v4.0 or greater
* A working installation of WPS v4.0 or greater
* Various preprocessing tools for WRF-Chem (e.g., mozbc, anthro_emis, megan, ...) as required
* All required input data (meteo, geog, emissions, ...)

## General naming conventions

Multiple (chained) simulations that serve a certain purpose, e.g. for a field campaign, are called an `experiment`. The
`experiment` name is the main identifier when working with WRFotron. The set of configuration options (namelist.wps, namelist.input, anthro_emis.inp, ...) for an `experiment` is called `blueprint`, and resides
in the subfolder `blueprints`/`experiment`.

## Main commands and scripts

`master.bash`: main script to start a simulation for an existing `experiment`.
`batch.bash`: main script to start a chain of simulations for an existing `experiment`. Basically calls `master.bash` multiple times.

These scripts can be called without arguments for help:

```
<me@mymachine>:. master.bash 

Call with arguments <experiment> <year (YYYY)> <month (MM)> <day (DD)> <hour (hh)> <forecast time (h)> <spinup time (h)>
                 or <experiment> <year (YYYY)> <month (MM)> <day (DD)> <hour (hh)> <forecast time (h)> <spinup time (h)> <PID of job dependency>

 * <experiment> can be a shortcut name (if experiment directory is found in subdirectory 'blueprints', 
                and you are calling it from the shell), or the absolute path to the experiment's settings directory.
 * <spinup time> needs to be a multiple of meteoInc.

 -d dry run, prepare only, do not submit or run
 -b do not use batch system, execute directly in shell
```

## General workflow

When calling master.bash, a simulation directory is prepared in `$workDir`. Four jobs are submitted to the job scheduler, each depending on the previous:

- `pre.bash`: run WPS (and everything to prepare the -Chem part), create wrfinput and wrfbdy (and other) files in `$workDir`
- `main.bash`: run WRF(-Chem)
- `staging.bash`: move WRF(-Chem) output into the staging location at `$stagingDir`, where it waits to be postprocessed
- `post.bash`: at minimum, move output from `$stagingDir` to `$archiveDir`, possibly apply postprocessing actions on the output

These four general phases may consist of several subjobs, which can be seen (and adapted) in the `jobs` subdirectory.

## Installation

1. Get WRFotron

  * go to the folder you want WRFotron to reside

  * clone the repository in there

    `git clone https://git.rz.uni-augsburg.de/knotechr/wrfotron.git`

  * subfolder `wrfotron` now contains your WRFotron installation

2. Set up a machine profile

  * create file with all commands to be executed prior to all runs, e.g. loading modules, setting ulimits, etc.:

    `machine_profiles/your_machine`

  * link to WRFotron root level as profile.bash

    `ln -s machine_profiles/your_machine profile.bash`

3. Experiment setup

  * create a new experiment folder in blueprints, following the existing blueprints as examples

    `cp -r blueprints/<chosen example> blueprints/<your experiment name>`

  * create an experiment config for your machine

    `cp -r blueprints/your_experiment/machine_specific/machine_example blueprints/your_experiment/machine_specific/your_machine`
    
  * adapt `config.bash` and the batch preambles in that folder to your environment

  * link to experiment folder

    `ln -s blueprints/<your experiment name>/machine_specific/<machine>/batch_preambles blueprints/<your experiment name>/`
    
    `ln -s blueprints/<your experiment name>/machine_specific/<machine>/config.bash blueprints/<your experiment name>/`

4. Test
  * make a run *(dates depend on the available data, obviously)*

    `. master.bash your_experiment 2001 01 01 00 24 06`
  
  * you should now have a run folder

    `${workDir}/your_experiment/2001-01-01_00:00:00-2001-01-02_00:00:00`

    ($workDir is set in the experiment config)
