import os
from setuptools import setup

def read(filename):
    with open(os.path.join(os.path.dirname(__file__), filename)) as f:
        return f.read()

setup(name='icartt',
      description='ICARTT format reader and writer',
      long_description=read('README.md') + '\n\n' + read('INSTALL.rst') + '\n\n' + read('CHANGES.rst'),
      long_description_content_type='text/markdown',
      version='1.9.1',
      url='https://mbees.med.uni-augsburg.de',
      author='Christoph Knote',
      author_email='christoph.knote@med.uni-augsburg.de',
      license='GPLv3',
      classifiers=[
            'Development Status :: 5 - Production/Stable',
            'Environment :: Console',
            'Intended Audience :: Developers',
            'Intended Audience :: Education',
            'Intended Audience :: End Users/Desktop',
            'Intended Audience :: Science/Research',
            'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
            'Operating System :: POSIX',
            'Programming Language :: Python :: 3',
            'Topic :: Education',
            'Topic :: Scientific/Engineering',
            'Topic :: Utilities'
        ],
      keywords='',
      packages=['icartt'],
      test_suite = 'tests',
      tests_require = [],
      zip_safe=False)
