import icartt
import datetime
import numpy as np

ict                                    = icartt.Dataset(format=icartt.Formats.FFI2110)

ict.PIName                             = 'Knote, Christoph'
ict.PIAffiliation                      = 'Faculty of Medicine, University Augsburg, Germany'
ict.dataSourceDescription              = 'Example data'
ict.missionName                        = 'MBEES'
ict.dateOfCollection                   = datetime.datetime.today()
ict.dateOfRevision                     = datetime.datetime.today()

ict.dataIntervalCode                   = [ 0 ]

ict.independentVariable                = icartt.Variable(  'Time_Start',
                                                            'seconds_from_0_hours_on_valid_date',
                                                            'Time_Start',
                                                            'Time_Start',
                                                            vartype=icartt.VariableType.IndependentVariable,
                                                            scale=1.0, miss=-9999999)

ict.independentBoundedVariable         = icartt.Variable(  'Altitude',
                                                            'altitude_above_ground_in_meters',
                                                            'Altitude',
                                                            'Altitude',
                                                            vartype=icartt.VariableType.IndependentBoundedVariable,
                                                            scale=1.0, miss=-9999999)

# ICARTT convention: first aux variable contains number of dependent elements
ict.auxiliaryVariables['nAltitudes']   = icartt.Variable(   'nAltitudes',
                                                            'number_of_dependent_variable_items',
                                                            'variable',
                                                            'nAltitudes',
                                                            scale=1.0, miss=-9999999)

ict.auxiliaryVariables['Time_Stop']    = icartt.Variable(   'Time_Stop',
                                                            'seconds_from_0_hours_on_valid_date',
                                                            'Time_Stop',
                                                            'Time_Stop',
                                                            scale=1.0, miss=-9999999)

ict.auxiliaryVariables['Longitude']    = icartt.Variable(   'Longitude',
                                                            'longitude_in_degrees',
                                                            'Longitude',
                                                            'Longitude',
                                                            scale=1.0, miss=-9999999)

ict.auxiliaryVariables['Latitude']    = icartt.Variable(   'Latitude',
                                                            'latitude_in_degrees',
                                                            'Latitude',
                                                            'Latitude',
                                                            scale=1.0, miss=-9999999)

ict.dependentVariables['Payload1']      = icartt.Variable( 'Payload1',
                                                            'some_units',
                                                            'Payload1',
                                                            'Payload1',
                                                            scale=1.0, miss=-9999999)

ict.dependentVariables['Payload2']      = icartt.Variable( 'Payload2',
                                                            'some_units',
                                                            'Payload2',
                                                            'Payload2',
                                                            scale=1.0, miss=-9999999)

ict.specialComments.append("Some comments on this dataset:")
ict.specialComments.append("They are just examples!")
ict.specialComments.append("Adapt as needed.")

ict.endDefineMode()

# Add data

# the three ways to add data (see FFI 1001) are still possible for FFI 2110

# a new independent variable item is created by adding data for the new item
# with its auxiliary data information:

ict.data.add( Time_Start = 12.3, nAuxiliary=4, Time_Stop = 12.5, Latitude = 48.21, Longitude = 10.3 )
ict.data.add( Time_Start = 13.3, nAuxiliary=2, Time_Stop = 13.5, Latitude = 48.31, Longitude = 10.4 )

# then, dependent data can be added:

#                   ibvar,  dvar1,  dvar2
data = np.array( [   (  0,    123,  8.4e4), 
                    (100,    122,  9.1e4),
                    (250,    115,  9.3e4),
                    (500,    106,  9.8e4) ] )

ict.data.addBulkDep(12.3, data)

#                   ibvar,  dvar1,  dvar2
data = np.array( [   (  0,    153,  7.3e4), 
                    (270,    172,  8.9e4) ] )

ict.data.addBulkDep(13.3, data)

# Now, look at it in ICARTT form:
ict.write()

# And you could simply write to file:
#with open('output.ict', 'w') as f:
#    ict.write(f=f)
