
import icartt
import datetime

ict                                    = icartt.Dataset(format=icartt.Formats.FFI1001)

ict.PIName                             = 'Knote, Christoph'
ict.PIAffiliation                      = 'Faculty of Medicine, University Augsburg, Germany'
ict.dataSourceDescription              = 'Example data'
ict.missionName                        = 'MBEES'
ict.dateOfCollection                   = datetime.datetime.today()
ict.dateOfRevision                     = datetime.datetime.today()

ict.dataIntervalCode                   = [ 0 ]

ict.independentVariable                = icartt.Variable(  'Time_Start',
                                                            'seconds_from_0_hours_on_valid_date',
                                                            'Time_Start',
                                                            'Time_Start',
                                                            vartype=icartt.VariableType.IndependentVariable,
                                                            scale=1.0, miss=-9999999)

ict.dependentVariables['Time_Stop']    = icartt.Variable(   'Time_Stop',
                                                            'seconds_from_0_hours_on_valid_date',
                                                            'Time_Stop',
                                                            'Time_Stop',
                                                            scale=1.0, miss=-9999999)

ict.dependentVariables['Payload']      = icartt.Variable(   'Payload',
                                                            'some_units',
                                                            'Payload',
                                                            'Payload',
                                                            scale=1.0, miss=-9999999)

ict.specialComments.append("Some comments on this dataset:")
ict.specialComments.append("They are just examples!")
ict.specialComments.append("Adapt as needed.")

ict.endDefineMode()

# Three ways to add data:

# 1) simple (single data line)
ict.data.add( Time_Start = 12.3, Time_Stop = 12.5, Payload = 23789423.2e5 )

# Let's check:
ict.write()

# 2) as dictionary (single data line)
mydict = { 'Time_Start': 12.6, 'Time_Stop': 13.1, 'Payload': 324235644.1e5 }
ict.data.add( **mydict )
# (note, exploding the dictionary is necessary)

# 3) as NumPy array (bulk)
import numpy as np
data = np.array( [ (13.4, 14.0, 2348925e5), (14.1, 14.9, 23425634e5) ] )
ict.data.addBulk( data )

# Note 1: you are responsible to ensure that the order of elements in a data line
# corresponds to variable listing below:
print( [ x for x in ict.variables ] )

# Note 2: for single lines, you still need to make it an array!
data = np.array( [ (15.4, 15.0, 52452495290e5) ] )
ict.data.addBulk( data )

# Now, look at it in ICARTT form:
ict.write()

# And you could simply write to file:
#with open('output.ict', 'w') as f:
#    ict.write(f=f)