import datetime

import icartt

# ------------------------------------------------------
# Phase 1: define file format, properties and variables
# ------------------------------------------------------

ict = icartt.Dataset(format=icartt.Formats.FFI1001)

ict.PIName = "Knote, Christoph"
ict.PIAffiliation = "Faculty of Medicine, University Augsburg, Germany"
ict.dataSourceDescription = "Example data"
ict.missionName = "MBEES"
ict.dateOfCollection = datetime.datetime.utcnow().timetuple()[:3]
ict.dateOfRevision = datetime.datetime.utcnow().timetuple()[:3]

ict.dataIntervalCode = [0]

ict.independentVariable = icartt.Variable(
    "Time_Start",
    "seconds_from_0_hours_on_valid_date",
    "Time_Start",
    "Time_Start",
    vartype=icartt.VariableType.IndependentVariable,
    scale=1.0,
    miss=-9999999,
)

ict.dependentVariables["Time_Stop"] = icartt.Variable(
    "Time_Stop",
    "seconds_from_0_hours_on_valid_date",
    "Time_Stop",
    "Time_Stop",
    scale=1.0,
    miss=-9999999,
)

ict.dependentVariables["Payload"] = icartt.Variable(
    "Payload", "some_units", "Payload", "Payload", scale=1.0, miss=-9999999
)

ict.specialComments.append("Some comments on this dataset:")
ict.specialComments.append("They are just examples!")
ict.specialComments.append("Adapt as needed.")

ict.normalComments.freeform.append("free comment line 1")
ict.normalComments.freeform.append("free comment line 2")

# ict.normalComments are all set to N/A if not specified

ict.endDefineMode()

# ------------------------------------------------------
# Phase 2: after ending define mode, add data
# ------------------------------------------------------

# all data are stored as NumPy arrays, and need to be provided as such.

import numpy as np

#                 ivar  dvar1 dvar2
data = np.array([(15.4, 15.0, 52452495290e5)])
ict.data.add(data)

# Note 1: you are responsible to ensure that the order of elements in a data line
# corresponds to variable listing below:
print([x for x in ict.variables])

# Note 2: evenfor single lines, you still need to make it an array!

# Note 3: multiple data lines can be added in bulk!
#                 ivar  dvar1 dvar2       ivar  dvar1 dvar2      ...
data = np.array([(13.4, 14.0, 2348925e5), (14.1, 14.9, 23425634e5)])

ict.data.add(data)

# Now, look at it in ICARTT form:
ict.write()

# And you could simply write to file:
# with open('output.ict', 'w') as f:
#    ict.write(f=f)
