#******************************************************************************
# BOXMOX heterogenous chemistry case
# Christoph Knote - 12/2017
#******************************************************************************

dat <- read.csv("HETCHEM.conc", header=TRUE, sep="")

speccols <- c(NO3="green", N2O5="yellow", HNO3="blue", NO2="red")

dat[names(dat) != "time"] <- dat[names(dat) != "time"] * 1e3
dat$time <- dat$time

png(file="het_chem.png", width=7, height=4, units="in", res=144)
par(mar=c(4,2.75,2.5,2.75), mgp=c(2,1,0))
plot(dat$time, dat$NO2, type="l", ylim=c(0, max(dat$NO2)), xlab="time (h)",
    ylab="", xaxs="i", yaxs="i", axes=FALSE, col=speccols["NO2"],
    main="Heterogeneous chemistry")
scaler <- 1
lines(dat$time, dat$NO3*scaler, col=speccols["NO3"])
lines(dat$time, dat$N2O5*scaler, col=speccols["N2O5"])
lines(dat$time, dat$HNO3*scaler, col=speccols["HNO3"])

legend("top", cex=0.8, legend=c(
        "NO2", "NO3", "N2O5","HNO3 (het.)"), lwd=1, lty=1,
    col=speccols[c("NO2", "NO3", "N2O5","HNO3")], bty="n",
    ncol=5, xpd=NA, inset=-0.0)

mtext(side=3, line=0.25, adj=-0.1, text=expression(ppbv))

axis(1, at=seq(0, max(dat$time), by=1))
axis(2, las=2)

dev.off()
