#******************************************************************************
# BOXMOX chamber experiment case
# Christoph Knote - 11/2015
#******************************************************************************

# plots results from the chamber experiment

dat <- read.csv("MOZART_4.conc", header=TRUE, sep="")

speccols <- c(OH="green", ISOPO2="yellow", ISOP="blue", ISOPOOH="red")

dat[names(dat) != "time"] <- dat[names(dat) != "time"] * 1e6
dat$time <- dat$time * 3600

png(file="chamber_experiment.png", width=7, height=4, units="in", res=144)
par(mar=c(4,2.75,2.5,2.75), mgp=c(2,1,0))
plot(dat$time, dat$ISOP, type="l", ylim=c(0, max(dat$ISOP)*2.0), xlab="time (s)",
    ylab="", xaxs="i", yaxs="i", axes=FALSE, col=speccols["ISOP"],
    main="Chamber experiment")
scaler <- 1000
lines(dat$time, dat$OH*scaler, col=speccols["OH"])
lines(dat$time, dat$ISOPO2*scaler, col=speccols["ISOPO2"])
lines(dat$time, dat$ISOPOOH*scaler, col=speccols["ISOPOOH"])

legend("top", cex=0.8, legend=c(
        "ISOP", "ISOPO2", "ISOPOOH","OH"), lwd=1, lty=1,
    col=speccols[c("ISOP", "ISOPO2", "ISOPOOH","OH")], bty="n",
    ncol=5, xpd=NA, inset=-0.0)

mtext(side=3, line=0.25, adj=-0.1, text=expression(isoprene~(pptv)))
mtext(side=3, line=0.25, adj=1.1,  text=expression(others~(ppqv)))

axis(1, at=seq(0, max(dat$time), by=600))
axis(2, las=2)
axis(4, at=axTicks(2), labels=axTicks(2)/scaler, las=2)

dev.off()
