#!/bin/sh
buildDir=$1

echo
echo " ---  pruning existing build dir ---"
echo

if [ ! -z "$buildDir" ]
then
  rm -rf $buildDir
fi

echo
echo " ---  prep Makefile.am ---"
echo

# (1) fancy shit: no wildcards in automake, add all files to be distributed with BOXMOX/KPP explicitly
cp Makefile.am_BLUEPRINT Makefile.am

# list all files in these subdirectories
distFiles=$(find boxmox drv examples case_studies int models util -type f)

#pretty print them                                        45 char wide    dd tab, backslash at end    remove backslash last line  remove tab first line
printf 'nobase_dist_pkgdata_DATA = %s\n' "${distFiles[*]}" | fmt -w 45 | sed -e 's/\(.*\)$/\t\1 \\/g' | sed '$ s/\\//g' | sed '1 s/\t//g' >> Makefile.am

echo 
echo " --- build documentation ---"
echo

cd boxmox
pdflatex UserManual
pdflatex UserManual
cp UserManual.pdf ../doc/boxmox_UserManual.pdf
cd ..

# now standard:

echo
echo " ---  aclocal ---"
echo
aclocal

echo
echo " ---  autoconf ---"
echo
autoconf

echo
echo " ---  automake ---"
echo
automake -a -c

echo
echo " ---  configure ---"
echo
./configure --prefix="${buildDir}"

echo
echo " ---  makec maintainer-clean ---"
echo
make maintainer-clean

echo
echo " ---  configure ---"
echo
./configure --prefix="${buildDir}"

echo
echo " ---  make ---"
echo
make

echo
echo " ---  make install ---"
echo
make install

echo
echo " ---  make dist ---"
echo
make dist

echo
echo " ---  make distcheck ---"
echo
make distcheck
