! ****************************************************************
!
! InitSaveData - Opens the data file for writing
!   Parameters :
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE KPP_ROOT_Parameters
!* ----------------------------------------------------
!* BOXMOX extension - Jerome Barre - 20150410
!*                    Christoph Knote - 20151030
!* add header to output species and sparse jacobian indices
!* and Hessian
      USE KPP_ROOT_JacobianSP
#if KPP_NHESS > 0
      USE KPP_ROOT_HessianSP
#endif
!* ----------------------------------------------------

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20140610
!* add header to output files and open rates file
      INTEGER     :: i
!* ----------------------------------------------------

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20161129
!* renamed concentration output
!      open(10, file='KPP_ROOT.dat')
      open(10, file='KPP_ROOT.conc')
!* ----------------------------------------------------

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20140610
!*                    Jerome Barre - 20150410
!*                    Christoph Knote - 20151030
!* add header to output files and open rates file

      ! add header to output file
      WRITE(10, "(A24,10000(1X,A24))") "time", ADJUSTR(SPC_NAMES(LOOKAT))

      open(11, file='KPP_ROOT.rates')

      WRITE(11, "(I5)") NREACT

      DO i = 1, NREACT
        WRITE(11, "(A)") EQN_NAMES(i)
      ENDDO

      ! add header to output file
      WRITE(11, "(A24,10000(1X,I24))") "time", (/(i, i=1,NREACT, 1)/)

!* write header to Jacobian output
      open(12, file='KPP_ROOT.jacobian')

!* species names
      WRITE(12, "(10000(1X,A24))") ADJUSTR(SPC_NAMES(LOOKAT))
!* species index
      WRITE(12, "(10000(1X,I5))") LOOKAT
!* Jacobian non zero row index
      WRITE(12, "(100000(1X,I5))") (LU_IROW(i), i=1,LU_NONZERO)
!* Jacobian non zero column index
      WRITE(12, "(100000(1X,I5))") (LU_ICOL(i), i=1,LU_NONZERO)

!* write header to Hessian output
#if KPP_NHESS > 0
      open(13, file='KPP_ROOT.hessian')

!* species names
      WRITE(13, "(10000(1X,A24))") ADJUSTR(SPC_NAMES(LOOKAT))
!* species index
      WRITE(13, "(10000(1X,I5))") LOOKAT
!* Hessian i, j, k species
      WRITE(13, "(100000(1X,I5))") (IHESS_I(i), i=1,NHESS)
      WRITE(13, "(100000(1X,I5))") (IHESS_J(i), i=1,NHESS)
      WRITE(13, "(100000(1X,I5))") (IHESS_K(i), i=1,NHESS)
#endif
!* ----------------------------------------------------

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!
! SaveData - Write LOOKAT species in the data file
!   Parameters :
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE KPP_ROOT_Global
      USE KPP_ROOT_Monitor
!* ----------------------------------------------------
!* BOXMOX extension - Jerome Barre - 20150410
!*                    Christoph Knote - 20151030
      USE KPP_ROOT_Jacobian
#if KPP_NHESS > 0
      USE KPP_ROOT_Hessian
#endif
!* ----------------------------------------------------

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20151030
      REAL(KIND=dp)      :: JVS(LU_NONZERO)           ! d(dc/dt)i/dcj
#if KPP_NHESS > 0
      REAL(KIND=dp)      :: HESS(NHESS)               !
#endif
      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20140610
!*                    Jerome Barre - 20150410
!*                    Christoph Knote - 20151030
!* write out reaction rates
      WRITE(11,999) (TIME-TSTART)/3600.D0,  &
                   (RCONST(i), i=1,NREACT)
!* call Jacobian function to output Jacobian values
      CALL Jac_SP( VAR, FIX, RCONST, JVS )
      WRITE(12,9999) (JVS(i), i=1,LU_NONZERO)
!* call Hessian function to output Hessian values
#if KPP_NHESS > 0
      CALL Hessian( VAR, FIX, RCONST, HESS )
      WRITE(13,9999) (HESS(i), i=1,NHESS)
#endif
!* ---------------------------------------------------

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20140610
!* might have more than 100 output variables
! 999   FORMAT(E24.16,100(1X,E24.16))
999    FORMAT(E24.16,10000(1X,E24.16E3))
9999   FORMAT(E24.16,100000(1X,E24.16E3))
!* ----------------------------------------------------

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!
! CloseSaveData - Close the data file
!   Parameters :
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE KPP_ROOT_Parameters

      CLOSE(10)

!* ----------------------------------------------------
!* BOXMOX extension - Christoph Knote - 20140610
!*                    Jerome Barre - 20150410
!                     Christoph Knote - 20153010
!* close rates file
      CLOSE(11)
!* close Jacobian file
      CLOSE(12)
!* close Hessian file
#if KPP_NHESS > 0
      CLOSE(13)
#endif
!* ---------------------------------------------------

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!
! GenerateMatlab - Generates MATLAB file to load the data file
!   Parameters :
!                It will have a character string to prefix each
!                species name with.
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE KPP_ROOT_Parameters
      USE KPP_ROOT_Global
      USE KPP_ROOT_Monitor


      CHARACTER(LEN=8) PREFIX
      INTEGER i

      open(20, file='KPP_ROOT.m')
      write(20,*) 'load KPP_ROOT.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = KPP_ROOT;')
      write(20,*) 'clear KPP_ROOT;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do

      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


