#******************************************************************************
# BOXMOX flow over urban area case
# Christoph Knote - 11/2015
#******************************************************************************

# plots results from the urban plume simulation

dat <- read.csv("MOZART_4.conc", header=TRUE, sep="")
emi <- read.csv("Emissions.csv", header=TRUE, sep="", skip=3)

speccols <- c(O3="black", NOx="red", CH2O="green", HNO3="blue", H2O2="yellow")

dat[names(dat) != "time"] <- dat[names(dat) != "time"] * 1e3

png(file="urban_plume.png", width=7, height=4, units="in", res=144)
par(mar=c(4,2.75,2.5,2.75), mgp=c(2,1,0))
plot(dat$time, dat$O3, type="l", ylim=c(0, max(dat$O3)*1.25), xlab="time (h)",
    ylab="", xaxs="i", yaxs="i", axes=FALSE, col=speccols["O3"],
    main="Urban plume")
nox <- dat$NO + dat$NO2
lines(dat$time, nox*10, col=speccols["NOx"])
lines(dat$time, dat$CH2O*10, col=speccols["CH2O"])
lines(dat$time, dat$H2O2*10, col=speccols["H2O2"])
lines(dat$time, dat$HNO3*10, col=speccols["HNO3"])

lines(emi$times/3600, emi$NO/max(emi$NO)*0.75*par("usr")[4], col="grey", lty=2)
legend("top", cex=0.8, legend=c(
        expression(c(O[3])),
        expression(c(NO[x])),
        expression(c(CH[2]*O)),
        expression(c(H[2]*O[2])),
        expression(c(HNO[3])),
        expression(NO[x]~emissions)), lty=c(1,1,1,1,1,2),
    col=c(speccols[c("O3", "NOx", "CH2O", "H2O2", "HNO3")], "grey"), bty="n",
    ncol=3, xpd=NA)

mtext(side=3, line=0.25, adj=-0.1, text=expression(O[3]~(ppbv)))
mtext(side=3, line=0.25, adj=1.1,  text=expression(others~(ppbv)))

axis(1, at=seq(0, max(dat$time), by=6))
axis(2, las=2)
axis(4, at=axTicks(2), labels=axTicks(2)/10, las=2)

dev.off()
