# BOXMOX

**Box modeling extensions to KPP**

Documentation, user downloads, online tools and further information can be found [here](https://mbees.med.uni-augsburg.de/boxmodeling/).

This is the development repository.

## Latest distributable archive

The most current BOXMOX distribution .tar.gz is automatically built upon commit and can be downloaded using the link above, right ("latest-dist").

## Contributing

We are looking forward to receiving your [new issue report](https://mbees.med.uni-augsburg.de/gitlab/mbees/boxmox/-/issues/new).

If you'd like to contribute source code directly, please [create a fork](https://mbees.med.uni-augsburg.de/gitlab/mbees/boxmox), make your changes and then [submit a merge request](https://mbees.med.uni-augsburg.de/gitlab/mbees/boxmox/-/merge_requests/new) to the original project.

## Citation

Please cite our work when BOXMOX use constituted a relevant contribution to your scientific work. The citation for BOXMOX is [Knote et al., Atm. Env., 2015](http://dx.doi.org/10.1016/j.atmosenv.2014.11.066).

## Where does BOXMOX extend KPP?

`drv/boxmox.f90`/ `drv/boxmox_adjoint.f90`

KPP (adjoint) driver for BOXMOX.

`drv/wrapper`

This is where all BOXMOX extension code lives.

`case_studies/`

Test cases for BOXMOX usage.

`doc/boxmox_README.tex`

BOXMOX documentation.

`models/`

Additional chemistry mechanisms included with BOXMOX.

`scripts/`

Command-line scripts to drive BOXMOX.

`util/UserRateLaws_BOXMOX.f90`

Rate constant equations for BOXMOX.

## License statement

BOXMOX is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BOXMOX is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

## Contact

[Christoph Knote](mailto:christoph.knote@med.uni-augsburg.de), [MBEES, Faculty of Medicine, University of Augsburg](https://mbees.med.uni-augsburg.de), Germany

