! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : SAPRC99_StoichiomSP.f90
! Time                 : Thu Oct  8 08:22:39 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_SAPRC99_30885_BOXMOX
! Equation file        : SAPRC99.kpp
! Output root filename : SAPRC99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE SAPRC99_StoichiomSP

  USE SAPRC99_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(226) :: CROW_JVRP = (/ &
       1,  2,  3,  5,  7,  9, 11, 13, 15, 17, 18, 20, &
      21, 22, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, &
      36, 38, 40, 42, 43, 45, 47, 49, 51, 52, 53, 55, &
      57, 58, 59, 61, 62, 63, 65, 67, 69, 70, 72, 74, &
      76, 77, 78, 80, 82, 84, 86, 87, 89, 91, 93, 95, &
      97, 98,100,102,104,106,108,110,111,113,114,116, &
     118,120,122,124,126,128,129,131,132,134,136,138, &
     140,142,144,146,148,149,151,152,154,156,158,160, &
     162,164,166,168,170,171,173,174,176,178,180,182, &
     184,186,188,190,192,194,195,197,198,200,202,203, &
     205,207,208,209,210,212,214,215,217,219,221,222, &
     224,226,227,229,231,232,234,235,237,239,241,242, &
     244,245,246,247,249,251,252,254,256,257,259,261, &
     263,265,267,269,270,272,274,276,278,280,281,283, &
     285,287,288,290,292,294,295,297,298,300,301,303, &
     305,307,308,310,311,313,315,317,319,321,323,325, &
     327,329,331,333,335,337,339,341,343,345,347,349, &
     351,353,355,357,359,361,363,365,367,369,371,373, &
     375,377,379,380,381,382,383,384,385,386 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_JVRP_0 = (/ &
      74, 63, 63, 67, 63, 73, 63, 74, 63, 74, 67, 73, &
      67, 74, 73, 75, 73, 74, 75, 22, 22, 74, 75, 75, &
      75, 67, 67, 11, 11, 71, 73, 23, 23, 23, 71, 71, &
      74, 71, 75, 47, 71, 47, 45, 71, 67, 71, 73, 78, &
      74, 78, 32, 32, 32, 71, 67, 78, 78, 78, 75, 78, &
      75, 19, 19, 71, 71, 78, 10, 71, 71, 73, 76, 76, &
      78, 75, 76, 76, 76, 73, 77, 77, 78, 75, 77, 76, &
      77, 77, 53, 73, 53, 78, 53, 75, 53, 76, 53, 77, &
      53, 69, 73, 69, 78, 69, 76, 69, 75, 69, 77, 53, &
      69, 69, 68, 74, 15, 68, 73, 68, 78, 68, 75, 68, &
      76, 68, 77, 53, 68, 68, 69, 68, 72, 74, 16, 72, &
      73, 72, 78, 72, 75, 72, 76, 72, 77, 53, 72, 69, &
      72, 68, 72, 72, 74, 79, 17, 73, 79, 78, 79, 75, &
      79, 76, 79, 77, 79, 53, 79, 69, 79, 68, 79, 72, &
      79, 79, 70, 74, 18, 70, 73, 70, 78, 70, 75, 70, &
      76, 70, 77, 53, 70, 69, 70, 68, 70, 70, 72, 70, &
      79, 70, 25, 74, 25, 51, 74, 51, 78, 51, 31, 74, &
      31, 78, 31, 61, 61, 61, 71, 61, 78, 30, 30, 73, &
      61, 75, 60, 71, 60, 60, 75, 64, 71, 64, 64, 75, &
      46, 71, 46, 65, 71, 65, 28, 71, 21, 71, 29, 71, &
      29, 42, 71, 42, 49, 49, 49, 71, 49, 75, 44, 44, &
      71, 44, 75, 14, 43, 71, 43, 75, 37, 71, 37, 75, &
      40, 75, 41, 71, 41, 41, 75, 55, 71, 55, 67, 55, &
      75, 55, 63, 55, 59, 71, 59, 67, 59, 63, 59, 57, &
      71, 57, 67, 57, 75, 57, 66, 71, 66, 62, 71, 62, &
      38, 71, 38, 67, 35, 71, 35, 36, 71, 36, 12, 71, &
      48, 71, 48, 67, 48, 75, 48, 63, 52, 71, 52, 67, &
      52, 75, 52, 63, 54, 71, 54, 67, 54, 75, 54, 63, &
      13, 71, 20, 71, 39, 71, 24, 71, 33, 71, 26, 71, &
      34, 71, 27, 71, 56, 71, 56, 67, 56, 75, 56, 63 /)
  INTEGER, PARAMETER, DIMENSION(25) :: ICOL_JVRP_1 = (/ &
      58, 71, 58, 67, 58, 75, 58, 63, 39, 67, 50, 71, &
      50, 67, 50, 75, 50, 63, 10, 78, 10,  1, 47, 19, &
       2 /)
  INTEGER, PARAMETER, DIMENSION(385) :: ICOL_JVRP = (/&
    ICOL_JVRP_0, ICOL_JVRP_1 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_JVRP_0 = (/ &
       1,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, &
       8,  8,  9,  9, 10, 11, 11, 12, 13, 14, 14, 15, &
      16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 24, 25, &
      25, 26, 26, 27, 27, 28, 29, 29, 30, 30, 31, 31, &
      32, 32, 33, 34, 35, 35, 36, 36, 37, 38, 39, 39, &
      40, 41, 42, 42, 43, 43, 44, 44, 45, 46, 46, 47, &
      47, 48, 48, 49, 50, 51, 51, 52, 52, 53, 53, 54, &
      54, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, &
      61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67, &
      67, 68, 69, 69, 70, 71, 71, 72, 72, 73, 73, 74, &
      74, 75, 75, 76, 76, 77, 77, 78, 79, 79, 80, 81, &
      81, 82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87, &
      87, 88, 88, 89, 90, 90, 91, 92, 92, 93, 93, 94, &
      94, 95, 95, 96, 96, 97, 97, 98, 98, 99, 99,100, &
     100,101,102,102,103,104,104,105,105,106,106,107, &
     107,108,108,109,109,110,110,111,111,112,112,113, &
     113,114,115,115,116,117,117,118,118,119,120,120, &
     121,121,122,123,124,125,125,126,126,127,128,128, &
     129,129,130,130,131,132,132,133,133,134,135,135, &
     136,136,137,138,138,139,140,140,141,141,142,142, &
     143,144,144,145,146,147,148,148,149,149,150,151, &
     151,152,152,153,154,154,155,155,156,156,157,157, &
     158,158,159,159,160,161,161,162,162,163,163,164, &
     164,165,165,166,167,167,168,168,169,169,170,171, &
     171,172,172,173,173,174,175,175,176,177,177,178, &
     179,179,180,180,181,181,182,183,183,184,185,185, &
     186,186,187,187,188,188,189,189,190,190,191,191, &
     192,192,193,193,194,194,195,195,196,196,197,197, &
     198,198,199,199,200,200,201,201,202,202,203,203, &
     204,204,205,205,206,206,207,207,208,208,209,209 /)
  INTEGER, PARAMETER, DIMENSION(25) :: IROW_JVRP_1 = (/ &
     210,210,211,211,212,212,213,213,214,214,215,215, &
     216,216,217,217,218,218,219,220,221,222,223,224, &
     225 /)
  INTEGER, PARAMETER, DIMENSION(385) :: IROW_JVRP = (/&
    IROW_JVRP_0, IROW_JVRP_1 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(226) :: CCOL_STOICM = (/ &
       1,  4,  6,  8, 11, 14, 17, 20, 23, 26, 28, 31, &
      34, 36, 38, 40, 43, 45, 47, 49, 51, 54, 57, 60, &
      63, 66, 70, 73, 76, 79, 82, 86, 89, 92, 97,100, &
     103,105,107,112,114,116,119,121,125,127,132,135, &
     140,143,146,150,153,157,162,164,167,168,171,172, &
     173,173,176,179,186,191,196,197,201,204,207,211, &
     216,220,224,227,228,232,234,237,240,245,250,255, &
     259,262,263,267,272,275,278,281,286,291,296,300, &
     303,304,308,313,319,322,325,328,333,338,343,347, &
     350,351,354,357,363,369,372,375,378,381,384,386, &
     390,393,395,398,400,404,407,410,415,420,423,427, &
     431,438,443,447,452,455,465,469,473,479,483,487, &
     491,495,498,501,506,512,516,520,525,527,532,536, &
     541,545,549,552,554,558,566,576,582,585,593,602, &
     612,616,621,634,648,659,667,678,687,700,712,717, &
     723,728,736,741,749,752,757,764,768,777,786,800, &
     807,815,823,841,849,853,857,863,871,882,896,907, &
     921,934,944,960,969,974,987,1010,1025,1035,1041,1048, &
     1060,1066,1071,1073,1074,1075,1076,1077,1078,1079 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      63, 73, 74, 63, 67, 63, 67, 63, 73, 74, 63, 73, &
      74, 63, 74, 75, 67, 73, 74, 67, 74, 75, 73, 74, &
      75, 73, 74, 22, 74, 75, 22, 74, 75, 22, 47, 73, &
      75, 73, 75, 63, 74, 75, 63, 67, 11, 67, 11, 71, &
      11, 63, 23, 71, 73, 23, 71, 73, 23, 74, 78, 23, &
      71, 74, 47, 71, 74, 71, 74, 75, 78, 47, 71, 75, &
      47, 71, 74, 45, 71, 78, 67, 71, 78, 71, 73, 74, &
      78, 32, 74, 78, 32, 74, 78, 32, 71, 74, 75, 78, &
      32, 71, 74, 67, 71, 78, 19, 78, 19, 78, 47, 71, &
      74, 75, 78, 74, 75, 19, 71, 19, 71, 78, 71, 78, &
       1, 10, 71, 78, 71, 78, 61, 73, 74, 76, 78, 29, &
      76, 78, 61, 74, 75, 76, 78, 28, 61, 76, 61, 76, &
      78, 73, 74, 77, 78, 42, 77, 78, 74, 75, 77, 78, &
      28, 61, 76, 77, 78, 77, 78, 53, 73, 74, 53, 53, &
      74, 75, 53, 53, 62, 69, 73, 42, 69, 78, 28, 61, &
      65, 66, 69, 76, 78, 65, 69, 74, 75, 78, 65, 66, &
      69, 77, 78, 53, 65, 66, 69, 78, 15, 68, 74, 15, &
      68, 74, 68, 73, 74, 76,  4,  6, 67, 68, 78, 68, &
      74, 75, 76,  4, 61, 68, 76,  4, 68, 77, 53,  4, &
      66, 68, 69, 68, 76, 16, 72, 74, 16, 72, 74, 60, &
      72, 73, 74, 77,  5,  7, 67, 72, 78, 60, 72, 74, &
      75, 77,  5, 61, 72, 76,  5, 72, 77, 53,  5, 66, &
      69, 72, 60, 68, 72, 76, 77, 60, 72, 77, 17, 74, &
      79, 17, 74, 79, 51, 53, 73, 74, 79,  5,  7, 67, &
      78, 79, 51, 53, 74, 75, 79,  5, 61, 76, 79,  5, &
      77, 79, 53,  5, 66, 69, 79, 51, 53, 68, 76, 79, &
      51, 53, 60, 72, 77, 79, 51, 53, 79, 18, 70, 74, &
      18, 70, 74, 61, 68, 70, 73, 74,  5,  7, 67, 70, &
      78, 61, 68, 70, 74, 75,  5, 61, 70, 76,  5, 70, &
      77, 53,  5, 69, 70, 61, 70, 76, 60, 61, 68, 70 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      72, 77, 51, 53, 61, 68, 70, 79, 61, 68, 70, 25, &
      62, 74, 25, 46, 76, 40, 51, 74, 43, 51, 78, 43, &
      51,  8,  9, 31, 74, 31, 40, 78, 31, 40, 45, 61, &
      78, 45, 61, 45, 61, 71, 78, 30, 61, 78, 30, 61, &
      78,  3, 30, 73, 74, 78, 45, 47, 61, 75, 78, 60, &
      68, 71, 45, 60, 76, 78, 47, 60, 68, 75, 45, 60, &
      64, 69, 71, 72, 77, 45, 60, 64, 77, 78, 47, 64, &
      72, 75, 46, 53, 61, 68, 71, 46, 68, 76, 53, 60, &
      61, 64, 65, 68, 69, 71, 72, 77, 60, 65, 68, 77, &
      28, 61, 71, 78, 21, 60, 61, 71, 77, 78, 29, 61, &
      71, 76, 29, 61, 71, 78, 42, 64, 71, 77, 42, 64, &
      71, 78, 45, 49, 78, 45, 49, 61, 45, 49, 71, 72, &
      78, 45, 47, 49, 72, 75, 78, 44, 45, 68, 78, 44, &
      45, 68, 71, 44, 45, 47, 68, 75, 14, 68, 43, 49, &
      51, 71, 77, 43, 47, 51, 75, 37, 44, 51, 71, 77, &
      37, 47, 51, 75, 31, 40, 47, 75, 41, 71, 79,  9, &
      41, 41, 47, 75, 79, 44, 45, 55, 61, 65, 70, 71, &
      77,  3, 44, 45, 55, 61, 67, 71, 72, 77, 78, 45, &
      47, 55, 70, 75, 77, 55, 63, 64, 45, 55, 61, 68, &
      70, 71, 77, 78, 44, 53, 59, 61, 64, 68, 69, 71, &
      77,  3, 44, 45, 59, 61, 67, 71, 72, 77, 78, 59, &
      63, 64, 65, 45, 59, 66, 70, 76, 44, 45, 49, 57, &
      60, 61, 64, 65, 66, 69, 70, 71, 77,  3,  5, 44, &
      45, 49, 57, 60, 61, 65, 67, 71, 72, 77, 78, 44, &
      45, 47, 57, 61, 62, 64, 69, 70, 75, 77, 45, 57, &
      60, 61, 65, 68, 72, 78, 60, 61, 64, 65, 66, 68, &
      69, 71, 72, 77, 78, 53, 60, 61, 64, 66, 68, 69, &
      72, 77, 46, 53, 60, 61, 62, 64, 65, 66, 69, 71, &
      74, 77, 78, 46, 53, 60, 61, 62, 64, 65, 66, 69, &
      74, 77, 78, 38, 45, 64, 71, 77, 38, 45, 49, 67 /)
  INTEGER, PARAMETER, DIMENSION(358) :: IROW_STOICM_2 = (/ &
      71, 78, 35, 53, 64, 68, 71, 35, 44, 45, 49, 53, &
      68, 77, 78, 36, 53, 64, 68, 71, 36, 44, 45, 49, &
      53, 68, 77, 78, 12, 71, 76, 48, 60, 61, 71, 77, &
       3, 45, 48, 61, 67, 71, 78, 48, 64, 75, 77, 45, &
      48, 49, 60, 61, 63, 76, 77, 78, 52, 53, 55, 57, &
      59, 61, 69, 71, 77,  3,  5, 45, 52, 53, 55, 59, &
      61, 66, 67, 69, 70, 71, 77, 52, 53, 57, 69, 74, &
      75, 77, 52, 53, 61, 63, 66, 69, 70, 76, 53, 54, &
      61, 64, 66, 69, 71, 77,  3,  5, 14, 45, 46, 49, &
      53, 54, 61, 64, 66, 67, 68, 69, 71, 72, 77, 78, &
      53, 54, 62, 64, 69, 74, 75, 77, 54, 63, 64, 66, &
      13, 60, 71, 77, 20, 46, 64, 69, 71, 77,  3, 39, &
      45, 49, 61, 71, 77, 78, 24, 25, 46, 53, 60, 61, &
      64, 65, 69, 71, 77, 33, 45, 46, 53, 60, 61, 64, &
      65, 66, 68, 69, 71, 76, 77, 26, 46, 53, 60, 61, &
      64, 65, 66, 69, 71, 77, 34, 35, 36, 37, 38, 41, &
      43, 44, 49, 66, 69, 71, 77, 78, 14, 27, 35, 36, &
      37, 38, 41, 44, 49, 69, 71, 77, 78, 46, 53, 56, &
      60, 61, 64, 66, 69, 71, 77,  3,  4,  5, 45, 46, &
      56, 60, 61, 64, 66, 67, 69, 71, 76, 77, 78, 46, &
      53, 56, 60, 62, 64, 69, 75, 77, 56, 63, 64, 65, &
      66, 41, 46, 53, 55, 57, 58, 60, 61, 64, 65, 69, &
      71, 77,  3,  4,  5, 41, 45, 46, 53, 55, 58, 59, &
      60, 61, 64, 65, 66, 67, 68, 69, 71, 72, 76, 77, &
      78, 41, 46, 53, 58, 59, 60, 61, 62, 64, 65, 69, &
      74, 75, 76, 77, 45, 55, 58, 63, 64, 65, 66, 69, &
      77, 78,  2, 39, 45, 67, 71, 78,  9, 50, 60, 61, &
      69, 71, 77,  2,  3,  4,  9, 45, 50, 60, 61, 67, &
      71, 76, 78,  8,  9, 50, 69, 75, 77,  9, 50, 63, &
      64, 65,  1, 10, 78, 10,  1, 47, 19,  2 /)
  INTEGER, PARAMETER, DIMENSION(1078) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  4,  4,  4,  5,  5, &
       5,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,  9, &
       9, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 14, &
      14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, &
      20, 20, 21, 21, 21, 22, 22, 22, 23, 23, 23, 24, &
      24, 24, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, &
      28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, &
      31, 32, 32, 32, 33, 33, 33, 34, 34, 34, 34, 34, &
      35, 35, 35, 36, 36, 36, 37, 37, 38, 38, 39, 39, &
      39, 39, 39, 40, 40, 41, 41, 42, 42, 42, 43, 43, &
      44, 44, 44, 44, 45, 45, 46, 46, 46, 46, 46, 47, &
      47, 47, 48, 48, 48, 48, 48, 49, 49, 49, 50, 50, &
      50, 51, 51, 51, 51, 52, 52, 52, 53, 53, 53, 53, &
      54, 54, 54, 54, 54, 55, 55, 56, 56, 56, 57, 58, &
      58, 58, 59, 60, 62, 62, 62, 63, 63, 63, 64, 64, &
      64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 66, 66, &
      66, 66, 66, 67, 68, 68, 68, 68, 69, 69, 69, 70, &
      70, 70, 71, 71, 71, 71, 72, 72, 72, 72, 72, 73, &
      73, 73, 73, 74, 74, 74, 74, 75, 75, 75, 76, 77, &
      77, 77, 77, 78, 78, 79, 79, 79, 80, 80, 80, 81, &
      81, 81, 81, 81, 82, 82, 82, 82, 82, 83, 83, 83, &
      83, 83, 84, 84, 84, 84, 85, 85, 85, 86, 87, 87, &
      87, 87, 88, 88, 88, 88, 88, 89, 89, 89, 90, 90, &
      90, 91, 91, 91, 92, 92, 92, 92, 92, 93, 93, 93, &
      93, 93, 94, 94, 94, 94, 94, 95, 95, 95, 95, 96, &
      96, 96, 97, 98, 98, 98, 98, 99, 99, 99, 99, 99, &
     100,100,100,100,100,100,101,101,101,102,102,102, &
     103,103,103,104,104,104,104,104,105,105,105,105, &
     105,106,106,106,106,106,107,107,107,107,108,108, &
     108,109,110,110,110,111,111,111,112,112,112,112 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
     112,112,113,113,113,113,113,113,114,114,114,115, &
     115,115,116,116,116,117,117,117,118,118,118,119, &
     119,120,120,120,120,121,121,121,122,122,123,123, &
     123,124,124,125,125,125,125,126,126,126,127,127, &
     127,128,128,128,128,128,129,129,129,129,129,130, &
     130,130,131,131,131,131,132,132,132,132,133,133, &
     133,133,133,133,133,134,134,134,134,134,135,135, &
     135,135,136,136,136,136,136,137,137,137,138,138, &
     138,138,138,138,138,138,138,138,139,139,139,139, &
     140,140,140,140,141,141,141,141,141,141,142,142, &
     142,142,143,143,143,143,144,144,144,144,145,145, &
     145,145,146,146,146,147,147,147,148,148,148,148, &
     148,149,149,149,149,149,149,150,150,150,150,151, &
     151,151,151,152,152,152,152,152,153,153,154,154, &
     154,154,154,155,155,155,155,156,156,156,156,156, &
     157,157,157,157,158,158,158,158,159,159,159,160, &
     160,161,161,161,161,162,162,162,162,162,162,162, &
     162,163,163,163,163,163,163,163,163,163,163,164, &
     164,164,164,164,164,165,165,165,166,166,166,166, &
     166,166,166,166,167,167,167,167,167,167,167,167, &
     167,168,168,168,168,168,168,168,168,168,168,169, &
     169,169,169,170,170,170,170,170,171,171,171,171, &
     171,171,171,171,171,171,171,171,171,172,172,172, &
     172,172,172,172,172,172,172,172,172,172,172,173, &
     173,173,173,173,173,173,173,173,173,173,174,174, &
     174,174,174,174,174,174,175,175,175,175,175,175, &
     175,175,175,175,175,176,176,176,176,176,176,176, &
     176,176,177,177,177,177,177,177,177,177,177,177, &
     177,177,177,178,178,178,178,178,178,178,178,178, &
     178,178,178,179,179,179,179,179,180,180,180,180 /)
  INTEGER, PARAMETER, DIMENSION(358) :: ICOL_STOICM_2 = (/ &
     180,180,181,181,181,181,181,182,182,182,182,182, &
     182,182,182,183,183,183,183,183,184,184,184,184, &
     184,184,184,184,185,185,185,186,186,186,186,186, &
     187,187,187,187,187,187,187,188,188,188,188,189, &
     189,189,189,189,189,189,189,189,190,190,190,190, &
     190,190,190,190,190,191,191,191,191,191,191,191, &
     191,191,191,191,191,191,191,192,192,192,192,192, &
     192,192,193,193,193,193,193,193,193,193,194,194, &
     194,194,194,194,194,194,195,195,195,195,195,195, &
     195,195,195,195,195,195,195,195,195,195,195,195, &
     196,196,196,196,196,196,196,196,197,197,197,197, &
     198,198,198,198,199,199,199,199,199,199,200,200, &
     200,200,200,200,200,200,201,201,201,201,201,201, &
     201,201,201,201,201,202,202,202,202,202,202,202, &
     202,202,202,202,202,202,202,203,203,203,203,203, &
     203,203,203,203,203,203,204,204,204,204,204,204, &
     204,204,204,204,204,204,204,204,205,205,205,205, &
     205,205,205,205,205,205,205,205,205,206,206,206, &
     206,206,206,206,206,206,206,207,207,207,207,207, &
     207,207,207,207,207,207,207,207,207,207,207,208, &
     208,208,208,208,208,208,208,208,209,209,209,209, &
     209,210,210,210,210,210,210,210,210,210,210,210, &
     210,210,211,211,211,211,211,211,211,211,211,211, &
     211,211,211,211,211,211,211,211,211,211,211,211, &
     211,212,212,212,212,212,212,212,212,212,212,212, &
     212,212,212,212,213,213,213,213,213,213,213,213, &
     213,213,214,214,214,214,214,214,215,215,215,215, &
     215,215,215,216,216,216,216,216,216,216,216,216, &
     216,216,216,217,217,217,217,217,217,218,218,218, &
     218,218,219,219,220,221,222,223,224,225 /)
  INTEGER, PARAMETER, DIMENSION(1078) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  3.900000e-01_dp,  6.100000e-01_dp,  3.900000e-01_dp, &
       6.100000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.500000e-01_dp, &
       7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  6.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       3.400000e-02_dp,  3.400000e-02_dp,  -1.000000e+00_dp,  1.000000e-03_dp,  -1.000000e+00_dp, &
       9.650000e-01_dp,  3.400000e-02_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  6.160000e-01_dp, &
       4.820000e-01_dp,  1.150000e-01_dp,  3.700000e-01_dp,  -1.000000e+00_dp,  4.920000e-01_dp, &
       4.200000e-02_dp,  -1.000000e+00_dp,  9.600000e-02_dp,  3.700000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  9.600000e-01_dp,  8.100000e-02_dp, &
       -1.000000e+00_dp,  5.000000e-02_dp,  9.500000e-01_dp,  -1.000000e+00_dp,  3.500000e-01_dp, &
       -6.500000e-01_dp,  6.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -3.400000e-01_dp,  3.400000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.260000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.700000e-01_dp,  6.300000e-01_dp, &
       1.260000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  3.700000e-01_dp,  -1.000000e+00_dp, &
       6.300000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  2.300000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp, &
       7.600000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.300000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp,  7.600000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  7.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  8.400000e-02_dp,  4.160000e-01_dp,  -1.000000e+00_dp, &
       8.400000e-02_dp,  4.160000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       3.330000e-01_dp,  9.000000e-01_dp,  4.500000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  2.080000e-01_dp,  1.000000e-01_dp,  1.000000e-01_dp,  8.000000e-03_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  6.700000e-01_dp, &
       -1.000000e+00_dp,  6.700000e-01_dp,  6.700000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp, &
       3.300000e-01_dp,  3.400000e-01_dp,  3.000000e-01_dp,  6.750000e-01_dp,  -1.000000e+00_dp, &
       3.000000e-01_dp,  6.750000e-01_dp,  6.750000e-01_dp,  2.500000e-02_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       3.000000e-01_dp,  3.510000e-01_dp,  9.500000e-01_dp,  4.750000e-01_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  -1.000000e+00_dp,  1.640000e-01_dp,  5.000000e-02_dp,  5.000000e-02_dp, &
       6.400000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  5.500000e-01_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  7.000000e-01_dp,  3.000000e-01_dp,  3.000000e-01_dp, &
       1.740000e-01_dp,  3.360000e-01_dp,  1.500000e-01_dp,  -1.000000e+00_dp,  1.290000e-01_dp, &
       5.500000e-02_dp,  1.300000e-02_dp,  1.500000e-01_dp,  3.320000e-01_dp,  4.100000e-02_dp, &
       2.890000e-01_dp,  -1.000000e+00_dp,  6.700000e-01_dp,  1.000000e-01_dp,  3.720000e-01_dp, &
       7.420000e-01_dp,  4.980000e-01_dp,  2.300000e-02_dp,  -1.000000e+00_dp,  4.700000e-02_dp, &
       1.250000e-01_dp,  2.100000e-01_dp,  -1.000000e+00_dp,  2.850000e-01_dp,  4.800000e-02_dp, &
       4.800000e-02_dp,  4.000000e-01_dp,  8.000000e-03_dp,  5.720000e-01_dp,  1.500000e-01_dp, &
       -1.000000e+00_dp,  2.270000e-01_dp,  5.720000e-01_dp,  2.180000e-01_dp,  5.100000e-02_dp, &
       1.500000e-01_dp,  -1.000000e+00_dp,  7.990000e-01_dp,  1.233000e+00_dp,  -1.000000e+00_dp, &
       4.670000e-01_dp,  3.000000e-01_dp,  2.330000e-01_dp,  4.670000e-01_dp,  3.000000e-01_dp, &
       1.233000e+00_dp,  8.400000e-02_dp,  2.130000e-01_dp,  5.580000e-01_dp,  1.150000e-01_dp, &
       -6.710000e-01_dp,  2.900000e-02_dp,  7.000000e-02_dp,  -1.000000e+00_dp,  4.900000e-02_dp, &
       4.730000e-01_dp,  3.790000e-01_dp,  5.150000e-01_dp,  2.460000e-01_dp,  5.060000e-01_dp, &
       7.100000e-01_dp,  -1.000000e+00_dp,  6.670000e-01_dp,  4.000000e-02_dp,  3.330000e-01_dp, &
       9.600000e-01_dp,  6.000000e-03_dp,  5.960000e-01_dp,  4.390000e-01_dp,  1.000000e-02_dp, &
       -6.900000e-01_dp,  2.130000e-01_dp,  1.770000e-01_dp,  4.800000e-02_dp,  1.730000e-01_dp, &
       -1.000000e+00_dp,  3.380000e-01_dp,  3.760000e-01_dp,  1.130000e-01_dp,  2.000000e-02_dp, &
       1.520000e-01_dp,  4.310000e-01_dp,  1.340000e-01_dp,  -1.000000e+00_dp,  1.470000e-01_dp, &
       2.430000e-01_dp,  4.350000e-01_dp,  9.500000e-02_dp,  1.000000e+00_dp,  5.640000e-01_dp, &
       3.410000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.500000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  1.500000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_5 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.950000e-01_dp,  1.610000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  3.700000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.200000e-01_dp,  1.200000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  4.910000e-01_dp,  -1.000000e+00_dp,  9.000000e-03_dp, &
       2.500000e-01_dp,  1.910000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  2.000000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  7.900000e-02_dp,  2.300000e-01_dp,  3.570000e-01_dp, &
       3.200000e-01_dp,  6.240000e-01_dp,  9.300000e-02_dp,  -1.000000e+00_dp,  9.070000e-01_dp, &
       2.040000e-01_dp,  1.500000e-01_dp,  2.750000e-01_dp,  -1.000000e+00_dp,  1.260000e-01_dp, &
       3.900000e-01_dp,  1.600000e-01_dp,  5.920000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-03_dp,  1.920000e-01_dp,  2.660000e-01_dp,  6.600000e-02_dp,  -1.000000e+00_dp, &
       1.870000e-01_dp,  9.360000e-01_dp,  6.400000e-02_dp,  1.870000e-01_dp,  -1.000000e+00_dp, &
       7.490000e-01_dp,  -1.000000e+00_dp,  2.400000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp, &
       7.500000e-01_dp,  1.000000e-02_dp,  2.400000e-01_dp,  2.500000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  2.760000e-01_dp,  4.740000e-01_dp,  2.760000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  1.030000e-01_dp,  1.890000e-01_dp,  3.100000e-02_dp, &
       1.570000e-01_dp,  1.300000e-01_dp,  1.000000e-03_dp,  7.290000e-01_dp,  -1.000000e+00_dp, &
       2.350000e-01_dp,  2.050000e-01_dp,  2.760000e-01_dp,  -1.000000e+00_dp,  1.230000e-01_dp, &
       1.800000e-01_dp,  5.670000e-01_dp,  2.010000e-01_dp,  3.100000e-02_dp,  3.300000e-02_dp, &
       7.500000e-01_dp,  -1.000000e+00_dp,  2.760000e-01_dp,  4.740000e-01_dp,  2.500000e-01_dp, &
       4.740000e-01_dp,  -1.000000e+00_dp,  2.760000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.470000e-01_dp,  8.530000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  7.040000e-01_dp,  2.610000e-01_dp,  3.500000e-02_dp, &
       -1.000000e+00_dp,  9.650000e-01_dp,  2.970000e-01_dp,  -1.000000e+00_dp,  3.930000e-01_dp, &
       6.070000e-01_dp,  9.600000e-02_dp,  -3.970000e-01_dp,  1.000000e-01_dp,  2.970000e-01_dp, &
       -1.000000e+00_dp,  2.360000e-01_dp,  2.400000e-02_dp,  5.590000e-01_dp,  4.450000e-01_dp, &
       2.600000e-02_dp,  1.220000e-01_dp,  3.320000e-01_dp,  7.000000e-02_dp,  -1.000000e+00_dp, &
       6.950000e-01_dp,  -1.000000e+00_dp,  2.000000e-03_dp,  4.520000e-01_dp,  9.360000e-01_dp, &
       4.550000e-01_dp,  2.400000e-02_dp,  2.440000e-01_dp,  1.100000e-01_dp,  1.250000e-01_dp, &
       1.100000e-02_dp,  1.430000e-01_dp,  -1.000000e+00_dp,  1.100000e-02_dp,  8.350000e-01_dp, &
       -1.000000e+00_dp,  7.200000e-02_dp,  9.480000e-01_dp,  9.900000e-02_dp,  2.600000e-02_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_6 = (/ &
       2.040000e-01_dp,  8.900000e-02_dp,  4.170000e-01_dp,  3.470000e-01_dp,  -1.000000e+00_dp, &
       6.530000e-01_dp,  -1.000000e+00_dp,  1.080000e-01_dp,  5.100000e-02_dp,  2.070000e-01_dp, &
       4.910000e-01_dp,  5.900000e-02_dp,  1.700000e-02_dp,  1.190000e-01_dp,  1.180000e-01_dp, &
       5.500000e-02_dp,  1.100000e-02_dp,  -1.000000e+00_dp,  7.650000e-01_dp,  2.240000e-01_dp, &
       8.700000e-02_dp,  -1.000000e+00_dp,  9.900000e-02_dp,  9.300000e-02_dp,  1.870000e-01_dp, &
       5.610000e-01_dp,  5.000000e-02_dp,  2.870000e-01_dp,  9.700000e-02_dp,  9.000000e-03_dp, &
       -1.000000e+00_dp,  8.040000e-01_dp,  1.870000e-01_dp,  5.000000e-03_dp,  2.050000e-01_dp, &
       -1.000000e+00_dp,  2.940000e-01_dp,  7.320000e-01_dp,  4.970000e-01_dp,  1.190000e-01_dp, &
       9.000000e-02_dp,  -1.000000e+00_dp,  9.100000e-01_dp,  1.850000e-01_dp,  5.000000e-02_dp, &
       1.190000e-01_dp,  3.450000e-01_dp,  1.000000e-03_dp,  -1.000000e+00_dp,  1.540000e-01_dp, &
       5.000000e-01_dp,  3.630000e-01_dp,  2.150000e-01_dp,  -1.000000e+00_dp,  1.000000e-03_dp, &
       1.550000e-01_dp,  7.600000e-02_dp,  2.200000e-02_dp,  5.600000e-02_dp,  2.400000e-02_dp, &
       4.880000e-01_dp,  -1.000000e+00_dp,  9.000000e-03_dp,  5.110000e-01_dp,  3.700000e-02_dp, &
       1.760000e-01_dp,  -1.000000e+00_dp,  8.240000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       4.500000e-01_dp,  4.370000e-01_dp,  1.130000e-01_dp,  6.100000e-02_dp,  1.270000e-01_dp, &
       1.000000e-03_dp,  2.500000e-02_dp,  2.500000e-02_dp,  -1.000000e+00_dp,  7.320000e-01_dp, &
       2.440000e-01_dp,  5.110000e-01_dp,  7.200000e-02_dp,  8.200000e-02_dp,  -1.000000e+00_dp, &
       9.180000e-01_dp,  7.300000e-02_dp,  1.290000e-01_dp,  2.470000e-01_dp,  4.200000e-02_dp, &
       2.650000e-01_dp,  4.500000e-02_dp,  1.370000e-01_dp,  2.600000e-02_dp,  -1.000000e+00_dp, &
       1.900000e-02_dp,  4.560000e-01_dp,  2.690000e-01_dp,  3.050000e-01_dp,  2.600000e-02_dp, &
       4.300000e-02_dp,  -1.000000e+00_dp,  1.370000e-01_dp,  2.000000e-03_dp,  3.780000e-01_dp, &
       6.000000e-03_dp,  1.970000e-01_dp,  3.300000e-02_dp,  3.000000e-03_dp,  1.500000e-02_dp, &
       1.020000e-01_dp,  7.110000e-01_dp,  -1.000000e+00_dp,  4.800000e-02_dp,  5.070000e-01_dp, &
       7.900000e-02_dp,  3.210000e-01_dp,  1.510000e-01_dp,  1.000000e-03_dp,  1.360000e-01_dp, &
       3.910000e-01_dp,  -1.000000e+00_dp,  3.000000e-02_dp,  4.420000e-01_dp,  1.200000e-02_dp, &
       1.200000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.900000e-02_dp,  6.590000e-01_dp, &
       2.590000e-01_dp,  1.000000e-03_dp,  1.200000e-02_dp,  1.300000e-02_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  1.500000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.500000e+00_dp, &
       4.800000e-02_dp,  -1.000000e+00_dp,  9.840000e-01_dp,  9.840000e-01_dp,  1.600000e-02_dp, &
       -1.000000e+00_dp,  9.840000e-01_dp,  1.350000e-01_dp,  1.850000e-01_dp,  1.700000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(28) :: STOICM_7 = (/ &
       7.000000e-02_dp,  5.100000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  3.200000e-01_dp,  2.600000e-01_dp,  6.000000e-02_dp,  1.000000e+00_dp, &
       2.693000e+00_dp,  -1.000000e+00_dp,  5.100000e-02_dp,  -1.000000e+00_dp,  9.490000e-01_dp, &
       5.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  5.500000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(1078) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5, STOICM_6, STOICM_7 /)


END MODULE SAPRC99_StoichiomSP

