! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : SAPRC99_Stoichiom.f90
! Time                 : Thu Oct  8 08:22:39 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_SAPRC99_30885_BOXMOX
! Equation file        : SAPRC99.kpp
! Output root filename : SAPRC99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE SAPRC99_Stoichiom

  USE SAPRC99_Parameters
  USE SAPRC99_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(74)
  ARP(2) = V(63)*F(2)
  ARP(3) = V(63)*V(67)
  ARP(4) = V(63)*V(73)*F(2)
  ARP(5) = V(63)*V(74)
  ARP(6) = V(63)*V(74)
  ARP(7) = V(67)*V(73)
  ARP(8) = V(67)*V(74)
  ARP(9) = V(73)*V(75)
  ARP(10) = V(73)*V(73)*F(2)
  ARP(11) = V(74)*V(75)
  ARP(12) = V(22)
  ARP(13) = V(22)*F(1)
  ARP(14) = V(74)*V(75)
  ARP(15) = V(75)
  ARP(16) = V(75)
  ARP(17) = V(67)
  ARP(18) = V(67)
  ARP(19) = V(11)*F(1)
  ARP(20) = V(11)*F(2)
  ARP(21) = V(71)*V(73)
  ARP(22) = V(23)
  ARP(23) = V(23)
  ARP(24) = V(23)*V(71)
  ARP(25) = V(71)*V(74)
  ARP(26) = V(71)*V(75)
  ARP(27) = V(47)*V(71)
  ARP(28) = V(47)
  ARP(29) = V(45)*V(71)
  ARP(30) = V(67)*V(71)
  ARP(31) = V(73)*V(78)
  ARP(32) = V(74)*V(78)
  ARP(33) = V(32)
  ARP(34) = V(32)
  ARP(35) = V(32)*V(71)
  ARP(36) = V(67)*V(78)
  ARP(37) = V(78)*V(78)
  ARP(38) = V(78)*V(78)*F(1)
  ARP(39) = V(75)*V(78)
  ARP(40) = V(75)*V(75)
  ARP(41) = V(19)
  ARP(42) = V(19)*V(71)
  ARP(43) = V(71)*V(78)
  ARP(44) = V(10)*V(71)
  ARP(45) = V(71)*F(2)
  ARP(46) = V(73)*V(76)
  ARP(47) = V(76)*V(78)
  ARP(48) = V(75)*V(76)
  ARP(49) = V(76)*V(76)
  ARP(50) = V(76)*V(76)
  ARP(51) = V(73)*V(77)
  ARP(52) = V(77)*V(78)
  ARP(53) = V(75)*V(77)
  ARP(54) = V(76)*V(77)
  ARP(55) = V(77)*V(77)
  ARP(56) = V(53)*V(73)
  ARP(57) = V(53)*V(78)
  ARP(58) = V(53)*V(75)
  ARP(59) = V(53)*V(76)
  ARP(60) = V(53)*V(77)
  ARP(61) = V(53)*V(53)
  ARP(62) = V(69)*V(73)
  ARP(63) = V(69)*V(78)
  ARP(64) = V(69)*V(76)
  ARP(65) = V(69)*V(75)
  ARP(66) = V(69)*V(77)
  ARP(67) = V(53)*V(69)
  ARP(68) = V(69)*V(69)
  ARP(69) = V(68)*V(74)
  ARP(70) = V(15)
  ARP(71) = V(68)*V(73)
  ARP(72) = V(68)*V(78)
  ARP(73) = V(68)*V(75)
  ARP(74) = V(68)*V(76)
  ARP(75) = V(68)*V(77)
  ARP(76) = V(53)*V(68)
  ARP(77) = V(68)*V(69)
  ARP(78) = V(68)*V(68)
  ARP(79) = V(72)*V(74)
  ARP(80) = V(16)
  ARP(81) = V(72)*V(73)
  ARP(82) = V(72)*V(78)
  ARP(83) = V(72)*V(75)
  ARP(84) = V(72)*V(76)
  ARP(85) = V(72)*V(77)
  ARP(86) = V(53)*V(72)
  ARP(87) = V(69)*V(72)
  ARP(88) = V(68)*V(72)
  ARP(89) = V(72)*V(72)
  ARP(90) = V(74)*V(79)
  ARP(91) = V(17)
  ARP(92) = V(73)*V(79)
  ARP(93) = V(78)*V(79)
  ARP(94) = V(75)*V(79)
  ARP(95) = V(76)*V(79)
  ARP(96) = V(77)*V(79)
  ARP(97) = V(53)*V(79)
  ARP(98) = V(69)*V(79)
  ARP(99) = V(68)*V(79)
  ARP(100) = V(72)*V(79)
  ARP(101) = V(79)*V(79)
  ARP(102) = V(70)*V(74)
  ARP(103) = V(18)
  ARP(104) = V(70)*V(73)
  ARP(105) = V(70)*V(78)
  ARP(106) = V(70)*V(75)
  ARP(107) = V(70)*V(76)
  ARP(108) = V(70)*V(77)
  ARP(109) = V(53)*V(70)
  ARP(110) = V(69)*V(70)
  ARP(111) = V(68)*V(70)
  ARP(112) = V(70)*V(72)
  ARP(113) = V(70)*V(79)
  ARP(114) = V(70)*V(70)
  ARP(115) = V(25)*V(74)
  ARP(116) = V(25)
  ARP(117) = V(51)*V(74)
  ARP(118) = V(51)*V(78)
  ARP(119) = V(51)
  ARP(120) = V(31)*V(74)
  ARP(121) = V(31)*V(78)
  ARP(122) = V(31)
  ARP(123) = V(61)
  ARP(124) = V(61)
  ARP(125) = V(61)*V(71)
  ARP(126) = V(61)*V(78)
  ARP(127) = V(30)
  ARP(128) = V(30)*V(73)
  ARP(129) = V(61)*V(75)
  ARP(130) = V(60)*V(71)
  ARP(131) = V(60)
  ARP(132) = V(60)*V(75)
  ARP(133) = V(64)*V(71)
  ARP(134) = V(64)
  ARP(135) = V(64)*V(75)
  ARP(136) = V(46)*V(71)
  ARP(137) = V(46)
  ARP(138) = V(65)*V(71)
  ARP(139) = V(65)
  ARP(140) = V(28)*V(71)
  ARP(141) = V(21)*V(71)
  ARP(142) = V(29)*V(71)
  ARP(143) = V(29)
  ARP(144) = V(42)*V(71)
  ARP(145) = V(42)
  ARP(146) = V(49)
  ARP(147) = V(49)
  ARP(148) = V(49)*V(71)
  ARP(149) = V(49)*V(75)
  ARP(150) = V(44)
  ARP(151) = V(44)*V(71)
  ARP(152) = V(44)*V(75)
  ARP(153) = V(14)
  ARP(154) = V(43)*V(71)
  ARP(155) = V(43)*V(75)
  ARP(156) = V(37)*V(71)
  ARP(157) = V(37)*V(75)
  ARP(158) = V(40)*V(75)
  ARP(159) = V(41)*V(71)
  ARP(160) = V(41)
  ARP(161) = V(41)*V(75)
  ARP(162) = V(55)*V(71)
  ARP(163) = V(55)*V(67)
  ARP(164) = V(55)*V(75)
  ARP(165) = V(55)*V(63)
  ARP(166) = V(55)
  ARP(167) = V(59)*V(71)
  ARP(168) = V(59)*V(67)
  ARP(169) = V(59)*V(63)
  ARP(170) = V(59)
  ARP(171) = V(57)*V(71)
  ARP(172) = V(57)*V(67)
  ARP(173) = V(57)*V(75)
  ARP(174) = V(57)
  ARP(175) = V(66)*V(71)
  ARP(176) = V(66)
  ARP(177) = V(62)*V(71)
  ARP(178) = V(62)
  ARP(179) = V(38)*V(71)
  ARP(180) = V(38)*V(67)
  ARP(181) = V(35)*V(71)
  ARP(182) = V(35)
  ARP(183) = V(36)*V(71)
  ARP(184) = V(36)
  ARP(185) = V(12)*V(71)
  ARP(186) = V(48)*V(71)
  ARP(187) = V(48)*V(67)
  ARP(188) = V(48)*V(75)
  ARP(189) = V(48)*V(63)
  ARP(190) = V(52)*V(71)
  ARP(191) = V(52)*V(67)
  ARP(192) = V(52)*V(75)
  ARP(193) = V(52)*V(63)
  ARP(194) = V(54)*V(71)
  ARP(195) = V(54)*V(67)
  ARP(196) = V(54)*V(75)
  ARP(197) = V(54)*V(63)
  ARP(198) = V(13)*V(71)
  ARP(199) = V(20)*V(71)
  ARP(200) = V(39)*V(71)
  ARP(201) = V(24)*V(71)
  ARP(202) = V(33)*V(71)
  ARP(203) = V(26)*V(71)
  ARP(204) = V(34)*V(71)
  ARP(205) = V(27)*V(71)
  ARP(206) = V(56)*V(71)
  ARP(207) = V(56)*V(67)
  ARP(208) = V(56)*V(75)
  ARP(209) = V(56)*V(63)
  ARP(210) = V(58)*V(71)
  ARP(211) = V(58)*V(67)
  ARP(212) = V(58)*V(75)
  ARP(213) = V(58)*V(63)
  ARP(214) = V(39)*V(67)
  ARP(215) = V(50)*V(71)
  ARP(216) = V(50)*V(67)
  ARP(217) = V(50)*V(75)
  ARP(218) = V(50)*V(63)
  ARP(219) = V(10)
  ARP(220) = V(78)
  ARP(221) = V(10)
  ARP(222) = V(1)
  ARP(223) = V(47)
  ARP(224) = V(19)
  ARP(225) = V(2)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(74)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(63)
  JVRP(2) = F(2)
! JVRP(3) = dARP(3)/dV(63)
  JVRP(3) = V(67)
! JVRP(4) = dARP(3)/dV(67)
  JVRP(4) = V(63)
! JVRP(5) = dARP(4)/dV(63)
  JVRP(5) = V(73)*F(2)
! JVRP(6) = dARP(4)/dV(73)
  JVRP(6) = V(63)*F(2)
! JVRP(7) = dARP(5)/dV(63)
  JVRP(7) = V(74)
! JVRP(8) = dARP(5)/dV(74)
  JVRP(8) = V(63)
! JVRP(9) = dARP(6)/dV(63)
  JVRP(9) = V(74)
! JVRP(10) = dARP(6)/dV(74)
  JVRP(10) = V(63)
! JVRP(11) = dARP(7)/dV(67)
  JVRP(11) = V(73)
! JVRP(12) = dARP(7)/dV(73)
  JVRP(12) = V(67)
! JVRP(13) = dARP(8)/dV(67)
  JVRP(13) = V(74)
! JVRP(14) = dARP(8)/dV(74)
  JVRP(14) = V(67)
! JVRP(15) = dARP(9)/dV(73)
  JVRP(15) = V(75)
! JVRP(16) = dARP(9)/dV(75)
  JVRP(16) = V(73)
! JVRP(17) = dARP(10)/dV(73)
  JVRP(17) = 2*V(73)*F(2)
! JVRP(18) = dARP(11)/dV(74)
  JVRP(18) = V(75)
! JVRP(19) = dARP(11)/dV(75)
  JVRP(19) = V(74)
! JVRP(20) = dARP(12)/dV(22)
  JVRP(20) = 1
! JVRP(21) = dARP(13)/dV(22)
  JVRP(21) = F(1)
! JVRP(22) = dARP(14)/dV(74)
  JVRP(22) = V(75)
! JVRP(23) = dARP(14)/dV(75)
  JVRP(23) = V(74)
! JVRP(24) = dARP(15)/dV(75)
  JVRP(24) = 1
! JVRP(25) = dARP(16)/dV(75)
  JVRP(25) = 1
! JVRP(26) = dARP(17)/dV(67)
  JVRP(26) = 1
! JVRP(27) = dARP(18)/dV(67)
  JVRP(27) = 1
! JVRP(28) = dARP(19)/dV(11)
  JVRP(28) = F(1)
! JVRP(29) = dARP(20)/dV(11)
  JVRP(29) = F(2)
! JVRP(30) = dARP(21)/dV(71)
  JVRP(30) = V(73)
! JVRP(31) = dARP(21)/dV(73)
  JVRP(31) = V(71)
! JVRP(32) = dARP(22)/dV(23)
  JVRP(32) = 1
! JVRP(33) = dARP(23)/dV(23)
  JVRP(33) = 1
! JVRP(34) = dARP(24)/dV(23)
  JVRP(34) = V(71)
! JVRP(35) = dARP(24)/dV(71)
  JVRP(35) = V(23)
! JVRP(36) = dARP(25)/dV(71)
  JVRP(36) = V(74)
! JVRP(37) = dARP(25)/dV(74)
  JVRP(37) = V(71)
! JVRP(38) = dARP(26)/dV(71)
  JVRP(38) = V(75)
! JVRP(39) = dARP(26)/dV(75)
  JVRP(39) = V(71)
! JVRP(40) = dARP(27)/dV(47)
  JVRP(40) = V(71)
! JVRP(41) = dARP(27)/dV(71)
  JVRP(41) = V(47)
! JVRP(42) = dARP(28)/dV(47)
  JVRP(42) = 1
! JVRP(43) = dARP(29)/dV(45)
  JVRP(43) = V(71)
! JVRP(44) = dARP(29)/dV(71)
  JVRP(44) = V(45)
! JVRP(45) = dARP(30)/dV(67)
  JVRP(45) = V(71)
! JVRP(46) = dARP(30)/dV(71)
  JVRP(46) = V(67)
! JVRP(47) = dARP(31)/dV(73)
  JVRP(47) = V(78)
! JVRP(48) = dARP(31)/dV(78)
  JVRP(48) = V(73)
! JVRP(49) = dARP(32)/dV(74)
  JVRP(49) = V(78)
! JVRP(50) = dARP(32)/dV(78)
  JVRP(50) = V(74)
! JVRP(51) = dARP(33)/dV(32)
  JVRP(51) = 1
! JVRP(52) = dARP(34)/dV(32)
  JVRP(52) = 1
! JVRP(53) = dARP(35)/dV(32)
  JVRP(53) = V(71)
! JVRP(54) = dARP(35)/dV(71)
  JVRP(54) = V(32)
! JVRP(55) = dARP(36)/dV(67)
  JVRP(55) = V(78)
! JVRP(56) = dARP(36)/dV(78)
  JVRP(56) = V(67)
! JVRP(57) = dARP(37)/dV(78)
  JVRP(57) = 2*V(78)
! JVRP(58) = dARP(38)/dV(78)
  JVRP(58) = 2*V(78)*F(1)
! JVRP(59) = dARP(39)/dV(75)
  JVRP(59) = V(78)
! JVRP(60) = dARP(39)/dV(78)
  JVRP(60) = V(75)
! JVRP(61) = dARP(40)/dV(75)
  JVRP(61) = 2*V(75)
! JVRP(62) = dARP(41)/dV(19)
  JVRP(62) = 1
! JVRP(63) = dARP(42)/dV(19)
  JVRP(63) = V(71)
! JVRP(64) = dARP(42)/dV(71)
  JVRP(64) = V(19)
! JVRP(65) = dARP(43)/dV(71)
  JVRP(65) = V(78)
! JVRP(66) = dARP(43)/dV(78)
  JVRP(66) = V(71)
! JVRP(67) = dARP(44)/dV(10)
  JVRP(67) = V(71)
! JVRP(68) = dARP(44)/dV(71)
  JVRP(68) = V(10)
! JVRP(69) = dARP(45)/dV(71)
  JVRP(69) = F(2)
! JVRP(70) = dARP(46)/dV(73)
  JVRP(70) = V(76)
! JVRP(71) = dARP(46)/dV(76)
  JVRP(71) = V(73)
! JVRP(72) = dARP(47)/dV(76)
  JVRP(72) = V(78)
! JVRP(73) = dARP(47)/dV(78)
  JVRP(73) = V(76)
! JVRP(74) = dARP(48)/dV(75)
  JVRP(74) = V(76)
! JVRP(75) = dARP(48)/dV(76)
  JVRP(75) = V(75)
! JVRP(76) = dARP(49)/dV(76)
  JVRP(76) = 2*V(76)
! JVRP(77) = dARP(50)/dV(76)
  JVRP(77) = 2*V(76)
! JVRP(78) = dARP(51)/dV(73)
  JVRP(78) = V(77)
! JVRP(79) = dARP(51)/dV(77)
  JVRP(79) = V(73)
! JVRP(80) = dARP(52)/dV(77)
  JVRP(80) = V(78)
! JVRP(81) = dARP(52)/dV(78)
  JVRP(81) = V(77)
! JVRP(82) = dARP(53)/dV(75)
  JVRP(82) = V(77)
! JVRP(83) = dARP(53)/dV(77)
  JVRP(83) = V(75)
! JVRP(84) = dARP(54)/dV(76)
  JVRP(84) = V(77)
! JVRP(85) = dARP(54)/dV(77)
  JVRP(85) = V(76)
! JVRP(86) = dARP(55)/dV(77)
  JVRP(86) = 2*V(77)
! JVRP(87) = dARP(56)/dV(53)
  JVRP(87) = V(73)
! JVRP(88) = dARP(56)/dV(73)
  JVRP(88) = V(53)
! JVRP(89) = dARP(57)/dV(53)
  JVRP(89) = V(78)
! JVRP(90) = dARP(57)/dV(78)
  JVRP(90) = V(53)
! JVRP(91) = dARP(58)/dV(53)
  JVRP(91) = V(75)
! JVRP(92) = dARP(58)/dV(75)
  JVRP(92) = V(53)
! JVRP(93) = dARP(59)/dV(53)
  JVRP(93) = V(76)
! JVRP(94) = dARP(59)/dV(76)
  JVRP(94) = V(53)
! JVRP(95) = dARP(60)/dV(53)
  JVRP(95) = V(77)
! JVRP(96) = dARP(60)/dV(77)
  JVRP(96) = V(53)
! JVRP(97) = dARP(61)/dV(53)
  JVRP(97) = 2*V(53)
! JVRP(98) = dARP(62)/dV(69)
  JVRP(98) = V(73)
! JVRP(99) = dARP(62)/dV(73)
  JVRP(99) = V(69)
! JVRP(100) = dARP(63)/dV(69)
  JVRP(100) = V(78)
! JVRP(101) = dARP(63)/dV(78)
  JVRP(101) = V(69)
! JVRP(102) = dARP(64)/dV(69)
  JVRP(102) = V(76)
! JVRP(103) = dARP(64)/dV(76)
  JVRP(103) = V(69)
! JVRP(104) = dARP(65)/dV(69)
  JVRP(104) = V(75)
! JVRP(105) = dARP(65)/dV(75)
  JVRP(105) = V(69)
! JVRP(106) = dARP(66)/dV(69)
  JVRP(106) = V(77)
! JVRP(107) = dARP(66)/dV(77)
  JVRP(107) = V(69)
! JVRP(108) = dARP(67)/dV(53)
  JVRP(108) = V(69)
! JVRP(109) = dARP(67)/dV(69)
  JVRP(109) = V(53)
! JVRP(110) = dARP(68)/dV(69)
  JVRP(110) = 2*V(69)
! JVRP(111) = dARP(69)/dV(68)
  JVRP(111) = V(74)
! JVRP(112) = dARP(69)/dV(74)
  JVRP(112) = V(68)
! JVRP(113) = dARP(70)/dV(15)
  JVRP(113) = 1
! JVRP(114) = dARP(71)/dV(68)
  JVRP(114) = V(73)
! JVRP(115) = dARP(71)/dV(73)
  JVRP(115) = V(68)
! JVRP(116) = dARP(72)/dV(68)
  JVRP(116) = V(78)
! JVRP(117) = dARP(72)/dV(78)
  JVRP(117) = V(68)
! JVRP(118) = dARP(73)/dV(68)
  JVRP(118) = V(75)
! JVRP(119) = dARP(73)/dV(75)
  JVRP(119) = V(68)
! JVRP(120) = dARP(74)/dV(68)
  JVRP(120) = V(76)
! JVRP(121) = dARP(74)/dV(76)
  JVRP(121) = V(68)
! JVRP(122) = dARP(75)/dV(68)
  JVRP(122) = V(77)
! JVRP(123) = dARP(75)/dV(77)
  JVRP(123) = V(68)
! JVRP(124) = dARP(76)/dV(53)
  JVRP(124) = V(68)
! JVRP(125) = dARP(76)/dV(68)
  JVRP(125) = V(53)
! JVRP(126) = dARP(77)/dV(68)
  JVRP(126) = V(69)
! JVRP(127) = dARP(77)/dV(69)
  JVRP(127) = V(68)
! JVRP(128) = dARP(78)/dV(68)
  JVRP(128) = 2*V(68)
! JVRP(129) = dARP(79)/dV(72)
  JVRP(129) = V(74)
! JVRP(130) = dARP(79)/dV(74)
  JVRP(130) = V(72)
! JVRP(131) = dARP(80)/dV(16)
  JVRP(131) = 1
! JVRP(132) = dARP(81)/dV(72)
  JVRP(132) = V(73)
! JVRP(133) = dARP(81)/dV(73)
  JVRP(133) = V(72)
! JVRP(134) = dARP(82)/dV(72)
  JVRP(134) = V(78)
! JVRP(135) = dARP(82)/dV(78)
  JVRP(135) = V(72)
! JVRP(136) = dARP(83)/dV(72)
  JVRP(136) = V(75)
! JVRP(137) = dARP(83)/dV(75)
  JVRP(137) = V(72)
! JVRP(138) = dARP(84)/dV(72)
  JVRP(138) = V(76)
! JVRP(139) = dARP(84)/dV(76)
  JVRP(139) = V(72)
! JVRP(140) = dARP(85)/dV(72)
  JVRP(140) = V(77)
! JVRP(141) = dARP(85)/dV(77)
  JVRP(141) = V(72)
! JVRP(142) = dARP(86)/dV(53)
  JVRP(142) = V(72)
! JVRP(143) = dARP(86)/dV(72)
  JVRP(143) = V(53)
! JVRP(144) = dARP(87)/dV(69)
  JVRP(144) = V(72)
! JVRP(145) = dARP(87)/dV(72)
  JVRP(145) = V(69)
! JVRP(146) = dARP(88)/dV(68)
  JVRP(146) = V(72)
! JVRP(147) = dARP(88)/dV(72)
  JVRP(147) = V(68)
! JVRP(148) = dARP(89)/dV(72)
  JVRP(148) = 2*V(72)
! JVRP(149) = dARP(90)/dV(74)
  JVRP(149) = V(79)
! JVRP(150) = dARP(90)/dV(79)
  JVRP(150) = V(74)
! JVRP(151) = dARP(91)/dV(17)
  JVRP(151) = 1
! JVRP(152) = dARP(92)/dV(73)
  JVRP(152) = V(79)
! JVRP(153) = dARP(92)/dV(79)
  JVRP(153) = V(73)
! JVRP(154) = dARP(93)/dV(78)
  JVRP(154) = V(79)
! JVRP(155) = dARP(93)/dV(79)
  JVRP(155) = V(78)
! JVRP(156) = dARP(94)/dV(75)
  JVRP(156) = V(79)
! JVRP(157) = dARP(94)/dV(79)
  JVRP(157) = V(75)
! JVRP(158) = dARP(95)/dV(76)
  JVRP(158) = V(79)
! JVRP(159) = dARP(95)/dV(79)
  JVRP(159) = V(76)
! JVRP(160) = dARP(96)/dV(77)
  JVRP(160) = V(79)
! JVRP(161) = dARP(96)/dV(79)
  JVRP(161) = V(77)
! JVRP(162) = dARP(97)/dV(53)
  JVRP(162) = V(79)
! JVRP(163) = dARP(97)/dV(79)
  JVRP(163) = V(53)
! JVRP(164) = dARP(98)/dV(69)
  JVRP(164) = V(79)
! JVRP(165) = dARP(98)/dV(79)
  JVRP(165) = V(69)
! JVRP(166) = dARP(99)/dV(68)
  JVRP(166) = V(79)
! JVRP(167) = dARP(99)/dV(79)
  JVRP(167) = V(68)
! JVRP(168) = dARP(100)/dV(72)
  JVRP(168) = V(79)
! JVRP(169) = dARP(100)/dV(79)
  JVRP(169) = V(72)
! JVRP(170) = dARP(101)/dV(79)
  JVRP(170) = 2*V(79)
! JVRP(171) = dARP(102)/dV(70)
  JVRP(171) = V(74)
! JVRP(172) = dARP(102)/dV(74)
  JVRP(172) = V(70)
! JVRP(173) = dARP(103)/dV(18)
  JVRP(173) = 1
! JVRP(174) = dARP(104)/dV(70)
  JVRP(174) = V(73)
! JVRP(175) = dARP(104)/dV(73)
  JVRP(175) = V(70)
! JVRP(176) = dARP(105)/dV(70)
  JVRP(176) = V(78)
! JVRP(177) = dARP(105)/dV(78)
  JVRP(177) = V(70)
! JVRP(178) = dARP(106)/dV(70)
  JVRP(178) = V(75)
! JVRP(179) = dARP(106)/dV(75)
  JVRP(179) = V(70)
! JVRP(180) = dARP(107)/dV(70)
  JVRP(180) = V(76)
! JVRP(181) = dARP(107)/dV(76)
  JVRP(181) = V(70)
! JVRP(182) = dARP(108)/dV(70)
  JVRP(182) = V(77)
! JVRP(183) = dARP(108)/dV(77)
  JVRP(183) = V(70)
! JVRP(184) = dARP(109)/dV(53)
  JVRP(184) = V(70)
! JVRP(185) = dARP(109)/dV(70)
  JVRP(185) = V(53)
! JVRP(186) = dARP(110)/dV(69)
  JVRP(186) = V(70)
! JVRP(187) = dARP(110)/dV(70)
  JVRP(187) = V(69)
! JVRP(188) = dARP(111)/dV(68)
  JVRP(188) = V(70)
! JVRP(189) = dARP(111)/dV(70)
  JVRP(189) = V(68)
! JVRP(190) = dARP(112)/dV(70)
  JVRP(190) = V(72)
! JVRP(191) = dARP(112)/dV(72)
  JVRP(191) = V(70)
! JVRP(192) = dARP(113)/dV(70)
  JVRP(192) = V(79)
! JVRP(193) = dARP(113)/dV(79)
  JVRP(193) = V(70)
! JVRP(194) = dARP(114)/dV(70)
  JVRP(194) = 2*V(70)
! JVRP(195) = dARP(115)/dV(25)
  JVRP(195) = V(74)
! JVRP(196) = dARP(115)/dV(74)
  JVRP(196) = V(25)
! JVRP(197) = dARP(116)/dV(25)
  JVRP(197) = 1
! JVRP(198) = dARP(117)/dV(51)
  JVRP(198) = V(74)
! JVRP(199) = dARP(117)/dV(74)
  JVRP(199) = V(51)
! JVRP(200) = dARP(118)/dV(51)
  JVRP(200) = V(78)
! JVRP(201) = dARP(118)/dV(78)
  JVRP(201) = V(51)
! JVRP(202) = dARP(119)/dV(51)
  JVRP(202) = 1
! JVRP(203) = dARP(120)/dV(31)
  JVRP(203) = V(74)
! JVRP(204) = dARP(120)/dV(74)
  JVRP(204) = V(31)
! JVRP(205) = dARP(121)/dV(31)
  JVRP(205) = V(78)
! JVRP(206) = dARP(121)/dV(78)
  JVRP(206) = V(31)
! JVRP(207) = dARP(122)/dV(31)
  JVRP(207) = 1
! JVRP(208) = dARP(123)/dV(61)
  JVRP(208) = 1
! JVRP(209) = dARP(124)/dV(61)
  JVRP(209) = 1
! JVRP(210) = dARP(125)/dV(61)
  JVRP(210) = V(71)
! JVRP(211) = dARP(125)/dV(71)
  JVRP(211) = V(61)
! JVRP(212) = dARP(126)/dV(61)
  JVRP(212) = V(78)
! JVRP(213) = dARP(126)/dV(78)
  JVRP(213) = V(61)
! JVRP(214) = dARP(127)/dV(30)
  JVRP(214) = 1
! JVRP(215) = dARP(128)/dV(30)
  JVRP(215) = V(73)
! JVRP(216) = dARP(128)/dV(73)
  JVRP(216) = V(30)
! JVRP(217) = dARP(129)/dV(61)
  JVRP(217) = V(75)
! JVRP(218) = dARP(129)/dV(75)
  JVRP(218) = V(61)
! JVRP(219) = dARP(130)/dV(60)
  JVRP(219) = V(71)
! JVRP(220) = dARP(130)/dV(71)
  JVRP(220) = V(60)
! JVRP(221) = dARP(131)/dV(60)
  JVRP(221) = 1
! JVRP(222) = dARP(132)/dV(60)
  JVRP(222) = V(75)
! JVRP(223) = dARP(132)/dV(75)
  JVRP(223) = V(60)
! JVRP(224) = dARP(133)/dV(64)
  JVRP(224) = V(71)
! JVRP(225) = dARP(133)/dV(71)
  JVRP(225) = V(64)
! JVRP(226) = dARP(134)/dV(64)
  JVRP(226) = 1
! JVRP(227) = dARP(135)/dV(64)
  JVRP(227) = V(75)
! JVRP(228) = dARP(135)/dV(75)
  JVRP(228) = V(64)
! JVRP(229) = dARP(136)/dV(46)
  JVRP(229) = V(71)
! JVRP(230) = dARP(136)/dV(71)
  JVRP(230) = V(46)
! JVRP(231) = dARP(137)/dV(46)
  JVRP(231) = 1
! JVRP(232) = dARP(138)/dV(65)
  JVRP(232) = V(71)
! JVRP(233) = dARP(138)/dV(71)
  JVRP(233) = V(65)
! JVRP(234) = dARP(139)/dV(65)
  JVRP(234) = 1
! JVRP(235) = dARP(140)/dV(28)
  JVRP(235) = V(71)
! JVRP(236) = dARP(140)/dV(71)
  JVRP(236) = V(28)
! JVRP(237) = dARP(141)/dV(21)
  JVRP(237) = V(71)
! JVRP(238) = dARP(141)/dV(71)
  JVRP(238) = V(21)
! JVRP(239) = dARP(142)/dV(29)
  JVRP(239) = V(71)
! JVRP(240) = dARP(142)/dV(71)
  JVRP(240) = V(29)
! JVRP(241) = dARP(143)/dV(29)
  JVRP(241) = 1
! JVRP(242) = dARP(144)/dV(42)
  JVRP(242) = V(71)
! JVRP(243) = dARP(144)/dV(71)
  JVRP(243) = V(42)
! JVRP(244) = dARP(145)/dV(42)
  JVRP(244) = 1
! JVRP(245) = dARP(146)/dV(49)
  JVRP(245) = 1
! JVRP(246) = dARP(147)/dV(49)
  JVRP(246) = 1
! JVRP(247) = dARP(148)/dV(49)
  JVRP(247) = V(71)
! JVRP(248) = dARP(148)/dV(71)
  JVRP(248) = V(49)
! JVRP(249) = dARP(149)/dV(49)
  JVRP(249) = V(75)
! JVRP(250) = dARP(149)/dV(75)
  JVRP(250) = V(49)
! JVRP(251) = dARP(150)/dV(44)
  JVRP(251) = 1
! JVRP(252) = dARP(151)/dV(44)
  JVRP(252) = V(71)
! JVRP(253) = dARP(151)/dV(71)
  JVRP(253) = V(44)
! JVRP(254) = dARP(152)/dV(44)
  JVRP(254) = V(75)
! JVRP(255) = dARP(152)/dV(75)
  JVRP(255) = V(44)
! JVRP(256) = dARP(153)/dV(14)
  JVRP(256) = 1
! JVRP(257) = dARP(154)/dV(43)
  JVRP(257) = V(71)
! JVRP(258) = dARP(154)/dV(71)
  JVRP(258) = V(43)
! JVRP(259) = dARP(155)/dV(43)
  JVRP(259) = V(75)
! JVRP(260) = dARP(155)/dV(75)
  JVRP(260) = V(43)
! JVRP(261) = dARP(156)/dV(37)
  JVRP(261) = V(71)
! JVRP(262) = dARP(156)/dV(71)
  JVRP(262) = V(37)
! JVRP(263) = dARP(157)/dV(37)
  JVRP(263) = V(75)
! JVRP(264) = dARP(157)/dV(75)
  JVRP(264) = V(37)
! JVRP(265) = dARP(158)/dV(40)
  JVRP(265) = V(75)
! JVRP(266) = dARP(158)/dV(75)
  JVRP(266) = V(40)
! JVRP(267) = dARP(159)/dV(41)
  JVRP(267) = V(71)
! JVRP(268) = dARP(159)/dV(71)
  JVRP(268) = V(41)
! JVRP(269) = dARP(160)/dV(41)
  JVRP(269) = 1
! JVRP(270) = dARP(161)/dV(41)
  JVRP(270) = V(75)
! JVRP(271) = dARP(161)/dV(75)
  JVRP(271) = V(41)
! JVRP(272) = dARP(162)/dV(55)
  JVRP(272) = V(71)
! JVRP(273) = dARP(162)/dV(71)
  JVRP(273) = V(55)
! JVRP(274) = dARP(163)/dV(55)
  JVRP(274) = V(67)
! JVRP(275) = dARP(163)/dV(67)
  JVRP(275) = V(55)
! JVRP(276) = dARP(164)/dV(55)
  JVRP(276) = V(75)
! JVRP(277) = dARP(164)/dV(75)
  JVRP(277) = V(55)
! JVRP(278) = dARP(165)/dV(55)
  JVRP(278) = V(63)
! JVRP(279) = dARP(165)/dV(63)
  JVRP(279) = V(55)
! JVRP(280) = dARP(166)/dV(55)
  JVRP(280) = 1
! JVRP(281) = dARP(167)/dV(59)
  JVRP(281) = V(71)
! JVRP(282) = dARP(167)/dV(71)
  JVRP(282) = V(59)
! JVRP(283) = dARP(168)/dV(59)
  JVRP(283) = V(67)
! JVRP(284) = dARP(168)/dV(67)
  JVRP(284) = V(59)
! JVRP(285) = dARP(169)/dV(59)
  JVRP(285) = V(63)
! JVRP(286) = dARP(169)/dV(63)
  JVRP(286) = V(59)
! JVRP(287) = dARP(170)/dV(59)
  JVRP(287) = 1
! JVRP(288) = dARP(171)/dV(57)
  JVRP(288) = V(71)
! JVRP(289) = dARP(171)/dV(71)
  JVRP(289) = V(57)
! JVRP(290) = dARP(172)/dV(57)
  JVRP(290) = V(67)
! JVRP(291) = dARP(172)/dV(67)
  JVRP(291) = V(57)
! JVRP(292) = dARP(173)/dV(57)
  JVRP(292) = V(75)
! JVRP(293) = dARP(173)/dV(75)
  JVRP(293) = V(57)
! JVRP(294) = dARP(174)/dV(57)
  JVRP(294) = 1
! JVRP(295) = dARP(175)/dV(66)
  JVRP(295) = V(71)
! JVRP(296) = dARP(175)/dV(71)
  JVRP(296) = V(66)
! JVRP(297) = dARP(176)/dV(66)
  JVRP(297) = 1
! JVRP(298) = dARP(177)/dV(62)
  JVRP(298) = V(71)
! JVRP(299) = dARP(177)/dV(71)
  JVRP(299) = V(62)
! JVRP(300) = dARP(178)/dV(62)
  JVRP(300) = 1
! JVRP(301) = dARP(179)/dV(38)
  JVRP(301) = V(71)
! JVRP(302) = dARP(179)/dV(71)
  JVRP(302) = V(38)
! JVRP(303) = dARP(180)/dV(38)
  JVRP(303) = V(67)
! JVRP(304) = dARP(180)/dV(67)
  JVRP(304) = V(38)
! JVRP(305) = dARP(181)/dV(35)
  JVRP(305) = V(71)
! JVRP(306) = dARP(181)/dV(71)
  JVRP(306) = V(35)
! JVRP(307) = dARP(182)/dV(35)
  JVRP(307) = 1
! JVRP(308) = dARP(183)/dV(36)
  JVRP(308) = V(71)
! JVRP(309) = dARP(183)/dV(71)
  JVRP(309) = V(36)
! JVRP(310) = dARP(184)/dV(36)
  JVRP(310) = 1
! JVRP(311) = dARP(185)/dV(12)
  JVRP(311) = V(71)
! JVRP(312) = dARP(185)/dV(71)
  JVRP(312) = V(12)
! JVRP(313) = dARP(186)/dV(48)
  JVRP(313) = V(71)
! JVRP(314) = dARP(186)/dV(71)
  JVRP(314) = V(48)
! JVRP(315) = dARP(187)/dV(48)
  JVRP(315) = V(67)
! JVRP(316) = dARP(187)/dV(67)
  JVRP(316) = V(48)
! JVRP(317) = dARP(188)/dV(48)
  JVRP(317) = V(75)
! JVRP(318) = dARP(188)/dV(75)
  JVRP(318) = V(48)
! JVRP(319) = dARP(189)/dV(48)
  JVRP(319) = V(63)
! JVRP(320) = dARP(189)/dV(63)
  JVRP(320) = V(48)
! JVRP(321) = dARP(190)/dV(52)
  JVRP(321) = V(71)
! JVRP(322) = dARP(190)/dV(71)
  JVRP(322) = V(52)
! JVRP(323) = dARP(191)/dV(52)
  JVRP(323) = V(67)
! JVRP(324) = dARP(191)/dV(67)
  JVRP(324) = V(52)
! JVRP(325) = dARP(192)/dV(52)
  JVRP(325) = V(75)
! JVRP(326) = dARP(192)/dV(75)
  JVRP(326) = V(52)
! JVRP(327) = dARP(193)/dV(52)
  JVRP(327) = V(63)
! JVRP(328) = dARP(193)/dV(63)
  JVRP(328) = V(52)
! JVRP(329) = dARP(194)/dV(54)
  JVRP(329) = V(71)
! JVRP(330) = dARP(194)/dV(71)
  JVRP(330) = V(54)
! JVRP(331) = dARP(195)/dV(54)
  JVRP(331) = V(67)
! JVRP(332) = dARP(195)/dV(67)
  JVRP(332) = V(54)
! JVRP(333) = dARP(196)/dV(54)
  JVRP(333) = V(75)
! JVRP(334) = dARP(196)/dV(75)
  JVRP(334) = V(54)
! JVRP(335) = dARP(197)/dV(54)
  JVRP(335) = V(63)
! JVRP(336) = dARP(197)/dV(63)
  JVRP(336) = V(54)
! JVRP(337) = dARP(198)/dV(13)
  JVRP(337) = V(71)
! JVRP(338) = dARP(198)/dV(71)
  JVRP(338) = V(13)
! JVRP(339) = dARP(199)/dV(20)
  JVRP(339) = V(71)
! JVRP(340) = dARP(199)/dV(71)
  JVRP(340) = V(20)
! JVRP(341) = dARP(200)/dV(39)
  JVRP(341) = V(71)
! JVRP(342) = dARP(200)/dV(71)
  JVRP(342) = V(39)
! JVRP(343) = dARP(201)/dV(24)
  JVRP(343) = V(71)
! JVRP(344) = dARP(201)/dV(71)
  JVRP(344) = V(24)
! JVRP(345) = dARP(202)/dV(33)
  JVRP(345) = V(71)
! JVRP(346) = dARP(202)/dV(71)
  JVRP(346) = V(33)
! JVRP(347) = dARP(203)/dV(26)
  JVRP(347) = V(71)
! JVRP(348) = dARP(203)/dV(71)
  JVRP(348) = V(26)
! JVRP(349) = dARP(204)/dV(34)
  JVRP(349) = V(71)
! JVRP(350) = dARP(204)/dV(71)
  JVRP(350) = V(34)
! JVRP(351) = dARP(205)/dV(27)
  JVRP(351) = V(71)
! JVRP(352) = dARP(205)/dV(71)
  JVRP(352) = V(27)
! JVRP(353) = dARP(206)/dV(56)
  JVRP(353) = V(71)
! JVRP(354) = dARP(206)/dV(71)
  JVRP(354) = V(56)
! JVRP(355) = dARP(207)/dV(56)
  JVRP(355) = V(67)
! JVRP(356) = dARP(207)/dV(67)
  JVRP(356) = V(56)
! JVRP(357) = dARP(208)/dV(56)
  JVRP(357) = V(75)
! JVRP(358) = dARP(208)/dV(75)
  JVRP(358) = V(56)
! JVRP(359) = dARP(209)/dV(56)
  JVRP(359) = V(63)
! JVRP(360) = dARP(209)/dV(63)
  JVRP(360) = V(56)
! JVRP(361) = dARP(210)/dV(58)
  JVRP(361) = V(71)
! JVRP(362) = dARP(210)/dV(71)
  JVRP(362) = V(58)
! JVRP(363) = dARP(211)/dV(58)
  JVRP(363) = V(67)
! JVRP(364) = dARP(211)/dV(67)
  JVRP(364) = V(58)
! JVRP(365) = dARP(212)/dV(58)
  JVRP(365) = V(75)
! JVRP(366) = dARP(212)/dV(75)
  JVRP(366) = V(58)
! JVRP(367) = dARP(213)/dV(58)
  JVRP(367) = V(63)
! JVRP(368) = dARP(213)/dV(63)
  JVRP(368) = V(58)
! JVRP(369) = dARP(214)/dV(39)
  JVRP(369) = V(67)
! JVRP(370) = dARP(214)/dV(67)
  JVRP(370) = V(39)
! JVRP(371) = dARP(215)/dV(50)
  JVRP(371) = V(71)
! JVRP(372) = dARP(215)/dV(71)
  JVRP(372) = V(50)
! JVRP(373) = dARP(216)/dV(50)
  JVRP(373) = V(67)
! JVRP(374) = dARP(216)/dV(67)
  JVRP(374) = V(50)
! JVRP(375) = dARP(217)/dV(50)
  JVRP(375) = V(75)
! JVRP(376) = dARP(217)/dV(75)
  JVRP(376) = V(50)
! JVRP(377) = dARP(218)/dV(50)
  JVRP(377) = V(63)
! JVRP(378) = dARP(218)/dV(63)
  JVRP(378) = V(50)
! JVRP(379) = dARP(219)/dV(10)
  JVRP(379) = 1
! JVRP(380) = dARP(220)/dV(78)
  JVRP(380) = 1
! JVRP(381) = dARP(221)/dV(10)
  JVRP(381) = 1
! JVRP(382) = dARP(222)/dV(1)
  JVRP(382) = 1
! JVRP(383) = dARP(223)/dV(47)
  JVRP(383) = 1
! JVRP(384) = dARP(224)/dV(19)
  JVRP(384) = 1
! JVRP(385) = dARP(225)/dV(2)
  JVRP(385) = 1
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE SAPRC99_Parameters
      USE SAPRC99_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE SAPRC99_Parameters
      USE SAPRC99_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE SAPRC99_Stoichiom

