! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : SAPRC99_LinearAlgebra.f90
! Time                 : Thu Oct  8 08:22:39 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_SAPRC99_30885_BOXMOX
! Equation file        : SAPRC99.kpp
! Output root filename : SAPRC99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE SAPRC99_LinearAlgebra

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE SAPRC99_Parameters
!  USE SAPRC99_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE SAPRC99_Parameters
!  USE SAPRC99_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE SAPRC99_Parameters
!  USE SAPRC99_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(25) = X(25)-JVS(109)*X(24)
  X(35) = X(35)-JVS(143)*X(27)-JVS(144)*X(34)
  X(36) = X(36)-JVS(147)*X(27)-JVS(148)*X(34)
  X(37) = X(37)-JVS(151)*X(27)-JVS(152)*X(34)
  X(38) = X(38)-JVS(156)*X(27)-JVS(157)*X(34)
  X(40) = X(40)-JVS(164)*X(31)
  X(41) = X(41)-JVS(170)*X(27)-JVS(171)*X(34)
  X(43) = X(43)-JVS(182)*X(34)
  X(44) = X(44)-JVS(188)*X(27)-JVS(189)*X(34)-JVS(190)*X(35)-JVS(191)*X(36)-JVS(192)*X(37)
  X(45) = X(45)-JVS(200)*X(33)-JVS(201)*X(35)-JVS(202)*X(36)-JVS(203)*X(38)-JVS(204)*X(39)-JVS(205)*X(44)
  X(46) = X(46)-JVS(224)*X(20)-JVS(225)*X(24)-JVS(226)*X(25)-JVS(227)*X(26)-JVS(228)*X(33)
  X(47) = X(47)-JVS(238)*X(22)-JVS(239)*X(37)-JVS(240)*X(40)-JVS(241)*X(41)-JVS(242)*X(43)-JVS(243)*X(44)
  X(49) = X(49)-JVS(264)*X(27)-JVS(265)*X(34)-JVS(266)*X(35)-JVS(267)*X(36)-JVS(268)*X(38)-JVS(269)*X(39)-JVS(270)*X(43)&
            &-JVS(271)*X(48)
  X(51) = X(51)-JVS(286)*X(37)-JVS(287)*X(43)
  X(53) = X(53)-JVS(303)*X(24)-JVS(304)*X(26)-JVS(305)*X(33)-JVS(306)*X(35)-JVS(307)*X(36)-JVS(308)*X(46)-JVS(309)*X(52)
  X(55) = X(55)-JVS(337)*X(52)
  X(57) = X(57)-JVS(349)*X(52)
  X(59) = X(59)-JVS(361)*X(52)-JVS(362)*X(58)
  X(60) = X(60)-JVS(368)*X(13)-JVS(369)*X(21)-JVS(370)*X(24)-JVS(371)*X(26)-JVS(372)*X(33)-JVS(373)*X(48)-JVS(374)*X(50)&
            &-JVS(375)*X(56)-JVS(376)*X(57)-JVS(377)*X(58)
  X(61) = X(61)-JVS(392)*X(21)-JVS(393)*X(24)-JVS(394)*X(26)-JVS(395)*X(28)-JVS(396)*X(29)-JVS(397)*X(30)-JVS(398)*X(33)&
            &-JVS(399)*X(39)-JVS(400)*X(46)-JVS(401)*X(48)-JVS(402)*X(49)-JVS(403)*X(50)-JVS(404)*X(51)-JVS(405)*X(52)&
            &-JVS(406)*X(54)-JVS(407)*X(55)-JVS(408)*X(56)-JVS(409)*X(57)-JVS(410)*X(58)-JVS(411)*X(59)
  X(62) = X(62)-JVS(430)*X(25)-JVS(431)*X(54)-JVS(432)*X(56)-JVS(433)*X(57)-JVS(434)*X(58)
  X(63) = X(63)-JVS(443)*X(11)-JVS(444)*X(48)-JVS(445)*X(50)-JVS(446)*X(52)-JVS(447)*X(54)-JVS(448)*X(55)-JVS(449)*X(56)&
            &-JVS(450)*X(58)-JVS(451)*X(59)
  X(64) = X(64)-JVS(458)*X(20)-JVS(459)*X(24)-JVS(460)*X(26)-JVS(461)*X(33)-JVS(462)*X(35)-JVS(463)*X(36)-JVS(464)*X(38)&
            &-JVS(465)*X(42)-JVS(466)*X(48)-JVS(467)*X(50)-JVS(468)*X(54)-JVS(469)*X(55)-JVS(470)*X(56)-JVS(471)*X(57)&
            &-JVS(472)*X(58)-JVS(473)*X(59)-JVS(474)*X(62)-JVS(475)*X(63)
  X(65) = X(65)-JVS(487)*X(24)-JVS(488)*X(26)-JVS(489)*X(33)-JVS(490)*X(50)-JVS(491)*X(55)-JVS(492)*X(56)-JVS(493)*X(57)&
            &-JVS(494)*X(58)-JVS(495)*X(59)-JVS(496)*X(62)-JVS(497)*X(63)
  X(66) = X(66)-JVS(508)*X(26)-JVS(509)*X(33)-JVS(510)*X(34)-JVS(511)*X(52)-JVS(512)*X(54)-JVS(513)*X(56)-JVS(514)*X(57)&
            &-JVS(515)*X(58)-JVS(516)*X(59)-JVS(517)*X(62)-JVS(518)*X(63)
  X(67) = X(67)-JVS(531)*X(38)-JVS(532)*X(39)-JVS(533)*X(48)-JVS(534)*X(50)-JVS(535)*X(52)-JVS(536)*X(54)-JVS(537)*X(55)&
            &-JVS(538)*X(56)-JVS(539)*X(57)-JVS(540)*X(58)-JVS(541)*X(59)-JVS(542)*X(63)
  X(68) = X(68)-JVS(553)*X(14)-JVS(554)*X(15)-JVS(555)*X(27)-JVS(556)*X(33)-JVS(557)*X(35)-JVS(558)*X(36)-JVS(559)*X(44)&
            &-JVS(560)*X(46)-JVS(561)*X(54)-JVS(562)*X(55)-JVS(563)*X(56)-JVS(564)*X(57)-JVS(565)*X(58)-JVS(566)*X(59)&
            &-JVS(567)*X(60)-JVS(568)*X(62)-JVS(569)*X(63)-JVS(570)*X(64)-JVS(571)*X(65)-JVS(572)*X(66)-JVS(573)*X(67)
  X(69) = X(69)-JVS(586)*X(20)-JVS(587)*X(24)-JVS(588)*X(26)-JVS(589)*X(27)-JVS(590)*X(33)-JVS(591)*X(34)-JVS(592)*X(50)&
            &-JVS(593)*X(52)-JVS(594)*X(54)-JVS(595)*X(56)-JVS(596)*X(57)-JVS(597)*X(58)-JVS(598)*X(59)-JVS(599)*X(62)&
            &-JVS(600)*X(63)-JVS(601)*X(64)-JVS(602)*X(65)-JVS(603)*X(66)-JVS(604)*X(67)-JVS(605)*X(68)
  X(70) = X(70)-JVS(617)*X(18)-JVS(618)*X(52)-JVS(619)*X(55)-JVS(620)*X(57)-JVS(621)*X(58)-JVS(622)*X(59)-JVS(623)*X(63)&
            &-JVS(624)*X(67)-JVS(625)*X(68)-JVS(626)*X(69)
  X(71) = X(71)-JVS(637)*X(10)-JVS(638)*X(11)-JVS(639)*X(12)-JVS(640)*X(13)-JVS(641)*X(19)-JVS(642)*X(20)-JVS(643)*X(21)&
            &-JVS(644)*X(23)-JVS(645)*X(24)-JVS(646)*X(26)-JVS(647)*X(27)-JVS(648)*X(28)-JVS(649)*X(29)-JVS(650)*X(32)&
            &-JVS(651)*X(33)-JVS(652)*X(34)-JVS(653)*X(35)-JVS(654)*X(36)-JVS(655)*X(37)-JVS(656)*X(38)-JVS(657)*X(39)&
            &-JVS(658)*X(41)-JVS(659)*X(42)-JVS(660)*X(43)-JVS(661)*X(44)-JVS(662)*X(45)-JVS(663)*X(46)-JVS(664)*X(47)&
            &-JVS(665)*X(48)-JVS(666)*X(49)-JVS(667)*X(50)-JVS(668)*X(51)-JVS(669)*X(52)-JVS(670)*X(54)-JVS(671)*X(55)&
            &-JVS(672)*X(56)-JVS(673)*X(57)-JVS(674)*X(58)-JVS(675)*X(59)-JVS(676)*X(60)-JVS(677)*X(61)-JVS(678)*X(62)&
            &-JVS(679)*X(63)-JVS(680)*X(64)-JVS(681)*X(65)-JVS(682)*X(66)-JVS(683)*X(67)-JVS(684)*X(68)-JVS(685)*X(69)&
            &-JVS(686)*X(70)
  X(72) = X(72)-JVS(696)*X(16)-JVS(697)*X(49)-JVS(698)*X(51)-JVS(699)*X(54)-JVS(700)*X(55)-JVS(701)*X(57)-JVS(702)*X(58)&
            &-JVS(703)*X(59)-JVS(704)*X(63)-JVS(705)*X(64)-JVS(706)*X(65)-JVS(707)*X(66)-JVS(708)*X(67)-JVS(709)*X(68)&
            &-JVS(710)*X(69)-JVS(711)*X(70)-JVS(712)*X(71)
  X(73) = X(73)-JVS(721)*X(23)-JVS(722)*X(30)-JVS(723)*X(53)-JVS(724)*X(54)-JVS(725)*X(56)-JVS(726)*X(58)-JVS(727)*X(59)&
            &-JVS(728)*X(61)-JVS(729)*X(62)-JVS(730)*X(63)-JVS(731)*X(65)-JVS(732)*X(66)-JVS(733)*X(67)-JVS(734)*X(68)&
            &-JVS(735)*X(69)-JVS(736)*X(70)-JVS(737)*X(71)-JVS(738)*X(72)
  X(74) = X(74)-JVS(746)*X(15)-JVS(747)*X(16)-JVS(748)*X(17)-JVS(749)*X(18)-JVS(750)*X(22)-JVS(751)*X(23)-JVS(752)*X(25)&
            &-JVS(753)*X(30)-JVS(754)*X(31)-JVS(755)*X(32)-JVS(756)*X(40)-JVS(757)*X(47)-JVS(758)*X(49)-JVS(759)*X(51)&
            &-JVS(760)*X(52)-JVS(761)*X(53)-JVS(762)*X(54)-JVS(763)*X(55)-JVS(764)*X(56)-JVS(765)*X(57)-JVS(766)*X(58)&
            &-JVS(767)*X(59)-JVS(768)*X(60)-JVS(769)*X(61)-JVS(770)*X(62)-JVS(771)*X(63)-JVS(772)*X(64)-JVS(773)*X(65)&
            &-JVS(774)*X(66)-JVS(775)*X(67)-JVS(776)*X(68)-JVS(777)*X(69)-JVS(778)*X(70)-JVS(779)*X(71)-JVS(780)*X(72)&
            &-JVS(781)*X(73)
  X(75) = X(75)-JVS(788)*X(22)-JVS(789)*X(32)-JVS(790)*X(37)-JVS(791)*X(40)-JVS(792)*X(41)-JVS(793)*X(43)-JVS(794)*X(44)&
            &-JVS(795)*X(47)-JVS(796)*X(48)-JVS(797)*X(49)-JVS(798)*X(50)-JVS(799)*X(51)-JVS(800)*X(52)-JVS(801)*X(53)&
            &-JVS(802)*X(54)-JVS(803)*X(55)-JVS(804)*X(56)-JVS(805)*X(57)-JVS(806)*X(58)-JVS(807)*X(59)-JVS(808)*X(60)&
            &-JVS(809)*X(61)-JVS(810)*X(62)-JVS(811)*X(63)-JVS(812)*X(64)-JVS(813)*X(65)-JVS(814)*X(66)-JVS(815)*X(67)&
            &-JVS(816)*X(68)-JVS(817)*X(69)-JVS(818)*X(70)-JVS(819)*X(71)-JVS(820)*X(72)-JVS(821)*X(73)-JVS(822)*X(74)
  X(76) = X(76)-JVS(828)*X(12)-JVS(829)*X(25)-JVS(830)*X(29)-JVS(831)*X(33)-JVS(832)*X(46)-JVS(833)*X(48)-JVS(834)*X(50)&
            &-JVS(835)*X(52)-JVS(836)*X(54)-JVS(837)*X(56)-JVS(838)*X(58)-JVS(839)*X(59)-JVS(840)*X(60)-JVS(841)*X(62)&
            &-JVS(842)*X(63)-JVS(843)*X(64)-JVS(844)*X(65)-JVS(845)*X(66)-JVS(846)*X(67)-JVS(847)*X(68)-JVS(848)*X(69)&
            &-JVS(849)*X(70)-JVS(850)*X(71)-JVS(851)*X(72)-JVS(852)*X(73)-JVS(853)*X(74)-JVS(854)*X(75)
  X(77) = X(77)-JVS(859)*X(13)-JVS(860)*X(20)-JVS(861)*X(21)-JVS(862)*X(24)-JVS(863)*X(26)-JVS(864)*X(27)-JVS(865)*X(33)&
            &-JVS(866)*X(34)-JVS(867)*X(35)-JVS(868)*X(36)-JVS(869)*X(37)-JVS(870)*X(38)-JVS(871)*X(39)-JVS(872)*X(42)&
            &-JVS(873)*X(43)-JVS(874)*X(48)-JVS(875)*X(50)-JVS(876)*X(51)-JVS(877)*X(52)-JVS(878)*X(54)-JVS(879)*X(55)&
            &-JVS(880)*X(56)-JVS(881)*X(57)-JVS(882)*X(58)-JVS(883)*X(59)-JVS(884)*X(62)-JVS(885)*X(63)-JVS(886)*X(64)&
            &-JVS(887)*X(65)-JVS(888)*X(66)-JVS(889)*X(67)-JVS(890)*X(68)-JVS(891)*X(69)-JVS(892)*X(70)-JVS(893)*X(71)&
            &-JVS(894)*X(72)-JVS(895)*X(73)-JVS(896)*X(74)-JVS(897)*X(75)-JVS(898)*X(76)
  X(78) = X(78)-JVS(902)*X(10)-JVS(903)*X(19)-JVS(904)*X(21)-JVS(905)*X(23)-JVS(906)*X(27)-JVS(907)*X(28)-JVS(908)*X(29)&
            &-JVS(909)*X(30)-JVS(910)*X(31)-JVS(911)*X(32)-JVS(912)*X(34)-JVS(913)*X(35)-JVS(914)*X(36)-JVS(915)*X(38)&
            &-JVS(916)*X(39)-JVS(917)*X(40)-JVS(918)*X(42)-JVS(919)*X(44)-JVS(920)*X(45)-JVS(921)*X(48)-JVS(922)*X(49)&
            &-JVS(923)*X(50)-JVS(924)*X(51)-JVS(925)*X(52)-JVS(926)*X(54)-JVS(927)*X(55)-JVS(928)*X(56)-JVS(929)*X(57)&
            &-JVS(930)*X(58)-JVS(931)*X(59)-JVS(932)*X(60)-JVS(933)*X(61)-JVS(934)*X(62)-JVS(935)*X(63)-JVS(936)*X(64)&
            &-JVS(937)*X(65)-JVS(938)*X(66)-JVS(939)*X(67)-JVS(940)*X(68)-JVS(941)*X(69)-JVS(942)*X(70)-JVS(943)*X(71)&
            &-JVS(944)*X(72)-JVS(945)*X(73)-JVS(946)*X(74)-JVS(947)*X(75)-JVS(948)*X(76)-JVS(949)*X(77)
  X(79) = X(79)-JVS(952)*X(17)-JVS(953)*X(41)-JVS(954)*X(58)-JVS(955)*X(63)-JVS(956)*X(67)-JVS(957)*X(68)-JVS(958)*X(69)&
            &-JVS(959)*X(70)-JVS(960)*X(71)-JVS(961)*X(72)-JVS(962)*X(73)-JVS(963)*X(74)-JVS(964)*X(75)-JVS(965)*X(76)&
            &-JVS(966)*X(77)-JVS(967)*X(78)
  X(79) = X(79)/JVS(968)
  X(78) = (X(78)-JVS(951)*X(79))/(JVS(950))
  X(77) = (X(77)-JVS(900)*X(78)-JVS(901)*X(79))/(JVS(899))
  X(76) = (X(76)-JVS(856)*X(77)-JVS(857)*X(78)-JVS(858)*X(79))/(JVS(855))
  X(75) = (X(75)-JVS(824)*X(76)-JVS(825)*X(77)-JVS(826)*X(78)-JVS(827)*X(79))/(JVS(823))
  X(74) = (X(74)-JVS(783)*X(75)-JVS(784)*X(76)-JVS(785)*X(77)-JVS(786)*X(78)-JVS(787)*X(79))/(JVS(782))
  X(73) = (X(73)-JVS(740)*X(74)-JVS(741)*X(75)-JVS(742)*X(76)-JVS(743)*X(77)-JVS(744)*X(78)-JVS(745)*X(79))/(JVS(739))
  X(72) = (X(72)-JVS(714)*X(73)-JVS(715)*X(74)-JVS(716)*X(75)-JVS(717)*X(76)-JVS(718)*X(77)-JVS(719)*X(78)-JVS(720)&
            &*X(79))/(JVS(713))
  X(71) = (X(71)-JVS(688)*X(72)-JVS(689)*X(73)-JVS(690)*X(74)-JVS(691)*X(75)-JVS(692)*X(76)-JVS(693)*X(77)-JVS(694)&
            &*X(78)-JVS(695)*X(79))/(JVS(687))
  X(70) = (X(70)-JVS(628)*X(71)-JVS(629)*X(72)-JVS(630)*X(73)-JVS(631)*X(74)-JVS(632)*X(75)-JVS(633)*X(76)-JVS(634)&
            &*X(77)-JVS(635)*X(78)-JVS(636)*X(79))/(JVS(627))
  X(69) = (X(69)-JVS(607)*X(70)-JVS(608)*X(71)-JVS(609)*X(72)-JVS(610)*X(73)-JVS(611)*X(74)-JVS(612)*X(75)-JVS(613)&
            &*X(76)-JVS(614)*X(77)-JVS(615)*X(78)-JVS(616)*X(79))/(JVS(606))
  X(68) = (X(68)-JVS(575)*X(69)-JVS(576)*X(70)-JVS(577)*X(71)-JVS(578)*X(72)-JVS(579)*X(73)-JVS(580)*X(74)-JVS(581)&
            &*X(75)-JVS(582)*X(76)-JVS(583)*X(77)-JVS(584)*X(78)-JVS(585)*X(79))/(JVS(574))
  X(67) = (X(67)-JVS(544)*X(68)-JVS(545)*X(70)-JVS(546)*X(71)-JVS(547)*X(72)-JVS(548)*X(73)-JVS(549)*X(74)-JVS(550)&
            &*X(75)-JVS(551)*X(78)-JVS(552)*X(79))/(JVS(543))
  X(66) = (X(66)-JVS(520)*X(67)-JVS(521)*X(68)-JVS(522)*X(69)-JVS(523)*X(71)-JVS(524)*X(72)-JVS(525)*X(73)-JVS(526)&
            &*X(74)-JVS(527)*X(75)-JVS(528)*X(76)-JVS(529)*X(77)-JVS(530)*X(79))/(JVS(519))
  X(65) = (X(65)-JVS(499)*X(66)-JVS(500)*X(67)-JVS(501)*X(69)-JVS(502)*X(71)-JVS(503)*X(73)-JVS(504)*X(74)-JVS(505)&
            &*X(75)-JVS(506)*X(76)-JVS(507)*X(77))/(JVS(498))
  X(64) = (X(64)-JVS(477)*X(65)-JVS(478)*X(66)-JVS(479)*X(67)-JVS(480)*X(69)-JVS(481)*X(71)-JVS(482)*X(73)-JVS(483)&
            &*X(74)-JVS(484)*X(75)-JVS(485)*X(77)-JVS(486)*X(78))/(JVS(476))
  X(63) = (X(63)-JVS(453)*X(67)-JVS(454)*X(71)-JVS(455)*X(73)-JVS(456)*X(74)-JVS(457)*X(75))/(JVS(452))
  X(62) = (X(62)-JVS(436)*X(63)-JVS(437)*X(67)-JVS(438)*X(69)-JVS(439)*X(71)-JVS(440)*X(73)-JVS(441)*X(74)-JVS(442)&
            &*X(75))/(JVS(435))
  X(61) = (X(61)-JVS(413)*X(62)-JVS(414)*X(63)-JVS(415)*X(65)-JVS(416)*X(66)-JVS(417)*X(67)-JVS(418)*X(68)-JVS(419)&
            &*X(69)-JVS(420)*X(70)-JVS(421)*X(71)-JVS(422)*X(72)-JVS(423)*X(73)-JVS(424)*X(74)-JVS(425)*X(75)-JVS(426)*X(76)&
            &-JVS(427)*X(77)-JVS(428)*X(78)-JVS(429)*X(79))/(JVS(412))
  X(60) = (X(60)-JVS(379)*X(62)-JVS(380)*X(63)-JVS(381)*X(64)-JVS(382)*X(65)-JVS(383)*X(66)-JVS(384)*X(67)-JVS(385)&
            &*X(68)-JVS(386)*X(70)-JVS(387)*X(71)-JVS(388)*X(72)-JVS(389)*X(73)-JVS(390)*X(75)-JVS(391)*X(79))/(JVS(378))
  X(59) = (X(59)-JVS(364)*X(63)-JVS(365)*X(67)-JVS(366)*X(71)-JVS(367)*X(75))/(JVS(363))
  X(58) = (X(58)-JVS(357)*X(63)-JVS(358)*X(67)-JVS(359)*X(71)-JVS(360)*X(75))/(JVS(356))
  X(57) = (X(57)-JVS(351)*X(58)-JVS(352)*X(63)-JVS(353)*X(67)-JVS(354)*X(71)-JVS(355)*X(75))/(JVS(350))
  X(56) = (X(56)-JVS(345)*X(63)-JVS(346)*X(67)-JVS(347)*X(71)-JVS(348)*X(75))/(JVS(344))
  X(55) = (X(55)-JVS(339)*X(58)-JVS(340)*X(63)-JVS(341)*X(67)-JVS(342)*X(71)-JVS(343)*X(75))/(JVS(338))
  X(54) = (X(54)-JVS(333)*X(63)-JVS(334)*X(67)-JVS(335)*X(71)-JVS(336)*X(75))/(JVS(332))
  X(53) = (X(53)-JVS(311)*X(54)-JVS(312)*X(56)-JVS(313)*X(58)-JVS(314)*X(59)-JVS(315)*X(62)-JVS(316)*X(63)-JVS(317)&
            &*X(65)-JVS(318)*X(66)-JVS(319)*X(67)-JVS(320)*X(68)-JVS(321)*X(69)-JVS(322)*X(70)-JVS(323)*X(71)-JVS(324)*X(72)&
            &-JVS(325)*X(73)-JVS(326)*X(74)-JVS(327)*X(75)-JVS(328)*X(76)-JVS(329)*X(77)-JVS(330)*X(78)-JVS(331)*X(79))&
            &/(JVS(310))
  X(52) = (X(52)-JVS(299)*X(63)-JVS(300)*X(67)-JVS(301)*X(71)-JVS(302)*X(75))/(JVS(298))
  X(51) = (X(51)-JVS(289)*X(68)-JVS(290)*X(70)-JVS(291)*X(71)-JVS(292)*X(72)-JVS(293)*X(73)-JVS(294)*X(74)-JVS(295)&
            &*X(75)-JVS(296)*X(78)-JVS(297)*X(79))/(JVS(288))
  X(50) = (X(50)-JVS(282)*X(63)-JVS(283)*X(67)-JVS(284)*X(71)-JVS(285)*X(75))/(JVS(281))
  X(49) = (X(49)-JVS(273)*X(51)-JVS(274)*X(54)-JVS(275)*X(57)-JVS(276)*X(63)-JVS(277)*X(67)-JVS(278)*X(71)-JVS(279)&
            &*X(75)-JVS(280)*X(78))/(JVS(272))
  X(48) = (X(48)-JVS(260)*X(63)-JVS(261)*X(67)-JVS(262)*X(71)-JVS(263)*X(75))/(JVS(259))
  X(47) = (X(47)-JVS(245)*X(49)-JVS(246)*X(51)-JVS(247)*X(55)-JVS(248)*X(57)-JVS(249)*X(58)-JVS(250)*X(59)-JVS(251)&
            &*X(60)-JVS(252)*X(61)-JVS(253)*X(64)-JVS(254)*X(67)-JVS(255)*X(71)-JVS(256)*X(74)-JVS(257)*X(75)-JVS(258)&
            &*X(78))/(JVS(244))
  X(46) = (X(46)-JVS(230)*X(54)-JVS(231)*X(56)-JVS(232)*X(58)-JVS(233)*X(62)-JVS(234)*X(67)-JVS(235)*X(71)-JVS(236)&
            &*X(74)-JVS(237)*X(75))/(JVS(229))
  X(45) = (X(45)-JVS(207)*X(48)-JVS(208)*X(49)-JVS(209)*X(50)-JVS(210)*X(52)-JVS(211)*X(54)-JVS(212)*X(55)-JVS(213)&
            &*X(56)-JVS(214)*X(57)-JVS(215)*X(58)-JVS(216)*X(59)-JVS(217)*X(60)-JVS(218)*X(61)-JVS(219)*X(63)-JVS(220)*X(64)&
            &-JVS(221)*X(67)-JVS(222)*X(71)-JVS(223)*X(75))/(JVS(206))
  X(44) = (X(44)-JVS(194)*X(55)-JVS(195)*X(57)-JVS(196)*X(59)-JVS(197)*X(67)-JVS(198)*X(71)-JVS(199)*X(75))/(JVS(193))
  X(43) = (X(43)-JVS(184)*X(51)-JVS(185)*X(71)-JVS(186)*X(75)-JVS(187)*X(78))/(JVS(183))
  X(42) = (X(42)-JVS(178)*X(69)-JVS(179)*X(71)-JVS(180)*X(77)-JVS(181)*X(78))/(JVS(177))
  X(41) = (X(41)-JVS(173)*X(58)-JVS(174)*X(67)-JVS(175)*X(71)-JVS(176)*X(75))/(JVS(172))
  X(40) = (X(40)-JVS(166)*X(51)-JVS(167)*X(74)-JVS(168)*X(75)-JVS(169)*X(78))/(JVS(165))
  X(39) = (X(39)-JVS(162)*X(67)-JVS(163)*X(71))/(JVS(161))
  X(38) = (X(38)-JVS(159)*X(67)-JVS(160)*X(71))/(JVS(158))
  X(37) = (X(37)-JVS(154)*X(71)-JVS(155)*X(75))/(JVS(153))
  X(36) = (X(36)-JVS(150)*X(71))/(JVS(149))
  X(35) = (X(35)-JVS(146)*X(71))/(JVS(145))
  X(34) = (X(34)-JVS(142)*X(71))/(JVS(141))
  X(33) = (X(33)-JVS(140)*X(71))/(JVS(139))
  X(32) = (X(32)-JVS(136)*X(71)-JVS(137)*X(74)-JVS(138)*X(78))/(JVS(135))
  X(31) = (X(31)-JVS(131)*X(40)-JVS(132)*X(74)-JVS(133)*X(75)-JVS(134)*X(78))/(JVS(130))
  X(30) = (X(30)-JVS(127)*X(61)-JVS(128)*X(73)-JVS(129)*X(78))/(JVS(126))
  X(29) = (X(29)-JVS(123)*X(71)-JVS(124)*X(76)-JVS(125)*X(78))/(JVS(122))
  X(28) = (X(28)-JVS(118)*X(69)-JVS(119)*X(71)-JVS(120)*X(76)-JVS(121)*X(77))/(JVS(117))
  X(27) = (X(27)-JVS(116)*X(71))/(JVS(115))
  X(26) = (X(26)-JVS(114)*X(71))/(JVS(113))
  X(25) = (X(25)-JVS(111)*X(71)-JVS(112)*X(74))/(JVS(110))
  X(24) = (X(24)-JVS(108)*X(71))/(JVS(107))
  X(23) = (X(23)-JVS(105)*X(71)-JVS(106)*X(73))/(JVS(104))
  X(22) = (X(22)-JVS(102)*X(74)-JVS(103)*X(75))/(JVS(101))
  X(21) = (X(21)-JVS(100)*X(71))/(JVS(99))
  X(20) = (X(20)-JVS(98)*X(71))/(JVS(97))
  X(19) = (X(19)-JVS(95)*X(71)-JVS(96)*X(78))/(JVS(94))
  X(18) = (X(18)-JVS(92)*X(70)-JVS(93)*X(74))/(JVS(91))
  X(17) = (X(17)-JVS(89)*X(74)-JVS(90)*X(79))/(JVS(88))
  X(16) = (X(16)-JVS(86)*X(72)-JVS(87)*X(74))/(JVS(85))
  X(15) = (X(15)-JVS(83)*X(68)-JVS(84)*X(74))/(JVS(82))
  X(14) = (X(14)-JVS(78)*X(27)-JVS(79)*X(54)-JVS(80)*X(67)-JVS(81)*X(71))/(JVS(77))
  X(13) = (X(13)-JVS(76)*X(71))/(JVS(75))
  X(12) = (X(12)-JVS(74)*X(71))/(JVS(73))
  X(11) = (X(11)-JVS(72)*X(67))/(JVS(71))
  X(10) = (X(10)-JVS(70)*X(71))/(JVS(69))
  X(9) = (X(9)-JVS(61)*X(31)-JVS(62)*X(41)-JVS(63)*X(50)-JVS(64)*X(63)-JVS(65)*X(67)-JVS(66)*X(71)-JVS(67)*X(74)-JVS(68)&
           &*X(75))/(JVS(60))
  X(8) = (X(8)-JVS(56)*X(31)-JVS(57)*X(50)-JVS(58)*X(74)-JVS(59)*X(75))/(JVS(55))
  X(7) = (X(7)-JVS(51)*X(70)-JVS(52)*X(72)-JVS(53)*X(78)-JVS(54)*X(79))/(JVS(50))
  X(6) = (X(6)-JVS(48)*X(68)-JVS(49)*X(78))/(JVS(47))
  X(5) = (X(5)-JVS(34)*X(52)-JVS(35)*X(54)-JVS(36)*X(56)-JVS(37)*X(57)-JVS(38)*X(58)-JVS(39)*X(67)-JVS(40)*X(69)-JVS(41)&
           &*X(70)-JVS(42)*X(72)-JVS(43)*X(76)-JVS(44)*X(77)-JVS(45)*X(78)-JVS(46)*X(79))/(JVS(33))
  X(4) = (X(4)-JVS(24)*X(50)-JVS(25)*X(56)-JVS(26)*X(58)-JVS(27)*X(67)-JVS(28)*X(68)-JVS(29)*X(69)-JVS(30)*X(76)-JVS(31)&
           &*X(77)-JVS(32)*X(78))/(JVS(23))
  X(3) = (X(3)-JVS(9)*X(30)-JVS(10)*X(39)-JVS(11)*X(48)-JVS(12)*X(50)-JVS(13)*X(52)-JVS(14)*X(54)-JVS(15)*X(55)-JVS(16)&
           &*X(56)-JVS(17)*X(57)-JVS(18)*X(58)-JVS(19)*X(59)-JVS(20)*X(67)-JVS(21)*X(71)-JVS(22)*X(73))/(JVS(8))
  X(2) = (X(2)-JVS(5)*X(39)-JVS(6)*X(50)-JVS(7)*X(67))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(10)-JVS(3)*X(71))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(8)
  XX(4) = X(4)/JVS(23)
  XX(5) = X(5)/JVS(33)
  XX(6) = X(6)/JVS(47)
  XX(7) = X(7)/JVS(50)
  XX(8) = X(8)/JVS(55)
  XX(9) = X(9)/JVS(60)
  XX(10) = (X(10)-JVS(2)*XX(1))/(JVS(69))
  XX(11) = X(11)/JVS(71)
  XX(12) = X(12)/JVS(73)
  XX(13) = X(13)/JVS(75)
  XX(14) = X(14)/JVS(77)
  XX(15) = X(15)/JVS(82)
  XX(16) = X(16)/JVS(85)
  XX(17) = X(17)/JVS(88)
  XX(18) = X(18)/JVS(91)
  XX(19) = X(19)/JVS(94)
  XX(20) = X(20)/JVS(97)
  XX(21) = X(21)/JVS(99)
  XX(22) = X(22)/JVS(101)
  XX(23) = X(23)/JVS(104)
  XX(24) = X(24)/JVS(107)
  XX(25) = X(25)/JVS(110)
  XX(26) = X(26)/JVS(113)
  XX(27) = (X(27)-JVS(78)*XX(14))/(JVS(115))
  XX(28) = X(28)/JVS(117)
  XX(29) = X(29)/JVS(122)
  XX(30) = (X(30)-JVS(9)*XX(3))/(JVS(126))
  XX(31) = (X(31)-JVS(56)*XX(8)-JVS(61)*XX(9))/(JVS(130))
  XX(32) = X(32)/JVS(135)
  XX(33) = X(33)/JVS(139)
  XX(34) = X(34)/JVS(141)
  XX(35) = X(35)/JVS(145)
  XX(36) = X(36)/JVS(149)
  XX(37) = X(37)/JVS(153)
  XX(38) = X(38)/JVS(158)
  XX(39) = (X(39)-JVS(5)*XX(2)-JVS(10)*XX(3))/(JVS(161))
  XX(40) = (X(40)-JVS(131)*XX(31))/(JVS(165))
  XX(41) = (X(41)-JVS(62)*XX(9))/(JVS(172))
  XX(42) = X(42)/JVS(177)
  XX(43) = X(43)/JVS(183)
  XX(44) = X(44)/JVS(193)
  XX(45) = X(45)/JVS(206)
  XX(46) = X(46)/JVS(229)
  XX(47) = X(47)/JVS(244)
  XX(48) = (X(48)-JVS(11)*XX(3)-JVS(207)*XX(45))/(JVS(259))
  XX(49) = (X(49)-JVS(208)*XX(45)-JVS(245)*XX(47))/(JVS(272))
  XX(50) = (X(50)-JVS(6)*XX(2)-JVS(12)*XX(3)-JVS(24)*XX(4)-JVS(57)*XX(8)-JVS(63)*XX(9)-JVS(209)*XX(45))/(JVS(281))
  XX(51) = (X(51)-JVS(166)*XX(40)-JVS(184)*XX(43)-JVS(246)*XX(47)-JVS(273)*XX(49))/(JVS(288))
  XX(52) = (X(52)-JVS(13)*XX(3)-JVS(34)*XX(5)-JVS(210)*XX(45))/(JVS(298))
  XX(53) = X(53)/JVS(310)
  XX(54) = (X(54)-JVS(14)*XX(3)-JVS(35)*XX(5)-JVS(79)*XX(14)-JVS(211)*XX(45)-JVS(230)*XX(46)-JVS(274)*XX(49)-JVS(311)&
             &*XX(53))/(JVS(332))
  XX(55) = (X(55)-JVS(15)*XX(3)-JVS(194)*XX(44)-JVS(212)*XX(45)-JVS(247)*XX(47))/(JVS(338))
  XX(56) = (X(56)-JVS(16)*XX(3)-JVS(25)*XX(4)-JVS(36)*XX(5)-JVS(213)*XX(45)-JVS(231)*XX(46)-JVS(312)*XX(53))/(JVS(344))
  XX(57) = (X(57)-JVS(17)*XX(3)-JVS(37)*XX(5)-JVS(195)*XX(44)-JVS(214)*XX(45)-JVS(248)*XX(47)-JVS(275)*XX(49))&
             &/(JVS(350))
  XX(58) = (X(58)-JVS(18)*XX(3)-JVS(26)*XX(4)-JVS(38)*XX(5)-JVS(173)*XX(41)-JVS(215)*XX(45)-JVS(232)*XX(46)-JVS(249)&
             &*XX(47)-JVS(313)*XX(53)-JVS(339)*XX(55)-JVS(351)*XX(57))/(JVS(356))
  XX(59) = (X(59)-JVS(19)*XX(3)-JVS(196)*XX(44)-JVS(216)*XX(45)-JVS(250)*XX(47)-JVS(314)*XX(53))/(JVS(363))
  XX(60) = (X(60)-JVS(217)*XX(45)-JVS(251)*XX(47))/(JVS(378))
  XX(61) = (X(61)-JVS(127)*XX(30)-JVS(218)*XX(45)-JVS(252)*XX(47))/(JVS(412))
  XX(62) = (X(62)-JVS(233)*XX(46)-JVS(315)*XX(53)-JVS(379)*XX(60)-JVS(413)*XX(61))/(JVS(435))
  XX(63) = (X(63)-JVS(64)*XX(9)-JVS(219)*XX(45)-JVS(260)*XX(48)-JVS(276)*XX(49)-JVS(282)*XX(50)-JVS(299)*XX(52)-JVS(316)&
             &*XX(53)-JVS(333)*XX(54)-JVS(340)*XX(55)-JVS(345)*XX(56)-JVS(352)*XX(57)-JVS(357)*XX(58)-JVS(364)*XX(59)&
             &-JVS(380)*XX(60)-JVS(414)*XX(61)-JVS(436)*XX(62))/(JVS(452))
  XX(64) = (X(64)-JVS(220)*XX(45)-JVS(253)*XX(47)-JVS(381)*XX(60))/(JVS(476))
  XX(65) = (X(65)-JVS(317)*XX(53)-JVS(382)*XX(60)-JVS(415)*XX(61)-JVS(477)*XX(64))/(JVS(498))
  XX(66) = (X(66)-JVS(318)*XX(53)-JVS(383)*XX(60)-JVS(416)*XX(61)-JVS(478)*XX(64)-JVS(499)*XX(65))/(JVS(519))
  XX(67) = (X(67)-JVS(7)*XX(2)-JVS(20)*XX(3)-JVS(27)*XX(4)-JVS(39)*XX(5)-JVS(65)*XX(9)-JVS(72)*XX(11)-JVS(80)*XX(14)&
             &-JVS(159)*XX(38)-JVS(162)*XX(39)-JVS(174)*XX(41)-JVS(197)*XX(44)-JVS(221)*XX(45)-JVS(234)*XX(46)-JVS(254)&
             &*XX(47)-JVS(261)*XX(48)-JVS(277)*XX(49)-JVS(283)*XX(50)-JVS(300)*XX(52)-JVS(319)*XX(53)-JVS(334)*XX(54)&
             &-JVS(341)*XX(55)-JVS(346)*XX(56)-JVS(353)*XX(57)-JVS(358)*XX(58)-JVS(365)*XX(59)-JVS(384)*XX(60)-JVS(417)&
             &*XX(61)-JVS(437)*XX(62)-JVS(453)*XX(63)-JVS(479)*XX(64)-JVS(500)*XX(65)-JVS(520)*XX(66))/(JVS(543))
  XX(68) = (X(68)-JVS(28)*XX(4)-JVS(48)*XX(6)-JVS(83)*XX(15)-JVS(289)*XX(51)-JVS(320)*XX(53)-JVS(385)*XX(60)-JVS(418)&
             &*XX(61)-JVS(521)*XX(66)-JVS(544)*XX(67))/(JVS(574))
  XX(69) = (X(69)-JVS(29)*XX(4)-JVS(40)*XX(5)-JVS(118)*XX(28)-JVS(178)*XX(42)-JVS(321)*XX(53)-JVS(419)*XX(61)-JVS(438)&
             &*XX(62)-JVS(480)*XX(64)-JVS(501)*XX(65)-JVS(522)*XX(66)-JVS(575)*XX(68))/(JVS(606))
  XX(70) = (X(70)-JVS(41)*XX(5)-JVS(51)*XX(7)-JVS(92)*XX(18)-JVS(290)*XX(51)-JVS(322)*XX(53)-JVS(386)*XX(60)-JVS(420)&
             &*XX(61)-JVS(545)*XX(67)-JVS(576)*XX(68)-JVS(607)*XX(69))/(JVS(627))
  XX(71) = (X(71)-JVS(3)*XX(1)-JVS(21)*XX(3)-JVS(66)*XX(9)-JVS(70)*XX(10)-JVS(74)*XX(12)-JVS(76)*XX(13)-JVS(81)*XX(14)&
             &-JVS(95)*XX(19)-JVS(98)*XX(20)-JVS(100)*XX(21)-JVS(105)*XX(23)-JVS(108)*XX(24)-JVS(111)*XX(25)-JVS(114)*XX(26)&
             &-JVS(116)*XX(27)-JVS(119)*XX(28)-JVS(123)*XX(29)-JVS(136)*XX(32)-JVS(140)*XX(33)-JVS(142)*XX(34)-JVS(146)&
             &*XX(35)-JVS(150)*XX(36)-JVS(154)*XX(37)-JVS(160)*XX(38)-JVS(163)*XX(39)-JVS(175)*XX(41)-JVS(179)*XX(42)&
             &-JVS(185)*XX(43)-JVS(198)*XX(44)-JVS(222)*XX(45)-JVS(235)*XX(46)-JVS(255)*XX(47)-JVS(262)*XX(48)-JVS(278)&
             &*XX(49)-JVS(284)*XX(50)-JVS(291)*XX(51)-JVS(301)*XX(52)-JVS(323)*XX(53)-JVS(335)*XX(54)-JVS(342)*XX(55)&
             &-JVS(347)*XX(56)-JVS(354)*XX(57)-JVS(359)*XX(58)-JVS(366)*XX(59)-JVS(387)*XX(60)-JVS(421)*XX(61)-JVS(439)&
             &*XX(62)-JVS(454)*XX(63)-JVS(481)*XX(64)-JVS(502)*XX(65)-JVS(523)*XX(66)-JVS(546)*XX(67)-JVS(577)*XX(68)&
             &-JVS(608)*XX(69)-JVS(628)*XX(70))/(JVS(687))
  XX(72) = (X(72)-JVS(42)*XX(5)-JVS(52)*XX(7)-JVS(86)*XX(16)-JVS(292)*XX(51)-JVS(324)*XX(53)-JVS(388)*XX(60)-JVS(422)&
             &*XX(61)-JVS(524)*XX(66)-JVS(547)*XX(67)-JVS(578)*XX(68)-JVS(609)*XX(69)-JVS(629)*XX(70)-JVS(688)*XX(71))&
             &/(JVS(713))
  XX(73) = (X(73)-JVS(22)*XX(3)-JVS(106)*XX(23)-JVS(128)*XX(30)-JVS(293)*XX(51)-JVS(325)*XX(53)-JVS(389)*XX(60)-JVS(423)&
             &*XX(61)-JVS(440)*XX(62)-JVS(455)*XX(63)-JVS(482)*XX(64)-JVS(503)*XX(65)-JVS(525)*XX(66)-JVS(548)*XX(67)&
             &-JVS(579)*XX(68)-JVS(610)*XX(69)-JVS(630)*XX(70)-JVS(689)*XX(71)-JVS(714)*XX(72))/(JVS(739))
  XX(74) = (X(74)-JVS(58)*XX(8)-JVS(67)*XX(9)-JVS(84)*XX(15)-JVS(87)*XX(16)-JVS(89)*XX(17)-JVS(93)*XX(18)-JVS(102)&
             &*XX(22)-JVS(112)*XX(25)-JVS(132)*XX(31)-JVS(137)*XX(32)-JVS(167)*XX(40)-JVS(236)*XX(46)-JVS(256)*XX(47)&
             &-JVS(294)*XX(51)-JVS(326)*XX(53)-JVS(424)*XX(61)-JVS(441)*XX(62)-JVS(456)*XX(63)-JVS(483)*XX(64)-JVS(504)&
             &*XX(65)-JVS(526)*XX(66)-JVS(549)*XX(67)-JVS(580)*XX(68)-JVS(611)*XX(69)-JVS(631)*XX(70)-JVS(690)*XX(71)&
             &-JVS(715)*XX(72)-JVS(740)*XX(73))/(JVS(782))
  XX(75) = (X(75)-JVS(59)*XX(8)-JVS(68)*XX(9)-JVS(103)*XX(22)-JVS(133)*XX(31)-JVS(155)*XX(37)-JVS(168)*XX(40)-JVS(176)&
             &*XX(41)-JVS(186)*XX(43)-JVS(199)*XX(44)-JVS(223)*XX(45)-JVS(237)*XX(46)-JVS(257)*XX(47)-JVS(263)*XX(48)&
             &-JVS(279)*XX(49)-JVS(285)*XX(50)-JVS(295)*XX(51)-JVS(302)*XX(52)-JVS(327)*XX(53)-JVS(336)*XX(54)-JVS(343)&
             &*XX(55)-JVS(348)*XX(56)-JVS(355)*XX(57)-JVS(360)*XX(58)-JVS(367)*XX(59)-JVS(390)*XX(60)-JVS(425)*XX(61)&
             &-JVS(442)*XX(62)-JVS(457)*XX(63)-JVS(484)*XX(64)-JVS(505)*XX(65)-JVS(527)*XX(66)-JVS(550)*XX(67)-JVS(581)&
             &*XX(68)-JVS(612)*XX(69)-JVS(632)*XX(70)-JVS(691)*XX(71)-JVS(716)*XX(72)-JVS(741)*XX(73)-JVS(783)*XX(74))&
             &/(JVS(823))
  XX(76) = (X(76)-JVS(30)*XX(4)-JVS(43)*XX(5)-JVS(120)*XX(28)-JVS(124)*XX(29)-JVS(328)*XX(53)-JVS(426)*XX(61)-JVS(506)&
             &*XX(65)-JVS(528)*XX(66)-JVS(582)*XX(68)-JVS(613)*XX(69)-JVS(633)*XX(70)-JVS(692)*XX(71)-JVS(717)*XX(72)&
             &-JVS(742)*XX(73)-JVS(784)*XX(74)-JVS(824)*XX(75))/(JVS(855))
  XX(77) = (X(77)-JVS(31)*XX(4)-JVS(44)*XX(5)-JVS(121)*XX(28)-JVS(180)*XX(42)-JVS(329)*XX(53)-JVS(427)*XX(61)-JVS(485)&
             &*XX(64)-JVS(507)*XX(65)-JVS(529)*XX(66)-JVS(583)*XX(68)-JVS(614)*XX(69)-JVS(634)*XX(70)-JVS(693)*XX(71)&
             &-JVS(718)*XX(72)-JVS(743)*XX(73)-JVS(785)*XX(74)-JVS(825)*XX(75)-JVS(856)*XX(76))/(JVS(899))
  XX(78) = (X(78)-JVS(32)*XX(4)-JVS(45)*XX(5)-JVS(49)*XX(6)-JVS(53)*XX(7)-JVS(96)*XX(19)-JVS(125)*XX(29)-JVS(129)*XX(30)&
             &-JVS(134)*XX(31)-JVS(138)*XX(32)-JVS(169)*XX(40)-JVS(181)*XX(42)-JVS(187)*XX(43)-JVS(258)*XX(47)-JVS(280)&
             &*XX(49)-JVS(296)*XX(51)-JVS(330)*XX(53)-JVS(428)*XX(61)-JVS(486)*XX(64)-JVS(551)*XX(67)-JVS(584)*XX(68)&
             &-JVS(615)*XX(69)-JVS(635)*XX(70)-JVS(694)*XX(71)-JVS(719)*XX(72)-JVS(744)*XX(73)-JVS(786)*XX(74)-JVS(826)&
             &*XX(75)-JVS(857)*XX(76)-JVS(900)*XX(77))/(JVS(950))
  XX(79) = (X(79)-JVS(46)*XX(5)-JVS(54)*XX(7)-JVS(90)*XX(17)-JVS(297)*XX(51)-JVS(331)*XX(53)-JVS(391)*XX(60)-JVS(429)&
             &*XX(61)-JVS(530)*XX(66)-JVS(552)*XX(67)-JVS(585)*XX(68)-JVS(616)*XX(69)-JVS(636)*XX(70)-JVS(695)*XX(71)&
             &-JVS(720)*XX(72)-JVS(745)*XX(73)-JVS(787)*XX(74)-JVS(827)*XX(75)-JVS(858)*XX(76)-JVS(901)*XX(77)-JVS(951)&
             &*XX(78))/(JVS(968))
  XX(79) = XX(79)
  XX(78) = XX(78)-JVS(967)*XX(79)
  XX(77) = XX(77)-JVS(949)*XX(78)-JVS(966)*XX(79)
  XX(76) = XX(76)-JVS(898)*XX(77)-JVS(948)*XX(78)-JVS(965)*XX(79)
  XX(75) = XX(75)-JVS(854)*XX(76)-JVS(897)*XX(77)-JVS(947)*XX(78)-JVS(964)*XX(79)
  XX(74) = XX(74)-JVS(822)*XX(75)-JVS(853)*XX(76)-JVS(896)*XX(77)-JVS(946)*XX(78)-JVS(963)*XX(79)
  XX(73) = XX(73)-JVS(781)*XX(74)-JVS(821)*XX(75)-JVS(852)*XX(76)-JVS(895)*XX(77)-JVS(945)*XX(78)-JVS(962)*XX(79)
  XX(72) = XX(72)-JVS(738)*XX(73)-JVS(780)*XX(74)-JVS(820)*XX(75)-JVS(851)*XX(76)-JVS(894)*XX(77)-JVS(944)*XX(78)&
             &-JVS(961)*XX(79)
  XX(71) = XX(71)-JVS(712)*XX(72)-JVS(737)*XX(73)-JVS(779)*XX(74)-JVS(819)*XX(75)-JVS(850)*XX(76)-JVS(893)*XX(77)&
             &-JVS(943)*XX(78)-JVS(960)*XX(79)
  XX(70) = XX(70)-JVS(686)*XX(71)-JVS(711)*XX(72)-JVS(736)*XX(73)-JVS(778)*XX(74)-JVS(818)*XX(75)-JVS(849)*XX(76)&
             &-JVS(892)*XX(77)-JVS(942)*XX(78)-JVS(959)*XX(79)
  XX(69) = XX(69)-JVS(626)*XX(70)-JVS(685)*XX(71)-JVS(710)*XX(72)-JVS(735)*XX(73)-JVS(777)*XX(74)-JVS(817)*XX(75)&
             &-JVS(848)*XX(76)-JVS(891)*XX(77)-JVS(941)*XX(78)-JVS(958)*XX(79)
  XX(68) = XX(68)-JVS(605)*XX(69)-JVS(625)*XX(70)-JVS(684)*XX(71)-JVS(709)*XX(72)-JVS(734)*XX(73)-JVS(776)*XX(74)&
             &-JVS(816)*XX(75)-JVS(847)*XX(76)-JVS(890)*XX(77)-JVS(940)*XX(78)-JVS(957)*XX(79)
  XX(67) = XX(67)-JVS(573)*XX(68)-JVS(604)*XX(69)-JVS(624)*XX(70)-JVS(683)*XX(71)-JVS(708)*XX(72)-JVS(733)*XX(73)&
             &-JVS(775)*XX(74)-JVS(815)*XX(75)-JVS(846)*XX(76)-JVS(889)*XX(77)-JVS(939)*XX(78)-JVS(956)*XX(79)
  XX(66) = XX(66)-JVS(572)*XX(68)-JVS(603)*XX(69)-JVS(682)*XX(71)-JVS(707)*XX(72)-JVS(732)*XX(73)-JVS(774)*XX(74)&
             &-JVS(814)*XX(75)-JVS(845)*XX(76)-JVS(888)*XX(77)-JVS(938)*XX(78)
  XX(65) = XX(65)-JVS(571)*XX(68)-JVS(602)*XX(69)-JVS(681)*XX(71)-JVS(706)*XX(72)-JVS(731)*XX(73)-JVS(773)*XX(74)&
             &-JVS(813)*XX(75)-JVS(844)*XX(76)-JVS(887)*XX(77)-JVS(937)*XX(78)
  XX(64) = XX(64)-JVS(570)*XX(68)-JVS(601)*XX(69)-JVS(680)*XX(71)-JVS(705)*XX(72)-JVS(772)*XX(74)-JVS(812)*XX(75)&
             &-JVS(843)*XX(76)-JVS(886)*XX(77)-JVS(936)*XX(78)
  XX(63) = XX(63)-JVS(475)*XX(64)-JVS(497)*XX(65)-JVS(518)*XX(66)-JVS(542)*XX(67)-JVS(569)*XX(68)-JVS(600)*XX(69)&
             &-JVS(623)*XX(70)-JVS(679)*XX(71)-JVS(704)*XX(72)-JVS(730)*XX(73)-JVS(771)*XX(74)-JVS(811)*XX(75)-JVS(842)&
             &*XX(76)-JVS(885)*XX(77)-JVS(935)*XX(78)-JVS(955)*XX(79)
  XX(62) = XX(62)-JVS(474)*XX(64)-JVS(496)*XX(65)-JVS(517)*XX(66)-JVS(568)*XX(68)-JVS(599)*XX(69)-JVS(678)*XX(71)&
             &-JVS(729)*XX(73)-JVS(770)*XX(74)-JVS(810)*XX(75)-JVS(841)*XX(76)-JVS(884)*XX(77)-JVS(934)*XX(78)
  XX(61) = XX(61)-JVS(677)*XX(71)-JVS(728)*XX(73)-JVS(769)*XX(74)-JVS(809)*XX(75)-JVS(933)*XX(78)
  XX(60) = XX(60)-JVS(567)*XX(68)-JVS(676)*XX(71)-JVS(768)*XX(74)-JVS(808)*XX(75)-JVS(840)*XX(76)-JVS(932)*XX(78)
  XX(59) = XX(59)-JVS(411)*XX(61)-JVS(451)*XX(63)-JVS(473)*XX(64)-JVS(495)*XX(65)-JVS(516)*XX(66)-JVS(541)*XX(67)&
             &-JVS(566)*XX(68)-JVS(598)*XX(69)-JVS(622)*XX(70)-JVS(675)*XX(71)-JVS(703)*XX(72)-JVS(727)*XX(73)-JVS(767)&
             &*XX(74)-JVS(807)*XX(75)-JVS(839)*XX(76)-JVS(883)*XX(77)-JVS(931)*XX(78)
  XX(58) = XX(58)-JVS(362)*XX(59)-JVS(377)*XX(60)-JVS(410)*XX(61)-JVS(434)*XX(62)-JVS(450)*XX(63)-JVS(472)*XX(64)&
             &-JVS(494)*XX(65)-JVS(515)*XX(66)-JVS(540)*XX(67)-JVS(565)*XX(68)-JVS(597)*XX(69)-JVS(621)*XX(70)-JVS(674)&
             &*XX(71)-JVS(702)*XX(72)-JVS(726)*XX(73)-JVS(766)*XX(74)-JVS(806)*XX(75)-JVS(838)*XX(76)-JVS(882)*XX(77)&
             &-JVS(930)*XX(78)-JVS(954)*XX(79)
  XX(57) = XX(57)-JVS(376)*XX(60)-JVS(409)*XX(61)-JVS(433)*XX(62)-JVS(471)*XX(64)-JVS(493)*XX(65)-JVS(514)*XX(66)&
             &-JVS(539)*XX(67)-JVS(564)*XX(68)-JVS(596)*XX(69)-JVS(620)*XX(70)-JVS(673)*XX(71)-JVS(701)*XX(72)-JVS(765)&
             &*XX(74)-JVS(805)*XX(75)-JVS(881)*XX(77)-JVS(929)*XX(78)
  XX(56) = XX(56)-JVS(375)*XX(60)-JVS(408)*XX(61)-JVS(432)*XX(62)-JVS(449)*XX(63)-JVS(470)*XX(64)-JVS(492)*XX(65)&
             &-JVS(513)*XX(66)-JVS(538)*XX(67)-JVS(563)*XX(68)-JVS(595)*XX(69)-JVS(672)*XX(71)-JVS(725)*XX(73)-JVS(764)&
             &*XX(74)-JVS(804)*XX(75)-JVS(837)*XX(76)-JVS(880)*XX(77)-JVS(928)*XX(78)
  XX(55) = XX(55)-JVS(407)*XX(61)-JVS(448)*XX(63)-JVS(469)*XX(64)-JVS(491)*XX(65)-JVS(537)*XX(67)-JVS(562)*XX(68)&
             &-JVS(619)*XX(70)-JVS(671)*XX(71)-JVS(700)*XX(72)-JVS(763)*XX(74)-JVS(803)*XX(75)-JVS(879)*XX(77)-JVS(927)&
             &*XX(78)
  XX(54) = XX(54)-JVS(406)*XX(61)-JVS(431)*XX(62)-JVS(447)*XX(63)-JVS(468)*XX(64)-JVS(512)*XX(66)-JVS(536)*XX(67)&
             &-JVS(561)*XX(68)-JVS(594)*XX(69)-JVS(670)*XX(71)-JVS(699)*XX(72)-JVS(724)*XX(73)-JVS(762)*XX(74)-JVS(802)&
             &*XX(75)-JVS(836)*XX(76)-JVS(878)*XX(77)-JVS(926)*XX(78)
  XX(53) = XX(53)-JVS(723)*XX(73)-JVS(761)*XX(74)-JVS(801)*XX(75)
  XX(52) = XX(52)-JVS(309)*XX(53)-JVS(337)*XX(55)-JVS(349)*XX(57)-JVS(361)*XX(59)-JVS(405)*XX(61)-JVS(446)*XX(63)&
             &-JVS(511)*XX(66)-JVS(535)*XX(67)-JVS(593)*XX(69)-JVS(618)*XX(70)-JVS(669)*XX(71)-JVS(760)*XX(74)-JVS(800)&
             &*XX(75)-JVS(835)*XX(76)-JVS(877)*XX(77)-JVS(925)*XX(78)
  XX(51) = XX(51)-JVS(404)*XX(61)-JVS(668)*XX(71)-JVS(698)*XX(72)-JVS(759)*XX(74)-JVS(799)*XX(75)-JVS(876)*XX(77)&
             &-JVS(924)*XX(78)
  XX(50) = XX(50)-JVS(374)*XX(60)-JVS(403)*XX(61)-JVS(445)*XX(63)-JVS(467)*XX(64)-JVS(490)*XX(65)-JVS(534)*XX(67)&
             &-JVS(592)*XX(69)-JVS(667)*XX(71)-JVS(798)*XX(75)-JVS(834)*XX(76)-JVS(875)*XX(77)-JVS(923)*XX(78)
  XX(49) = XX(49)-JVS(402)*XX(61)-JVS(666)*XX(71)-JVS(697)*XX(72)-JVS(758)*XX(74)-JVS(797)*XX(75)-JVS(922)*XX(78)
  XX(48) = XX(48)-JVS(271)*XX(49)-JVS(373)*XX(60)-JVS(401)*XX(61)-JVS(444)*XX(63)-JVS(466)*XX(64)-JVS(533)*XX(67)&
             &-JVS(665)*XX(71)-JVS(796)*XX(75)-JVS(833)*XX(76)-JVS(874)*XX(77)-JVS(921)*XX(78)
  XX(47) = XX(47)-JVS(664)*XX(71)-JVS(757)*XX(74)-JVS(795)*XX(75)
  XX(46) = XX(46)-JVS(308)*XX(53)-JVS(400)*XX(61)-JVS(560)*XX(68)-JVS(663)*XX(71)-JVS(832)*XX(76)
  XX(45) = XX(45)-JVS(662)*XX(71)-JVS(920)*XX(78)
  XX(44) = XX(44)-JVS(205)*XX(45)-JVS(243)*XX(47)-JVS(559)*XX(68)-JVS(661)*XX(71)-JVS(794)*XX(75)-JVS(919)*XX(78)
  XX(43) = XX(43)-JVS(242)*XX(47)-JVS(270)*XX(49)-JVS(287)*XX(51)-JVS(660)*XX(71)-JVS(793)*XX(75)-JVS(873)*XX(77)
  XX(42) = XX(42)-JVS(465)*XX(64)-JVS(659)*XX(71)-JVS(872)*XX(77)-JVS(918)*XX(78)
  XX(41) = XX(41)-JVS(241)*XX(47)-JVS(658)*XX(71)-JVS(792)*XX(75)-JVS(953)*XX(79)
  XX(40) = XX(40)-JVS(240)*XX(47)-JVS(756)*XX(74)-JVS(791)*XX(75)-JVS(917)*XX(78)
  XX(39) = XX(39)-JVS(204)*XX(45)-JVS(269)*XX(49)-JVS(399)*XX(61)-JVS(532)*XX(67)-JVS(657)*XX(71)-JVS(871)*XX(77)&
             &-JVS(916)*XX(78)
  XX(38) = XX(38)-JVS(203)*XX(45)-JVS(268)*XX(49)-JVS(464)*XX(64)-JVS(531)*XX(67)-JVS(656)*XX(71)-JVS(870)*XX(77)&
             &-JVS(915)*XX(78)
  XX(37) = XX(37)-JVS(192)*XX(44)-JVS(239)*XX(47)-JVS(286)*XX(51)-JVS(655)*XX(71)-JVS(790)*XX(75)-JVS(869)*XX(77)
  XX(36) = XX(36)-JVS(191)*XX(44)-JVS(202)*XX(45)-JVS(267)*XX(49)-JVS(307)*XX(53)-JVS(463)*XX(64)-JVS(558)*XX(68)&
             &-JVS(654)*XX(71)-JVS(868)*XX(77)-JVS(914)*XX(78)
  XX(35) = XX(35)-JVS(190)*XX(44)-JVS(201)*XX(45)-JVS(266)*XX(49)-JVS(306)*XX(53)-JVS(462)*XX(64)-JVS(557)*XX(68)&
             &-JVS(653)*XX(71)-JVS(867)*XX(77)-JVS(913)*XX(78)
  XX(34) = XX(34)-JVS(144)*XX(35)-JVS(148)*XX(36)-JVS(152)*XX(37)-JVS(157)*XX(38)-JVS(171)*XX(41)-JVS(182)*XX(43)&
             &-JVS(189)*XX(44)-JVS(265)*XX(49)-JVS(510)*XX(66)-JVS(591)*XX(69)-JVS(652)*XX(71)-JVS(866)*XX(77)-JVS(912)&
             &*XX(78)
  XX(33) = XX(33)-JVS(200)*XX(45)-JVS(228)*XX(46)-JVS(305)*XX(53)-JVS(372)*XX(60)-JVS(398)*XX(61)-JVS(461)*XX(64)&
             &-JVS(489)*XX(65)-JVS(509)*XX(66)-JVS(556)*XX(68)-JVS(590)*XX(69)-JVS(651)*XX(71)-JVS(831)*XX(76)-JVS(865)&
             &*XX(77)
  XX(32) = XX(32)-JVS(650)*XX(71)-JVS(755)*XX(74)-JVS(789)*XX(75)-JVS(911)*XX(78)
  XX(31) = XX(31)-JVS(164)*XX(40)-JVS(754)*XX(74)-JVS(910)*XX(78)
  XX(30) = XX(30)-JVS(397)*XX(61)-JVS(722)*XX(73)-JVS(753)*XX(74)-JVS(909)*XX(78)
  XX(29) = XX(29)-JVS(396)*XX(61)-JVS(649)*XX(71)-JVS(830)*XX(76)-JVS(908)*XX(78)
  XX(28) = XX(28)-JVS(395)*XX(61)-JVS(648)*XX(71)-JVS(907)*XX(78)
  XX(27) = XX(27)-JVS(143)*XX(35)-JVS(147)*XX(36)-JVS(151)*XX(37)-JVS(156)*XX(38)-JVS(170)*XX(41)-JVS(188)*XX(44)&
             &-JVS(264)*XX(49)-JVS(555)*XX(68)-JVS(589)*XX(69)-JVS(647)*XX(71)-JVS(864)*XX(77)-JVS(906)*XX(78)
  XX(26) = XX(26)-JVS(227)*XX(46)-JVS(304)*XX(53)-JVS(371)*XX(60)-JVS(394)*XX(61)-JVS(460)*XX(64)-JVS(488)*XX(65)&
             &-JVS(508)*XX(66)-JVS(588)*XX(69)-JVS(646)*XX(71)-JVS(863)*XX(77)
  XX(25) = XX(25)-JVS(226)*XX(46)-JVS(430)*XX(62)-JVS(752)*XX(74)-JVS(829)*XX(76)
  XX(24) = XX(24)-JVS(109)*XX(25)-JVS(225)*XX(46)-JVS(303)*XX(53)-JVS(370)*XX(60)-JVS(393)*XX(61)-JVS(459)*XX(64)&
             &-JVS(487)*XX(65)-JVS(587)*XX(69)-JVS(645)*XX(71)-JVS(862)*XX(77)
  XX(23) = XX(23)-JVS(644)*XX(71)-JVS(721)*XX(73)-JVS(751)*XX(74)-JVS(905)*XX(78)
  XX(22) = XX(22)-JVS(238)*XX(47)-JVS(750)*XX(74)-JVS(788)*XX(75)
  XX(21) = XX(21)-JVS(369)*XX(60)-JVS(392)*XX(61)-JVS(643)*XX(71)-JVS(861)*XX(77)-JVS(904)*XX(78)
  XX(20) = XX(20)-JVS(224)*XX(46)-JVS(458)*XX(64)-JVS(586)*XX(69)-JVS(642)*XX(71)-JVS(860)*XX(77)
  XX(19) = XX(19)-JVS(641)*XX(71)-JVS(903)*XX(78)
  XX(18) = XX(18)-JVS(617)*XX(70)-JVS(749)*XX(74)
  XX(17) = XX(17)-JVS(748)*XX(74)-JVS(952)*XX(79)
  XX(16) = XX(16)-JVS(696)*XX(72)-JVS(747)*XX(74)
  XX(15) = XX(15)-JVS(554)*XX(68)-JVS(746)*XX(74)
  XX(14) = XX(14)-JVS(553)*XX(68)
  XX(13) = XX(13)-JVS(368)*XX(60)-JVS(640)*XX(71)-JVS(859)*XX(77)
  XX(12) = XX(12)-JVS(639)*XX(71)-JVS(828)*XX(76)
  XX(11) = XX(11)-JVS(443)*XX(63)-JVS(638)*XX(71)
  XX(10) = XX(10)-JVS(637)*XX(71)-JVS(902)*XX(78)
  XX(9) = XX(9)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE SAPRC99_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE SAPRC99_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE SAPRC99_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE SAPRC99_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE SAPRC99_LinearAlgebra

