! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : SAPRC99_Jacobian.f90
! Time                 : Thu Oct  8 08:22:39 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_SAPRC99_30885_BOXMOX
! Equation file        : SAPRC99.kpp
! Output root filename : SAPRC99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE SAPRC99_Jacobian

  USE SAPRC99_Parameters
  USE SAPRC99_JacobianSP

  USE SAPRC99_Global

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(393)

! B(1) = dA(1)/dV(74)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(63)
  B(2) = RCT(2)*F(2)
! B(4) = dA(3)/dV(63)
  B(4) = RCT(3)*V(67)
! B(5) = dA(3)/dV(67)
  B(5) = RCT(3)*V(63)
! B(6) = dA(4)/dV(63)
  B(6) = RCT(4)*V(73)*F(2)
! B(7) = dA(4)/dV(73)
  B(7) = RCT(4)*V(63)*F(2)
! B(9) = dA(5)/dV(63)
  B(9) = RCT(5)*V(74)
! B(10) = dA(5)/dV(74)
  B(10) = RCT(5)*V(63)
! B(11) = dA(6)/dV(63)
  B(11) = RCT(6)*V(74)
! B(12) = dA(6)/dV(74)
  B(12) = RCT(6)*V(63)
! B(13) = dA(7)/dV(67)
  B(13) = RCT(7)*V(73)
! B(14) = dA(7)/dV(73)
  B(14) = RCT(7)*V(67)
! B(15) = dA(8)/dV(67)
  B(15) = RCT(8)*V(74)
! B(16) = dA(8)/dV(74)
  B(16) = RCT(8)*V(67)
! B(17) = dA(9)/dV(73)
  B(17) = RCT(9)*V(75)
! B(18) = dA(9)/dV(75)
  B(18) = RCT(9)*V(73)
! B(19) = dA(10)/dV(73)
  B(19) = RCT(10)*2*V(73)*F(2)
! B(21) = dA(11)/dV(74)
  B(21) = RCT(11)*V(75)
! B(22) = dA(11)/dV(75)
  B(22) = RCT(11)*V(74)
! B(23) = dA(12)/dV(22)
  B(23) = RCT(12)
! B(24) = dA(13)/dV(22)
  B(24) = RCT(13)*F(1)
! B(26) = dA(14)/dV(74)
  B(26) = RCT(14)*V(75)
! B(27) = dA(14)/dV(75)
  B(27) = RCT(14)*V(74)
! B(28) = dA(15)/dV(75)
  B(28) = RCT(15)
! B(29) = dA(16)/dV(75)
  B(29) = RCT(16)
! B(30) = dA(17)/dV(67)
  B(30) = RCT(17)
! B(31) = dA(18)/dV(67)
  B(31) = RCT(18)
! B(32) = dA(19)/dV(11)
  B(32) = RCT(19)*F(1)
! B(34) = dA(20)/dV(11)
  B(34) = RCT(20)*F(2)
! B(36) = dA(21)/dV(71)
  B(36) = RCT(21)*V(73)
! B(37) = dA(21)/dV(73)
  B(37) = RCT(21)*V(71)
! B(38) = dA(22)/dV(23)
  B(38) = RCT(22)
! B(39) = dA(23)/dV(23)
  B(39) = RCT(23)
! B(40) = dA(24)/dV(23)
  B(40) = RCT(24)*V(71)
! B(41) = dA(24)/dV(71)
  B(41) = RCT(24)*V(23)
! B(42) = dA(25)/dV(71)
  B(42) = RCT(25)*V(74)
! B(43) = dA(25)/dV(74)
  B(43) = RCT(25)*V(71)
! B(44) = dA(26)/dV(71)
  B(44) = RCT(26)*V(75)
! B(45) = dA(26)/dV(75)
  B(45) = RCT(26)*V(71)
! B(46) = dA(27)/dV(47)
  B(46) = RCT(27)*V(71)
! B(47) = dA(27)/dV(71)
  B(47) = RCT(27)*V(47)
! B(48) = dA(28)/dV(47)
  B(48) = RCT(28)
! B(49) = dA(29)/dV(45)
  B(49) = RCT(29)*V(71)
! B(50) = dA(29)/dV(71)
  B(50) = RCT(29)*V(45)
! B(51) = dA(30)/dV(67)
  B(51) = RCT(30)*V(71)
! B(52) = dA(30)/dV(71)
  B(52) = RCT(30)*V(67)
! B(53) = dA(31)/dV(73)
  B(53) = RCT(31)*V(78)
! B(54) = dA(31)/dV(78)
  B(54) = RCT(31)*V(73)
! B(55) = dA(32)/dV(74)
  B(55) = RCT(32)*V(78)
! B(56) = dA(32)/dV(78)
  B(56) = RCT(32)*V(74)
! B(57) = dA(33)/dV(32)
  B(57) = RCT(33)
! B(58) = dA(34)/dV(32)
  B(58) = RCT(34)
! B(59) = dA(35)/dV(32)
  B(59) = RCT(35)*V(71)
! B(60) = dA(35)/dV(71)
  B(60) = RCT(35)*V(32)
! B(61) = dA(36)/dV(67)
  B(61) = RCT(36)*V(78)
! B(62) = dA(36)/dV(78)
  B(62) = RCT(36)*V(67)
! B(63) = dA(37)/dV(78)
  B(63) = RCT(37)*2*V(78)
! B(64) = dA(38)/dV(78)
  B(64) = RCT(38)*2*V(78)*F(1)
! B(66) = dA(39)/dV(75)
  B(66) = RCT(39)*V(78)
! B(67) = dA(39)/dV(78)
  B(67) = RCT(39)*V(75)
! B(68) = dA(40)/dV(75)
  B(68) = RCT(40)*2*V(75)
! B(69) = dA(41)/dV(19)
  B(69) = RCT(41)
! B(70) = dA(42)/dV(19)
  B(70) = RCT(42)*V(71)
! B(71) = dA(42)/dV(71)
  B(71) = RCT(42)*V(19)
! B(72) = dA(43)/dV(71)
  B(72) = RCT(43)*V(78)
! B(73) = dA(43)/dV(78)
  B(73) = RCT(43)*V(71)
! B(74) = dA(44)/dV(10)
  B(74) = RCT(44)*V(71)
! B(75) = dA(44)/dV(71)
  B(75) = RCT(44)*V(10)
! B(76) = dA(45)/dV(71)
  B(76) = RCT(45)*F(2)
! B(78) = dA(46)/dV(73)
  B(78) = RCT(46)*V(76)
! B(79) = dA(46)/dV(76)
  B(79) = RCT(46)*V(73)
! B(80) = dA(47)/dV(76)
  B(80) = RCT(47)*V(78)
! B(81) = dA(47)/dV(78)
  B(81) = RCT(47)*V(76)
! B(82) = dA(48)/dV(75)
  B(82) = RCT(48)*V(76)
! B(83) = dA(48)/dV(76)
  B(83) = RCT(48)*V(75)
! B(84) = dA(49)/dV(76)
  B(84) = RCT(49)*2*V(76)
! B(85) = dA(50)/dV(76)
  B(85) = RCT(50)*2*V(76)
! B(86) = dA(51)/dV(73)
  B(86) = RCT(51)*V(77)
! B(87) = dA(51)/dV(77)
  B(87) = RCT(51)*V(73)
! B(88) = dA(52)/dV(77)
  B(88) = RCT(52)*V(78)
! B(89) = dA(52)/dV(78)
  B(89) = RCT(52)*V(77)
! B(90) = dA(53)/dV(75)
  B(90) = RCT(53)*V(77)
! B(91) = dA(53)/dV(77)
  B(91) = RCT(53)*V(75)
! B(92) = dA(54)/dV(76)
  B(92) = RCT(54)*V(77)
! B(93) = dA(54)/dV(77)
  B(93) = RCT(54)*V(76)
! B(94) = dA(55)/dV(77)
  B(94) = RCT(55)*2*V(77)
! B(95) = dA(56)/dV(53)
  B(95) = RCT(56)*V(73)
! B(96) = dA(56)/dV(73)
  B(96) = RCT(56)*V(53)
! B(97) = dA(57)/dV(53)
  B(97) = RCT(57)*V(78)
! B(98) = dA(57)/dV(78)
  B(98) = RCT(57)*V(53)
! B(99) = dA(58)/dV(53)
  B(99) = RCT(58)*V(75)
! B(100) = dA(58)/dV(75)
  B(100) = RCT(58)*V(53)
! B(101) = dA(59)/dV(53)
  B(101) = RCT(59)*V(76)
! B(102) = dA(59)/dV(76)
  B(102) = RCT(59)*V(53)
! B(103) = dA(60)/dV(53)
  B(103) = RCT(60)*V(77)
! B(104) = dA(60)/dV(77)
  B(104) = RCT(60)*V(53)
! B(105) = dA(61)/dV(53)
  B(105) = RCT(61)*2*V(53)
! B(106) = dA(62)/dV(69)
  B(106) = RCT(62)*V(73)
! B(107) = dA(62)/dV(73)
  B(107) = RCT(62)*V(69)
! B(108) = dA(63)/dV(69)
  B(108) = RCT(63)*V(78)
! B(109) = dA(63)/dV(78)
  B(109) = RCT(63)*V(69)
! B(110) = dA(64)/dV(69)
  B(110) = RCT(64)*V(76)
! B(111) = dA(64)/dV(76)
  B(111) = RCT(64)*V(69)
! B(112) = dA(65)/dV(69)
  B(112) = RCT(65)*V(75)
! B(113) = dA(65)/dV(75)
  B(113) = RCT(65)*V(69)
! B(114) = dA(66)/dV(69)
  B(114) = RCT(66)*V(77)
! B(115) = dA(66)/dV(77)
  B(115) = RCT(66)*V(69)
! B(116) = dA(67)/dV(53)
  B(116) = RCT(67)*V(69)
! B(117) = dA(67)/dV(69)
  B(117) = RCT(67)*V(53)
! B(118) = dA(68)/dV(69)
  B(118) = RCT(68)*2*V(69)
! B(119) = dA(69)/dV(68)
  B(119) = RCT(69)*V(74)
! B(120) = dA(69)/dV(74)
  B(120) = RCT(69)*V(68)
! B(121) = dA(70)/dV(15)
  B(121) = RCT(70)
! B(122) = dA(71)/dV(68)
  B(122) = RCT(71)*V(73)
! B(123) = dA(71)/dV(73)
  B(123) = RCT(71)*V(68)
! B(124) = dA(72)/dV(68)
  B(124) = RCT(72)*V(78)
! B(125) = dA(72)/dV(78)
  B(125) = RCT(72)*V(68)
! B(126) = dA(73)/dV(68)
  B(126) = RCT(73)*V(75)
! B(127) = dA(73)/dV(75)
  B(127) = RCT(73)*V(68)
! B(128) = dA(74)/dV(68)
  B(128) = RCT(74)*V(76)
! B(129) = dA(74)/dV(76)
  B(129) = RCT(74)*V(68)
! B(130) = dA(75)/dV(68)
  B(130) = RCT(75)*V(77)
! B(131) = dA(75)/dV(77)
  B(131) = RCT(75)*V(68)
! B(132) = dA(76)/dV(53)
  B(132) = RCT(76)*V(68)
! B(133) = dA(76)/dV(68)
  B(133) = RCT(76)*V(53)
! B(134) = dA(77)/dV(68)
  B(134) = RCT(77)*V(69)
! B(135) = dA(77)/dV(69)
  B(135) = RCT(77)*V(68)
! B(136) = dA(78)/dV(68)
  B(136) = RCT(78)*2*V(68)
! B(137) = dA(79)/dV(72)
  B(137) = RCT(79)*V(74)
! B(138) = dA(79)/dV(74)
  B(138) = RCT(79)*V(72)
! B(139) = dA(80)/dV(16)
  B(139) = RCT(80)
! B(140) = dA(81)/dV(72)
  B(140) = RCT(81)*V(73)
! B(141) = dA(81)/dV(73)
  B(141) = RCT(81)*V(72)
! B(142) = dA(82)/dV(72)
  B(142) = RCT(82)*V(78)
! B(143) = dA(82)/dV(78)
  B(143) = RCT(82)*V(72)
! B(144) = dA(83)/dV(72)
  B(144) = RCT(83)*V(75)
! B(145) = dA(83)/dV(75)
  B(145) = RCT(83)*V(72)
! B(146) = dA(84)/dV(72)
  B(146) = RCT(84)*V(76)
! B(147) = dA(84)/dV(76)
  B(147) = RCT(84)*V(72)
! B(148) = dA(85)/dV(72)
  B(148) = RCT(85)*V(77)
! B(149) = dA(85)/dV(77)
  B(149) = RCT(85)*V(72)
! B(150) = dA(86)/dV(53)
  B(150) = RCT(86)*V(72)
! B(151) = dA(86)/dV(72)
  B(151) = RCT(86)*V(53)
! B(152) = dA(87)/dV(69)
  B(152) = RCT(87)*V(72)
! B(153) = dA(87)/dV(72)
  B(153) = RCT(87)*V(69)
! B(154) = dA(88)/dV(68)
  B(154) = RCT(88)*V(72)
! B(155) = dA(88)/dV(72)
  B(155) = RCT(88)*V(68)
! B(156) = dA(89)/dV(72)
  B(156) = RCT(89)*2*V(72)
! B(157) = dA(90)/dV(74)
  B(157) = RCT(90)*V(79)
! B(158) = dA(90)/dV(79)
  B(158) = RCT(90)*V(74)
! B(159) = dA(91)/dV(17)
  B(159) = RCT(91)
! B(160) = dA(92)/dV(73)
  B(160) = RCT(92)*V(79)
! B(161) = dA(92)/dV(79)
  B(161) = RCT(92)*V(73)
! B(162) = dA(93)/dV(78)
  B(162) = RCT(93)*V(79)
! B(163) = dA(93)/dV(79)
  B(163) = RCT(93)*V(78)
! B(164) = dA(94)/dV(75)
  B(164) = RCT(94)*V(79)
! B(165) = dA(94)/dV(79)
  B(165) = RCT(94)*V(75)
! B(166) = dA(95)/dV(76)
  B(166) = RCT(95)*V(79)
! B(167) = dA(95)/dV(79)
  B(167) = RCT(95)*V(76)
! B(168) = dA(96)/dV(77)
  B(168) = RCT(96)*V(79)
! B(169) = dA(96)/dV(79)
  B(169) = RCT(96)*V(77)
! B(170) = dA(97)/dV(53)
  B(170) = RCT(97)*V(79)
! B(171) = dA(97)/dV(79)
  B(171) = RCT(97)*V(53)
! B(172) = dA(98)/dV(69)
  B(172) = RCT(98)*V(79)
! B(173) = dA(98)/dV(79)
  B(173) = RCT(98)*V(69)
! B(174) = dA(99)/dV(68)
  B(174) = RCT(99)*V(79)
! B(175) = dA(99)/dV(79)
  B(175) = RCT(99)*V(68)
! B(176) = dA(100)/dV(72)
  B(176) = RCT(100)*V(79)
! B(177) = dA(100)/dV(79)
  B(177) = RCT(100)*V(72)
! B(178) = dA(101)/dV(79)
  B(178) = RCT(101)*2*V(79)
! B(179) = dA(102)/dV(70)
  B(179) = RCT(102)*V(74)
! B(180) = dA(102)/dV(74)
  B(180) = RCT(102)*V(70)
! B(181) = dA(103)/dV(18)
  B(181) = RCT(103)
! B(182) = dA(104)/dV(70)
  B(182) = RCT(104)*V(73)
! B(183) = dA(104)/dV(73)
  B(183) = RCT(104)*V(70)
! B(184) = dA(105)/dV(70)
  B(184) = RCT(105)*V(78)
! B(185) = dA(105)/dV(78)
  B(185) = RCT(105)*V(70)
! B(186) = dA(106)/dV(70)
  B(186) = RCT(106)*V(75)
! B(187) = dA(106)/dV(75)
  B(187) = RCT(106)*V(70)
! B(188) = dA(107)/dV(70)
  B(188) = RCT(107)*V(76)
! B(189) = dA(107)/dV(76)
  B(189) = RCT(107)*V(70)
! B(190) = dA(108)/dV(70)
  B(190) = RCT(108)*V(77)
! B(191) = dA(108)/dV(77)
  B(191) = RCT(108)*V(70)
! B(192) = dA(109)/dV(53)
  B(192) = RCT(109)*V(70)
! B(193) = dA(109)/dV(70)
  B(193) = RCT(109)*V(53)
! B(194) = dA(110)/dV(69)
  B(194) = RCT(110)*V(70)
! B(195) = dA(110)/dV(70)
  B(195) = RCT(110)*V(69)
! B(196) = dA(111)/dV(68)
  B(196) = RCT(111)*V(70)
! B(197) = dA(111)/dV(70)
  B(197) = RCT(111)*V(68)
! B(198) = dA(112)/dV(70)
  B(198) = RCT(112)*V(72)
! B(199) = dA(112)/dV(72)
  B(199) = RCT(112)*V(70)
! B(200) = dA(113)/dV(70)
  B(200) = RCT(113)*V(79)
! B(201) = dA(113)/dV(79)
  B(201) = RCT(113)*V(70)
! B(202) = dA(114)/dV(70)
  B(202) = RCT(114)*2*V(70)
! B(203) = dA(115)/dV(25)
  B(203) = RCT(115)*V(74)
! B(204) = dA(115)/dV(74)
  B(204) = RCT(115)*V(25)
! B(205) = dA(116)/dV(25)
  B(205) = RCT(116)
! B(206) = dA(117)/dV(51)
  B(206) = RCT(117)*V(74)
! B(207) = dA(117)/dV(74)
  B(207) = RCT(117)*V(51)
! B(208) = dA(118)/dV(51)
  B(208) = RCT(118)*V(78)
! B(209) = dA(118)/dV(78)
  B(209) = RCT(118)*V(51)
! B(210) = dA(119)/dV(51)
  B(210) = RCT(119)
! B(211) = dA(120)/dV(31)
  B(211) = RCT(120)*V(74)
! B(212) = dA(120)/dV(74)
  B(212) = RCT(120)*V(31)
! B(213) = dA(121)/dV(31)
  B(213) = RCT(121)*V(78)
! B(214) = dA(121)/dV(78)
  B(214) = RCT(121)*V(31)
! B(215) = dA(122)/dV(31)
  B(215) = RCT(122)
! B(216) = dA(123)/dV(61)
  B(216) = RCT(123)
! B(217) = dA(124)/dV(61)
  B(217) = RCT(124)
! B(218) = dA(125)/dV(61)
  B(218) = RCT(125)*V(71)
! B(219) = dA(125)/dV(71)
  B(219) = RCT(125)*V(61)
! B(220) = dA(126)/dV(61)
  B(220) = RCT(126)*V(78)
! B(221) = dA(126)/dV(78)
  B(221) = RCT(126)*V(61)
! B(222) = dA(127)/dV(30)
  B(222) = RCT(127)
! B(223) = dA(128)/dV(30)
  B(223) = RCT(128)*V(73)
! B(224) = dA(128)/dV(73)
  B(224) = RCT(128)*V(30)
! B(225) = dA(129)/dV(61)
  B(225) = RCT(129)*V(75)
! B(226) = dA(129)/dV(75)
  B(226) = RCT(129)*V(61)
! B(227) = dA(130)/dV(60)
  B(227) = RCT(130)*V(71)
! B(228) = dA(130)/dV(71)
  B(228) = RCT(130)*V(60)
! B(229) = dA(131)/dV(60)
  B(229) = RCT(131)
! B(230) = dA(132)/dV(60)
  B(230) = RCT(132)*V(75)
! B(231) = dA(132)/dV(75)
  B(231) = RCT(132)*V(60)
! B(232) = dA(133)/dV(64)
  B(232) = RCT(133)*V(71)
! B(233) = dA(133)/dV(71)
  B(233) = RCT(133)*V(64)
! B(234) = dA(134)/dV(64)
  B(234) = RCT(134)
! B(235) = dA(135)/dV(64)
  B(235) = RCT(135)*V(75)
! B(236) = dA(135)/dV(75)
  B(236) = RCT(135)*V(64)
! B(237) = dA(136)/dV(46)
  B(237) = RCT(136)*V(71)
! B(238) = dA(136)/dV(71)
  B(238) = RCT(136)*V(46)
! B(239) = dA(137)/dV(46)
  B(239) = RCT(137)
! B(240) = dA(138)/dV(65)
  B(240) = RCT(138)*V(71)
! B(241) = dA(138)/dV(71)
  B(241) = RCT(138)*V(65)
! B(242) = dA(139)/dV(65)
  B(242) = RCT(139)
! B(243) = dA(140)/dV(28)
  B(243) = RCT(140)*V(71)
! B(244) = dA(140)/dV(71)
  B(244) = RCT(140)*V(28)
! B(245) = dA(141)/dV(21)
  B(245) = RCT(141)*V(71)
! B(246) = dA(141)/dV(71)
  B(246) = RCT(141)*V(21)
! B(247) = dA(142)/dV(29)
  B(247) = RCT(142)*V(71)
! B(248) = dA(142)/dV(71)
  B(248) = RCT(142)*V(29)
! B(249) = dA(143)/dV(29)
  B(249) = RCT(143)
! B(250) = dA(144)/dV(42)
  B(250) = RCT(144)*V(71)
! B(251) = dA(144)/dV(71)
  B(251) = RCT(144)*V(42)
! B(252) = dA(145)/dV(42)
  B(252) = RCT(145)
! B(253) = dA(146)/dV(49)
  B(253) = RCT(146)
! B(254) = dA(147)/dV(49)
  B(254) = RCT(147)
! B(255) = dA(148)/dV(49)
  B(255) = RCT(148)*V(71)
! B(256) = dA(148)/dV(71)
  B(256) = RCT(148)*V(49)
! B(257) = dA(149)/dV(49)
  B(257) = RCT(149)*V(75)
! B(258) = dA(149)/dV(75)
  B(258) = RCT(149)*V(49)
! B(259) = dA(150)/dV(44)
  B(259) = RCT(150)
! B(260) = dA(151)/dV(44)
  B(260) = RCT(151)*V(71)
! B(261) = dA(151)/dV(71)
  B(261) = RCT(151)*V(44)
! B(262) = dA(152)/dV(44)
  B(262) = RCT(152)*V(75)
! B(263) = dA(152)/dV(75)
  B(263) = RCT(152)*V(44)
! B(264) = dA(153)/dV(14)
  B(264) = RCT(153)
! B(265) = dA(154)/dV(43)
  B(265) = RCT(154)*V(71)
! B(266) = dA(154)/dV(71)
  B(266) = RCT(154)*V(43)
! B(267) = dA(155)/dV(43)
  B(267) = RCT(155)*V(75)
! B(268) = dA(155)/dV(75)
  B(268) = RCT(155)*V(43)
! B(269) = dA(156)/dV(37)
  B(269) = RCT(156)*V(71)
! B(270) = dA(156)/dV(71)
  B(270) = RCT(156)*V(37)
! B(271) = dA(157)/dV(37)
  B(271) = RCT(157)*V(75)
! B(272) = dA(157)/dV(75)
  B(272) = RCT(157)*V(37)
! B(273) = dA(158)/dV(40)
  B(273) = RCT(158)*V(75)
! B(274) = dA(158)/dV(75)
  B(274) = RCT(158)*V(40)
! B(275) = dA(159)/dV(41)
  B(275) = RCT(159)*V(71)
! B(276) = dA(159)/dV(71)
  B(276) = RCT(159)*V(41)
! B(277) = dA(160)/dV(41)
  B(277) = RCT(160)
! B(278) = dA(161)/dV(41)
  B(278) = RCT(161)*V(75)
! B(279) = dA(161)/dV(75)
  B(279) = RCT(161)*V(41)
! B(280) = dA(162)/dV(55)
  B(280) = RCT(162)*V(71)
! B(281) = dA(162)/dV(71)
  B(281) = RCT(162)*V(55)
! B(282) = dA(163)/dV(55)
  B(282) = RCT(163)*V(67)
! B(283) = dA(163)/dV(67)
  B(283) = RCT(163)*V(55)
! B(284) = dA(164)/dV(55)
  B(284) = RCT(164)*V(75)
! B(285) = dA(164)/dV(75)
  B(285) = RCT(164)*V(55)
! B(286) = dA(165)/dV(55)
  B(286) = RCT(165)*V(63)
! B(287) = dA(165)/dV(63)
  B(287) = RCT(165)*V(55)
! B(288) = dA(166)/dV(55)
  B(288) = RCT(166)
! B(289) = dA(167)/dV(59)
  B(289) = RCT(167)*V(71)
! B(290) = dA(167)/dV(71)
  B(290) = RCT(167)*V(59)
! B(291) = dA(168)/dV(59)
  B(291) = RCT(168)*V(67)
! B(292) = dA(168)/dV(67)
  B(292) = RCT(168)*V(59)
! B(293) = dA(169)/dV(59)
  B(293) = RCT(169)*V(63)
! B(294) = dA(169)/dV(63)
  B(294) = RCT(169)*V(59)
! B(295) = dA(170)/dV(59)
  B(295) = RCT(170)
! B(296) = dA(171)/dV(57)
  B(296) = RCT(171)*V(71)
! B(297) = dA(171)/dV(71)
  B(297) = RCT(171)*V(57)
! B(298) = dA(172)/dV(57)
  B(298) = RCT(172)*V(67)
! B(299) = dA(172)/dV(67)
  B(299) = RCT(172)*V(57)
! B(300) = dA(173)/dV(57)
  B(300) = RCT(173)*V(75)
! B(301) = dA(173)/dV(75)
  B(301) = RCT(173)*V(57)
! B(302) = dA(174)/dV(57)
  B(302) = RCT(174)
! B(303) = dA(175)/dV(66)
  B(303) = RCT(175)*V(71)
! B(304) = dA(175)/dV(71)
  B(304) = RCT(175)*V(66)
! B(305) = dA(176)/dV(66)
  B(305) = RCT(176)
! B(306) = dA(177)/dV(62)
  B(306) = RCT(177)*V(71)
! B(307) = dA(177)/dV(71)
  B(307) = RCT(177)*V(62)
! B(308) = dA(178)/dV(62)
  B(308) = RCT(178)
! B(309) = dA(179)/dV(38)
  B(309) = RCT(179)*V(71)
! B(310) = dA(179)/dV(71)
  B(310) = RCT(179)*V(38)
! B(311) = dA(180)/dV(38)
  B(311) = RCT(180)*V(67)
! B(312) = dA(180)/dV(67)
  B(312) = RCT(180)*V(38)
! B(313) = dA(181)/dV(35)
  B(313) = RCT(181)*V(71)
! B(314) = dA(181)/dV(71)
  B(314) = RCT(181)*V(35)
! B(315) = dA(182)/dV(35)
  B(315) = RCT(182)
! B(316) = dA(183)/dV(36)
  B(316) = RCT(183)*V(71)
! B(317) = dA(183)/dV(71)
  B(317) = RCT(183)*V(36)
! B(318) = dA(184)/dV(36)
  B(318) = RCT(184)
! B(319) = dA(185)/dV(12)
  B(319) = RCT(185)*V(71)
! B(320) = dA(185)/dV(71)
  B(320) = RCT(185)*V(12)
! B(321) = dA(186)/dV(48)
  B(321) = RCT(186)*V(71)
! B(322) = dA(186)/dV(71)
  B(322) = RCT(186)*V(48)
! B(323) = dA(187)/dV(48)
  B(323) = RCT(187)*V(67)
! B(324) = dA(187)/dV(67)
  B(324) = RCT(187)*V(48)
! B(325) = dA(188)/dV(48)
  B(325) = RCT(188)*V(75)
! B(326) = dA(188)/dV(75)
  B(326) = RCT(188)*V(48)
! B(327) = dA(189)/dV(48)
  B(327) = RCT(189)*V(63)
! B(328) = dA(189)/dV(63)
  B(328) = RCT(189)*V(48)
! B(329) = dA(190)/dV(52)
  B(329) = RCT(190)*V(71)
! B(330) = dA(190)/dV(71)
  B(330) = RCT(190)*V(52)
! B(331) = dA(191)/dV(52)
  B(331) = RCT(191)*V(67)
! B(332) = dA(191)/dV(67)
  B(332) = RCT(191)*V(52)
! B(333) = dA(192)/dV(52)
  B(333) = RCT(192)*V(75)
! B(334) = dA(192)/dV(75)
  B(334) = RCT(192)*V(52)
! B(335) = dA(193)/dV(52)
  B(335) = RCT(193)*V(63)
! B(336) = dA(193)/dV(63)
  B(336) = RCT(193)*V(52)
! B(337) = dA(194)/dV(54)
  B(337) = RCT(194)*V(71)
! B(338) = dA(194)/dV(71)
  B(338) = RCT(194)*V(54)
! B(339) = dA(195)/dV(54)
  B(339) = RCT(195)*V(67)
! B(340) = dA(195)/dV(67)
  B(340) = RCT(195)*V(54)
! B(341) = dA(196)/dV(54)
  B(341) = RCT(196)*V(75)
! B(342) = dA(196)/dV(75)
  B(342) = RCT(196)*V(54)
! B(343) = dA(197)/dV(54)
  B(343) = RCT(197)*V(63)
! B(344) = dA(197)/dV(63)
  B(344) = RCT(197)*V(54)
! B(345) = dA(198)/dV(13)
  B(345) = RCT(198)*V(71)
! B(346) = dA(198)/dV(71)
  B(346) = RCT(198)*V(13)
! B(347) = dA(199)/dV(20)
  B(347) = RCT(199)*V(71)
! B(348) = dA(199)/dV(71)
  B(348) = RCT(199)*V(20)
! B(349) = dA(200)/dV(39)
  B(349) = RCT(200)*V(71)
! B(350) = dA(200)/dV(71)
  B(350) = RCT(200)*V(39)
! B(351) = dA(201)/dV(24)
  B(351) = RCT(201)*V(71)
! B(352) = dA(201)/dV(71)
  B(352) = RCT(201)*V(24)
! B(353) = dA(202)/dV(33)
  B(353) = RCT(202)*V(71)
! B(354) = dA(202)/dV(71)
  B(354) = RCT(202)*V(33)
! B(355) = dA(203)/dV(26)
  B(355) = RCT(203)*V(71)
! B(356) = dA(203)/dV(71)
  B(356) = RCT(203)*V(26)
! B(357) = dA(204)/dV(34)
  B(357) = RCT(204)*V(71)
! B(358) = dA(204)/dV(71)
  B(358) = RCT(204)*V(34)
! B(359) = dA(205)/dV(27)
  B(359) = RCT(205)*V(71)
! B(360) = dA(205)/dV(71)
  B(360) = RCT(205)*V(27)
! B(361) = dA(206)/dV(56)
  B(361) = RCT(206)*V(71)
! B(362) = dA(206)/dV(71)
  B(362) = RCT(206)*V(56)
! B(363) = dA(207)/dV(56)
  B(363) = RCT(207)*V(67)
! B(364) = dA(207)/dV(67)
  B(364) = RCT(207)*V(56)
! B(365) = dA(208)/dV(56)
  B(365) = RCT(208)*V(75)
! B(366) = dA(208)/dV(75)
  B(366) = RCT(208)*V(56)
! B(367) = dA(209)/dV(56)
  B(367) = RCT(209)*V(63)
! B(368) = dA(209)/dV(63)
  B(368) = RCT(209)*V(56)
! B(369) = dA(210)/dV(58)
  B(369) = RCT(210)*V(71)
! B(370) = dA(210)/dV(71)
  B(370) = RCT(210)*V(58)
! B(371) = dA(211)/dV(58)
  B(371) = RCT(211)*V(67)
! B(372) = dA(211)/dV(67)
  B(372) = RCT(211)*V(58)
! B(373) = dA(212)/dV(58)
  B(373) = RCT(212)*V(75)
! B(374) = dA(212)/dV(75)
  B(374) = RCT(212)*V(58)
! B(375) = dA(213)/dV(58)
  B(375) = RCT(213)*V(63)
! B(376) = dA(213)/dV(63)
  B(376) = RCT(213)*V(58)
! B(377) = dA(214)/dV(39)
  B(377) = RCT(214)*V(67)
! B(378) = dA(214)/dV(67)
  B(378) = RCT(214)*V(39)
! B(379) = dA(215)/dV(50)
  B(379) = RCT(215)*V(71)
! B(380) = dA(215)/dV(71)
  B(380) = RCT(215)*V(50)
! B(381) = dA(216)/dV(50)
  B(381) = RCT(216)*V(67)
! B(382) = dA(216)/dV(67)
  B(382) = RCT(216)*V(50)
! B(383) = dA(217)/dV(50)
  B(383) = RCT(217)*V(75)
! B(384) = dA(217)/dV(75)
  B(384) = RCT(217)*V(50)
! B(385) = dA(218)/dV(50)
  B(385) = RCT(218)*V(63)
! B(386) = dA(218)/dV(63)
  B(386) = RCT(218)*V(50)
! B(387) = dA(219)/dV(10)
  B(387) = RCT(219)
! B(388) = dA(220)/dV(78)
  B(388) = RCT(220)
! B(389) = dA(221)/dV(10)
  B(389) = RCT(221)
! B(390) = dA(222)/dV(1)
  B(390) = RCT(222)
! B(391) = dA(223)/dV(47)
  B(391) = RCT(223)
! B(392) = dA(224)/dV(19)
  B(392) = RCT(224)
! B(393) = dA(225)/dV(2)
  B(393) = RCT(225)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = -B(390)
! JVS(2) = Jac_FULL(1,10)
  JVS(2) = B(74)+B(387)
! JVS(3) = Jac_FULL(1,71)
  JVS(3) = B(75)
! JVS(4) = Jac_FULL(2,2)
  JVS(4) = -B(393)
! JVS(5) = Jac_FULL(2,39)
  JVS(5) = 0.5*B(377)
! JVS(6) = Jac_FULL(2,50)
  JVS(6) = 0.135*B(381)
! JVS(7) = Jac_FULL(2,67)
  JVS(7) = 0.5*B(378)+0.135*B(382)
! JVS(8) = Jac_FULL(3,3)
  JVS(8) = 0
! JVS(9) = Jac_FULL(3,30)
  JVS(9) = B(223)
! JVS(10) = Jac_FULL(3,39)
  JVS(10) = 0.297*B(349)
! JVS(11) = Jac_FULL(3,48)
  JVS(11) = 0.37*B(323)
! JVS(12) = Jac_FULL(3,50)
  JVS(12) = 0.185*B(381)
! JVS(13) = Jac_FULL(3,52)
  JVS(13) = 0.204*B(331)
! JVS(14) = Jac_FULL(3,54)
  JVS(14) = 0.103*B(339)
! JVS(15) = Jac_FULL(3,55)
  JVS(15) = 0.333*B(282)
! JVS(16) = Jac_FULL(3,56)
  JVS(16) = 0.185*B(363)
! JVS(17) = Jac_FULL(3,57)
  JVS(17) = 0.1*B(298)
! JVS(18) = Jac_FULL(3,58)
  JVS(18) = 0.073*B(371)
! JVS(19) = Jac_FULL(3,59)
  JVS(19) = 0.351*B(291)
! JVS(20) = Jac_FULL(3,67)
  JVS(20) = 0.333*B(283)+0.351*B(292)+0.1*B(299)+0.37*B(324)+0.204*B(332)+0.103*B(340)+0.185*B(364)+0.073*B(372)+0.185&
              &*B(382)
! JVS(21) = Jac_FULL(3,71)
  JVS(21) = 0.297*B(350)
! JVS(22) = Jac_FULL(3,73)
  JVS(22) = B(224)
! JVS(23) = Jac_FULL(4,4)
  JVS(23) = 0
! JVS(24) = Jac_FULL(4,50)
  JVS(24) = 0.17*B(381)
! JVS(25) = Jac_FULL(4,56)
  JVS(25) = 0.05*B(363)
! JVS(26) = Jac_FULL(4,58)
  JVS(26) = 0.129*B(371)
! JVS(27) = Jac_FULL(4,67)
  JVS(27) = 0.05*B(364)+0.129*B(372)+0.17*B(382)
! JVS(28) = Jac_FULL(4,68)
  JVS(28) = 0.25*B(124)+B(128)+B(130)+B(134)
! JVS(29) = Jac_FULL(4,69)
  JVS(29) = B(135)
! JVS(30) = Jac_FULL(4,76)
  JVS(30) = B(129)
! JVS(31) = Jac_FULL(4,77)
  JVS(31) = B(131)
! JVS(32) = Jac_FULL(4,78)
  JVS(32) = 0.25*B(125)
! JVS(33) = Jac_FULL(5,5)
  JVS(33) = 0
! JVS(34) = Jac_FULL(5,52)
  JVS(34) = 0.15*B(331)
! JVS(35) = Jac_FULL(5,54)
  JVS(35) = 0.189*B(339)
! JVS(36) = Jac_FULL(5,56)
  JVS(36) = 0.119*B(363)
! JVS(37) = Jac_FULL(5,57)
  JVS(37) = 0.372*B(298)
! JVS(38) = Jac_FULL(5,58)
  JVS(38) = 0.247*B(371)
! JVS(39) = Jac_FULL(5,67)
  JVS(39) = 0.372*B(299)+0.15*B(332)+0.189*B(340)+0.119*B(364)+0.247*B(372)
! JVS(40) = Jac_FULL(5,69)
  JVS(40) = B(152)+B(172)+2*B(194)
! JVS(41) = Jac_FULL(5,70)
  JVS(41) = 0.25*B(184)+B(188)+B(190)+2*B(195)
! JVS(42) = Jac_FULL(5,72)
  JVS(42) = 0.25*B(142)+B(146)+B(148)+B(153)
! JVS(43) = Jac_FULL(5,76)
  JVS(43) = B(147)+B(166)+B(189)
! JVS(44) = Jac_FULL(5,77)
  JVS(44) = B(149)+B(168)+B(191)
! JVS(45) = Jac_FULL(5,78)
  JVS(45) = 0.25*B(143)+0.25*B(162)+0.25*B(185)
! JVS(46) = Jac_FULL(5,79)
  JVS(46) = 0.25*B(163)+B(167)+B(169)+B(173)
! JVS(47) = Jac_FULL(6,6)
  JVS(47) = 0
! JVS(48) = Jac_FULL(6,68)
  JVS(48) = 0.75*B(124)
! JVS(49) = Jac_FULL(6,78)
  JVS(49) = 0.75*B(125)
! JVS(50) = Jac_FULL(7,7)
  JVS(50) = 0
! JVS(51) = Jac_FULL(7,70)
  JVS(51) = 0.75*B(184)
! JVS(52) = Jac_FULL(7,72)
  JVS(52) = 0.75*B(142)
! JVS(53) = Jac_FULL(7,78)
  JVS(53) = 0.75*B(143)+0.75*B(162)+0.75*B(185)
! JVS(54) = Jac_FULL(7,79)
  JVS(54) = 0.75*B(163)
! JVS(55) = Jac_FULL(8,8)
  JVS(55) = 0
! JVS(56) = Jac_FULL(8,31)
  JVS(56) = 2*B(211)
! JVS(57) = Jac_FULL(8,50)
  JVS(57) = B(383)
! JVS(58) = Jac_FULL(8,74)
  JVS(58) = 2*B(212)
! JVS(59) = Jac_FULL(8,75)
  JVS(59) = B(384)
! JVS(60) = Jac_FULL(9,9)
  JVS(60) = 0
! JVS(61) = Jac_FULL(9,31)
  JVS(61) = 6*B(211)
! JVS(62) = Jac_FULL(9,41)
  JVS(62) = 7*B(277)
! JVS(63) = Jac_FULL(9,50)
  JVS(63) = 0.048*B(379)+0.07*B(381)+2.693*B(383)+0.55*B(385)
! JVS(64) = Jac_FULL(9,63)
  JVS(64) = 0.55*B(386)
! JVS(65) = Jac_FULL(9,67)
  JVS(65) = 0.07*B(382)
! JVS(66) = Jac_FULL(9,71)
  JVS(66) = 0.048*B(380)
! JVS(67) = Jac_FULL(9,74)
  JVS(67) = 6*B(212)
! JVS(68) = Jac_FULL(9,75)
  JVS(68) = 2.693*B(384)
! JVS(69) = Jac_FULL(10,10)
  JVS(69) = -B(74)-B(387)-B(389)
! JVS(70) = Jac_FULL(10,71)
  JVS(70) = -B(75)
! JVS(71) = Jac_FULL(11,11)
  JVS(71) = -B(32)-B(34)
! JVS(72) = Jac_FULL(11,67)
  JVS(72) = B(31)
! JVS(73) = Jac_FULL(12,12)
  JVS(73) = -B(319)
! JVS(74) = Jac_FULL(12,71)
  JVS(74) = -B(320)
! JVS(75) = Jac_FULL(13,13)
  JVS(75) = -B(345)
! JVS(76) = Jac_FULL(13,71)
  JVS(76) = -B(346)
! JVS(77) = Jac_FULL(14,14)
  JVS(77) = -B(264)
! JVS(78) = Jac_FULL(14,27)
  JVS(78) = 0.087*B(359)
! JVS(79) = Jac_FULL(14,54)
  JVS(79) = 0.031*B(339)
! JVS(80) = Jac_FULL(14,67)
  JVS(80) = 0.031*B(340)
! JVS(81) = Jac_FULL(14,71)
  JVS(81) = 0.087*B(360)
! JVS(82) = Jac_FULL(15,15)
  JVS(82) = -B(121)
! JVS(83) = Jac_FULL(15,68)
  JVS(83) = B(119)
! JVS(84) = Jac_FULL(15,74)
  JVS(84) = B(120)
! JVS(85) = Jac_FULL(16,16)
  JVS(85) = -B(139)
! JVS(86) = Jac_FULL(16,72)
  JVS(86) = B(137)
! JVS(87) = Jac_FULL(16,74)
  JVS(87) = B(138)
! JVS(88) = Jac_FULL(17,17)
  JVS(88) = -B(159)
! JVS(89) = Jac_FULL(17,74)
  JVS(89) = B(157)
! JVS(90) = Jac_FULL(17,79)
  JVS(90) = B(158)
! JVS(91) = Jac_FULL(18,18)
  JVS(91) = -B(181)
! JVS(92) = Jac_FULL(18,70)
  JVS(92) = B(179)
! JVS(93) = Jac_FULL(18,74)
  JVS(93) = B(180)
! JVS(94) = Jac_FULL(19,19)
  JVS(94) = -B(69)-B(70)-B(392)
! JVS(95) = Jac_FULL(19,71)
  JVS(95) = -B(71)
! JVS(96) = Jac_FULL(19,78)
  JVS(96) = B(63)+B(64)
! JVS(97) = Jac_FULL(20,20)
  JVS(97) = -B(347)
! JVS(98) = Jac_FULL(20,71)
  JVS(98) = -B(348)
! JVS(99) = Jac_FULL(21,21)
  JVS(99) = -B(245)
! JVS(100) = Jac_FULL(21,71)
  JVS(100) = -B(246)
! JVS(101) = Jac_FULL(22,22)
  JVS(101) = -B(23)-B(24)
! JVS(102) = Jac_FULL(22,74)
  JVS(102) = B(21)
! JVS(103) = Jac_FULL(22,75)
  JVS(103) = B(22)
! JVS(104) = Jac_FULL(23,23)
  JVS(104) = -B(38)-B(39)-B(40)
! JVS(105) = Jac_FULL(23,71)
  JVS(105) = B(36)-B(41)
! JVS(106) = Jac_FULL(23,73)
  JVS(106) = B(37)
! JVS(107) = Jac_FULL(24,24)
  JVS(107) = -B(351)
! JVS(108) = Jac_FULL(24,71)
  JVS(108) = -B(352)
! JVS(109) = Jac_FULL(25,24)
  JVS(109) = 0.236*B(351)
! JVS(110) = Jac_FULL(25,25)
  JVS(110) = -B(203)-B(205)
! JVS(111) = Jac_FULL(25,71)
  JVS(111) = 0.236*B(352)
! JVS(112) = Jac_FULL(25,74)
  JVS(112) = -B(204)
! JVS(113) = Jac_FULL(26,26)
  JVS(113) = -B(355)
! JVS(114) = Jac_FULL(26,71)
  JVS(114) = -B(356)
! JVS(115) = Jac_FULL(27,27)
  JVS(115) = -B(359)
! JVS(116) = Jac_FULL(27,71)
  JVS(116) = -B(360)
! JVS(117) = Jac_FULL(28,28)
  JVS(117) = -B(243)
! JVS(118) = Jac_FULL(28,69)
  JVS(118) = 0.25*B(110)
! JVS(119) = Jac_FULL(28,71)
  JVS(119) = -B(244)
! JVS(120) = Jac_FULL(28,76)
  JVS(120) = B(84)+0.25*B(92)+0.25*B(111)
! JVS(121) = Jac_FULL(28,77)
  JVS(121) = 0.25*B(93)
! JVS(122) = Jac_FULL(29,29)
  JVS(122) = -B(247)-B(249)
! JVS(123) = Jac_FULL(29,71)
  JVS(123) = -B(248)
! JVS(124) = Jac_FULL(29,76)
  JVS(124) = B(80)
! JVS(125) = Jac_FULL(29,78)
  JVS(125) = B(81)
! JVS(126) = Jac_FULL(30,30)
  JVS(126) = -B(222)-B(223)
! JVS(127) = Jac_FULL(30,61)
  JVS(127) = B(220)
! JVS(128) = Jac_FULL(30,73)
  JVS(128) = -B(224)
! JVS(129) = Jac_FULL(30,78)
  JVS(129) = B(221)
! JVS(130) = Jac_FULL(31,31)
  JVS(130) = -B(211)-B(213)-B(215)
! JVS(131) = Jac_FULL(31,40)
  JVS(131) = B(273)
! JVS(132) = Jac_FULL(31,74)
  JVS(132) = -B(212)
! JVS(133) = Jac_FULL(31,75)
  JVS(133) = B(274)
! JVS(134) = Jac_FULL(31,78)
  JVS(134) = -B(214)
! JVS(135) = Jac_FULL(32,32)
  JVS(135) = -B(57)-B(58)-B(59)
! JVS(136) = Jac_FULL(32,71)
  JVS(136) = -B(60)
! JVS(137) = Jac_FULL(32,74)
  JVS(137) = B(55)
! JVS(138) = Jac_FULL(32,78)
  JVS(138) = B(56)
! JVS(139) = Jac_FULL(33,33)
  JVS(139) = -B(353)
! JVS(140) = Jac_FULL(33,71)
  JVS(140) = -B(354)
! JVS(141) = Jac_FULL(34,34)
  JVS(141) = -B(357)
! JVS(142) = Jac_FULL(34,71)
  JVS(142) = -B(358)
! JVS(143) = Jac_FULL(35,27)
  JVS(143) = 0.099*B(359)
! JVS(144) = Jac_FULL(35,34)
  JVS(144) = 0.108*B(357)
! JVS(145) = Jac_FULL(35,35)
  JVS(145) = -B(313)-B(315)
! JVS(146) = Jac_FULL(35,71)
  JVS(146) = -B(314)+0.108*B(358)+0.099*B(360)
! JVS(147) = Jac_FULL(36,27)
  JVS(147) = 0.093*B(359)
! JVS(148) = Jac_FULL(36,34)
  JVS(148) = 0.051*B(357)
! JVS(149) = Jac_FULL(36,36)
  JVS(149) = -B(316)-B(318)
! JVS(150) = Jac_FULL(36,71)
  JVS(150) = -B(317)+0.051*B(358)+0.093*B(360)
! JVS(151) = Jac_FULL(37,27)
  JVS(151) = 0.187*B(359)
! JVS(152) = Jac_FULL(37,34)
  JVS(152) = 0.207*B(357)
! JVS(153) = Jac_FULL(37,37)
  JVS(153) = -B(269)-B(271)
! JVS(154) = Jac_FULL(37,71)
  JVS(154) = -B(270)+0.207*B(358)+0.187*B(360)
! JVS(155) = Jac_FULL(37,75)
  JVS(155) = -B(272)
! JVS(156) = Jac_FULL(38,27)
  JVS(156) = 0.561*B(359)
! JVS(157) = Jac_FULL(38,34)
  JVS(157) = 0.491*B(357)
! JVS(158) = Jac_FULL(38,38)
  JVS(158) = -B(309)-B(311)
! JVS(159) = Jac_FULL(38,67)
  JVS(159) = -B(312)
! JVS(160) = Jac_FULL(38,71)
  JVS(160) = -B(310)+0.491*B(358)+0.561*B(360)
! JVS(161) = Jac_FULL(39,39)
  JVS(161) = -B(349)-B(377)
! JVS(162) = Jac_FULL(39,67)
  JVS(162) = -B(378)
! JVS(163) = Jac_FULL(39,71)
  JVS(163) = -B(350)
! JVS(164) = Jac_FULL(40,31)
  JVS(164) = B(213)+B(215)
! JVS(165) = Jac_FULL(40,40)
  JVS(165) = -B(273)
! JVS(166) = Jac_FULL(40,51)
  JVS(166) = B(206)
! JVS(167) = Jac_FULL(40,74)
  JVS(167) = B(207)
! JVS(168) = Jac_FULL(40,75)
  JVS(168) = -B(274)
! JVS(169) = Jac_FULL(40,78)
  JVS(169) = B(214)
! JVS(170) = Jac_FULL(41,27)
  JVS(170) = 0.05*B(359)
! JVS(171) = Jac_FULL(41,34)
  JVS(171) = 0.059*B(357)
! JVS(172) = Jac_FULL(41,41)
  JVS(172) = -B(275)-B(277)-B(278)
! JVS(173) = Jac_FULL(41,58)
  JVS(173) = 0.061*B(369)+0.042*B(371)+0.015*B(373)
! JVS(174) = Jac_FULL(41,67)
  JVS(174) = 0.042*B(372)
! JVS(175) = Jac_FULL(41,71)
  JVS(175) = -B(276)+0.059*B(358)+0.05*B(360)+0.061*B(370)
! JVS(176) = Jac_FULL(41,75)
  JVS(176) = -B(279)+0.015*B(374)
! JVS(177) = Jac_FULL(42,42)
  JVS(177) = -B(250)-B(252)
! JVS(178) = Jac_FULL(42,69)
  JVS(178) = B(108)
! JVS(179) = Jac_FULL(42,71)
  JVS(179) = -B(251)
! JVS(180) = Jac_FULL(42,77)
  JVS(180) = B(88)
! JVS(181) = Jac_FULL(42,78)
  JVS(181) = B(89)+B(109)
! JVS(182) = Jac_FULL(43,34)
  JVS(182) = 0.017*B(357)
! JVS(183) = Jac_FULL(43,43)
  JVS(183) = -B(265)-B(267)
! JVS(184) = Jac_FULL(43,51)
  JVS(184) = B(208)+B(210)
! JVS(185) = Jac_FULL(43,71)
  JVS(185) = -B(266)+0.017*B(358)
! JVS(186) = Jac_FULL(43,75)
  JVS(186) = -B(268)
! JVS(187) = Jac_FULL(43,78)
  JVS(187) = B(209)
! JVS(188) = Jac_FULL(44,27)
  JVS(188) = 0.287*B(359)
! JVS(189) = Jac_FULL(44,34)
  JVS(189) = 0.119*B(357)
! JVS(190) = Jac_FULL(44,35)
  JVS(190) = 0.5*B(315)
! JVS(191) = Jac_FULL(44,36)
  JVS(191) = 0.5*B(318)
! JVS(192) = Jac_FULL(44,37)
  JVS(192) = 0.23*B(269)
! JVS(193) = Jac_FULL(44,44)
  JVS(193) = -B(259)-B(260)-B(262)
! JVS(194) = Jac_FULL(44,55)
  JVS(194) = 0.084*B(280)+0.9*B(282)
! JVS(195) = Jac_FULL(44,57)
  JVS(195) = 0.174*B(296)+0.742*B(298)+0.008*B(300)
! JVS(196) = Jac_FULL(44,59)
  JVS(196) = 0.3*B(289)+0.95*B(291)
! JVS(197) = Jac_FULL(44,67)
  JVS(197) = 0.9*B(283)+0.95*B(292)+0.742*B(299)
! JVS(198) = Jac_FULL(44,71)
  JVS(198) = -B(261)+0.23*B(270)+0.084*B(281)+0.3*B(290)+0.174*B(297)+0.119*B(358)+0.287*B(360)
! JVS(199) = Jac_FULL(44,75)
  JVS(199) = -B(263)+0.008*B(301)
! JVS(200) = Jac_FULL(45,33)
  JVS(200) = 0.002*B(353)
! JVS(201) = Jac_FULL(45,35)
  JVS(201) = B(315)
! JVS(202) = Jac_FULL(45,36)
  JVS(202) = B(318)
! JVS(203) = Jac_FULL(45,38)
  JVS(203) = B(309)+1.5*B(311)
! JVS(204) = Jac_FULL(45,39)
  JVS(204) = 0.393*B(349)+1.5*B(377)
! JVS(205) = Jac_FULL(45,44)
  JVS(205) = B(259)+B(260)+B(262)
! JVS(206) = Jac_FULL(45,45)
  JVS(206) = -B(49)
! JVS(207) = Jac_FULL(45,48)
  JVS(207) = 0.5*B(323)+0.491*B(327)
! JVS(208) = Jac_FULL(45,49)
  JVS(208) = 2*B(253)+B(254)+1.26*B(255)+1.26*B(257)
! JVS(209) = Jac_FULL(45,50)
  JVS(209) = 0.51*B(381)
! JVS(210) = Jac_FULL(45,52)
  JVS(210) = 0.275*B(331)
! JVS(211) = Jac_FULL(45,54)
  JVS(211) = 0.157*B(339)
! JVS(212) = Jac_FULL(45,55)
  JVS(212) = 0.416*B(280)+0.45*B(282)+0.5*B(284)+0.67*B(288)
! JVS(213) = Jac_FULL(45,56)
  JVS(213) = 0.345*B(363)
! JVS(214) = Jac_FULL(45,57)
  JVS(214) = 0.336*B(296)+0.498*B(298)+0.572*B(300)+1.233*B(302)
! JVS(215) = Jac_FULL(45,58)
  JVS(215) = 0.265*B(371)+0.012*B(375)
! JVS(216) = Jac_FULL(45,59)
  JVS(216) = 0.475*B(291)+0.7*B(295)
! JVS(217) = Jac_FULL(45,60)
  JVS(217) = B(229)
! JVS(218) = Jac_FULL(45,61)
  JVS(218) = B(216)+B(217)+B(218)+B(225)
! JVS(219) = Jac_FULL(45,63)
  JVS(219) = 0.491*B(328)+0.012*B(376)
! JVS(220) = Jac_FULL(45,64)
  JVS(220) = 0.034*B(232)+B(234)
! JVS(221) = Jac_FULL(45,67)
  JVS(221) = 0.45*B(283)+0.475*B(292)+0.498*B(299)+1.5*B(312)+0.5*B(324)+0.275*B(332)+0.157*B(340)+0.345*B(364)+0.265&
               &*B(372)+1.5*B(378)+0.51*B(382)
! JVS(222) = Jac_FULL(45,71)
  JVS(222) = -B(50)+B(219)+0.034*B(233)+1.26*B(256)+B(261)+0.416*B(281)+0.336*B(297)+B(310)+0.393*B(350)+0.002*B(354)
! JVS(223) = Jac_FULL(45,75)
  JVS(223) = B(226)+1.26*B(258)+B(263)+0.5*B(285)+0.572*B(301)
! JVS(224) = Jac_FULL(46,20)
  JVS(224) = 0.704*B(347)
! JVS(225) = Jac_FULL(46,24)
  JVS(225) = 0.024*B(351)
! JVS(226) = Jac_FULL(46,25)
  JVS(226) = B(205)
! JVS(227) = Jac_FULL(46,26)
  JVS(227) = 0.072*B(355)
! JVS(228) = Jac_FULL(46,33)
  JVS(228) = 0.452*B(353)
! JVS(229) = Jac_FULL(46,46)
  JVS(229) = -B(237)-B(239)
! JVS(230) = Jac_FULL(46,54)
  JVS(230) = 0.13*B(339)
! JVS(231) = Jac_FULL(46,56)
  JVS(231) = 0.005*B(361)+0.001*B(363)+0.024*B(365)
! JVS(232) = Jac_FULL(46,58)
  JVS(232) = 0.127*B(369)+0.045*B(371)+0.102*B(373)
! JVS(233) = Jac_FULL(46,62)
  JVS(233) = 0.006*B(306)+0.02*B(308)
! JVS(234) = Jac_FULL(46,67)
  JVS(234) = 0.13*B(340)+0.001*B(364)+0.045*B(372)
! JVS(235) = Jac_FULL(46,71)
  JVS(235) = -B(238)+0.006*B(307)+0.704*B(348)+0.024*B(352)+0.452*B(354)+0.072*B(356)+0.005*B(362)+0.127*B(370)
! JVS(236) = Jac_FULL(46,74)
  JVS(236) = 0
! JVS(237) = Jac_FULL(46,75)
  JVS(237) = 0.024*B(366)+0.102*B(374)
! JVS(238) = Jac_FULL(47,22)
  JVS(238) = 2*B(24)
! JVS(239) = Jac_FULL(47,37)
  JVS(239) = B(271)
! JVS(240) = Jac_FULL(47,40)
  JVS(240) = B(273)
! JVS(241) = Jac_FULL(47,41)
  JVS(241) = B(278)
! JVS(242) = Jac_FULL(47,43)
  JVS(242) = B(267)
! JVS(243) = Jac_FULL(47,44)
  JVS(243) = B(262)
! JVS(244) = Jac_FULL(47,47)
  JVS(244) = -B(46)-B(48)-B(391)
! JVS(245) = Jac_FULL(47,49)
  JVS(245) = B(257)
! JVS(246) = Jac_FULL(47,51)
  JVS(246) = 0
! JVS(247) = Jac_FULL(47,55)
  JVS(247) = 0.5*B(284)
! JVS(248) = Jac_FULL(47,57)
  JVS(248) = 0.15*B(300)
! JVS(249) = Jac_FULL(47,58)
  JVS(249) = 0
! JVS(250) = Jac_FULL(47,59)
  JVS(250) = 0
! JVS(251) = Jac_FULL(47,60)
  JVS(251) = B(230)
! JVS(252) = Jac_FULL(47,61)
  JVS(252) = B(225)
! JVS(253) = Jac_FULL(47,64)
  JVS(253) = B(235)
! JVS(254) = Jac_FULL(47,67)
  JVS(254) = 0
! JVS(255) = Jac_FULL(47,71)
  JVS(255) = B(42)-B(47)
! JVS(256) = Jac_FULL(47,74)
  JVS(256) = B(43)
! JVS(257) = Jac_FULL(47,75)
  JVS(257) = 0.2*B(66)+B(226)+B(231)+B(236)+B(258)+B(263)+B(268)+B(272)+B(274)+B(279)+0.5*B(285)+0.15*B(301)
! JVS(258) = Jac_FULL(47,78)
  JVS(258) = 0.2*B(67)
! JVS(259) = Jac_FULL(48,48)
  JVS(259) = -B(321)-B(323)-B(325)-B(327)
! JVS(260) = Jac_FULL(48,63)
  JVS(260) = -B(328)
! JVS(261) = Jac_FULL(48,67)
  JVS(261) = -B(324)
! JVS(262) = Jac_FULL(48,71)
  JVS(262) = -B(322)
! JVS(263) = Jac_FULL(48,75)
  JVS(263) = -B(326)
! JVS(264) = Jac_FULL(49,27)
  JVS(264) = 0.097*B(359)
! JVS(265) = Jac_FULL(49,34)
  JVS(265) = 0.118*B(357)
! JVS(266) = Jac_FULL(49,35)
  JVS(266) = 0.5*B(315)
! JVS(267) = Jac_FULL(49,36)
  JVS(267) = 0.5*B(318)
! JVS(268) = Jac_FULL(49,38)
  JVS(268) = B(311)
! JVS(269) = Jac_FULL(49,39)
  JVS(269) = 0.607*B(349)
! JVS(270) = Jac_FULL(49,43)
  JVS(270) = 0.23*B(265)
! JVS(271) = Jac_FULL(49,48)
  JVS(271) = 0.009*B(327)
! JVS(272) = Jac_FULL(49,49)
  JVS(272) = -B(253)-B(254)-B(255)-B(257)
! JVS(273) = Jac_FULL(49,51)
  JVS(273) = 0
! JVS(274) = Jac_FULL(49,54)
  JVS(274) = 0.001*B(339)
! JVS(275) = Jac_FULL(49,57)
  JVS(275) = 0.15*B(296)+0.023*B(298)
! JVS(276) = Jac_FULL(49,63)
  JVS(276) = 0.009*B(328)
! JVS(277) = Jac_FULL(49,67)
  JVS(277) = 0.023*B(299)+B(312)+0.001*B(340)
! JVS(278) = Jac_FULL(49,71)
  JVS(278) = -B(256)+0.23*B(266)+0.15*B(297)+0.607*B(350)+0.118*B(358)+0.097*B(360)
! JVS(279) = Jac_FULL(49,75)
  JVS(279) = -B(258)
! JVS(280) = Jac_FULL(49,78)
  JVS(280) = 0
! JVS(281) = Jac_FULL(50,50)
  JVS(281) = -B(379)-B(381)-B(383)-B(385)
! JVS(282) = Jac_FULL(50,63)
  JVS(282) = -B(386)
! JVS(283) = Jac_FULL(50,67)
  JVS(283) = -B(382)
! JVS(284) = Jac_FULL(50,71)
  JVS(284) = -B(380)
! JVS(285) = Jac_FULL(50,75)
  JVS(285) = -B(384)
! JVS(286) = Jac_FULL(51,37)
  JVS(286) = 0.24*B(269)+B(271)
! JVS(287) = Jac_FULL(51,43)
  JVS(287) = 0.24*B(265)+B(267)
! JVS(288) = Jac_FULL(51,51)
  JVS(288) = -B(206)-B(208)-B(210)
! JVS(289) = Jac_FULL(51,68)
  JVS(289) = B(174)
! JVS(290) = Jac_FULL(51,70)
  JVS(290) = B(200)
! JVS(291) = Jac_FULL(51,71)
  JVS(291) = 0.24*B(266)+0.24*B(270)
! JVS(292) = Jac_FULL(51,72)
  JVS(292) = B(176)
! JVS(293) = Jac_FULL(51,73)
  JVS(293) = B(160)
! JVS(294) = Jac_FULL(51,74)
  JVS(294) = -B(207)
! JVS(295) = Jac_FULL(51,75)
  JVS(295) = B(164)+B(268)+B(272)
! JVS(296) = Jac_FULL(51,78)
  JVS(296) = -B(209)
! JVS(297) = Jac_FULL(51,79)
  JVS(297) = B(161)+B(165)+B(175)+B(177)+2*B(178)+B(201)
! JVS(298) = Jac_FULL(52,52)
  JVS(298) = -B(329)-B(331)-B(333)-B(335)
! JVS(299) = Jac_FULL(52,63)
  JVS(299) = -B(336)
! JVS(300) = Jac_FULL(52,67)
  JVS(300) = -B(332)
! JVS(301) = Jac_FULL(52,71)
  JVS(301) = -B(330)
! JVS(302) = Jac_FULL(52,75)
  JVS(302) = -B(334)
! JVS(303) = Jac_FULL(53,24)
  JVS(303) = 0.559*B(351)
! JVS(304) = Jac_FULL(53,26)
  JVS(304) = 0.948*B(355)
! JVS(305) = Jac_FULL(53,33)
  JVS(305) = 0.936*B(353)
! JVS(306) = Jac_FULL(53,35)
  JVS(306) = B(313)+B(315)
! JVS(307) = Jac_FULL(53,36)
  JVS(307) = B(316)+B(318)
! JVS(308) = Jac_FULL(53,46)
  JVS(308) = B(237)
! JVS(309) = Jac_FULL(53,52)
  JVS(309) = 0.079*B(329)+0.126*B(331)+0.187*B(333)+0.24*B(335)
! JVS(310) = Jac_FULL(53,53)
  JVS(310) = -B(95)-B(97)-B(99)-B(101)-B(103)-B(116)-B(132)-B(150)-B(170)-B(192)
! JVS(311) = Jac_FULL(53,54)
  JVS(311) = 0.5*B(337)+0.729*B(339)+0.75*B(341)
! JVS(312) = Jac_FULL(53,56)
  JVS(312) = 0.205*B(361)+0.488*B(365)
! JVS(313) = Jac_FULL(53,58)
  JVS(313) = 0.001*B(369)+0.137*B(371)+0.711*B(373)
! JVS(314) = Jac_FULL(53,59)
  JVS(314) = 0.675*B(289)
! JVS(315) = Jac_FULL(53,62)
  JVS(315) = 0.596*B(306)+0.152*B(308)
! JVS(316) = Jac_FULL(53,63)
  JVS(316) = 0.24*B(336)
! JVS(317) = Jac_FULL(53,65)
  JVS(317) = 0.616*B(240)
! JVS(318) = Jac_FULL(53,66)
  JVS(318) = 0.515*B(305)
! JVS(319) = Jac_FULL(53,67)
  JVS(319) = 0.126*B(332)+0.729*B(340)+0.137*B(372)
! JVS(320) = Jac_FULL(53,68)
  JVS(320) = -B(133)+B(174)
! JVS(321) = Jac_FULL(53,69)
  JVS(321) = -B(117)
! JVS(322) = Jac_FULL(53,70)
  JVS(322) = -B(193)+B(200)
! JVS(323) = Jac_FULL(53,71)
  JVS(323) = B(238)+0.616*B(241)+0.675*B(290)+0.596*B(307)+B(314)+B(317)+0.079*B(330)+0.5*B(338)+0.559*B(352)+0.936&
               &*B(354)+0.948*B(356)+0.205*B(362)+0.001*B(370)
! JVS(324) = Jac_FULL(53,72)
  JVS(324) = -B(151)+B(176)
! JVS(325) = Jac_FULL(53,73)
  JVS(325) = -B(96)+B(160)
! JVS(326) = Jac_FULL(53,74)
  JVS(326) = 0
! JVS(327) = Jac_FULL(53,75)
  JVS(327) = -B(100)+B(164)+0.187*B(334)+0.75*B(342)+0.488*B(366)+0.711*B(374)
! JVS(328) = Jac_FULL(53,76)
  JVS(328) = -B(102)
! JVS(329) = Jac_FULL(53,77)
  JVS(329) = -B(104)
! JVS(330) = Jac_FULL(53,78)
  JVS(330) = -B(98)
! JVS(331) = Jac_FULL(53,79)
  JVS(331) = B(161)+B(165)-B(171)+B(175)+B(177)+2*B(178)+B(201)
! JVS(332) = Jac_FULL(54,54)
  JVS(332) = -B(337)-B(339)-B(341)-B(343)
! JVS(333) = Jac_FULL(54,63)
  JVS(333) = -B(344)
! JVS(334) = Jac_FULL(54,67)
  JVS(334) = -B(340)
! JVS(335) = Jac_FULL(54,71)
  JVS(335) = -B(338)
! JVS(336) = Jac_FULL(54,75)
  JVS(336) = -B(342)
! JVS(337) = Jac_FULL(55,52)
  JVS(337) = 0.23*B(329)+0.39*B(331)
! JVS(338) = Jac_FULL(55,55)
  JVS(338) = -B(280)-B(282)-B(284)-B(286)-B(288)
! JVS(339) = Jac_FULL(55,58)
  JVS(339) = 0.025*B(369)+0.026*B(371)+0.012*B(375)
! JVS(340) = Jac_FULL(55,63)
  JVS(340) = -B(287)+0.012*B(376)
! JVS(341) = Jac_FULL(55,67)
  JVS(341) = -B(283)+0.39*B(332)+0.026*B(372)
! JVS(342) = Jac_FULL(55,71)
  JVS(342) = -B(281)+0.23*B(330)+0.025*B(370)
! JVS(343) = Jac_FULL(55,75)
  JVS(343) = -B(285)
! JVS(344) = Jac_FULL(56,56)
  JVS(344) = -B(361)-B(363)-B(365)-B(367)
! JVS(345) = Jac_FULL(56,63)
  JVS(345) = -B(368)
! JVS(346) = Jac_FULL(56,67)
  JVS(346) = -B(364)
! JVS(347) = Jac_FULL(56,71)
  JVS(347) = -B(362)
! JVS(348) = Jac_FULL(56,75)
  JVS(348) = -B(366)
! JVS(349) = Jac_FULL(57,52)
  JVS(349) = 0.357*B(329)+0.936*B(333)
! JVS(350) = Jac_FULL(57,57)
  JVS(350) = -B(296)-B(298)-B(300)-B(302)
! JVS(351) = Jac_FULL(57,58)
  JVS(351) = 0.025*B(369)
! JVS(352) = Jac_FULL(57,63)
  JVS(352) = 0
! JVS(353) = Jac_FULL(57,67)
  JVS(353) = -B(299)
! JVS(354) = Jac_FULL(57,71)
  JVS(354) = -B(297)+0.357*B(330)+0.025*B(370)
! JVS(355) = Jac_FULL(57,75)
  JVS(355) = -B(301)+0.936*B(334)
! JVS(356) = Jac_FULL(58,58)
  JVS(356) = -B(369)-B(371)-B(373)-B(375)
! JVS(357) = Jac_FULL(58,63)
  JVS(357) = -B(376)
! JVS(358) = Jac_FULL(58,67)
  JVS(358) = -B(372)
! JVS(359) = Jac_FULL(58,71)
  JVS(359) = -B(370)
! JVS(360) = Jac_FULL(58,75)
  JVS(360) = -B(374)
! JVS(361) = Jac_FULL(59,52)
  JVS(361) = 0.32*B(329)+0.16*B(331)
! JVS(362) = Jac_FULL(59,58)
  JVS(362) = 0.019*B(371)+0.048*B(373)
! JVS(363) = Jac_FULL(59,59)
  JVS(363) = -B(289)-B(291)-B(293)-B(295)
! JVS(364) = Jac_FULL(59,63)
  JVS(364) = -B(294)
! JVS(365) = Jac_FULL(59,67)
  JVS(365) = -B(292)+0.16*B(332)+0.019*B(372)
! JVS(366) = Jac_FULL(59,71)
  JVS(366) = -B(290)+0.32*B(330)
! JVS(367) = Jac_FULL(59,75)
  JVS(367) = 0.048*B(374)
! JVS(368) = Jac_FULL(60,13)
  JVS(368) = B(345)
! JVS(369) = Jac_FULL(60,21)
  JVS(369) = 0.96*B(245)
! JVS(370) = Jac_FULL(60,24)
  JVS(370) = 0.445*B(351)
! JVS(371) = Jac_FULL(60,26)
  JVS(371) = 0.099*B(355)
! JVS(372) = Jac_FULL(60,33)
  JVS(372) = 0.455*B(353)
! JVS(373) = Jac_FULL(60,48)
  JVS(373) = 0.195*B(321)+0.25*B(327)
! JVS(374) = Jac_FULL(60,50)
  JVS(374) = 0.984*B(379)+0.5*B(381)
! JVS(375) = Jac_FULL(60,56)
  JVS(375) = 0.294*B(361)+0.154*B(363)+0.009*B(365)
! JVS(376) = Jac_FULL(60,57)
  JVS(376) = 0.129*B(296)+0.047*B(298)+0.467*B(302)
! JVS(377) = Jac_FULL(60,58)
  JVS(377) = 0.732*B(369)+0.456*B(371)+0.507*B(373)
! JVS(378) = Jac_FULL(60,60)
  JVS(378) = -B(227)-B(229)-B(230)
! JVS(379) = Jac_FULL(60,62)
  JVS(379) = 0.439*B(306)+0.431*B(308)
! JVS(380) = Jac_FULL(60,63)
  JVS(380) = 0.25*B(328)
! JVS(381) = Jac_FULL(60,64)
  JVS(381) = 0.034*B(232)+B(234)
! JVS(382) = Jac_FULL(60,65)
  JVS(382) = 0.482*B(240)+B(242)
! JVS(383) = Jac_FULL(60,66)
  JVS(383) = 0.084*B(303)+0.246*B(305)
! JVS(384) = Jac_FULL(60,67)
  JVS(384) = 0.047*B(299)+0.154*B(364)+0.456*B(372)+0.5*B(382)
! JVS(385) = Jac_FULL(60,68)
  JVS(385) = B(154)
! JVS(386) = Jac_FULL(60,70)
  JVS(386) = B(198)
! JVS(387) = Jac_FULL(60,71)
  JVS(387) = -B(228)+0.034*B(233)+0.482*B(241)+0.96*B(246)+0.129*B(297)+0.084*B(304)+0.439*B(307)+0.195*B(322)+B(346)&
               &+0.445*B(352)+0.455*B(354)+0.099*B(356)+0.294*B(362)+0.732*B(370)+0.984*B(380)
! JVS(388) = Jac_FULL(60,72)
  JVS(388) = B(140)+B(144)+B(155)+2*B(156)+B(176)+B(199)
! JVS(389) = Jac_FULL(60,73)
  JVS(389) = B(141)
! JVS(390) = Jac_FULL(60,75)
  JVS(390) = B(145)-B(231)+0.009*B(366)+0.507*B(374)
! JVS(391) = Jac_FULL(60,79)
  JVS(391) = B(177)
! JVS(392) = Jac_FULL(61,21)
  JVS(392) = 0.081*B(245)
! JVS(393) = Jac_FULL(61,24)
  JVS(393) = 0.026*B(351)
! JVS(394) = Jac_FULL(61,26)
  JVS(394) = 0.026*B(355)
! JVS(395) = Jac_FULL(61,28)
  JVS(395) = B(243)
! JVS(396) = Jac_FULL(61,29)
  JVS(396) = 0.35*B(247)+B(249)
! JVS(397) = Jac_FULL(61,30)
  JVS(397) = B(222)
! JVS(398) = Jac_FULL(61,33)
  JVS(398) = 0.024*B(353)
! JVS(399) = Jac_FULL(61,39)
  JVS(399) = 0.096*B(349)
! JVS(400) = Jac_FULL(61,46)
  JVS(400) = B(237)
! JVS(401) = Jac_FULL(61,48)
  JVS(401) = 1.61*B(321)+B(323)+0.191*B(327)
! JVS(402) = Jac_FULL(61,49)
  JVS(402) = B(254)
! JVS(403) = Jac_FULL(61,50)
  JVS(403) = 0.984*B(379)+0.5*B(381)
! JVS(404) = Jac_FULL(61,51)
  JVS(404) = 0
! JVS(405) = Jac_FULL(61,52)
  JVS(405) = 0.624*B(329)+0.592*B(331)+0.24*B(335)
! JVS(406) = Jac_FULL(61,54)
  JVS(406) = 0.276*B(337)+0.235*B(339)
! JVS(407) = Jac_FULL(61,55)
  JVS(407) = 0.084*B(280)+0.2*B(282)+0.67*B(288)
! JVS(408) = Jac_FULL(61,56)
  JVS(408) = 0.732*B(361)+0.5*B(363)
! JVS(409) = Jac_FULL(61,57)
  JVS(409) = 0.055*B(296)+0.125*B(298)+0.227*B(300)+0.3*B(302)
! JVS(410) = Jac_FULL(61,58)
  JVS(410) = 0.244*B(369)+0.269*B(371)+0.079*B(373)
! JVS(411) = Jac_FULL(61,59)
  JVS(411) = 0.3*B(289)+0.1*B(291)
! JVS(412) = Jac_FULL(61,61)
  JVS(412) = -B(216)-B(217)-B(218)-B(220)-B(225)
! JVS(413) = Jac_FULL(61,62)
  JVS(413) = 0.01*B(306)+0.134*B(308)
! JVS(414) = Jac_FULL(61,63)
  JVS(414) = 0.191*B(328)+0.24*B(336)
! JVS(415) = Jac_FULL(61,65)
  JVS(415) = 0.115*B(240)
! JVS(416) = Jac_FULL(61,66)
  JVS(416) = 0.213*B(303)+0.506*B(305)
! JVS(417) = Jac_FULL(61,67)
  JVS(417) = 0.2*B(283)+0.1*B(292)+0.125*B(299)+B(324)+0.592*B(332)+0.235*B(340)+0.5*B(364)+0.269*B(372)+0.5*B(382)
! JVS(418) = Jac_FULL(61,68)
  JVS(418) = B(128)+B(196)
! JVS(419) = Jac_FULL(61,69)
  JVS(419) = 0.75*B(110)
! JVS(420) = Jac_FULL(61,70)
  JVS(420) = B(182)+B(186)+B(188)+B(197)+B(198)+B(200)+2*B(202)
! JVS(421) = Jac_FULL(61,71)
  JVS(421) = -B(219)+B(238)+0.115*B(241)+B(244)+0.081*B(246)+0.35*B(248)+0.084*B(281)+0.3*B(290)+0.055*B(297)+0.213&
               &*B(304)+0.01*B(307)+1.61*B(322)+0.624*B(330)+0.276*B(338)+0.096*B(350)+0.026*B(352)+0.024*B(354)+0.026&
               &*B(356)+0.732*B(362)+0.244*B(370)+0.984*B(380)
! JVS(422) = Jac_FULL(61,72)
  JVS(422) = B(146)+B(199)
! JVS(423) = Jac_FULL(61,73)
  JVS(423) = B(78)+B(183)
! JVS(424) = Jac_FULL(61,74)
  JVS(424) = 0
! JVS(425) = Jac_FULL(61,75)
  JVS(425) = B(82)+B(187)-B(226)+0.227*B(301)+0.079*B(374)
! JVS(426) = Jac_FULL(61,76)
  JVS(426) = B(79)+B(83)+B(84)+2*B(85)+0.75*B(92)+0.75*B(111)+B(129)+B(147)+B(166)+B(189)
! JVS(427) = Jac_FULL(61,77)
  JVS(427) = 0.75*B(93)
! JVS(428) = Jac_FULL(61,78)
  JVS(428) = -B(221)
! JVS(429) = Jac_FULL(61,79)
  JVS(429) = B(167)+B(201)
! JVS(430) = Jac_FULL(62,25)
  JVS(430) = B(203)
! JVS(431) = Jac_FULL(62,54)
  JVS(431) = 0.276*B(341)
! JVS(432) = Jac_FULL(62,56)
  JVS(432) = 0.511*B(365)
! JVS(433) = Jac_FULL(62,57)
  JVS(433) = 0.572*B(300)
! JVS(434) = Jac_FULL(62,58)
  JVS(434) = 0.321*B(373)
! JVS(435) = Jac_FULL(62,62)
  JVS(435) = -0.69*B(306)-B(308)
! JVS(436) = Jac_FULL(62,63)
  JVS(436) = 0
! JVS(437) = Jac_FULL(62,67)
  JVS(437) = 0
! JVS(438) = Jac_FULL(62,69)
  JVS(438) = B(106)
! JVS(439) = Jac_FULL(62,71)
  JVS(439) = -0.69*B(307)
! JVS(440) = Jac_FULL(62,73)
  JVS(440) = B(107)
! JVS(441) = Jac_FULL(62,74)
  JVS(441) = B(204)
! JVS(442) = Jac_FULL(62,75)
  JVS(442) = 0.572*B(301)+0.276*B(342)+0.511*B(366)+0.321*B(374)
! JVS(443) = Jac_FULL(63,11)
  JVS(443) = B(34)
! JVS(444) = Jac_FULL(63,48)
  JVS(444) = -B(327)
! JVS(445) = Jac_FULL(63,50)
  JVS(445) = -B(385)
! JVS(446) = Jac_FULL(63,52)
  JVS(446) = -B(335)
! JVS(447) = Jac_FULL(63,54)
  JVS(447) = -B(343)
! JVS(448) = Jac_FULL(63,55)
  JVS(448) = -B(286)
! JVS(449) = Jac_FULL(63,56)
  JVS(449) = -B(367)
! JVS(450) = Jac_FULL(63,58)
  JVS(450) = -B(375)
! JVS(451) = Jac_FULL(63,59)
  JVS(451) = -B(293)
! JVS(452) = Jac_FULL(63,63)
  JVS(452) = -B(2)-B(4)-B(6)-B(9)-B(11)-B(287)-B(294)-B(328)-B(336)-B(344)-B(368)-B(376)-B(386)
! JVS(453) = Jac_FULL(63,67)
  JVS(453) = -B(5)+B(30)
! JVS(454) = Jac_FULL(63,71)
  JVS(454) = 0
! JVS(455) = Jac_FULL(63,73)
  JVS(455) = -B(7)
! JVS(456) = Jac_FULL(63,74)
  JVS(456) = B(1)-B(10)-B(12)
! JVS(457) = Jac_FULL(63,75)
  JVS(457) = B(29)
! JVS(458) = Jac_FULL(64,20)
  JVS(458) = 0.261*B(347)
! JVS(459) = Jac_FULL(64,24)
  JVS(459) = 0.122*B(351)
! JVS(460) = Jac_FULL(64,26)
  JVS(460) = 0.204*B(355)
! JVS(461) = Jac_FULL(64,33)
  JVS(461) = 0.244*B(353)
! JVS(462) = Jac_FULL(64,35)
  JVS(462) = B(313)
! JVS(463) = Jac_FULL(64,36)
  JVS(463) = B(316)
! JVS(464) = Jac_FULL(64,38)
  JVS(464) = B(309)
! JVS(465) = Jac_FULL(64,42)
  JVS(465) = B(250)+B(252)
! JVS(466) = Jac_FULL(64,48)
  JVS(466) = B(325)
! JVS(467) = Jac_FULL(64,50)
  JVS(467) = 0.45*B(385)
! JVS(468) = Jac_FULL(64,54)
  JVS(468) = 0.474*B(337)+0.205*B(339)+0.474*B(341)+0.147*B(343)
! JVS(469) = Jac_FULL(64,55)
  JVS(469) = B(286)
! JVS(470) = Jac_FULL(64,56)
  JVS(470) = 0.497*B(361)+0.363*B(363)+0.037*B(365)+0.45*B(367)
! JVS(471) = Jac_FULL(64,57)
  JVS(471) = 0.013*B(296)+0.218*B(300)
! JVS(472) = Jac_FULL(64,58)
  JVS(472) = 0.511*B(369)+0.305*B(371)+0.151*B(373)+0.069*B(375)
! JVS(473) = Jac_FULL(64,59)
  JVS(473) = 0.675*B(289)+0.45*B(293)
! JVS(474) = Jac_FULL(64,62)
  JVS(474) = 0.213*B(306)+0.147*B(308)
! JVS(475) = Jac_FULL(64,63)
  JVS(475) = B(287)+0.45*B(294)+0.147*B(344)+0.45*B(368)+0.069*B(376)+0.45*B(386)
! JVS(476) = Jac_FULL(64,64)
  JVS(476) = -B(232)-B(234)-B(235)
! JVS(477) = Jac_FULL(64,65)
  JVS(477) = 0.37*B(240)
! JVS(478) = Jac_FULL(64,66)
  JVS(478) = 0.558*B(303)+0.71*B(305)
! JVS(479) = Jac_FULL(64,67)
  JVS(479) = 0.205*B(340)+0.363*B(364)+0.305*B(372)
! JVS(480) = Jac_FULL(64,69)
  JVS(480) = 0
! JVS(481) = Jac_FULL(64,71)
  JVS(481) = -B(233)+0.37*B(241)+B(251)+0.675*B(290)+0.013*B(297)+0.558*B(304)+0.213*B(307)+B(310)+B(314)+B(317)+0.474&
               &*B(338)+0.261*B(348)+0.122*B(352)+0.244*B(354)+0.204*B(356)+0.497*B(362)+0.511*B(370)
! JVS(482) = Jac_FULL(64,73)
  JVS(482) = 0
! JVS(483) = Jac_FULL(64,74)
  JVS(483) = 0
! JVS(484) = Jac_FULL(64,75)
  JVS(484) = -B(236)+0.218*B(301)+B(326)+0.474*B(342)+0.037*B(366)+0.151*B(374)
! JVS(485) = Jac_FULL(64,77)
  JVS(485) = 0
! JVS(486) = Jac_FULL(64,78)
  JVS(486) = 0
! JVS(487) = Jac_FULL(65,24)
  JVS(487) = 0.332*B(351)
! JVS(488) = Jac_FULL(65,26)
  JVS(488) = 0.089*B(355)
! JVS(489) = Jac_FULL(65,33)
  JVS(489) = 0.11*B(353)
! JVS(490) = Jac_FULL(65,50)
  JVS(490) = 0.55*B(385)
! JVS(491) = Jac_FULL(65,55)
  JVS(491) = 0.416*B(280)
! JVS(492) = Jac_FULL(65,56)
  JVS(492) = 0.437*B(367)
! JVS(493) = Jac_FULL(65,57)
  JVS(493) = 0.15*B(296)+0.21*B(298)+0.233*B(302)
! JVS(494) = Jac_FULL(65,58)
  JVS(494) = 0.072*B(369)+0.026*B(371)+0.001*B(373)+0.659*B(375)
! JVS(495) = Jac_FULL(65,59)
  JVS(495) = 0.55*B(293)
! JVS(496) = Jac_FULL(65,62)
  JVS(496) = 0.177*B(306)+0.243*B(308)
! JVS(497) = Jac_FULL(65,63)
  JVS(497) = 0.55*B(294)+0.437*B(368)+0.659*B(376)+0.55*B(386)
! JVS(498) = Jac_FULL(65,65)
  JVS(498) = -B(240)-B(242)
! JVS(499) = Jac_FULL(65,66)
  JVS(499) = 0.115*B(303)
! JVS(500) = Jac_FULL(65,67)
  JVS(500) = 0.21*B(299)+0.026*B(372)
! JVS(501) = Jac_FULL(65,69)
  JVS(501) = 0.5*B(110)+B(112)+0.5*B(114)+B(118)
! JVS(502) = Jac_FULL(65,71)
  JVS(502) = -B(241)+0.416*B(281)+0.15*B(297)+0.115*B(304)+0.177*B(307)+0.332*B(352)+0.11*B(354)+0.089*B(356)+0.072&
               &*B(370)
! JVS(503) = Jac_FULL(65,73)
  JVS(503) = 0
! JVS(504) = Jac_FULL(65,74)
  JVS(504) = 0
! JVS(505) = Jac_FULL(65,75)
  JVS(505) = B(113)+0.001*B(374)
! JVS(506) = Jac_FULL(65,76)
  JVS(506) = 0.5*B(111)
! JVS(507) = Jac_FULL(65,77)
  JVS(507) = 0.5*B(115)
! JVS(508) = Jac_FULL(66,26)
  JVS(508) = 0.417*B(355)
! JVS(509) = Jac_FULL(66,33)
  JVS(509) = 0.125*B(353)
! JVS(510) = Jac_FULL(66,34)
  JVS(510) = 0.055*B(357)
! JVS(511) = Jac_FULL(66,52)
  JVS(511) = 0.1*B(331)+0.75*B(335)
! JVS(512) = Jac_FULL(66,54)
  JVS(512) = 0.276*B(337)+0.276*B(339)+0.853*B(343)
! JVS(513) = Jac_FULL(66,56)
  JVS(513) = 0.119*B(361)+0.215*B(363)+0.113*B(367)
! JVS(514) = Jac_FULL(66,57)
  JVS(514) = 0.332*B(296)
! JVS(515) = Jac_FULL(66,58)
  JVS(515) = 0.043*B(371)+0.259*B(375)
! JVS(516) = Jac_FULL(66,59)
  JVS(516) = 0.7*B(295)
! JVS(517) = Jac_FULL(66,62)
  JVS(517) = 0.048*B(306)+0.435*B(308)
! JVS(518) = Jac_FULL(66,63)
  JVS(518) = 0.75*B(336)+0.853*B(344)+0.113*B(368)+0.259*B(376)
! JVS(519) = Jac_FULL(66,66)
  JVS(519) = -0.671*B(303)-B(305)
! JVS(520) = Jac_FULL(66,67)
  JVS(520) = 0.1*B(332)+0.276*B(340)+0.215*B(364)+0.043*B(372)
! JVS(521) = Jac_FULL(66,68)
  JVS(521) = B(134)
! JVS(522) = Jac_FULL(66,69)
  JVS(522) = 0.5*B(110)+0.5*B(114)+B(118)+B(135)+B(152)+B(172)
! JVS(523) = Jac_FULL(66,71)
  JVS(523) = 0.332*B(297)-0.671*B(304)+0.048*B(307)+0.276*B(338)+0.125*B(354)+0.417*B(356)+0.055*B(358)+0.119*B(362)
! JVS(524) = Jac_FULL(66,72)
  JVS(524) = B(153)
! JVS(525) = Jac_FULL(66,73)
  JVS(525) = 0
! JVS(526) = Jac_FULL(66,74)
  JVS(526) = 0
! JVS(527) = Jac_FULL(66,75)
  JVS(527) = 0
! JVS(528) = Jac_FULL(66,76)
  JVS(528) = 0.5*B(111)
! JVS(529) = Jac_FULL(66,77)
  JVS(529) = 0.5*B(115)
! JVS(530) = Jac_FULL(66,79)
  JVS(530) = B(173)
! JVS(531) = Jac_FULL(67,38)
  JVS(531) = -B(311)
! JVS(532) = Jac_FULL(67,39)
  JVS(532) = -B(377)
! JVS(533) = Jac_FULL(67,48)
  JVS(533) = -B(323)
! JVS(534) = Jac_FULL(67,50)
  JVS(534) = -B(381)
! JVS(535) = Jac_FULL(67,52)
  JVS(535) = -B(331)
! JVS(536) = Jac_FULL(67,54)
  JVS(536) = -B(339)
! JVS(537) = Jac_FULL(67,55)
  JVS(537) = -B(282)
! JVS(538) = Jac_FULL(67,56)
  JVS(538) = -B(363)
! JVS(539) = Jac_FULL(67,57)
  JVS(539) = -B(298)
! JVS(540) = Jac_FULL(67,58)
  JVS(540) = -B(371)
! JVS(541) = Jac_FULL(67,59)
  JVS(541) = -B(291)
! JVS(542) = Jac_FULL(67,63)
  JVS(542) = B(2)-B(4)
! JVS(543) = Jac_FULL(67,67)
  JVS(543) = -B(5)-B(13)-B(15)-B(30)-B(31)-B(51)-B(61)-B(283)-B(292)-B(299)-B(312)-B(324)-B(332)-B(340)-B(364)-B(372)&
               &-B(378)-B(382)
! JVS(544) = Jac_FULL(67,68)
  JVS(544) = 0.25*B(124)
! JVS(545) = Jac_FULL(67,70)
  JVS(545) = 0.25*B(184)
! JVS(546) = Jac_FULL(67,71)
  JVS(546) = -B(52)
! JVS(547) = Jac_FULL(67,72)
  JVS(547) = 0.25*B(142)
! JVS(548) = Jac_FULL(67,73)
  JVS(548) = -B(14)
! JVS(549) = Jac_FULL(67,74)
  JVS(549) = -B(16)
! JVS(550) = Jac_FULL(67,75)
  JVS(550) = 0
! JVS(551) = Jac_FULL(67,78)
  JVS(551) = -B(62)+0.25*B(125)+0.25*B(143)+0.25*B(162)+0.25*B(185)
! JVS(552) = Jac_FULL(67,79)
  JVS(552) = 0.25*B(163)
! JVS(553) = Jac_FULL(68,14)
  JVS(553) = 2*B(264)
! JVS(554) = Jac_FULL(68,15)
  JVS(554) = B(121)
! JVS(555) = Jac_FULL(68,27)
  JVS(555) = 0
! JVS(556) = Jac_FULL(68,33)
  JVS(556) = 0.011*B(353)
! JVS(557) = Jac_FULL(68,35)
  JVS(557) = B(313)+0.5*B(315)
! JVS(558) = Jac_FULL(68,36)
  JVS(558) = B(316)+0.5*B(318)
! JVS(559) = Jac_FULL(68,44)
  JVS(559) = B(259)+B(260)+B(262)
! JVS(560) = Jac_FULL(68,46)
  JVS(560) = B(237)+B(239)
! JVS(561) = Jac_FULL(68,54)
  JVS(561) = 0.123*B(339)
! JVS(562) = Jac_FULL(68,55)
  JVS(562) = 0.67*B(288)
! JVS(563) = Jac_FULL(68,56)
  JVS(563) = 0
! JVS(564) = Jac_FULL(68,57)
  JVS(564) = 0.467*B(302)
! JVS(565) = Jac_FULL(68,58)
  JVS(565) = 0.137*B(371)
! JVS(566) = Jac_FULL(68,59)
  JVS(566) = 0.675*B(289)
! JVS(567) = Jac_FULL(68,60)
  JVS(567) = B(227)+B(230)
! JVS(568) = Jac_FULL(68,62)
  JVS(568) = 0
! JVS(569) = Jac_FULL(68,63)
  JVS(569) = 0
! JVS(570) = Jac_FULL(68,64)
  JVS(570) = 0
! JVS(571) = Jac_FULL(68,65)
  JVS(571) = 0.492*B(240)+B(242)
! JVS(572) = Jac_FULL(68,66)
  JVS(572) = 0.029*B(303)+0.667*B(305)
! JVS(573) = Jac_FULL(68,67)
  JVS(573) = 0.123*B(340)+0.137*B(372)
! JVS(574) = Jac_FULL(68,68)
  JVS(574) = -B(119)-B(122)-B(124)-B(126)-B(128)-B(130)-B(134)-2*B(136)-B(154)-B(174)
! JVS(575) = Jac_FULL(68,69)
  JVS(575) = -B(135)
! JVS(576) = Jac_FULL(68,70)
  JVS(576) = B(182)+B(186)+B(198)+B(200)+2*B(202)
! JVS(577) = Jac_FULL(68,71)
  JVS(577) = B(228)+B(238)+0.492*B(241)+B(261)+0.675*B(290)+0.029*B(304)+B(314)+B(317)+0.011*B(354)
! JVS(578) = Jac_FULL(68,72)
  JVS(578) = -B(155)+B(199)
! JVS(579) = Jac_FULL(68,73)
  JVS(579) = -B(123)+B(183)
! JVS(580) = Jac_FULL(68,74)
  JVS(580) = -B(120)
! JVS(581) = Jac_FULL(68,75)
  JVS(581) = -B(127)+B(187)+B(231)+B(263)
! JVS(582) = Jac_FULL(68,76)
  JVS(582) = -B(129)
! JVS(583) = Jac_FULL(68,77)
  JVS(583) = -B(131)
! JVS(584) = Jac_FULL(68,78)
  JVS(584) = -B(125)
! JVS(585) = Jac_FULL(68,79)
  JVS(585) = -B(175)+B(201)
! JVS(586) = Jac_FULL(69,20)
  JVS(586) = 0.035*B(347)
! JVS(587) = Jac_FULL(69,24)
  JVS(587) = 0.07*B(351)
! JVS(588) = Jac_FULL(69,26)
  JVS(588) = 0.347*B(355)
! JVS(589) = Jac_FULL(69,27)
  JVS(589) = 0.009*B(359)
! JVS(590) = Jac_FULL(69,33)
  JVS(590) = 0.143*B(353)
! JVS(591) = Jac_FULL(69,34)
  JVS(591) = 0.011*B(357)
! JVS(592) = Jac_FULL(69,50)
  JVS(592) = 0.016*B(379)+0.051*B(383)
! JVS(593) = Jac_FULL(69,52)
  JVS(593) = 0.093*B(329)+0.008*B(331)+0.064*B(333)+0.01*B(335)
! JVS(594) = Jac_FULL(69,54)
  JVS(594) = 0.25*B(337)+0.18*B(339)+0.25*B(341)
! JVS(595) = Jac_FULL(69,56)
  JVS(595) = 0.09*B(361)+0.001*B(363)+0.176*B(365)
! JVS(596) = Jac_FULL(69,57)
  JVS(596) = 0.041*B(296)+0.051*B(300)
! JVS(597) = Jac_FULL(69,58)
  JVS(597) = 0.082*B(369)+0.002*B(371)+0.136*B(373)+0.001*B(375)
! JVS(598) = Jac_FULL(69,59)
  JVS(598) = 0.025*B(289)
! JVS(599) = Jac_FULL(69,62)
  JVS(599) = 0.173*B(306)+0.095*B(308)
! JVS(600) = Jac_FULL(69,63)
  JVS(600) = 0.01*B(336)+0.001*B(376)
! JVS(601) = Jac_FULL(69,64)
  JVS(601) = 0.001*B(232)
! JVS(602) = Jac_FULL(69,65)
  JVS(602) = 0.042*B(240)
! JVS(603) = Jac_FULL(69,66)
  JVS(603) = 0.07*B(303)+0.04*B(305)
! JVS(604) = Jac_FULL(69,67)
  JVS(604) = 0.008*B(332)+0.18*B(340)+0.001*B(364)+0.002*B(372)
! JVS(605) = Jac_FULL(69,68)
  JVS(605) = -B(134)
! JVS(606) = Jac_FULL(69,69)
  JVS(606) = -B(106)-B(108)-B(110)-B(112)-B(114)-2*B(118)-B(135)-B(152)-B(172)-B(194)
! JVS(607) = Jac_FULL(69,70)
  JVS(607) = -B(195)
! JVS(608) = Jac_FULL(69,71)
  JVS(608) = 0.001*B(233)+0.042*B(241)+0.025*B(290)+0.041*B(297)+0.07*B(304)+0.173*B(307)+0.093*B(330)+0.25*B(338)+0.035&
               &*B(348)+0.07*B(352)+0.143*B(354)+0.347*B(356)+0.011*B(358)+0.009*B(360)+0.09*B(362)+0.082*B(370)+0.016&
               &*B(380)
! JVS(609) = Jac_FULL(69,72)
  JVS(609) = -B(153)
! JVS(610) = Jac_FULL(69,73)
  JVS(610) = -B(107)
! JVS(611) = Jac_FULL(69,74)
  JVS(611) = 0
! JVS(612) = Jac_FULL(69,75)
  JVS(612) = -B(113)+0.051*B(301)+0.064*B(334)+0.25*B(342)+0.176*B(366)+0.136*B(374)+0.051*B(384)
! JVS(613) = Jac_FULL(69,76)
  JVS(613) = -B(111)
! JVS(614) = Jac_FULL(69,77)
  JVS(614) = -B(115)
! JVS(615) = Jac_FULL(69,78)
  JVS(615) = -B(109)
! JVS(616) = Jac_FULL(69,79)
  JVS(616) = -B(173)
! JVS(617) = Jac_FULL(70,18)
  JVS(617) = B(181)
! JVS(618) = Jac_FULL(70,52)
  JVS(618) = 0.192*B(331)+0.24*B(335)
! JVS(619) = Jac_FULL(70,55)
  JVS(619) = 0.5*B(280)+0.5*B(284)+0.33*B(288)
! JVS(620) = Jac_FULL(70,57)
  JVS(620) = 0.289*B(296)+0.15*B(300)
! JVS(621) = Jac_FULL(70,58)
  JVS(621) = 0
! JVS(622) = Jac_FULL(70,59)
  JVS(622) = 0.3*B(295)
! JVS(623) = Jac_FULL(70,63)
  JVS(623) = 0.24*B(336)
! JVS(624) = Jac_FULL(70,67)
  JVS(624) = 0.192*B(332)
! JVS(625) = Jac_FULL(70,68)
  JVS(625) = -B(196)
! JVS(626) = Jac_FULL(70,69)
  JVS(626) = -B(194)
! JVS(627) = Jac_FULL(70,70)
  JVS(627) = -B(179)-B(182)-B(184)-B(186)-B(188)-B(190)-B(195)-B(197)-B(198)-B(200)-2*B(202)
! JVS(628) = Jac_FULL(70,71)
  JVS(628) = 0.5*B(281)+0.289*B(297)
! JVS(629) = Jac_FULL(70,72)
  JVS(629) = -B(199)
! JVS(630) = Jac_FULL(70,73)
  JVS(630) = -B(183)
! JVS(631) = Jac_FULL(70,74)
  JVS(631) = -B(180)
! JVS(632) = Jac_FULL(70,75)
  JVS(632) = -B(187)+0.5*B(285)+0.15*B(301)
! JVS(633) = Jac_FULL(70,76)
  JVS(633) = -B(189)
! JVS(634) = Jac_FULL(70,77)
  JVS(634) = -B(191)
! JVS(635) = Jac_FULL(70,78)
  JVS(635) = -B(185)
! JVS(636) = Jac_FULL(70,79)
  JVS(636) = -B(201)
! JVS(637) = Jac_FULL(71,10)
  JVS(637) = -B(74)
! JVS(638) = Jac_FULL(71,11)
  JVS(638) = 2*B(32)
! JVS(639) = Jac_FULL(71,12)
  JVS(639) = -B(319)
! JVS(640) = Jac_FULL(71,13)
  JVS(640) = -B(345)
! JVS(641) = Jac_FULL(71,19)
  JVS(641) = 2*B(69)-B(70)
! JVS(642) = Jac_FULL(71,20)
  JVS(642) = -B(347)
! JVS(643) = Jac_FULL(71,21)
  JVS(643) = -B(245)
! JVS(644) = Jac_FULL(71,23)
  JVS(644) = B(38)-B(40)
! JVS(645) = Jac_FULL(71,24)
  JVS(645) = -B(351)
! JVS(646) = Jac_FULL(71,26)
  JVS(646) = -B(355)
! JVS(647) = Jac_FULL(71,27)
  JVS(647) = -B(359)
! JVS(648) = Jac_FULL(71,28)
  JVS(648) = -B(243)
! JVS(649) = Jac_FULL(71,29)
  JVS(649) = -0.65*B(247)+B(249)
! JVS(650) = Jac_FULL(71,32)
  JVS(650) = 0.39*B(58)-B(59)
! JVS(651) = Jac_FULL(71,33)
  JVS(651) = -B(353)
! JVS(652) = Jac_FULL(71,34)
  JVS(652) = -B(357)
! JVS(653) = Jac_FULL(71,35)
  JVS(653) = -B(313)
! JVS(654) = Jac_FULL(71,36)
  JVS(654) = -B(316)
! JVS(655) = Jac_FULL(71,37)
  JVS(655) = -B(269)
! JVS(656) = Jac_FULL(71,38)
  JVS(656) = -B(309)+0.5*B(311)
! JVS(657) = Jac_FULL(71,39)
  JVS(657) = -0.397*B(349)+0.5*B(377)
! JVS(658) = Jac_FULL(71,41)
  JVS(658) = -B(275)
! JVS(659) = Jac_FULL(71,42)
  JVS(659) = -0.34*B(250)+B(252)
! JVS(660) = Jac_FULL(71,43)
  JVS(660) = -B(265)
! JVS(661) = Jac_FULL(71,44)
  JVS(661) = -B(260)
! JVS(662) = Jac_FULL(71,45)
  JVS(662) = -B(49)
! JVS(663) = Jac_FULL(71,46)
  JVS(663) = -B(237)
! JVS(664) = Jac_FULL(71,47)
  JVS(664) = -B(46)+B(48)
! JVS(665) = Jac_FULL(71,48)
  JVS(665) = -B(321)+0.12*B(323)
! JVS(666) = Jac_FULL(71,49)
  JVS(666) = -B(255)
! JVS(667) = Jac_FULL(71,50)
  JVS(667) = -B(379)+0.32*B(381)
! JVS(668) = Jac_FULL(71,51)
  JVS(668) = 0
! JVS(669) = Jac_FULL(71,52)
  JVS(669) = -B(329)+0.266*B(331)
! JVS(670) = Jac_FULL(71,54)
  JVS(670) = -B(337)+0.567*B(339)
! JVS(671) = Jac_FULL(71,55)
  JVS(671) = -B(280)+0.208*B(282)+0.33*B(288)
! JVS(672) = Jac_FULL(71,56)
  JVS(672) = -B(361)+0.155*B(363)
! JVS(673) = Jac_FULL(71,57)
  JVS(673) = -B(296)+0.285*B(298)
! JVS(674) = Jac_FULL(71,58)
  JVS(674) = -B(369)+0.378*B(371)
! JVS(675) = Jac_FULL(71,59)
  JVS(675) = -B(289)+0.164*B(291)
! JVS(676) = Jac_FULL(71,60)
  JVS(676) = -B(227)
! JVS(677) = Jac_FULL(71,61)
  JVS(677) = -B(218)
! JVS(678) = Jac_FULL(71,62)
  JVS(678) = -B(306)
! JVS(679) = Jac_FULL(71,63)
  JVS(679) = 0
! JVS(680) = Jac_FULL(71,64)
  JVS(680) = -B(232)
! JVS(681) = Jac_FULL(71,65)
  JVS(681) = -B(240)
! JVS(682) = Jac_FULL(71,66)
  JVS(682) = -B(303)
! JVS(683) = Jac_FULL(71,67)
  JVS(683) = -B(51)+B(61)+0.208*B(283)+0.164*B(292)+0.285*B(299)+0.5*B(312)+0.12*B(324)+0.266*B(332)+0.567*B(340)+0.155&
               &*B(364)+0.378*B(372)+0.5*B(378)+0.32*B(382)
! JVS(684) = Jac_FULL(71,68)
  JVS(684) = 0
! JVS(685) = Jac_FULL(71,69)
  JVS(685) = 0
! JVS(686) = Jac_FULL(71,70)
  JVS(686) = 0
! JVS(687) = Jac_FULL(71,71)
  JVS(687) = -B(36)-B(41)-B(42)-B(44)-B(47)-B(50)-B(52)-B(60)-B(71)-B(72)-B(75)-B(76)-B(219)-B(228)-B(233)-B(238)-B(241)&
               &-B(244)-B(246)-0.65*B(248)-0.34*B(251)-B(256)-B(261)-B(266)-B(270)-B(276)-B(281)-B(290)-B(297)-B(304)-B(307)&
               &-B(310)-B(314)-B(317)-B(320)-B(322)-B(330)-B(338)-B(346)-B(348)-0.397*B(350)-B(352)-B(354)-B(356)-B(358)&
               &-B(360)-B(362)-B(370)-B(380)
! JVS(688) = Jac_FULL(71,72)
  JVS(688) = 0
! JVS(689) = Jac_FULL(71,73)
  JVS(689) = -B(37)+B(53)
! JVS(690) = Jac_FULL(71,74)
  JVS(690) = -B(43)
! JVS(691) = Jac_FULL(71,75)
  JVS(691) = -B(45)+0.8*B(66)
! JVS(692) = Jac_FULL(71,76)
  JVS(692) = 0
! JVS(693) = Jac_FULL(71,77)
  JVS(693) = 0
! JVS(694) = Jac_FULL(71,78)
  JVS(694) = B(54)+B(62)+0.8*B(67)-B(73)
! JVS(695) = Jac_FULL(71,79)
  JVS(695) = 0
! JVS(696) = Jac_FULL(72,16)
  JVS(696) = B(139)
! JVS(697) = Jac_FULL(72,49)
  JVS(697) = 0.37*B(255)+0.37*B(257)
! JVS(698) = Jac_FULL(72,51)
  JVS(698) = 0
! JVS(699) = Jac_FULL(72,54)
  JVS(699) = 0.201*B(339)
! JVS(700) = Jac_FULL(72,55)
  JVS(700) = 0.1*B(282)
! JVS(701) = Jac_FULL(72,57)
  JVS(701) = 0.048*B(298)+0.3*B(302)
! JVS(702) = Jac_FULL(72,58)
  JVS(702) = 0.006*B(371)
! JVS(703) = Jac_FULL(72,59)
  JVS(703) = 0.05*B(291)
! JVS(704) = Jac_FULL(72,63)
  JVS(704) = 0
! JVS(705) = Jac_FULL(72,64)
  JVS(705) = 0.965*B(232)+B(235)
! JVS(706) = Jac_FULL(72,65)
  JVS(706) = 0.096*B(240)
! JVS(707) = Jac_FULL(72,66)
  JVS(707) = 0.049*B(303)+0.333*B(305)
! JVS(708) = Jac_FULL(72,67)
  JVS(708) = 0.1*B(283)+0.05*B(292)+0.048*B(299)+0.201*B(340)+0.006*B(372)
! JVS(709) = Jac_FULL(72,68)
  JVS(709) = -B(154)
! JVS(710) = Jac_FULL(72,69)
  JVS(710) = -B(152)
! JVS(711) = Jac_FULL(72,70)
  JVS(711) = -B(198)
! JVS(712) = Jac_FULL(72,71)
  JVS(712) = 0.965*B(233)+0.096*B(241)+0.37*B(256)+0.049*B(304)
! JVS(713) = Jac_FULL(72,72)
  JVS(713) = -B(137)-B(140)-B(142)-B(144)-B(146)-B(148)-B(153)-B(155)-2*B(156)-B(176)-B(199)
! JVS(714) = Jac_FULL(72,73)
  JVS(714) = -B(141)
! JVS(715) = Jac_FULL(72,74)
  JVS(715) = -B(138)
! JVS(716) = Jac_FULL(72,75)
  JVS(716) = -B(145)+B(236)+0.37*B(258)
! JVS(717) = Jac_FULL(72,76)
  JVS(717) = -B(147)
! JVS(718) = Jac_FULL(72,77)
  JVS(718) = -B(149)
! JVS(719) = Jac_FULL(72,78)
  JVS(719) = -B(143)
! JVS(720) = Jac_FULL(72,79)
  JVS(720) = -B(177)
! JVS(721) = Jac_FULL(73,23)
  JVS(721) = B(38)
! JVS(722) = Jac_FULL(73,30)
  JVS(722) = -B(223)
! JVS(723) = Jac_FULL(73,53)
  JVS(723) = -B(95)
! JVS(724) = Jac_FULL(73,54)
  JVS(724) = 0
! JVS(725) = Jac_FULL(73,56)
  JVS(725) = 0
! JVS(726) = Jac_FULL(73,58)
  JVS(726) = 0
! JVS(727) = Jac_FULL(73,59)
  JVS(727) = 0
! JVS(728) = Jac_FULL(73,61)
  JVS(728) = 0
! JVS(729) = Jac_FULL(73,62)
  JVS(729) = 0
! JVS(730) = Jac_FULL(73,63)
  JVS(730) = -B(6)+B(9)
! JVS(731) = Jac_FULL(73,65)
  JVS(731) = 0
! JVS(732) = Jac_FULL(73,66)
  JVS(732) = 0
! JVS(733) = Jac_FULL(73,67)
  JVS(733) = -B(13)
! JVS(734) = Jac_FULL(73,68)
  JVS(734) = -B(122)
! JVS(735) = Jac_FULL(73,69)
  JVS(735) = -B(106)
! JVS(736) = Jac_FULL(73,70)
  JVS(736) = -B(182)
! JVS(737) = Jac_FULL(73,71)
  JVS(737) = -B(36)
! JVS(738) = Jac_FULL(73,72)
  JVS(738) = -B(140)
! JVS(739) = Jac_FULL(73,73)
  JVS(739) = -B(7)-B(14)-B(17)-2*B(19)-B(37)-B(53)-B(78)-B(86)-B(96)-B(107)-B(123)-B(141)-B(160)-B(183)-B(224)
! JVS(740) = Jac_FULL(73,74)
  JVS(740) = B(1)+B(10)+B(26)
! JVS(741) = Jac_FULL(73,75)
  JVS(741) = -B(18)+B(27)+B(28)
! JVS(742) = Jac_FULL(73,76)
  JVS(742) = -B(79)
! JVS(743) = Jac_FULL(73,77)
  JVS(743) = -B(87)
! JVS(744) = Jac_FULL(73,78)
  JVS(744) = -B(54)
! JVS(745) = Jac_FULL(73,79)
  JVS(745) = -B(161)
! JVS(746) = Jac_FULL(74,15)
  JVS(746) = B(121)
! JVS(747) = Jac_FULL(74,16)
  JVS(747) = B(139)
! JVS(748) = Jac_FULL(74,17)
  JVS(748) = B(159)
! JVS(749) = Jac_FULL(74,18)
  JVS(749) = B(181)
! JVS(750) = Jac_FULL(74,22)
  JVS(750) = B(23)
! JVS(751) = Jac_FULL(74,23)
  JVS(751) = B(39)+B(40)
! JVS(752) = Jac_FULL(74,25)
  JVS(752) = -B(203)
! JVS(753) = Jac_FULL(74,30)
  JVS(753) = B(223)
! JVS(754) = Jac_FULL(74,31)
  JVS(754) = -B(211)
! JVS(755) = Jac_FULL(74,32)
  JVS(755) = B(57)+0.61*B(58)+B(59)
! JVS(756) = Jac_FULL(74,40)
  JVS(756) = 0
! JVS(757) = Jac_FULL(74,47)
  JVS(757) = B(48)
! JVS(758) = Jac_FULL(74,49)
  JVS(758) = 0
! JVS(759) = Jac_FULL(74,51)
  JVS(759) = -B(206)
! JVS(760) = Jac_FULL(74,52)
  JVS(760) = 0.187*B(333)
! JVS(761) = Jac_FULL(74,53)
  JVS(761) = B(95)+B(99)
! JVS(762) = Jac_FULL(74,54)
  JVS(762) = 0.474*B(341)
! JVS(763) = Jac_FULL(74,55)
  JVS(763) = 0
! JVS(764) = Jac_FULL(74,56)
  JVS(764) = 0
! JVS(765) = Jac_FULL(74,57)
  JVS(765) = 0
! JVS(766) = Jac_FULL(74,58)
  JVS(766) = 0.391*B(373)
! JVS(767) = Jac_FULL(74,59)
  JVS(767) = 0
! JVS(768) = Jac_FULL(74,60)
  JVS(768) = 0
! JVS(769) = Jac_FULL(74,61)
  JVS(769) = 0
! JVS(770) = Jac_FULL(74,62)
  JVS(770) = 0.338*B(306)+B(308)
! JVS(771) = Jac_FULL(74,63)
  JVS(771) = B(6)-B(9)-B(11)
! JVS(772) = Jac_FULL(74,64)
  JVS(772) = 0
! JVS(773) = Jac_FULL(74,65)
  JVS(773) = 0
! JVS(774) = Jac_FULL(74,66)
  JVS(774) = 0
! JVS(775) = Jac_FULL(74,67)
  JVS(775) = B(13)-B(15)
! JVS(776) = Jac_FULL(74,68)
  JVS(776) = -B(119)+B(122)+B(126)
! JVS(777) = Jac_FULL(74,69)
  JVS(777) = B(112)
! JVS(778) = Jac_FULL(74,70)
  JVS(778) = -B(179)+B(182)+B(186)
! JVS(779) = Jac_FULL(74,71)
  JVS(779) = B(41)-B(42)+B(44)+B(60)+0.338*B(307)
! JVS(780) = Jac_FULL(74,72)
  JVS(780) = -B(137)+B(140)+B(144)
! JVS(781) = Jac_FULL(74,73)
  JVS(781) = B(7)+B(14)+2*B(17)+2*B(19)+B(53)+B(78)+B(86)+B(96)+B(123)+B(141)+B(160)+B(183)+B(224)
! JVS(782) = Jac_FULL(74,74)
  JVS(782) = -B(1)-B(10)-B(12)-B(16)-B(21)-B(43)-B(55)-B(120)-B(138)-B(157)-B(180)-B(204)-B(207)-B(212)
! JVS(783) = Jac_FULL(74,75)
  JVS(783) = 2*B(18)-B(22)+B(29)+B(45)+0.8*B(66)+2*B(68)+B(82)+B(90)+B(100)+B(113)+B(127)+B(145)+B(164)+B(187)+0.187&
               &*B(334)+0.474*B(342)+0.391*B(374)
! JVS(784) = Jac_FULL(74,76)
  JVS(784) = B(79)+B(83)
! JVS(785) = Jac_FULL(74,77)
  JVS(785) = B(87)+B(91)
! JVS(786) = Jac_FULL(74,78)
  JVS(786) = B(54)-B(56)+0.8*B(67)
! JVS(787) = Jac_FULL(74,79)
  JVS(787) = -B(158)+B(161)+B(165)
! JVS(788) = Jac_FULL(75,22)
  JVS(788) = B(23)
! JVS(789) = Jac_FULL(75,32)
  JVS(789) = 0.39*B(58)
! JVS(790) = Jac_FULL(75,37)
  JVS(790) = -B(271)
! JVS(791) = Jac_FULL(75,40)
  JVS(791) = -B(273)
! JVS(792) = Jac_FULL(75,41)
  JVS(792) = -B(278)
! JVS(793) = Jac_FULL(75,43)
  JVS(793) = -B(267)
! JVS(794) = Jac_FULL(75,44)
  JVS(794) = -B(262)
! JVS(795) = Jac_FULL(75,47)
  JVS(795) = B(46)
! JVS(796) = Jac_FULL(75,48)
  JVS(796) = -B(325)
! JVS(797) = Jac_FULL(75,49)
  JVS(797) = -B(257)
! JVS(798) = Jac_FULL(75,50)
  JVS(798) = -B(383)
! JVS(799) = Jac_FULL(75,51)
  JVS(799) = 0
! JVS(800) = Jac_FULL(75,52)
  JVS(800) = -B(333)
! JVS(801) = Jac_FULL(75,53)
  JVS(801) = -B(99)
! JVS(802) = Jac_FULL(75,54)
  JVS(802) = -B(341)
! JVS(803) = Jac_FULL(75,55)
  JVS(803) = -B(284)
! JVS(804) = Jac_FULL(75,56)
  JVS(804) = -B(365)
! JVS(805) = Jac_FULL(75,57)
  JVS(805) = -B(300)
! JVS(806) = Jac_FULL(75,58)
  JVS(806) = -B(373)
! JVS(807) = Jac_FULL(75,59)
  JVS(807) = 0
! JVS(808) = Jac_FULL(75,60)
  JVS(808) = -B(230)
! JVS(809) = Jac_FULL(75,61)
  JVS(809) = -B(225)
! JVS(810) = Jac_FULL(75,62)
  JVS(810) = 0
! JVS(811) = Jac_FULL(75,63)
  JVS(811) = B(11)
! JVS(812) = Jac_FULL(75,64)
  JVS(812) = -B(235)
! JVS(813) = Jac_FULL(75,65)
  JVS(813) = 0
! JVS(814) = Jac_FULL(75,66)
  JVS(814) = 0
! JVS(815) = Jac_FULL(75,67)
  JVS(815) = B(15)
! JVS(816) = Jac_FULL(75,68)
  JVS(816) = -B(126)
! JVS(817) = Jac_FULL(75,69)
  JVS(817) = -B(112)
! JVS(818) = Jac_FULL(75,70)
  JVS(818) = -B(186)
! JVS(819) = Jac_FULL(75,71)
  JVS(819) = -B(44)+B(47)
! JVS(820) = Jac_FULL(75,72)
  JVS(820) = -B(144)
! JVS(821) = Jac_FULL(75,73)
  JVS(821) = -B(17)
! JVS(822) = Jac_FULL(75,74)
  JVS(822) = B(12)+B(16)-B(21)-B(26)
! JVS(823) = Jac_FULL(75,75)
  JVS(823) = -B(18)-B(22)-B(27)-B(28)-B(29)-B(45)-B(66)-2*B(68)-B(82)-B(90)-B(100)-B(113)-B(127)-B(145)-B(164)-B(187)&
               &-B(226)-B(231)-B(236)-B(258)-B(263)-B(268)-B(272)-B(274)-B(279)-B(285)-B(301)-B(326)-B(334)-B(342)-B(366)&
               &-B(374)-B(384)
! JVS(824) = Jac_FULL(75,76)
  JVS(824) = -B(83)
! JVS(825) = Jac_FULL(75,77)
  JVS(825) = -B(91)
! JVS(826) = Jac_FULL(75,78)
  JVS(826) = -B(67)
! JVS(827) = Jac_FULL(75,79)
  JVS(827) = -B(165)
! JVS(828) = Jac_FULL(76,12)
  JVS(828) = B(319)
! JVS(829) = Jac_FULL(76,25)
  JVS(829) = B(205)
! JVS(830) = Jac_FULL(76,29)
  JVS(830) = 0.65*B(247)
! JVS(831) = Jac_FULL(76,33)
  JVS(831) = 0.011*B(353)
! JVS(832) = Jac_FULL(76,46)
  JVS(832) = B(239)
! JVS(833) = Jac_FULL(76,48)
  JVS(833) = 0.3*B(327)
! JVS(834) = Jac_FULL(76,50)
  JVS(834) = 0.26*B(381)
! JVS(835) = Jac_FULL(76,52)
  JVS(835) = 0.25*B(335)
! JVS(836) = Jac_FULL(76,54)
  JVS(836) = 0
! JVS(837) = Jac_FULL(76,56)
  JVS(837) = 0.076*B(363)
! JVS(838) = Jac_FULL(76,58)
  JVS(838) = 0.197*B(371)+0.03*B(373)
! JVS(839) = Jac_FULL(76,59)
  JVS(839) = 0.3*B(295)
! JVS(840) = Jac_FULL(76,60)
  JVS(840) = B(229)
! JVS(841) = Jac_FULL(76,62)
  JVS(841) = 0
! JVS(842) = Jac_FULL(76,63)
  JVS(842) = 0.3*B(328)+0.25*B(336)
! JVS(843) = Jac_FULL(76,64)
  JVS(843) = 0
! JVS(844) = Jac_FULL(76,65)
  JVS(844) = 0
! JVS(845) = Jac_FULL(76,66)
  JVS(845) = 0
! JVS(846) = Jac_FULL(76,67)
  JVS(846) = 0.076*B(364)+0.197*B(372)+0.26*B(382)
! JVS(847) = Jac_FULL(76,68)
  JVS(847) = B(122)+B(126)-B(128)+2*B(136)+B(154)+B(174)+B(196)
! JVS(848) = Jac_FULL(76,69)
  JVS(848) = -B(110)
! JVS(849) = Jac_FULL(76,70)
  JVS(849) = -B(188)+B(197)
! JVS(850) = Jac_FULL(76,71)
  JVS(850) = 0.65*B(248)+B(320)+0.011*B(354)
! JVS(851) = Jac_FULL(76,72)
  JVS(851) = -B(146)+B(155)
! JVS(852) = Jac_FULL(76,73)
  JVS(852) = -B(78)+B(123)
! JVS(853) = Jac_FULL(76,74)
  JVS(853) = 0
! JVS(854) = Jac_FULL(76,75)
  JVS(854) = -B(82)+B(127)+0.03*B(374)
! JVS(855) = Jac_FULL(76,76)
  JVS(855) = -B(79)-B(80)-B(83)-2*B(84)-2*B(85)-B(92)-B(111)-B(129)-B(147)-B(166)-B(189)
! JVS(856) = Jac_FULL(76,77)
  JVS(856) = -B(93)
! JVS(857) = Jac_FULL(76,78)
  JVS(857) = -B(81)
! JVS(858) = Jac_FULL(76,79)
  JVS(858) = -B(167)+B(175)
! JVS(859) = Jac_FULL(77,13)
  JVS(859) = B(345)
! JVS(860) = Jac_FULL(77,20)
  JVS(860) = 0.965*B(347)
! JVS(861) = Jac_FULL(77,21)
  JVS(861) = 0.05*B(245)
! JVS(862) = Jac_FULL(77,24)
  JVS(862) = 0.695*B(351)
! JVS(863) = Jac_FULL(77,26)
  JVS(863) = 0.653*B(355)
! JVS(864) = Jac_FULL(77,27)
  JVS(864) = 0.804*B(359)
! JVS(865) = Jac_FULL(77,33)
  JVS(865) = 0.835*B(353)
! JVS(866) = Jac_FULL(77,34)
  JVS(866) = 0.765*B(357)
! JVS(867) = Jac_FULL(77,35)
  JVS(867) = B(315)
! JVS(868) = Jac_FULL(77,36)
  JVS(868) = B(318)
! JVS(869) = Jac_FULL(77,37)
  JVS(869) = 0.76*B(269)
! JVS(870) = Jac_FULL(77,38)
  JVS(870) = B(309)
! JVS(871) = Jac_FULL(77,39)
  JVS(871) = 0.1*B(349)
! JVS(872) = Jac_FULL(77,42)
  JVS(872) = 0.34*B(250)
! JVS(873) = Jac_FULL(77,43)
  JVS(873) = 0.76*B(265)
! JVS(874) = Jac_FULL(77,48)
  JVS(874) = B(321)+B(325)+0.2*B(327)
! JVS(875) = Jac_FULL(77,50)
  JVS(875) = 0.984*B(379)+0.949*B(383)
! JVS(876) = Jac_FULL(77,51)
  JVS(876) = 0
! JVS(877) = Jac_FULL(77,52)
  JVS(877) = 0.907*B(329)+0.066*B(331)+0.749*B(333)
! JVS(878) = Jac_FULL(77,54)
  JVS(878) = 0.75*B(337)+0.031*B(339)+0.276*B(341)
! JVS(879) = Jac_FULL(77,55)
  JVS(879) = 0.5*B(280)+0.1*B(282)+0.5*B(284)+0.33*B(288)
! JVS(880) = Jac_FULL(77,56)
  JVS(880) = 0.91*B(361)+0.022*B(363)+0.824*B(365)
! JVS(881) = Jac_FULL(77,57)
  JVS(881) = 0.67*B(296)+0.048*B(298)+0.799*B(300)
! JVS(882) = Jac_FULL(77,58)
  JVS(882) = 0.918*B(369)+0.033*B(371)+0.442*B(373)+0.012*B(375)
! JVS(883) = Jac_FULL(77,59)
  JVS(883) = 0.3*B(289)+0.05*B(291)
! JVS(884) = Jac_FULL(77,62)
  JVS(884) = 0.376*B(306)+0.564*B(308)
! JVS(885) = Jac_FULL(77,63)
  JVS(885) = 0.2*B(328)+0.012*B(376)
! JVS(886) = Jac_FULL(77,64)
  JVS(886) = 0.034*B(232)+B(234)
! JVS(887) = Jac_FULL(77,65)
  JVS(887) = 0.37*B(240)+B(242)
! JVS(888) = Jac_FULL(77,66)
  JVS(888) = 0.473*B(303)+0.96*B(305)
! JVS(889) = Jac_FULL(77,67)
  JVS(889) = 0.1*B(283)+0.05*B(292)+0.048*B(299)+0.066*B(332)+0.031*B(340)+0.022*B(364)+0.033*B(372)
! JVS(890) = Jac_FULL(77,68)
  JVS(890) = -B(130)+B(154)
! JVS(891) = Jac_FULL(77,69)
  JVS(891) = -B(114)
! JVS(892) = Jac_FULL(77,70)
  JVS(892) = -B(190)+B(198)
! JVS(893) = Jac_FULL(77,71)
  JVS(893) = 0.034*B(233)+0.37*B(241)+0.05*B(246)+0.34*B(251)+0.76*B(266)+0.76*B(270)+0.5*B(281)+0.3*B(290)+0.67*B(297)&
               &+0.473*B(304)+0.376*B(307)+B(310)+B(322)+0.907*B(330)+0.75*B(338)+B(346)+0.965*B(348)+0.1*B(350)+0.695&
               &*B(352)+0.835*B(354)+0.653*B(356)+0.765*B(358)+0.804*B(360)+0.91*B(362)+0.918*B(370)+0.984*B(380)
! JVS(894) = Jac_FULL(77,72)
  JVS(894) = B(140)+B(144)-B(148)+B(155)+2*B(156)+B(176)+B(199)
! JVS(895) = Jac_FULL(77,73)
  JVS(895) = -B(86)+B(141)
! JVS(896) = Jac_FULL(77,74)
  JVS(896) = 0
! JVS(897) = Jac_FULL(77,75)
  JVS(897) = -B(90)+B(145)+0.5*B(285)+0.799*B(301)+B(326)+0.749*B(334)+0.276*B(342)+0.824*B(366)+0.442*B(374)+0.949&
               &*B(384)
! JVS(898) = Jac_FULL(77,76)
  JVS(898) = -B(92)
! JVS(899) = Jac_FULL(77,77)
  JVS(899) = -B(87)-B(88)-B(91)-B(93)-2*B(94)-B(115)-B(131)-B(149)-B(168)-B(191)
! JVS(900) = Jac_FULL(77,78)
  JVS(900) = -B(89)
! JVS(901) = Jac_FULL(77,79)
  JVS(901) = -B(169)+B(177)
! JVS(902) = Jac_FULL(78,10)
  JVS(902) = B(74)
! JVS(903) = Jac_FULL(78,19)
  JVS(903) = B(70)
! JVS(904) = Jac_FULL(78,21)
  JVS(904) = 0.95*B(245)
! JVS(905) = Jac_FULL(78,23)
  JVS(905) = B(39)
! JVS(906) = Jac_FULL(78,27)
  JVS(906) = 0.187*B(359)
! JVS(907) = Jac_FULL(78,28)
  JVS(907) = B(243)
! JVS(908) = Jac_FULL(78,29)
  JVS(908) = B(249)
! JVS(909) = Jac_FULL(78,30)
  JVS(909) = B(222)+B(223)
! JVS(910) = Jac_FULL(78,31)
  JVS(910) = -B(213)
! JVS(911) = Jac_FULL(78,32)
  JVS(911) = B(57)+0.61*B(58)
! JVS(912) = Jac_FULL(78,34)
  JVS(912) = 0.224*B(357)
! JVS(913) = Jac_FULL(78,35)
  JVS(913) = 0.5*B(315)
! JVS(914) = Jac_FULL(78,36)
  JVS(914) = 0.5*B(318)
! JVS(915) = Jac_FULL(78,38)
  JVS(915) = 1.5*B(311)
! JVS(916) = Jac_FULL(78,39)
  JVS(916) = 0.297*B(349)+1.5*B(377)
! JVS(917) = Jac_FULL(78,40)
  JVS(917) = 0
! JVS(918) = Jac_FULL(78,42)
  JVS(918) = B(252)
! JVS(919) = Jac_FULL(78,44)
  JVS(919) = B(259)
! JVS(920) = Jac_FULL(78,45)
  JVS(920) = B(49)
! JVS(921) = Jac_FULL(78,48)
  JVS(921) = 0.12*B(323)+0.5*B(327)
! JVS(922) = Jac_FULL(78,49)
  JVS(922) = 2*B(253)+0.63*B(255)+0.63*B(257)
! JVS(923) = Jac_FULL(78,50)
  JVS(923) = 0.06*B(381)
! JVS(924) = Jac_FULL(78,51)
  JVS(924) = -B(208)
! JVS(925) = Jac_FULL(78,52)
  JVS(925) = 0
! JVS(926) = Jac_FULL(78,54)
  JVS(926) = 0.033*B(339)
! JVS(927) = Jac_FULL(78,55)
  JVS(927) = 0.008*B(282)+0.34*B(288)
! JVS(928) = Jac_FULL(78,56)
  JVS(928) = 0.056*B(363)
! JVS(929) = Jac_FULL(78,57)
  JVS(929) = 0.4*B(298)+1.233*B(302)
! JVS(930) = Jac_FULL(78,58)
  JVS(930) = 0.003*B(371)+0.013*B(375)
! JVS(931) = Jac_FULL(78,59)
  JVS(931) = 0.064*B(291)
! JVS(932) = Jac_FULL(78,60)
  JVS(932) = B(229)
! JVS(933) = Jac_FULL(78,61)
  JVS(933) = 2*B(216)+B(218)-B(220)+B(225)
! JVS(934) = Jac_FULL(78,62)
  JVS(934) = 0.113*B(306)+0.341*B(308)
! JVS(935) = Jac_FULL(78,63)
  JVS(935) = 0.5*B(328)+0.013*B(376)
! JVS(936) = Jac_FULL(78,64)
  JVS(936) = B(234)
! JVS(937) = Jac_FULL(78,65)
  JVS(937) = 0
! JVS(938) = Jac_FULL(78,66)
  JVS(938) = 0.379*B(303)
! JVS(939) = Jac_FULL(78,67)
  JVS(939) = B(51)-B(61)+0.008*B(283)+0.064*B(292)+0.4*B(299)+1.5*B(312)+0.12*B(324)+0.033*B(340)+0.056*B(364)+0.003&
               &*B(372)+1.5*B(378)+0.06*B(382)
! JVS(940) = Jac_FULL(78,68)
  JVS(940) = -B(124)
! JVS(941) = Jac_FULL(78,69)
  JVS(941) = -B(108)+B(110)+B(112)+B(114)+B(118)
! JVS(942) = Jac_FULL(78,70)
  JVS(942) = -B(184)
! JVS(943) = Jac_FULL(78,71)
  JVS(943) = B(44)+B(50)+B(52)+B(71)-B(72)+B(75)+B(76)+B(219)+B(244)+0.95*B(246)+0.63*B(256)+0.379*B(304)+0.113*B(307)&
               &+0.297*B(350)+0.224*B(358)+0.187*B(360)
! JVS(944) = Jac_FULL(78,72)
  JVS(944) = -B(142)
! JVS(945) = Jac_FULL(78,73)
  JVS(945) = -B(53)+B(78)+B(86)+B(224)
! JVS(946) = Jac_FULL(78,74)
  JVS(946) = -B(55)
! JVS(947) = Jac_FULL(78,75)
  JVS(947) = B(45)-B(66)+B(82)+B(90)+B(113)+B(226)+0.63*B(258)
! JVS(948) = Jac_FULL(78,76)
  JVS(948) = B(79)-B(80)+B(83)+2*B(85)+B(92)+B(111)
! JVS(949) = Jac_FULL(78,77)
  JVS(949) = B(87)-B(88)+B(91)+B(93)+B(94)+B(115)
! JVS(950) = Jac_FULL(78,78)
  JVS(950) = -B(54)-B(56)-B(62)-2*B(63)-2*B(64)-B(67)-B(73)-B(81)-B(89)-B(109)-B(125)-B(143)-B(162)-B(185)-B(209)-B(214)&
               &-B(221)-B(388)
! JVS(951) = Jac_FULL(78,79)
  JVS(951) = -B(163)
! JVS(952) = Jac_FULL(79,17)
  JVS(952) = B(159)
! JVS(953) = Jac_FULL(79,41)
  JVS(953) = B(275)+B(278)
! JVS(954) = Jac_FULL(79,58)
  JVS(954) = 0
! JVS(955) = Jac_FULL(79,63)
  JVS(955) = 0
! JVS(956) = Jac_FULL(79,67)
  JVS(956) = 0
! JVS(957) = Jac_FULL(79,68)
  JVS(957) = -B(174)
! JVS(958) = Jac_FULL(79,69)
  JVS(958) = -B(172)
! JVS(959) = Jac_FULL(79,70)
  JVS(959) = -B(200)
! JVS(960) = Jac_FULL(79,71)
  JVS(960) = B(276)
! JVS(961) = Jac_FULL(79,72)
  JVS(961) = -B(176)
! JVS(962) = Jac_FULL(79,73)
  JVS(962) = -B(160)
! JVS(963) = Jac_FULL(79,74)
  JVS(963) = -B(157)
! JVS(964) = Jac_FULL(79,75)
  JVS(964) = -B(164)+B(279)
! JVS(965) = Jac_FULL(79,76)
  JVS(965) = -B(166)
! JVS(966) = Jac_FULL(79,77)
  JVS(966) = -B(168)
! JVS(967) = Jac_FULL(79,78)
  JVS(967) = -B(162)
! JVS(968) = Jac_FULL(79,79)
  JVS(968) = -B(158)-B(161)-B(163)-B(165)-B(167)-B(169)-B(173)-B(175)-B(177)-2*B(178)-B(201)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)+JVS(2)*UV(10)+JVS(3)*UV(71)
  JUV(2) = JVS(4)*UV(2)+JVS(5)*UV(39)+JVS(6)*UV(50)+JVS(7)*UV(67)
  JUV(3) = JVS(8)*UV(3)+JVS(9)*UV(30)+JVS(10)*UV(39)+JVS(11)*UV(48)+JVS(12)*UV(50)+JVS(13)*UV(52)+JVS(14)*UV(54)+JVS(15)&
             &*UV(55)+JVS(16)*UV(56)+JVS(17)*UV(57)+JVS(18)*UV(58)+JVS(19)*UV(59)+JVS(20)*UV(67)+JVS(21)*UV(71)+JVS(22)&
             &*UV(73)
  JUV(4) = JVS(23)*UV(4)+JVS(24)*UV(50)+JVS(25)*UV(56)+JVS(26)*UV(58)+JVS(27)*UV(67)+JVS(28)*UV(68)+JVS(29)*UV(69)&
             &+JVS(30)*UV(76)+JVS(31)*UV(77)+JVS(32)*UV(78)
  JUV(5) = JVS(33)*UV(5)+JVS(34)*UV(52)+JVS(35)*UV(54)+JVS(36)*UV(56)+JVS(37)*UV(57)+JVS(38)*UV(58)+JVS(39)*UV(67)&
             &+JVS(40)*UV(69)+JVS(41)*UV(70)+JVS(42)*UV(72)+JVS(43)*UV(76)+JVS(44)*UV(77)+JVS(45)*UV(78)+JVS(46)*UV(79)
  JUV(6) = JVS(47)*UV(6)+JVS(48)*UV(68)+JVS(49)*UV(78)
  JUV(7) = JVS(50)*UV(7)+JVS(51)*UV(70)+JVS(52)*UV(72)+JVS(53)*UV(78)+JVS(54)*UV(79)
  JUV(8) = JVS(55)*UV(8)+JVS(56)*UV(31)+JVS(57)*UV(50)+JVS(58)*UV(74)+JVS(59)*UV(75)
  JUV(9) = JVS(60)*UV(9)+JVS(61)*UV(31)+JVS(62)*UV(41)+JVS(63)*UV(50)+JVS(64)*UV(63)+JVS(65)*UV(67)+JVS(66)*UV(71)&
             &+JVS(67)*UV(74)+JVS(68)*UV(75)
  JUV(10) = JVS(69)*UV(10)+JVS(70)*UV(71)
  JUV(11) = JVS(71)*UV(11)+JVS(72)*UV(67)
  JUV(12) = JVS(73)*UV(12)+JVS(74)*UV(71)
  JUV(13) = JVS(75)*UV(13)+JVS(76)*UV(71)
  JUV(14) = JVS(77)*UV(14)+JVS(78)*UV(27)+JVS(79)*UV(54)+JVS(80)*UV(67)+JVS(81)*UV(71)
  JUV(15) = JVS(82)*UV(15)+JVS(83)*UV(68)+JVS(84)*UV(74)
  JUV(16) = JVS(85)*UV(16)+JVS(86)*UV(72)+JVS(87)*UV(74)
  JUV(17) = JVS(88)*UV(17)+JVS(89)*UV(74)+JVS(90)*UV(79)
  JUV(18) = JVS(91)*UV(18)+JVS(92)*UV(70)+JVS(93)*UV(74)
  JUV(19) = JVS(94)*UV(19)+JVS(95)*UV(71)+JVS(96)*UV(78)
  JUV(20) = JVS(97)*UV(20)+JVS(98)*UV(71)
  JUV(21) = JVS(99)*UV(21)+JVS(100)*UV(71)
  JUV(22) = JVS(101)*UV(22)+JVS(102)*UV(74)+JVS(103)*UV(75)
  JUV(23) = JVS(104)*UV(23)+JVS(105)*UV(71)+JVS(106)*UV(73)
  JUV(24) = JVS(107)*UV(24)+JVS(108)*UV(71)
  JUV(25) = JVS(109)*UV(24)+JVS(110)*UV(25)+JVS(111)*UV(71)+JVS(112)*UV(74)
  JUV(26) = JVS(113)*UV(26)+JVS(114)*UV(71)
  JUV(27) = JVS(115)*UV(27)+JVS(116)*UV(71)
  JUV(28) = JVS(117)*UV(28)+JVS(118)*UV(69)+JVS(119)*UV(71)+JVS(120)*UV(76)+JVS(121)*UV(77)
  JUV(29) = JVS(122)*UV(29)+JVS(123)*UV(71)+JVS(124)*UV(76)+JVS(125)*UV(78)
  JUV(30) = JVS(126)*UV(30)+JVS(127)*UV(61)+JVS(128)*UV(73)+JVS(129)*UV(78)
  JUV(31) = JVS(130)*UV(31)+JVS(131)*UV(40)+JVS(132)*UV(74)+JVS(133)*UV(75)+JVS(134)*UV(78)
  JUV(32) = JVS(135)*UV(32)+JVS(136)*UV(71)+JVS(137)*UV(74)+JVS(138)*UV(78)
  JUV(33) = JVS(139)*UV(33)+JVS(140)*UV(71)
  JUV(34) = JVS(141)*UV(34)+JVS(142)*UV(71)
  JUV(35) = JVS(143)*UV(27)+JVS(144)*UV(34)+JVS(145)*UV(35)+JVS(146)*UV(71)
  JUV(36) = JVS(147)*UV(27)+JVS(148)*UV(34)+JVS(149)*UV(36)+JVS(150)*UV(71)
  JUV(37) = JVS(151)*UV(27)+JVS(152)*UV(34)+JVS(153)*UV(37)+JVS(154)*UV(71)+JVS(155)*UV(75)
  JUV(38) = JVS(156)*UV(27)+JVS(157)*UV(34)+JVS(158)*UV(38)+JVS(159)*UV(67)+JVS(160)*UV(71)
  JUV(39) = JVS(161)*UV(39)+JVS(162)*UV(67)+JVS(163)*UV(71)
  JUV(40) = JVS(164)*UV(31)+JVS(165)*UV(40)+JVS(166)*UV(51)+JVS(167)*UV(74)+JVS(168)*UV(75)+JVS(169)*UV(78)
  JUV(41) = JVS(170)*UV(27)+JVS(171)*UV(34)+JVS(172)*UV(41)+JVS(173)*UV(58)+JVS(174)*UV(67)+JVS(175)*UV(71)+JVS(176)&
              &*UV(75)
  JUV(42) = JVS(177)*UV(42)+JVS(178)*UV(69)+JVS(179)*UV(71)+JVS(180)*UV(77)+JVS(181)*UV(78)
  JUV(43) = JVS(182)*UV(34)+JVS(183)*UV(43)+JVS(184)*UV(51)+JVS(185)*UV(71)+JVS(186)*UV(75)+JVS(187)*UV(78)
  JUV(44) = JVS(188)*UV(27)+JVS(189)*UV(34)+JVS(190)*UV(35)+JVS(191)*UV(36)+JVS(192)*UV(37)+JVS(193)*UV(44)+JVS(194)&
              &*UV(55)+JVS(195)*UV(57)+JVS(196)*UV(59)+JVS(197)*UV(67)+JVS(198)*UV(71)+JVS(199)*UV(75)
  JUV(45) = JVS(200)*UV(33)+JVS(201)*UV(35)+JVS(202)*UV(36)+JVS(203)*UV(38)+JVS(204)*UV(39)+JVS(205)*UV(44)+JVS(206)&
              &*UV(45)+JVS(207)*UV(48)+JVS(208)*UV(49)+JVS(209)*UV(50)+JVS(210)*UV(52)+JVS(211)*UV(54)+JVS(212)*UV(55)&
              &+JVS(213)*UV(56)+JVS(214)*UV(57)+JVS(215)*UV(58)+JVS(216)*UV(59)+JVS(217)*UV(60)+JVS(218)*UV(61)+JVS(219)&
              &*UV(63)+JVS(220)*UV(64)+JVS(221)*UV(67)+JVS(222)*UV(71)+JVS(223)*UV(75)
  JUV(46) = JVS(224)*UV(20)+JVS(225)*UV(24)+JVS(226)*UV(25)+JVS(227)*UV(26)+JVS(228)*UV(33)+JVS(229)*UV(46)+JVS(230)&
              &*UV(54)+JVS(231)*UV(56)+JVS(232)*UV(58)+JVS(233)*UV(62)+JVS(234)*UV(67)+JVS(235)*UV(71)+JVS(237)*UV(75)
  JUV(47) = JVS(238)*UV(22)+JVS(239)*UV(37)+JVS(240)*UV(40)+JVS(241)*UV(41)+JVS(242)*UV(43)+JVS(243)*UV(44)+JVS(244)&
              &*UV(47)+JVS(245)*UV(49)+JVS(247)*UV(55)+JVS(248)*UV(57)+JVS(251)*UV(60)+JVS(252)*UV(61)+JVS(253)*UV(64)&
              &+JVS(255)*UV(71)+JVS(256)*UV(74)+JVS(257)*UV(75)+JVS(258)*UV(78)
  JUV(48) = JVS(259)*UV(48)+JVS(260)*UV(63)+JVS(261)*UV(67)+JVS(262)*UV(71)+JVS(263)*UV(75)
  JUV(49) = JVS(264)*UV(27)+JVS(265)*UV(34)+JVS(266)*UV(35)+JVS(267)*UV(36)+JVS(268)*UV(38)+JVS(269)*UV(39)+JVS(270)&
              &*UV(43)+JVS(271)*UV(48)+JVS(272)*UV(49)+JVS(274)*UV(54)+JVS(275)*UV(57)+JVS(276)*UV(63)+JVS(277)*UV(67)&
              &+JVS(278)*UV(71)+JVS(279)*UV(75)
  JUV(50) = JVS(281)*UV(50)+JVS(282)*UV(63)+JVS(283)*UV(67)+JVS(284)*UV(71)+JVS(285)*UV(75)
  JUV(51) = JVS(286)*UV(37)+JVS(287)*UV(43)+JVS(288)*UV(51)+JVS(289)*UV(68)+JVS(290)*UV(70)+JVS(291)*UV(71)+JVS(292)&
              &*UV(72)+JVS(293)*UV(73)+JVS(294)*UV(74)+JVS(295)*UV(75)+JVS(296)*UV(78)+JVS(297)*UV(79)
  JUV(52) = JVS(298)*UV(52)+JVS(299)*UV(63)+JVS(300)*UV(67)+JVS(301)*UV(71)+JVS(302)*UV(75)
  JUV(53) = JVS(303)*UV(24)+JVS(304)*UV(26)+JVS(305)*UV(33)+JVS(306)*UV(35)+JVS(307)*UV(36)+JVS(308)*UV(46)+JVS(309)&
              &*UV(52)+JVS(310)*UV(53)+JVS(311)*UV(54)+JVS(312)*UV(56)+JVS(313)*UV(58)+JVS(314)*UV(59)+JVS(315)*UV(62)&
              &+JVS(316)*UV(63)+JVS(317)*UV(65)+JVS(318)*UV(66)+JVS(319)*UV(67)+JVS(320)*UV(68)+JVS(321)*UV(69)+JVS(322)&
              &*UV(70)+JVS(323)*UV(71)+JVS(324)*UV(72)+JVS(325)*UV(73)+JVS(327)*UV(75)+JVS(328)*UV(76)+JVS(329)*UV(77)&
              &+JVS(330)*UV(78)+JVS(331)*UV(79)
  JUV(54) = JVS(332)*UV(54)+JVS(333)*UV(63)+JVS(334)*UV(67)+JVS(335)*UV(71)+JVS(336)*UV(75)
  JUV(55) = JVS(337)*UV(52)+JVS(338)*UV(55)+JVS(339)*UV(58)+JVS(340)*UV(63)+JVS(341)*UV(67)+JVS(342)*UV(71)+JVS(343)&
              &*UV(75)
  JUV(56) = JVS(344)*UV(56)+JVS(345)*UV(63)+JVS(346)*UV(67)+JVS(347)*UV(71)+JVS(348)*UV(75)
  JUV(57) = JVS(349)*UV(52)+JVS(350)*UV(57)+JVS(351)*UV(58)+JVS(353)*UV(67)+JVS(354)*UV(71)+JVS(355)*UV(75)
  JUV(58) = JVS(356)*UV(58)+JVS(357)*UV(63)+JVS(358)*UV(67)+JVS(359)*UV(71)+JVS(360)*UV(75)
  JUV(59) = JVS(361)*UV(52)+JVS(362)*UV(58)+JVS(363)*UV(59)+JVS(364)*UV(63)+JVS(365)*UV(67)+JVS(366)*UV(71)+JVS(367)&
              &*UV(75)
  JUV(60) = JVS(368)*UV(13)+JVS(369)*UV(21)+JVS(370)*UV(24)+JVS(371)*UV(26)+JVS(372)*UV(33)+JVS(373)*UV(48)+JVS(374)&
              &*UV(50)+JVS(375)*UV(56)+JVS(376)*UV(57)+JVS(377)*UV(58)+JVS(378)*UV(60)+JVS(379)*UV(62)+JVS(380)*UV(63)&
              &+JVS(381)*UV(64)+JVS(382)*UV(65)+JVS(383)*UV(66)+JVS(384)*UV(67)+JVS(385)*UV(68)+JVS(386)*UV(70)+JVS(387)&
              &*UV(71)+JVS(388)*UV(72)+JVS(389)*UV(73)+JVS(390)*UV(75)+JVS(391)*UV(79)
  JUV(61) = JVS(392)*UV(21)+JVS(393)*UV(24)+JVS(394)*UV(26)+JVS(395)*UV(28)+JVS(396)*UV(29)+JVS(397)*UV(30)+JVS(398)&
              &*UV(33)+JVS(399)*UV(39)+JVS(400)*UV(46)+JVS(401)*UV(48)+JVS(402)*UV(49)+JVS(403)*UV(50)+JVS(405)*UV(52)&
              &+JVS(406)*UV(54)+JVS(407)*UV(55)+JVS(408)*UV(56)+JVS(409)*UV(57)+JVS(410)*UV(58)+JVS(411)*UV(59)+JVS(412)&
              &*UV(61)+JVS(413)*UV(62)+JVS(414)*UV(63)+JVS(415)*UV(65)+JVS(416)*UV(66)+JVS(417)*UV(67)+JVS(418)*UV(68)&
              &+JVS(419)*UV(69)+JVS(420)*UV(70)+JVS(421)*UV(71)+JVS(422)*UV(72)+JVS(423)*UV(73)+JVS(425)*UV(75)+JVS(426)&
              &*UV(76)+JVS(427)*UV(77)+JVS(428)*UV(78)+JVS(429)*UV(79)
  JUV(62) = JVS(430)*UV(25)+JVS(431)*UV(54)+JVS(432)*UV(56)+JVS(433)*UV(57)+JVS(434)*UV(58)+JVS(435)*UV(62)+JVS(438)&
              &*UV(69)+JVS(439)*UV(71)+JVS(440)*UV(73)+JVS(441)*UV(74)+JVS(442)*UV(75)
  JUV(63) = JVS(443)*UV(11)+JVS(444)*UV(48)+JVS(445)*UV(50)+JVS(446)*UV(52)+JVS(447)*UV(54)+JVS(448)*UV(55)+JVS(449)&
              &*UV(56)+JVS(450)*UV(58)+JVS(451)*UV(59)+JVS(452)*UV(63)+JVS(453)*UV(67)+JVS(455)*UV(73)+JVS(456)*UV(74)&
              &+JVS(457)*UV(75)
  JUV(64) = JVS(458)*UV(20)+JVS(459)*UV(24)+JVS(460)*UV(26)+JVS(461)*UV(33)+JVS(462)*UV(35)+JVS(463)*UV(36)+JVS(464)&
              &*UV(38)+JVS(465)*UV(42)+JVS(466)*UV(48)+JVS(467)*UV(50)+JVS(468)*UV(54)+JVS(469)*UV(55)+JVS(470)*UV(56)&
              &+JVS(471)*UV(57)+JVS(472)*UV(58)+JVS(473)*UV(59)+JVS(474)*UV(62)+JVS(475)*UV(63)+JVS(476)*UV(64)+JVS(477)&
              &*UV(65)+JVS(478)*UV(66)+JVS(479)*UV(67)+JVS(481)*UV(71)+JVS(484)*UV(75)
  JUV(65) = JVS(487)*UV(24)+JVS(488)*UV(26)+JVS(489)*UV(33)+JVS(490)*UV(50)+JVS(491)*UV(55)+JVS(492)*UV(56)+JVS(493)&
              &*UV(57)+JVS(494)*UV(58)+JVS(495)*UV(59)+JVS(496)*UV(62)+JVS(497)*UV(63)+JVS(498)*UV(65)+JVS(499)*UV(66)&
              &+JVS(500)*UV(67)+JVS(501)*UV(69)+JVS(502)*UV(71)+JVS(505)*UV(75)+JVS(506)*UV(76)+JVS(507)*UV(77)
  JUV(66) = JVS(508)*UV(26)+JVS(509)*UV(33)+JVS(510)*UV(34)+JVS(511)*UV(52)+JVS(512)*UV(54)+JVS(513)*UV(56)+JVS(514)&
              &*UV(57)+JVS(515)*UV(58)+JVS(516)*UV(59)+JVS(517)*UV(62)+JVS(518)*UV(63)+JVS(519)*UV(66)+JVS(520)*UV(67)&
              &+JVS(521)*UV(68)+JVS(522)*UV(69)+JVS(523)*UV(71)+JVS(524)*UV(72)+JVS(528)*UV(76)+JVS(529)*UV(77)+JVS(530)&
              &*UV(79)
  JUV(67) = JVS(531)*UV(38)+JVS(532)*UV(39)+JVS(533)*UV(48)+JVS(534)*UV(50)+JVS(535)*UV(52)+JVS(536)*UV(54)+JVS(537)&
              &*UV(55)+JVS(538)*UV(56)+JVS(539)*UV(57)+JVS(540)*UV(58)+JVS(541)*UV(59)+JVS(542)*UV(63)+JVS(543)*UV(67)&
              &+JVS(544)*UV(68)+JVS(545)*UV(70)+JVS(546)*UV(71)+JVS(547)*UV(72)+JVS(548)*UV(73)+JVS(549)*UV(74)+JVS(551)&
              &*UV(78)+JVS(552)*UV(79)
  JUV(68) = JVS(553)*UV(14)+JVS(554)*UV(15)+JVS(556)*UV(33)+JVS(557)*UV(35)+JVS(558)*UV(36)+JVS(559)*UV(44)+JVS(560)&
              &*UV(46)+JVS(561)*UV(54)+JVS(562)*UV(55)+JVS(564)*UV(57)+JVS(565)*UV(58)+JVS(566)*UV(59)+JVS(567)*UV(60)&
              &+JVS(571)*UV(65)+JVS(572)*UV(66)+JVS(573)*UV(67)+JVS(574)*UV(68)+JVS(575)*UV(69)+JVS(576)*UV(70)+JVS(577)&
              &*UV(71)+JVS(578)*UV(72)+JVS(579)*UV(73)+JVS(580)*UV(74)+JVS(581)*UV(75)+JVS(582)*UV(76)+JVS(583)*UV(77)&
              &+JVS(584)*UV(78)+JVS(585)*UV(79)
  JUV(69) = JVS(586)*UV(20)+JVS(587)*UV(24)+JVS(588)*UV(26)+JVS(589)*UV(27)+JVS(590)*UV(33)+JVS(591)*UV(34)+JVS(592)&
              &*UV(50)+JVS(593)*UV(52)+JVS(594)*UV(54)+JVS(595)*UV(56)+JVS(596)*UV(57)+JVS(597)*UV(58)+JVS(598)*UV(59)&
              &+JVS(599)*UV(62)+JVS(600)*UV(63)+JVS(601)*UV(64)+JVS(602)*UV(65)+JVS(603)*UV(66)+JVS(604)*UV(67)+JVS(605)&
              &*UV(68)+JVS(606)*UV(69)+JVS(607)*UV(70)+JVS(608)*UV(71)+JVS(609)*UV(72)+JVS(610)*UV(73)+JVS(612)*UV(75)&
              &+JVS(613)*UV(76)+JVS(614)*UV(77)+JVS(615)*UV(78)+JVS(616)*UV(79)
  JUV(70) = JVS(617)*UV(18)+JVS(618)*UV(52)+JVS(619)*UV(55)+JVS(620)*UV(57)+JVS(622)*UV(59)+JVS(623)*UV(63)+JVS(624)&
              &*UV(67)+JVS(625)*UV(68)+JVS(626)*UV(69)+JVS(627)*UV(70)+JVS(628)*UV(71)+JVS(629)*UV(72)+JVS(630)*UV(73)&
              &+JVS(631)*UV(74)+JVS(632)*UV(75)+JVS(633)*UV(76)+JVS(634)*UV(77)+JVS(635)*UV(78)+JVS(636)*UV(79)
  JUV(71) = JVS(637)*UV(10)+JVS(638)*UV(11)+JVS(639)*UV(12)+JVS(640)*UV(13)+JVS(641)*UV(19)+JVS(642)*UV(20)+JVS(643)&
              &*UV(21)+JVS(644)*UV(23)+JVS(645)*UV(24)+JVS(646)*UV(26)+JVS(647)*UV(27)+JVS(648)*UV(28)+JVS(649)*UV(29)&
              &+JVS(650)*UV(32)+JVS(651)*UV(33)+JVS(652)*UV(34)+JVS(653)*UV(35)+JVS(654)*UV(36)+JVS(655)*UV(37)+JVS(656)&
              &*UV(38)+JVS(657)*UV(39)+JVS(658)*UV(41)+JVS(659)*UV(42)+JVS(660)*UV(43)+JVS(661)*UV(44)+JVS(662)*UV(45)&
              &+JVS(663)*UV(46)+JVS(664)*UV(47)+JVS(665)*UV(48)+JVS(666)*UV(49)+JVS(667)*UV(50)+JVS(669)*UV(52)+JVS(670)&
              &*UV(54)+JVS(671)*UV(55)+JVS(672)*UV(56)+JVS(673)*UV(57)+JVS(674)*UV(58)+JVS(675)*UV(59)+JVS(676)*UV(60)&
              &+JVS(677)*UV(61)+JVS(678)*UV(62)+JVS(680)*UV(64)+JVS(681)*UV(65)+JVS(682)*UV(66)+JVS(683)*UV(67)+JVS(687)&
              &*UV(71)+JVS(689)*UV(73)+JVS(690)*UV(74)+JVS(691)*UV(75)+JVS(694)*UV(78)
  JUV(72) = JVS(696)*UV(16)+JVS(697)*UV(49)+JVS(699)*UV(54)+JVS(700)*UV(55)+JVS(701)*UV(57)+JVS(702)*UV(58)+JVS(703)&
              &*UV(59)+JVS(705)*UV(64)+JVS(706)*UV(65)+JVS(707)*UV(66)+JVS(708)*UV(67)+JVS(709)*UV(68)+JVS(710)*UV(69)&
              &+JVS(711)*UV(70)+JVS(712)*UV(71)+JVS(713)*UV(72)+JVS(714)*UV(73)+JVS(715)*UV(74)+JVS(716)*UV(75)+JVS(717)&
              &*UV(76)+JVS(718)*UV(77)+JVS(719)*UV(78)+JVS(720)*UV(79)
  JUV(73) = JVS(721)*UV(23)+JVS(722)*UV(30)+JVS(723)*UV(53)+JVS(730)*UV(63)+JVS(733)*UV(67)+JVS(734)*UV(68)+JVS(735)&
              &*UV(69)+JVS(736)*UV(70)+JVS(737)*UV(71)+JVS(738)*UV(72)+JVS(739)*UV(73)+JVS(740)*UV(74)+JVS(741)*UV(75)&
              &+JVS(742)*UV(76)+JVS(743)*UV(77)+JVS(744)*UV(78)+JVS(745)*UV(79)
  JUV(74) = JVS(746)*UV(15)+JVS(747)*UV(16)+JVS(748)*UV(17)+JVS(749)*UV(18)+JVS(750)*UV(22)+JVS(751)*UV(23)+JVS(752)&
              &*UV(25)+JVS(753)*UV(30)+JVS(754)*UV(31)+JVS(755)*UV(32)+JVS(757)*UV(47)+JVS(759)*UV(51)+JVS(760)*UV(52)&
              &+JVS(761)*UV(53)+JVS(762)*UV(54)+JVS(766)*UV(58)+JVS(770)*UV(62)+JVS(771)*UV(63)+JVS(775)*UV(67)+JVS(776)&
              &*UV(68)+JVS(777)*UV(69)+JVS(778)*UV(70)+JVS(779)*UV(71)+JVS(780)*UV(72)+JVS(781)*UV(73)+JVS(782)*UV(74)&
              &+JVS(783)*UV(75)+JVS(784)*UV(76)+JVS(785)*UV(77)+JVS(786)*UV(78)+JVS(787)*UV(79)
  JUV(75) = JVS(788)*UV(22)+JVS(789)*UV(32)+JVS(790)*UV(37)+JVS(791)*UV(40)+JVS(792)*UV(41)+JVS(793)*UV(43)+JVS(794)&
              &*UV(44)+JVS(795)*UV(47)+JVS(796)*UV(48)+JVS(797)*UV(49)+JVS(798)*UV(50)+JVS(800)*UV(52)+JVS(801)*UV(53)&
              &+JVS(802)*UV(54)+JVS(803)*UV(55)+JVS(804)*UV(56)+JVS(805)*UV(57)+JVS(806)*UV(58)+JVS(808)*UV(60)+JVS(809)&
              &*UV(61)+JVS(811)*UV(63)+JVS(812)*UV(64)+JVS(815)*UV(67)+JVS(816)*UV(68)+JVS(817)*UV(69)+JVS(818)*UV(70)&
              &+JVS(819)*UV(71)+JVS(820)*UV(72)+JVS(821)*UV(73)+JVS(822)*UV(74)+JVS(823)*UV(75)+JVS(824)*UV(76)+JVS(825)&
              &*UV(77)+JVS(826)*UV(78)+JVS(827)*UV(79)
  JUV(76) = JVS(828)*UV(12)+JVS(829)*UV(25)+JVS(830)*UV(29)+JVS(831)*UV(33)+JVS(832)*UV(46)+JVS(833)*UV(48)+JVS(834)&
              &*UV(50)+JVS(835)*UV(52)+JVS(837)*UV(56)+JVS(838)*UV(58)+JVS(839)*UV(59)+JVS(840)*UV(60)+JVS(842)*UV(63)&
              &+JVS(846)*UV(67)+JVS(847)*UV(68)+JVS(848)*UV(69)+JVS(849)*UV(70)+JVS(850)*UV(71)+JVS(851)*UV(72)+JVS(852)&
              &*UV(73)+JVS(854)*UV(75)+JVS(855)*UV(76)+JVS(856)*UV(77)+JVS(857)*UV(78)+JVS(858)*UV(79)
  JUV(77) = JVS(859)*UV(13)+JVS(860)*UV(20)+JVS(861)*UV(21)+JVS(862)*UV(24)+JVS(863)*UV(26)+JVS(864)*UV(27)+JVS(865)&
              &*UV(33)+JVS(866)*UV(34)+JVS(867)*UV(35)+JVS(868)*UV(36)+JVS(869)*UV(37)+JVS(870)*UV(38)+JVS(871)*UV(39)&
              &+JVS(872)*UV(42)+JVS(873)*UV(43)+JVS(874)*UV(48)+JVS(875)*UV(50)+JVS(877)*UV(52)+JVS(878)*UV(54)+JVS(879)&
              &*UV(55)+JVS(880)*UV(56)+JVS(881)*UV(57)+JVS(882)*UV(58)+JVS(883)*UV(59)+JVS(884)*UV(62)+JVS(885)*UV(63)&
              &+JVS(886)*UV(64)+JVS(887)*UV(65)+JVS(888)*UV(66)+JVS(889)*UV(67)+JVS(890)*UV(68)+JVS(891)*UV(69)+JVS(892)&
              &*UV(70)+JVS(893)*UV(71)+JVS(894)*UV(72)+JVS(895)*UV(73)+JVS(897)*UV(75)+JVS(898)*UV(76)+JVS(899)*UV(77)&
              &+JVS(900)*UV(78)+JVS(901)*UV(79)
  JUV(78) = JVS(902)*UV(10)+JVS(903)*UV(19)+JVS(904)*UV(21)+JVS(905)*UV(23)+JVS(906)*UV(27)+JVS(907)*UV(28)+JVS(908)&
              &*UV(29)+JVS(909)*UV(30)+JVS(910)*UV(31)+JVS(911)*UV(32)+JVS(912)*UV(34)+JVS(913)*UV(35)+JVS(914)*UV(36)&
              &+JVS(915)*UV(38)+JVS(916)*UV(39)+JVS(918)*UV(42)+JVS(919)*UV(44)+JVS(920)*UV(45)+JVS(921)*UV(48)+JVS(922)&
              &*UV(49)+JVS(923)*UV(50)+JVS(924)*UV(51)+JVS(926)*UV(54)+JVS(927)*UV(55)+JVS(928)*UV(56)+JVS(929)*UV(57)&
              &+JVS(930)*UV(58)+JVS(931)*UV(59)+JVS(932)*UV(60)+JVS(933)*UV(61)+JVS(934)*UV(62)+JVS(935)*UV(63)+JVS(936)&
              &*UV(64)+JVS(938)*UV(66)+JVS(939)*UV(67)+JVS(940)*UV(68)+JVS(941)*UV(69)+JVS(942)*UV(70)+JVS(943)*UV(71)&
              &+JVS(944)*UV(72)+JVS(945)*UV(73)+JVS(946)*UV(74)+JVS(947)*UV(75)+JVS(948)*UV(76)+JVS(949)*UV(77)+JVS(950)&
              &*UV(78)+JVS(951)*UV(79)
  JUV(79) = JVS(952)*UV(17)+JVS(953)*UV(41)+JVS(957)*UV(68)+JVS(958)*UV(69)+JVS(959)*UV(70)+JVS(960)*UV(71)+JVS(961)&
              &*UV(72)+JVS(962)*UV(73)+JVS(963)*UV(74)+JVS(964)*UV(75)+JVS(965)*UV(76)+JVS(966)*UV(77)+JVS(967)*UV(78)&
              &+JVS(968)*UV(79)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)
  JTUV(2) = JVS(4)*UV(2)
  JTUV(3) = JVS(8)*UV(3)
  JTUV(4) = JVS(23)*UV(4)
  JTUV(5) = JVS(33)*UV(5)
  JTUV(6) = JVS(47)*UV(6)
  JTUV(7) = JVS(50)*UV(7)
  JTUV(8) = JVS(55)*UV(8)
  JTUV(9) = JVS(60)*UV(9)
  JTUV(10) = JVS(2)*UV(1)+JVS(69)*UV(10)+JVS(637)*UV(71)+JVS(902)*UV(78)
  JTUV(11) = JVS(71)*UV(11)+JVS(443)*UV(63)+JVS(638)*UV(71)
  JTUV(12) = JVS(73)*UV(12)+JVS(639)*UV(71)+JVS(828)*UV(76)
  JTUV(13) = JVS(75)*UV(13)+JVS(368)*UV(60)+JVS(640)*UV(71)+JVS(859)*UV(77)
  JTUV(14) = JVS(77)*UV(14)+JVS(553)*UV(68)
  JTUV(15) = JVS(82)*UV(15)+JVS(554)*UV(68)+JVS(746)*UV(74)
  JTUV(16) = JVS(85)*UV(16)+JVS(696)*UV(72)+JVS(747)*UV(74)
  JTUV(17) = JVS(88)*UV(17)+JVS(748)*UV(74)+JVS(952)*UV(79)
  JTUV(18) = JVS(91)*UV(18)+JVS(617)*UV(70)+JVS(749)*UV(74)
  JTUV(19) = JVS(94)*UV(19)+JVS(641)*UV(71)+JVS(903)*UV(78)
  JTUV(20) = JVS(97)*UV(20)+JVS(224)*UV(46)+JVS(458)*UV(64)+JVS(586)*UV(69)+JVS(642)*UV(71)+JVS(860)*UV(77)
  JTUV(21) = JVS(99)*UV(21)+JVS(369)*UV(60)+JVS(392)*UV(61)+JVS(643)*UV(71)+JVS(861)*UV(77)+JVS(904)*UV(78)
  JTUV(22) = JVS(101)*UV(22)+JVS(238)*UV(47)+JVS(750)*UV(74)+JVS(788)*UV(75)
  JTUV(23) = JVS(104)*UV(23)+JVS(644)*UV(71)+JVS(721)*UV(73)+JVS(751)*UV(74)+JVS(905)*UV(78)
  JTUV(24) = JVS(107)*UV(24)+JVS(109)*UV(25)+JVS(225)*UV(46)+JVS(303)*UV(53)+JVS(370)*UV(60)+JVS(393)*UV(61)+JVS(459)&
               &*UV(64)+JVS(487)*UV(65)+JVS(587)*UV(69)+JVS(645)*UV(71)+JVS(862)*UV(77)
  JTUV(25) = JVS(110)*UV(25)+JVS(226)*UV(46)+JVS(430)*UV(62)+JVS(752)*UV(74)+JVS(829)*UV(76)
  JTUV(26) = JVS(113)*UV(26)+JVS(227)*UV(46)+JVS(304)*UV(53)+JVS(371)*UV(60)+JVS(394)*UV(61)+JVS(460)*UV(64)+JVS(488)&
               &*UV(65)+JVS(508)*UV(66)+JVS(588)*UV(69)+JVS(646)*UV(71)+JVS(863)*UV(77)
  JTUV(27) = JVS(78)*UV(14)+JVS(115)*UV(27)+JVS(143)*UV(35)+JVS(147)*UV(36)+JVS(151)*UV(37)+JVS(156)*UV(38)+JVS(170)&
               &*UV(41)+JVS(188)*UV(44)+JVS(264)*UV(49)+JVS(589)*UV(69)+JVS(647)*UV(71)+JVS(864)*UV(77)+JVS(906)*UV(78)
  JTUV(28) = JVS(117)*UV(28)+JVS(395)*UV(61)+JVS(648)*UV(71)+JVS(907)*UV(78)
  JTUV(29) = JVS(122)*UV(29)+JVS(396)*UV(61)+JVS(649)*UV(71)+JVS(830)*UV(76)+JVS(908)*UV(78)
  JTUV(30) = JVS(9)*UV(3)+JVS(126)*UV(30)+JVS(397)*UV(61)+JVS(722)*UV(73)+JVS(753)*UV(74)+JVS(909)*UV(78)
  JTUV(31) = JVS(56)*UV(8)+JVS(61)*UV(9)+JVS(130)*UV(31)+JVS(164)*UV(40)+JVS(754)*UV(74)+JVS(910)*UV(78)
  JTUV(32) = JVS(135)*UV(32)+JVS(650)*UV(71)+JVS(755)*UV(74)+JVS(789)*UV(75)+JVS(911)*UV(78)
  JTUV(33) = JVS(139)*UV(33)+JVS(200)*UV(45)+JVS(228)*UV(46)+JVS(305)*UV(53)+JVS(372)*UV(60)+JVS(398)*UV(61)+JVS(461)&
               &*UV(64)+JVS(489)*UV(65)+JVS(509)*UV(66)+JVS(556)*UV(68)+JVS(590)*UV(69)+JVS(651)*UV(71)+JVS(831)*UV(76)&
               &+JVS(865)*UV(77)
  JTUV(34) = JVS(141)*UV(34)+JVS(144)*UV(35)+JVS(148)*UV(36)+JVS(152)*UV(37)+JVS(157)*UV(38)+JVS(171)*UV(41)+JVS(182)&
               &*UV(43)+JVS(189)*UV(44)+JVS(265)*UV(49)+JVS(510)*UV(66)+JVS(591)*UV(69)+JVS(652)*UV(71)+JVS(866)*UV(77)&
               &+JVS(912)*UV(78)
  JTUV(35) = JVS(145)*UV(35)+JVS(190)*UV(44)+JVS(201)*UV(45)+JVS(266)*UV(49)+JVS(306)*UV(53)+JVS(462)*UV(64)+JVS(557)&
               &*UV(68)+JVS(653)*UV(71)+JVS(867)*UV(77)+JVS(913)*UV(78)
  JTUV(36) = JVS(149)*UV(36)+JVS(191)*UV(44)+JVS(202)*UV(45)+JVS(267)*UV(49)+JVS(307)*UV(53)+JVS(463)*UV(64)+JVS(558)&
               &*UV(68)+JVS(654)*UV(71)+JVS(868)*UV(77)+JVS(914)*UV(78)
  JTUV(37) = JVS(153)*UV(37)+JVS(192)*UV(44)+JVS(239)*UV(47)+JVS(286)*UV(51)+JVS(655)*UV(71)+JVS(790)*UV(75)+JVS(869)&
               &*UV(77)
  JTUV(38) = JVS(158)*UV(38)+JVS(203)*UV(45)+JVS(268)*UV(49)+JVS(464)*UV(64)+JVS(531)*UV(67)+JVS(656)*UV(71)+JVS(870)&
               &*UV(77)+JVS(915)*UV(78)
  JTUV(39) = JVS(5)*UV(2)+JVS(10)*UV(3)+JVS(161)*UV(39)+JVS(204)*UV(45)+JVS(269)*UV(49)+JVS(399)*UV(61)+JVS(532)*UV(67)&
               &+JVS(657)*UV(71)+JVS(871)*UV(77)+JVS(916)*UV(78)
  JTUV(40) = JVS(131)*UV(31)+JVS(165)*UV(40)+JVS(240)*UV(47)+JVS(791)*UV(75)
  JTUV(41) = JVS(62)*UV(9)+JVS(172)*UV(41)+JVS(241)*UV(47)+JVS(658)*UV(71)+JVS(792)*UV(75)+JVS(953)*UV(79)
  JTUV(42) = JVS(177)*UV(42)+JVS(465)*UV(64)+JVS(659)*UV(71)+JVS(872)*UV(77)+JVS(918)*UV(78)
  JTUV(43) = JVS(183)*UV(43)+JVS(242)*UV(47)+JVS(270)*UV(49)+JVS(287)*UV(51)+JVS(660)*UV(71)+JVS(793)*UV(75)+JVS(873)&
               &*UV(77)
  JTUV(44) = JVS(193)*UV(44)+JVS(205)*UV(45)+JVS(243)*UV(47)+JVS(559)*UV(68)+JVS(661)*UV(71)+JVS(794)*UV(75)+JVS(919)&
               &*UV(78)
  JTUV(45) = JVS(206)*UV(45)+JVS(662)*UV(71)+JVS(920)*UV(78)
  JTUV(46) = JVS(229)*UV(46)+JVS(308)*UV(53)+JVS(400)*UV(61)+JVS(560)*UV(68)+JVS(663)*UV(71)+JVS(832)*UV(76)
  JTUV(47) = JVS(244)*UV(47)+JVS(664)*UV(71)+JVS(757)*UV(74)+JVS(795)*UV(75)
  JTUV(48) = JVS(11)*UV(3)+JVS(207)*UV(45)+JVS(259)*UV(48)+JVS(271)*UV(49)+JVS(373)*UV(60)+JVS(401)*UV(61)+JVS(444)&
               &*UV(63)+JVS(466)*UV(64)+JVS(533)*UV(67)+JVS(665)*UV(71)+JVS(796)*UV(75)+JVS(833)*UV(76)+JVS(874)*UV(77)&
               &+JVS(921)*UV(78)
  JTUV(49) = JVS(208)*UV(45)+JVS(245)*UV(47)+JVS(272)*UV(49)+JVS(402)*UV(61)+JVS(666)*UV(71)+JVS(697)*UV(72)+JVS(797)&
               &*UV(75)+JVS(922)*UV(78)
  JTUV(50) = JVS(6)*UV(2)+JVS(12)*UV(3)+JVS(24)*UV(4)+JVS(57)*UV(8)+JVS(63)*UV(9)+JVS(209)*UV(45)+JVS(281)*UV(50)&
               &+JVS(374)*UV(60)+JVS(403)*UV(61)+JVS(445)*UV(63)+JVS(467)*UV(64)+JVS(490)*UV(65)+JVS(534)*UV(67)+JVS(592)&
               &*UV(69)+JVS(667)*UV(71)+JVS(798)*UV(75)+JVS(834)*UV(76)+JVS(875)*UV(77)+JVS(923)*UV(78)
  JTUV(51) = JVS(166)*UV(40)+JVS(184)*UV(43)+JVS(288)*UV(51)+JVS(759)*UV(74)+JVS(924)*UV(78)
  JTUV(52) = JVS(13)*UV(3)+JVS(34)*UV(5)+JVS(210)*UV(45)+JVS(298)*UV(52)+JVS(309)*UV(53)+JVS(337)*UV(55)+JVS(349)*UV(57)&
               &+JVS(361)*UV(59)+JVS(405)*UV(61)+JVS(446)*UV(63)+JVS(511)*UV(66)+JVS(535)*UV(67)+JVS(593)*UV(69)+JVS(618)&
               &*UV(70)+JVS(669)*UV(71)+JVS(760)*UV(74)+JVS(800)*UV(75)+JVS(835)*UV(76)+JVS(877)*UV(77)
  JTUV(53) = JVS(310)*UV(53)+JVS(723)*UV(73)+JVS(761)*UV(74)+JVS(801)*UV(75)
  JTUV(54) = JVS(14)*UV(3)+JVS(35)*UV(5)+JVS(79)*UV(14)+JVS(211)*UV(45)+JVS(230)*UV(46)+JVS(274)*UV(49)+JVS(311)*UV(53)&
               &+JVS(332)*UV(54)+JVS(406)*UV(61)+JVS(431)*UV(62)+JVS(447)*UV(63)+JVS(468)*UV(64)+JVS(512)*UV(66)+JVS(536)&
               &*UV(67)+JVS(561)*UV(68)+JVS(594)*UV(69)+JVS(670)*UV(71)+JVS(699)*UV(72)+JVS(762)*UV(74)+JVS(802)*UV(75)&
               &+JVS(878)*UV(77)+JVS(926)*UV(78)
  JTUV(55) = JVS(15)*UV(3)+JVS(194)*UV(44)+JVS(212)*UV(45)+JVS(247)*UV(47)+JVS(338)*UV(55)+JVS(407)*UV(61)+JVS(448)&
               &*UV(63)+JVS(469)*UV(64)+JVS(491)*UV(65)+JVS(537)*UV(67)+JVS(562)*UV(68)+JVS(619)*UV(70)+JVS(671)*UV(71)&
               &+JVS(700)*UV(72)+JVS(803)*UV(75)+JVS(879)*UV(77)+JVS(927)*UV(78)
  JTUV(56) = JVS(16)*UV(3)+JVS(25)*UV(4)+JVS(36)*UV(5)+JVS(213)*UV(45)+JVS(231)*UV(46)+JVS(312)*UV(53)+JVS(344)*UV(56)&
               &+JVS(375)*UV(60)+JVS(408)*UV(61)+JVS(432)*UV(62)+JVS(449)*UV(63)+JVS(470)*UV(64)+JVS(492)*UV(65)+JVS(513)&
               &*UV(66)+JVS(538)*UV(67)+JVS(595)*UV(69)+JVS(672)*UV(71)+JVS(804)*UV(75)+JVS(837)*UV(76)+JVS(880)*UV(77)&
               &+JVS(928)*UV(78)
  JTUV(57) = JVS(17)*UV(3)+JVS(37)*UV(5)+JVS(195)*UV(44)+JVS(214)*UV(45)+JVS(248)*UV(47)+JVS(275)*UV(49)+JVS(350)*UV(57)&
               &+JVS(376)*UV(60)+JVS(409)*UV(61)+JVS(433)*UV(62)+JVS(471)*UV(64)+JVS(493)*UV(65)+JVS(514)*UV(66)+JVS(539)&
               &*UV(67)+JVS(564)*UV(68)+JVS(596)*UV(69)+JVS(620)*UV(70)+JVS(673)*UV(71)+JVS(701)*UV(72)+JVS(805)*UV(75)&
               &+JVS(881)*UV(77)+JVS(929)*UV(78)
  JTUV(58) = JVS(18)*UV(3)+JVS(26)*UV(4)+JVS(38)*UV(5)+JVS(173)*UV(41)+JVS(215)*UV(45)+JVS(232)*UV(46)+JVS(313)*UV(53)&
               &+JVS(339)*UV(55)+JVS(351)*UV(57)+JVS(356)*UV(58)+JVS(362)*UV(59)+JVS(377)*UV(60)+JVS(410)*UV(61)+JVS(434)&
               &*UV(62)+JVS(450)*UV(63)+JVS(472)*UV(64)+JVS(494)*UV(65)+JVS(515)*UV(66)+JVS(540)*UV(67)+JVS(565)*UV(68)&
               &+JVS(597)*UV(69)+JVS(674)*UV(71)+JVS(702)*UV(72)+JVS(766)*UV(74)+JVS(806)*UV(75)+JVS(838)*UV(76)+JVS(882)&
               &*UV(77)+JVS(930)*UV(78)
  JTUV(59) = JVS(19)*UV(3)+JVS(196)*UV(44)+JVS(216)*UV(45)+JVS(314)*UV(53)+JVS(363)*UV(59)+JVS(411)*UV(61)+JVS(451)&
               &*UV(63)+JVS(473)*UV(64)+JVS(495)*UV(65)+JVS(516)*UV(66)+JVS(541)*UV(67)+JVS(566)*UV(68)+JVS(598)*UV(69)&
               &+JVS(622)*UV(70)+JVS(675)*UV(71)+JVS(703)*UV(72)+JVS(839)*UV(76)+JVS(883)*UV(77)+JVS(931)*UV(78)
  JTUV(60) = JVS(217)*UV(45)+JVS(251)*UV(47)+JVS(378)*UV(60)+JVS(567)*UV(68)+JVS(676)*UV(71)+JVS(808)*UV(75)+JVS(840)&
               &*UV(76)+JVS(932)*UV(78)
  JTUV(61) = JVS(127)*UV(30)+JVS(218)*UV(45)+JVS(252)*UV(47)+JVS(412)*UV(61)+JVS(677)*UV(71)+JVS(809)*UV(75)+JVS(933)&
               &*UV(78)
  JTUV(62) = JVS(233)*UV(46)+JVS(315)*UV(53)+JVS(379)*UV(60)+JVS(413)*UV(61)+JVS(435)*UV(62)+JVS(474)*UV(64)+JVS(496)&
               &*UV(65)+JVS(517)*UV(66)+JVS(599)*UV(69)+JVS(678)*UV(71)+JVS(770)*UV(74)+JVS(884)*UV(77)+JVS(934)*UV(78)
  JTUV(63) = JVS(64)*UV(9)+JVS(219)*UV(45)+JVS(260)*UV(48)+JVS(276)*UV(49)+JVS(282)*UV(50)+JVS(299)*UV(52)+JVS(316)&
               &*UV(53)+JVS(333)*UV(54)+JVS(340)*UV(55)+JVS(345)*UV(56)+JVS(357)*UV(58)+JVS(364)*UV(59)+JVS(380)*UV(60)&
               &+JVS(414)*UV(61)+JVS(452)*UV(63)+JVS(475)*UV(64)+JVS(497)*UV(65)+JVS(518)*UV(66)+JVS(542)*UV(67)+JVS(600)&
               &*UV(69)+JVS(623)*UV(70)+JVS(730)*UV(73)+JVS(771)*UV(74)+JVS(811)*UV(75)+JVS(842)*UV(76)+JVS(885)*UV(77)&
               &+JVS(935)*UV(78)
  JTUV(64) = JVS(220)*UV(45)+JVS(253)*UV(47)+JVS(381)*UV(60)+JVS(476)*UV(64)+JVS(601)*UV(69)+JVS(680)*UV(71)+JVS(705)&
               &*UV(72)+JVS(812)*UV(75)+JVS(886)*UV(77)+JVS(936)*UV(78)
  JTUV(65) = JVS(317)*UV(53)+JVS(382)*UV(60)+JVS(415)*UV(61)+JVS(477)*UV(64)+JVS(498)*UV(65)+JVS(571)*UV(68)+JVS(602)&
               &*UV(69)+JVS(681)*UV(71)+JVS(706)*UV(72)+JVS(887)*UV(77)
  JTUV(66) = JVS(318)*UV(53)+JVS(383)*UV(60)+JVS(416)*UV(61)+JVS(478)*UV(64)+JVS(499)*UV(65)+JVS(519)*UV(66)+JVS(572)&
               &*UV(68)+JVS(603)*UV(69)+JVS(682)*UV(71)+JVS(707)*UV(72)+JVS(888)*UV(77)+JVS(938)*UV(78)
  JTUV(67) = JVS(7)*UV(2)+JVS(20)*UV(3)+JVS(27)*UV(4)+JVS(39)*UV(5)+JVS(65)*UV(9)+JVS(72)*UV(11)+JVS(80)*UV(14)+JVS(159)&
               &*UV(38)+JVS(162)*UV(39)+JVS(174)*UV(41)+JVS(197)*UV(44)+JVS(221)*UV(45)+JVS(234)*UV(46)+JVS(261)*UV(48)&
               &+JVS(277)*UV(49)+JVS(283)*UV(50)+JVS(300)*UV(52)+JVS(319)*UV(53)+JVS(334)*UV(54)+JVS(341)*UV(55)+JVS(346)&
               &*UV(56)+JVS(353)*UV(57)+JVS(358)*UV(58)+JVS(365)*UV(59)+JVS(384)*UV(60)+JVS(417)*UV(61)+JVS(453)*UV(63)&
               &+JVS(479)*UV(64)+JVS(500)*UV(65)+JVS(520)*UV(66)+JVS(543)*UV(67)+JVS(573)*UV(68)+JVS(604)*UV(69)+JVS(624)&
               &*UV(70)+JVS(683)*UV(71)+JVS(708)*UV(72)+JVS(733)*UV(73)+JVS(775)*UV(74)+JVS(815)*UV(75)+JVS(846)*UV(76)&
               &+JVS(889)*UV(77)+JVS(939)*UV(78)
  JTUV(68) = JVS(28)*UV(4)+JVS(48)*UV(6)+JVS(83)*UV(15)+JVS(289)*UV(51)+JVS(320)*UV(53)+JVS(385)*UV(60)+JVS(418)*UV(61)&
               &+JVS(521)*UV(66)+JVS(544)*UV(67)+JVS(574)*UV(68)+JVS(605)*UV(69)+JVS(625)*UV(70)+JVS(709)*UV(72)+JVS(734)&
               &*UV(73)+JVS(776)*UV(74)+JVS(816)*UV(75)+JVS(847)*UV(76)+JVS(890)*UV(77)+JVS(940)*UV(78)+JVS(957)*UV(79)
  JTUV(69) = JVS(29)*UV(4)+JVS(40)*UV(5)+JVS(118)*UV(28)+JVS(178)*UV(42)+JVS(321)*UV(53)+JVS(419)*UV(61)+JVS(438)*UV(62)&
               &+JVS(501)*UV(65)+JVS(522)*UV(66)+JVS(575)*UV(68)+JVS(606)*UV(69)+JVS(626)*UV(70)+JVS(710)*UV(72)+JVS(735)&
               &*UV(73)+JVS(777)*UV(74)+JVS(817)*UV(75)+JVS(848)*UV(76)+JVS(891)*UV(77)+JVS(941)*UV(78)+JVS(958)*UV(79)
  JTUV(70) = JVS(41)*UV(5)+JVS(51)*UV(7)+JVS(92)*UV(18)+JVS(290)*UV(51)+JVS(322)*UV(53)+JVS(386)*UV(60)+JVS(420)*UV(61)&
               &+JVS(545)*UV(67)+JVS(576)*UV(68)+JVS(607)*UV(69)+JVS(627)*UV(70)+JVS(711)*UV(72)+JVS(736)*UV(73)+JVS(778)&
               &*UV(74)+JVS(818)*UV(75)+JVS(849)*UV(76)+JVS(892)*UV(77)+JVS(942)*UV(78)+JVS(959)*UV(79)
  JTUV(71) = JVS(3)*UV(1)+JVS(21)*UV(3)+JVS(66)*UV(9)+JVS(70)*UV(10)+JVS(74)*UV(12)+JVS(76)*UV(13)+JVS(81)*UV(14)&
               &+JVS(95)*UV(19)+JVS(98)*UV(20)+JVS(100)*UV(21)+JVS(105)*UV(23)+JVS(108)*UV(24)+JVS(111)*UV(25)+JVS(114)&
               &*UV(26)+JVS(116)*UV(27)+JVS(119)*UV(28)+JVS(123)*UV(29)+JVS(136)*UV(32)+JVS(140)*UV(33)+JVS(142)*UV(34)&
               &+JVS(146)*UV(35)+JVS(150)*UV(36)+JVS(154)*UV(37)+JVS(160)*UV(38)+JVS(163)*UV(39)+JVS(175)*UV(41)+JVS(179)&
               &*UV(42)+JVS(185)*UV(43)+JVS(198)*UV(44)+JVS(222)*UV(45)+JVS(235)*UV(46)+JVS(255)*UV(47)+JVS(262)*UV(48)&
               &+JVS(278)*UV(49)+JVS(284)*UV(50)+JVS(291)*UV(51)+JVS(301)*UV(52)+JVS(323)*UV(53)+JVS(335)*UV(54)+JVS(342)&
               &*UV(55)+JVS(347)*UV(56)+JVS(354)*UV(57)+JVS(359)*UV(58)+JVS(366)*UV(59)+JVS(387)*UV(60)+JVS(421)*UV(61)&
               &+JVS(439)*UV(62)+JVS(481)*UV(64)+JVS(502)*UV(65)+JVS(523)*UV(66)+JVS(546)*UV(67)+JVS(577)*UV(68)+JVS(608)&
               &*UV(69)+JVS(628)*UV(70)+JVS(687)*UV(71)+JVS(712)*UV(72)+JVS(737)*UV(73)+JVS(779)*UV(74)+JVS(819)*UV(75)&
               &+JVS(850)*UV(76)+JVS(893)*UV(77)+JVS(943)*UV(78)+JVS(960)*UV(79)
  JTUV(72) = JVS(42)*UV(5)+JVS(52)*UV(7)+JVS(86)*UV(16)+JVS(292)*UV(51)+JVS(324)*UV(53)+JVS(388)*UV(60)+JVS(422)*UV(61)&
               &+JVS(524)*UV(66)+JVS(547)*UV(67)+JVS(578)*UV(68)+JVS(609)*UV(69)+JVS(629)*UV(70)+JVS(713)*UV(72)+JVS(738)&
               &*UV(73)+JVS(780)*UV(74)+JVS(820)*UV(75)+JVS(851)*UV(76)+JVS(894)*UV(77)+JVS(944)*UV(78)+JVS(961)*UV(79)
  JTUV(73) = JVS(22)*UV(3)+JVS(106)*UV(23)+JVS(128)*UV(30)+JVS(293)*UV(51)+JVS(325)*UV(53)+JVS(389)*UV(60)+JVS(423)&
               &*UV(61)+JVS(440)*UV(62)+JVS(455)*UV(63)+JVS(548)*UV(67)+JVS(579)*UV(68)+JVS(610)*UV(69)+JVS(630)*UV(70)&
               &+JVS(689)*UV(71)+JVS(714)*UV(72)+JVS(739)*UV(73)+JVS(781)*UV(74)+JVS(821)*UV(75)+JVS(852)*UV(76)+JVS(895)&
               &*UV(77)+JVS(945)*UV(78)+JVS(962)*UV(79)
  JTUV(74) = JVS(58)*UV(8)+JVS(67)*UV(9)+JVS(84)*UV(15)+JVS(87)*UV(16)+JVS(89)*UV(17)+JVS(93)*UV(18)+JVS(102)*UV(22)&
               &+JVS(112)*UV(25)+JVS(132)*UV(31)+JVS(137)*UV(32)+JVS(167)*UV(40)+JVS(256)*UV(47)+JVS(294)*UV(51)+JVS(441)&
               &*UV(62)+JVS(456)*UV(63)+JVS(549)*UV(67)+JVS(580)*UV(68)+JVS(631)*UV(70)+JVS(690)*UV(71)+JVS(715)*UV(72)&
               &+JVS(740)*UV(73)+JVS(782)*UV(74)+JVS(822)*UV(75)+JVS(946)*UV(78)+JVS(963)*UV(79)
  JTUV(75) = JVS(59)*UV(8)+JVS(68)*UV(9)+JVS(103)*UV(22)+JVS(133)*UV(31)+JVS(155)*UV(37)+JVS(168)*UV(40)+JVS(176)*UV(41)&
               &+JVS(186)*UV(43)+JVS(199)*UV(44)+JVS(223)*UV(45)+JVS(237)*UV(46)+JVS(257)*UV(47)+JVS(263)*UV(48)+JVS(279)&
               &*UV(49)+JVS(285)*UV(50)+JVS(295)*UV(51)+JVS(302)*UV(52)+JVS(327)*UV(53)+JVS(336)*UV(54)+JVS(343)*UV(55)&
               &+JVS(348)*UV(56)+JVS(355)*UV(57)+JVS(360)*UV(58)+JVS(367)*UV(59)+JVS(390)*UV(60)+JVS(425)*UV(61)+JVS(442)&
               &*UV(62)+JVS(457)*UV(63)+JVS(484)*UV(64)+JVS(505)*UV(65)+JVS(581)*UV(68)+JVS(612)*UV(69)+JVS(632)*UV(70)&
               &+JVS(691)*UV(71)+JVS(716)*UV(72)+JVS(741)*UV(73)+JVS(783)*UV(74)+JVS(823)*UV(75)+JVS(854)*UV(76)+JVS(897)&
               &*UV(77)+JVS(947)*UV(78)+JVS(964)*UV(79)
  JTUV(76) = JVS(30)*UV(4)+JVS(43)*UV(5)+JVS(120)*UV(28)+JVS(124)*UV(29)+JVS(328)*UV(53)+JVS(426)*UV(61)+JVS(506)*UV(65)&
               &+JVS(528)*UV(66)+JVS(582)*UV(68)+JVS(613)*UV(69)+JVS(633)*UV(70)+JVS(717)*UV(72)+JVS(742)*UV(73)+JVS(784)&
               &*UV(74)+JVS(824)*UV(75)+JVS(855)*UV(76)+JVS(898)*UV(77)+JVS(948)*UV(78)+JVS(965)*UV(79)
  JTUV(77) = JVS(31)*UV(4)+JVS(44)*UV(5)+JVS(121)*UV(28)+JVS(180)*UV(42)+JVS(329)*UV(53)+JVS(427)*UV(61)+JVS(507)*UV(65)&
               &+JVS(529)*UV(66)+JVS(583)*UV(68)+JVS(614)*UV(69)+JVS(634)*UV(70)+JVS(718)*UV(72)+JVS(743)*UV(73)+JVS(785)&
               &*UV(74)+JVS(825)*UV(75)+JVS(856)*UV(76)+JVS(899)*UV(77)+JVS(949)*UV(78)+JVS(966)*UV(79)
  JTUV(78) = JVS(32)*UV(4)+JVS(45)*UV(5)+JVS(49)*UV(6)+JVS(53)*UV(7)+JVS(96)*UV(19)+JVS(125)*UV(29)+JVS(129)*UV(30)&
               &+JVS(134)*UV(31)+JVS(138)*UV(32)+JVS(169)*UV(40)+JVS(181)*UV(42)+JVS(187)*UV(43)+JVS(258)*UV(47)+JVS(296)&
               &*UV(51)+JVS(330)*UV(53)+JVS(428)*UV(61)+JVS(551)*UV(67)+JVS(584)*UV(68)+JVS(615)*UV(69)+JVS(635)*UV(70)&
               &+JVS(694)*UV(71)+JVS(719)*UV(72)+JVS(744)*UV(73)+JVS(786)*UV(74)+JVS(826)*UV(75)+JVS(857)*UV(76)+JVS(900)&
               &*UV(77)+JVS(950)*UV(78)+JVS(967)*UV(79)
  JTUV(79) = JVS(46)*UV(5)+JVS(54)*UV(7)+JVS(90)*UV(17)+JVS(297)*UV(51)+JVS(331)*UV(53)+JVS(391)*UV(60)+JVS(429)*UV(61)&
               &+JVS(530)*UV(66)+JVS(552)*UV(67)+JVS(585)*UV(68)+JVS(616)*UV(69)+JVS(636)*UV(70)+JVS(720)*UV(72)+JVS(745)&
               &*UV(73)+JVS(787)*UV(74)+JVS(827)*UV(75)+JVS(858)*UV(76)+JVS(901)*UV(77)+JVS(951)*UV(78)+JVS(968)*UV(79)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE SAPRC99_Jacobian

