! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : SAPRC99_Function.f90
! Time                 : Thu Oct  8 08:22:39 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_SAPRC99_30885_BOXMOX
! Equation file        : SAPRC99.kpp
! Output root filename : SAPRC99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE SAPRC99_Function

  USE SAPRC99_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(74)
  A(2) = RCT(2)*V(63)*F(2)
  A(3) = RCT(3)*V(63)*V(67)
  A(4) = RCT(4)*V(63)*V(73)*F(2)
  A(5) = RCT(5)*V(63)*V(74)
  A(6) = RCT(6)*V(63)*V(74)
  A(7) = RCT(7)*V(67)*V(73)
  A(8) = RCT(8)*V(67)*V(74)
  A(9) = RCT(9)*V(73)*V(75)
  A(10) = RCT(10)*V(73)*V(73)*F(2)
  A(11) = RCT(11)*V(74)*V(75)
  A(12) = RCT(12)*V(22)
  A(13) = RCT(13)*V(22)*F(1)
  A(14) = RCT(14)*V(74)*V(75)
  A(15) = RCT(15)*V(75)
  A(16) = RCT(16)*V(75)
  A(17) = RCT(17)*V(67)
  A(18) = RCT(18)*V(67)
  A(19) = RCT(19)*V(11)*F(1)
  A(20) = RCT(20)*V(11)*F(2)
  A(21) = RCT(21)*V(71)*V(73)
  A(22) = RCT(22)*V(23)
  A(23) = RCT(23)*V(23)
  A(24) = RCT(24)*V(23)*V(71)
  A(25) = RCT(25)*V(71)*V(74)
  A(26) = RCT(26)*V(71)*V(75)
  A(27) = RCT(27)*V(47)*V(71)
  A(28) = RCT(28)*V(47)
  A(29) = RCT(29)*V(45)*V(71)
  A(30) = RCT(30)*V(67)*V(71)
  A(31) = RCT(31)*V(73)*V(78)
  A(32) = RCT(32)*V(74)*V(78)
  A(33) = RCT(33)*V(32)
  A(34) = RCT(34)*V(32)
  A(35) = RCT(35)*V(32)*V(71)
  A(36) = RCT(36)*V(67)*V(78)
  A(37) = RCT(37)*V(78)*V(78)
  A(38) = RCT(38)*V(78)*V(78)*F(1)
  A(39) = RCT(39)*V(75)*V(78)
  A(40) = RCT(40)*V(75)*V(75)
  A(41) = RCT(41)*V(19)
  A(42) = RCT(42)*V(19)*V(71)
  A(43) = RCT(43)*V(71)*V(78)
  A(44) = RCT(44)*V(10)*V(71)
  A(45) = RCT(45)*V(71)*F(2)
  A(46) = RCT(46)*V(73)*V(76)
  A(47) = RCT(47)*V(76)*V(78)
  A(48) = RCT(48)*V(75)*V(76)
  A(49) = RCT(49)*V(76)*V(76)
  A(50) = RCT(50)*V(76)*V(76)
  A(51) = RCT(51)*V(73)*V(77)
  A(52) = RCT(52)*V(77)*V(78)
  A(53) = RCT(53)*V(75)*V(77)
  A(54) = RCT(54)*V(76)*V(77)
  A(55) = RCT(55)*V(77)*V(77)
  A(56) = RCT(56)*V(53)*V(73)
  A(57) = RCT(57)*V(53)*V(78)
  A(58) = RCT(58)*V(53)*V(75)
  A(59) = RCT(59)*V(53)*V(76)
  A(60) = RCT(60)*V(53)*V(77)
  A(62) = RCT(62)*V(69)*V(73)
  A(63) = RCT(63)*V(69)*V(78)
  A(64) = RCT(64)*V(69)*V(76)
  A(65) = RCT(65)*V(69)*V(75)
  A(66) = RCT(66)*V(69)*V(77)
  A(67) = RCT(67)*V(53)*V(69)
  A(68) = RCT(68)*V(69)*V(69)
  A(69) = RCT(69)*V(68)*V(74)
  A(70) = RCT(70)*V(15)
  A(71) = RCT(71)*V(68)*V(73)
  A(72) = RCT(72)*V(68)*V(78)
  A(73) = RCT(73)*V(68)*V(75)
  A(74) = RCT(74)*V(68)*V(76)
  A(75) = RCT(75)*V(68)*V(77)
  A(76) = RCT(76)*V(53)*V(68)
  A(77) = RCT(77)*V(68)*V(69)
  A(78) = RCT(78)*V(68)*V(68)
  A(79) = RCT(79)*V(72)*V(74)
  A(80) = RCT(80)*V(16)
  A(81) = RCT(81)*V(72)*V(73)
  A(82) = RCT(82)*V(72)*V(78)
  A(83) = RCT(83)*V(72)*V(75)
  A(84) = RCT(84)*V(72)*V(76)
  A(85) = RCT(85)*V(72)*V(77)
  A(86) = RCT(86)*V(53)*V(72)
  A(87) = RCT(87)*V(69)*V(72)
  A(88) = RCT(88)*V(68)*V(72)
  A(89) = RCT(89)*V(72)*V(72)
  A(90) = RCT(90)*V(74)*V(79)
  A(91) = RCT(91)*V(17)
  A(92) = RCT(92)*V(73)*V(79)
  A(93) = RCT(93)*V(78)*V(79)
  A(94) = RCT(94)*V(75)*V(79)
  A(95) = RCT(95)*V(76)*V(79)
  A(96) = RCT(96)*V(77)*V(79)
  A(97) = RCT(97)*V(53)*V(79)
  A(98) = RCT(98)*V(69)*V(79)
  A(99) = RCT(99)*V(68)*V(79)
  A(100) = RCT(100)*V(72)*V(79)
  A(101) = RCT(101)*V(79)*V(79)
  A(102) = RCT(102)*V(70)*V(74)
  A(103) = RCT(103)*V(18)
  A(104) = RCT(104)*V(70)*V(73)
  A(105) = RCT(105)*V(70)*V(78)
  A(106) = RCT(106)*V(70)*V(75)
  A(107) = RCT(107)*V(70)*V(76)
  A(108) = RCT(108)*V(70)*V(77)
  A(109) = RCT(109)*V(53)*V(70)
  A(110) = RCT(110)*V(69)*V(70)
  A(111) = RCT(111)*V(68)*V(70)
  A(112) = RCT(112)*V(70)*V(72)
  A(113) = RCT(113)*V(70)*V(79)
  A(114) = RCT(114)*V(70)*V(70)
  A(115) = RCT(115)*V(25)*V(74)
  A(116) = RCT(116)*V(25)
  A(117) = RCT(117)*V(51)*V(74)
  A(118) = RCT(118)*V(51)*V(78)
  A(119) = RCT(119)*V(51)
  A(120) = RCT(120)*V(31)*V(74)
  A(121) = RCT(121)*V(31)*V(78)
  A(122) = RCT(122)*V(31)
  A(123) = RCT(123)*V(61)
  A(124) = RCT(124)*V(61)
  A(125) = RCT(125)*V(61)*V(71)
  A(126) = RCT(126)*V(61)*V(78)
  A(127) = RCT(127)*V(30)
  A(128) = RCT(128)*V(30)*V(73)
  A(129) = RCT(129)*V(61)*V(75)
  A(130) = RCT(130)*V(60)*V(71)
  A(131) = RCT(131)*V(60)
  A(132) = RCT(132)*V(60)*V(75)
  A(133) = RCT(133)*V(64)*V(71)
  A(134) = RCT(134)*V(64)
  A(135) = RCT(135)*V(64)*V(75)
  A(136) = RCT(136)*V(46)*V(71)
  A(137) = RCT(137)*V(46)
  A(138) = RCT(138)*V(65)*V(71)
  A(139) = RCT(139)*V(65)
  A(140) = RCT(140)*V(28)*V(71)
  A(141) = RCT(141)*V(21)*V(71)
  A(142) = RCT(142)*V(29)*V(71)
  A(143) = RCT(143)*V(29)
  A(144) = RCT(144)*V(42)*V(71)
  A(145) = RCT(145)*V(42)
  A(146) = RCT(146)*V(49)
  A(147) = RCT(147)*V(49)
  A(148) = RCT(148)*V(49)*V(71)
  A(149) = RCT(149)*V(49)*V(75)
  A(150) = RCT(150)*V(44)
  A(151) = RCT(151)*V(44)*V(71)
  A(152) = RCT(152)*V(44)*V(75)
  A(153) = RCT(153)*V(14)
  A(154) = RCT(154)*V(43)*V(71)
  A(155) = RCT(155)*V(43)*V(75)
  A(156) = RCT(156)*V(37)*V(71)
  A(157) = RCT(157)*V(37)*V(75)
  A(158) = RCT(158)*V(40)*V(75)
  A(159) = RCT(159)*V(41)*V(71)
  A(160) = RCT(160)*V(41)
  A(161) = RCT(161)*V(41)*V(75)
  A(162) = RCT(162)*V(55)*V(71)
  A(163) = RCT(163)*V(55)*V(67)
  A(164) = RCT(164)*V(55)*V(75)
  A(165) = RCT(165)*V(55)*V(63)
  A(166) = RCT(166)*V(55)
  A(167) = RCT(167)*V(59)*V(71)
  A(168) = RCT(168)*V(59)*V(67)
  A(169) = RCT(169)*V(59)*V(63)
  A(170) = RCT(170)*V(59)
  A(171) = RCT(171)*V(57)*V(71)
  A(172) = RCT(172)*V(57)*V(67)
  A(173) = RCT(173)*V(57)*V(75)
  A(174) = RCT(174)*V(57)
  A(175) = RCT(175)*V(66)*V(71)
  A(176) = RCT(176)*V(66)
  A(177) = RCT(177)*V(62)*V(71)
  A(178) = RCT(178)*V(62)
  A(179) = RCT(179)*V(38)*V(71)
  A(180) = RCT(180)*V(38)*V(67)
  A(181) = RCT(181)*V(35)*V(71)
  A(182) = RCT(182)*V(35)
  A(183) = RCT(183)*V(36)*V(71)
  A(184) = RCT(184)*V(36)
  A(185) = RCT(185)*V(12)*V(71)
  A(186) = RCT(186)*V(48)*V(71)
  A(187) = RCT(187)*V(48)*V(67)
  A(188) = RCT(188)*V(48)*V(75)
  A(189) = RCT(189)*V(48)*V(63)
  A(190) = RCT(190)*V(52)*V(71)
  A(191) = RCT(191)*V(52)*V(67)
  A(192) = RCT(192)*V(52)*V(75)
  A(193) = RCT(193)*V(52)*V(63)
  A(194) = RCT(194)*V(54)*V(71)
  A(195) = RCT(195)*V(54)*V(67)
  A(196) = RCT(196)*V(54)*V(75)
  A(197) = RCT(197)*V(54)*V(63)
  A(198) = RCT(198)*V(13)*V(71)
  A(199) = RCT(199)*V(20)*V(71)
  A(200) = RCT(200)*V(39)*V(71)
  A(201) = RCT(201)*V(24)*V(71)
  A(202) = RCT(202)*V(33)*V(71)
  A(203) = RCT(203)*V(26)*V(71)
  A(204) = RCT(204)*V(34)*V(71)
  A(205) = RCT(205)*V(27)*V(71)
  A(206) = RCT(206)*V(56)*V(71)
  A(207) = RCT(207)*V(56)*V(67)
  A(208) = RCT(208)*V(56)*V(75)
  A(209) = RCT(209)*V(56)*V(63)
  A(210) = RCT(210)*V(58)*V(71)
  A(211) = RCT(211)*V(58)*V(67)
  A(212) = RCT(212)*V(58)*V(75)
  A(213) = RCT(213)*V(58)*V(63)
  A(214) = RCT(214)*V(39)*V(67)
  A(215) = RCT(215)*V(50)*V(71)
  A(216) = RCT(216)*V(50)*V(67)
  A(217) = RCT(217)*V(50)*V(75)
  A(218) = RCT(218)*V(50)*V(63)
  A(219) = RCT(219)*V(10)
  A(220) = RCT(220)*V(78)
  A(221) = RCT(221)*V(10)
  A(222) = RCT(222)*V(1)
  A(223) = RCT(223)*V(47)
  A(224) = RCT(224)*V(19)
  A(225) = RCT(225)*V(2)

! Aggregate function
  Vdot(1) = A(44)+A(219)-A(222)
  Vdot(2) = 0.5*A(214)+0.135*A(216)-A(225)
  Vdot(3) = A(128)+0.333*A(163)+0.351*A(168)+0.1*A(172)+0.37*A(187)+0.204*A(191)+0.103*A(195)+0.297*A(200)+0.185*A(207)&
              &+0.073*A(211)+0.185*A(216)
  Vdot(4) = 0.25*A(72)+A(74)+A(75)+A(77)+0.05*A(207)+0.129*A(211)+0.17*A(216)
  Vdot(5) = 0.25*A(82)+A(84)+A(85)+A(87)+0.25*A(93)+A(95)+A(96)+A(98)+0.25*A(105)+A(107)+A(108)+2*A(110)+0.372*A(172)&
              &+0.15*A(191)+0.189*A(195)+0.119*A(207)+0.247*A(211)
  Vdot(6) = 0.75*A(72)
  Vdot(7) = 0.75*A(82)+0.75*A(93)+0.75*A(105)
  Vdot(8) = 2*A(120)+A(217)
  Vdot(9) = 6*A(120)+7*A(160)+0.048*A(215)+0.07*A(216)+2.693*A(217)+0.55*A(218)
  Vdot(10) = -A(44)-A(219)-A(221)
  Vdot(11) = A(18)-A(19)-A(20)
  Vdot(12) = -A(185)
  Vdot(13) = -A(198)
  Vdot(14) = -A(153)+0.031*A(195)+0.087*A(205)
  Vdot(15) = A(69)-A(70)
  Vdot(16) = A(79)-A(80)
  Vdot(17) = A(90)-A(91)
  Vdot(18) = A(102)-A(103)
  Vdot(19) = A(37)+A(38)-A(41)-A(42)-A(224)
  Vdot(20) = -A(199)
  Vdot(21) = -A(141)
  Vdot(22) = A(11)-A(12)-A(13)
  Vdot(23) = A(21)-A(22)-A(23)-A(24)
  Vdot(24) = -A(201)
  Vdot(25) = -A(115)-A(116)+0.236*A(201)
  Vdot(26) = -A(203)
  Vdot(27) = -A(205)
  Vdot(28) = A(49)+0.25*A(54)+0.25*A(64)-A(140)
  Vdot(29) = A(47)-A(142)-A(143)
  Vdot(30) = A(126)-A(127)-A(128)
  Vdot(31) = -A(120)-A(121)-A(122)+A(158)
  Vdot(32) = A(32)-A(33)-A(34)-A(35)
  Vdot(33) = -A(202)
  Vdot(34) = -A(204)
  Vdot(35) = -A(181)-A(182)+0.108*A(204)+0.099*A(205)
  Vdot(36) = -A(183)-A(184)+0.051*A(204)+0.093*A(205)
  Vdot(37) = -A(156)-A(157)+0.207*A(204)+0.187*A(205)
  Vdot(38) = -A(179)-A(180)+0.491*A(204)+0.561*A(205)
  Vdot(39) = -A(200)-A(214)
  Vdot(40) = A(117)+A(121)+A(122)-A(158)
  Vdot(41) = -A(159)-A(160)-A(161)+0.059*A(204)+0.05*A(205)+0.061*A(210)+0.042*A(211)+0.015*A(212)
  Vdot(42) = A(52)+A(63)-A(144)-A(145)
  Vdot(43) = A(118)+A(119)-A(154)-A(155)+0.017*A(204)
  Vdot(44) = -A(150)-A(151)-A(152)+0.23*A(156)+0.084*A(162)+0.9*A(163)+0.3*A(167)+0.95*A(168)+0.174*A(171)+0.742*A(172)&
               &+0.008*A(173)+0.5*A(182)+0.5*A(184)+0.119*A(204)+0.287*A(205)
  Vdot(45) = -A(29)+A(123)+A(124)+A(125)+A(129)+A(131)+0.034*A(133)+A(134)+2*A(146)+A(147)+1.26*A(148)+1.26*A(149)&
               &+A(150)+A(151)+A(152)+0.416*A(162)+0.45*A(163)+0.5*A(164)+0.67*A(166)+0.475*A(168)+0.7*A(170)+0.336*A(171)&
               &+0.498*A(172)+0.572*A(173)+1.233*A(174)+A(179)+1.5*A(180)+A(182)+A(184)+0.5*A(187)+0.491*A(189)+0.275*A(191)&
               &+0.157*A(195)+0.393*A(200)+0.002*A(202)+0.345*A(207)+0.265*A(211)+0.012*A(213)+1.5*A(214)+0.51*A(216)
  Vdot(46) = A(116)-A(136)-A(137)+0.006*A(177)+0.02*A(178)+0.13*A(195)+0.704*A(199)+0.024*A(201)+0.452*A(202)+0.072&
               &*A(203)+0.005*A(206)+0.001*A(207)+0.024*A(208)+0.127*A(210)+0.045*A(211)+0.102*A(212)
  Vdot(47) = 2*A(13)+A(25)-A(27)-A(28)+0.2*A(39)+A(129)+A(132)+A(135)+A(149)+A(152)+A(155)+A(157)+A(158)+A(161)+0.5&
               &*A(164)+0.15*A(173)-A(223)
  Vdot(48) = -A(186)-A(187)-A(188)-A(189)
  Vdot(49) = -A(146)-A(147)-A(148)-A(149)+0.23*A(154)+0.15*A(171)+0.023*A(172)+A(180)+0.5*A(182)+0.5*A(184)+0.009*A(189)&
               &+0.001*A(195)+0.607*A(200)+0.118*A(204)+0.097*A(205)
  Vdot(50) = -A(215)-A(216)-A(217)-A(218)
  Vdot(51) = A(92)+A(94)+A(99)+A(100)+2*A(101)+A(113)-A(117)-A(118)-A(119)+0.24*A(154)+A(155)+0.24*A(156)+A(157)
  Vdot(52) = -A(190)-A(191)-A(192)-A(193)
  Vdot(53) = -A(56)-A(57)-A(58)-A(59)-A(60)-A(67)-A(76)-A(86)+A(92)+A(94)-A(97)+A(99)+A(100)+2*A(101)-A(109)+A(113)&
               &+A(136)+0.616*A(138)+0.675*A(167)+0.515*A(176)+0.596*A(177)+0.152*A(178)+A(181)+A(182)+A(183)+A(184)+0.079&
               &*A(190)+0.126*A(191)+0.187*A(192)+0.24*A(193)+0.5*A(194)+0.729*A(195)+0.75*A(196)+0.559*A(201)+0.936*A(202)&
               &+0.948*A(203)+0.205*A(206)+0.488*A(208)+0.001*A(210)+0.137*A(211)+0.711*A(212)
  Vdot(54) = -A(194)-A(195)-A(196)-A(197)
  Vdot(55) = -A(162)-A(163)-A(164)-A(165)-A(166)+0.23*A(190)+0.39*A(191)+0.025*A(210)+0.026*A(211)+0.012*A(213)
  Vdot(56) = -A(206)-A(207)-A(208)-A(209)
  Vdot(57) = -A(171)-A(172)-A(173)-A(174)+0.357*A(190)+0.936*A(192)+0.025*A(210)
  Vdot(58) = -A(210)-A(211)-A(212)-A(213)
  Vdot(59) = -A(167)-A(168)-A(169)-A(170)+0.32*A(190)+0.16*A(191)+0.019*A(211)+0.048*A(212)
  Vdot(60) = A(81)+A(83)+A(88)+2*A(89)+A(100)+A(112)-A(130)-A(131)-A(132)+0.034*A(133)+A(134)+0.482*A(138)+A(139)+0.96&
               &*A(141)+0.129*A(171)+0.047*A(172)+0.467*A(174)+0.084*A(175)+0.246*A(176)+0.439*A(177)+0.431*A(178)+0.195&
               &*A(186)+0.25*A(189)+A(198)+0.445*A(201)+0.455*A(202)+0.099*A(203)+0.294*A(206)+0.154*A(207)+0.009*A(208)&
               &+0.732*A(210)+0.456*A(211)+0.507*A(212)+0.984*A(215)+0.5*A(216)
  Vdot(61) = A(46)+A(48)+A(49)+2*A(50)+0.75*A(54)+0.75*A(64)+A(74)+A(84)+A(95)+A(104)+A(106)+A(107)+A(111)+A(112)+A(113)&
               &+2*A(114)-A(123)-A(124)-A(125)-A(126)+A(127)-A(129)+A(136)+0.115*A(138)+A(140)+0.081*A(141)+0.35*A(142)&
               &+A(143)+A(147)+0.084*A(162)+0.2*A(163)+0.67*A(166)+0.3*A(167)+0.1*A(168)+0.055*A(171)+0.125*A(172)+0.227&
               &*A(173)+0.3*A(174)+0.213*A(175)+0.506*A(176)+0.01*A(177)+0.134*A(178)+1.61*A(186)+A(187)+0.191*A(189)+0.624&
               &*A(190)+0.592*A(191)+0.24*A(193)+0.276*A(194)+0.235*A(195)+0.096*A(200)+0.026*A(201)+0.024*A(202)+0.026&
               &*A(203)+0.732*A(206)+0.5*A(207)+0.244*A(210)+0.269*A(211)+0.079*A(212)+0.984*A(215)+0.5*A(216)
  Vdot(62) = A(62)+A(115)+0.572*A(173)-0.69*A(177)-A(178)+0.276*A(196)+0.511*A(208)+0.321*A(212)
  Vdot(63) = A(1)-A(2)-A(3)-A(4)-A(5)-A(6)+A(16)+A(17)+A(20)-A(165)-A(169)-A(189)-A(193)-A(197)-A(209)-A(213)-A(218)
  Vdot(64) = -A(133)-A(134)-A(135)+0.37*A(138)+A(144)+A(145)+A(165)+0.675*A(167)+0.45*A(169)+0.013*A(171)+0.218*A(173)&
               &+0.558*A(175)+0.71*A(176)+0.213*A(177)+0.147*A(178)+A(179)+A(181)+A(183)+A(188)+0.474*A(194)+0.205*A(195)&
               &+0.474*A(196)+0.147*A(197)+0.261*A(199)+0.122*A(201)+0.244*A(202)+0.204*A(203)+0.497*A(206)+0.363*A(207)&
               &+0.037*A(208)+0.45*A(209)+0.511*A(210)+0.305*A(211)+0.151*A(212)+0.069*A(213)+0.45*A(218)
  Vdot(65) = 0.5*A(64)+A(65)+0.5*A(66)+A(68)-A(138)-A(139)+0.416*A(162)+0.55*A(169)+0.15*A(171)+0.21*A(172)+0.233*A(174)&
               &+0.115*A(175)+0.177*A(177)+0.243*A(178)+0.332*A(201)+0.11*A(202)+0.089*A(203)+0.437*A(209)+0.072*A(210)&
               &+0.026*A(211)+0.001*A(212)+0.659*A(213)+0.55*A(218)
  Vdot(66) = 0.5*A(64)+0.5*A(66)+A(68)+A(77)+A(87)+A(98)+0.7*A(170)+0.332*A(171)-0.671*A(175)-A(176)+0.048*A(177)+0.435&
               &*A(178)+0.1*A(191)+0.75*A(193)+0.276*A(194)+0.276*A(195)+0.853*A(197)+0.125*A(202)+0.417*A(203)+0.055*A(204)&
               &+0.119*A(206)+0.215*A(207)+0.113*A(209)+0.043*A(211)+0.259*A(213)
  Vdot(67) = A(2)-A(3)-A(7)-A(8)-A(17)-A(18)-A(30)-A(36)+0.25*A(72)+0.25*A(82)+0.25*A(93)+0.25*A(105)-A(163)-A(168)&
               &-A(172)-A(180)-A(187)-A(191)-A(195)-A(207)-A(211)-A(214)-A(216)
  Vdot(68) = -A(69)+A(70)-A(71)-A(72)-A(73)-A(74)-A(75)-A(77)-2*A(78)-A(88)-A(99)+A(104)+A(106)+A(112)+A(113)+2*A(114)&
               &+A(130)+A(132)+A(136)+A(137)+0.492*A(138)+A(139)+A(150)+A(151)+A(152)+2*A(153)+0.67*A(166)+0.675*A(167)&
               &+0.467*A(174)+0.029*A(175)+0.667*A(176)+A(181)+0.5*A(182)+A(183)+0.5*A(184)+0.123*A(195)+0.011*A(202)+0.137&
               &*A(211)
  Vdot(69) = -A(62)-A(63)-A(64)-A(65)-A(66)-2*A(68)-A(77)-A(87)-A(98)-A(110)+0.001*A(133)+0.042*A(138)+0.025*A(167)&
               &+0.041*A(171)+0.051*A(173)+0.07*A(175)+0.04*A(176)+0.173*A(177)+0.095*A(178)+0.093*A(190)+0.008*A(191)+0.064&
               &*A(192)+0.01*A(193)+0.25*A(194)+0.18*A(195)+0.25*A(196)+0.035*A(199)+0.07*A(201)+0.143*A(202)+0.347*A(203)&
               &+0.011*A(204)+0.009*A(205)+0.09*A(206)+0.001*A(207)+0.176*A(208)+0.082*A(210)+0.002*A(211)+0.136*A(212)&
               &+0.001*A(213)+0.016*A(215)+0.051*A(217)
  Vdot(70) = -A(102)+A(103)-A(104)-A(105)-A(106)-A(107)-A(108)-A(110)-A(111)-A(112)-A(113)-2*A(114)+0.5*A(162)+0.5&
               &*A(164)+0.33*A(166)+0.3*A(170)+0.289*A(171)+0.15*A(173)+0.192*A(191)+0.24*A(193)
  Vdot(71) = 2*A(19)-A(21)+A(22)-A(24)-A(25)-A(26)-A(27)+A(28)-A(29)-A(30)+A(31)+0.39*A(34)-A(35)+A(36)+0.8*A(39)+2&
               &*A(41)-A(42)-A(43)-A(44)-A(45)-A(125)-A(130)-A(133)-A(136)-A(138)-A(140)-A(141)-0.65*A(142)+A(143)-0.34&
               &*A(144)+A(145)-A(148)-A(151)-A(154)-A(156)-A(159)-A(162)+0.208*A(163)+0.33*A(166)-A(167)+0.164*A(168)-A(171)&
               &+0.285*A(172)-A(175)-A(177)-A(179)+0.5*A(180)-A(181)-A(183)-A(185)-A(186)+0.12*A(187)-A(190)+0.266*A(191)&
               &-A(194)+0.567*A(195)-A(198)-A(199)-0.397*A(200)-A(201)-A(202)-A(203)-A(204)-A(205)-A(206)+0.155*A(207)&
               &-A(210)+0.378*A(211)+0.5*A(214)-A(215)+0.32*A(216)
  Vdot(72) = -A(79)+A(80)-A(81)-A(82)-A(83)-A(84)-A(85)-A(87)-A(88)-2*A(89)-A(100)-A(112)+0.965*A(133)+A(135)+0.096&
               &*A(138)+0.37*A(148)+0.37*A(149)+0.1*A(163)+0.05*A(168)+0.048*A(172)+0.3*A(174)+0.049*A(175)+0.333*A(176)&
               &+0.201*A(195)+0.006*A(211)
  Vdot(73) = A(1)-A(4)+A(5)-A(7)-A(9)-2*A(10)+A(14)+A(15)-A(21)+A(22)-A(31)-A(46)-A(51)-A(56)-A(62)-A(71)-A(81)-A(92)&
               &-A(104)-A(128)
  Vdot(74) = -A(1)+A(4)-A(5)-A(6)+A(7)-A(8)+2*A(9)+2*A(10)-A(11)+A(12)+A(16)+A(23)+A(24)-A(25)+A(26)+A(28)+A(31)-A(32)&
               &+A(33)+0.61*A(34)+A(35)+0.8*A(39)+2*A(40)+A(46)+A(48)+A(51)+A(53)+A(56)+A(58)+A(65)-A(69)+A(70)+A(71)+A(73)&
               &-A(79)+A(80)+A(81)+A(83)-A(90)+A(91)+A(92)+A(94)-A(102)+A(103)+A(104)+A(106)-A(115)-A(117)-A(120)+A(128)&
               &+0.338*A(177)+A(178)+0.187*A(192)+0.474*A(196)+0.391*A(212)
  Vdot(75) = A(6)+A(8)-A(9)-A(11)+A(12)-A(14)-A(15)-A(16)-A(26)+A(27)+0.39*A(34)-A(39)-2*A(40)-A(48)-A(53)-A(58)-A(65)&
               &-A(73)-A(83)-A(94)-A(106)-A(129)-A(132)-A(135)-A(149)-A(152)-A(155)-A(157)-A(158)-A(161)-A(164)-A(173)&
               &-A(188)-A(192)-A(196)-A(208)-A(212)-A(217)
  Vdot(76) = -A(46)-A(47)-A(48)-2*A(49)-2*A(50)-A(54)-A(64)+A(71)+A(73)-A(74)+2*A(78)-A(84)+A(88)-A(95)+A(99)-A(107)&
               &+A(111)+A(116)+A(131)+A(137)+0.65*A(142)+0.3*A(170)+A(185)+0.3*A(189)+0.25*A(193)+0.011*A(202)+0.076*A(207)&
               &+0.197*A(211)+0.03*A(212)+0.26*A(216)
  Vdot(77) = -A(51)-A(52)-A(53)-A(54)-2*A(55)-A(66)-A(75)+A(81)+A(83)-A(85)+A(88)+2*A(89)-A(96)+A(100)-A(108)+A(112)&
               &+0.034*A(133)+A(134)+0.37*A(138)+A(139)+0.05*A(141)+0.34*A(144)+0.76*A(154)+0.76*A(156)+0.5*A(162)+0.1&
               &*A(163)+0.5*A(164)+0.33*A(166)+0.3*A(167)+0.05*A(168)+0.67*A(171)+0.048*A(172)+0.799*A(173)+0.473*A(175)&
               &+0.96*A(176)+0.376*A(177)+0.564*A(178)+A(179)+A(182)+A(184)+A(186)+A(188)+0.2*A(189)+0.907*A(190)+0.066&
               &*A(191)+0.749*A(192)+0.75*A(194)+0.031*A(195)+0.276*A(196)+A(198)+0.965*A(199)+0.1*A(200)+0.695*A(201)+0.835&
               &*A(202)+0.653*A(203)+0.765*A(204)+0.804*A(205)+0.91*A(206)+0.022*A(207)+0.824*A(208)+0.918*A(210)+0.033&
               &*A(211)+0.442*A(212)+0.012*A(213)+0.984*A(215)+0.949*A(217)
  Vdot(78) = A(23)+A(26)+A(29)+A(30)-A(31)-A(32)+A(33)+0.61*A(34)-A(36)-2*A(37)-2*A(38)-A(39)+A(42)-A(43)+A(44)+A(45)&
               &+A(46)-A(47)+A(48)+2*A(50)+A(51)-A(52)+A(53)+A(54)+A(55)-A(63)+A(64)+A(65)+A(66)+A(68)-A(72)-A(82)-A(93)&
               &-A(105)-A(118)-A(121)+2*A(123)+A(125)-A(126)+A(127)+A(128)+A(129)+A(131)+A(134)+A(140)+0.95*A(141)+A(143)&
               &+A(145)+2*A(146)+0.63*A(148)+0.63*A(149)+A(150)+0.008*A(163)+0.34*A(166)+0.064*A(168)+0.4*A(172)+1.233&
               &*A(174)+0.379*A(175)+0.113*A(177)+0.341*A(178)+1.5*A(180)+0.5*A(182)+0.5*A(184)+0.12*A(187)+0.5*A(189)+0.033&
               &*A(195)+0.297*A(200)+0.224*A(204)+0.187*A(205)+0.056*A(207)+0.003*A(211)+0.013*A(213)+1.5*A(214)+0.06*A(216)&
               &-A(220)
  Vdot(79) = -A(90)+A(91)-A(92)-A(93)-A(94)-A(95)-A(96)-A(98)-A(99)-A(100)-2*A(101)-A(113)+A(159)+A(161)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE SAPRC99_Function

