! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADMKA_StoichiomSP.f90
! Time                 : Thu Oct  8 08:22:34 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADMKA_16038_BOXMOX
! Equation file        : RADMKA.kpp
! Output root filename : RADMKA
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADMKA_StoichiomSP

  USE RADMKA_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(187) :: CROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 26, &
      28, 30, 32, 34, 36, 38, 40, 42, 43, 45, 47, 49, &
      51, 53, 55, 57, 59, 61, 62, 64, 66, 68, 70, 72, &
      74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, &
      98,100,102,104,106,108,110,112,114,116,118,120, &
     122,124,125,127,128,130,132,134,136,138,140,142, &
     144,146,148,150,152,154,156,158,160,162,164,166, &
     168,170,172,174,176,178,180,182,184,186,188,190, &
     192,194,196,198,200,202,204,206,208,210,212,213, &
     215,217,219,221,223,225,227,229,231,233,235,237, &
     239,241,243,245,247,249,251,253,254,256,258,260, &
     262,264,266,268,270,272,274,276,278,280,281,283, &
     285,287,289,291,293,295,297,299,301,303,305,307, &
     309,311,313,315,317,318,320,322,324,326,328,330, &
     331,333,334,336,338,340,342 /)

  INTEGER, PARAMETER, DIMENSION(341) :: ICOL_JVRP = (/ &
      72, 74, 74, 15, 40, 26, 71, 71, 30, 58, 58, 65, &
      22, 54, 21, 49, 42, 42, 57, 45, 75, 29, 34, 29, &
      72,  1, 19, 19, 34, 19, 61, 73, 74, 70, 74, 69, &
      74, 69, 73, 69, 72, 69, 61, 69, 30, 70, 70, 73, &
      34, 73, 72, 74, 71, 73, 71, 72, 69, 71, 71, 72, &
      20, 20, 61, 70, 72, 40, 70, 26, 70, 69, 70,  7, &
      70, 36, 70, 24, 70,  8, 70, 17, 70, 10, 70, 11, &
      70, 31, 70, 38, 70, 63, 70, 12, 70, 13, 70, 25, &
      70, 58, 70, 65, 70, 49, 70, 42, 70, 57, 70, 45, &
      70, 22, 70, 54, 70, 21, 70, 28, 70, 70, 75, 39, &
      70, 68, 72, 28, 59, 72, 14, 67, 73, 73, 76, 46, &
      73, 47, 73, 50, 73, 51, 73, 48, 73, 68, 73, 59, &
      73, 53, 73, 43, 73, 66, 73, 64, 73, 56, 73, 58, &
      71, 65, 71, 42, 71, 57, 71, 45, 71, 25, 71, 31, &
      71, 38, 71, 63, 71, 39, 71, 31, 74, 38, 74, 63, &
      74, 39, 74, 67, 69, 66, 69, 69, 76, 46, 69, 47, &
      69, 50, 69, 51, 69, 48, 69, 64, 69, 68, 69, 53, &
      69, 43, 69, 59, 69, 56, 69, 67, 66, 67, 67, 76, &
      46, 67, 47, 67, 50, 67, 51, 67, 48, 67, 64, 67, &
      67, 68, 53, 67, 43, 67, 59, 67, 66, 68, 68, 76, &
      46, 68, 47, 68, 50, 68, 51, 68, 48, 68, 64, 68, &
      68, 53, 68, 43, 68, 59, 68, 52, 69, 52, 67, 52, &
      68, 52, 73, 41, 72, 41, 69, 41, 67, 41, 68, 56, &
      67, 56, 68, 56, 35, 70, 35, 71, 35, 74, 60, 73, &
      60, 69, 60, 67, 60, 68, 60, 71, 37, 70, 37, 71, &
      37, 74, 62, 73, 62, 69, 62, 67, 62, 68, 62, 71, &
      32, 73, 32, 69, 32,  9, 70, 33, 70, 44, 70, 44, &
      74, 55, 73, 55, 69, 55, 55, 72, 23, 23, 70, 16, &
      70, 27, 70, 18, 70 /)

  INTEGER, PARAMETER, DIMENSION(341) :: IROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 22, 23, &
      23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, &
      29, 30, 30, 31, 31, 32, 33, 33, 34, 34, 35, 35, &
      36, 36, 37, 37, 38, 38, 39, 39, 40, 40, 41, 41, &
      42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48, &
      48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, &
      54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, &
      60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66, &
      66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71, 72, &
      72, 73, 73, 74, 75, 75, 76, 77, 77, 78, 78, 79, &
      79, 80, 80, 81, 81, 82, 82, 83, 83, 84, 84, 85, &
      85, 86, 86, 87, 87, 88, 88, 89, 89, 90, 90, 91, &
      91, 92, 92, 93, 93, 94, 94, 95, 95, 96, 96, 97, &
      97, 98, 98, 99, 99,100,100,101,101,102,102,103, &
     103,104,104,105,105,106,106,107,107,108,108,109, &
     109,110,110,111,111,112,112,113,113,114,114,115, &
     115,116,116,117,117,118,118,119,120,120,121,121, &
     122,122,123,123,124,124,125,125,126,126,127,127, &
     128,128,129,129,130,130,131,131,132,132,133,133, &
     134,134,135,135,136,136,137,137,138,138,139,139, &
     140,141,141,142,142,143,143,144,144,145,145,146, &
     146,147,147,148,148,149,149,150,150,151,151,152, &
     152,153,153,154,155,155,156,156,157,157,158,158, &
     159,159,160,160,161,161,162,162,163,163,164,164, &
     165,165,166,166,167,167,168,168,169,169,170,170, &
     171,171,172,172,173,174,174,175,175,176,176,177, &
     177,178,178,179,179,180,181,181,182,183,183,184, &
     184,185,185,186,186 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(187) :: CCOL_STOICM = (/ &
       1,  4,  7, 10, 13, 16, 19, 22, 25, 27, 30, 33, &
      37, 41, 45, 49, 52, 55, 59, 63, 67, 72, 75, 79, &
      81, 83, 86, 90, 94, 98,102,105,107,109,113,116, &
     119,122,125,128,132,135,138,141,144,148,153,157, &
     161,164,168,172,180,185,190,193,196,199,204,209, &
     214,219,223,227,232,237,241,245,249,253,258,262, &
     265,268,271,274,277,282,290,297,305,311,317,324, &
     328,337,344,350,355,360,365,370,374,379,384,388, &
     392,395,398,401,404,410,421,433,445,448,451,454, &
     457,460,463,466,469,472,475,478,481,484,487,490, &
     495,501,507,513,518,523,529,534,539,546,552,562, &
     568,575,582,589,596,603,611,617,619,626,632,640, &
     643,647,650,653,656,659,663,666,672,679,683,686, &
     689,699,706,709,715,721,727,730,733,746,754,757, &
     763,770,777,784,787,791,793,797,800,808,817,820, &
     826,829,832,836,839,843,848 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      29, 72, 73, 19, 34, 74, 29, 34, 74, 15, 70, 73, &
      40, 70, 72, 26, 69, 72, 34, 71, 73, 29, 71, 72, &
      30, 70,  6, 36, 58, 36, 58, 69, 36, 65, 67, 69, &
      22, 58, 69, 70, 54, 65, 69, 70,  5, 21, 67, 70, &
      49, 66, 68, 36, 42, 58, 36, 42, 58, 69, 36, 57, &
      68, 69, 45, 59, 68, 69, 49, 65, 69, 72, 75, 29, &
      34, 74, 29, 34, 72, 73, 19, 29, 19, 29, 19, 61, &
      70, 34, 72, 73, 74, 34, 69, 70, 74, 34, 69, 70, &
      74, 69, 70, 72, 73, 26, 69, 72, 30, 69, 30, 69, &
      30, 61, 69, 70, 15, 70, 73, 34, 72, 73, 71, 72, &
      74, 71, 72, 73, 34, 71, 73, 34, 40, 69, 71, 20, &
      71, 72, 20, 71, 72, 20, 40, 61, 40, 70, 72, 40, &
      61, 70, 71, 26, 34, 61, 70, 72, 34, 61, 69, 70, &
       2,  7, 69, 70, 36, 69, 70, 24, 61, 67, 70,  8, &
      61, 66, 70, 17, 49, 58, 61, 65, 69, 70, 76, 10, &
      46, 52, 61, 70, 11, 47, 52, 61, 70, 31, 50, 70, &
      38, 51, 70, 48, 63, 70, 12, 25, 53, 69, 70, 13, &
      25, 43, 69, 70, 25, 52, 59, 69, 70, 36, 58, 61, &
      69, 70, 61, 65, 68, 70, 49, 61, 64, 70, 36, 42, &
      61, 69, 70, 36, 57, 61, 68, 70, 45, 59, 61, 70, &
      22, 58, 67, 70, 54, 65, 70, 76, 21, 61, 68, 70, &
      28, 52, 58, 70, 71, 70, 72, 75, 76, 32, 39, 70, &
      28, 68, 72, 28, 68, 72, 14, 59, 72, 14, 59, 72, &
      58, 67, 69, 72, 73, 49, 58, 65, 69, 72, 73, 75, &
      76, 46, 49, 65, 69, 72, 73, 75, 47, 49, 58, 65, &
      69, 72, 73, 75, 50, 58, 65, 69, 72, 73, 51, 58, &
      65, 69, 72, 73, 48, 49, 58, 65, 69, 72, 73, 67, &
      68, 72, 73, 36, 42, 52, 57, 59, 68, 69, 72, 73, &
      42, 45, 53, 57, 69, 72, 73, 43, 45, 57, 69, 72, &
      73, 65, 66, 69, 72, 73, 57, 64, 69, 72, 73, 56 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      58, 65, 72, 73, 36, 40, 58, 69, 71, 40, 65, 68, &
      71, 36, 40, 42, 69, 71, 36, 40, 57, 68, 71, 40, &
      45, 59, 71, 25, 40, 41, 71, 31, 56, 71, 38, 56, &
      71, 56, 63, 71, 33, 39, 71,  3, 31, 36, 58, 69, &
      74,  3,  4, 24, 36, 38, 58, 65, 67, 69, 70, 74, &
       3,  4, 24, 36, 49, 58, 63, 65, 67, 69, 70, 74, &
       3, 30, 36, 39, 44, 55, 58, 67, 68, 69, 70, 74, &
      22, 67, 69, 54, 66, 69, 54, 69, 76, 46, 54, 69, &
      47, 54, 69, 50, 54, 69, 51, 54, 69, 48, 54, 69, &
      54, 64, 69, 21, 68, 69, 53, 54, 69, 43, 54, 69, &
      54, 59, 69, 56, 69, 75, 58, 67, 69, 58, 65, 66, &
      67, 69, 49, 58, 65, 67, 69, 76, 46, 49, 58, 65, &
      67, 69, 47, 49, 58, 65, 67, 69, 50, 58, 65, 67, &
      69, 51, 58, 65, 67, 69, 48, 49, 58, 65, 67, 69, &
      57, 58, 64, 67, 69,  4, 58, 67, 68, 69, 42, 45, &
      53, 57, 58, 67, 69, 43, 45, 57, 58, 67, 69,  4, &
      36, 42, 52, 57, 58, 59, 67, 68, 69,  4, 65, 66, &
      67, 68, 69,  4, 49, 65, 67, 68, 69, 76,  4, 46, &
      49, 65, 67, 68, 69,  4, 47, 49, 65, 67, 68, 69, &
       4, 50, 58, 65, 67, 68, 69,  4, 51, 58, 65, 67, &
      68, 69,  4, 48, 49, 58, 65, 67, 68, 69,  4, 57, &
      64, 67, 68, 69, 67, 68, 42, 45, 53, 57, 67, 68, &
      69, 43, 45, 57, 67, 68, 69, 36, 42, 52, 57, 59, &
      67, 68, 69, 52, 54, 69, 52, 58, 67, 69, 52, 67, &
      68, 52, 72, 73, 41, 72, 75, 41, 54, 69, 41, 58, &
      67, 69, 41, 67, 68, 56, 58, 65, 67, 69, 72,  4, &
      56, 58, 65, 67, 68, 72, 56, 58, 65, 72, 35, 60, &
      70, 35, 56, 71, 30, 35, 36, 49, 64, 65, 66, 69, &
      70, 74, 49, 60, 65, 69, 72, 73, 75, 54, 60, 69, &
      49, 58, 60, 65, 67, 69, 49, 60, 65, 67, 68, 69 /)
  INTEGER, PARAMETER, DIMENSION(127) :: IROW_STOICM_2 = (/ &
      49, 60, 65, 69, 71, 72, 37, 62, 70, 37, 56, 71, &
       3,  4, 30, 36, 37, 38, 44, 58, 64, 66, 69, 70, &
      74, 44, 58, 62, 63, 69, 72, 73, 75, 54, 62, 69, &
      44, 58, 62, 63, 67, 69, 44, 58, 62, 63, 67, 68, &
      69, 44, 58, 62, 63, 69, 71, 72, 32, 33, 44, 58, &
      69, 72, 73,  9, 32, 69, 32, 44, 58, 69,  9, 44, &
      18, 27, 33, 70, 44, 55, 70,  3, 36, 44, 57, 68, &
      69, 70, 74, 27, 36, 55, 57, 58, 68, 69, 72, 73, &
      16, 55, 69, 27, 36, 55, 57, 58, 69, 23, 55, 72, &
      23, 55, 72, 23, 27, 70, 72, 16, 55, 70, 27, 57, &
      69, 70, 18, 36, 58, 70, 72 /)
  INTEGER, PARAMETER, DIMENSION(847) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  2,  3,  3,  3,  4,  4,  4, &
       5,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  8, &
       9,  9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12, &
      13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, &
      16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 19, 19, &
      19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22, &
      22, 22, 23, 23, 23, 23, 24, 24, 25, 25, 26, 26, &
      26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, &
      29, 30, 30, 30, 30, 31, 31, 31, 32, 32, 33, 33, &
      34, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, &
      37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 40, 41, &
      41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 45, &
      45, 45, 45, 46, 46, 46, 46, 46, 47, 47, 47, 47, &
      48, 48, 48, 48, 49, 49, 49, 50, 50, 50, 50, 51, &
      51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 53, &
      53, 53, 53, 53, 54, 54, 54, 54, 54, 55, 55, 55, &
      56, 56, 56, 57, 57, 57, 58, 58, 58, 58, 58, 59, &
      59, 59, 59, 59, 60, 60, 60, 60, 60, 61, 61, 61, &
      61, 61, 62, 62, 62, 62, 63, 63, 63, 63, 64, 64, &
      64, 64, 64, 65, 65, 65, 65, 65, 66, 66, 66, 66, &
      67, 67, 67, 67, 68, 68, 68, 68, 69, 69, 69, 69, &
      70, 70, 70, 70, 70, 71, 71, 71, 71, 72, 72, 72, &
      73, 73, 73, 74, 74, 74, 75, 75, 75, 76, 76, 76, &
      77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, &
      78, 79, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, &
      80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 82, 82, &
      82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 84, &
      84, 84, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, &
      86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, &
      87, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 90 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
      90, 90, 90, 90, 91, 91, 91, 91, 91, 92, 92, 92, &
      92, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 95, &
      95, 95, 95, 96, 96, 96, 96, 97, 97, 97, 98, 98, &
      98, 99, 99, 99,100,100,100,101,101,101,101,101, &
     101,102,102,102,102,102,102,102,102,102,102,102, &
     103,103,103,103,103,103,103,103,103,103,103,103, &
     104,104,104,104,104,104,104,104,104,104,104,104, &
     105,105,105,106,106,106,107,107,107,108,108,108, &
     109,109,109,110,110,110,111,111,111,112,112,112, &
     113,113,113,114,114,114,115,115,115,116,116,116, &
     117,117,117,118,118,118,119,119,119,120,120,120, &
     120,120,121,121,121,121,121,121,122,122,122,122, &
     122,122,123,123,123,123,123,123,124,124,124,124, &
     124,125,125,125,125,125,126,126,126,126,126,126, &
     127,127,127,127,127,128,128,128,128,128,129,129, &
     129,129,129,129,129,130,130,130,130,130,130,131, &
     131,131,131,131,131,131,131,131,131,132,132,132, &
     132,132,132,133,133,133,133,133,133,133,134,134, &
     134,134,134,134,134,135,135,135,135,135,135,135, &
     136,136,136,136,136,136,136,137,137,137,137,137, &
     137,137,138,138,138,138,138,138,138,138,139,139, &
     139,139,139,139,140,140,141,141,141,141,141,141, &
     141,142,142,142,142,142,142,143,143,143,143,143, &
     143,143,143,144,144,144,145,145,145,145,146,146, &
     146,147,147,147,148,148,148,149,149,149,150,150, &
     150,150,151,151,151,152,152,152,152,152,152,153, &
     153,153,153,153,153,153,154,154,154,154,155,155, &
     155,156,156,156,157,157,157,157,157,157,157,157, &
     157,157,158,158,158,158,158,158,158,159,159,159, &
     160,160,160,160,160,160,161,161,161,161,161,161 /)
  INTEGER, PARAMETER, DIMENSION(127) :: ICOL_STOICM_2 = (/ &
     162,162,162,162,162,162,163,163,163,164,164,164, &
     165,165,165,165,165,165,165,165,165,165,165,165, &
     165,166,166,166,166,166,166,166,166,167,167,167, &
     168,168,168,168,168,168,169,169,169,169,169,169, &
     169,170,170,170,170,170,170,170,171,171,171,171, &
     171,171,171,172,172,172,173,173,173,173,174,174, &
     175,175,175,175,176,176,176,177,177,177,177,177, &
     177,177,177,178,178,178,178,178,178,178,178,178, &
     179,179,179,180,180,180,180,180,180,181,181,181, &
     182,182,182,183,183,183,183,184,184,184,185,185, &
     185,185,186,186,186,186,186 /)
  INTEGER, PARAMETER, DIMENSION(847) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.870000e+00_dp,  -1.000000e+00_dp,  1.300000e-01_dp,  1.550000e+00_dp, &
       -1.000000e+00_dp,  4.500000e-01_dp,  8.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e-02_dp, &
       9.800000e-01_dp,  8.000000e-01_dp,  2.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-02_dp,  9.000000e-03_dp,  1.000000e+00_dp, &
       7.500000e-02_dp,  1.700000e-01_dp,  -1.000000e+00_dp,  8.300000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  7.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp, &
       7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.700000e-01_dp, &
       8.300000e-01_dp,  1.700000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       9.000000e-01_dp,  1.000000e-01_dp,  -1.900000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  -5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  9.000000e-02_dp,  7.500000e-01_dp,  9.640000e-01_dp, &
       9.640000e-01_dp,  -1.000000e+00_dp,  3.600000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       6.900000e-01_dp,  3.800000e-01_dp,  9.200000e-01_dp,  9.200000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-02_dp,  -1.000000e+00_dp,  1.060000e+00_dp,  4.000000e-02_dp,  3.500000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       7.600000e-01_dp,  7.600000e-01_dp,  -1.000000e+00_dp,  2.400000e-01_dp,  -1.000000e+00_dp, &
       1.600000e+00_dp,  2.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  2.800000e-01_dp,  1.450000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  9.500000e-01_dp,  8.900000e-01_dp,  2.000000e+00_dp, &
       1.100000e-01_dp,  -1.000000e+00_dp,  5.000000e-02_dp,  9.200000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.600000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  1.700000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  8.060000e-01_dp, &
       4.500000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -5.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  -1.000000e+00_dp, &
       4.200000e-01_dp,  1.000000e+00_dp,  1.200000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       2.000000e-01_dp,  6.000000e-02_dp,  3.300000e-01_dp,  -1.000000e+00_dp,  5.300000e-01_dp, &
       5.000000e-01_dp,  2.200000e-01_dp,  2.300000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       6.000000e-02_dp,  2.900000e-01_dp,  9.000000e-02_dp,  2.300000e-01_dp,  1.000000e-01_dp, &
       1.800000e-01_dp,  -1.000000e+00_dp,  7.200000e-01_dp,  3.100000e-01_dp,  2.600000e-01_dp, &
       1.400000e-01_dp,  -1.000000e+00_dp,  2.800000e-01_dp,  9.000000e-02_dp,  1.400000e-01_dp, &
       -1.000000e+00_dp,  6.500000e-01_dp,  1.000000e-01_dp,  5.800000e-01_dp,  8.000000e-02_dp, &
       1.000000e-01_dp,  2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.500000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  7.500000e-01_dp, &
       7.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.600000e-01_dp, &
       8.400000e-01_dp,  7.700000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  7.700000e-01_dp,  4.100000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.390000e+00_dp,  8.000000e-01_dp,  4.600000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.550000e+00_dp,  3.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.250000e+00_dp,  7.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.500000e-01_dp,  8.900000e-01_dp, &
       7.250000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  7.500000e-01_dp,  7.500000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       -5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.600000e-01_dp,  7.000000e-01_dp, &
       -1.000000e+00_dp,  1.700000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  8.060000e-01_dp,  4.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  5.000000e-01_dp,  4.750000e-01_dp,  4.450000e-01_dp,  1.000000e+00_dp, &
       5.500000e-02_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-02_dp, &
       4.600000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  2.600000e-01_dp,  7.700000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  4.100000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.390000e+00_dp,  4.600000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  6.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.500000e-01_dp, &
       1.400000e-01_dp,  7.250000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.600000e-01_dp,  7.000000e-01_dp, &
       -1.000000e+00_dp,  1.700000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  8.060000e-01_dp,  4.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  9.500000e-01_dp,  8.900000e-01_dp,  2.000000e+00_dp,  1.100000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -9.500000e-01_dp,  9.200000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.750000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp, &
       2.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-02_dp,  -1.000000e+00_dp, &
       1.400000e-01_dp,  5.300000e-01_dp,  4.200000e-01_dp,  6.500000e-01_dp,  2.000000e-01_dp, &
       1.000000e-01_dp,  8.500000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  8.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-02_dp,  7.000000e-02_dp,  2.000000e-02_dp, &
       1.400000e-01_dp,  -1.000000e+00_dp,  4.600000e-01_dp,  7.900000e-01_dp,  4.000000e-02_dp, &
       4.200000e-01_dp,  1.600000e-01_dp,  1.000000e-01_dp,  8.500000e-01_dp,  -1.000000e+00_dp, &
       4.000000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  6.500000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(97) :: STOICM_5 = (/ &
       6.500000e-01_dp,  -1.000000e+00_dp,  3.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  6.000000e-01_dp,  1.400000e+00_dp,  -1.000000e+00_dp,  4.000000e-01_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  6.000000e-01_dp,  4.000000e-01_dp,  -1.000000e+00_dp, &
       4.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  6.000000e-01_dp, &
       4.000000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  4.600000e-02_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp, &
       2.200000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  1.000000e-01_dp,  3.200000e-01_dp, &
       1.900000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  7.500000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(847) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5 /)


END MODULE RADMKA_StoichiomSP

