! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADMKA_Stoichiom.f90
! Time                 : Thu Oct  8 08:22:34 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADMKA_16038_BOXMOX
! Equation file        : RADMKA.kpp
! Output root filename : RADMKA
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADMKA_Stoichiom

  USE RADMKA_Parameters
  USE RADMKA_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(72)
  ARP(2) = V(74)
  ARP(3) = V(74)
  ARP(4) = V(15)
  ARP(5) = V(40)
  ARP(6) = V(26)
  ARP(7) = V(71)
  ARP(8) = V(71)
  ARP(9) = V(30)
  ARP(10) = V(58)
  ARP(11) = V(58)
  ARP(12) = V(65)
  ARP(13) = V(22)
  ARP(14) = V(54)
  ARP(15) = V(21)
  ARP(16) = V(49)
  ARP(17) = V(42)
  ARP(18) = V(42)
  ARP(19) = V(57)
  ARP(20) = V(45)
  ARP(21) = V(75)
  ARP(22) = V(29)*V(34)
  ARP(23) = V(29)*V(72)
  ARP(24) = V(1)*V(19)
  ARP(25) = V(19)*V(34)
  ARP(26) = V(19)*V(61)
  ARP(27) = V(73)*V(74)
  ARP(28) = V(70)*V(74)
  ARP(29) = V(69)*V(74)
  ARP(30) = V(69)*V(73)
  ARP(31) = V(69)*V(72)
  ARP(32) = V(69)*V(69)
  ARP(33) = V(61)*V(69)*V(69)
  ARP(34) = V(30)*V(70)
  ARP(35) = V(70)*V(73)
  ARP(36) = V(34)*V(73)*V(73)
  ARP(37) = V(72)*V(74)
  ARP(38) = V(71)*V(73)
  ARP(39) = V(71)*V(72)
  ARP(40) = V(69)*V(71)
  ARP(41) = V(71)*V(72)
  ARP(42) = V(20)
  ARP(43) = V(20)*V(61)
  ARP(44) = V(70)*V(72)
  ARP(45) = V(40)*V(70)
  ARP(46) = V(26)*V(70)
  ARP(47) = V(69)*V(70)
  ARP(48) = V(7)*V(70)
  ARP(49) = V(36)*V(70)
  ARP(50) = V(24)*V(70)
  ARP(51) = V(8)*V(70)
  ARP(52) = V(17)*V(70)
  ARP(53) = V(10)*V(70)
  ARP(54) = V(11)*V(70)
  ARP(55) = V(31)*V(70)
  ARP(56) = V(38)*V(70)
  ARP(57) = V(63)*V(70)
  ARP(58) = V(12)*V(70)
  ARP(59) = V(13)*V(70)
  ARP(60) = V(25)*V(70)
  ARP(61) = V(58)*V(70)
  ARP(62) = V(65)*V(70)
  ARP(63) = V(49)*V(70)
  ARP(64) = V(42)*V(70)
  ARP(65) = V(57)*V(70)
  ARP(66) = V(45)*V(70)
  ARP(67) = V(22)*V(70)
  ARP(68) = V(54)*V(70)
  ARP(69) = V(21)*V(70)
  ARP(70) = V(28)*V(70)
  ARP(71) = V(70)*V(75)
  ARP(72) = V(39)*V(70)
  ARP(73) = V(68)*V(72)
  ARP(74) = V(28)
  ARP(75) = V(59)*V(72)
  ARP(76) = V(14)
  ARP(77) = V(67)*V(73)
  ARP(78) = V(73)*V(76)
  ARP(79) = V(46)*V(73)
  ARP(80) = V(47)*V(73)
  ARP(81) = V(50)*V(73)
  ARP(82) = V(51)*V(73)
  ARP(83) = V(48)*V(73)
  ARP(84) = V(68)*V(73)
  ARP(85) = V(59)*V(73)
  ARP(86) = V(53)*V(73)
  ARP(87) = V(43)*V(73)
  ARP(88) = V(66)*V(73)
  ARP(89) = V(64)*V(73)
  ARP(90) = V(56)*V(73)
  ARP(91) = V(58)*V(71)
  ARP(92) = V(65)*V(71)
  ARP(93) = V(42)*V(71)
  ARP(94) = V(57)*V(71)
  ARP(95) = V(45)*V(71)
  ARP(96) = V(25)*V(71)
  ARP(97) = V(31)*V(71)
  ARP(98) = V(38)*V(71)
  ARP(99) = V(63)*V(71)
  ARP(100) = V(39)*V(71)
  ARP(101) = V(31)*V(74)
  ARP(102) = V(38)*V(74)
  ARP(103) = V(63)*V(74)
  ARP(104) = V(39)*V(74)
  ARP(105) = V(67)*V(69)
  ARP(106) = V(66)*V(69)
  ARP(107) = V(69)*V(76)
  ARP(108) = V(46)*V(69)
  ARP(109) = V(47)*V(69)
  ARP(110) = V(50)*V(69)
  ARP(111) = V(51)*V(69)
  ARP(112) = V(48)*V(69)
  ARP(113) = V(64)*V(69)
  ARP(114) = V(68)*V(69)
  ARP(115) = V(53)*V(69)
  ARP(116) = V(43)*V(69)
  ARP(117) = V(59)*V(69)
  ARP(118) = V(56)*V(69)
  ARP(119) = V(67)*V(67)
  ARP(120) = V(66)*V(67)
  ARP(121) = V(67)*V(76)
  ARP(122) = V(46)*V(67)
  ARP(123) = V(47)*V(67)
  ARP(124) = V(50)*V(67)
  ARP(125) = V(51)*V(67)
  ARP(126) = V(48)*V(67)
  ARP(127) = V(64)*V(67)
  ARP(128) = V(67)*V(68)
  ARP(129) = V(53)*V(67)
  ARP(130) = V(43)*V(67)
  ARP(131) = V(59)*V(67)
  ARP(132) = V(66)*V(68)
  ARP(133) = V(68)*V(76)
  ARP(134) = V(46)*V(68)
  ARP(135) = V(47)*V(68)
  ARP(136) = V(50)*V(68)
  ARP(137) = V(51)*V(68)
  ARP(138) = V(48)*V(68)
  ARP(139) = V(64)*V(68)
  ARP(140) = V(68)*V(68)
  ARP(141) = V(53)*V(68)
  ARP(142) = V(43)*V(68)
  ARP(143) = V(59)*V(68)
  ARP(144) = V(52)*V(69)
  ARP(145) = V(52)*V(67)
  ARP(146) = V(52)*V(68)
  ARP(147) = V(52)*V(73)
  ARP(148) = V(41)*V(72)
  ARP(149) = V(41)*V(69)
  ARP(150) = V(41)*V(67)
  ARP(151) = V(41)*V(68)
  ARP(152) = V(56)*V(67)
  ARP(153) = V(56)*V(68)
  ARP(154) = V(56)*V(56)
  ARP(155) = V(35)*V(70)
  ARP(156) = V(35)*V(71)
  ARP(157) = V(35)*V(74)
  ARP(158) = V(60)*V(73)
  ARP(159) = V(60)*V(69)
  ARP(160) = V(60)*V(67)
  ARP(161) = V(60)*V(68)
  ARP(162) = V(60)*V(71)
  ARP(163) = V(37)*V(70)
  ARP(164) = V(37)*V(71)
  ARP(165) = V(37)*V(74)
  ARP(166) = V(62)*V(73)
  ARP(167) = V(62)*V(69)
  ARP(168) = V(62)*V(67)
  ARP(169) = V(62)*V(68)
  ARP(170) = V(62)*V(71)
  ARP(171) = V(32)*V(73)
  ARP(172) = V(32)*V(69)
  ARP(173) = V(32)*V(32)
  ARP(174) = V(9)*V(70)
  ARP(175) = V(33)*V(70)
  ARP(176) = V(44)*V(70)
  ARP(177) = V(44)*V(74)
  ARP(178) = V(55)*V(73)
  ARP(179) = V(55)*V(69)
  ARP(180) = V(55)*V(55)
  ARP(181) = V(55)*V(72)
  ARP(182) = V(23)
  ARP(183) = V(23)*V(70)
  ARP(184) = V(16)*V(70)
  ARP(185) = V(27)*V(70)
  ARP(186) = V(18)*V(70)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(72)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(74)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(74)
  JVRP(3) = 1
! JVRP(4) = dARP(4)/dV(15)
  JVRP(4) = 1
! JVRP(5) = dARP(5)/dV(40)
  JVRP(5) = 1
! JVRP(6) = dARP(6)/dV(26)
  JVRP(6) = 1
! JVRP(7) = dARP(7)/dV(71)
  JVRP(7) = 1
! JVRP(8) = dARP(8)/dV(71)
  JVRP(8) = 1
! JVRP(9) = dARP(9)/dV(30)
  JVRP(9) = 1
! JVRP(10) = dARP(10)/dV(58)
  JVRP(10) = 1
! JVRP(11) = dARP(11)/dV(58)
  JVRP(11) = 1
! JVRP(12) = dARP(12)/dV(65)
  JVRP(12) = 1
! JVRP(13) = dARP(13)/dV(22)
  JVRP(13) = 1
! JVRP(14) = dARP(14)/dV(54)
  JVRP(14) = 1
! JVRP(15) = dARP(15)/dV(21)
  JVRP(15) = 1
! JVRP(16) = dARP(16)/dV(49)
  JVRP(16) = 1
! JVRP(17) = dARP(17)/dV(42)
  JVRP(17) = 1
! JVRP(18) = dARP(18)/dV(42)
  JVRP(18) = 1
! JVRP(19) = dARP(19)/dV(57)
  JVRP(19) = 1
! JVRP(20) = dARP(20)/dV(45)
  JVRP(20) = 1
! JVRP(21) = dARP(21)/dV(75)
  JVRP(21) = 1
! JVRP(22) = dARP(22)/dV(29)
  JVRP(22) = V(34)
! JVRP(23) = dARP(22)/dV(34)
  JVRP(23) = V(29)
! JVRP(24) = dARP(23)/dV(29)
  JVRP(24) = V(72)
! JVRP(25) = dARP(23)/dV(72)
  JVRP(25) = V(29)
! JVRP(26) = dARP(24)/dV(1)
  JVRP(26) = V(19)
! JVRP(27) = dARP(24)/dV(19)
  JVRP(27) = V(1)
! JVRP(28) = dARP(25)/dV(19)
  JVRP(28) = V(34)
! JVRP(29) = dARP(25)/dV(34)
  JVRP(29) = V(19)
! JVRP(30) = dARP(26)/dV(19)
  JVRP(30) = V(61)
! JVRP(31) = dARP(26)/dV(61)
  JVRP(31) = V(19)
! JVRP(32) = dARP(27)/dV(73)
  JVRP(32) = V(74)
! JVRP(33) = dARP(27)/dV(74)
  JVRP(33) = V(73)
! JVRP(34) = dARP(28)/dV(70)
  JVRP(34) = V(74)
! JVRP(35) = dARP(28)/dV(74)
  JVRP(35) = V(70)
! JVRP(36) = dARP(29)/dV(69)
  JVRP(36) = V(74)
! JVRP(37) = dARP(29)/dV(74)
  JVRP(37) = V(69)
! JVRP(38) = dARP(30)/dV(69)
  JVRP(38) = V(73)
! JVRP(39) = dARP(30)/dV(73)
  JVRP(39) = V(69)
! JVRP(40) = dARP(31)/dV(69)
  JVRP(40) = V(72)
! JVRP(41) = dARP(31)/dV(72)
  JVRP(41) = V(69)
! JVRP(42) = dARP(32)/dV(69)
  JVRP(42) = 2*V(69)
! JVRP(43) = dARP(33)/dV(61)
  JVRP(43) = V(69)*V(69)
! JVRP(44) = dARP(33)/dV(69)
  JVRP(44) = 2*V(61)*V(69)
! JVRP(45) = dARP(34)/dV(30)
  JVRP(45) = V(70)
! JVRP(46) = dARP(34)/dV(70)
  JVRP(46) = V(30)
! JVRP(47) = dARP(35)/dV(70)
  JVRP(47) = V(73)
! JVRP(48) = dARP(35)/dV(73)
  JVRP(48) = V(70)
! JVRP(49) = dARP(36)/dV(34)
  JVRP(49) = V(73)*V(73)
! JVRP(50) = dARP(36)/dV(73)
  JVRP(50) = 2*V(34)*V(73)
! JVRP(51) = dARP(37)/dV(72)
  JVRP(51) = V(74)
! JVRP(52) = dARP(37)/dV(74)
  JVRP(52) = V(72)
! JVRP(53) = dARP(38)/dV(71)
  JVRP(53) = V(73)
! JVRP(54) = dARP(38)/dV(73)
  JVRP(54) = V(71)
! JVRP(55) = dARP(39)/dV(71)
  JVRP(55) = V(72)
! JVRP(56) = dARP(39)/dV(72)
  JVRP(56) = V(71)
! JVRP(57) = dARP(40)/dV(69)
  JVRP(57) = V(71)
! JVRP(58) = dARP(40)/dV(71)
  JVRP(58) = V(69)
! JVRP(59) = dARP(41)/dV(71)
  JVRP(59) = V(72)
! JVRP(60) = dARP(41)/dV(72)
  JVRP(60) = V(71)
! JVRP(61) = dARP(42)/dV(20)
  JVRP(61) = 1
! JVRP(62) = dARP(43)/dV(20)
  JVRP(62) = V(61)
! JVRP(63) = dARP(43)/dV(61)
  JVRP(63) = V(20)
! JVRP(64) = dARP(44)/dV(70)
  JVRP(64) = V(72)
! JVRP(65) = dARP(44)/dV(72)
  JVRP(65) = V(70)
! JVRP(66) = dARP(45)/dV(40)
  JVRP(66) = V(70)
! JVRP(67) = dARP(45)/dV(70)
  JVRP(67) = V(40)
! JVRP(68) = dARP(46)/dV(26)
  JVRP(68) = V(70)
! JVRP(69) = dARP(46)/dV(70)
  JVRP(69) = V(26)
! JVRP(70) = dARP(47)/dV(69)
  JVRP(70) = V(70)
! JVRP(71) = dARP(47)/dV(70)
  JVRP(71) = V(69)
! JVRP(72) = dARP(48)/dV(7)
  JVRP(72) = V(70)
! JVRP(73) = dARP(48)/dV(70)
  JVRP(73) = V(7)
! JVRP(74) = dARP(49)/dV(36)
  JVRP(74) = V(70)
! JVRP(75) = dARP(49)/dV(70)
  JVRP(75) = V(36)
! JVRP(76) = dARP(50)/dV(24)
  JVRP(76) = V(70)
! JVRP(77) = dARP(50)/dV(70)
  JVRP(77) = V(24)
! JVRP(78) = dARP(51)/dV(8)
  JVRP(78) = V(70)
! JVRP(79) = dARP(51)/dV(70)
  JVRP(79) = V(8)
! JVRP(80) = dARP(52)/dV(17)
  JVRP(80) = V(70)
! JVRP(81) = dARP(52)/dV(70)
  JVRP(81) = V(17)
! JVRP(82) = dARP(53)/dV(10)
  JVRP(82) = V(70)
! JVRP(83) = dARP(53)/dV(70)
  JVRP(83) = V(10)
! JVRP(84) = dARP(54)/dV(11)
  JVRP(84) = V(70)
! JVRP(85) = dARP(54)/dV(70)
  JVRP(85) = V(11)
! JVRP(86) = dARP(55)/dV(31)
  JVRP(86) = V(70)
! JVRP(87) = dARP(55)/dV(70)
  JVRP(87) = V(31)
! JVRP(88) = dARP(56)/dV(38)
  JVRP(88) = V(70)
! JVRP(89) = dARP(56)/dV(70)
  JVRP(89) = V(38)
! JVRP(90) = dARP(57)/dV(63)
  JVRP(90) = V(70)
! JVRP(91) = dARP(57)/dV(70)
  JVRP(91) = V(63)
! JVRP(92) = dARP(58)/dV(12)
  JVRP(92) = V(70)
! JVRP(93) = dARP(58)/dV(70)
  JVRP(93) = V(12)
! JVRP(94) = dARP(59)/dV(13)
  JVRP(94) = V(70)
! JVRP(95) = dARP(59)/dV(70)
  JVRP(95) = V(13)
! JVRP(96) = dARP(60)/dV(25)
  JVRP(96) = V(70)
! JVRP(97) = dARP(60)/dV(70)
  JVRP(97) = V(25)
! JVRP(98) = dARP(61)/dV(58)
  JVRP(98) = V(70)
! JVRP(99) = dARP(61)/dV(70)
  JVRP(99) = V(58)
! JVRP(100) = dARP(62)/dV(65)
  JVRP(100) = V(70)
! JVRP(101) = dARP(62)/dV(70)
  JVRP(101) = V(65)
! JVRP(102) = dARP(63)/dV(49)
  JVRP(102) = V(70)
! JVRP(103) = dARP(63)/dV(70)
  JVRP(103) = V(49)
! JVRP(104) = dARP(64)/dV(42)
  JVRP(104) = V(70)
! JVRP(105) = dARP(64)/dV(70)
  JVRP(105) = V(42)
! JVRP(106) = dARP(65)/dV(57)
  JVRP(106) = V(70)
! JVRP(107) = dARP(65)/dV(70)
  JVRP(107) = V(57)
! JVRP(108) = dARP(66)/dV(45)
  JVRP(108) = V(70)
! JVRP(109) = dARP(66)/dV(70)
  JVRP(109) = V(45)
! JVRP(110) = dARP(67)/dV(22)
  JVRP(110) = V(70)
! JVRP(111) = dARP(67)/dV(70)
  JVRP(111) = V(22)
! JVRP(112) = dARP(68)/dV(54)
  JVRP(112) = V(70)
! JVRP(113) = dARP(68)/dV(70)
  JVRP(113) = V(54)
! JVRP(114) = dARP(69)/dV(21)
  JVRP(114) = V(70)
! JVRP(115) = dARP(69)/dV(70)
  JVRP(115) = V(21)
! JVRP(116) = dARP(70)/dV(28)
  JVRP(116) = V(70)
! JVRP(117) = dARP(70)/dV(70)
  JVRP(117) = V(28)
! JVRP(118) = dARP(71)/dV(70)
  JVRP(118) = V(75)
! JVRP(119) = dARP(71)/dV(75)
  JVRP(119) = V(70)
! JVRP(120) = dARP(72)/dV(39)
  JVRP(120) = V(70)
! JVRP(121) = dARP(72)/dV(70)
  JVRP(121) = V(39)
! JVRP(122) = dARP(73)/dV(68)
  JVRP(122) = V(72)
! JVRP(123) = dARP(73)/dV(72)
  JVRP(123) = V(68)
! JVRP(124) = dARP(74)/dV(28)
  JVRP(124) = 1
! JVRP(125) = dARP(75)/dV(59)
  JVRP(125) = V(72)
! JVRP(126) = dARP(75)/dV(72)
  JVRP(126) = V(59)
! JVRP(127) = dARP(76)/dV(14)
  JVRP(127) = 1
! JVRP(128) = dARP(77)/dV(67)
  JVRP(128) = V(73)
! JVRP(129) = dARP(77)/dV(73)
  JVRP(129) = V(67)
! JVRP(130) = dARP(78)/dV(73)
  JVRP(130) = V(76)
! JVRP(131) = dARP(78)/dV(76)
  JVRP(131) = V(73)
! JVRP(132) = dARP(79)/dV(46)
  JVRP(132) = V(73)
! JVRP(133) = dARP(79)/dV(73)
  JVRP(133) = V(46)
! JVRP(134) = dARP(80)/dV(47)
  JVRP(134) = V(73)
! JVRP(135) = dARP(80)/dV(73)
  JVRP(135) = V(47)
! JVRP(136) = dARP(81)/dV(50)
  JVRP(136) = V(73)
! JVRP(137) = dARP(81)/dV(73)
  JVRP(137) = V(50)
! JVRP(138) = dARP(82)/dV(51)
  JVRP(138) = V(73)
! JVRP(139) = dARP(82)/dV(73)
  JVRP(139) = V(51)
! JVRP(140) = dARP(83)/dV(48)
  JVRP(140) = V(73)
! JVRP(141) = dARP(83)/dV(73)
  JVRP(141) = V(48)
! JVRP(142) = dARP(84)/dV(68)
  JVRP(142) = V(73)
! JVRP(143) = dARP(84)/dV(73)
  JVRP(143) = V(68)
! JVRP(144) = dARP(85)/dV(59)
  JVRP(144) = V(73)
! JVRP(145) = dARP(85)/dV(73)
  JVRP(145) = V(59)
! JVRP(146) = dARP(86)/dV(53)
  JVRP(146) = V(73)
! JVRP(147) = dARP(86)/dV(73)
  JVRP(147) = V(53)
! JVRP(148) = dARP(87)/dV(43)
  JVRP(148) = V(73)
! JVRP(149) = dARP(87)/dV(73)
  JVRP(149) = V(43)
! JVRP(150) = dARP(88)/dV(66)
  JVRP(150) = V(73)
! JVRP(151) = dARP(88)/dV(73)
  JVRP(151) = V(66)
! JVRP(152) = dARP(89)/dV(64)
  JVRP(152) = V(73)
! JVRP(153) = dARP(89)/dV(73)
  JVRP(153) = V(64)
! JVRP(154) = dARP(90)/dV(56)
  JVRP(154) = V(73)
! JVRP(155) = dARP(90)/dV(73)
  JVRP(155) = V(56)
! JVRP(156) = dARP(91)/dV(58)
  JVRP(156) = V(71)
! JVRP(157) = dARP(91)/dV(71)
  JVRP(157) = V(58)
! JVRP(158) = dARP(92)/dV(65)
  JVRP(158) = V(71)
! JVRP(159) = dARP(92)/dV(71)
  JVRP(159) = V(65)
! JVRP(160) = dARP(93)/dV(42)
  JVRP(160) = V(71)
! JVRP(161) = dARP(93)/dV(71)
  JVRP(161) = V(42)
! JVRP(162) = dARP(94)/dV(57)
  JVRP(162) = V(71)
! JVRP(163) = dARP(94)/dV(71)
  JVRP(163) = V(57)
! JVRP(164) = dARP(95)/dV(45)
  JVRP(164) = V(71)
! JVRP(165) = dARP(95)/dV(71)
  JVRP(165) = V(45)
! JVRP(166) = dARP(96)/dV(25)
  JVRP(166) = V(71)
! JVRP(167) = dARP(96)/dV(71)
  JVRP(167) = V(25)
! JVRP(168) = dARP(97)/dV(31)
  JVRP(168) = V(71)
! JVRP(169) = dARP(97)/dV(71)
  JVRP(169) = V(31)
! JVRP(170) = dARP(98)/dV(38)
  JVRP(170) = V(71)
! JVRP(171) = dARP(98)/dV(71)
  JVRP(171) = V(38)
! JVRP(172) = dARP(99)/dV(63)
  JVRP(172) = V(71)
! JVRP(173) = dARP(99)/dV(71)
  JVRP(173) = V(63)
! JVRP(174) = dARP(100)/dV(39)
  JVRP(174) = V(71)
! JVRP(175) = dARP(100)/dV(71)
  JVRP(175) = V(39)
! JVRP(176) = dARP(101)/dV(31)
  JVRP(176) = V(74)
! JVRP(177) = dARP(101)/dV(74)
  JVRP(177) = V(31)
! JVRP(178) = dARP(102)/dV(38)
  JVRP(178) = V(74)
! JVRP(179) = dARP(102)/dV(74)
  JVRP(179) = V(38)
! JVRP(180) = dARP(103)/dV(63)
  JVRP(180) = V(74)
! JVRP(181) = dARP(103)/dV(74)
  JVRP(181) = V(63)
! JVRP(182) = dARP(104)/dV(39)
  JVRP(182) = V(74)
! JVRP(183) = dARP(104)/dV(74)
  JVRP(183) = V(39)
! JVRP(184) = dARP(105)/dV(67)
  JVRP(184) = V(69)
! JVRP(185) = dARP(105)/dV(69)
  JVRP(185) = V(67)
! JVRP(186) = dARP(106)/dV(66)
  JVRP(186) = V(69)
! JVRP(187) = dARP(106)/dV(69)
  JVRP(187) = V(66)
! JVRP(188) = dARP(107)/dV(69)
  JVRP(188) = V(76)
! JVRP(189) = dARP(107)/dV(76)
  JVRP(189) = V(69)
! JVRP(190) = dARP(108)/dV(46)
  JVRP(190) = V(69)
! JVRP(191) = dARP(108)/dV(69)
  JVRP(191) = V(46)
! JVRP(192) = dARP(109)/dV(47)
  JVRP(192) = V(69)
! JVRP(193) = dARP(109)/dV(69)
  JVRP(193) = V(47)
! JVRP(194) = dARP(110)/dV(50)
  JVRP(194) = V(69)
! JVRP(195) = dARP(110)/dV(69)
  JVRP(195) = V(50)
! JVRP(196) = dARP(111)/dV(51)
  JVRP(196) = V(69)
! JVRP(197) = dARP(111)/dV(69)
  JVRP(197) = V(51)
! JVRP(198) = dARP(112)/dV(48)
  JVRP(198) = V(69)
! JVRP(199) = dARP(112)/dV(69)
  JVRP(199) = V(48)
! JVRP(200) = dARP(113)/dV(64)
  JVRP(200) = V(69)
! JVRP(201) = dARP(113)/dV(69)
  JVRP(201) = V(64)
! JVRP(202) = dARP(114)/dV(68)
  JVRP(202) = V(69)
! JVRP(203) = dARP(114)/dV(69)
  JVRP(203) = V(68)
! JVRP(204) = dARP(115)/dV(53)
  JVRP(204) = V(69)
! JVRP(205) = dARP(115)/dV(69)
  JVRP(205) = V(53)
! JVRP(206) = dARP(116)/dV(43)
  JVRP(206) = V(69)
! JVRP(207) = dARP(116)/dV(69)
  JVRP(207) = V(43)
! JVRP(208) = dARP(117)/dV(59)
  JVRP(208) = V(69)
! JVRP(209) = dARP(117)/dV(69)
  JVRP(209) = V(59)
! JVRP(210) = dARP(118)/dV(56)
  JVRP(210) = V(69)
! JVRP(211) = dARP(118)/dV(69)
  JVRP(211) = V(56)
! JVRP(212) = dARP(119)/dV(67)
  JVRP(212) = 2*V(67)
! JVRP(213) = dARP(120)/dV(66)
  JVRP(213) = V(67)
! JVRP(214) = dARP(120)/dV(67)
  JVRP(214) = V(66)
! JVRP(215) = dARP(121)/dV(67)
  JVRP(215) = V(76)
! JVRP(216) = dARP(121)/dV(76)
  JVRP(216) = V(67)
! JVRP(217) = dARP(122)/dV(46)
  JVRP(217) = V(67)
! JVRP(218) = dARP(122)/dV(67)
  JVRP(218) = V(46)
! JVRP(219) = dARP(123)/dV(47)
  JVRP(219) = V(67)
! JVRP(220) = dARP(123)/dV(67)
  JVRP(220) = V(47)
! JVRP(221) = dARP(124)/dV(50)
  JVRP(221) = V(67)
! JVRP(222) = dARP(124)/dV(67)
  JVRP(222) = V(50)
! JVRP(223) = dARP(125)/dV(51)
  JVRP(223) = V(67)
! JVRP(224) = dARP(125)/dV(67)
  JVRP(224) = V(51)
! JVRP(225) = dARP(126)/dV(48)
  JVRP(225) = V(67)
! JVRP(226) = dARP(126)/dV(67)
  JVRP(226) = V(48)
! JVRP(227) = dARP(127)/dV(64)
  JVRP(227) = V(67)
! JVRP(228) = dARP(127)/dV(67)
  JVRP(228) = V(64)
! JVRP(229) = dARP(128)/dV(67)
  JVRP(229) = V(68)
! JVRP(230) = dARP(128)/dV(68)
  JVRP(230) = V(67)
! JVRP(231) = dARP(129)/dV(53)
  JVRP(231) = V(67)
! JVRP(232) = dARP(129)/dV(67)
  JVRP(232) = V(53)
! JVRP(233) = dARP(130)/dV(43)
  JVRP(233) = V(67)
! JVRP(234) = dARP(130)/dV(67)
  JVRP(234) = V(43)
! JVRP(235) = dARP(131)/dV(59)
  JVRP(235) = V(67)
! JVRP(236) = dARP(131)/dV(67)
  JVRP(236) = V(59)
! JVRP(237) = dARP(132)/dV(66)
  JVRP(237) = V(68)
! JVRP(238) = dARP(132)/dV(68)
  JVRP(238) = V(66)
! JVRP(239) = dARP(133)/dV(68)
  JVRP(239) = V(76)
! JVRP(240) = dARP(133)/dV(76)
  JVRP(240) = V(68)
! JVRP(241) = dARP(134)/dV(46)
  JVRP(241) = V(68)
! JVRP(242) = dARP(134)/dV(68)
  JVRP(242) = V(46)
! JVRP(243) = dARP(135)/dV(47)
  JVRP(243) = V(68)
! JVRP(244) = dARP(135)/dV(68)
  JVRP(244) = V(47)
! JVRP(245) = dARP(136)/dV(50)
  JVRP(245) = V(68)
! JVRP(246) = dARP(136)/dV(68)
  JVRP(246) = V(50)
! JVRP(247) = dARP(137)/dV(51)
  JVRP(247) = V(68)
! JVRP(248) = dARP(137)/dV(68)
  JVRP(248) = V(51)
! JVRP(249) = dARP(138)/dV(48)
  JVRP(249) = V(68)
! JVRP(250) = dARP(138)/dV(68)
  JVRP(250) = V(48)
! JVRP(251) = dARP(139)/dV(64)
  JVRP(251) = V(68)
! JVRP(252) = dARP(139)/dV(68)
  JVRP(252) = V(64)
! JVRP(253) = dARP(140)/dV(68)
  JVRP(253) = 2*V(68)
! JVRP(254) = dARP(141)/dV(53)
  JVRP(254) = V(68)
! JVRP(255) = dARP(141)/dV(68)
  JVRP(255) = V(53)
! JVRP(256) = dARP(142)/dV(43)
  JVRP(256) = V(68)
! JVRP(257) = dARP(142)/dV(68)
  JVRP(257) = V(43)
! JVRP(258) = dARP(143)/dV(59)
  JVRP(258) = V(68)
! JVRP(259) = dARP(143)/dV(68)
  JVRP(259) = V(59)
! JVRP(260) = dARP(144)/dV(52)
  JVRP(260) = V(69)
! JVRP(261) = dARP(144)/dV(69)
  JVRP(261) = V(52)
! JVRP(262) = dARP(145)/dV(52)
  JVRP(262) = V(67)
! JVRP(263) = dARP(145)/dV(67)
  JVRP(263) = V(52)
! JVRP(264) = dARP(146)/dV(52)
  JVRP(264) = V(68)
! JVRP(265) = dARP(146)/dV(68)
  JVRP(265) = V(52)
! JVRP(266) = dARP(147)/dV(52)
  JVRP(266) = V(73)
! JVRP(267) = dARP(147)/dV(73)
  JVRP(267) = V(52)
! JVRP(268) = dARP(148)/dV(41)
  JVRP(268) = V(72)
! JVRP(269) = dARP(148)/dV(72)
  JVRP(269) = V(41)
! JVRP(270) = dARP(149)/dV(41)
  JVRP(270) = V(69)
! JVRP(271) = dARP(149)/dV(69)
  JVRP(271) = V(41)
! JVRP(272) = dARP(150)/dV(41)
  JVRP(272) = V(67)
! JVRP(273) = dARP(150)/dV(67)
  JVRP(273) = V(41)
! JVRP(274) = dARP(151)/dV(41)
  JVRP(274) = V(68)
! JVRP(275) = dARP(151)/dV(68)
  JVRP(275) = V(41)
! JVRP(276) = dARP(152)/dV(56)
  JVRP(276) = V(67)
! JVRP(277) = dARP(152)/dV(67)
  JVRP(277) = V(56)
! JVRP(278) = dARP(153)/dV(56)
  JVRP(278) = V(68)
! JVRP(279) = dARP(153)/dV(68)
  JVRP(279) = V(56)
! JVRP(280) = dARP(154)/dV(56)
  JVRP(280) = 2*V(56)
! JVRP(281) = dARP(155)/dV(35)
  JVRP(281) = V(70)
! JVRP(282) = dARP(155)/dV(70)
  JVRP(282) = V(35)
! JVRP(283) = dARP(156)/dV(35)
  JVRP(283) = V(71)
! JVRP(284) = dARP(156)/dV(71)
  JVRP(284) = V(35)
! JVRP(285) = dARP(157)/dV(35)
  JVRP(285) = V(74)
! JVRP(286) = dARP(157)/dV(74)
  JVRP(286) = V(35)
! JVRP(287) = dARP(158)/dV(60)
  JVRP(287) = V(73)
! JVRP(288) = dARP(158)/dV(73)
  JVRP(288) = V(60)
! JVRP(289) = dARP(159)/dV(60)
  JVRP(289) = V(69)
! JVRP(290) = dARP(159)/dV(69)
  JVRP(290) = V(60)
! JVRP(291) = dARP(160)/dV(60)
  JVRP(291) = V(67)
! JVRP(292) = dARP(160)/dV(67)
  JVRP(292) = V(60)
! JVRP(293) = dARP(161)/dV(60)
  JVRP(293) = V(68)
! JVRP(294) = dARP(161)/dV(68)
  JVRP(294) = V(60)
! JVRP(295) = dARP(162)/dV(60)
  JVRP(295) = V(71)
! JVRP(296) = dARP(162)/dV(71)
  JVRP(296) = V(60)
! JVRP(297) = dARP(163)/dV(37)
  JVRP(297) = V(70)
! JVRP(298) = dARP(163)/dV(70)
  JVRP(298) = V(37)
! JVRP(299) = dARP(164)/dV(37)
  JVRP(299) = V(71)
! JVRP(300) = dARP(164)/dV(71)
  JVRP(300) = V(37)
! JVRP(301) = dARP(165)/dV(37)
  JVRP(301) = V(74)
! JVRP(302) = dARP(165)/dV(74)
  JVRP(302) = V(37)
! JVRP(303) = dARP(166)/dV(62)
  JVRP(303) = V(73)
! JVRP(304) = dARP(166)/dV(73)
  JVRP(304) = V(62)
! JVRP(305) = dARP(167)/dV(62)
  JVRP(305) = V(69)
! JVRP(306) = dARP(167)/dV(69)
  JVRP(306) = V(62)
! JVRP(307) = dARP(168)/dV(62)
  JVRP(307) = V(67)
! JVRP(308) = dARP(168)/dV(67)
  JVRP(308) = V(62)
! JVRP(309) = dARP(169)/dV(62)
  JVRP(309) = V(68)
! JVRP(310) = dARP(169)/dV(68)
  JVRP(310) = V(62)
! JVRP(311) = dARP(170)/dV(62)
  JVRP(311) = V(71)
! JVRP(312) = dARP(170)/dV(71)
  JVRP(312) = V(62)
! JVRP(313) = dARP(171)/dV(32)
  JVRP(313) = V(73)
! JVRP(314) = dARP(171)/dV(73)
  JVRP(314) = V(32)
! JVRP(315) = dARP(172)/dV(32)
  JVRP(315) = V(69)
! JVRP(316) = dARP(172)/dV(69)
  JVRP(316) = V(32)
! JVRP(317) = dARP(173)/dV(32)
  JVRP(317) = 2*V(32)
! JVRP(318) = dARP(174)/dV(9)
  JVRP(318) = V(70)
! JVRP(319) = dARP(174)/dV(70)
  JVRP(319) = V(9)
! JVRP(320) = dARP(175)/dV(33)
  JVRP(320) = V(70)
! JVRP(321) = dARP(175)/dV(70)
  JVRP(321) = V(33)
! JVRP(322) = dARP(176)/dV(44)
  JVRP(322) = V(70)
! JVRP(323) = dARP(176)/dV(70)
  JVRP(323) = V(44)
! JVRP(324) = dARP(177)/dV(44)
  JVRP(324) = V(74)
! JVRP(325) = dARP(177)/dV(74)
  JVRP(325) = V(44)
! JVRP(326) = dARP(178)/dV(55)
  JVRP(326) = V(73)
! JVRP(327) = dARP(178)/dV(73)
  JVRP(327) = V(55)
! JVRP(328) = dARP(179)/dV(55)
  JVRP(328) = V(69)
! JVRP(329) = dARP(179)/dV(69)
  JVRP(329) = V(55)
! JVRP(330) = dARP(180)/dV(55)
  JVRP(330) = 2*V(55)
! JVRP(331) = dARP(181)/dV(55)
  JVRP(331) = V(72)
! JVRP(332) = dARP(181)/dV(72)
  JVRP(332) = V(55)
! JVRP(333) = dARP(182)/dV(23)
  JVRP(333) = 1
! JVRP(334) = dARP(183)/dV(23)
  JVRP(334) = V(70)
! JVRP(335) = dARP(183)/dV(70)
  JVRP(335) = V(23)
! JVRP(336) = dARP(184)/dV(16)
  JVRP(336) = V(70)
! JVRP(337) = dARP(184)/dV(70)
  JVRP(337) = V(16)
! JVRP(338) = dARP(185)/dV(27)
  JVRP(338) = V(70)
! JVRP(339) = dARP(185)/dV(70)
  JVRP(339) = V(27)
! JVRP(340) = dARP(186)/dV(18)
  JVRP(340) = V(70)
! JVRP(341) = dARP(186)/dV(70)
  JVRP(341) = V(18)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE RADMKA_Parameters
      USE RADMKA_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE RADMKA_Parameters
      USE RADMKA_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE RADMKA_Stoichiom

