! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADMKA_Rates.f90
! Time                 : Thu Oct  8 08:22:34 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADMKA_16038_BOXMOX
! Equation file        : RADMKA.kpp
! Output root filename : RADMKA
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADMKA_Rates

  USE RADMKA_Parameters
  USE RADMKA_Global
  USE RADMKA_Util
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
!   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
!      REAL A0,B0,C0
!      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
!   END FUNCTION ARR

! Arrhenius (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION ARR( A0,B0,C0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0,C0
      ARR =  A0 * EXP( -B0 /TEMP ) * (TEMP/300._dp)**C0
    END FUNCTION ARR

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
!   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
!      REAL A0,B0
!      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )
!   END FUNCTION ARR2
! CK 20140313 WRF-chem uses different kind of Arrhenius function
!             with TEMP as argument...
   REAL(kind=dp) FUNCTION ARR2( A0,B0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0
      ARR2 = A0 * EXP( -B0 /TEMP )
   END FUNCTION ARR2
! CK 20140313 end

!   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
!      REAL A0,C0,A2,C2,A3,C3
!      REAL(kind=dp) K0,K2,K3
!      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
!      K3 = K3*CFACTOR*1.0E6_dp
!      EP2 = K0 + K3/(1.0_dp+K3/K2 )
!   END FUNCTION EP2

!   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2)
!      REAL A1, C1, A2, C2
!      REAL(kind=dp) K1, K2
!      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
!   END FUNCTION EP3

! EP2 (added by psaide 22-07-2009)
   REAL(kind=dp) FUNCTION EP2( A0,C0,A2,C2,A3,C3,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3

      K0 = A0 * EXP(-C0 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
      K3 = A3 * EXP(-C3 /TEMP)
!      K3 = K3 * 2.45E13_dp * 1.0E6_dp
      K3 = K3 * cair
      EP2 = K0 + K3/(1._dp+K3/K2 )
   END FUNCTION EP2

! EP3 (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A1, C1, A2, C2
      REAL(kind=dp) K1, K2

      K1 = A1 * EXP(-C1 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
!      EP3 = K1 + K2*(1.0E6_dp * 2.45E13_dp)
      EP3 = K1 + K2*cair
    END FUNCTION EP3


!   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
!      REAL A0,B0,C0,A1,B1,C1,CF
!      REAL(kind=dp) K0, K1
!      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
!      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
!      K0 = K0*CFACTOR*1.0E6_dp
!      K1 = K0/K1
!      FALL = (K0/(1.0_dp+K1))*   &
!           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
!   END FUNCTION FALL

! FALL (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION FALL( A0,B0,C0,A1,B1,C1,CF,TEMP,cair)

      INTRINSIC LOG10

      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      FALL = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1))**2))

    END FUNCTION FALL

! FALL2 (added by psaide 28-10-2009)
    REAL(KIND=dp) FUNCTION F2( A0,B0,C0,A1,B1,C1,CF,CN,TEMP,cair)

      INTRINSIC LOG10

      REAL(KIND=dp) :: TEMP
      REAL(KIND=dp) :: cair
      REAL(KIND=dp) A0,B0,C0,A1,B1,C1,CF,CN
      REAL(KIND=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      F2 = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1)/CN)**2))

    END FUNCTION F2


  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

! CK 20140313 in the following some more rate functions needed by
!             WRF-chem packages

!------------------------------------
! Troe reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROE(k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),          INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),          INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    TROE   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

   END FUNCTION TROE



!-------------------------------------------
! Troe equilibrium reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROEE(A, B, k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp),     INTENT(IN) :: A, B
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio, troe


    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    troe   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

    TROEE = A * EXP( - B / temp) * troe



  END FUNCTION TROEE

!------------------------
! k=T^2 C exp (-D/T) reactions

   REAL(kind=dp) FUNCTION THERMAL_T2(c, d ,temp)
    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp),     INTENT(IN) :: c, d


     THERMAL_T2= temp**2._dp * c * EXP(- d  / temp)

   END FUNCTION THERMAL_T2

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions



! ****************************************************************************
! J - the photolysis rate retrieval function
! ****************************************************************************
      REAL(kind=dp) FUNCTION J(name)

      CHARACTER(LEN=*), INTENT(IN)     :: name

      CHARACTER(LEN=15) :: xname

      INTEGER                          :: i

      xname(:)           = " "
      xname(1:LEN(name)) = name

      J                  = jvalues(hash(xname))

      RETURN

      END FUNCTION J
! ****************************************************************************



!C
!C*********************************************************************
!C Die Funktion TROE bestimmt die Werte der Troefunktion
!C nach Stockwell et al. [2],
!C die die Druckabhaengigkeit von Reaktionskonstanten durch eine
!C quasi-bimolekulare Reaktionskonstante beschreibt.
!C*********************************************************************
!C
!
!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
! EMPA, original KPP style
   REAL FUNCTION ARR2E( A0,B0 )
      REAL(dp) A0,B0
      ARR2E =  DBLE(A0) * EXP( DBLE(B0)/TEMP )
   END FUNCTION ARR2E
!
REAL FUNCTION TROE_EMPA( K0300, Q, KU300, R, M, T )
!C CALCULATION OF RATE CONSTANTS FOR TROE REACTIONS
!      IMPLICIT REAL(dp) (A-Z)
      REAL(dp) :: K0300, Q, KU300, R, M, T
      REAL(dp) :: tt, k0, ku, k0m, kk, lgkk, e, f
      TT= T / 3.D2
      K0= K0300 / TT**Q
      KU= KU300 / TT**R
      K0M= K0 * M
      KK= K0M / KU
      LGKK=0.434294481D0 * LOG(KK)
      E=1.D0 / ( 1.D0 + LGKK*LGKK )
      F=0.6D0 ** E
      TROE_EMPA= F * K0M / ( 1.D0 + KK )
END FUNCTION TROE_EMPA
!C
!C**********************************************************************
!C Die Funktion EQT [2] bestimmt die Reaktionskonstanten fuer
!C HNO4 --> H2O + NO2 und N2O5 --> NO2 + NO3
!C**********************************************************************
!C
FUNCTION EQT( K0300, Q, KU300, R, M, T, A, B )
      !IMPLICIT REAL(dp) (A-Z)
      REAL(dp) :: K0300, Q, KU300, R, M, T, A, B, EQT
      REAL(dp) :: kh
      KH= TROE_EMPA( K0300, Q, KU300, R, M, T )
      EQT= KH * A *DEXP( -B / T )
END FUNCTION EQT
!C
!C**********************************************************************
!C Die Funktion SPEZ bestimmt die Reaktionskonstante fuer
!C HNO3 + HO --> H2O + NO3
!C**********************************************************************
!C
FUNCTION SPEZ(A0,B0,A2,B2,A3,B3,M,T)
!C SPECIAL RATE CONSTANTS
      !IMPLICIT REAL(dp) (A-Z)
      REAL(dp) :: A0,B0,A2,B2,A3,B3,M,T, SPEZ
      REAL(dp) :: k0, k2, k3
      K0=A0*DEXP(B0/T)
      K2=A2*DEXP(B2/T)
      K3=A3*M*DEXP(B3/T)
      SPEZ= K0 + K3 / ( 1D0 + K3/K2 )
END FUNCTION SPEZ


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE RADMKA_Parameters
      !USE RADMKA_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


! End INLINED RCONST

  RCONST(1) = (j('no2'))
  RCONST(2) = (j('o31d'))
  RCONST(3) = (j('o33p'))
  RCONST(4) = (j('hno2'))
  RCONST(5) = (j('hno3'))
  RCONST(6) = (j('hno4')+EQT(1.8D-31,3.2_dp,4.7D-12,1.4_dp,C_M,TEMP,4.76D+26,10900._dp))
  RCONST(7) = (j('no3o2'))
  RCONST(8) = (j('no3o'))
  RCONST(9) = (j('h2o2'))
  RCONST(10) = (j('ch2om'))
  RCONST(11) = (j('ch2or'))
  RCONST(12) = (j('ch3cho'))
  RCONST(13) = (j('ch3o2h'))
  RCONST(14) = (j('ch3coch3'))
  RCONST(15) = (j('ch3coo2h'))
  RCONST(16) = (j('ch3coc2h5'))
  RCONST(17) = (j('hcocho'))
  RCONST(18) = (j('hcochob'))
  RCONST(19) = (j('ch3cocho'))
  RCONST(20) = (j('hcochest'))
  RCONST(21) = (j('ch3ono2'))
  RCONST(22) = (C_M*6.0D-34*(TEMP/300._dp)**(-2.3_dp))
  RCONST(23) = (6.50D-12*EXP(120._dp/TEMP))
  RCONST(24) = (2.00D-11*EXP(130._dp/TEMP))
  RCONST(25) = (3.20D-11*EXP(67._dp/TEMP))
  RCONST(26) = (2.14D-10)
  RCONST(27) = (1.4D-12*EXP(-1310._dp/TEMP))
  RCONST(28) = (1.70D-12*EXP(-940._dp/TEMP))
  RCONST(29) = (1.10D-14*EXP(-500._dp/TEMP))
  RCONST(30) = (3.45D-12*EXP(270._dp/TEMP))
  RCONST(31) = (TROE_EMPA(1.8D-31,3.2_dp,4.7D-12,1.4_dp,C_M,TEMP))
  RCONST(32) = (2.2D-13*EXP(620._dp/TEMP)+1.9D-33*C_M*EXP(980._dp/TEMP))
  RCONST(33) = (3.08D-34*EXP(2820._dp/TEMP)+2.66D-54*C_M*EXP(3180._dp/TEMP))
  RCONST(34) = (3.30D-12*EXP(-200._dp/TEMP))
  RCONST(35) = (TROE_EMPA(7.0D-31,2.6_dp,1.5D-11,0.5_dp,C_M,TEMP))
  RCONST(36) = (3.30D-39*EXP(530._dp/TEMP))
  RCONST(37) = (1.40D-13*EXP(-2470._dp/TEMP))
  RCONST(38) = (1.80D-11*EXP(110._dp/TEMP))
  RCONST(39) = (2.50D-14*EXP(-1230._dp/TEMP))
  RCONST(40) = (2.50D-12)
  RCONST(41) = (TROE_EMPA(2.2D-30,4.3_dp,1.5D-12,0.5_dp,C_M,TEMP))
  RCONST(42) = (EQT(2.2D-30,4.3_dp,1.5D-12,0.5_dp,C_M,TEMP,9.09D+26,11200._dp))
  RCONST(43) = (HET(1))
  RCONST(44) = (TROE_EMPA(2.6D-30,3.2_dp,2.4D-11,1.3_dp,C_M,TEMP))
  RCONST(45) = (SPEZ(7.2D-15,785._dp,4.1D-16,1440._dp,1.9D-33,725._dp,C_M,TEMP))
  RCONST(46) = (1.30D-12*EXP(380._dp/TEMP))
  RCONST(47) = (4.80D-11*EXP(250._dp/TEMP))
  RCONST(48) = (TROE_EMPA(3.0D-31,3.3_dp,1.5D-12,0.0_dp,C_M,TEMP))
  RCONST(49) = (1.5D-13*(1.0_dp+2.439D-20*C_M))
  RCONST(50) = (TEMP*TEMP*6.95D-18*EXP(-1280._dp/TEMP))
  RCONST(51) = (TEMP*TEMP*1.37D-17*EXP(-444._dp/TEMP))
  RCONST(52) = (1.59D-11*EXP(-540._dp/TEMP))
  RCONST(53) = (1.73D-11*EXP(-380._dp/TEMP))
  RCONST(54) = (3.64D-11*EXP(-380._dp/TEMP))
  RCONST(55) = (2.15D-12*EXP(411._dp/TEMP))
  RCONST(56) = (5.32D-12*EXP(504._dp/TEMP))
  RCONST(57) = (1.07D-11*EXP(549._dp/TEMP))
  RCONST(58) = (2.10D-12*EXP(322._dp/TEMP))
  RCONST(59) = (1.89D-11*EXP(116._dp/TEMP))
  RCONST(60) = (4.00D-11)
  RCONST(61) = (9.00D-12)
  RCONST(62) = (6.87D-12*EXP(256._dp/TEMP))
  RCONST(63) = (1.20D-11*EXP(-745._dp/TEMP))
  RCONST(64) = (1.15D-11)
  RCONST(65) = (1.70D-11)
  RCONST(66) = (2.8D-11)
  RCONST(67) = (1.00D-11)
  RCONST(68) = (1.00D-11)
  RCONST(69) = (1.00D-11)
  RCONST(70) = (TEMP*TEMP*6.85D-18*EXP(-444._dp/TEMP))
  RCONST(71) = (1.55D-11*EXP(-540._dp/TEMP))
  RCONST(72) = (2.55D-11*EXP(409._dp/TEMP))
  RCONST(73) = (2.6D-12*EXP(380._dp/TEMP))
  RCONST(74) = (2.D16*EXP(-13500._dp/TEMP))
  RCONST(75) = (4.7D-12)
  RCONST(76) = (1.95D16*EXP(-13543._dp/TEMP))
  RCONST(77) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(78) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(79) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(80) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(81) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(82) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(83) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(84) = (3.50D-11*EXP(-180./TEMP))
  RCONST(85) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(86) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(87) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(88) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(89) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(90) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(91) = (6.00D-13*EXP(-2058._dp/TEMP))
  RCONST(92) = (1.40D-12*EXP(-1900._dp/TEMP))
  RCONST(93) = (6.00D-13*EXP(-2058._dp/TEMP))
  RCONST(94) = (1.40D-12*EXP(-1900._dp/TEMP))
  RCONST(95) = (1.40D-12*EXP(-1900._dp/TEMP))
  RCONST(96) = (2.20D-11)
  RCONST(97) = (2.00D-12*EXP(-2923._dp/TEMP))
  RCONST(98) = (1.00D-11*EXP(-1895._dp/TEMP))
  RCONST(99) = (3.23D-11*EXP(-975._dp/TEMP))
  RCONST(100) = (5.81D-13)
  RCONST(101) = (1.20D-14*EXP(-2633._dp/TEMP))
  RCONST(102) = (1.32D-14*EXP(-2105._dp/TEMP))
  RCONST(103) = (7.29D-15*EXP(-1136._dp/TEMP))
  RCONST(104) = (1.23D-14*EXP(-2013._dp/TEMP))
  RCONST(105) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(106) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(107) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(108) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(109) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(110) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(111) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(112) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(113) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(114) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(115) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(116) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(117) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(118) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(119) = (1.90D-13*EXP(220._dp/TEMP))
  RCONST(120) = (1.40D-13*EXP(220._dp/TEMP))
  RCONST(121) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(122) = (3.40D-14*EXP(220._dp/TEMP))
  RCONST(123) = (2.90D-14*EXP(220._dp/TEMP))
  RCONST(124) = (1.40D-13*EXP(220._dp/TEMP))
  RCONST(125) = (1.40D-13*EXP(220._dp/TEMP))
  RCONST(126) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(127) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(128) = (9.60D-13*EXP(220._dp/TEMP))
  RCONST(129) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(130) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(131) = (9.60D-13*EXP(220._dp/TEMP))
  RCONST(132) = (3.40D-13*EXP(220._dp/TEMP))
  RCONST(133) = (1.00D-13*EXP(220._dp/TEMP))
  RCONST(134) = (8.40D-14*EXP(220._dp/TEMP))
  RCONST(135) = (7.20D-14*EXP(220._dp/TEMP))
  RCONST(136) = (3.40D-13*EXP(220._dp/TEMP))
  RCONST(137) = (3.40D-13*EXP(220._dp/TEMP))
  RCONST(138) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(139) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(140) = (1.19D-12*EXP(220._dp/TEMP))
  RCONST(141) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(142) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(143) = (1.19D-12*EXP(220._dp/TEMP))
  RCONST(144) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(145) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(146) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(147) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(148) = (4.20D-12*EXP(180._dp/TEMP))
  RCONST(149) = (7.70D-14*EXP(1300._dp/TEMP))
  RCONST(150) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(151) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(152) = (1.70D-14*EXP(220._dp/TEMP))
  RCONST(153) = (4.20D-14*EXP(220._dp/TEMP))
  RCONST(154) = (3.60D-16*EXP(220._dp/TEMP))
  RCONST(155) = (1.21D-11*EXP(444._dp/TEMP))
  RCONST(156) = (ARR2E(1.19D-12,490._dp))
  RCONST(157) = (ARR2E(1.01D-15,-736._dp))
  RCONST(158) = (4.00D-12)
  RCONST(159) = (1.50D-11)
  RCONST(160) = (ARR2E(3.56D-14,708._dp))
  RCONST(161) = (ARR2E(7.40D-13,765._dp))
  RCONST(162) = (1.20D-12)
  RCONST(163) = (1.70D-10)
  RCONST(164) = (1.22D-11)
  RCONST(165) = (2.00D-16)
  RCONST(166) = (4.00D-12)
  RCONST(167) = (1.50D-11)
  RCONST(168) = (ARR2E(3.56D-14,708._dp))
  RCONST(169) = (ARR2E(7.40D-13,765._dp))
  RCONST(170) = (1.20D-12)
  RCONST(171) = (ARR2E(2.43D-12,360._dp))
  RCONST(172) = (ARR2E(2.05D-13,1300._dp))
  RCONST(173) = (2.00D-12)
  RCONST(174) = (1.00D-10)
  RCONST(175) = (1.30D-11)
  RCONST(176) = (0.5_dp*(4.13D-12*EXP(452._dp/TEMP)+1.86D-11*EXP(175._dp/TEMP)))
  RCONST(177) = (0.5_dp*(1.36D-15*EXP(-2112._dp/TEMP)+7.51D-16*EXP(-1521._dp/TEMP)))
  RCONST(178) = (ARR2E(2.54D-12,360._dp))
  RCONST(179) = (ARR2E(1.82D-13,1300._dp))
  RCONST(180) = (2.00D-12)
  RCONST(181) = (TROE_EMPA(9.7D-29,-5.6_dp,9.3D-12,-1.5_dp,C_M,TEMP))
  RCONST(182) = (TROE_EMPA(9.7D-29,-5.6_dp,9.3D-12,-1.5_dp,C_M,TEMP)/(ARR2E(9.0D-19,14000._dp)))
  RCONST(183) = (3.60D-12)
  RCONST(184) = (3.00D-11)
  RCONST(185) = (3.00D-12)
  RCONST(186) = (ARR2E(5.60D-12,270._dp))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE RADMKA_Global

  RCONST(1) = (j('no2'))
  RCONST(2) = (j('o31d'))
  RCONST(3) = (j('o33p'))
  RCONST(4) = (j('hno2'))
  RCONST(5) = (j('hno3'))
  RCONST(6) = (j('hno4')+EQT(1.8D-31,3.2_dp,4.7D-12,1.4_dp,C_M,TEMP,4.76D+26,10900._dp))
  RCONST(7) = (j('no3o2'))
  RCONST(8) = (j('no3o'))
  RCONST(9) = (j('h2o2'))
  RCONST(10) = (j('ch2om'))
  RCONST(11) = (j('ch2or'))
  RCONST(12) = (j('ch3cho'))
  RCONST(13) = (j('ch3o2h'))
  RCONST(14) = (j('ch3coch3'))
  RCONST(15) = (j('ch3coo2h'))
  RCONST(16) = (j('ch3coc2h5'))
  RCONST(17) = (j('hcocho'))
  RCONST(18) = (j('hcochob'))
  RCONST(19) = (j('ch3cocho'))
  RCONST(20) = (j('hcochest'))
  RCONST(21) = (j('ch3ono2'))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADMKA_Rates

