! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADMKA_Jacobian.f90
! Time                 : Thu Oct  8 08:22:34 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADMKA_16038_BOXMOX
! Equation file        : RADMKA.kpp
! Output root filename : RADMKA
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADMKA_Jacobian

  USE RADMKA_Parameters
  USE RADMKA_JacobianSP

  USE RADMKA_Global

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(341)

! B(1) = dA(1)/dV(72)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(74)
  B(2) = RCT(2)
! B(3) = dA(3)/dV(74)
  B(3) = RCT(3)
! B(4) = dA(4)/dV(15)
  B(4) = RCT(4)
! B(5) = dA(5)/dV(40)
  B(5) = RCT(5)
! B(6) = dA(6)/dV(26)
  B(6) = RCT(6)
! B(7) = dA(7)/dV(71)
  B(7) = RCT(7)
! B(8) = dA(8)/dV(71)
  B(8) = RCT(8)
! B(9) = dA(9)/dV(30)
  B(9) = RCT(9)
! B(10) = dA(10)/dV(58)
  B(10) = RCT(10)
! B(11) = dA(11)/dV(58)
  B(11) = RCT(11)
! B(12) = dA(12)/dV(65)
  B(12) = RCT(12)
! B(13) = dA(13)/dV(22)
  B(13) = RCT(13)
! B(14) = dA(14)/dV(54)
  B(14) = RCT(14)
! B(15) = dA(15)/dV(21)
  B(15) = RCT(15)
! B(16) = dA(16)/dV(49)
  B(16) = RCT(16)
! B(17) = dA(17)/dV(42)
  B(17) = RCT(17)
! B(18) = dA(18)/dV(42)
  B(18) = RCT(18)
! B(19) = dA(19)/dV(57)
  B(19) = RCT(19)
! B(20) = dA(20)/dV(45)
  B(20) = RCT(20)
! B(21) = dA(21)/dV(75)
  B(21) = RCT(21)
! B(22) = dA(22)/dV(29)
  B(22) = RCT(22)*V(34)
! B(23) = dA(22)/dV(34)
  B(23) = RCT(22)*V(29)
! B(24) = dA(23)/dV(29)
  B(24) = RCT(23)*V(72)
! B(25) = dA(23)/dV(72)
  B(25) = RCT(23)*V(29)
! B(26) = dA(24)/dV(1)
  B(26) = RCT(24)*V(19)
! B(27) = dA(24)/dV(19)
  B(27) = RCT(24)*V(1)
! B(28) = dA(25)/dV(19)
  B(28) = RCT(25)*V(34)
! B(29) = dA(25)/dV(34)
  B(29) = RCT(25)*V(19)
! B(30) = dA(26)/dV(19)
  B(30) = RCT(26)*V(61)
! B(31) = dA(26)/dV(61)
  B(31) = RCT(26)*V(19)
! B(32) = dA(27)/dV(73)
  B(32) = RCT(27)*V(74)
! B(33) = dA(27)/dV(74)
  B(33) = RCT(27)*V(73)
! B(34) = dA(28)/dV(70)
  B(34) = RCT(28)*V(74)
! B(35) = dA(28)/dV(74)
  B(35) = RCT(28)*V(70)
! B(36) = dA(29)/dV(69)
  B(36) = RCT(29)*V(74)
! B(37) = dA(29)/dV(74)
  B(37) = RCT(29)*V(69)
! B(38) = dA(30)/dV(69)
  B(38) = RCT(30)*V(73)
! B(39) = dA(30)/dV(73)
  B(39) = RCT(30)*V(69)
! B(40) = dA(31)/dV(69)
  B(40) = RCT(31)*V(72)
! B(41) = dA(31)/dV(72)
  B(41) = RCT(31)*V(69)
! B(42) = dA(32)/dV(69)
  B(42) = RCT(32)*2*V(69)
! B(43) = dA(33)/dV(61)
  B(43) = RCT(33)*V(69)*V(69)
! B(44) = dA(33)/dV(69)
  B(44) = RCT(33)*2*V(61)*V(69)
! B(45) = dA(34)/dV(30)
  B(45) = RCT(34)*V(70)
! B(46) = dA(34)/dV(70)
  B(46) = RCT(34)*V(30)
! B(47) = dA(35)/dV(70)
  B(47) = RCT(35)*V(73)
! B(48) = dA(35)/dV(73)
  B(48) = RCT(35)*V(70)
! B(49) = dA(36)/dV(34)
  B(49) = RCT(36)*V(73)*V(73)
! B(50) = dA(36)/dV(73)
  B(50) = RCT(36)*2*V(34)*V(73)
! B(51) = dA(37)/dV(72)
  B(51) = RCT(37)*V(74)
! B(52) = dA(37)/dV(74)
  B(52) = RCT(37)*V(72)
! B(53) = dA(38)/dV(71)
  B(53) = RCT(38)*V(73)
! B(54) = dA(38)/dV(73)
  B(54) = RCT(38)*V(71)
! B(55) = dA(39)/dV(71)
  B(55) = RCT(39)*V(72)
! B(56) = dA(39)/dV(72)
  B(56) = RCT(39)*V(71)
! B(57) = dA(40)/dV(69)
  B(57) = RCT(40)*V(71)
! B(58) = dA(40)/dV(71)
  B(58) = RCT(40)*V(69)
! B(59) = dA(41)/dV(71)
  B(59) = RCT(41)*V(72)
! B(60) = dA(41)/dV(72)
  B(60) = RCT(41)*V(71)
! B(61) = dA(42)/dV(20)
  B(61) = RCT(42)
! B(62) = dA(43)/dV(20)
  B(62) = RCT(43)*V(61)
! B(63) = dA(43)/dV(61)
  B(63) = RCT(43)*V(20)
! B(64) = dA(44)/dV(70)
  B(64) = RCT(44)*V(72)
! B(65) = dA(44)/dV(72)
  B(65) = RCT(44)*V(70)
! B(66) = dA(45)/dV(40)
  B(66) = RCT(45)*V(70)
! B(67) = dA(45)/dV(70)
  B(67) = RCT(45)*V(40)
! B(68) = dA(46)/dV(26)
  B(68) = RCT(46)*V(70)
! B(69) = dA(46)/dV(70)
  B(69) = RCT(46)*V(26)
! B(70) = dA(47)/dV(69)
  B(70) = RCT(47)*V(70)
! B(71) = dA(47)/dV(70)
  B(71) = RCT(47)*V(69)
! B(72) = dA(48)/dV(7)
  B(72) = RCT(48)*V(70)
! B(73) = dA(48)/dV(70)
  B(73) = RCT(48)*V(7)
! B(74) = dA(49)/dV(36)
  B(74) = RCT(49)*V(70)
! B(75) = dA(49)/dV(70)
  B(75) = RCT(49)*V(36)
! B(76) = dA(50)/dV(24)
  B(76) = RCT(50)*V(70)
! B(77) = dA(50)/dV(70)
  B(77) = RCT(50)*V(24)
! B(78) = dA(51)/dV(8)
  B(78) = RCT(51)*V(70)
! B(79) = dA(51)/dV(70)
  B(79) = RCT(51)*V(8)
! B(80) = dA(52)/dV(17)
  B(80) = RCT(52)*V(70)
! B(81) = dA(52)/dV(70)
  B(81) = RCT(52)*V(17)
! B(82) = dA(53)/dV(10)
  B(82) = RCT(53)*V(70)
! B(83) = dA(53)/dV(70)
  B(83) = RCT(53)*V(10)
! B(84) = dA(54)/dV(11)
  B(84) = RCT(54)*V(70)
! B(85) = dA(54)/dV(70)
  B(85) = RCT(54)*V(11)
! B(86) = dA(55)/dV(31)
  B(86) = RCT(55)*V(70)
! B(87) = dA(55)/dV(70)
  B(87) = RCT(55)*V(31)
! B(88) = dA(56)/dV(38)
  B(88) = RCT(56)*V(70)
! B(89) = dA(56)/dV(70)
  B(89) = RCT(56)*V(38)
! B(90) = dA(57)/dV(63)
  B(90) = RCT(57)*V(70)
! B(91) = dA(57)/dV(70)
  B(91) = RCT(57)*V(63)
! B(92) = dA(58)/dV(12)
  B(92) = RCT(58)*V(70)
! B(93) = dA(58)/dV(70)
  B(93) = RCT(58)*V(12)
! B(94) = dA(59)/dV(13)
  B(94) = RCT(59)*V(70)
! B(95) = dA(59)/dV(70)
  B(95) = RCT(59)*V(13)
! B(96) = dA(60)/dV(25)
  B(96) = RCT(60)*V(70)
! B(97) = dA(60)/dV(70)
  B(97) = RCT(60)*V(25)
! B(98) = dA(61)/dV(58)
  B(98) = RCT(61)*V(70)
! B(99) = dA(61)/dV(70)
  B(99) = RCT(61)*V(58)
! B(100) = dA(62)/dV(65)
  B(100) = RCT(62)*V(70)
! B(101) = dA(62)/dV(70)
  B(101) = RCT(62)*V(65)
! B(102) = dA(63)/dV(49)
  B(102) = RCT(63)*V(70)
! B(103) = dA(63)/dV(70)
  B(103) = RCT(63)*V(49)
! B(104) = dA(64)/dV(42)
  B(104) = RCT(64)*V(70)
! B(105) = dA(64)/dV(70)
  B(105) = RCT(64)*V(42)
! B(106) = dA(65)/dV(57)
  B(106) = RCT(65)*V(70)
! B(107) = dA(65)/dV(70)
  B(107) = RCT(65)*V(57)
! B(108) = dA(66)/dV(45)
  B(108) = RCT(66)*V(70)
! B(109) = dA(66)/dV(70)
  B(109) = RCT(66)*V(45)
! B(110) = dA(67)/dV(22)
  B(110) = RCT(67)*V(70)
! B(111) = dA(67)/dV(70)
  B(111) = RCT(67)*V(22)
! B(112) = dA(68)/dV(54)
  B(112) = RCT(68)*V(70)
! B(113) = dA(68)/dV(70)
  B(113) = RCT(68)*V(54)
! B(114) = dA(69)/dV(21)
  B(114) = RCT(69)*V(70)
! B(115) = dA(69)/dV(70)
  B(115) = RCT(69)*V(21)
! B(116) = dA(70)/dV(28)
  B(116) = RCT(70)*V(70)
! B(117) = dA(70)/dV(70)
  B(117) = RCT(70)*V(28)
! B(118) = dA(71)/dV(70)
  B(118) = RCT(71)*V(75)
! B(119) = dA(71)/dV(75)
  B(119) = RCT(71)*V(70)
! B(120) = dA(72)/dV(39)
  B(120) = RCT(72)*V(70)
! B(121) = dA(72)/dV(70)
  B(121) = RCT(72)*V(39)
! B(122) = dA(73)/dV(68)
  B(122) = RCT(73)*V(72)
! B(123) = dA(73)/dV(72)
  B(123) = RCT(73)*V(68)
! B(124) = dA(74)/dV(28)
  B(124) = RCT(74)
! B(125) = dA(75)/dV(59)
  B(125) = RCT(75)*V(72)
! B(126) = dA(75)/dV(72)
  B(126) = RCT(75)*V(59)
! B(127) = dA(76)/dV(14)
  B(127) = RCT(76)
! B(128) = dA(77)/dV(67)
  B(128) = RCT(77)*V(73)
! B(129) = dA(77)/dV(73)
  B(129) = RCT(77)*V(67)
! B(130) = dA(78)/dV(73)
  B(130) = RCT(78)*V(76)
! B(131) = dA(78)/dV(76)
  B(131) = RCT(78)*V(73)
! B(132) = dA(79)/dV(46)
  B(132) = RCT(79)*V(73)
! B(133) = dA(79)/dV(73)
  B(133) = RCT(79)*V(46)
! B(134) = dA(80)/dV(47)
  B(134) = RCT(80)*V(73)
! B(135) = dA(80)/dV(73)
  B(135) = RCT(80)*V(47)
! B(136) = dA(81)/dV(50)
  B(136) = RCT(81)*V(73)
! B(137) = dA(81)/dV(73)
  B(137) = RCT(81)*V(50)
! B(138) = dA(82)/dV(51)
  B(138) = RCT(82)*V(73)
! B(139) = dA(82)/dV(73)
  B(139) = RCT(82)*V(51)
! B(140) = dA(83)/dV(48)
  B(140) = RCT(83)*V(73)
! B(141) = dA(83)/dV(73)
  B(141) = RCT(83)*V(48)
! B(142) = dA(84)/dV(68)
  B(142) = RCT(84)*V(73)
! B(143) = dA(84)/dV(73)
  B(143) = RCT(84)*V(68)
! B(144) = dA(85)/dV(59)
  B(144) = RCT(85)*V(73)
! B(145) = dA(85)/dV(73)
  B(145) = RCT(85)*V(59)
! B(146) = dA(86)/dV(53)
  B(146) = RCT(86)*V(73)
! B(147) = dA(86)/dV(73)
  B(147) = RCT(86)*V(53)
! B(148) = dA(87)/dV(43)
  B(148) = RCT(87)*V(73)
! B(149) = dA(87)/dV(73)
  B(149) = RCT(87)*V(43)
! B(150) = dA(88)/dV(66)
  B(150) = RCT(88)*V(73)
! B(151) = dA(88)/dV(73)
  B(151) = RCT(88)*V(66)
! B(152) = dA(89)/dV(64)
  B(152) = RCT(89)*V(73)
! B(153) = dA(89)/dV(73)
  B(153) = RCT(89)*V(64)
! B(154) = dA(90)/dV(56)
  B(154) = RCT(90)*V(73)
! B(155) = dA(90)/dV(73)
  B(155) = RCT(90)*V(56)
! B(156) = dA(91)/dV(58)
  B(156) = RCT(91)*V(71)
! B(157) = dA(91)/dV(71)
  B(157) = RCT(91)*V(58)
! B(158) = dA(92)/dV(65)
  B(158) = RCT(92)*V(71)
! B(159) = dA(92)/dV(71)
  B(159) = RCT(92)*V(65)
! B(160) = dA(93)/dV(42)
  B(160) = RCT(93)*V(71)
! B(161) = dA(93)/dV(71)
  B(161) = RCT(93)*V(42)
! B(162) = dA(94)/dV(57)
  B(162) = RCT(94)*V(71)
! B(163) = dA(94)/dV(71)
  B(163) = RCT(94)*V(57)
! B(164) = dA(95)/dV(45)
  B(164) = RCT(95)*V(71)
! B(165) = dA(95)/dV(71)
  B(165) = RCT(95)*V(45)
! B(166) = dA(96)/dV(25)
  B(166) = RCT(96)*V(71)
! B(167) = dA(96)/dV(71)
  B(167) = RCT(96)*V(25)
! B(168) = dA(97)/dV(31)
  B(168) = RCT(97)*V(71)
! B(169) = dA(97)/dV(71)
  B(169) = RCT(97)*V(31)
! B(170) = dA(98)/dV(38)
  B(170) = RCT(98)*V(71)
! B(171) = dA(98)/dV(71)
  B(171) = RCT(98)*V(38)
! B(172) = dA(99)/dV(63)
  B(172) = RCT(99)*V(71)
! B(173) = dA(99)/dV(71)
  B(173) = RCT(99)*V(63)
! B(174) = dA(100)/dV(39)
  B(174) = RCT(100)*V(71)
! B(175) = dA(100)/dV(71)
  B(175) = RCT(100)*V(39)
! B(176) = dA(101)/dV(31)
  B(176) = RCT(101)*V(74)
! B(177) = dA(101)/dV(74)
  B(177) = RCT(101)*V(31)
! B(178) = dA(102)/dV(38)
  B(178) = RCT(102)*V(74)
! B(179) = dA(102)/dV(74)
  B(179) = RCT(102)*V(38)
! B(180) = dA(103)/dV(63)
  B(180) = RCT(103)*V(74)
! B(181) = dA(103)/dV(74)
  B(181) = RCT(103)*V(63)
! B(182) = dA(104)/dV(39)
  B(182) = RCT(104)*V(74)
! B(183) = dA(104)/dV(74)
  B(183) = RCT(104)*V(39)
! B(184) = dA(105)/dV(67)
  B(184) = RCT(105)*V(69)
! B(185) = dA(105)/dV(69)
  B(185) = RCT(105)*V(67)
! B(186) = dA(106)/dV(66)
  B(186) = RCT(106)*V(69)
! B(187) = dA(106)/dV(69)
  B(187) = RCT(106)*V(66)
! B(188) = dA(107)/dV(69)
  B(188) = RCT(107)*V(76)
! B(189) = dA(107)/dV(76)
  B(189) = RCT(107)*V(69)
! B(190) = dA(108)/dV(46)
  B(190) = RCT(108)*V(69)
! B(191) = dA(108)/dV(69)
  B(191) = RCT(108)*V(46)
! B(192) = dA(109)/dV(47)
  B(192) = RCT(109)*V(69)
! B(193) = dA(109)/dV(69)
  B(193) = RCT(109)*V(47)
! B(194) = dA(110)/dV(50)
  B(194) = RCT(110)*V(69)
! B(195) = dA(110)/dV(69)
  B(195) = RCT(110)*V(50)
! B(196) = dA(111)/dV(51)
  B(196) = RCT(111)*V(69)
! B(197) = dA(111)/dV(69)
  B(197) = RCT(111)*V(51)
! B(198) = dA(112)/dV(48)
  B(198) = RCT(112)*V(69)
! B(199) = dA(112)/dV(69)
  B(199) = RCT(112)*V(48)
! B(200) = dA(113)/dV(64)
  B(200) = RCT(113)*V(69)
! B(201) = dA(113)/dV(69)
  B(201) = RCT(113)*V(64)
! B(202) = dA(114)/dV(68)
  B(202) = RCT(114)*V(69)
! B(203) = dA(114)/dV(69)
  B(203) = RCT(114)*V(68)
! B(204) = dA(115)/dV(53)
  B(204) = RCT(115)*V(69)
! B(205) = dA(115)/dV(69)
  B(205) = RCT(115)*V(53)
! B(206) = dA(116)/dV(43)
  B(206) = RCT(116)*V(69)
! B(207) = dA(116)/dV(69)
  B(207) = RCT(116)*V(43)
! B(208) = dA(117)/dV(59)
  B(208) = RCT(117)*V(69)
! B(209) = dA(117)/dV(69)
  B(209) = RCT(117)*V(59)
! B(210) = dA(118)/dV(56)
  B(210) = RCT(118)*V(69)
! B(211) = dA(118)/dV(69)
  B(211) = RCT(118)*V(56)
! B(212) = dA(119)/dV(67)
  B(212) = RCT(119)*2*V(67)
! B(213) = dA(120)/dV(66)
  B(213) = RCT(120)*V(67)
! B(214) = dA(120)/dV(67)
  B(214) = RCT(120)*V(66)
! B(215) = dA(121)/dV(67)
  B(215) = RCT(121)*V(76)
! B(216) = dA(121)/dV(76)
  B(216) = RCT(121)*V(67)
! B(217) = dA(122)/dV(46)
  B(217) = RCT(122)*V(67)
! B(218) = dA(122)/dV(67)
  B(218) = RCT(122)*V(46)
! B(219) = dA(123)/dV(47)
  B(219) = RCT(123)*V(67)
! B(220) = dA(123)/dV(67)
  B(220) = RCT(123)*V(47)
! B(221) = dA(124)/dV(50)
  B(221) = RCT(124)*V(67)
! B(222) = dA(124)/dV(67)
  B(222) = RCT(124)*V(50)
! B(223) = dA(125)/dV(51)
  B(223) = RCT(125)*V(67)
! B(224) = dA(125)/dV(67)
  B(224) = RCT(125)*V(51)
! B(225) = dA(126)/dV(48)
  B(225) = RCT(126)*V(67)
! B(226) = dA(126)/dV(67)
  B(226) = RCT(126)*V(48)
! B(227) = dA(127)/dV(64)
  B(227) = RCT(127)*V(67)
! B(228) = dA(127)/dV(67)
  B(228) = RCT(127)*V(64)
! B(229) = dA(128)/dV(67)
  B(229) = RCT(128)*V(68)
! B(230) = dA(128)/dV(68)
  B(230) = RCT(128)*V(67)
! B(231) = dA(129)/dV(53)
  B(231) = RCT(129)*V(67)
! B(232) = dA(129)/dV(67)
  B(232) = RCT(129)*V(53)
! B(233) = dA(130)/dV(43)
  B(233) = RCT(130)*V(67)
! B(234) = dA(130)/dV(67)
  B(234) = RCT(130)*V(43)
! B(235) = dA(131)/dV(59)
  B(235) = RCT(131)*V(67)
! B(236) = dA(131)/dV(67)
  B(236) = RCT(131)*V(59)
! B(237) = dA(132)/dV(66)
  B(237) = RCT(132)*V(68)
! B(238) = dA(132)/dV(68)
  B(238) = RCT(132)*V(66)
! B(239) = dA(133)/dV(68)
  B(239) = RCT(133)*V(76)
! B(240) = dA(133)/dV(76)
  B(240) = RCT(133)*V(68)
! B(241) = dA(134)/dV(46)
  B(241) = RCT(134)*V(68)
! B(242) = dA(134)/dV(68)
  B(242) = RCT(134)*V(46)
! B(243) = dA(135)/dV(47)
  B(243) = RCT(135)*V(68)
! B(244) = dA(135)/dV(68)
  B(244) = RCT(135)*V(47)
! B(245) = dA(136)/dV(50)
  B(245) = RCT(136)*V(68)
! B(246) = dA(136)/dV(68)
  B(246) = RCT(136)*V(50)
! B(247) = dA(137)/dV(51)
  B(247) = RCT(137)*V(68)
! B(248) = dA(137)/dV(68)
  B(248) = RCT(137)*V(51)
! B(249) = dA(138)/dV(48)
  B(249) = RCT(138)*V(68)
! B(250) = dA(138)/dV(68)
  B(250) = RCT(138)*V(48)
! B(251) = dA(139)/dV(64)
  B(251) = RCT(139)*V(68)
! B(252) = dA(139)/dV(68)
  B(252) = RCT(139)*V(64)
! B(253) = dA(140)/dV(68)
  B(253) = RCT(140)*2*V(68)
! B(254) = dA(141)/dV(53)
  B(254) = RCT(141)*V(68)
! B(255) = dA(141)/dV(68)
  B(255) = RCT(141)*V(53)
! B(256) = dA(142)/dV(43)
  B(256) = RCT(142)*V(68)
! B(257) = dA(142)/dV(68)
  B(257) = RCT(142)*V(43)
! B(258) = dA(143)/dV(59)
  B(258) = RCT(143)*V(68)
! B(259) = dA(143)/dV(68)
  B(259) = RCT(143)*V(59)
! B(260) = dA(144)/dV(52)
  B(260) = RCT(144)*V(69)
! B(261) = dA(144)/dV(69)
  B(261) = RCT(144)*V(52)
! B(262) = dA(145)/dV(52)
  B(262) = RCT(145)*V(67)
! B(263) = dA(145)/dV(67)
  B(263) = RCT(145)*V(52)
! B(264) = dA(146)/dV(52)
  B(264) = RCT(146)*V(68)
! B(265) = dA(146)/dV(68)
  B(265) = RCT(146)*V(52)
! B(266) = dA(147)/dV(52)
  B(266) = RCT(147)*V(73)
! B(267) = dA(147)/dV(73)
  B(267) = RCT(147)*V(52)
! B(268) = dA(148)/dV(41)
  B(268) = RCT(148)*V(72)
! B(269) = dA(148)/dV(72)
  B(269) = RCT(148)*V(41)
! B(270) = dA(149)/dV(41)
  B(270) = RCT(149)*V(69)
! B(271) = dA(149)/dV(69)
  B(271) = RCT(149)*V(41)
! B(272) = dA(150)/dV(41)
  B(272) = RCT(150)*V(67)
! B(273) = dA(150)/dV(67)
  B(273) = RCT(150)*V(41)
! B(274) = dA(151)/dV(41)
  B(274) = RCT(151)*V(68)
! B(275) = dA(151)/dV(68)
  B(275) = RCT(151)*V(41)
! B(276) = dA(152)/dV(56)
  B(276) = RCT(152)*V(67)
! B(277) = dA(152)/dV(67)
  B(277) = RCT(152)*V(56)
! B(278) = dA(153)/dV(56)
  B(278) = RCT(153)*V(68)
! B(279) = dA(153)/dV(68)
  B(279) = RCT(153)*V(56)
! B(280) = dA(154)/dV(56)
  B(280) = RCT(154)*2*V(56)
! B(281) = dA(155)/dV(35)
  B(281) = RCT(155)*V(70)
! B(282) = dA(155)/dV(70)
  B(282) = RCT(155)*V(35)
! B(283) = dA(156)/dV(35)
  B(283) = RCT(156)*V(71)
! B(284) = dA(156)/dV(71)
  B(284) = RCT(156)*V(35)
! B(285) = dA(157)/dV(35)
  B(285) = RCT(157)*V(74)
! B(286) = dA(157)/dV(74)
  B(286) = RCT(157)*V(35)
! B(287) = dA(158)/dV(60)
  B(287) = RCT(158)*V(73)
! B(288) = dA(158)/dV(73)
  B(288) = RCT(158)*V(60)
! B(289) = dA(159)/dV(60)
  B(289) = RCT(159)*V(69)
! B(290) = dA(159)/dV(69)
  B(290) = RCT(159)*V(60)
! B(291) = dA(160)/dV(60)
  B(291) = RCT(160)*V(67)
! B(292) = dA(160)/dV(67)
  B(292) = RCT(160)*V(60)
! B(293) = dA(161)/dV(60)
  B(293) = RCT(161)*V(68)
! B(294) = dA(161)/dV(68)
  B(294) = RCT(161)*V(60)
! B(295) = dA(162)/dV(60)
  B(295) = RCT(162)*V(71)
! B(296) = dA(162)/dV(71)
  B(296) = RCT(162)*V(60)
! B(297) = dA(163)/dV(37)
  B(297) = RCT(163)*V(70)
! B(298) = dA(163)/dV(70)
  B(298) = RCT(163)*V(37)
! B(299) = dA(164)/dV(37)
  B(299) = RCT(164)*V(71)
! B(300) = dA(164)/dV(71)
  B(300) = RCT(164)*V(37)
! B(301) = dA(165)/dV(37)
  B(301) = RCT(165)*V(74)
! B(302) = dA(165)/dV(74)
  B(302) = RCT(165)*V(37)
! B(303) = dA(166)/dV(62)
  B(303) = RCT(166)*V(73)
! B(304) = dA(166)/dV(73)
  B(304) = RCT(166)*V(62)
! B(305) = dA(167)/dV(62)
  B(305) = RCT(167)*V(69)
! B(306) = dA(167)/dV(69)
  B(306) = RCT(167)*V(62)
! B(307) = dA(168)/dV(62)
  B(307) = RCT(168)*V(67)
! B(308) = dA(168)/dV(67)
  B(308) = RCT(168)*V(62)
! B(309) = dA(169)/dV(62)
  B(309) = RCT(169)*V(68)
! B(310) = dA(169)/dV(68)
  B(310) = RCT(169)*V(62)
! B(311) = dA(170)/dV(62)
  B(311) = RCT(170)*V(71)
! B(312) = dA(170)/dV(71)
  B(312) = RCT(170)*V(62)
! B(313) = dA(171)/dV(32)
  B(313) = RCT(171)*V(73)
! B(314) = dA(171)/dV(73)
  B(314) = RCT(171)*V(32)
! B(315) = dA(172)/dV(32)
  B(315) = RCT(172)*V(69)
! B(316) = dA(172)/dV(69)
  B(316) = RCT(172)*V(32)
! B(317) = dA(173)/dV(32)
  B(317) = RCT(173)*2*V(32)
! B(318) = dA(174)/dV(9)
  B(318) = RCT(174)*V(70)
! B(319) = dA(174)/dV(70)
  B(319) = RCT(174)*V(9)
! B(320) = dA(175)/dV(33)
  B(320) = RCT(175)*V(70)
! B(321) = dA(175)/dV(70)
  B(321) = RCT(175)*V(33)
! B(322) = dA(176)/dV(44)
  B(322) = RCT(176)*V(70)
! B(323) = dA(176)/dV(70)
  B(323) = RCT(176)*V(44)
! B(324) = dA(177)/dV(44)
  B(324) = RCT(177)*V(74)
! B(325) = dA(177)/dV(74)
  B(325) = RCT(177)*V(44)
! B(326) = dA(178)/dV(55)
  B(326) = RCT(178)*V(73)
! B(327) = dA(178)/dV(73)
  B(327) = RCT(178)*V(55)
! B(328) = dA(179)/dV(55)
  B(328) = RCT(179)*V(69)
! B(329) = dA(179)/dV(69)
  B(329) = RCT(179)*V(55)
! B(330) = dA(180)/dV(55)
  B(330) = RCT(180)*2*V(55)
! B(331) = dA(181)/dV(55)
  B(331) = RCT(181)*V(72)
! B(332) = dA(181)/dV(72)
  B(332) = RCT(181)*V(55)
! B(333) = dA(182)/dV(23)
  B(333) = RCT(182)
! B(334) = dA(183)/dV(23)
  B(334) = RCT(183)*V(70)
! B(335) = dA(183)/dV(70)
  B(335) = RCT(183)*V(23)
! B(336) = dA(184)/dV(16)
  B(336) = RCT(184)*V(70)
! B(337) = dA(184)/dV(70)
  B(337) = RCT(184)*V(16)
! B(338) = dA(185)/dV(27)
  B(338) = RCT(185)*V(70)
! B(339) = dA(185)/dV(70)
  B(339) = RCT(185)*V(27)
! B(340) = dA(186)/dV(18)
  B(340) = RCT(186)*V(70)
! B(341) = dA(186)/dV(70)
  B(341) = RCT(186)*V(18)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = 0
! JVS(2) = Jac_FULL(2,2)
  JVS(2) = 0
! JVS(3) = Jac_FULL(2,7)
  JVS(3) = B(72)
! JVS(4) = Jac_FULL(2,70)
  JVS(4) = B(73)
! JVS(5) = Jac_FULL(3,3)
  JVS(5) = 0
! JVS(6) = Jac_FULL(3,31)
  JVS(6) = 0.4*B(176)
! JVS(7) = Jac_FULL(3,37)
  JVS(7) = 0.01*B(301)
! JVS(8) = Jac_FULL(3,38)
  JVS(8) = 0.2*B(178)
! JVS(9) = Jac_FULL(3,39)
  JVS(9) = 0.28*B(182)
! JVS(10) = Jac_FULL(3,44)
  JVS(10) = 0.45*B(324)
! JVS(11) = Jac_FULL(3,63)
  JVS(11) = 0.06*B(180)
! JVS(12) = Jac_FULL(3,74)
  JVS(12) = 0.4*B(177)+0.2*B(179)+0.06*B(181)+0.28*B(183)+0.01*B(302)+0.45*B(325)
! JVS(13) = Jac_FULL(4,4)
  JVS(13) = 0
! JVS(14) = Jac_FULL(4,37)
  JVS(14) = 0.07*B(301)
! JVS(15) = Jac_FULL(4,38)
  JVS(15) = 0.2*B(178)
! JVS(16) = Jac_FULL(4,46)
  JVS(16) = 0.5*B(241)
! JVS(17) = Jac_FULL(4,47)
  JVS(17) = 0.5*B(243)
! JVS(18) = Jac_FULL(4,48)
  JVS(18) = 0.5*B(249)
! JVS(19) = Jac_FULL(4,50)
  JVS(19) = 0.5*B(245)
! JVS(20) = Jac_FULL(4,51)
  JVS(20) = 0.5*B(247)
! JVS(21) = Jac_FULL(4,56)
  JVS(21) = 0.5*B(278)
! JVS(22) = Jac_FULL(4,59)
  JVS(22) = 0.5*B(235)
! JVS(23) = Jac_FULL(4,63)
  JVS(23) = 0.29*B(180)
! JVS(24) = Jac_FULL(4,64)
  JVS(24) = 0.5*B(251)
! JVS(25) = Jac_FULL(4,66)
  JVS(25) = 0.5*B(237)
! JVS(26) = Jac_FULL(4,67)
  JVS(26) = 0.5*B(229)+0.5*B(236)
! JVS(27) = Jac_FULL(4,68)
  JVS(27) = 0.5*B(230)+0.5*B(238)+0.5*B(239)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)+0.5*B(252)+0.5&
              &*B(279)
! JVS(28) = Jac_FULL(4,74)
  JVS(28) = 0.2*B(179)+0.29*B(181)+0.07*B(302)
! JVS(29) = Jac_FULL(4,76)
  JVS(29) = 0.5*B(240)
! JVS(30) = Jac_FULL(5,5)
  JVS(30) = 0
! JVS(31) = Jac_FULL(5,21)
  JVS(31) = B(15)
! JVS(32) = Jac_FULL(6,6)
  JVS(32) = 0
! JVS(33) = Jac_FULL(6,58)
  JVS(33) = B(10)
! JVS(34) = Jac_FULL(7,7)
  JVS(34) = -B(72)
! JVS(35) = Jac_FULL(7,70)
  JVS(35) = -B(73)
! JVS(36) = Jac_FULL(8,8)
  JVS(36) = -B(78)
! JVS(37) = Jac_FULL(8,70)
  JVS(37) = -B(79)
! JVS(38) = Jac_FULL(9,9)
  JVS(38) = -B(318)
! JVS(39) = Jac_FULL(9,32)
  JVS(39) = B(315)
! JVS(40) = Jac_FULL(9,69)
  JVS(40) = B(316)
! JVS(41) = Jac_FULL(9,70)
  JVS(41) = -B(319)
! JVS(42) = Jac_FULL(10,10)
  JVS(42) = -B(82)
! JVS(43) = Jac_FULL(10,70)
  JVS(43) = -B(83)
! JVS(44) = Jac_FULL(11,11)
  JVS(44) = -B(84)
! JVS(45) = Jac_FULL(11,70)
  JVS(45) = -B(85)
! JVS(46) = Jac_FULL(12,12)
  JVS(46) = -B(92)
! JVS(47) = Jac_FULL(12,70)
  JVS(47) = -B(93)
! JVS(48) = Jac_FULL(13,13)
  JVS(48) = -B(94)
! JVS(49) = Jac_FULL(13,70)
  JVS(49) = -B(95)
! JVS(50) = Jac_FULL(14,14)
  JVS(50) = -B(127)
! JVS(51) = Jac_FULL(14,59)
  JVS(51) = B(125)
! JVS(52) = Jac_FULL(14,72)
  JVS(52) = B(126)
! JVS(53) = Jac_FULL(15,15)
  JVS(53) = -B(4)
! JVS(54) = Jac_FULL(15,70)
  JVS(54) = B(47)
! JVS(55) = Jac_FULL(15,73)
  JVS(55) = B(48)
! JVS(56) = Jac_FULL(16,16)
  JVS(56) = -B(336)
! JVS(57) = Jac_FULL(16,55)
  JVS(57) = B(328)
! JVS(58) = Jac_FULL(16,69)
  JVS(58) = B(329)
! JVS(59) = Jac_FULL(16,70)
  JVS(59) = -B(337)
! JVS(60) = Jac_FULL(17,17)
  JVS(60) = -B(80)
! JVS(61) = Jac_FULL(17,70)
  JVS(61) = -B(81)
! JVS(62) = Jac_FULL(18,18)
  JVS(62) = -B(340)
! JVS(63) = Jac_FULL(18,33)
  JVS(63) = B(320)
! JVS(64) = Jac_FULL(18,70)
  JVS(64) = B(321)-B(341)
! JVS(65) = Jac_FULL(19,1)
  JVS(65) = -B(26)
! JVS(66) = Jac_FULL(19,19)
  JVS(66) = -B(27)-B(28)-B(30)
! JVS(67) = Jac_FULL(19,34)
  JVS(67) = -B(29)
! JVS(68) = Jac_FULL(19,61)
  JVS(68) = -B(31)
! JVS(69) = Jac_FULL(19,74)
  JVS(69) = B(2)
! JVS(70) = Jac_FULL(20,20)
  JVS(70) = -B(61)-B(62)
! JVS(71) = Jac_FULL(20,61)
  JVS(71) = -B(63)
! JVS(72) = Jac_FULL(20,71)
  JVS(72) = B(59)
! JVS(73) = Jac_FULL(20,72)
  JVS(73) = B(60)
! JVS(74) = Jac_FULL(21,21)
  JVS(74) = -B(15)-B(114)
! JVS(75) = Jac_FULL(21,68)
  JVS(75) = B(202)
! JVS(76) = Jac_FULL(21,69)
  JVS(76) = B(203)
! JVS(77) = Jac_FULL(21,70)
  JVS(77) = -B(115)
! JVS(78) = Jac_FULL(22,22)
  JVS(78) = -B(13)-B(110)
! JVS(79) = Jac_FULL(22,67)
  JVS(79) = B(184)
! JVS(80) = Jac_FULL(22,69)
  JVS(80) = B(185)
! JVS(81) = Jac_FULL(22,70)
  JVS(81) = -B(111)
! JVS(82) = Jac_FULL(23,23)
  JVS(82) = -B(333)-B(334)
! JVS(83) = Jac_FULL(23,55)
  JVS(83) = B(331)
! JVS(84) = Jac_FULL(23,70)
  JVS(84) = -B(335)
! JVS(85) = Jac_FULL(23,72)
  JVS(85) = B(332)
! JVS(86) = Jac_FULL(24,24)
  JVS(86) = -B(76)
! JVS(87) = Jac_FULL(24,38)
  JVS(87) = 0.06*B(178)
! JVS(88) = Jac_FULL(24,63)
  JVS(88) = 0.09*B(180)
! JVS(89) = Jac_FULL(24,70)
  JVS(89) = -B(77)
! JVS(90) = Jac_FULL(24,74)
  JVS(90) = 0.06*B(179)+0.09*B(181)
! JVS(91) = Jac_FULL(25,12)
  JVS(91) = 0.25*B(92)
! JVS(92) = Jac_FULL(25,13)
  JVS(92) = 0.17*B(94)
! JVS(93) = Jac_FULL(25,25)
  JVS(93) = -B(96)-0.5*B(166)
! JVS(94) = Jac_FULL(25,70)
  JVS(94) = 0.25*B(93)+0.17*B(95)-B(97)
! JVS(95) = Jac_FULL(25,71)
  JVS(95) = -0.5*B(167)
! JVS(96) = Jac_FULL(26,26)
  JVS(96) = -B(6)-B(68)
! JVS(97) = Jac_FULL(26,69)
  JVS(97) = B(40)
! JVS(98) = Jac_FULL(26,70)
  JVS(98) = -B(69)
! JVS(99) = Jac_FULL(26,72)
  JVS(99) = B(41)
! JVS(100) = Jac_FULL(27,23)
  JVS(100) = B(334)
! JVS(101) = Jac_FULL(27,27)
  JVS(101) = -B(338)
! JVS(102) = Jac_FULL(27,33)
  JVS(102) = B(320)
! JVS(103) = Jac_FULL(27,55)
  JVS(103) = 0.25*B(326)+B(330)
! JVS(104) = Jac_FULL(27,70)
  JVS(104) = B(321)+B(335)-B(339)
! JVS(105) = Jac_FULL(27,72)
  JVS(105) = 0
! JVS(106) = Jac_FULL(27,73)
  JVS(106) = 0.25*B(327)
! JVS(107) = Jac_FULL(28,28)
  JVS(107) = -B(116)-B(124)
! JVS(108) = Jac_FULL(28,68)
  JVS(108) = B(122)
! JVS(109) = Jac_FULL(28,70)
  JVS(109) = -B(117)
! JVS(110) = Jac_FULL(28,72)
  JVS(110) = B(123)
! JVS(111) = Jac_FULL(29,1)
  JVS(111) = B(26)
! JVS(112) = Jac_FULL(29,19)
  JVS(112) = B(27)+B(28)
! JVS(113) = Jac_FULL(29,29)
  JVS(113) = -B(22)-B(24)
! JVS(114) = Jac_FULL(29,34)
  JVS(114) = -B(23)+B(29)
! JVS(115) = Jac_FULL(29,61)
  JVS(115) = 0
! JVS(116) = Jac_FULL(29,71)
  JVS(116) = B(8)
! JVS(117) = Jac_FULL(29,72)
  JVS(117) = B(1)-B(25)
! JVS(118) = Jac_FULL(29,74)
  JVS(118) = B(3)
! JVS(119) = Jac_FULL(30,30)
  JVS(119) = -B(9)-B(45)
! JVS(120) = Jac_FULL(30,35)
  JVS(120) = 0.02*B(285)
! JVS(121) = Jac_FULL(30,37)
  JVS(121) = 0.02*B(301)
! JVS(122) = Jac_FULL(30,39)
  JVS(122) = 0.09*B(182)
! JVS(123) = Jac_FULL(30,61)
  JVS(123) = B(43)
! JVS(124) = Jac_FULL(30,69)
  JVS(124) = B(42)+B(44)
! JVS(125) = Jac_FULL(30,70)
  JVS(125) = -B(46)
! JVS(126) = Jac_FULL(30,74)
  JVS(126) = 0.09*B(183)+0.02*B(286)+0.02*B(302)
! JVS(127) = Jac_FULL(31,31)
  JVS(127) = -B(86)-B(168)-B(176)
! JVS(128) = Jac_FULL(31,70)
  JVS(128) = -B(87)
! JVS(129) = Jac_FULL(31,71)
  JVS(129) = -B(169)
! JVS(130) = Jac_FULL(31,74)
  JVS(130) = -B(177)
! JVS(131) = Jac_FULL(32,32)
  JVS(131) = -B(313)-B(315)-2*B(317)
! JVS(132) = Jac_FULL(32,39)
  JVS(132) = B(120)
! JVS(133) = Jac_FULL(32,69)
  JVS(133) = -B(316)
! JVS(134) = Jac_FULL(32,70)
  JVS(134) = B(121)
! JVS(135) = Jac_FULL(32,73)
  JVS(135) = -B(314)
! JVS(136) = Jac_FULL(33,32)
  JVS(136) = 0.046*B(313)
! JVS(137) = Jac_FULL(33,33)
  JVS(137) = -B(320)
! JVS(138) = Jac_FULL(33,39)
  JVS(138) = B(174)
! JVS(139) = Jac_FULL(33,69)
  JVS(139) = 0
! JVS(140) = Jac_FULL(33,70)
  JVS(140) = -B(321)
! JVS(141) = Jac_FULL(33,71)
  JVS(141) = B(175)
! JVS(142) = Jac_FULL(33,73)
  JVS(142) = 0.046*B(314)
! JVS(143) = Jac_FULL(34,26)
  JVS(143) = B(68)
! JVS(144) = Jac_FULL(34,29)
  JVS(144) = -B(22)+B(24)
! JVS(145) = Jac_FULL(34,34)
  JVS(145) = -B(23)-B(49)
! JVS(146) = Jac_FULL(34,61)
  JVS(146) = 0
! JVS(147) = Jac_FULL(34,69)
  JVS(147) = 2*B(36)+B(57)+B(70)
! JVS(148) = Jac_FULL(34,70)
  JVS(148) = B(34)+B(69)+B(71)
! JVS(149) = Jac_FULL(34,71)
  JVS(149) = B(7)+B(55)+B(58)
! JVS(150) = Jac_FULL(34,72)
  JVS(150) = B(25)+B(56)
! JVS(151) = Jac_FULL(34,73)
  JVS(151) = B(32)-B(50)
! JVS(152) = Jac_FULL(34,74)
  JVS(152) = B(2)+B(3)+B(33)+B(35)+2*B(37)
! JVS(153) = Jac_FULL(35,35)
  JVS(153) = -B(281)-B(283)-B(285)
! JVS(154) = Jac_FULL(35,70)
  JVS(154) = -B(282)
! JVS(155) = Jac_FULL(35,71)
  JVS(155) = -B(284)
! JVS(156) = Jac_FULL(35,74)
  JVS(156) = -B(286)
! JVS(157) = Jac_FULL(36,18)
  JVS(157) = B(340)
! JVS(158) = Jac_FULL(36,31)
  JVS(158) = 0.42*B(176)
! JVS(159) = Jac_FULL(36,33)
  JVS(159) = 0
! JVS(160) = Jac_FULL(36,35)
  JVS(160) = 0.14*B(285)
! JVS(161) = Jac_FULL(36,36)
  JVS(161) = -B(74)
! JVS(162) = Jac_FULL(36,37)
  JVS(162) = 0.14*B(301)
! JVS(163) = Jac_FULL(36,38)
  JVS(163) = 0.33*B(178)
! JVS(164) = Jac_FULL(36,39)
  JVS(164) = 0.14*B(182)
! JVS(165) = Jac_FULL(36,42)
  JVS(165) = 1.87*B(17)+1.55*B(18)+2*B(104)+2*B(160)
! JVS(166) = Jac_FULL(36,44)
  JVS(166) = 0.22*B(324)
! JVS(167) = Jac_FULL(36,55)
  JVS(167) = 0.25*B(326)+0.5*B(330)
! JVS(168) = Jac_FULL(36,57)
  JVS(168) = B(19)+B(106)+B(162)
! JVS(169) = Jac_FULL(36,58)
  JVS(169) = B(10)+B(11)+B(98)+B(156)
! JVS(170) = Jac_FULL(36,59)
  JVS(170) = 0.95*B(144)+0.475*B(235)+0.95*B(258)
! JVS(171) = Jac_FULL(36,63)
  JVS(171) = 0.23*B(180)
! JVS(172) = Jac_FULL(36,65)
  JVS(172) = B(12)
! JVS(173) = Jac_FULL(36,67)
  JVS(173) = 0.475*B(236)
! JVS(174) = Jac_FULL(36,68)
  JVS(174) = 0.95*B(259)
! JVS(175) = Jac_FULL(36,69)
  JVS(175) = 0
! JVS(176) = Jac_FULL(36,70)
  JVS(176) = -B(75)+B(99)+2*B(105)+B(107)+B(341)
! JVS(177) = Jac_FULL(36,71)
  JVS(177) = B(157)+2*B(161)+B(163)
! JVS(178) = Jac_FULL(36,73)
  JVS(178) = 0.95*B(145)+0.25*B(327)
! JVS(179) = Jac_FULL(36,74)
  JVS(179) = 0.42*B(177)+0.33*B(179)+0.23*B(181)+0.14*B(183)+0.14*B(286)+0.14*B(302)+0.22*B(325)
! JVS(180) = Jac_FULL(37,37)
  JVS(180) = -B(297)-B(299)-B(301)
! JVS(181) = Jac_FULL(37,70)
  JVS(181) = -B(298)
! JVS(182) = Jac_FULL(37,71)
  JVS(182) = -B(300)
! JVS(183) = Jac_FULL(37,74)
  JVS(183) = -B(302)
! JVS(184) = Jac_FULL(38,37)
  JVS(184) = 0.46*B(301)
! JVS(185) = Jac_FULL(38,38)
  JVS(185) = -B(88)-B(170)-B(178)
! JVS(186) = Jac_FULL(38,70)
  JVS(186) = -B(89)
! JVS(187) = Jac_FULL(38,71)
  JVS(187) = -B(171)
! JVS(188) = Jac_FULL(38,74)
  JVS(188) = -B(179)+0.46*B(302)
! JVS(189) = Jac_FULL(39,39)
  JVS(189) = -B(120)-B(174)-B(182)
! JVS(190) = Jac_FULL(39,70)
  JVS(190) = -B(121)
! JVS(191) = Jac_FULL(39,71)
  JVS(191) = -B(175)
! JVS(192) = Jac_FULL(39,74)
  JVS(192) = -B(183)
! JVS(193) = Jac_FULL(40,20)
  JVS(193) = 2*B(62)
! JVS(194) = Jac_FULL(40,25)
  JVS(194) = B(166)
! JVS(195) = Jac_FULL(40,40)
  JVS(195) = -B(5)-B(66)
! JVS(196) = Jac_FULL(40,42)
  JVS(196) = B(160)
! JVS(197) = Jac_FULL(40,45)
  JVS(197) = B(164)
! JVS(198) = Jac_FULL(40,57)
  JVS(198) = B(162)
! JVS(199) = Jac_FULL(40,58)
  JVS(199) = B(156)
! JVS(200) = Jac_FULL(40,61)
  JVS(200) = 2*B(63)
! JVS(201) = Jac_FULL(40,65)
  JVS(201) = B(158)
! JVS(202) = Jac_FULL(40,69)
  JVS(202) = B(57)
! JVS(203) = Jac_FULL(40,70)
  JVS(203) = B(64)-B(67)
! JVS(204) = Jac_FULL(40,71)
  JVS(204) = B(58)+B(157)+B(159)+B(161)+B(163)+B(165)+B(167)
! JVS(205) = Jac_FULL(40,72)
  JVS(205) = B(65)
! JVS(206) = Jac_FULL(41,25)
  JVS(206) = B(166)
! JVS(207) = Jac_FULL(41,41)
  JVS(207) = -B(268)-B(270)-B(272)-B(274)
! JVS(208) = Jac_FULL(41,67)
  JVS(208) = -B(273)
! JVS(209) = Jac_FULL(41,68)
  JVS(209) = -B(275)
! JVS(210) = Jac_FULL(41,69)
  JVS(210) = -B(271)
! JVS(211) = Jac_FULL(41,70)
  JVS(211) = 0
! JVS(212) = Jac_FULL(41,71)
  JVS(212) = B(167)
! JVS(213) = Jac_FULL(41,72)
  JVS(213) = -B(269)
! JVS(214) = Jac_FULL(42,42)
  JVS(214) = -B(17)-B(18)-B(104)-B(160)
! JVS(215) = Jac_FULL(42,53)
  JVS(215) = 0.16*B(146)+0.16*B(231)+0.16*B(254)
! JVS(216) = Jac_FULL(42,59)
  JVS(216) = 0.89*B(144)+0.445*B(235)+0.89*B(258)
! JVS(217) = Jac_FULL(42,67)
  JVS(217) = 0.16*B(232)+0.445*B(236)
! JVS(218) = Jac_FULL(42,68)
  JVS(218) = 0.16*B(255)+0.89*B(259)
! JVS(219) = Jac_FULL(42,70)
  JVS(219) = -B(105)
! JVS(220) = Jac_FULL(42,71)
  JVS(220) = -B(161)
! JVS(221) = Jac_FULL(42,73)
  JVS(221) = 0.89*B(145)+0.16*B(147)
! JVS(222) = Jac_FULL(43,13)
  JVS(222) = 0.83*B(94)
! JVS(223) = Jac_FULL(43,43)
  JVS(223) = -B(148)-B(206)-B(233)-B(256)
! JVS(224) = Jac_FULL(43,67)
  JVS(224) = -B(234)
! JVS(225) = Jac_FULL(43,68)
  JVS(225) = -B(257)
! JVS(226) = Jac_FULL(43,69)
  JVS(226) = -B(207)
! JVS(227) = Jac_FULL(43,70)
  JVS(227) = 0.83*B(95)
! JVS(228) = Jac_FULL(43,73)
  JVS(228) = -B(149)
! JVS(229) = Jac_FULL(44,9)
  JVS(229) = B(318)
! JVS(230) = Jac_FULL(44,32)
  JVS(230) = B(313)+2*B(317)
! JVS(231) = Jac_FULL(44,37)
  JVS(231) = 0.79*B(301)
! JVS(232) = Jac_FULL(44,39)
  JVS(232) = 0.65*B(182)
! JVS(233) = Jac_FULL(44,44)
  JVS(233) = -B(322)-B(324)
! JVS(234) = Jac_FULL(44,62)
  JVS(234) = 0.4*B(303)+0.6*B(307)+0.6*B(309)+0.6*B(311)
! JVS(235) = Jac_FULL(44,67)
  JVS(235) = 0.6*B(308)
! JVS(236) = Jac_FULL(44,68)
  JVS(236) = 0.6*B(310)
! JVS(237) = Jac_FULL(44,69)
  JVS(237) = 0
! JVS(238) = Jac_FULL(44,70)
  JVS(238) = B(319)-B(323)
! JVS(239) = Jac_FULL(44,71)
  JVS(239) = 0.6*B(312)
! JVS(240) = Jac_FULL(44,73)
  JVS(240) = 0.4*B(304)+B(314)
! JVS(241) = Jac_FULL(44,74)
  JVS(241) = 0.65*B(183)+0.79*B(302)-B(325)
! JVS(242) = Jac_FULL(45,43)
  JVS(242) = 0.806*B(148)+0.806*B(233)+0.806*B(256)
! JVS(243) = Jac_FULL(45,45)
  JVS(243) = -B(20)-B(108)-B(164)
! JVS(244) = Jac_FULL(45,53)
  JVS(244) = 0.7*B(146)+0.7*B(231)+0.7*B(254)
! JVS(245) = Jac_FULL(45,67)
  JVS(245) = 0.7*B(232)+0.806*B(234)
! JVS(246) = Jac_FULL(45,68)
  JVS(246) = 0.7*B(255)+0.806*B(257)
! JVS(247) = Jac_FULL(45,69)
  JVS(247) = 0
! JVS(248) = Jac_FULL(45,70)
  JVS(248) = -B(109)
! JVS(249) = Jac_FULL(45,71)
  JVS(249) = -B(165)
! JVS(250) = Jac_FULL(45,73)
  JVS(250) = 0.7*B(147)+0.806*B(149)
! JVS(251) = Jac_FULL(46,10)
  JVS(251) = B(82)
! JVS(252) = Jac_FULL(46,46)
  JVS(252) = -B(132)-B(190)-B(217)-B(241)
! JVS(253) = Jac_FULL(46,67)
  JVS(253) = -B(218)
! JVS(254) = Jac_FULL(46,68)
  JVS(254) = -B(242)
! JVS(255) = Jac_FULL(46,69)
  JVS(255) = -B(191)
! JVS(256) = Jac_FULL(46,70)
  JVS(256) = B(83)
! JVS(257) = Jac_FULL(46,73)
  JVS(257) = -B(133)
! JVS(258) = Jac_FULL(47,11)
  JVS(258) = B(84)
! JVS(259) = Jac_FULL(47,47)
  JVS(259) = -B(134)-B(192)-B(219)-B(243)
! JVS(260) = Jac_FULL(47,67)
  JVS(260) = -B(220)
! JVS(261) = Jac_FULL(47,68)
  JVS(261) = -B(244)
! JVS(262) = Jac_FULL(47,69)
  JVS(262) = -B(193)
! JVS(263) = Jac_FULL(47,70)
  JVS(263) = B(85)
! JVS(264) = Jac_FULL(47,73)
  JVS(264) = -B(135)
! JVS(265) = Jac_FULL(48,48)
  JVS(265) = -B(140)-B(198)-B(225)-B(249)
! JVS(266) = Jac_FULL(48,63)
  JVS(266) = B(90)
! JVS(267) = Jac_FULL(48,67)
  JVS(267) = -B(226)
! JVS(268) = Jac_FULL(48,68)
  JVS(268) = -B(250)
! JVS(269) = Jac_FULL(48,69)
  JVS(269) = -B(199)
! JVS(270) = Jac_FULL(48,70)
  JVS(270) = B(91)
! JVS(271) = Jac_FULL(48,73)
  JVS(271) = -B(141)
! JVS(272) = Jac_FULL(49,17)
  JVS(272) = 0.025*B(80)
! JVS(273) = Jac_FULL(49,35)
  JVS(273) = 0.53*B(285)
! JVS(274) = Jac_FULL(49,46)
  JVS(274) = 0.69*B(132)+0.75*B(217)+0.75*B(241)
! JVS(275) = Jac_FULL(49,47)
  JVS(275) = 1.06*B(134)+1.39*B(219)+1.39*B(243)
! JVS(276) = Jac_FULL(49,48)
  JVS(276) = 0.1*B(140)+0.55*B(225)+0.55*B(249)
! JVS(277) = Jac_FULL(49,49)
  JVS(277) = -B(16)-B(102)
! JVS(278) = Jac_FULL(49,60)
  JVS(278) = 0.8*B(287)+B(291)+B(293)+B(295)
! JVS(279) = Jac_FULL(49,63)
  JVS(279) = 0.1*B(180)
! JVS(280) = Jac_FULL(49,67)
  JVS(280) = 0.26*B(215)+0.75*B(218)+1.39*B(220)+0.55*B(226)+B(292)
! JVS(281) = Jac_FULL(49,68)
  JVS(281) = 0.26*B(239)+0.75*B(242)+1.39*B(244)+0.55*B(250)+B(294)
! JVS(282) = Jac_FULL(49,69)
  JVS(282) = 0
! JVS(283) = Jac_FULL(49,70)
  JVS(283) = 0.025*B(81)-B(103)
! JVS(284) = Jac_FULL(49,71)
  JVS(284) = B(296)
! JVS(285) = Jac_FULL(49,73)
  JVS(285) = 0.25*B(130)+0.69*B(133)+1.06*B(135)+0.1*B(141)+0.8*B(288)
! JVS(286) = Jac_FULL(49,74)
  JVS(286) = 0.1*B(181)+0.53*B(286)
! JVS(287) = Jac_FULL(49,75)
  JVS(287) = 0.8*B(21)
! JVS(288) = Jac_FULL(49,76)
  JVS(288) = 0.25*B(131)+0.26*B(216)+0.26*B(240)
! JVS(289) = Jac_FULL(50,31)
  JVS(289) = B(86)
! JVS(290) = Jac_FULL(50,50)
  JVS(290) = -B(136)-B(194)-B(221)-B(245)
! JVS(291) = Jac_FULL(50,67)
  JVS(291) = -B(222)
! JVS(292) = Jac_FULL(50,68)
  JVS(292) = -B(246)
! JVS(293) = Jac_FULL(50,69)
  JVS(293) = -B(195)
! JVS(294) = Jac_FULL(50,70)
  JVS(294) = B(87)
! JVS(295) = Jac_FULL(50,71)
  JVS(295) = 0
! JVS(296) = Jac_FULL(50,73)
  JVS(296) = -B(137)
! JVS(297) = Jac_FULL(50,74)
  JVS(297) = 0
! JVS(298) = Jac_FULL(51,38)
  JVS(298) = B(88)
! JVS(299) = Jac_FULL(51,51)
  JVS(299) = -B(138)-B(196)-B(223)-B(247)
! JVS(300) = Jac_FULL(51,67)
  JVS(300) = -B(224)
! JVS(301) = Jac_FULL(51,68)
  JVS(301) = -B(248)
! JVS(302) = Jac_FULL(51,69)
  JVS(302) = -B(197)
! JVS(303) = Jac_FULL(51,70)
  JVS(303) = B(89)
! JVS(304) = Jac_FULL(51,71)
  JVS(304) = 0
! JVS(305) = Jac_FULL(51,73)
  JVS(305) = -B(139)
! JVS(306) = Jac_FULL(51,74)
  JVS(306) = 0
! JVS(307) = Jac_FULL(52,10)
  JVS(307) = 0.25*B(82)
! JVS(308) = Jac_FULL(52,11)
  JVS(308) = 0.75*B(84)
! JVS(309) = Jac_FULL(52,25)
  JVS(309) = 0.9*B(96)
! JVS(310) = Jac_FULL(52,28)
  JVS(310) = B(116)
! JVS(311) = Jac_FULL(52,52)
  JVS(311) = -B(260)-B(262)-B(264)-B(266)
! JVS(312) = Jac_FULL(52,59)
  JVS(312) = 2*B(144)+B(235)+2*B(258)
! JVS(313) = Jac_FULL(52,67)
  JVS(313) = B(236)-B(263)
! JVS(314) = Jac_FULL(52,68)
  JVS(314) = 2*B(259)-B(265)
! JVS(315) = Jac_FULL(52,69)
  JVS(315) = -B(261)
! JVS(316) = Jac_FULL(52,70)
  JVS(316) = 0.25*B(83)+0.75*B(85)+0.9*B(97)+B(117)
! JVS(317) = Jac_FULL(52,71)
  JVS(317) = 0
! JVS(318) = Jac_FULL(52,72)
  JVS(318) = 0
! JVS(319) = Jac_FULL(52,73)
  JVS(319) = 2*B(145)-B(267)
! JVS(320) = Jac_FULL(53,12)
  JVS(320) = 0.75*B(92)
! JVS(321) = Jac_FULL(53,53)
  JVS(321) = -B(146)-B(204)-B(231)-B(254)
! JVS(322) = Jac_FULL(53,67)
  JVS(322) = -B(232)
! JVS(323) = Jac_FULL(53,68)
  JVS(323) = -B(255)
! JVS(324) = Jac_FULL(53,69)
  JVS(324) = -B(205)
! JVS(325) = Jac_FULL(53,70)
  JVS(325) = 0.75*B(93)
! JVS(326) = Jac_FULL(53,73)
  JVS(326) = -B(147)
! JVS(327) = Jac_FULL(54,41)
  JVS(327) = B(270)
! JVS(328) = Jac_FULL(54,43)
  JVS(328) = B(206)
! JVS(329) = Jac_FULL(54,46)
  JVS(329) = B(190)
! JVS(330) = Jac_FULL(54,47)
  JVS(330) = B(192)
! JVS(331) = Jac_FULL(54,48)
  JVS(331) = B(198)
! JVS(332) = Jac_FULL(54,50)
  JVS(332) = B(194)
! JVS(333) = Jac_FULL(54,51)
  JVS(333) = B(196)
! JVS(334) = Jac_FULL(54,52)
  JVS(334) = B(260)
! JVS(335) = Jac_FULL(54,53)
  JVS(335) = B(204)
! JVS(336) = Jac_FULL(54,54)
  JVS(336) = -B(14)-B(112)
! JVS(337) = Jac_FULL(54,59)
  JVS(337) = B(208)
! JVS(338) = Jac_FULL(54,60)
  JVS(338) = B(289)
! JVS(339) = Jac_FULL(54,62)
  JVS(339) = B(305)
! JVS(340) = Jac_FULL(54,63)
  JVS(340) = 0
! JVS(341) = Jac_FULL(54,64)
  JVS(341) = B(200)
! JVS(342) = Jac_FULL(54,66)
  JVS(342) = B(186)
! JVS(343) = Jac_FULL(54,67)
  JVS(343) = 0
! JVS(344) = Jac_FULL(54,68)
  JVS(344) = 0
! JVS(345) = Jac_FULL(54,69)
  JVS(345) = B(187)+B(188)+B(191)+B(193)+B(195)+B(197)+B(199)+B(201)+B(205)+B(207)+B(209)+B(261)+B(271)+B(290)+B(306)
! JVS(346) = Jac_FULL(54,70)
  JVS(346) = -B(113)
! JVS(347) = Jac_FULL(54,71)
  JVS(347) = 0
! JVS(348) = Jac_FULL(54,72)
  JVS(348) = 0
! JVS(349) = Jac_FULL(54,73)
  JVS(349) = 0
! JVS(350) = Jac_FULL(54,74)
  JVS(350) = 0
! JVS(351) = Jac_FULL(54,76)
  JVS(351) = B(189)
! JVS(352) = Jac_FULL(55,16)
  JVS(352) = B(336)
! JVS(353) = Jac_FULL(55,23)
  JVS(353) = B(333)
! JVS(354) = Jac_FULL(55,39)
  JVS(354) = 0.1*B(182)
! JVS(355) = Jac_FULL(55,44)
  JVS(355) = B(322)
! JVS(356) = Jac_FULL(55,55)
  JVS(356) = -B(326)-B(328)-2*B(330)-B(331)
! JVS(357) = Jac_FULL(55,62)
  JVS(357) = 0
! JVS(358) = Jac_FULL(55,67)
  JVS(358) = 0
! JVS(359) = Jac_FULL(55,68)
  JVS(359) = 0
! JVS(360) = Jac_FULL(55,69)
  JVS(360) = -B(329)
! JVS(361) = Jac_FULL(55,70)
  JVS(361) = B(323)+B(337)
! JVS(362) = Jac_FULL(55,71)
  JVS(362) = 0
! JVS(363) = Jac_FULL(55,72)
  JVS(363) = -B(332)
! JVS(364) = Jac_FULL(55,73)
  JVS(364) = -B(327)
! JVS(365) = Jac_FULL(55,74)
  JVS(365) = 0.1*B(183)
! JVS(366) = Jac_FULL(56,31)
  JVS(366) = B(168)
! JVS(367) = Jac_FULL(56,35)
  JVS(367) = B(283)
! JVS(368) = Jac_FULL(56,37)
  JVS(368) = B(299)
! JVS(369) = Jac_FULL(56,38)
  JVS(369) = B(170)
! JVS(370) = Jac_FULL(56,56)
  JVS(370) = -B(154)-B(210)-B(276)-B(278)-2*B(280)
! JVS(371) = Jac_FULL(56,63)
  JVS(371) = B(172)
! JVS(372) = Jac_FULL(56,67)
  JVS(372) = -B(277)
! JVS(373) = Jac_FULL(56,68)
  JVS(373) = -B(279)
! JVS(374) = Jac_FULL(56,69)
  JVS(374) = -B(211)
! JVS(375) = Jac_FULL(56,70)
  JVS(375) = 0
! JVS(376) = Jac_FULL(56,71)
  JVS(376) = B(169)+B(171)+B(173)+B(284)+B(300)
! JVS(377) = Jac_FULL(56,73)
  JVS(377) = -B(155)
! JVS(378) = Jac_FULL(56,74)
  JVS(378) = 0
! JVS(379) = Jac_FULL(57,27)
  JVS(379) = B(338)
! JVS(380) = Jac_FULL(57,33)
  JVS(380) = 0
! JVS(381) = Jac_FULL(57,39)
  JVS(381) = 0
! JVS(382) = Jac_FULL(57,43)
  JVS(382) = 0.45*B(148)+0.45*B(233)+0.45*B(256)
! JVS(383) = Jac_FULL(57,44)
  JVS(383) = 0.9*B(324)
! JVS(384) = Jac_FULL(57,53)
  JVS(384) = 0.17*B(146)+0.17*B(231)+0.17*B(254)
! JVS(385) = Jac_FULL(57,55)
  JVS(385) = 0.5*B(326)+B(330)
! JVS(386) = Jac_FULL(57,57)
  JVS(386) = -B(19)-B(106)-B(162)
! JVS(387) = Jac_FULL(57,59)
  JVS(387) = 0.11*B(144)+0.055*B(235)+0.11*B(258)
! JVS(388) = Jac_FULL(57,62)
  JVS(388) = 0
! JVS(389) = Jac_FULL(57,64)
  JVS(389) = B(152)+0.75*B(227)+B(251)
! JVS(390) = Jac_FULL(57,67)
  JVS(390) = 0.75*B(228)+0.17*B(232)+0.45*B(234)+0.055*B(236)
! JVS(391) = Jac_FULL(57,68)
  JVS(391) = B(252)+0.17*B(255)+0.45*B(257)+0.11*B(259)
! JVS(392) = Jac_FULL(57,69)
  JVS(392) = 0
! JVS(393) = Jac_FULL(57,70)
  JVS(393) = -B(107)+B(339)
! JVS(394) = Jac_FULL(57,71)
  JVS(394) = -B(163)
! JVS(395) = Jac_FULL(57,72)
  JVS(395) = 0
! JVS(396) = Jac_FULL(57,73)
  JVS(396) = 0.11*B(145)+0.17*B(147)+0.45*B(149)+B(153)+0.5*B(327)
! JVS(397) = Jac_FULL(57,74)
  JVS(397) = 0.9*B(325)
! JVS(398) = Jac_FULL(58,17)
  JVS(398) = 0.009*B(80)
! JVS(399) = Jac_FULL(58,18)
  JVS(399) = B(340)
! JVS(400) = Jac_FULL(58,22)
  JVS(400) = B(13)+0.5*B(110)
! JVS(401) = Jac_FULL(58,28)
  JVS(401) = B(116)
! JVS(402) = Jac_FULL(58,31)
  JVS(402) = B(176)
! JVS(403) = Jac_FULL(58,32)
  JVS(403) = B(313)+B(317)
! JVS(404) = Jac_FULL(58,33)
  JVS(404) = 0
! JVS(405) = Jac_FULL(58,37)
  JVS(405) = 0.04*B(301)
! JVS(406) = Jac_FULL(58,38)
  JVS(406) = 0.53*B(178)
! JVS(407) = Jac_FULL(58,39)
  JVS(407) = 0.58*B(182)
! JVS(408) = Jac_FULL(58,41)
  JVS(408) = B(272)
! JVS(409) = Jac_FULL(58,42)
  JVS(409) = 0.13*B(17)+0.45*B(18)
! JVS(410) = Jac_FULL(58,43)
  JVS(410) = B(233)
! JVS(411) = Jac_FULL(58,46)
  JVS(411) = 0.77*B(217)
! JVS(412) = Jac_FULL(58,47)
  JVS(412) = 0.04*B(134)+0.8*B(219)
! JVS(413) = Jac_FULL(58,48)
  JVS(413) = 0.28*B(140)+0.89*B(225)+0.14*B(249)
! JVS(414) = Jac_FULL(58,50)
  JVS(414) = 1.6*B(136)+1.55*B(221)+0.8*B(245)
! JVS(415) = Jac_FULL(58,51)
  JVS(415) = B(138)+1.25*B(223)+0.5*B(247)
! JVS(416) = Jac_FULL(58,52)
  JVS(416) = B(262)
! JVS(417) = Jac_FULL(58,53)
  JVS(417) = B(231)
! JVS(418) = Jac_FULL(58,55)
  JVS(418) = 0.75*B(326)+0.5*B(330)
! JVS(419) = Jac_FULL(58,56)
  JVS(419) = B(154)+1.75*B(276)+B(278)+2*B(280)
! JVS(420) = Jac_FULL(58,58)
  JVS(420) = -B(10)-B(11)-B(98)-B(156)
! JVS(421) = Jac_FULL(58,59)
  JVS(421) = 0.5*B(235)
! JVS(422) = Jac_FULL(58,60)
  JVS(422) = B(291)
! JVS(423) = Jac_FULL(58,62)
  JVS(423) = 0.25*B(303)+1.4*B(307)+0.4*B(309)+0.4*B(311)
! JVS(424) = Jac_FULL(58,63)
  JVS(424) = 0.18*B(180)
! JVS(425) = Jac_FULL(58,64)
  JVS(425) = 0.75*B(227)
! JVS(426) = Jac_FULL(58,66)
  JVS(426) = 0.75*B(213)
! JVS(427) = Jac_FULL(58,67)
  JVS(427) = B(128)+1.5*B(212)+0.75*B(214)+0.84*B(215)+0.77*B(218)+0.8*B(220)+1.55*B(222)+1.25*B(224)+0.89*B(226)+0.75&
               &*B(228)+B(229)+B(232)+B(234)+0.5*B(236)+B(263)+B(273)+1.75*B(277)+B(292)+1.4*B(308)
! JVS(428) = Jac_FULL(58,68)
  JVS(428) = B(230)+0.8*B(246)+0.5*B(248)+0.14*B(250)+B(279)+0.4*B(310)
! JVS(429) = Jac_FULL(58,69)
  JVS(429) = 0
! JVS(430) = Jac_FULL(58,70)
  JVS(430) = 0.009*B(81)-B(99)+0.5*B(111)+B(117)+B(341)
! JVS(431) = Jac_FULL(58,71)
  JVS(431) = -B(157)+0.4*B(312)
! JVS(432) = Jac_FULL(58,72)
  JVS(432) = 0
! JVS(433) = Jac_FULL(58,73)
  JVS(433) = B(129)+0.09*B(130)+0.04*B(135)+1.6*B(137)+B(139)+0.28*B(141)+B(155)+0.25*B(304)+B(314)+0.75*B(327)
! JVS(434) = Jac_FULL(58,74)
  JVS(434) = B(177)+0.53*B(179)+0.18*B(181)+0.58*B(183)+0.04*B(302)
! JVS(435) = Jac_FULL(58,76)
  JVS(435) = 0.09*B(131)+0.84*B(216)
! JVS(436) = Jac_FULL(59,14)
  JVS(436) = B(127)
! JVS(437) = Jac_FULL(59,25)
  JVS(437) = 0.9*B(96)
! JVS(438) = Jac_FULL(59,45)
  JVS(438) = B(20)+B(108)+B(164)
! JVS(439) = Jac_FULL(59,53)
  JVS(439) = 0
! JVS(440) = Jac_FULL(59,59)
  JVS(440) = -B(125)-B(144)-B(208)-B(235)-B(258)
! JVS(441) = Jac_FULL(59,67)
  JVS(441) = -B(236)
! JVS(442) = Jac_FULL(59,68)
  JVS(442) = -B(259)
! JVS(443) = Jac_FULL(59,69)
  JVS(443) = -B(209)
! JVS(444) = Jac_FULL(59,70)
  JVS(444) = 0.9*B(97)+B(109)
! JVS(445) = Jac_FULL(59,71)
  JVS(445) = B(165)
! JVS(446) = Jac_FULL(59,72)
  JVS(446) = -B(126)
! JVS(447) = Jac_FULL(59,73)
  JVS(447) = -B(145)
! JVS(448) = Jac_FULL(60,35)
  JVS(448) = B(281)
! JVS(449) = Jac_FULL(60,60)
  JVS(449) = -B(287)-B(289)-B(291)-B(293)-B(295)
! JVS(450) = Jac_FULL(60,67)
  JVS(450) = -B(292)
! JVS(451) = Jac_FULL(60,68)
  JVS(451) = -B(294)
! JVS(452) = Jac_FULL(60,69)
  JVS(452) = -B(290)
! JVS(453) = Jac_FULL(60,70)
  JVS(453) = B(282)
! JVS(454) = Jac_FULL(60,71)
  JVS(454) = -B(296)
! JVS(455) = Jac_FULL(60,73)
  JVS(455) = -B(288)
! JVS(456) = Jac_FULL(60,74)
  JVS(456) = 0
! JVS(457) = Jac_FULL(61,8)
  JVS(457) = B(78)
! JVS(458) = Jac_FULL(61,10)
  JVS(458) = B(82)
! JVS(459) = Jac_FULL(61,11)
  JVS(459) = B(84)
! JVS(460) = Jac_FULL(61,17)
  JVS(460) = B(80)
! JVS(461) = Jac_FULL(61,19)
  JVS(461) = -B(30)
! JVS(462) = Jac_FULL(61,20)
  JVS(462) = -B(62)
! JVS(463) = Jac_FULL(61,21)
  JVS(463) = B(114)
! JVS(464) = Jac_FULL(61,24)
  JVS(464) = B(76)
! JVS(465) = Jac_FULL(61,26)
  JVS(465) = B(68)
! JVS(466) = Jac_FULL(61,30)
  JVS(466) = B(45)
! JVS(467) = Jac_FULL(61,34)
  JVS(467) = 0
! JVS(468) = Jac_FULL(61,35)
  JVS(468) = 0
! JVS(469) = Jac_FULL(61,37)
  JVS(469) = 0
! JVS(470) = Jac_FULL(61,38)
  JVS(470) = 0
! JVS(471) = Jac_FULL(61,39)
  JVS(471) = 0
! JVS(472) = Jac_FULL(61,40)
  JVS(472) = B(66)
! JVS(473) = Jac_FULL(61,42)
  JVS(473) = B(104)
! JVS(474) = Jac_FULL(61,45)
  JVS(474) = B(108)
! JVS(475) = Jac_FULL(61,49)
  JVS(475) = B(102)
! JVS(476) = Jac_FULL(61,53)
  JVS(476) = 0
! JVS(477) = Jac_FULL(61,57)
  JVS(477) = B(106)
! JVS(478) = Jac_FULL(61,58)
  JVS(478) = B(98)
! JVS(479) = Jac_FULL(61,59)
  JVS(479) = 0
! JVS(480) = Jac_FULL(61,60)
  JVS(480) = 0
! JVS(481) = Jac_FULL(61,61)
  JVS(481) = -B(31)-B(63)
! JVS(482) = Jac_FULL(61,62)
  JVS(482) = 0
! JVS(483) = Jac_FULL(61,63)
  JVS(483) = 0
! JVS(484) = Jac_FULL(61,64)
  JVS(484) = 0
! JVS(485) = Jac_FULL(61,65)
  JVS(485) = B(100)
! JVS(486) = Jac_FULL(61,66)
  JVS(486) = 0
! JVS(487) = Jac_FULL(61,67)
  JVS(487) = 0
! JVS(488) = Jac_FULL(61,68)
  JVS(488) = 0
! JVS(489) = Jac_FULL(61,69)
  JVS(489) = B(70)
! JVS(490) = Jac_FULL(61,70)
  JVS(490) = B(46)+B(67)+B(69)+B(71)+B(77)+B(79)+B(81)+B(83)+B(85)+B(99)+B(101)+B(103)+B(105)+B(107)+B(109)+B(115)
! JVS(491) = Jac_FULL(61,71)
  JVS(491) = 0
! JVS(492) = Jac_FULL(61,72)
  JVS(492) = 0
! JVS(493) = Jac_FULL(61,73)
  JVS(493) = 0
! JVS(494) = Jac_FULL(61,74)
  JVS(494) = 0
! JVS(495) = Jac_FULL(61,75)
  JVS(495) = 0
! JVS(496) = Jac_FULL(61,76)
  JVS(496) = 0
! JVS(497) = Jac_FULL(62,37)
  JVS(497) = B(297)
! JVS(498) = Jac_FULL(62,62)
  JVS(498) = -B(303)-B(305)-B(307)-B(309)-B(311)
! JVS(499) = Jac_FULL(62,67)
  JVS(499) = -B(308)
! JVS(500) = Jac_FULL(62,68)
  JVS(500) = -B(310)
! JVS(501) = Jac_FULL(62,69)
  JVS(501) = -B(306)
! JVS(502) = Jac_FULL(62,70)
  JVS(502) = B(298)
! JVS(503) = Jac_FULL(62,71)
  JVS(503) = -B(312)
! JVS(504) = Jac_FULL(62,73)
  JVS(504) = -B(304)
! JVS(505) = Jac_FULL(62,74)
  JVS(505) = 0
! JVS(506) = Jac_FULL(63,62)
  JVS(506) = 0.25*B(303)+0.4*B(307)+0.4*B(309)+0.4*B(311)
! JVS(507) = Jac_FULL(63,63)
  JVS(507) = -B(90)-B(172)-B(180)
! JVS(508) = Jac_FULL(63,67)
  JVS(508) = 0.4*B(308)
! JVS(509) = Jac_FULL(63,68)
  JVS(509) = 0.4*B(310)
! JVS(510) = Jac_FULL(63,69)
  JVS(510) = 0
! JVS(511) = Jac_FULL(63,70)
  JVS(511) = -B(91)
! JVS(512) = Jac_FULL(63,71)
  JVS(512) = -B(173)+0.4*B(312)
! JVS(513) = Jac_FULL(63,73)
  JVS(513) = 0.25*B(304)
! JVS(514) = Jac_FULL(63,74)
  JVS(514) = -B(181)
! JVS(515) = Jac_FULL(64,35)
  JVS(515) = 0.42*B(285)
! JVS(516) = Jac_FULL(64,37)
  JVS(516) = 0.42*B(301)
! JVS(517) = Jac_FULL(64,49)
  JVS(517) = B(102)
! JVS(518) = Jac_FULL(64,60)
  JVS(518) = 0
! JVS(519) = Jac_FULL(64,63)
  JVS(519) = 0
! JVS(520) = Jac_FULL(64,64)
  JVS(520) = -B(152)-B(200)-B(227)-B(251)
! JVS(521) = Jac_FULL(64,67)
  JVS(521) = -B(228)
! JVS(522) = Jac_FULL(64,68)
  JVS(522) = -B(252)
! JVS(523) = Jac_FULL(64,69)
  JVS(523) = -B(201)
! JVS(524) = Jac_FULL(64,70)
  JVS(524) = B(103)
! JVS(525) = Jac_FULL(64,71)
  JVS(525) = 0
! JVS(526) = Jac_FULL(64,73)
  JVS(526) = -B(153)
! JVS(527) = Jac_FULL(64,74)
  JVS(527) = 0.42*B(286)+0.42*B(302)
! JVS(528) = Jac_FULL(64,75)
  JVS(528) = 0
! JVS(529) = Jac_FULL(64,76)
  JVS(529) = 0
! JVS(530) = Jac_FULL(65,17)
  JVS(530) = 0.075*B(80)
! JVS(531) = Jac_FULL(65,35)
  JVS(531) = 0.65*B(285)
! JVS(532) = Jac_FULL(65,38)
  JVS(532) = 0.5*B(178)
! JVS(533) = Jac_FULL(65,46)
  JVS(533) = 0.38*B(132)+0.41*B(217)+0.41*B(241)
! JVS(534) = Jac_FULL(65,47)
  JVS(534) = 0.35*B(134)+0.46*B(219)+0.46*B(243)
! JVS(535) = Jac_FULL(65,48)
  JVS(535) = 1.45*B(140)+0.725*B(225)+0.725*B(249)
! JVS(536) = Jac_FULL(65,50)
  JVS(536) = 0.2*B(136)+0.35*B(221)+0.6*B(245)
! JVS(537) = Jac_FULL(65,51)
  JVS(537) = B(138)+0.75*B(223)+B(247)
! JVS(538) = Jac_FULL(65,54)
  JVS(538) = B(14)+0.5*B(112)
! JVS(539) = Jac_FULL(65,56)
  JVS(539) = B(154)+B(276)+B(278)+2*B(280)
! JVS(540) = Jac_FULL(65,59)
  JVS(540) = 0
! JVS(541) = Jac_FULL(65,60)
  JVS(541) = 0.8*B(287)+B(291)+B(293)+B(295)
! JVS(542) = Jac_FULL(65,62)
  JVS(542) = 0
! JVS(543) = Jac_FULL(65,63)
  JVS(543) = 0.72*B(180)
! JVS(544) = Jac_FULL(65,64)
  JVS(544) = 0
! JVS(545) = Jac_FULL(65,65)
  JVS(545) = -B(12)-B(100)-B(158)
! JVS(546) = Jac_FULL(65,66)
  JVS(546) = B(150)+0.75*B(213)+B(237)
! JVS(547) = Jac_FULL(65,67)
  JVS(547) = 0.75*B(214)+0.77*B(215)+0.41*B(218)+0.46*B(220)+0.35*B(222)+0.75*B(224)+0.725*B(226)+B(277)+B(292)
! JVS(548) = Jac_FULL(65,68)
  JVS(548) = B(238)+0.77*B(239)+0.41*B(242)+0.46*B(244)+0.6*B(246)+B(248)+0.725*B(250)+B(279)+B(294)
! JVS(549) = Jac_FULL(65,69)
  JVS(549) = 0
! JVS(550) = Jac_FULL(65,70)
  JVS(550) = 0.075*B(81)-B(101)+0.5*B(113)
! JVS(551) = Jac_FULL(65,71)
  JVS(551) = -B(159)+B(296)
! JVS(552) = Jac_FULL(65,72)
  JVS(552) = 0
! JVS(553) = Jac_FULL(65,73)
  JVS(553) = 0.75*B(130)+0.38*B(133)+0.35*B(135)+0.2*B(137)+B(139)+1.45*B(141)+B(151)+B(155)+0.8*B(288)
! JVS(554) = Jac_FULL(65,74)
  JVS(554) = 0.5*B(179)+0.72*B(181)+0.65*B(286)
! JVS(555) = Jac_FULL(65,75)
  JVS(555) = 0.2*B(21)
! JVS(556) = Jac_FULL(65,76)
  JVS(556) = 0.75*B(131)+0.77*B(216)+0.77*B(240)
! JVS(557) = Jac_FULL(66,8)
  JVS(557) = B(78)
! JVS(558) = Jac_FULL(66,35)
  JVS(558) = 0.2*B(285)
! JVS(559) = Jac_FULL(66,37)
  JVS(559) = 0.16*B(301)
! JVS(560) = Jac_FULL(66,49)
  JVS(560) = B(16)
! JVS(561) = Jac_FULL(66,60)
  JVS(561) = 0
! JVS(562) = Jac_FULL(66,63)
  JVS(562) = 0
! JVS(563) = Jac_FULL(66,66)
  JVS(563) = -B(150)-B(186)-B(213)-B(237)
! JVS(564) = Jac_FULL(66,67)
  JVS(564) = -B(214)
! JVS(565) = Jac_FULL(66,68)
  JVS(565) = -B(238)
! JVS(566) = Jac_FULL(66,69)
  JVS(566) = -B(187)
! JVS(567) = Jac_FULL(66,70)
  JVS(567) = B(79)
! JVS(568) = Jac_FULL(66,71)
  JVS(568) = 0
! JVS(569) = Jac_FULL(66,73)
  JVS(569) = -B(151)
! JVS(570) = Jac_FULL(66,74)
  JVS(570) = 0.2*B(286)+0.16*B(302)
! JVS(571) = Jac_FULL(66,75)
  JVS(571) = 0
! JVS(572) = Jac_FULL(66,76)
  JVS(572) = 0
! JVS(573) = Jac_FULL(67,21)
  JVS(573) = B(15)
! JVS(574) = Jac_FULL(67,22)
  JVS(574) = 0.5*B(110)
! JVS(575) = Jac_FULL(67,24)
  JVS(575) = B(76)
! JVS(576) = Jac_FULL(67,38)
  JVS(576) = 0.22*B(178)
! JVS(577) = Jac_FULL(67,39)
  JVS(577) = 0.08*B(182)
! JVS(578) = Jac_FULL(67,41)
  JVS(578) = -B(272)+B(274)
! JVS(579) = Jac_FULL(67,43)
  JVS(579) = -B(233)+B(256)
! JVS(580) = Jac_FULL(67,46)
  JVS(580) = -B(217)+0.5*B(241)
! JVS(581) = Jac_FULL(67,47)
  JVS(581) = -B(219)+0.5*B(243)
! JVS(582) = Jac_FULL(67,48)
  JVS(582) = -B(225)+0.5*B(249)
! JVS(583) = Jac_FULL(67,50)
  JVS(583) = -B(221)+0.5*B(245)
! JVS(584) = Jac_FULL(67,51)
  JVS(584) = -B(223)+0.5*B(247)
! JVS(585) = Jac_FULL(67,52)
  JVS(585) = -B(262)+B(264)
! JVS(586) = Jac_FULL(67,53)
  JVS(586) = -B(231)+B(254)
! JVS(587) = Jac_FULL(67,56)
  JVS(587) = -B(276)+0.5*B(278)
! JVS(588) = Jac_FULL(67,59)
  JVS(588) = -B(235)+B(258)
! JVS(589) = Jac_FULL(67,60)
  JVS(589) = -B(291)+B(293)
! JVS(590) = Jac_FULL(67,62)
  JVS(590) = -B(307)+B(309)
! JVS(591) = Jac_FULL(67,63)
  JVS(591) = 0.31*B(180)
! JVS(592) = Jac_FULL(67,64)
  JVS(592) = -B(227)+0.5*B(251)
! JVS(593) = Jac_FULL(67,65)
  JVS(593) = B(12)
! JVS(594) = Jac_FULL(67,66)
  JVS(594) = -B(213)+0.5*B(237)
! JVS(595) = Jac_FULL(67,67)
  JVS(595) = -B(128)-B(184)-2*B(212)-B(214)-B(215)-B(218)-B(220)-B(222)-B(224)-B(226)-B(228)-0.5*B(229)-B(232)-B(234)&
               &-B(236)-B(263)-B(273)-B(277)-B(292)-B(308)
! JVS(596) = Jac_FULL(67,68)
  JVS(596) = B(142)-0.5*B(230)+0.5*B(238)+0.5*B(239)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)+0.5*B(252)+2&
               &*B(253)+B(255)+B(257)+B(259)+B(265)+B(275)+0.5*B(279)+B(294)+B(310)
! JVS(597) = Jac_FULL(67,69)
  JVS(597) = -B(185)
! JVS(598) = Jac_FULL(67,70)
  JVS(598) = B(77)+0.5*B(111)
! JVS(599) = Jac_FULL(67,71)
  JVS(599) = 0
! JVS(600) = Jac_FULL(67,72)
  JVS(600) = 0
! JVS(601) = Jac_FULL(67,73)
  JVS(601) = -B(129)+B(143)
! JVS(602) = Jac_FULL(67,74)
  JVS(602) = 0.22*B(179)+0.31*B(181)+0.08*B(183)
! JVS(603) = Jac_FULL(67,75)
  JVS(603) = 0
! JVS(604) = Jac_FULL(67,76)
  JVS(604) = -B(216)+0.5*B(240)
! JVS(605) = Jac_FULL(68,21)
  JVS(605) = B(114)
! JVS(606) = Jac_FULL(68,28)
  JVS(606) = B(124)
! JVS(607) = Jac_FULL(68,39)
  JVS(607) = 0.1*B(182)
! JVS(608) = Jac_FULL(68,41)
  JVS(608) = -B(274)
! JVS(609) = Jac_FULL(68,43)
  JVS(609) = -B(256)
! JVS(610) = Jac_FULL(68,44)
  JVS(610) = 0.1*B(324)
! JVS(611) = Jac_FULL(68,45)
  JVS(611) = 0.02*B(20)
! JVS(612) = Jac_FULL(68,46)
  JVS(612) = -B(241)
! JVS(613) = Jac_FULL(68,47)
  JVS(613) = -B(243)
! JVS(614) = Jac_FULL(68,48)
  JVS(614) = -B(249)
! JVS(615) = Jac_FULL(68,49)
  JVS(615) = B(16)
! JVS(616) = Jac_FULL(68,50)
  JVS(616) = -B(245)
! JVS(617) = Jac_FULL(68,51)
  JVS(617) = -B(247)
! JVS(618) = Jac_FULL(68,52)
  JVS(618) = -B(264)
! JVS(619) = Jac_FULL(68,53)
  JVS(619) = -B(254)
! JVS(620) = Jac_FULL(68,55)
  JVS(620) = 0.25*B(326)
! JVS(621) = Jac_FULL(68,56)
  JVS(621) = -B(278)
! JVS(622) = Jac_FULL(68,57)
  JVS(622) = B(19)+B(106)+B(162)
! JVS(623) = Jac_FULL(68,59)
  JVS(623) = 0.05*B(144)+0.03*B(235)-0.95*B(258)
! JVS(624) = Jac_FULL(68,60)
  JVS(624) = -B(293)
! JVS(625) = Jac_FULL(68,62)
  JVS(625) = -B(309)
! JVS(626) = Jac_FULL(68,63)
  JVS(626) = 0
! JVS(627) = Jac_FULL(68,64)
  JVS(627) = -B(251)
! JVS(628) = Jac_FULL(68,65)
  JVS(628) = B(100)+B(158)
! JVS(629) = Jac_FULL(68,66)
  JVS(629) = -B(237)
! JVS(630) = Jac_FULL(68,67)
  JVS(630) = -B(229)+0.03*B(236)
! JVS(631) = Jac_FULL(68,68)
  JVS(631) = -B(122)-B(142)-B(202)-B(230)-B(238)-B(239)-B(242)-B(244)-B(246)-B(248)-B(250)-B(252)-2*B(253)-B(255)-B(257)&
               &-0.95*B(259)-B(265)-B(275)-B(279)-B(294)-B(310)
! JVS(632) = Jac_FULL(68,69)
  JVS(632) = -B(203)
! JVS(633) = Jac_FULL(68,70)
  JVS(633) = B(101)+B(107)+B(115)
! JVS(634) = Jac_FULL(68,71)
  JVS(634) = B(159)+B(163)
! JVS(635) = Jac_FULL(68,72)
  JVS(635) = -B(123)
! JVS(636) = Jac_FULL(68,73)
  JVS(636) = -B(143)+0.05*B(145)+0.25*B(327)
! JVS(637) = Jac_FULL(68,74)
  JVS(637) = 0.1*B(183)+0.1*B(325)
! JVS(638) = Jac_FULL(68,75)
  JVS(638) = 0
! JVS(639) = Jac_FULL(68,76)
  JVS(639) = -B(240)
! JVS(640) = Jac_FULL(69,7)
  JVS(640) = B(72)
! JVS(641) = Jac_FULL(69,12)
  JVS(641) = 0.25*B(92)
! JVS(642) = Jac_FULL(69,13)
  JVS(642) = 0.17*B(94)
! JVS(643) = Jac_FULL(69,17)
  JVS(643) = 0.17*B(80)
! JVS(644) = Jac_FULL(69,22)
  JVS(644) = B(13)
! JVS(645) = Jac_FULL(69,25)
  JVS(645) = 0.1*B(96)
! JVS(646) = Jac_FULL(69,26)
  JVS(646) = B(6)
! JVS(647) = Jac_FULL(69,27)
  JVS(647) = B(338)
! JVS(648) = Jac_FULL(69,30)
  JVS(648) = B(45)
! JVS(649) = Jac_FULL(69,31)
  JVS(649) = 0.12*B(176)
! JVS(650) = Jac_FULL(69,32)
  JVS(650) = B(313)-B(315)+B(317)
! JVS(651) = Jac_FULL(69,33)
  JVS(651) = 0
! JVS(652) = Jac_FULL(69,35)
  JVS(652) = 0.1*B(285)
! JVS(653) = Jac_FULL(69,36)
  JVS(653) = B(74)
! JVS(654) = Jac_FULL(69,37)
  JVS(654) = 0.1*B(301)
! JVS(655) = Jac_FULL(69,38)
  JVS(655) = 0.23*B(178)
! JVS(656) = Jac_FULL(69,39)
  JVS(656) = 0.25*B(182)
! JVS(657) = Jac_FULL(69,41)
  JVS(657) = -B(270)+B(272)
! JVS(658) = Jac_FULL(69,42)
  JVS(658) = 0.8*B(18)+B(104)+B(160)
! JVS(659) = Jac_FULL(69,43)
  JVS(659) = B(148)-B(206)+2*B(233)+B(256)
! JVS(660) = Jac_FULL(69,44)
  JVS(660) = 0.32*B(324)
! JVS(661) = Jac_FULL(69,45)
  JVS(661) = 0.98*B(20)
! JVS(662) = Jac_FULL(69,46)
  JVS(662) = 0.92*B(132)-B(190)+B(217)+0.5*B(241)
! JVS(663) = Jac_FULL(69,47)
  JVS(663) = 0.76*B(134)-B(192)+B(219)+0.5*B(243)
! JVS(664) = Jac_FULL(69,48)
  JVS(664) = B(140)-B(198)+B(225)+0.5*B(249)
! JVS(665) = Jac_FULL(69,50)
  JVS(665) = B(136)-B(194)+B(221)+0.5*B(245)
! JVS(666) = Jac_FULL(69,51)
  JVS(666) = B(138)-B(196)+B(223)+0.5*B(247)
! JVS(667) = Jac_FULL(69,52)
  JVS(667) = -B(260)+B(262)
! JVS(668) = Jac_FULL(69,53)
  JVS(668) = B(146)-B(204)+2*B(231)+B(254)
! JVS(669) = Jac_FULL(69,54)
  JVS(669) = B(14)
! JVS(670) = Jac_FULL(69,55)
  JVS(670) = 0.75*B(326)-B(328)+B(330)
! JVS(671) = Jac_FULL(69,56)
  JVS(671) = -B(210)+0.5*B(276)
! JVS(672) = Jac_FULL(69,57)
  JVS(672) = B(19)
! JVS(673) = Jac_FULL(69,58)
  JVS(673) = 2*B(11)+B(98)+B(156)
! JVS(674) = Jac_FULL(69,59)
  JVS(674) = 0.92*B(144)-B(208)+0.46*B(235)+0.92*B(258)
! JVS(675) = Jac_FULL(69,60)
  JVS(675) = 0.8*B(287)-B(289)+2*B(291)+B(293)+B(295)
! JVS(676) = Jac_FULL(69,61)
  JVS(676) = -2*B(43)
! JVS(677) = Jac_FULL(69,62)
  JVS(677) = 0.65*B(303)-B(305)+2*B(307)+B(309)+B(311)
! JVS(678) = Jac_FULL(69,63)
  JVS(678) = 0.26*B(180)
! JVS(679) = Jac_FULL(69,64)
  JVS(679) = B(152)-B(200)+B(227)+0.5*B(251)
! JVS(680) = Jac_FULL(69,65)
  JVS(680) = B(12)
! JVS(681) = Jac_FULL(69,66)
  JVS(681) = B(150)-B(186)+B(213)+0.5*B(237)
! JVS(682) = Jac_FULL(69,67)
  JVS(682) = B(128)-B(184)+B(212)+B(214)+B(215)+B(218)+B(220)+B(222)+B(224)+B(226)+B(228)+0.5*B(229)+2*B(232)+2*B(234)&
               &+0.46*B(236)+B(263)+B(273)+0.5*B(277)+2*B(292)+2*B(308)
! JVS(683) = Jac_FULL(69,68)
  JVS(683) = -B(202)+0.5*B(230)+0.5*B(238)+0.5*B(239)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)+0.5*B(252)&
               &+B(255)+B(257)+0.92*B(259)+B(294)+B(310)
! JVS(684) = Jac_FULL(69,69)
  JVS(684) = -B(36)-B(38)-B(40)-2*B(42)-2*B(44)-B(57)-B(70)-B(185)-B(187)-B(188)-B(191)-B(193)-B(195)-B(197)-B(199)&
               &-B(201)-B(203)-B(205)-B(207)-B(209)-B(211)-B(261)-B(271)-B(290)-B(306)-B(316)-B(329)
! JVS(685) = Jac_FULL(69,70)
  JVS(685) = B(34)+B(46)-B(71)+B(73)+B(75)+0.17*B(81)+0.25*B(93)+0.17*B(95)+0.1*B(97)+B(99)+B(105)+B(339)
! JVS(686) = Jac_FULL(69,71)
  JVS(686) = -B(58)+B(157)+B(161)+B(296)+B(312)
! JVS(687) = Jac_FULL(69,72)
  JVS(687) = -B(41)
! JVS(688) = Jac_FULL(69,73)
  JVS(688) = -B(39)+B(129)+0.964*B(130)+0.92*B(133)+0.76*B(135)+B(137)+B(139)+B(141)+0.92*B(145)+B(147)+B(149)+B(151)&
               &+B(153)+0.8*B(288)+0.65*B(304)+B(314)+0.75*B(327)
! JVS(689) = Jac_FULL(69,74)
  JVS(689) = B(35)-B(37)+0.12*B(177)+0.23*B(179)+0.26*B(181)+0.25*B(183)+0.1*B(286)+0.1*B(302)+0.32*B(325)
! JVS(690) = Jac_FULL(69,75)
  JVS(690) = B(21)
! JVS(691) = Jac_FULL(69,76)
  JVS(691) = 0.964*B(131)-B(189)+B(216)+0.5*B(240)
! JVS(692) = Jac_FULL(70,7)
  JVS(692) = -B(72)
! JVS(693) = Jac_FULL(70,8)
  JVS(693) = -B(78)
! JVS(694) = Jac_FULL(70,10)
  JVS(694) = -B(82)
! JVS(695) = Jac_FULL(70,11)
  JVS(695) = -B(84)
! JVS(696) = Jac_FULL(70,12)
  JVS(696) = -B(92)
! JVS(697) = Jac_FULL(70,13)
  JVS(697) = -B(94)
! JVS(698) = Jac_FULL(70,15)
  JVS(698) = B(4)
! JVS(699) = Jac_FULL(70,16)
  JVS(699) = -B(336)
! JVS(700) = Jac_FULL(70,17)
  JVS(700) = -B(80)
! JVS(701) = Jac_FULL(70,18)
  JVS(701) = -B(340)
! JVS(702) = Jac_FULL(70,19)
  JVS(702) = 2*B(30)
! JVS(703) = Jac_FULL(70,21)
  JVS(703) = B(15)-B(114)
! JVS(704) = Jac_FULL(70,22)
  JVS(704) = B(13)-0.5*B(110)
! JVS(705) = Jac_FULL(70,23)
  JVS(705) = -B(334)
! JVS(706) = Jac_FULL(70,24)
  JVS(706) = -B(76)
! JVS(707) = Jac_FULL(70,25)
  JVS(707) = -1.9*B(96)
! JVS(708) = Jac_FULL(70,26)
  JVS(708) = -B(68)
! JVS(709) = Jac_FULL(70,27)
  JVS(709) = -B(338)
! JVS(710) = Jac_FULL(70,28)
  JVS(710) = -B(116)
! JVS(711) = Jac_FULL(70,30)
  JVS(711) = 2*B(9)-B(45)
! JVS(712) = Jac_FULL(70,31)
  JVS(712) = -B(86)
! JVS(713) = Jac_FULL(70,33)
  JVS(713) = -B(320)
! JVS(714) = Jac_FULL(70,34)
  JVS(714) = 0
! JVS(715) = Jac_FULL(70,35)
  JVS(715) = -B(281)+0.85*B(285)
! JVS(716) = Jac_FULL(70,36)
  JVS(716) = -B(74)
! JVS(717) = Jac_FULL(70,37)
  JVS(717) = -B(297)+0.85*B(301)
! JVS(718) = Jac_FULL(70,38)
  JVS(718) = -B(88)+0.1*B(178)
! JVS(719) = Jac_FULL(70,39)
  JVS(719) = -B(120)+0.25*B(182)
! JVS(720) = Jac_FULL(70,40)
  JVS(720) = B(5)-B(66)
! JVS(721) = Jac_FULL(70,42)
  JVS(721) = -B(104)
! JVS(722) = Jac_FULL(70,44)
  JVS(722) = -B(322)+0.19*B(324)
! JVS(723) = Jac_FULL(70,45)
  JVS(723) = -B(108)
! JVS(724) = Jac_FULL(70,49)
  JVS(724) = -B(102)
! JVS(725) = Jac_FULL(70,53)
  JVS(725) = 0
! JVS(726) = Jac_FULL(70,54)
  JVS(726) = B(14)-0.5*B(112)
! JVS(727) = Jac_FULL(70,55)
  JVS(727) = 0
! JVS(728) = Jac_FULL(70,57)
  JVS(728) = -B(106)
! JVS(729) = Jac_FULL(70,58)
  JVS(729) = -B(98)
! JVS(730) = Jac_FULL(70,59)
  JVS(730) = 0
! JVS(731) = Jac_FULL(70,60)
  JVS(731) = 0
! JVS(732) = Jac_FULL(70,61)
  JVS(732) = 2*B(31)
! JVS(733) = Jac_FULL(70,62)
  JVS(733) = 0
! JVS(734) = Jac_FULL(70,63)
  JVS(734) = -B(90)+0.14*B(180)
! JVS(735) = Jac_FULL(70,64)
  JVS(735) = 0
! JVS(736) = Jac_FULL(70,65)
  JVS(736) = -B(100)
! JVS(737) = Jac_FULL(70,66)
  JVS(737) = 0
! JVS(738) = Jac_FULL(70,67)
  JVS(738) = 0
! JVS(739) = Jac_FULL(70,68)
  JVS(739) = 0
! JVS(740) = Jac_FULL(70,69)
  JVS(740) = B(36)+B(38)-B(70)
! JVS(741) = Jac_FULL(70,70)
  JVS(741) = -B(34)-B(46)-B(47)-B(64)-B(67)-B(69)-B(71)-B(73)-B(75)-B(77)-B(79)-B(81)-B(83)-B(85)-B(87)-B(89)-B(91)&
               &-B(93)-B(95)-1.9*B(97)-B(99)-B(101)-B(103)-B(105)-B(107)-B(109)-0.5*B(111)-0.5*B(113)-B(115)-B(117)-B(118)&
               &-B(121)-B(282)-B(298)-B(321)-B(323)-B(335)-B(337)-B(339)-B(341)
! JVS(742) = Jac_FULL(70,71)
  JVS(742) = 0
! JVS(743) = Jac_FULL(70,72)
  JVS(743) = -B(65)
! JVS(744) = Jac_FULL(70,73)
  JVS(744) = B(39)-B(48)
! JVS(745) = Jac_FULL(70,74)
  JVS(745) = -B(35)+B(37)+0.1*B(179)+0.14*B(181)+0.25*B(183)+0.85*B(286)+0.85*B(302)+0.19*B(325)
! JVS(746) = Jac_FULL(70,75)
  JVS(746) = -B(119)
! JVS(747) = Jac_FULL(70,76)
  JVS(747) = 0
! JVS(748) = Jac_FULL(71,20)
  JVS(748) = B(61)
! JVS(749) = Jac_FULL(71,25)
  JVS(749) = -B(166)
! JVS(750) = Jac_FULL(71,28)
  JVS(750) = B(116)
! JVS(751) = Jac_FULL(71,31)
  JVS(751) = -B(168)
! JVS(752) = Jac_FULL(71,35)
  JVS(752) = -B(283)
! JVS(753) = Jac_FULL(71,37)
  JVS(753) = -B(299)
! JVS(754) = Jac_FULL(71,38)
  JVS(754) = -B(170)
! JVS(755) = Jac_FULL(71,39)
  JVS(755) = -B(174)
! JVS(756) = Jac_FULL(71,40)
  JVS(756) = B(66)
! JVS(757) = Jac_FULL(71,42)
  JVS(757) = -B(160)
! JVS(758) = Jac_FULL(71,45)
  JVS(758) = -B(164)
! JVS(759) = Jac_FULL(71,53)
  JVS(759) = 0
! JVS(760) = Jac_FULL(71,57)
  JVS(760) = -B(162)
! JVS(761) = Jac_FULL(71,58)
  JVS(761) = -B(156)
! JVS(762) = Jac_FULL(71,59)
  JVS(762) = 0
! JVS(763) = Jac_FULL(71,60)
  JVS(763) = -B(295)
! JVS(764) = Jac_FULL(71,61)
  JVS(764) = 0
! JVS(765) = Jac_FULL(71,62)
  JVS(765) = -B(311)
! JVS(766) = Jac_FULL(71,63)
  JVS(766) = -B(172)
! JVS(767) = Jac_FULL(71,64)
  JVS(767) = 0
! JVS(768) = Jac_FULL(71,65)
  JVS(768) = -B(158)
! JVS(769) = Jac_FULL(71,66)
  JVS(769) = 0
! JVS(770) = Jac_FULL(71,67)
  JVS(770) = 0
! JVS(771) = Jac_FULL(71,68)
  JVS(771) = 0
! JVS(772) = Jac_FULL(71,69)
  JVS(772) = -B(57)
! JVS(773) = Jac_FULL(71,70)
  JVS(773) = B(67)+B(117)
! JVS(774) = Jac_FULL(71,71)
  JVS(774) = -B(7)-B(8)-B(53)-B(55)-B(58)-B(59)-B(157)-B(159)-B(161)-B(163)-B(165)-B(167)-B(169)-B(171)-B(173)-B(175)&
               &-B(284)-B(296)-B(300)-B(312)
! JVS(775) = Jac_FULL(71,72)
  JVS(775) = B(51)-B(56)-B(60)
! JVS(776) = Jac_FULL(71,73)
  JVS(776) = -B(54)
! JVS(777) = Jac_FULL(71,74)
  JVS(777) = B(52)
! JVS(778) = Jac_FULL(71,75)
  JVS(778) = 0
! JVS(779) = Jac_FULL(71,76)
  JVS(779) = 0
! JVS(780) = Jac_FULL(72,14)
  JVS(780) = B(127)
! JVS(781) = Jac_FULL(72,18)
  JVS(781) = B(340)
! JVS(782) = Jac_FULL(72,20)
  JVS(782) = B(61)
! JVS(783) = Jac_FULL(72,23)
  JVS(783) = B(333)+B(334)
! JVS(784) = Jac_FULL(72,26)
  JVS(784) = B(6)+B(68)
! JVS(785) = Jac_FULL(72,28)
  JVS(785) = B(124)
! JVS(786) = Jac_FULL(72,29)
  JVS(786) = -B(24)
! JVS(787) = Jac_FULL(72,32)
  JVS(787) = B(313)
! JVS(788) = Jac_FULL(72,33)
  JVS(788) = 0
! JVS(789) = Jac_FULL(72,34)
  JVS(789) = 2*B(49)
! JVS(790) = Jac_FULL(72,39)
  JVS(790) = 0
! JVS(791) = Jac_FULL(72,40)
  JVS(791) = B(5)
! JVS(792) = Jac_FULL(72,41)
  JVS(792) = -B(268)
! JVS(793) = Jac_FULL(72,42)
  JVS(793) = 0
! JVS(794) = Jac_FULL(72,43)
  JVS(794) = B(148)
! JVS(795) = Jac_FULL(72,45)
  JVS(795) = 0
! JVS(796) = Jac_FULL(72,46)
  JVS(796) = 0.92*B(132)
! JVS(797) = Jac_FULL(72,47)
  JVS(797) = 0.76*B(134)
! JVS(798) = Jac_FULL(72,48)
  JVS(798) = B(140)
! JVS(799) = Jac_FULL(72,50)
  JVS(799) = B(136)
! JVS(800) = Jac_FULL(72,51)
  JVS(800) = B(138)
! JVS(801) = Jac_FULL(72,52)
  JVS(801) = B(266)
! JVS(802) = Jac_FULL(72,53)
  JVS(802) = B(146)
! JVS(803) = Jac_FULL(72,55)
  JVS(803) = B(326)-B(331)
! JVS(804) = Jac_FULL(72,56)
  JVS(804) = 2*B(154)+B(276)+B(278)+2*B(280)
! JVS(805) = Jac_FULL(72,57)
  JVS(805) = 0
! JVS(806) = Jac_FULL(72,58)
  JVS(806) = 0
! JVS(807) = Jac_FULL(72,59)
  JVS(807) = -B(125)+B(144)
! JVS(808) = Jac_FULL(72,60)
  JVS(808) = 0.8*B(287)+B(295)
! JVS(809) = Jac_FULL(72,61)
  JVS(809) = 0
! JVS(810) = Jac_FULL(72,62)
  JVS(810) = 0.65*B(303)+B(311)
! JVS(811) = Jac_FULL(72,63)
  JVS(811) = 0
! JVS(812) = Jac_FULL(72,64)
  JVS(812) = B(152)
! JVS(813) = Jac_FULL(72,65)
  JVS(813) = 0
! JVS(814) = Jac_FULL(72,66)
  JVS(814) = B(150)
! JVS(815) = Jac_FULL(72,67)
  JVS(815) = B(128)+B(277)
! JVS(816) = Jac_FULL(72,68)
  JVS(816) = -B(122)+B(142)+B(279)
! JVS(817) = Jac_FULL(72,69)
  JVS(817) = B(38)-B(40)
! JVS(818) = Jac_FULL(72,70)
  JVS(818) = -B(64)+B(69)+B(118)+B(335)+B(341)
! JVS(819) = Jac_FULL(72,71)
  JVS(819) = B(8)+2*B(53)-B(59)+B(296)+B(312)
! JVS(820) = Jac_FULL(72,72)
  JVS(820) = -B(1)-B(25)-B(41)-B(51)-B(60)-B(65)-B(123)-B(126)-B(269)-B(332)
! JVS(821) = Jac_FULL(72,73)
  JVS(821) = B(32)+B(39)+2*B(50)+2*B(54)+B(129)+0.964*B(130)+0.92*B(133)+0.76*B(135)+B(137)+B(139)+B(141)+B(143)+B(145)&
               &+B(147)+B(149)+B(151)+B(153)+2*B(155)+B(267)+0.8*B(288)+0.65*B(304)+B(314)+B(327)
! JVS(822) = Jac_FULL(72,74)
  JVS(822) = B(33)-B(52)
! JVS(823) = Jac_FULL(72,75)
  JVS(823) = B(21)+B(119)
! JVS(824) = Jac_FULL(72,76)
  JVS(824) = 0.964*B(131)
! JVS(825) = Jac_FULL(73,15)
  JVS(825) = B(4)
! JVS(826) = Jac_FULL(73,29)
  JVS(826) = B(24)
! JVS(827) = Jac_FULL(73,32)
  JVS(827) = -B(313)
! JVS(828) = Jac_FULL(73,34)
  JVS(828) = -2*B(49)
! JVS(829) = Jac_FULL(73,39)
  JVS(829) = 0
! JVS(830) = Jac_FULL(73,43)
  JVS(830) = -B(148)
! JVS(831) = Jac_FULL(73,46)
  JVS(831) = -B(132)
! JVS(832) = Jac_FULL(73,47)
  JVS(832) = -B(134)
! JVS(833) = Jac_FULL(73,48)
  JVS(833) = -B(140)
! JVS(834) = Jac_FULL(73,50)
  JVS(834) = -B(136)
! JVS(835) = Jac_FULL(73,51)
  JVS(835) = -B(138)
! JVS(836) = Jac_FULL(73,52)
  JVS(836) = -B(266)
! JVS(837) = Jac_FULL(73,53)
  JVS(837) = -B(146)
! JVS(838) = Jac_FULL(73,55)
  JVS(838) = -B(326)
! JVS(839) = Jac_FULL(73,56)
  JVS(839) = -B(154)
! JVS(840) = Jac_FULL(73,59)
  JVS(840) = -B(144)
! JVS(841) = Jac_FULL(73,60)
  JVS(841) = -B(287)
! JVS(842) = Jac_FULL(73,61)
  JVS(842) = 0
! JVS(843) = Jac_FULL(73,62)
  JVS(843) = -B(303)
! JVS(844) = Jac_FULL(73,63)
  JVS(844) = 0
! JVS(845) = Jac_FULL(73,64)
  JVS(845) = -B(152)
! JVS(846) = Jac_FULL(73,65)
  JVS(846) = 0
! JVS(847) = Jac_FULL(73,66)
  JVS(847) = -B(150)
! JVS(848) = Jac_FULL(73,67)
  JVS(848) = -B(128)
! JVS(849) = Jac_FULL(73,68)
  JVS(849) = -B(142)
! JVS(850) = Jac_FULL(73,69)
  JVS(850) = -B(38)
! JVS(851) = Jac_FULL(73,70)
  JVS(851) = -B(47)
! JVS(852) = Jac_FULL(73,71)
  JVS(852) = B(7)-B(53)+B(55)
! JVS(853) = Jac_FULL(73,72)
  JVS(853) = B(1)+B(25)+B(56)
! JVS(854) = Jac_FULL(73,73)
  JVS(854) = -B(32)-B(39)-B(48)-2*B(50)-B(54)-B(129)-B(130)-B(133)-B(135)-B(137)-B(139)-B(141)-B(143)-B(145)-B(147)&
               &-B(149)-B(151)-B(153)-B(155)-B(267)-B(288)-B(304)-B(314)-B(327)
! JVS(855) = Jac_FULL(73,74)
  JVS(855) = -B(33)
! JVS(856) = Jac_FULL(73,75)
  JVS(856) = 0
! JVS(857) = Jac_FULL(73,76)
  JVS(857) = -B(131)
! JVS(858) = Jac_FULL(74,29)
  JVS(858) = B(22)
! JVS(859) = Jac_FULL(74,31)
  JVS(859) = -B(176)
! JVS(860) = Jac_FULL(74,34)
  JVS(860) = B(23)
! JVS(861) = Jac_FULL(74,35)
  JVS(861) = -B(285)
! JVS(862) = Jac_FULL(74,37)
  JVS(862) = -B(301)
! JVS(863) = Jac_FULL(74,38)
  JVS(863) = -B(178)
! JVS(864) = Jac_FULL(74,39)
  JVS(864) = -B(182)
! JVS(865) = Jac_FULL(74,44)
  JVS(865) = -B(324)
! JVS(866) = Jac_FULL(74,61)
  JVS(866) = 0
! JVS(867) = Jac_FULL(74,62)
  JVS(867) = 0
! JVS(868) = Jac_FULL(74,63)
  JVS(868) = -B(180)
! JVS(869) = Jac_FULL(74,64)
  JVS(869) = 0
! JVS(870) = Jac_FULL(74,65)
  JVS(870) = 0
! JVS(871) = Jac_FULL(74,66)
  JVS(871) = 0
! JVS(872) = Jac_FULL(74,67)
  JVS(872) = 0
! JVS(873) = Jac_FULL(74,68)
  JVS(873) = 0
! JVS(874) = Jac_FULL(74,69)
  JVS(874) = -B(36)
! JVS(875) = Jac_FULL(74,70)
  JVS(875) = -B(34)
! JVS(876) = Jac_FULL(74,71)
  JVS(876) = 0
! JVS(877) = Jac_FULL(74,72)
  JVS(877) = -B(51)
! JVS(878) = Jac_FULL(74,73)
  JVS(878) = -B(32)
! JVS(879) = Jac_FULL(74,74)
  JVS(879) = -B(2)-B(3)-B(33)-B(35)-B(37)-B(52)-B(177)-B(179)-B(181)-B(183)-B(286)-B(302)-B(325)
! JVS(880) = Jac_FULL(74,75)
  JVS(880) = 0
! JVS(881) = Jac_FULL(74,76)
  JVS(881) = 0
! JVS(882) = Jac_FULL(75,41)
  JVS(882) = B(268)
! JVS(883) = Jac_FULL(75,46)
  JVS(883) = 0.08*B(132)
! JVS(884) = Jac_FULL(75,47)
  JVS(884) = 0.24*B(134)
! JVS(885) = Jac_FULL(75,56)
  JVS(885) = B(210)
! JVS(886) = Jac_FULL(75,60)
  JVS(886) = 0.2*B(287)
! JVS(887) = Jac_FULL(75,62)
  JVS(887) = 0.35*B(303)
! JVS(888) = Jac_FULL(75,63)
  JVS(888) = 0
! JVS(889) = Jac_FULL(75,67)
  JVS(889) = 0
! JVS(890) = Jac_FULL(75,68)
  JVS(890) = 0
! JVS(891) = Jac_FULL(75,69)
  JVS(891) = B(211)
! JVS(892) = Jac_FULL(75,70)
  JVS(892) = -B(118)
! JVS(893) = Jac_FULL(75,71)
  JVS(893) = 0
! JVS(894) = Jac_FULL(75,72)
  JVS(894) = B(269)
! JVS(895) = Jac_FULL(75,73)
  JVS(895) = 0.036*B(130)+0.08*B(133)+0.24*B(135)+0.2*B(288)+0.35*B(304)
! JVS(896) = Jac_FULL(75,74)
  JVS(896) = 0
! JVS(897) = Jac_FULL(75,75)
  JVS(897) = -B(21)-B(119)
! JVS(898) = Jac_FULL(75,76)
  JVS(898) = 0.036*B(131)
! JVS(899) = Jac_FULL(76,17)
  JVS(899) = 0.83*B(80)
! JVS(900) = Jac_FULL(76,54)
  JVS(900) = 0.5*B(112)
! JVS(901) = Jac_FULL(76,59)
  JVS(901) = 0
! JVS(902) = Jac_FULL(76,60)
  JVS(902) = 0
! JVS(903) = Jac_FULL(76,62)
  JVS(903) = 0
! JVS(904) = Jac_FULL(76,63)
  JVS(904) = 0
! JVS(905) = Jac_FULL(76,64)
  JVS(905) = 0
! JVS(906) = Jac_FULL(76,66)
  JVS(906) = 0
! JVS(907) = Jac_FULL(76,67)
  JVS(907) = -B(215)
! JVS(908) = Jac_FULL(76,68)
  JVS(908) = -B(239)
! JVS(909) = Jac_FULL(76,69)
  JVS(909) = -B(188)
! JVS(910) = Jac_FULL(76,70)
  JVS(910) = 0.83*B(81)+0.5*B(113)+B(118)
! JVS(911) = Jac_FULL(76,71)
  JVS(911) = 0
! JVS(912) = Jac_FULL(76,72)
  JVS(912) = 0
! JVS(913) = Jac_FULL(76,73)
  JVS(913) = -B(130)
! JVS(914) = Jac_FULL(76,74)
  JVS(914) = 0
! JVS(915) = Jac_FULL(76,75)
  JVS(915) = B(119)
! JVS(916) = Jac_FULL(76,76)
  JVS(916) = -B(131)-B(189)-B(216)-B(240)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)
  JUV(2) = JVS(2)*UV(2)+JVS(3)*UV(7)+JVS(4)*UV(70)
  JUV(3) = JVS(5)*UV(3)+JVS(6)*UV(31)+JVS(7)*UV(37)+JVS(8)*UV(38)+JVS(9)*UV(39)+JVS(10)*UV(44)+JVS(11)*UV(63)+JVS(12)&
             &*UV(74)
  JUV(4) = JVS(13)*UV(4)+JVS(14)*UV(37)+JVS(15)*UV(38)+JVS(16)*UV(46)+JVS(17)*UV(47)+JVS(18)*UV(48)+JVS(19)*UV(50)&
             &+JVS(20)*UV(51)+JVS(21)*UV(56)+JVS(22)*UV(59)+JVS(23)*UV(63)+JVS(24)*UV(64)+JVS(25)*UV(66)+JVS(26)*UV(67)&
             &+JVS(27)*UV(68)+JVS(28)*UV(74)+JVS(29)*UV(76)
  JUV(5) = JVS(30)*UV(5)+JVS(31)*UV(21)
  JUV(6) = JVS(32)*UV(6)+JVS(33)*UV(58)
  JUV(7) = JVS(34)*UV(7)+JVS(35)*UV(70)
  JUV(8) = JVS(36)*UV(8)+JVS(37)*UV(70)
  JUV(9) = JVS(38)*UV(9)+JVS(39)*UV(32)+JVS(40)*UV(69)+JVS(41)*UV(70)
  JUV(10) = JVS(42)*UV(10)+JVS(43)*UV(70)
  JUV(11) = JVS(44)*UV(11)+JVS(45)*UV(70)
  JUV(12) = JVS(46)*UV(12)+JVS(47)*UV(70)
  JUV(13) = JVS(48)*UV(13)+JVS(49)*UV(70)
  JUV(14) = JVS(50)*UV(14)+JVS(51)*UV(59)+JVS(52)*UV(72)
  JUV(15) = JVS(53)*UV(15)+JVS(54)*UV(70)+JVS(55)*UV(73)
  JUV(16) = JVS(56)*UV(16)+JVS(57)*UV(55)+JVS(58)*UV(69)+JVS(59)*UV(70)
  JUV(17) = JVS(60)*UV(17)+JVS(61)*UV(70)
  JUV(18) = JVS(62)*UV(18)+JVS(63)*UV(33)+JVS(64)*UV(70)
  JUV(19) = JVS(65)*UV(1)+JVS(66)*UV(19)+JVS(67)*UV(34)+JVS(68)*UV(61)+JVS(69)*UV(74)
  JUV(20) = JVS(70)*UV(20)+JVS(71)*UV(61)+JVS(72)*UV(71)+JVS(73)*UV(72)
  JUV(21) = JVS(74)*UV(21)+JVS(75)*UV(68)+JVS(76)*UV(69)+JVS(77)*UV(70)
  JUV(22) = JVS(78)*UV(22)+JVS(79)*UV(67)+JVS(80)*UV(69)+JVS(81)*UV(70)
  JUV(23) = JVS(82)*UV(23)+JVS(83)*UV(55)+JVS(84)*UV(70)+JVS(85)*UV(72)
  JUV(24) = JVS(86)*UV(24)+JVS(87)*UV(38)+JVS(88)*UV(63)+JVS(89)*UV(70)+JVS(90)*UV(74)
  JUV(25) = JVS(91)*UV(12)+JVS(92)*UV(13)+JVS(93)*UV(25)+JVS(94)*UV(70)+JVS(95)*UV(71)
  JUV(26) = JVS(96)*UV(26)+JVS(97)*UV(69)+JVS(98)*UV(70)+JVS(99)*UV(72)
  JUV(27) = JVS(100)*UV(23)+JVS(101)*UV(27)+JVS(102)*UV(33)+JVS(103)*UV(55)+JVS(104)*UV(70)+JVS(106)*UV(73)
  JUV(28) = JVS(107)*UV(28)+JVS(108)*UV(68)+JVS(109)*UV(70)+JVS(110)*UV(72)
  JUV(29) = JVS(111)*UV(1)+JVS(112)*UV(19)+JVS(113)*UV(29)+JVS(114)*UV(34)+JVS(116)*UV(71)+JVS(117)*UV(72)+JVS(118)&
              &*UV(74)
  JUV(30) = JVS(119)*UV(30)+JVS(120)*UV(35)+JVS(121)*UV(37)+JVS(122)*UV(39)+JVS(123)*UV(61)+JVS(124)*UV(69)+JVS(125)&
              &*UV(70)+JVS(126)*UV(74)
  JUV(31) = JVS(127)*UV(31)+JVS(128)*UV(70)+JVS(129)*UV(71)+JVS(130)*UV(74)
  JUV(32) = JVS(131)*UV(32)+JVS(132)*UV(39)+JVS(133)*UV(69)+JVS(134)*UV(70)+JVS(135)*UV(73)
  JUV(33) = JVS(136)*UV(32)+JVS(137)*UV(33)+JVS(138)*UV(39)+JVS(140)*UV(70)+JVS(141)*UV(71)+JVS(142)*UV(73)
  JUV(34) = JVS(143)*UV(26)+JVS(144)*UV(29)+JVS(145)*UV(34)+JVS(147)*UV(69)+JVS(148)*UV(70)+JVS(149)*UV(71)+JVS(150)&
              &*UV(72)+JVS(151)*UV(73)+JVS(152)*UV(74)
  JUV(35) = JVS(153)*UV(35)+JVS(154)*UV(70)+JVS(155)*UV(71)+JVS(156)*UV(74)
  JUV(36) = JVS(157)*UV(18)+JVS(158)*UV(31)+JVS(160)*UV(35)+JVS(161)*UV(36)+JVS(162)*UV(37)+JVS(163)*UV(38)+JVS(164)&
              &*UV(39)+JVS(165)*UV(42)+JVS(166)*UV(44)+JVS(167)*UV(55)+JVS(168)*UV(57)+JVS(169)*UV(58)+JVS(170)*UV(59)&
              &+JVS(171)*UV(63)+JVS(172)*UV(65)+JVS(173)*UV(67)+JVS(174)*UV(68)+JVS(176)*UV(70)+JVS(177)*UV(71)+JVS(178)&
              &*UV(73)+JVS(179)*UV(74)
  JUV(37) = JVS(180)*UV(37)+JVS(181)*UV(70)+JVS(182)*UV(71)+JVS(183)*UV(74)
  JUV(38) = JVS(184)*UV(37)+JVS(185)*UV(38)+JVS(186)*UV(70)+JVS(187)*UV(71)+JVS(188)*UV(74)
  JUV(39) = JVS(189)*UV(39)+JVS(190)*UV(70)+JVS(191)*UV(71)+JVS(192)*UV(74)
  JUV(40) = JVS(193)*UV(20)+JVS(194)*UV(25)+JVS(195)*UV(40)+JVS(196)*UV(42)+JVS(197)*UV(45)+JVS(198)*UV(57)+JVS(199)&
              &*UV(58)+JVS(200)*UV(61)+JVS(201)*UV(65)+JVS(202)*UV(69)+JVS(203)*UV(70)+JVS(204)*UV(71)+JVS(205)*UV(72)
  JUV(41) = JVS(206)*UV(25)+JVS(207)*UV(41)+JVS(208)*UV(67)+JVS(209)*UV(68)+JVS(210)*UV(69)+JVS(212)*UV(71)+JVS(213)&
              &*UV(72)
  JUV(42) = JVS(214)*UV(42)+JVS(215)*UV(53)+JVS(216)*UV(59)+JVS(217)*UV(67)+JVS(218)*UV(68)+JVS(219)*UV(70)+JVS(220)&
              &*UV(71)+JVS(221)*UV(73)
  JUV(43) = JVS(222)*UV(13)+JVS(223)*UV(43)+JVS(224)*UV(67)+JVS(225)*UV(68)+JVS(226)*UV(69)+JVS(227)*UV(70)+JVS(228)&
              &*UV(73)
  JUV(44) = JVS(229)*UV(9)+JVS(230)*UV(32)+JVS(231)*UV(37)+JVS(232)*UV(39)+JVS(233)*UV(44)+JVS(234)*UV(62)+JVS(235)&
              &*UV(67)+JVS(236)*UV(68)+JVS(238)*UV(70)+JVS(239)*UV(71)+JVS(240)*UV(73)+JVS(241)*UV(74)
  JUV(45) = JVS(242)*UV(43)+JVS(243)*UV(45)+JVS(244)*UV(53)+JVS(245)*UV(67)+JVS(246)*UV(68)+JVS(248)*UV(70)+JVS(249)&
              &*UV(71)+JVS(250)*UV(73)
  JUV(46) = JVS(251)*UV(10)+JVS(252)*UV(46)+JVS(253)*UV(67)+JVS(254)*UV(68)+JVS(255)*UV(69)+JVS(256)*UV(70)+JVS(257)&
              &*UV(73)
  JUV(47) = JVS(258)*UV(11)+JVS(259)*UV(47)+JVS(260)*UV(67)+JVS(261)*UV(68)+JVS(262)*UV(69)+JVS(263)*UV(70)+JVS(264)&
              &*UV(73)
  JUV(48) = JVS(265)*UV(48)+JVS(266)*UV(63)+JVS(267)*UV(67)+JVS(268)*UV(68)+JVS(269)*UV(69)+JVS(270)*UV(70)+JVS(271)&
              &*UV(73)
  JUV(49) = JVS(272)*UV(17)+JVS(273)*UV(35)+JVS(274)*UV(46)+JVS(275)*UV(47)+JVS(276)*UV(48)+JVS(277)*UV(49)+JVS(278)&
              &*UV(60)+JVS(279)*UV(63)+JVS(280)*UV(67)+JVS(281)*UV(68)+JVS(283)*UV(70)+JVS(284)*UV(71)+JVS(285)*UV(73)&
              &+JVS(286)*UV(74)+JVS(287)*UV(75)+JVS(288)*UV(76)
  JUV(50) = JVS(289)*UV(31)+JVS(290)*UV(50)+JVS(291)*UV(67)+JVS(292)*UV(68)+JVS(293)*UV(69)+JVS(294)*UV(70)+JVS(296)&
              &*UV(73)
  JUV(51) = JVS(298)*UV(38)+JVS(299)*UV(51)+JVS(300)*UV(67)+JVS(301)*UV(68)+JVS(302)*UV(69)+JVS(303)*UV(70)+JVS(305)&
              &*UV(73)
  JUV(52) = JVS(307)*UV(10)+JVS(308)*UV(11)+JVS(309)*UV(25)+JVS(310)*UV(28)+JVS(311)*UV(52)+JVS(312)*UV(59)+JVS(313)&
              &*UV(67)+JVS(314)*UV(68)+JVS(315)*UV(69)+JVS(316)*UV(70)+JVS(319)*UV(73)
  JUV(53) = JVS(320)*UV(12)+JVS(321)*UV(53)+JVS(322)*UV(67)+JVS(323)*UV(68)+JVS(324)*UV(69)+JVS(325)*UV(70)+JVS(326)&
              &*UV(73)
  JUV(54) = JVS(327)*UV(41)+JVS(328)*UV(43)+JVS(329)*UV(46)+JVS(330)*UV(47)+JVS(331)*UV(48)+JVS(332)*UV(50)+JVS(333)&
              &*UV(51)+JVS(334)*UV(52)+JVS(335)*UV(53)+JVS(336)*UV(54)+JVS(337)*UV(59)+JVS(338)*UV(60)+JVS(339)*UV(62)&
              &+JVS(341)*UV(64)+JVS(342)*UV(66)+JVS(345)*UV(69)+JVS(346)*UV(70)+JVS(351)*UV(76)
  JUV(55) = JVS(352)*UV(16)+JVS(353)*UV(23)+JVS(354)*UV(39)+JVS(355)*UV(44)+JVS(356)*UV(55)+JVS(360)*UV(69)+JVS(361)&
              &*UV(70)+JVS(363)*UV(72)+JVS(364)*UV(73)+JVS(365)*UV(74)
  JUV(56) = JVS(366)*UV(31)+JVS(367)*UV(35)+JVS(368)*UV(37)+JVS(369)*UV(38)+JVS(370)*UV(56)+JVS(371)*UV(63)+JVS(372)&
              &*UV(67)+JVS(373)*UV(68)+JVS(374)*UV(69)+JVS(376)*UV(71)+JVS(377)*UV(73)
  JUV(57) = JVS(379)*UV(27)+JVS(382)*UV(43)+JVS(383)*UV(44)+JVS(384)*UV(53)+JVS(385)*UV(55)+JVS(386)*UV(57)+JVS(387)&
              &*UV(59)+JVS(389)*UV(64)+JVS(390)*UV(67)+JVS(391)*UV(68)+JVS(393)*UV(70)+JVS(394)*UV(71)+JVS(396)*UV(73)&
              &+JVS(397)*UV(74)
  JUV(58) = JVS(398)*UV(17)+JVS(399)*UV(18)+JVS(400)*UV(22)+JVS(401)*UV(28)+JVS(402)*UV(31)+JVS(403)*UV(32)+JVS(405)&
              &*UV(37)+JVS(406)*UV(38)+JVS(407)*UV(39)+JVS(408)*UV(41)+JVS(409)*UV(42)+JVS(410)*UV(43)+JVS(411)*UV(46)&
              &+JVS(412)*UV(47)+JVS(413)*UV(48)+JVS(414)*UV(50)+JVS(415)*UV(51)+JVS(416)*UV(52)+JVS(417)*UV(53)+JVS(418)&
              &*UV(55)+JVS(419)*UV(56)+JVS(420)*UV(58)+JVS(421)*UV(59)+JVS(422)*UV(60)+JVS(423)*UV(62)+JVS(424)*UV(63)&
              &+JVS(425)*UV(64)+JVS(426)*UV(66)+JVS(427)*UV(67)+JVS(428)*UV(68)+JVS(430)*UV(70)+JVS(431)*UV(71)+JVS(433)&
              &*UV(73)+JVS(434)*UV(74)+JVS(435)*UV(76)
  JUV(59) = JVS(436)*UV(14)+JVS(437)*UV(25)+JVS(438)*UV(45)+JVS(440)*UV(59)+JVS(441)*UV(67)+JVS(442)*UV(68)+JVS(443)&
              &*UV(69)+JVS(444)*UV(70)+JVS(445)*UV(71)+JVS(446)*UV(72)+JVS(447)*UV(73)
  JUV(60) = JVS(448)*UV(35)+JVS(449)*UV(60)+JVS(450)*UV(67)+JVS(451)*UV(68)+JVS(452)*UV(69)+JVS(453)*UV(70)+JVS(454)&
              &*UV(71)+JVS(455)*UV(73)
  JUV(61) = JVS(457)*UV(8)+JVS(458)*UV(10)+JVS(459)*UV(11)+JVS(460)*UV(17)+JVS(461)*UV(19)+JVS(462)*UV(20)+JVS(463)&
              &*UV(21)+JVS(464)*UV(24)+JVS(465)*UV(26)+JVS(466)*UV(30)+JVS(472)*UV(40)+JVS(473)*UV(42)+JVS(474)*UV(45)&
              &+JVS(475)*UV(49)+JVS(477)*UV(57)+JVS(478)*UV(58)+JVS(481)*UV(61)+JVS(485)*UV(65)+JVS(489)*UV(69)+JVS(490)&
              &*UV(70)
  JUV(62) = JVS(497)*UV(37)+JVS(498)*UV(62)+JVS(499)*UV(67)+JVS(500)*UV(68)+JVS(501)*UV(69)+JVS(502)*UV(70)+JVS(503)&
              &*UV(71)+JVS(504)*UV(73)
  JUV(63) = JVS(506)*UV(62)+JVS(507)*UV(63)+JVS(508)*UV(67)+JVS(509)*UV(68)+JVS(511)*UV(70)+JVS(512)*UV(71)+JVS(513)&
              &*UV(73)+JVS(514)*UV(74)
  JUV(64) = JVS(515)*UV(35)+JVS(516)*UV(37)+JVS(517)*UV(49)+JVS(520)*UV(64)+JVS(521)*UV(67)+JVS(522)*UV(68)+JVS(523)&
              &*UV(69)+JVS(524)*UV(70)+JVS(526)*UV(73)+JVS(527)*UV(74)
  JUV(65) = JVS(530)*UV(17)+JVS(531)*UV(35)+JVS(532)*UV(38)+JVS(533)*UV(46)+JVS(534)*UV(47)+JVS(535)*UV(48)+JVS(536)&
              &*UV(50)+JVS(537)*UV(51)+JVS(538)*UV(54)+JVS(539)*UV(56)+JVS(541)*UV(60)+JVS(543)*UV(63)+JVS(545)*UV(65)&
              &+JVS(546)*UV(66)+JVS(547)*UV(67)+JVS(548)*UV(68)+JVS(550)*UV(70)+JVS(551)*UV(71)+JVS(553)*UV(73)+JVS(554)&
              &*UV(74)+JVS(555)*UV(75)+JVS(556)*UV(76)
  JUV(66) = JVS(557)*UV(8)+JVS(558)*UV(35)+JVS(559)*UV(37)+JVS(560)*UV(49)+JVS(563)*UV(66)+JVS(564)*UV(67)+JVS(565)&
              &*UV(68)+JVS(566)*UV(69)+JVS(567)*UV(70)+JVS(569)*UV(73)+JVS(570)*UV(74)
  JUV(67) = JVS(573)*UV(21)+JVS(574)*UV(22)+JVS(575)*UV(24)+JVS(576)*UV(38)+JVS(577)*UV(39)+JVS(578)*UV(41)+JVS(579)&
              &*UV(43)+JVS(580)*UV(46)+JVS(581)*UV(47)+JVS(582)*UV(48)+JVS(583)*UV(50)+JVS(584)*UV(51)+JVS(585)*UV(52)&
              &+JVS(586)*UV(53)+JVS(587)*UV(56)+JVS(588)*UV(59)+JVS(589)*UV(60)+JVS(590)*UV(62)+JVS(591)*UV(63)+JVS(592)&
              &*UV(64)+JVS(593)*UV(65)+JVS(594)*UV(66)+JVS(595)*UV(67)+JVS(596)*UV(68)+JVS(597)*UV(69)+JVS(598)*UV(70)&
              &+JVS(601)*UV(73)+JVS(602)*UV(74)+JVS(604)*UV(76)
  JUV(68) = JVS(605)*UV(21)+JVS(606)*UV(28)+JVS(607)*UV(39)+JVS(608)*UV(41)+JVS(609)*UV(43)+JVS(610)*UV(44)+JVS(611)&
              &*UV(45)+JVS(612)*UV(46)+JVS(613)*UV(47)+JVS(614)*UV(48)+JVS(615)*UV(49)+JVS(616)*UV(50)+JVS(617)*UV(51)&
              &+JVS(618)*UV(52)+JVS(619)*UV(53)+JVS(620)*UV(55)+JVS(621)*UV(56)+JVS(622)*UV(57)+JVS(623)*UV(59)+JVS(624)&
              &*UV(60)+JVS(625)*UV(62)+JVS(627)*UV(64)+JVS(628)*UV(65)+JVS(629)*UV(66)+JVS(630)*UV(67)+JVS(631)*UV(68)&
              &+JVS(632)*UV(69)+JVS(633)*UV(70)+JVS(634)*UV(71)+JVS(635)*UV(72)+JVS(636)*UV(73)+JVS(637)*UV(74)+JVS(639)&
              &*UV(76)
  JUV(69) = JVS(640)*UV(7)+JVS(641)*UV(12)+JVS(642)*UV(13)+JVS(643)*UV(17)+JVS(644)*UV(22)+JVS(645)*UV(25)+JVS(646)&
              &*UV(26)+JVS(647)*UV(27)+JVS(648)*UV(30)+JVS(649)*UV(31)+JVS(650)*UV(32)+JVS(652)*UV(35)+JVS(653)*UV(36)&
              &+JVS(654)*UV(37)+JVS(655)*UV(38)+JVS(656)*UV(39)+JVS(657)*UV(41)+JVS(658)*UV(42)+JVS(659)*UV(43)+JVS(660)&
              &*UV(44)+JVS(661)*UV(45)+JVS(662)*UV(46)+JVS(663)*UV(47)+JVS(664)*UV(48)+JVS(665)*UV(50)+JVS(666)*UV(51)&
              &+JVS(667)*UV(52)+JVS(668)*UV(53)+JVS(669)*UV(54)+JVS(670)*UV(55)+JVS(671)*UV(56)+JVS(672)*UV(57)+JVS(673)&
              &*UV(58)+JVS(674)*UV(59)+JVS(675)*UV(60)+JVS(676)*UV(61)+JVS(677)*UV(62)+JVS(678)*UV(63)+JVS(679)*UV(64)&
              &+JVS(680)*UV(65)+JVS(681)*UV(66)+JVS(682)*UV(67)+JVS(683)*UV(68)+JVS(684)*UV(69)+JVS(685)*UV(70)+JVS(686)&
              &*UV(71)+JVS(687)*UV(72)+JVS(688)*UV(73)+JVS(689)*UV(74)+JVS(690)*UV(75)+JVS(691)*UV(76)
  JUV(70) = JVS(692)*UV(7)+JVS(693)*UV(8)+JVS(694)*UV(10)+JVS(695)*UV(11)+JVS(696)*UV(12)+JVS(697)*UV(13)+JVS(698)&
              &*UV(15)+JVS(699)*UV(16)+JVS(700)*UV(17)+JVS(701)*UV(18)+JVS(702)*UV(19)+JVS(703)*UV(21)+JVS(704)*UV(22)&
              &+JVS(705)*UV(23)+JVS(706)*UV(24)+JVS(707)*UV(25)+JVS(708)*UV(26)+JVS(709)*UV(27)+JVS(710)*UV(28)+JVS(711)&
              &*UV(30)+JVS(712)*UV(31)+JVS(713)*UV(33)+JVS(715)*UV(35)+JVS(716)*UV(36)+JVS(717)*UV(37)+JVS(718)*UV(38)&
              &+JVS(719)*UV(39)+JVS(720)*UV(40)+JVS(721)*UV(42)+JVS(722)*UV(44)+JVS(723)*UV(45)+JVS(724)*UV(49)+JVS(726)&
              &*UV(54)+JVS(728)*UV(57)+JVS(729)*UV(58)+JVS(732)*UV(61)+JVS(734)*UV(63)+JVS(736)*UV(65)+JVS(740)*UV(69)&
              &+JVS(741)*UV(70)+JVS(743)*UV(72)+JVS(744)*UV(73)+JVS(745)*UV(74)+JVS(746)*UV(75)
  JUV(71) = JVS(748)*UV(20)+JVS(749)*UV(25)+JVS(750)*UV(28)+JVS(751)*UV(31)+JVS(752)*UV(35)+JVS(753)*UV(37)+JVS(754)&
              &*UV(38)+JVS(755)*UV(39)+JVS(756)*UV(40)+JVS(757)*UV(42)+JVS(758)*UV(45)+JVS(760)*UV(57)+JVS(761)*UV(58)&
              &+JVS(763)*UV(60)+JVS(765)*UV(62)+JVS(766)*UV(63)+JVS(768)*UV(65)+JVS(772)*UV(69)+JVS(773)*UV(70)+JVS(774)&
              &*UV(71)+JVS(775)*UV(72)+JVS(776)*UV(73)+JVS(777)*UV(74)
  JUV(72) = JVS(780)*UV(14)+JVS(781)*UV(18)+JVS(782)*UV(20)+JVS(783)*UV(23)+JVS(784)*UV(26)+JVS(785)*UV(28)+JVS(786)&
              &*UV(29)+JVS(787)*UV(32)+JVS(789)*UV(34)+JVS(791)*UV(40)+JVS(792)*UV(41)+JVS(794)*UV(43)+JVS(796)*UV(46)&
              &+JVS(797)*UV(47)+JVS(798)*UV(48)+JVS(799)*UV(50)+JVS(800)*UV(51)+JVS(801)*UV(52)+JVS(802)*UV(53)+JVS(803)&
              &*UV(55)+JVS(804)*UV(56)+JVS(807)*UV(59)+JVS(808)*UV(60)+JVS(810)*UV(62)+JVS(812)*UV(64)+JVS(814)*UV(66)&
              &+JVS(815)*UV(67)+JVS(816)*UV(68)+JVS(817)*UV(69)+JVS(818)*UV(70)+JVS(819)*UV(71)+JVS(820)*UV(72)+JVS(821)&
              &*UV(73)+JVS(822)*UV(74)+JVS(823)*UV(75)+JVS(824)*UV(76)
  JUV(73) = JVS(825)*UV(15)+JVS(826)*UV(29)+JVS(827)*UV(32)+JVS(828)*UV(34)+JVS(830)*UV(43)+JVS(831)*UV(46)+JVS(832)&
              &*UV(47)+JVS(833)*UV(48)+JVS(834)*UV(50)+JVS(835)*UV(51)+JVS(836)*UV(52)+JVS(837)*UV(53)+JVS(838)*UV(55)&
              &+JVS(839)*UV(56)+JVS(840)*UV(59)+JVS(841)*UV(60)+JVS(843)*UV(62)+JVS(845)*UV(64)+JVS(847)*UV(66)+JVS(848)&
              &*UV(67)+JVS(849)*UV(68)+JVS(850)*UV(69)+JVS(851)*UV(70)+JVS(852)*UV(71)+JVS(853)*UV(72)+JVS(854)*UV(73)&
              &+JVS(855)*UV(74)+JVS(857)*UV(76)
  JUV(74) = JVS(858)*UV(29)+JVS(859)*UV(31)+JVS(860)*UV(34)+JVS(861)*UV(35)+JVS(862)*UV(37)+JVS(863)*UV(38)+JVS(864)&
              &*UV(39)+JVS(865)*UV(44)+JVS(868)*UV(63)+JVS(874)*UV(69)+JVS(875)*UV(70)+JVS(877)*UV(72)+JVS(878)*UV(73)&
              &+JVS(879)*UV(74)
  JUV(75) = JVS(882)*UV(41)+JVS(883)*UV(46)+JVS(884)*UV(47)+JVS(885)*UV(56)+JVS(886)*UV(60)+JVS(887)*UV(62)+JVS(891)&
              &*UV(69)+JVS(892)*UV(70)+JVS(894)*UV(72)+JVS(895)*UV(73)+JVS(897)*UV(75)+JVS(898)*UV(76)
  JUV(76) = JVS(899)*UV(17)+JVS(900)*UV(54)+JVS(907)*UV(67)+JVS(908)*UV(68)+JVS(909)*UV(69)+JVS(910)*UV(70)+JVS(913)&
              &*UV(73)+JVS(915)*UV(75)+JVS(916)*UV(76)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)+JVS(65)*UV(19)+JVS(111)*UV(29)
  JTUV(2) = JVS(2)*UV(2)
  JTUV(3) = JVS(5)*UV(3)
  JTUV(4) = JVS(13)*UV(4)
  JTUV(5) = JVS(30)*UV(5)
  JTUV(6) = JVS(32)*UV(6)
  JTUV(7) = JVS(3)*UV(2)+JVS(34)*UV(7)+JVS(640)*UV(69)+JVS(692)*UV(70)
  JTUV(8) = JVS(36)*UV(8)+JVS(457)*UV(61)+JVS(557)*UV(66)+JVS(693)*UV(70)
  JTUV(9) = JVS(38)*UV(9)+JVS(229)*UV(44)
  JTUV(10) = JVS(42)*UV(10)+JVS(251)*UV(46)+JVS(307)*UV(52)+JVS(458)*UV(61)+JVS(694)*UV(70)
  JTUV(11) = JVS(44)*UV(11)+JVS(258)*UV(47)+JVS(308)*UV(52)+JVS(459)*UV(61)+JVS(695)*UV(70)
  JTUV(12) = JVS(46)*UV(12)+JVS(91)*UV(25)+JVS(320)*UV(53)+JVS(641)*UV(69)+JVS(696)*UV(70)
  JTUV(13) = JVS(48)*UV(13)+JVS(92)*UV(25)+JVS(222)*UV(43)+JVS(642)*UV(69)+JVS(697)*UV(70)
  JTUV(14) = JVS(50)*UV(14)+JVS(436)*UV(59)+JVS(780)*UV(72)
  JTUV(15) = JVS(53)*UV(15)+JVS(698)*UV(70)+JVS(825)*UV(73)
  JTUV(16) = JVS(56)*UV(16)+JVS(352)*UV(55)+JVS(699)*UV(70)
  JTUV(17) = JVS(60)*UV(17)+JVS(272)*UV(49)+JVS(398)*UV(58)+JVS(460)*UV(61)+JVS(530)*UV(65)+JVS(643)*UV(69)+JVS(700)&
               &*UV(70)+JVS(899)*UV(76)
  JTUV(18) = JVS(62)*UV(18)+JVS(157)*UV(36)+JVS(399)*UV(58)+JVS(701)*UV(70)+JVS(781)*UV(72)
  JTUV(19) = JVS(66)*UV(19)+JVS(112)*UV(29)+JVS(461)*UV(61)+JVS(702)*UV(70)
  JTUV(20) = JVS(70)*UV(20)+JVS(193)*UV(40)+JVS(462)*UV(61)+JVS(748)*UV(71)+JVS(782)*UV(72)
  JTUV(21) = JVS(31)*UV(5)+JVS(74)*UV(21)+JVS(463)*UV(61)+JVS(573)*UV(67)+JVS(605)*UV(68)+JVS(703)*UV(70)
  JTUV(22) = JVS(78)*UV(22)+JVS(400)*UV(58)+JVS(574)*UV(67)+JVS(644)*UV(69)+JVS(704)*UV(70)
  JTUV(23) = JVS(82)*UV(23)+JVS(100)*UV(27)+JVS(353)*UV(55)+JVS(705)*UV(70)+JVS(783)*UV(72)
  JTUV(24) = JVS(86)*UV(24)+JVS(464)*UV(61)+JVS(575)*UV(67)+JVS(706)*UV(70)
  JTUV(25) = JVS(93)*UV(25)+JVS(194)*UV(40)+JVS(206)*UV(41)+JVS(309)*UV(52)+JVS(437)*UV(59)+JVS(645)*UV(69)+JVS(707)&
               &*UV(70)+JVS(749)*UV(71)
  JTUV(26) = JVS(96)*UV(26)+JVS(143)*UV(34)+JVS(465)*UV(61)+JVS(646)*UV(69)+JVS(708)*UV(70)+JVS(784)*UV(72)
  JTUV(27) = JVS(101)*UV(27)+JVS(379)*UV(57)+JVS(647)*UV(69)+JVS(709)*UV(70)
  JTUV(28) = JVS(107)*UV(28)+JVS(310)*UV(52)+JVS(401)*UV(58)+JVS(606)*UV(68)+JVS(710)*UV(70)+JVS(750)*UV(71)+JVS(785)&
               &*UV(72)
  JTUV(29) = JVS(113)*UV(29)+JVS(144)*UV(34)+JVS(786)*UV(72)+JVS(826)*UV(73)+JVS(858)*UV(74)
  JTUV(30) = JVS(119)*UV(30)+JVS(466)*UV(61)+JVS(648)*UV(69)+JVS(711)*UV(70)
  JTUV(31) = JVS(6)*UV(3)+JVS(127)*UV(31)+JVS(158)*UV(36)+JVS(289)*UV(50)+JVS(366)*UV(56)+JVS(402)*UV(58)+JVS(649)&
               &*UV(69)+JVS(712)*UV(70)+JVS(751)*UV(71)+JVS(859)*UV(74)
  JTUV(32) = JVS(39)*UV(9)+JVS(131)*UV(32)+JVS(136)*UV(33)+JVS(230)*UV(44)+JVS(403)*UV(58)+JVS(650)*UV(69)+JVS(787)&
               &*UV(72)+JVS(827)*UV(73)
  JTUV(33) = JVS(63)*UV(18)+JVS(102)*UV(27)+JVS(137)*UV(33)+JVS(713)*UV(70)
  JTUV(34) = JVS(67)*UV(19)+JVS(114)*UV(29)+JVS(145)*UV(34)+JVS(789)*UV(72)+JVS(828)*UV(73)+JVS(860)*UV(74)
  JTUV(35) = JVS(120)*UV(30)+JVS(153)*UV(35)+JVS(160)*UV(36)+JVS(273)*UV(49)+JVS(367)*UV(56)+JVS(448)*UV(60)+JVS(515)&
               &*UV(64)+JVS(531)*UV(65)+JVS(558)*UV(66)+JVS(652)*UV(69)+JVS(715)*UV(70)+JVS(752)*UV(71)+JVS(861)*UV(74)
  JTUV(36) = JVS(161)*UV(36)+JVS(653)*UV(69)+JVS(716)*UV(70)
  JTUV(37) = JVS(7)*UV(3)+JVS(14)*UV(4)+JVS(121)*UV(30)+JVS(162)*UV(36)+JVS(180)*UV(37)+JVS(184)*UV(38)+JVS(231)*UV(44)&
               &+JVS(368)*UV(56)+JVS(405)*UV(58)+JVS(497)*UV(62)+JVS(516)*UV(64)+JVS(559)*UV(66)+JVS(654)*UV(69)+JVS(717)&
               &*UV(70)+JVS(753)*UV(71)+JVS(862)*UV(74)
  JTUV(38) = JVS(8)*UV(3)+JVS(15)*UV(4)+JVS(87)*UV(24)+JVS(163)*UV(36)+JVS(185)*UV(38)+JVS(298)*UV(51)+JVS(369)*UV(56)&
               &+JVS(406)*UV(58)+JVS(532)*UV(65)+JVS(576)*UV(67)+JVS(655)*UV(69)+JVS(718)*UV(70)+JVS(754)*UV(71)+JVS(863)&
               &*UV(74)
  JTUV(39) = JVS(9)*UV(3)+JVS(122)*UV(30)+JVS(132)*UV(32)+JVS(138)*UV(33)+JVS(164)*UV(36)+JVS(189)*UV(39)+JVS(232)&
               &*UV(44)+JVS(354)*UV(55)+JVS(407)*UV(58)+JVS(577)*UV(67)+JVS(607)*UV(68)+JVS(656)*UV(69)+JVS(719)*UV(70)&
               &+JVS(755)*UV(71)+JVS(864)*UV(74)
  JTUV(40) = JVS(195)*UV(40)+JVS(472)*UV(61)+JVS(720)*UV(70)+JVS(756)*UV(71)+JVS(791)*UV(72)
  JTUV(41) = JVS(207)*UV(41)+JVS(327)*UV(54)+JVS(408)*UV(58)+JVS(578)*UV(67)+JVS(608)*UV(68)+JVS(657)*UV(69)+JVS(792)&
               &*UV(72)+JVS(882)*UV(75)
  JTUV(42) = JVS(165)*UV(36)+JVS(196)*UV(40)+JVS(214)*UV(42)+JVS(409)*UV(58)+JVS(473)*UV(61)+JVS(658)*UV(69)+JVS(721)&
               &*UV(70)+JVS(757)*UV(71)
  JTUV(43) = JVS(223)*UV(43)+JVS(242)*UV(45)+JVS(328)*UV(54)+JVS(382)*UV(57)+JVS(410)*UV(58)+JVS(579)*UV(67)+JVS(609)&
               &*UV(68)+JVS(659)*UV(69)+JVS(794)*UV(72)+JVS(830)*UV(73)
  JTUV(44) = JVS(10)*UV(3)+JVS(166)*UV(36)+JVS(233)*UV(44)+JVS(355)*UV(55)+JVS(383)*UV(57)+JVS(610)*UV(68)+JVS(660)&
               &*UV(69)+JVS(722)*UV(70)+JVS(865)*UV(74)
  JTUV(45) = JVS(197)*UV(40)+JVS(243)*UV(45)+JVS(438)*UV(59)+JVS(474)*UV(61)+JVS(611)*UV(68)+JVS(661)*UV(69)+JVS(723)&
               &*UV(70)+JVS(758)*UV(71)
  JTUV(46) = JVS(16)*UV(4)+JVS(252)*UV(46)+JVS(274)*UV(49)+JVS(329)*UV(54)+JVS(411)*UV(58)+JVS(533)*UV(65)+JVS(580)&
               &*UV(67)+JVS(612)*UV(68)+JVS(662)*UV(69)+JVS(796)*UV(72)+JVS(831)*UV(73)+JVS(883)*UV(75)
  JTUV(47) = JVS(17)*UV(4)+JVS(259)*UV(47)+JVS(275)*UV(49)+JVS(330)*UV(54)+JVS(412)*UV(58)+JVS(534)*UV(65)+JVS(581)&
               &*UV(67)+JVS(613)*UV(68)+JVS(663)*UV(69)+JVS(797)*UV(72)+JVS(832)*UV(73)+JVS(884)*UV(75)
  JTUV(48) = JVS(18)*UV(4)+JVS(265)*UV(48)+JVS(276)*UV(49)+JVS(331)*UV(54)+JVS(413)*UV(58)+JVS(535)*UV(65)+JVS(582)&
               &*UV(67)+JVS(614)*UV(68)+JVS(664)*UV(69)+JVS(798)*UV(72)+JVS(833)*UV(73)
  JTUV(49) = JVS(277)*UV(49)+JVS(475)*UV(61)+JVS(517)*UV(64)+JVS(560)*UV(66)+JVS(615)*UV(68)+JVS(724)*UV(70)
  JTUV(50) = JVS(19)*UV(4)+JVS(290)*UV(50)+JVS(332)*UV(54)+JVS(414)*UV(58)+JVS(536)*UV(65)+JVS(583)*UV(67)+JVS(616)&
               &*UV(68)+JVS(665)*UV(69)+JVS(799)*UV(72)+JVS(834)*UV(73)
  JTUV(51) = JVS(20)*UV(4)+JVS(299)*UV(51)+JVS(333)*UV(54)+JVS(415)*UV(58)+JVS(537)*UV(65)+JVS(584)*UV(67)+JVS(617)&
               &*UV(68)+JVS(666)*UV(69)+JVS(800)*UV(72)+JVS(835)*UV(73)
  JTUV(52) = JVS(311)*UV(52)+JVS(334)*UV(54)+JVS(416)*UV(58)+JVS(585)*UV(67)+JVS(618)*UV(68)+JVS(667)*UV(69)+JVS(801)&
               &*UV(72)+JVS(836)*UV(73)
  JTUV(53) = JVS(215)*UV(42)+JVS(244)*UV(45)+JVS(321)*UV(53)+JVS(335)*UV(54)+JVS(384)*UV(57)+JVS(417)*UV(58)+JVS(586)&
               &*UV(67)+JVS(619)*UV(68)+JVS(668)*UV(69)+JVS(802)*UV(72)+JVS(837)*UV(73)
  JTUV(54) = JVS(336)*UV(54)+JVS(538)*UV(65)+JVS(669)*UV(69)+JVS(726)*UV(70)+JVS(900)*UV(76)
  JTUV(55) = JVS(57)*UV(16)+JVS(83)*UV(23)+JVS(103)*UV(27)+JVS(167)*UV(36)+JVS(356)*UV(55)+JVS(385)*UV(57)+JVS(418)&
               &*UV(58)+JVS(620)*UV(68)+JVS(670)*UV(69)+JVS(803)*UV(72)+JVS(838)*UV(73)
  JTUV(56) = JVS(21)*UV(4)+JVS(370)*UV(56)+JVS(419)*UV(58)+JVS(539)*UV(65)+JVS(587)*UV(67)+JVS(621)*UV(68)+JVS(671)&
               &*UV(69)+JVS(804)*UV(72)+JVS(839)*UV(73)+JVS(885)*UV(75)
  JTUV(57) = JVS(168)*UV(36)+JVS(198)*UV(40)+JVS(386)*UV(57)+JVS(477)*UV(61)+JVS(622)*UV(68)+JVS(672)*UV(69)+JVS(728)&
               &*UV(70)+JVS(760)*UV(71)
  JTUV(58) = JVS(33)*UV(6)+JVS(169)*UV(36)+JVS(199)*UV(40)+JVS(420)*UV(58)+JVS(478)*UV(61)+JVS(673)*UV(69)+JVS(729)&
               &*UV(70)+JVS(761)*UV(71)
  JTUV(59) = JVS(22)*UV(4)+JVS(51)*UV(14)+JVS(170)*UV(36)+JVS(216)*UV(42)+JVS(312)*UV(52)+JVS(337)*UV(54)+JVS(387)&
               &*UV(57)+JVS(421)*UV(58)+JVS(440)*UV(59)+JVS(588)*UV(67)+JVS(623)*UV(68)+JVS(674)*UV(69)+JVS(807)*UV(72)&
               &+JVS(840)*UV(73)
  JTUV(60) = JVS(278)*UV(49)+JVS(338)*UV(54)+JVS(422)*UV(58)+JVS(449)*UV(60)+JVS(541)*UV(65)+JVS(589)*UV(67)+JVS(624)&
               &*UV(68)+JVS(675)*UV(69)+JVS(763)*UV(71)+JVS(808)*UV(72)+JVS(841)*UV(73)+JVS(886)*UV(75)
  JTUV(61) = JVS(68)*UV(19)+JVS(71)*UV(20)+JVS(123)*UV(30)+JVS(200)*UV(40)+JVS(481)*UV(61)+JVS(676)*UV(69)+JVS(732)&
               &*UV(70)
  JTUV(62) = JVS(234)*UV(44)+JVS(339)*UV(54)+JVS(423)*UV(58)+JVS(498)*UV(62)+JVS(506)*UV(63)+JVS(590)*UV(67)+JVS(625)&
               &*UV(68)+JVS(677)*UV(69)+JVS(765)*UV(71)+JVS(810)*UV(72)+JVS(843)*UV(73)+JVS(887)*UV(75)
  JTUV(63) = JVS(11)*UV(3)+JVS(23)*UV(4)+JVS(88)*UV(24)+JVS(171)*UV(36)+JVS(266)*UV(48)+JVS(279)*UV(49)+JVS(371)*UV(56)&
               &+JVS(424)*UV(58)+JVS(507)*UV(63)+JVS(543)*UV(65)+JVS(591)*UV(67)+JVS(678)*UV(69)+JVS(734)*UV(70)+JVS(766)&
               &*UV(71)+JVS(868)*UV(74)
  JTUV(64) = JVS(24)*UV(4)+JVS(341)*UV(54)+JVS(389)*UV(57)+JVS(425)*UV(58)+JVS(520)*UV(64)+JVS(592)*UV(67)+JVS(627)&
               &*UV(68)+JVS(679)*UV(69)+JVS(812)*UV(72)+JVS(845)*UV(73)
  JTUV(65) = JVS(172)*UV(36)+JVS(201)*UV(40)+JVS(485)*UV(61)+JVS(545)*UV(65)+JVS(593)*UV(67)+JVS(628)*UV(68)+JVS(680)&
               &*UV(69)+JVS(736)*UV(70)+JVS(768)*UV(71)
  JTUV(66) = JVS(25)*UV(4)+JVS(342)*UV(54)+JVS(426)*UV(58)+JVS(546)*UV(65)+JVS(563)*UV(66)+JVS(594)*UV(67)+JVS(629)&
               &*UV(68)+JVS(681)*UV(69)+JVS(814)*UV(72)+JVS(847)*UV(73)
  JTUV(67) = JVS(26)*UV(4)+JVS(79)*UV(22)+JVS(173)*UV(36)+JVS(208)*UV(41)+JVS(217)*UV(42)+JVS(224)*UV(43)+JVS(235)&
               &*UV(44)+JVS(245)*UV(45)+JVS(253)*UV(46)+JVS(260)*UV(47)+JVS(267)*UV(48)+JVS(280)*UV(49)+JVS(291)*UV(50)&
               &+JVS(300)*UV(51)+JVS(313)*UV(52)+JVS(322)*UV(53)+JVS(372)*UV(56)+JVS(390)*UV(57)+JVS(427)*UV(58)+JVS(441)&
               &*UV(59)+JVS(450)*UV(60)+JVS(499)*UV(62)+JVS(508)*UV(63)+JVS(521)*UV(64)+JVS(547)*UV(65)+JVS(564)*UV(66)&
               &+JVS(595)*UV(67)+JVS(630)*UV(68)+JVS(682)*UV(69)+JVS(815)*UV(72)+JVS(848)*UV(73)+JVS(907)*UV(76)
  JTUV(68) = JVS(27)*UV(4)+JVS(75)*UV(21)+JVS(108)*UV(28)+JVS(174)*UV(36)+JVS(209)*UV(41)+JVS(218)*UV(42)+JVS(225)&
               &*UV(43)+JVS(236)*UV(44)+JVS(246)*UV(45)+JVS(254)*UV(46)+JVS(261)*UV(47)+JVS(268)*UV(48)+JVS(281)*UV(49)&
               &+JVS(292)*UV(50)+JVS(301)*UV(51)+JVS(314)*UV(52)+JVS(323)*UV(53)+JVS(373)*UV(56)+JVS(391)*UV(57)+JVS(428)&
               &*UV(58)+JVS(442)*UV(59)+JVS(451)*UV(60)+JVS(500)*UV(62)+JVS(509)*UV(63)+JVS(522)*UV(64)+JVS(548)*UV(65)&
               &+JVS(565)*UV(66)+JVS(596)*UV(67)+JVS(631)*UV(68)+JVS(683)*UV(69)+JVS(816)*UV(72)+JVS(849)*UV(73)+JVS(908)&
               &*UV(76)
  JTUV(69) = JVS(40)*UV(9)+JVS(58)*UV(16)+JVS(76)*UV(21)+JVS(80)*UV(22)+JVS(97)*UV(26)+JVS(124)*UV(30)+JVS(133)*UV(32)&
               &+JVS(147)*UV(34)+JVS(202)*UV(40)+JVS(210)*UV(41)+JVS(226)*UV(43)+JVS(255)*UV(46)+JVS(262)*UV(47)+JVS(269)&
               &*UV(48)+JVS(293)*UV(50)+JVS(302)*UV(51)+JVS(315)*UV(52)+JVS(324)*UV(53)+JVS(345)*UV(54)+JVS(360)*UV(55)&
               &+JVS(374)*UV(56)+JVS(443)*UV(59)+JVS(452)*UV(60)+JVS(489)*UV(61)+JVS(501)*UV(62)+JVS(523)*UV(64)+JVS(566)&
               &*UV(66)+JVS(597)*UV(67)+JVS(632)*UV(68)+JVS(684)*UV(69)+JVS(740)*UV(70)+JVS(772)*UV(71)+JVS(817)*UV(72)&
               &+JVS(850)*UV(73)+JVS(874)*UV(74)+JVS(891)*UV(75)+JVS(909)*UV(76)
  JTUV(70) = JVS(4)*UV(2)+JVS(35)*UV(7)+JVS(37)*UV(8)+JVS(41)*UV(9)+JVS(43)*UV(10)+JVS(45)*UV(11)+JVS(47)*UV(12)+JVS(49)&
               &*UV(13)+JVS(54)*UV(15)+JVS(59)*UV(16)+JVS(61)*UV(17)+JVS(64)*UV(18)+JVS(77)*UV(21)+JVS(81)*UV(22)+JVS(84)&
               &*UV(23)+JVS(89)*UV(24)+JVS(94)*UV(25)+JVS(98)*UV(26)+JVS(104)*UV(27)+JVS(109)*UV(28)+JVS(125)*UV(30)&
               &+JVS(128)*UV(31)+JVS(134)*UV(32)+JVS(140)*UV(33)+JVS(148)*UV(34)+JVS(154)*UV(35)+JVS(176)*UV(36)+JVS(181)&
               &*UV(37)+JVS(186)*UV(38)+JVS(190)*UV(39)+JVS(203)*UV(40)+JVS(219)*UV(42)+JVS(227)*UV(43)+JVS(238)*UV(44)&
               &+JVS(248)*UV(45)+JVS(256)*UV(46)+JVS(263)*UV(47)+JVS(270)*UV(48)+JVS(283)*UV(49)+JVS(294)*UV(50)+JVS(303)&
               &*UV(51)+JVS(316)*UV(52)+JVS(325)*UV(53)+JVS(346)*UV(54)+JVS(361)*UV(55)+JVS(393)*UV(57)+JVS(430)*UV(58)&
               &+JVS(444)*UV(59)+JVS(453)*UV(60)+JVS(490)*UV(61)+JVS(502)*UV(62)+JVS(511)*UV(63)+JVS(524)*UV(64)+JVS(550)&
               &*UV(65)+JVS(567)*UV(66)+JVS(598)*UV(67)+JVS(633)*UV(68)+JVS(685)*UV(69)+JVS(741)*UV(70)+JVS(773)*UV(71)&
               &+JVS(818)*UV(72)+JVS(851)*UV(73)+JVS(875)*UV(74)+JVS(892)*UV(75)+JVS(910)*UV(76)
  JTUV(71) = JVS(72)*UV(20)+JVS(95)*UV(25)+JVS(116)*UV(29)+JVS(129)*UV(31)+JVS(141)*UV(33)+JVS(149)*UV(34)+JVS(155)&
               &*UV(35)+JVS(177)*UV(36)+JVS(182)*UV(37)+JVS(187)*UV(38)+JVS(191)*UV(39)+JVS(204)*UV(40)+JVS(212)*UV(41)&
               &+JVS(220)*UV(42)+JVS(239)*UV(44)+JVS(249)*UV(45)+JVS(284)*UV(49)+JVS(376)*UV(56)+JVS(394)*UV(57)+JVS(431)&
               &*UV(58)+JVS(445)*UV(59)+JVS(454)*UV(60)+JVS(503)*UV(62)+JVS(512)*UV(63)+JVS(551)*UV(65)+JVS(634)*UV(68)&
               &+JVS(686)*UV(69)+JVS(774)*UV(71)+JVS(819)*UV(72)+JVS(852)*UV(73)
  JTUV(72) = JVS(52)*UV(14)+JVS(73)*UV(20)+JVS(85)*UV(23)+JVS(99)*UV(26)+JVS(110)*UV(28)+JVS(117)*UV(29)+JVS(150)*UV(34)&
               &+JVS(205)*UV(40)+JVS(213)*UV(41)+JVS(363)*UV(55)+JVS(446)*UV(59)+JVS(635)*UV(68)+JVS(687)*UV(69)+JVS(743)&
               &*UV(70)+JVS(775)*UV(71)+JVS(820)*UV(72)+JVS(853)*UV(73)+JVS(877)*UV(74)+JVS(894)*UV(75)
  JTUV(73) = JVS(55)*UV(15)+JVS(106)*UV(27)+JVS(135)*UV(32)+JVS(142)*UV(33)+JVS(151)*UV(34)+JVS(178)*UV(36)+JVS(221)&
               &*UV(42)+JVS(228)*UV(43)+JVS(240)*UV(44)+JVS(250)*UV(45)+JVS(257)*UV(46)+JVS(264)*UV(47)+JVS(271)*UV(48)&
               &+JVS(285)*UV(49)+JVS(296)*UV(50)+JVS(305)*UV(51)+JVS(319)*UV(52)+JVS(326)*UV(53)+JVS(364)*UV(55)+JVS(377)&
               &*UV(56)+JVS(396)*UV(57)+JVS(433)*UV(58)+JVS(447)*UV(59)+JVS(455)*UV(60)+JVS(504)*UV(62)+JVS(513)*UV(63)&
               &+JVS(526)*UV(64)+JVS(553)*UV(65)+JVS(569)*UV(66)+JVS(601)*UV(67)+JVS(636)*UV(68)+JVS(688)*UV(69)+JVS(744)&
               &*UV(70)+JVS(776)*UV(71)+JVS(821)*UV(72)+JVS(854)*UV(73)+JVS(878)*UV(74)+JVS(895)*UV(75)+JVS(913)*UV(76)
  JTUV(74) = JVS(12)*UV(3)+JVS(28)*UV(4)+JVS(69)*UV(19)+JVS(90)*UV(24)+JVS(118)*UV(29)+JVS(126)*UV(30)+JVS(130)*UV(31)&
               &+JVS(152)*UV(34)+JVS(156)*UV(35)+JVS(179)*UV(36)+JVS(183)*UV(37)+JVS(188)*UV(38)+JVS(192)*UV(39)+JVS(241)&
               &*UV(44)+JVS(286)*UV(49)+JVS(365)*UV(55)+JVS(397)*UV(57)+JVS(434)*UV(58)+JVS(514)*UV(63)+JVS(527)*UV(64)&
               &+JVS(554)*UV(65)+JVS(570)*UV(66)+JVS(602)*UV(67)+JVS(637)*UV(68)+JVS(689)*UV(69)+JVS(745)*UV(70)+JVS(777)&
               &*UV(71)+JVS(822)*UV(72)+JVS(855)*UV(73)+JVS(879)*UV(74)
  JTUV(75) = JVS(287)*UV(49)+JVS(555)*UV(65)+JVS(690)*UV(69)+JVS(746)*UV(70)+JVS(823)*UV(72)+JVS(897)*UV(75)+JVS(915)&
               &*UV(76)
  JTUV(76) = JVS(29)*UV(4)+JVS(288)*UV(49)+JVS(351)*UV(54)+JVS(435)*UV(58)+JVS(556)*UV(65)+JVS(604)*UV(67)+JVS(639)&
               &*UV(68)+JVS(691)*UV(69)+JVS(824)*UV(72)+JVS(857)*UV(73)+JVS(898)*UV(75)+JVS(916)*UV(76)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADMKA_Jacobian

