! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADMKA_Function.f90
! Time                 : Thu Oct  8 08:22:34 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADMKA_16038_BOXMOX
! Equation file        : RADMKA.kpp
! Output root filename : RADMKA
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADMKA_Function

  USE RADMKA_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(72)
  A(2) = RCT(2)*V(74)
  A(3) = RCT(3)*V(74)
  A(4) = RCT(4)*V(15)
  A(5) = RCT(5)*V(40)
  A(6) = RCT(6)*V(26)
  A(7) = RCT(7)*V(71)
  A(8) = RCT(8)*V(71)
  A(9) = RCT(9)*V(30)
  A(10) = RCT(10)*V(58)
  A(11) = RCT(11)*V(58)
  A(12) = RCT(12)*V(65)
  A(13) = RCT(13)*V(22)
  A(14) = RCT(14)*V(54)
  A(15) = RCT(15)*V(21)
  A(16) = RCT(16)*V(49)
  A(17) = RCT(17)*V(42)
  A(18) = RCT(18)*V(42)
  A(19) = RCT(19)*V(57)
  A(20) = RCT(20)*V(45)
  A(21) = RCT(21)*V(75)
  A(22) = RCT(22)*V(29)*V(34)
  A(23) = RCT(23)*V(29)*V(72)
  A(24) = RCT(24)*V(1)*V(19)
  A(25) = RCT(25)*V(19)*V(34)
  A(26) = RCT(26)*V(19)*V(61)
  A(27) = RCT(27)*V(73)*V(74)
  A(28) = RCT(28)*V(70)*V(74)
  A(29) = RCT(29)*V(69)*V(74)
  A(30) = RCT(30)*V(69)*V(73)
  A(31) = RCT(31)*V(69)*V(72)
  A(32) = RCT(32)*V(69)*V(69)
  A(33) = RCT(33)*V(61)*V(69)*V(69)
  A(34) = RCT(34)*V(30)*V(70)
  A(35) = RCT(35)*V(70)*V(73)
  A(36) = RCT(36)*V(34)*V(73)*V(73)
  A(37) = RCT(37)*V(72)*V(74)
  A(38) = RCT(38)*V(71)*V(73)
  A(39) = RCT(39)*V(71)*V(72)
  A(40) = RCT(40)*V(69)*V(71)
  A(41) = RCT(41)*V(71)*V(72)
  A(42) = RCT(42)*V(20)
  A(43) = RCT(43)*V(20)*V(61)
  A(44) = RCT(44)*V(70)*V(72)
  A(45) = RCT(45)*V(40)*V(70)
  A(46) = RCT(46)*V(26)*V(70)
  A(47) = RCT(47)*V(69)*V(70)
  A(48) = RCT(48)*V(7)*V(70)
  A(49) = RCT(49)*V(36)*V(70)
  A(50) = RCT(50)*V(24)*V(70)
  A(51) = RCT(51)*V(8)*V(70)
  A(52) = RCT(52)*V(17)*V(70)
  A(53) = RCT(53)*V(10)*V(70)
  A(54) = RCT(54)*V(11)*V(70)
  A(55) = RCT(55)*V(31)*V(70)
  A(56) = RCT(56)*V(38)*V(70)
  A(57) = RCT(57)*V(63)*V(70)
  A(58) = RCT(58)*V(12)*V(70)
  A(59) = RCT(59)*V(13)*V(70)
  A(60) = RCT(60)*V(25)*V(70)
  A(61) = RCT(61)*V(58)*V(70)
  A(62) = RCT(62)*V(65)*V(70)
  A(63) = RCT(63)*V(49)*V(70)
  A(64) = RCT(64)*V(42)*V(70)
  A(65) = RCT(65)*V(57)*V(70)
  A(66) = RCT(66)*V(45)*V(70)
  A(67) = RCT(67)*V(22)*V(70)
  A(68) = RCT(68)*V(54)*V(70)
  A(69) = RCT(69)*V(21)*V(70)
  A(70) = RCT(70)*V(28)*V(70)
  A(71) = RCT(71)*V(70)*V(75)
  A(72) = RCT(72)*V(39)*V(70)
  A(73) = RCT(73)*V(68)*V(72)
  A(74) = RCT(74)*V(28)
  A(75) = RCT(75)*V(59)*V(72)
  A(76) = RCT(76)*V(14)
  A(77) = RCT(77)*V(67)*V(73)
  A(78) = RCT(78)*V(73)*V(76)
  A(79) = RCT(79)*V(46)*V(73)
  A(80) = RCT(80)*V(47)*V(73)
  A(81) = RCT(81)*V(50)*V(73)
  A(82) = RCT(82)*V(51)*V(73)
  A(83) = RCT(83)*V(48)*V(73)
  A(84) = RCT(84)*V(68)*V(73)
  A(85) = RCT(85)*V(59)*V(73)
  A(86) = RCT(86)*V(53)*V(73)
  A(87) = RCT(87)*V(43)*V(73)
  A(88) = RCT(88)*V(66)*V(73)
  A(89) = RCT(89)*V(64)*V(73)
  A(90) = RCT(90)*V(56)*V(73)
  A(91) = RCT(91)*V(58)*V(71)
  A(92) = RCT(92)*V(65)*V(71)
  A(93) = RCT(93)*V(42)*V(71)
  A(94) = RCT(94)*V(57)*V(71)
  A(95) = RCT(95)*V(45)*V(71)
  A(96) = RCT(96)*V(25)*V(71)
  A(97) = RCT(97)*V(31)*V(71)
  A(98) = RCT(98)*V(38)*V(71)
  A(99) = RCT(99)*V(63)*V(71)
  A(100) = RCT(100)*V(39)*V(71)
  A(101) = RCT(101)*V(31)*V(74)
  A(102) = RCT(102)*V(38)*V(74)
  A(103) = RCT(103)*V(63)*V(74)
  A(104) = RCT(104)*V(39)*V(74)
  A(105) = RCT(105)*V(67)*V(69)
  A(106) = RCT(106)*V(66)*V(69)
  A(107) = RCT(107)*V(69)*V(76)
  A(108) = RCT(108)*V(46)*V(69)
  A(109) = RCT(109)*V(47)*V(69)
  A(110) = RCT(110)*V(50)*V(69)
  A(111) = RCT(111)*V(51)*V(69)
  A(112) = RCT(112)*V(48)*V(69)
  A(113) = RCT(113)*V(64)*V(69)
  A(114) = RCT(114)*V(68)*V(69)
  A(115) = RCT(115)*V(53)*V(69)
  A(116) = RCT(116)*V(43)*V(69)
  A(117) = RCT(117)*V(59)*V(69)
  A(118) = RCT(118)*V(56)*V(69)
  A(119) = RCT(119)*V(67)*V(67)
  A(120) = RCT(120)*V(66)*V(67)
  A(121) = RCT(121)*V(67)*V(76)
  A(122) = RCT(122)*V(46)*V(67)
  A(123) = RCT(123)*V(47)*V(67)
  A(124) = RCT(124)*V(50)*V(67)
  A(125) = RCT(125)*V(51)*V(67)
  A(126) = RCT(126)*V(48)*V(67)
  A(127) = RCT(127)*V(64)*V(67)
  A(128) = RCT(128)*V(67)*V(68)
  A(129) = RCT(129)*V(53)*V(67)
  A(130) = RCT(130)*V(43)*V(67)
  A(131) = RCT(131)*V(59)*V(67)
  A(132) = RCT(132)*V(66)*V(68)
  A(133) = RCT(133)*V(68)*V(76)
  A(134) = RCT(134)*V(46)*V(68)
  A(135) = RCT(135)*V(47)*V(68)
  A(136) = RCT(136)*V(50)*V(68)
  A(137) = RCT(137)*V(51)*V(68)
  A(138) = RCT(138)*V(48)*V(68)
  A(139) = RCT(139)*V(64)*V(68)
  A(140) = RCT(140)*V(68)*V(68)
  A(141) = RCT(141)*V(53)*V(68)
  A(142) = RCT(142)*V(43)*V(68)
  A(143) = RCT(143)*V(59)*V(68)
  A(144) = RCT(144)*V(52)*V(69)
  A(145) = RCT(145)*V(52)*V(67)
  A(146) = RCT(146)*V(52)*V(68)
  A(147) = RCT(147)*V(52)*V(73)
  A(148) = RCT(148)*V(41)*V(72)
  A(149) = RCT(149)*V(41)*V(69)
  A(150) = RCT(150)*V(41)*V(67)
  A(151) = RCT(151)*V(41)*V(68)
  A(152) = RCT(152)*V(56)*V(67)
  A(153) = RCT(153)*V(56)*V(68)
  A(154) = RCT(154)*V(56)*V(56)
  A(155) = RCT(155)*V(35)*V(70)
  A(156) = RCT(156)*V(35)*V(71)
  A(157) = RCT(157)*V(35)*V(74)
  A(158) = RCT(158)*V(60)*V(73)
  A(159) = RCT(159)*V(60)*V(69)
  A(160) = RCT(160)*V(60)*V(67)
  A(161) = RCT(161)*V(60)*V(68)
  A(162) = RCT(162)*V(60)*V(71)
  A(163) = RCT(163)*V(37)*V(70)
  A(164) = RCT(164)*V(37)*V(71)
  A(165) = RCT(165)*V(37)*V(74)
  A(166) = RCT(166)*V(62)*V(73)
  A(167) = RCT(167)*V(62)*V(69)
  A(168) = RCT(168)*V(62)*V(67)
  A(169) = RCT(169)*V(62)*V(68)
  A(170) = RCT(170)*V(62)*V(71)
  A(171) = RCT(171)*V(32)*V(73)
  A(172) = RCT(172)*V(32)*V(69)
  A(173) = RCT(173)*V(32)*V(32)
  A(174) = RCT(174)*V(9)*V(70)
  A(175) = RCT(175)*V(33)*V(70)
  A(176) = RCT(176)*V(44)*V(70)
  A(177) = RCT(177)*V(44)*V(74)
  A(178) = RCT(178)*V(55)*V(73)
  A(179) = RCT(179)*V(55)*V(69)
  A(180) = RCT(180)*V(55)*V(55)
  A(181) = RCT(181)*V(55)*V(72)
  A(182) = RCT(182)*V(23)
  A(183) = RCT(183)*V(23)*V(70)
  A(184) = RCT(184)*V(16)*V(70)
  A(185) = RCT(185)*V(27)*V(70)
  A(186) = RCT(186)*V(18)*V(70)

! Aggregate function
  Vdot(1) = 0
  Vdot(2) = A(48)
  Vdot(3) = 0.4*A(101)+0.2*A(102)+0.06*A(103)+0.28*A(104)+0.01*A(165)+0.45*A(177)
  Vdot(4) = 0.2*A(102)+0.29*A(103)+0.5*A(128)+0.5*A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)+0.5*A(135)+0.5*A(136)+0.5&
              &*A(137)+0.5*A(138)+0.5*A(139)+0.5*A(153)+0.07*A(165)
  Vdot(5) = A(15)
  Vdot(6) = A(10)
  Vdot(7) = -A(48)
  Vdot(8) = -A(51)
  Vdot(9) = A(172)-A(174)
  Vdot(10) = -A(53)
  Vdot(11) = -A(54)
  Vdot(12) = -A(58)
  Vdot(13) = -A(59)
  Vdot(14) = A(75)-A(76)
  Vdot(15) = -A(4)+A(35)
  Vdot(16) = A(179)-A(184)
  Vdot(17) = -A(52)
  Vdot(18) = A(175)-A(186)
  Vdot(19) = A(2)-A(24)-A(25)-A(26)
  Vdot(20) = A(41)-A(42)-A(43)
  Vdot(21) = -A(15)-A(69)+A(114)
  Vdot(22) = -A(13)-A(67)+A(105)
  Vdot(23) = A(181)-A(182)-A(183)
  Vdot(24) = -A(50)+0.06*A(102)+0.09*A(103)
  Vdot(25) = 0.25*A(58)+0.17*A(59)-A(60)-0.5*A(96)
  Vdot(26) = -A(6)+A(31)-A(46)
  Vdot(27) = A(175)+0.25*A(178)+A(180)+A(183)-A(185)
  Vdot(28) = -A(70)+A(73)-A(74)
  Vdot(29) = A(1)+A(3)+A(8)-A(22)-A(23)+A(24)+A(25)
  Vdot(30) = -A(9)+A(32)+A(33)-A(34)+0.09*A(104)+0.02*A(157)+0.02*A(165)
  Vdot(31) = -A(55)-A(97)-A(101)
  Vdot(32) = A(72)-A(171)-A(172)-2*A(173)
  Vdot(33) = A(100)+0.046*A(171)-A(175)
  Vdot(34) = A(2)+A(3)+A(7)-A(22)+A(23)+A(27)+A(28)+2*A(29)-A(36)+A(39)+A(40)+A(46)+A(47)
  Vdot(35) = -A(155)-A(156)-A(157)
  Vdot(36) = A(10)+A(11)+A(12)+1.87*A(17)+1.55*A(18)+A(19)-A(49)+A(61)+2*A(64)+A(65)+0.95*A(85)+A(91)+2*A(93)+A(94)+0.42&
               &*A(101)+0.33*A(102)+0.23*A(103)+0.14*A(104)+0.475*A(131)+0.95*A(143)+0.14*A(157)+0.14*A(165)+0.22*A(177)&
               &+0.25*A(178)+0.5*A(180)+A(186)
  Vdot(37) = -A(163)-A(164)-A(165)
  Vdot(38) = -A(56)-A(98)-A(102)+0.46*A(165)
  Vdot(39) = -A(72)-A(100)-A(104)
  Vdot(40) = -A(5)+A(40)+2*A(43)+A(44)-A(45)+A(91)+A(92)+A(93)+A(94)+A(95)+A(96)
  Vdot(41) = A(96)-A(148)-A(149)-A(150)-A(151)
  Vdot(42) = -A(17)-A(18)-A(64)+0.89*A(85)+0.16*A(86)-A(93)+0.16*A(129)+0.445*A(131)+0.16*A(141)+0.89*A(143)
  Vdot(43) = 0.83*A(59)-A(87)-A(116)-A(130)-A(142)
  Vdot(44) = 0.65*A(104)+0.79*A(165)+0.4*A(166)+0.6*A(168)+0.6*A(169)+0.6*A(170)+A(171)+2*A(173)+A(174)-A(176)-A(177)
  Vdot(45) = -A(20)-A(66)+0.7*A(86)+0.806*A(87)-A(95)+0.7*A(129)+0.806*A(130)+0.7*A(141)+0.806*A(142)
  Vdot(46) = A(53)-A(79)-A(108)-A(122)-A(134)
  Vdot(47) = A(54)-A(80)-A(109)-A(123)-A(135)
  Vdot(48) = A(57)-A(83)-A(112)-A(126)-A(138)
  Vdot(49) = -A(16)+0.8*A(21)+0.025*A(52)-A(63)+0.25*A(78)+0.69*A(79)+1.06*A(80)+0.1*A(83)+0.1*A(103)+0.26*A(121)+0.75&
               &*A(122)+1.39*A(123)+0.55*A(126)+0.26*A(133)+0.75*A(134)+1.39*A(135)+0.55*A(138)+0.53*A(157)+0.8*A(158)&
               &+A(160)+A(161)+A(162)
  Vdot(50) = A(55)-A(81)-A(110)-A(124)-A(136)
  Vdot(51) = A(56)-A(82)-A(111)-A(125)-A(137)
  Vdot(52) = 0.25*A(53)+0.75*A(54)+0.9*A(60)+A(70)+2*A(85)+A(131)+2*A(143)-A(144)-A(145)-A(146)-A(147)
  Vdot(53) = 0.75*A(58)-A(86)-A(115)-A(129)-A(141)
  Vdot(54) = -A(14)-A(68)+A(106)+A(107)+A(108)+A(109)+A(110)+A(111)+A(112)+A(113)+A(115)+A(116)+A(117)+A(144)+A(149)&
               &+A(159)+A(167)
  Vdot(55) = 0.1*A(104)+A(176)-A(178)-A(179)-2*A(180)-A(181)+A(182)+A(184)
  Vdot(56) = -A(90)+A(97)+A(98)+A(99)-A(118)-A(152)-A(153)-2*A(154)+A(156)+A(164)
  Vdot(57) = -A(19)-A(65)+0.11*A(85)+0.17*A(86)+0.45*A(87)+A(89)-A(94)+0.75*A(127)+0.17*A(129)+0.45*A(130)+0.055*A(131)&
               &+A(139)+0.17*A(141)+0.45*A(142)+0.11*A(143)+0.9*A(177)+0.5*A(178)+A(180)+A(185)
  Vdot(58) = -A(10)-A(11)+A(13)+0.13*A(17)+0.45*A(18)+0.009*A(52)-A(61)+0.5*A(67)+A(70)+A(77)+0.09*A(78)+0.04*A(80)+1.6&
               &*A(81)+A(82)+0.28*A(83)+A(90)-A(91)+A(101)+0.53*A(102)+0.18*A(103)+0.58*A(104)+1.5*A(119)+0.75*A(120)+0.84&
               &*A(121)+0.77*A(122)+0.8*A(123)+1.55*A(124)+1.25*A(125)+0.89*A(126)+0.75*A(127)+A(128)+A(129)+A(130)+0.5&
               &*A(131)+0.8*A(136)+0.5*A(137)+0.14*A(138)+A(145)+A(150)+1.75*A(152)+A(153)+2*A(154)+A(160)+0.04*A(165)+0.25&
               &*A(166)+1.4*A(168)+0.4*A(169)+0.4*A(170)+A(171)+A(173)+0.75*A(178)+0.5*A(180)+A(186)
  Vdot(59) = A(20)+0.9*A(60)+A(66)-A(75)+A(76)-A(85)+A(95)-A(117)-A(131)-A(143)
  Vdot(60) = A(155)-A(158)-A(159)-A(160)-A(161)-A(162)
  Vdot(61) = -A(26)+A(34)-A(43)+A(45)+A(46)+A(47)+A(50)+A(51)+A(52)+A(53)+A(54)+A(61)+A(62)+A(63)+A(64)+A(65)+A(66)&
               &+A(69)
  Vdot(62) = A(163)-A(166)-A(167)-A(168)-A(169)-A(170)
  Vdot(63) = -A(57)-A(99)-A(103)+0.25*A(166)+0.4*A(168)+0.4*A(169)+0.4*A(170)
  Vdot(64) = A(63)-A(89)-A(113)-A(127)-A(139)+0.42*A(157)+0.42*A(165)
  Vdot(65) = -A(12)+A(14)+0.2*A(21)+0.075*A(52)-A(62)+0.5*A(68)+0.75*A(78)+0.38*A(79)+0.35*A(80)+0.2*A(81)+A(82)+1.45&
               &*A(83)+A(88)+A(90)-A(92)+0.5*A(102)+0.72*A(103)+0.75*A(120)+0.77*A(121)+0.41*A(122)+0.46*A(123)+0.35*A(124)&
               &+0.75*A(125)+0.725*A(126)+A(132)+0.77*A(133)+0.41*A(134)+0.46*A(135)+0.6*A(136)+A(137)+0.725*A(138)+A(152)&
               &+A(153)+2*A(154)+0.65*A(157)+0.8*A(158)+A(160)+A(161)+A(162)
  Vdot(66) = A(16)+A(51)-A(88)-A(106)-A(120)-A(132)+0.2*A(157)+0.16*A(165)
  Vdot(67) = A(12)+A(15)+A(50)+0.5*A(67)-A(77)+A(84)+0.22*A(102)+0.31*A(103)+0.08*A(104)-A(105)-2*A(119)-A(120)-A(121)&
               &-A(122)-A(123)-A(124)-A(125)-A(126)-A(127)-0.5*A(128)-A(129)-A(130)-A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)&
               &+0.5*A(135)+0.5*A(136)+0.5*A(137)+0.5*A(138)+0.5*A(139)+2*A(140)+A(141)+A(142)+A(143)-A(145)+A(146)-A(150)&
               &+A(151)-A(152)+0.5*A(153)-A(160)+A(161)-A(168)+A(169)
  Vdot(68) = A(16)+A(19)+0.02*A(20)+A(62)+A(65)+A(69)-A(73)+A(74)-A(84)+0.05*A(85)+A(92)+A(94)+0.1*A(104)-A(114)-A(128)&
               &+0.03*A(131)-A(132)-A(133)-A(134)-A(135)-A(136)-A(137)-A(138)-A(139)-2*A(140)-A(141)-A(142)-0.95*A(143)&
               &-A(146)-A(151)-A(153)-A(161)-A(169)+0.1*A(177)+0.25*A(178)
  Vdot(69) = A(6)+2*A(11)+A(12)+A(13)+A(14)+0.8*A(18)+A(19)+0.98*A(20)+A(21)+A(28)-A(29)-A(30)-A(31)-2*A(32)-2*A(33)&
               &+A(34)-A(40)-A(47)+A(48)+A(49)+0.17*A(52)+0.25*A(58)+0.17*A(59)+0.1*A(60)+A(61)+A(64)+A(77)+0.964*A(78)+0.92&
               &*A(79)+0.76*A(80)+A(81)+A(82)+A(83)+0.92*A(85)+A(86)+A(87)+A(88)+A(89)+A(91)+A(93)+0.12*A(101)+0.23*A(102)&
               &+0.26*A(103)+0.25*A(104)-A(105)-A(106)-A(107)-A(108)-A(109)-A(110)-A(111)-A(112)-A(113)-A(114)-A(115)-A(116)&
               &-A(117)-A(118)+A(119)+A(120)+A(121)+A(122)+A(123)+A(124)+A(125)+A(126)+A(127)+0.5*A(128)+2*A(129)+2*A(130)&
               &+0.46*A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)+0.5*A(135)+0.5*A(136)+0.5*A(137)+0.5*A(138)+0.5*A(139)+A(141)&
               &+A(142)+0.92*A(143)-A(144)+A(145)-A(149)+A(150)+0.5*A(152)+0.1*A(157)+0.8*A(158)-A(159)+2*A(160)+A(161)&
               &+A(162)+0.1*A(165)+0.65*A(166)-A(167)+2*A(168)+A(169)+A(170)+A(171)-A(172)+A(173)+0.32*A(177)+0.75*A(178)&
               &-A(179)+A(180)+A(185)
  Vdot(70) = A(4)+A(5)+2*A(9)+A(13)+A(14)+A(15)+2*A(26)-A(28)+A(29)+A(30)-A(34)-A(35)-A(44)-A(45)-A(46)-A(47)-A(48)&
               &-A(49)-A(50)-A(51)-A(52)-A(53)-A(54)-A(55)-A(56)-A(57)-A(58)-A(59)-1.9*A(60)-A(61)-A(62)-A(63)-A(64)-A(65)&
               &-A(66)-0.5*A(67)-0.5*A(68)-A(69)-A(70)-A(71)-A(72)+0.1*A(102)+0.14*A(103)+0.25*A(104)-A(155)+0.85*A(157)&
               &-A(163)+0.85*A(165)-A(175)-A(176)+0.19*A(177)-A(183)-A(184)-A(185)-A(186)
  Vdot(71) = -A(7)-A(8)+A(37)-A(38)-A(39)-A(40)-A(41)+A(42)+A(45)+A(70)-A(91)-A(92)-A(93)-A(94)-A(95)-A(96)-A(97)-A(98)&
               &-A(99)-A(100)-A(156)-A(162)-A(164)-A(170)
  Vdot(72) = -A(1)+A(5)+A(6)+A(8)+A(21)-A(23)+A(27)+A(30)-A(31)+2*A(36)-A(37)+2*A(38)-A(41)+A(42)-A(44)+A(46)+A(71)&
               &-A(73)+A(74)-A(75)+A(76)+A(77)+0.964*A(78)+0.92*A(79)+0.76*A(80)+A(81)+A(82)+A(83)+A(84)+A(85)+A(86)+A(87)&
               &+A(88)+A(89)+2*A(90)+A(147)-A(148)+A(152)+A(153)+2*A(154)+0.8*A(158)+A(162)+0.65*A(166)+A(170)+A(171)+A(178)&
               &-A(181)+A(182)+A(183)+A(186)
  Vdot(73) = A(1)+A(4)+A(7)+A(23)-A(27)-A(30)-A(35)-2*A(36)-A(38)+A(39)-A(77)-A(78)-A(79)-A(80)-A(81)-A(82)-A(83)-A(84)&
               &-A(85)-A(86)-A(87)-A(88)-A(89)-A(90)-A(147)-A(158)-A(166)-A(171)-A(178)
  Vdot(74) = -A(2)-A(3)+A(22)-A(27)-A(28)-A(29)-A(37)-A(101)-A(102)-A(103)-A(104)-A(157)-A(165)-A(177)
  Vdot(75) = -A(21)-A(71)+0.036*A(78)+0.08*A(79)+0.24*A(80)+A(118)+A(148)+0.2*A(158)+0.35*A(166)
  Vdot(76) = 0.83*A(52)+0.5*A(68)+A(71)-A(78)-A(107)-A(121)-A(133)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADMKA_Function

