! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADM2_StoichiomSP.f90
! Time                 : Thu Oct  8 08:22:27 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADM2_18938_BOXMOX
! Equation file        : RADM2.kpp
! Output root filename : RADM2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADM2_StoichiomSP

  USE RADM2_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(157) :: CROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, &
      26, 27, 29, 31, 33, 35, 37, 38, 39, 40, 42, 44, &
      45, 47, 49, 51, 53, 55, 56, 57, 59, 61, 63, 65, &
      67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, &
      91, 93, 95, 97, 99,101,103,105,107,109,111,113, &
     115,117,118,120,121,123,125,127,129,131,133,135, &
     137,139,141,143,145,147,149,151,153,155,157,159, &
     161,163,165,167,169,171,173,175,177,179,181,183, &
     185,187,189,191,193,195,197,199,201,203,205,206, &
     208,210,212,214,216,218,220,222,224,226,228,230, &
     232,234,236,238,240,242,244,246,247,249,251,253, &
     255,257,259,260,262,264,266,268,270,271,273,275, &
     276 /)

  INTEGER, PARAMETER, DIMENSION(275) :: ICOL_JVRP = (/ &
      59, 46, 46, 13, 25, 20, 54, 54, 14, 43, 43, 48, &
      21, 42, 18, 33, 31, 31, 34, 30, 47, 19, 19, 59, &
       7,  7, 46, 58, 46, 53, 46, 51, 51, 58, 51, 59, &
      20, 51, 51, 14, 53, 53, 58, 58, 46, 59, 54, 58, &
      54, 59, 51, 54, 54, 59, 15, 15, 53, 59, 25, 53, &
      20, 53, 51, 53,  5, 53, 26, 53, 17, 53,  6, 53, &
      16, 53,  8, 53,  9, 53, 24, 53, 28, 53, 29, 53, &
      10, 53, 11, 53, 22, 53, 43, 53, 48, 53, 33, 53, &
      31, 53, 34, 53, 30, 53, 21, 53, 42, 53, 18, 53, &
      23, 53, 47, 53, 27, 53, 55, 59, 23, 45, 59, 12, &
      52, 58, 56, 58, 41, 58, 44, 58, 40, 58, 37, 58, &
      49, 58, 55, 58, 45, 58, 35, 58, 36, 58, 57, 58, &
      50, 58, 38, 58, 43, 54, 48, 54, 31, 54, 34, 54, &
      30, 54, 22, 54, 24, 54, 28, 54, 29, 54, 27, 54, &
      24, 46, 28, 46, 29, 46, 27, 46, 51, 52, 51, 57, &
      51, 56, 41, 51, 44, 51, 40, 51, 37, 51, 49, 51, &
      50, 51, 51, 55, 35, 51, 36, 51, 45, 51, 38, 51, &
      52, 52, 57, 52, 56, 41, 52, 44, 52, 40, 52, 37, &
      52, 49, 52, 50, 52, 52, 55, 35, 52, 36, 52, 45, &
      52, 55, 57, 55, 56, 41, 55, 44, 55, 40, 55, 37, &
      55, 49, 55, 50, 55, 55, 35, 55, 36, 55, 45, 55, &
      39, 51, 39, 52, 39, 55, 39, 39, 58, 32, 59, 32, &
      51, 32, 52, 32, 55, 32, 38, 52, 38, 55, 38 /)

  INTEGER, PARAMETER, DIMENSION(275) :: IROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 23, &
      24, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, &
      31, 32, 33, 34, 34, 35, 35, 36, 37, 37, 38, 38, &
      39, 39, 40, 40, 41, 41, 42, 43, 44, 44, 45, 45, &
      46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, &
      52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, &
      58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, &
      64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69, &
      70, 70, 71, 71, 72, 72, 73, 73, 74, 75, 75, 76, &
      77, 77, 78, 78, 79, 79, 80, 80, 81, 81, 82, 82, &
      83, 83, 84, 84, 85, 85, 86, 86, 87, 87, 88, 88, &
      89, 89, 90, 90, 91, 91, 92, 92, 93, 93, 94, 94, &
      95, 95, 96, 96, 97, 97, 98, 98, 99, 99,100,100, &
     101,101,102,102,103,103,104,104,105,105,106,106, &
     107,107,108,108,109,109,110,110,111,111,112,112, &
     113,113,114,114,115,115,116,116,117,117,118,118, &
     119,120,120,121,121,122,122,123,123,124,124,125, &
     125,126,126,127,127,128,128,129,129,130,130,131, &
     131,132,132,133,133,134,134,135,135,136,136,137, &
     137,138,138,139,139,140,141,141,142,142,143,143, &
     144,144,145,145,146,146,147,148,148,149,149,150, &
     150,151,151,152,152,153,154,154,155,155,156 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(157) :: CCOL_STOICM = (/ &
       1,  4,  6,  8, 11, 14, 19, 21, 24, 26, 28, 31, &
      35, 39, 43, 46, 49, 52, 56, 60, 63, 68, 70, 73, &
      75, 77, 80, 83, 86, 90, 93, 96, 98,100,103,106, &
     108,111,114,116,119,122,125,127,130,133,136,138, &
     142,146,149,152,159,163,167,170,173,176,181,186, &
     191,195,198,201,205,209,212,216,220,223,228,232, &
     235,238,241,244,247,252,260,267,275,281,287,294, &
     298,307,314,320,325,330,335,340,344,349,354,358, &
     362,365,368,371,374,380,391,403,413,416,419,422, &
     425,428,431,434,437,440,443,446,449,452,455,458, &
     463,469,475,481,486,491,497,502,507,514,520,530, &
     536,543,550,557,564,571,579,585,587,594,600,608, &
     611,615,618,619,622,625,628,632,635,636,642,649, &
     653 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      19, 58, 59,  7, 46, 19, 46, 13, 53, 58, 25, 53, &
      59, 20, 51, 53, 54, 59, 54, 58, 19, 54, 59, 14, &
      53, 26, 43, 26, 43, 51, 26, 48, 51, 52, 21, 43, &
      51, 53, 42, 48, 51, 53, 18, 52, 53, 33, 55, 57, &
      26, 31, 43, 26, 31, 43, 51, 26, 34, 51, 55, 30, &
      45, 51, 33, 47, 48, 51, 59, 19, 46, 19, 58, 59, &
       7, 19,  7, 53, 46, 58, 59, 46, 51, 53, 46, 51, &
      53, 51, 53, 58, 59, 20, 51, 59, 20, 51, 59, 14, &
      51, 14, 51, 14, 51, 53, 13, 53, 58, 58, 59, 46, &
      54, 59, 54, 58, 59, 54, 58, 25, 51, 54, 15, 54, &
      59, 15, 54, 59, 15, 25, 25, 53, 59, 25, 53, 54, &
      20, 53, 59, 51, 53,  1,  5, 51, 53,  4, 26, 51, &
      53, 17, 52, 53,  6, 53, 57, 16, 33, 43, 48, 51, &
      53, 56,  8, 39, 41, 53,  9, 39, 44, 53, 24, 40, &
      53, 28, 37, 53, 29, 49, 53, 10, 22, 35, 51, 53, &
      11, 22, 36, 51, 53, 22, 39, 45, 51, 53, 26, 43, &
      51, 53, 48, 53, 55, 33, 50, 53, 26, 31, 51, 53, &
      26, 34, 53, 55, 30, 45, 53, 21, 43, 52, 53, 42, &
      48, 53, 56, 18, 53, 55, 23, 39, 43, 53, 54, 47, &
      53, 56, 59, 27, 37, 53, 23, 55, 59, 23, 55, 59, &
      12, 45, 59, 12, 45, 59, 43, 51, 52, 58, 59, 33, &
      43, 47, 48, 51, 56, 58, 59, 33, 41, 47, 48, 51, &
      58, 59, 33, 43, 44, 47, 48, 51, 58, 59, 40, 43, &
      48, 51, 58, 59, 37, 43, 48, 51, 58, 59, 33, 43, &
      48, 49, 51, 58, 59, 52, 55, 58, 59, 26, 31, 34, &
      39, 45, 51, 55, 58, 59, 30, 31, 34, 35, 51, 58, &
      59, 30, 34, 36, 51, 58, 59, 48, 51, 57, 58, 59, &
      34, 50, 51, 58, 59, 38, 43, 48, 58, 59, 25, 26, &
      43, 51, 54, 25, 48, 54, 55, 25, 26, 31, 51, 54, &
      25, 26, 34, 54, 55, 25, 30, 45, 54, 22, 25, 32 /)
  INTEGER, PARAMETER, DIMENSION(292) :: IROW_STOICM_1 = (/ &
      54, 24, 38, 54, 28, 38, 54, 29, 38, 54, 27, 38, &
      54,  2, 24, 26, 43, 46, 51,  2,  3, 17, 26, 28, &
      43, 46, 48, 51, 52, 53,  2,  3, 17, 26, 29, 33, &
      43, 46, 48, 51, 52, 53,  2,  3, 26, 27, 43, 46, &
      48, 51, 52, 53, 21, 51, 52, 42, 51, 57, 42, 51, &
      56, 41, 42, 51, 42, 44, 51, 40, 42, 51, 37, 42, &
      51, 42, 49, 51, 42, 50, 51, 18, 51, 55, 35, 42, &
      51, 36, 42, 51, 42, 45, 51, 38, 47, 51, 43, 51, &
      52, 43, 48, 51, 52, 57, 33, 43, 48, 51, 52, 56, &
      33, 41, 43, 48, 51, 52, 33, 43, 44, 48, 51, 52, &
      40, 43, 48, 51, 52, 37, 43, 48, 51, 52, 33, 43, &
      48, 49, 51, 52, 34, 43, 50, 51, 52,  3, 43, 51, &
      52, 55, 30, 31, 34, 35, 43, 51, 52, 30, 34, 36, &
      43, 51, 52,  3, 26, 31, 34, 39, 43, 45, 51, 52, &
      55,  3, 48, 51, 52, 55, 57,  3, 33, 48, 51, 52, &
      55, 56,  3, 33, 41, 48, 51, 52, 55,  3, 33, 44, &
      48, 51, 52, 55,  3, 40, 43, 48, 51, 52, 55,  3, &
      37, 43, 48, 51, 52, 55,  3, 33, 43, 48, 49, 51, &
      52, 55,  3, 34, 50, 51, 52, 55, 52, 55, 30, 31, &
      34, 35, 51, 52, 55, 30, 34, 36, 51, 52, 55, 26, &
      31, 34, 39, 45, 51, 52, 55, 39, 42, 51, 39, 43, &
      51, 52, 39, 52, 55, 39, 39, 58, 59, 32, 47, 59, &
      32, 42, 51, 32, 43, 51, 52, 32, 52, 55, 32, 38, &
      43, 48, 51, 52, 59,  3, 38, 43, 48, 52, 55, 59, &
      38, 43, 48, 59 /)
  INTEGER, PARAMETER, DIMENSION(652) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  4,  4,  4,  5,  5, &
       5,  6,  6,  6,  6,  6,  7,  7,  8,  8,  8,  9, &
       9, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, &
      13, 13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, &
      17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, &
      20, 20, 21, 21, 21, 21, 21, 22, 22, 23, 23, 23, &
      24, 24, 25, 25, 26, 26, 26, 27, 27, 27, 28, 28, &
      28, 29, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, &
      32, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 37, &
      37, 37, 38, 38, 38, 39, 39, 40, 40, 40, 41, 41, &
      41, 42, 42, 42, 43, 43, 44, 44, 44, 45, 45, 45, &
      46, 46, 46, 47, 47, 48, 48, 48, 48, 49, 49, 49, &
      49, 50, 50, 50, 51, 51, 51, 52, 52, 52, 52, 52, &
      52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, &
      55, 56, 56, 56, 57, 57, 57, 58, 58, 58, 58, 58, &
      59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 61, 61, &
      61, 61, 62, 62, 62, 63, 63, 63, 64, 64, 64, 64, &
      65, 65, 65, 65, 66, 66, 66, 67, 67, 67, 67, 68, &
      68, 68, 68, 69, 69, 69, 70, 70, 70, 70, 70, 71, &
      71, 71, 71, 72, 72, 72, 73, 73, 73, 74, 74, 74, &
      75, 75, 75, 76, 76, 76, 77, 77, 77, 77, 77, 78, &
      78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, &
      79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 81, 81, &
      81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 83, 83, &
      83, 83, 83, 83, 83, 84, 84, 84, 84, 85, 85, 85, &
      85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, &
      86, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, &
      89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 91, 91, &
      91, 91, 91, 92, 92, 92, 92, 93, 93, 93, 93, 93, &
      94, 94, 94, 94, 94, 95, 95, 95, 95, 96, 96, 96 /)
  INTEGER, PARAMETER, DIMENSION(292) :: ICOL_STOICM_1 = (/ &
      96, 97, 97, 97, 98, 98, 98, 99, 99, 99,100,100, &
     100,101,101,101,101,101,101,102,102,102,102,102, &
     102,102,102,102,102,102,103,103,103,103,103,103, &
     103,103,103,103,103,103,104,104,104,104,104,104, &
     104,104,104,104,105,105,105,106,106,106,107,107, &
     107,108,108,108,109,109,109,110,110,110,111,111, &
     111,112,112,112,113,113,113,114,114,114,115,115, &
     115,116,116,116,117,117,117,118,118,118,119,119, &
     119,120,120,120,120,120,121,121,121,121,121,121, &
     122,122,122,122,122,122,123,123,123,123,123,123, &
     124,124,124,124,124,125,125,125,125,125,126,126, &
     126,126,126,126,127,127,127,127,127,128,128,128, &
     128,128,129,129,129,129,129,129,129,130,130,130, &
     130,130,130,131,131,131,131,131,131,131,131,131, &
     131,132,132,132,132,132,132,133,133,133,133,133, &
     133,133,134,134,134,134,134,134,134,135,135,135, &
     135,135,135,135,136,136,136,136,136,136,136,137, &
     137,137,137,137,137,137,138,138,138,138,138,138, &
     138,138,139,139,139,139,139,139,140,140,141,141, &
     141,141,141,141,141,142,142,142,142,142,142,143, &
     143,143,143,143,143,143,143,144,144,144,145,145, &
     145,145,146,146,146,147,148,148,148,149,149,149, &
     150,150,150,151,151,151,151,152,152,152,153,154, &
     154,154,154,154,154,155,155,155,155,155,155,155, &
     156,156,156,156 /)
  INTEGER, PARAMETER, DIMENSION(652) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  6.500000e-01_dp, &
       3.500000e-01_dp,  3.500000e-01_dp,  6.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.870000e+00_dp,  -1.000000e+00_dp, &
       1.300000e-01_dp,  1.550000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  8.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-02_dp,  9.000000e-03_dp,  7.500000e-02_dp, &
       1.700000e-01_dp,  -1.000000e+00_dp,  8.300000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.700000e-01_dp,  8.300000e-01_dp,  1.700000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  9.000000e-01_dp,  9.000000e-01_dp,  1.000000e-01_dp,  -1.900000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -5.000000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  -5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.500000e-01_dp,  9.000000e-02_dp,  3.600000e-02_dp,  7.500000e-01_dp, &
       9.640000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.640000e-01_dp,  6.900000e-01_dp, &
       -1.000000e+00_dp,  8.000000e-02_dp,  3.800000e-01_dp,  9.200000e-01_dp,  -1.000000e+00_dp, &
       9.200000e-01_dp,  1.060000e+00_dp,  4.000000e-02_dp,  -1.000000e+00_dp,  2.400000e-01_dp, &
       3.500000e-01_dp,  7.600000e-01_dp,  -1.000000e+00_dp,  7.600000e-01_dp,  -1.000000e+00_dp, &
       1.600000e+00_dp,  2.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e-01_dp,  2.800000e-01_dp,  1.450000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  9.500000e-01_dp,  8.900000e-01_dp,  1.100000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       2.000000e+00_dp,  -1.000000e+00_dp,  9.200000e-01_dp,  5.000000e-02_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  7.000000e-01_dp,  1.600000e-01_dp,  1.700000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.060000e-01_dp,  4.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -5.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  -1.000000e+00_dp, &
       4.200000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.200000e-01_dp,  2.000000e-01_dp, &
       2.000000e-01_dp,  6.000000e-02_dp,  3.300000e-01_dp,  -1.000000e+00_dp,  5.300000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  2.300000e-01_dp,  2.200000e-01_dp,  1.000000e-01_dp, &
       6.000000e-02_dp,  2.900000e-01_dp,  9.000000e-02_dp,  2.300000e-01_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  1.800000e-01_dp,  -1.000000e+00_dp,  7.200000e-01_dp,  2.600000e-01_dp, &
       3.100000e-01_dp,  1.400000e-01_dp,  2.000000e-01_dp,  2.000000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  5.300000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  2.300000e-01_dp, &
       2.200000e-01_dp,  1.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.500000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  7.500000e-01_dp,  7.500000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  6.000000e-01_dp,  7.500000e-01_dp,  1.500000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  -1.000000e+00_dp, &
       7.700000e-01_dp,  4.100000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.390000e+00_dp, &
       8.000000e-01_dp,  -1.000000e+00_dp,  4.600000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.550000e+00_dp,  3.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.250000e+00_dp,  7.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.500000e-01_dp,  8.900000e-01_dp,  7.250000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  7.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  -5.000000e-01_dp, &
       -1.000000e+00_dp,  7.000000e-01_dp,  1.600000e-01_dp,  1.700000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  8.060000e-01_dp,  4.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       4.750000e-01_dp,  4.450000e-01_dp,  5.500000e-02_dp,  1.000000e+00_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  4.600000e-01_dp,  -1.000000e+00_dp,  2.500000e-02_dp,  5.000000e-01_dp, &
       1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  8.000000e-01_dp,  2.000000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  8.600000e-01_dp,  -1.000000e+00_dp, &
       1.400000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       9.000000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  6.000000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.500000e-01_dp,  1.400000e-01_dp,  7.250000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  1.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  9.500000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(52) :: STOICM_4 = (/ &
       8.900000e-01_dp,  1.100000e-01_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  9.200000e-01_dp, &
       1.000000e+00_dp,  -9.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -2.000000e+00_dp, &
       -1.000000e+00_dp,  1.750000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp, &
       2.000000e+00_dp,  2.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(652) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4 /)


END MODULE RADM2_StoichiomSP

