! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADM2_Stoichiom.f90
! Time                 : Thu Oct  8 08:22:27 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADM2_18938_BOXMOX
! Equation file        : RADM2.kpp
! Output root filename : RADM2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADM2_Stoichiom

  USE RADM2_Parameters
  USE RADM2_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(59)
  ARP(2) = V(46)
  ARP(3) = V(46)
  ARP(4) = V(13)
  ARP(5) = V(25)
  ARP(6) = V(20)
  ARP(7) = V(54)
  ARP(8) = V(54)
  ARP(9) = V(14)
  ARP(10) = V(43)
  ARP(11) = V(43)
  ARP(12) = V(48)
  ARP(13) = V(21)
  ARP(14) = V(42)
  ARP(15) = V(18)
  ARP(16) = V(33)
  ARP(17) = V(31)
  ARP(18) = V(31)
  ARP(19) = V(34)
  ARP(20) = V(30)
  ARP(21) = V(47)
  ARP(22) = V(19)*F(2)
  ARP(23) = V(19)*V(59)
  ARP(24) = V(7)*F(2)
  ARP(25) = V(7)*F(1)
  ARP(26) = V(46)*V(58)
  ARP(27) = V(46)*V(53)
  ARP(28) = V(46)*V(51)
  ARP(29) = V(51)*V(58)
  ARP(30) = V(51)*V(59)
  ARP(31) = V(20)
  ARP(32) = V(51)*V(51)
  ARP(33) = V(51)*V(51)*F(1)
  ARP(34) = V(14)*V(53)
  ARP(35) = V(53)*V(58)
  ARP(36) = V(58)*V(58)*F(2)
  ARP(37) = V(46)*V(59)
  ARP(38) = V(54)*V(58)
  ARP(39) = V(54)*V(59)
  ARP(40) = V(51)*V(54)
  ARP(41) = V(54)*V(59)
  ARP(42) = V(15)
  ARP(43) = V(15)
  ARP(44) = V(53)*V(59)
  ARP(45) = V(25)*V(53)
  ARP(46) = V(20)*V(53)
  ARP(47) = V(51)*V(53)
  ARP(48) = V(5)*V(53)
  ARP(49) = V(26)*V(53)
  ARP(50) = V(17)*V(53)
  ARP(51) = V(6)*V(53)
  ARP(52) = V(16)*V(53)
  ARP(53) = V(8)*V(53)
  ARP(54) = V(9)*V(53)
  ARP(55) = V(24)*V(53)
  ARP(56) = V(28)*V(53)
  ARP(57) = V(29)*V(53)
  ARP(58) = V(10)*V(53)
  ARP(59) = V(11)*V(53)
  ARP(60) = V(22)*V(53)
  ARP(61) = V(43)*V(53)
  ARP(62) = V(48)*V(53)
  ARP(63) = V(33)*V(53)
  ARP(64) = V(31)*V(53)
  ARP(65) = V(34)*V(53)
  ARP(66) = V(30)*V(53)
  ARP(67) = V(21)*V(53)
  ARP(68) = V(42)*V(53)
  ARP(69) = V(18)*V(53)
  ARP(70) = V(23)*V(53)
  ARP(71) = V(47)*V(53)
  ARP(72) = V(27)*V(53)
  ARP(73) = V(55)*V(59)
  ARP(74) = V(23)
  ARP(75) = V(45)*V(59)
  ARP(76) = V(12)
  ARP(77) = V(52)*V(58)
  ARP(78) = V(56)*V(58)
  ARP(79) = V(41)*V(58)
  ARP(80) = V(44)*V(58)
  ARP(81) = V(40)*V(58)
  ARP(82) = V(37)*V(58)
  ARP(83) = V(49)*V(58)
  ARP(84) = V(55)*V(58)
  ARP(85) = V(45)*V(58)
  ARP(86) = V(35)*V(58)
  ARP(87) = V(36)*V(58)
  ARP(88) = V(57)*V(58)
  ARP(89) = V(50)*V(58)
  ARP(90) = V(38)*V(58)
  ARP(91) = V(43)*V(54)
  ARP(92) = V(48)*V(54)
  ARP(93) = V(31)*V(54)
  ARP(94) = V(34)*V(54)
  ARP(95) = V(30)*V(54)
  ARP(96) = V(22)*V(54)
  ARP(97) = V(24)*V(54)
  ARP(98) = V(28)*V(54)
  ARP(99) = V(29)*V(54)
  ARP(100) = V(27)*V(54)
  ARP(101) = V(24)*V(46)
  ARP(102) = V(28)*V(46)
  ARP(103) = V(29)*V(46)
  ARP(104) = V(27)*V(46)
  ARP(105) = V(51)*V(52)
  ARP(106) = V(51)*V(57)
  ARP(107) = V(51)*V(56)
  ARP(108) = V(41)*V(51)
  ARP(109) = V(44)*V(51)
  ARP(110) = V(40)*V(51)
  ARP(111) = V(37)*V(51)
  ARP(112) = V(49)*V(51)
  ARP(113) = V(50)*V(51)
  ARP(114) = V(51)*V(55)
  ARP(115) = V(35)*V(51)
  ARP(116) = V(36)*V(51)
  ARP(117) = V(45)*V(51)
  ARP(118) = V(38)*V(51)
  ARP(119) = V(52)*V(52)
  ARP(120) = V(52)*V(57)
  ARP(121) = V(52)*V(56)
  ARP(122) = V(41)*V(52)
  ARP(123) = V(44)*V(52)
  ARP(124) = V(40)*V(52)
  ARP(125) = V(37)*V(52)
  ARP(126) = V(49)*V(52)
  ARP(127) = V(50)*V(52)
  ARP(128) = V(52)*V(55)
  ARP(129) = V(35)*V(52)
  ARP(130) = V(36)*V(52)
  ARP(131) = V(45)*V(52)
  ARP(132) = V(55)*V(57)
  ARP(133) = V(55)*V(56)
  ARP(134) = V(41)*V(55)
  ARP(135) = V(44)*V(55)
  ARP(136) = V(40)*V(55)
  ARP(137) = V(37)*V(55)
  ARP(138) = V(49)*V(55)
  ARP(139) = V(50)*V(55)
  ARP(140) = V(55)*V(55)
  ARP(141) = V(35)*V(55)
  ARP(142) = V(36)*V(55)
  ARP(143) = V(45)*V(55)
  ARP(144) = V(39)*V(51)
  ARP(145) = V(39)*V(52)
  ARP(146) = V(39)*V(55)
  ARP(147) = V(39)*V(39)
  ARP(148) = V(39)*V(58)
  ARP(149) = V(32)*V(59)
  ARP(150) = V(32)*V(51)
  ARP(151) = V(32)*V(52)
  ARP(152) = V(32)*V(55)
  ARP(153) = V(32)*V(32)
  ARP(154) = V(38)*V(52)
  ARP(155) = V(38)*V(55)
  ARP(156) = V(38)*V(38)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(59)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(46)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(46)
  JVRP(3) = 1
! JVRP(4) = dARP(4)/dV(13)
  JVRP(4) = 1
! JVRP(5) = dARP(5)/dV(25)
  JVRP(5) = 1
! JVRP(6) = dARP(6)/dV(20)
  JVRP(6) = 1
! JVRP(7) = dARP(7)/dV(54)
  JVRP(7) = 1
! JVRP(8) = dARP(8)/dV(54)
  JVRP(8) = 1
! JVRP(9) = dARP(9)/dV(14)
  JVRP(9) = 1
! JVRP(10) = dARP(10)/dV(43)
  JVRP(10) = 1
! JVRP(11) = dARP(11)/dV(43)
  JVRP(11) = 1
! JVRP(12) = dARP(12)/dV(48)
  JVRP(12) = 1
! JVRP(13) = dARP(13)/dV(21)
  JVRP(13) = 1
! JVRP(14) = dARP(14)/dV(42)
  JVRP(14) = 1
! JVRP(15) = dARP(15)/dV(18)
  JVRP(15) = 1
! JVRP(16) = dARP(16)/dV(33)
  JVRP(16) = 1
! JVRP(17) = dARP(17)/dV(31)
  JVRP(17) = 1
! JVRP(18) = dARP(18)/dV(31)
  JVRP(18) = 1
! JVRP(19) = dARP(19)/dV(34)
  JVRP(19) = 1
! JVRP(20) = dARP(20)/dV(30)
  JVRP(20) = 1
! JVRP(21) = dARP(21)/dV(47)
  JVRP(21) = 1
! JVRP(22) = dARP(22)/dV(19)
  JVRP(22) = F(2)
! JVRP(23) = dARP(23)/dV(19)
  JVRP(23) = V(59)
! JVRP(24) = dARP(23)/dV(59)
  JVRP(24) = V(19)
! JVRP(25) = dARP(24)/dV(7)
  JVRP(25) = F(2)
! JVRP(26) = dARP(25)/dV(7)
  JVRP(26) = F(1)
! JVRP(27) = dARP(26)/dV(46)
  JVRP(27) = V(58)
! JVRP(28) = dARP(26)/dV(58)
  JVRP(28) = V(46)
! JVRP(29) = dARP(27)/dV(46)
  JVRP(29) = V(53)
! JVRP(30) = dARP(27)/dV(53)
  JVRP(30) = V(46)
! JVRP(31) = dARP(28)/dV(46)
  JVRP(31) = V(51)
! JVRP(32) = dARP(28)/dV(51)
  JVRP(32) = V(46)
! JVRP(33) = dARP(29)/dV(51)
  JVRP(33) = V(58)
! JVRP(34) = dARP(29)/dV(58)
  JVRP(34) = V(51)
! JVRP(35) = dARP(30)/dV(51)
  JVRP(35) = V(59)
! JVRP(36) = dARP(30)/dV(59)
  JVRP(36) = V(51)
! JVRP(37) = dARP(31)/dV(20)
  JVRP(37) = 1
! JVRP(38) = dARP(32)/dV(51)
  JVRP(38) = 2*V(51)
! JVRP(39) = dARP(33)/dV(51)
  JVRP(39) = 2*V(51)*F(1)
! JVRP(40) = dARP(34)/dV(14)
  JVRP(40) = V(53)
! JVRP(41) = dARP(34)/dV(53)
  JVRP(41) = V(14)
! JVRP(42) = dARP(35)/dV(53)
  JVRP(42) = V(58)
! JVRP(43) = dARP(35)/dV(58)
  JVRP(43) = V(53)
! JVRP(44) = dARP(36)/dV(58)
  JVRP(44) = 2*V(58)*F(2)
! JVRP(45) = dARP(37)/dV(46)
  JVRP(45) = V(59)
! JVRP(46) = dARP(37)/dV(59)
  JVRP(46) = V(46)
! JVRP(47) = dARP(38)/dV(54)
  JVRP(47) = V(58)
! JVRP(48) = dARP(38)/dV(58)
  JVRP(48) = V(54)
! JVRP(49) = dARP(39)/dV(54)
  JVRP(49) = V(59)
! JVRP(50) = dARP(39)/dV(59)
  JVRP(50) = V(54)
! JVRP(51) = dARP(40)/dV(51)
  JVRP(51) = V(54)
! JVRP(52) = dARP(40)/dV(54)
  JVRP(52) = V(51)
! JVRP(53) = dARP(41)/dV(54)
  JVRP(53) = V(59)
! JVRP(54) = dARP(41)/dV(59)
  JVRP(54) = V(54)
! JVRP(55) = dARP(42)/dV(15)
  JVRP(55) = 1
! JVRP(56) = dARP(43)/dV(15)
  JVRP(56) = 1
! JVRP(57) = dARP(44)/dV(53)
  JVRP(57) = V(59)
! JVRP(58) = dARP(44)/dV(59)
  JVRP(58) = V(53)
! JVRP(59) = dARP(45)/dV(25)
  JVRP(59) = V(53)
! JVRP(60) = dARP(45)/dV(53)
  JVRP(60) = V(25)
! JVRP(61) = dARP(46)/dV(20)
  JVRP(61) = V(53)
! JVRP(62) = dARP(46)/dV(53)
  JVRP(62) = V(20)
! JVRP(63) = dARP(47)/dV(51)
  JVRP(63) = V(53)
! JVRP(64) = dARP(47)/dV(53)
  JVRP(64) = V(51)
! JVRP(65) = dARP(48)/dV(5)
  JVRP(65) = V(53)
! JVRP(66) = dARP(48)/dV(53)
  JVRP(66) = V(5)
! JVRP(67) = dARP(49)/dV(26)
  JVRP(67) = V(53)
! JVRP(68) = dARP(49)/dV(53)
  JVRP(68) = V(26)
! JVRP(69) = dARP(50)/dV(17)
  JVRP(69) = V(53)
! JVRP(70) = dARP(50)/dV(53)
  JVRP(70) = V(17)
! JVRP(71) = dARP(51)/dV(6)
  JVRP(71) = V(53)
! JVRP(72) = dARP(51)/dV(53)
  JVRP(72) = V(6)
! JVRP(73) = dARP(52)/dV(16)
  JVRP(73) = V(53)
! JVRP(74) = dARP(52)/dV(53)
  JVRP(74) = V(16)
! JVRP(75) = dARP(53)/dV(8)
  JVRP(75) = V(53)
! JVRP(76) = dARP(53)/dV(53)
  JVRP(76) = V(8)
! JVRP(77) = dARP(54)/dV(9)
  JVRP(77) = V(53)
! JVRP(78) = dARP(54)/dV(53)
  JVRP(78) = V(9)
! JVRP(79) = dARP(55)/dV(24)
  JVRP(79) = V(53)
! JVRP(80) = dARP(55)/dV(53)
  JVRP(80) = V(24)
! JVRP(81) = dARP(56)/dV(28)
  JVRP(81) = V(53)
! JVRP(82) = dARP(56)/dV(53)
  JVRP(82) = V(28)
! JVRP(83) = dARP(57)/dV(29)
  JVRP(83) = V(53)
! JVRP(84) = dARP(57)/dV(53)
  JVRP(84) = V(29)
! JVRP(85) = dARP(58)/dV(10)
  JVRP(85) = V(53)
! JVRP(86) = dARP(58)/dV(53)
  JVRP(86) = V(10)
! JVRP(87) = dARP(59)/dV(11)
  JVRP(87) = V(53)
! JVRP(88) = dARP(59)/dV(53)
  JVRP(88) = V(11)
! JVRP(89) = dARP(60)/dV(22)
  JVRP(89) = V(53)
! JVRP(90) = dARP(60)/dV(53)
  JVRP(90) = V(22)
! JVRP(91) = dARP(61)/dV(43)
  JVRP(91) = V(53)
! JVRP(92) = dARP(61)/dV(53)
  JVRP(92) = V(43)
! JVRP(93) = dARP(62)/dV(48)
  JVRP(93) = V(53)
! JVRP(94) = dARP(62)/dV(53)
  JVRP(94) = V(48)
! JVRP(95) = dARP(63)/dV(33)
  JVRP(95) = V(53)
! JVRP(96) = dARP(63)/dV(53)
  JVRP(96) = V(33)
! JVRP(97) = dARP(64)/dV(31)
  JVRP(97) = V(53)
! JVRP(98) = dARP(64)/dV(53)
  JVRP(98) = V(31)
! JVRP(99) = dARP(65)/dV(34)
  JVRP(99) = V(53)
! JVRP(100) = dARP(65)/dV(53)
  JVRP(100) = V(34)
! JVRP(101) = dARP(66)/dV(30)
  JVRP(101) = V(53)
! JVRP(102) = dARP(66)/dV(53)
  JVRP(102) = V(30)
! JVRP(103) = dARP(67)/dV(21)
  JVRP(103) = V(53)
! JVRP(104) = dARP(67)/dV(53)
  JVRP(104) = V(21)
! JVRP(105) = dARP(68)/dV(42)
  JVRP(105) = V(53)
! JVRP(106) = dARP(68)/dV(53)
  JVRP(106) = V(42)
! JVRP(107) = dARP(69)/dV(18)
  JVRP(107) = V(53)
! JVRP(108) = dARP(69)/dV(53)
  JVRP(108) = V(18)
! JVRP(109) = dARP(70)/dV(23)
  JVRP(109) = V(53)
! JVRP(110) = dARP(70)/dV(53)
  JVRP(110) = V(23)
! JVRP(111) = dARP(71)/dV(47)
  JVRP(111) = V(53)
! JVRP(112) = dARP(71)/dV(53)
  JVRP(112) = V(47)
! JVRP(113) = dARP(72)/dV(27)
  JVRP(113) = V(53)
! JVRP(114) = dARP(72)/dV(53)
  JVRP(114) = V(27)
! JVRP(115) = dARP(73)/dV(55)
  JVRP(115) = V(59)
! JVRP(116) = dARP(73)/dV(59)
  JVRP(116) = V(55)
! JVRP(117) = dARP(74)/dV(23)
  JVRP(117) = 1
! JVRP(118) = dARP(75)/dV(45)
  JVRP(118) = V(59)
! JVRP(119) = dARP(75)/dV(59)
  JVRP(119) = V(45)
! JVRP(120) = dARP(76)/dV(12)
  JVRP(120) = 1
! JVRP(121) = dARP(77)/dV(52)
  JVRP(121) = V(58)
! JVRP(122) = dARP(77)/dV(58)
  JVRP(122) = V(52)
! JVRP(123) = dARP(78)/dV(56)
  JVRP(123) = V(58)
! JVRP(124) = dARP(78)/dV(58)
  JVRP(124) = V(56)
! JVRP(125) = dARP(79)/dV(41)
  JVRP(125) = V(58)
! JVRP(126) = dARP(79)/dV(58)
  JVRP(126) = V(41)
! JVRP(127) = dARP(80)/dV(44)
  JVRP(127) = V(58)
! JVRP(128) = dARP(80)/dV(58)
  JVRP(128) = V(44)
! JVRP(129) = dARP(81)/dV(40)
  JVRP(129) = V(58)
! JVRP(130) = dARP(81)/dV(58)
  JVRP(130) = V(40)
! JVRP(131) = dARP(82)/dV(37)
  JVRP(131) = V(58)
! JVRP(132) = dARP(82)/dV(58)
  JVRP(132) = V(37)
! JVRP(133) = dARP(83)/dV(49)
  JVRP(133) = V(58)
! JVRP(134) = dARP(83)/dV(58)
  JVRP(134) = V(49)
! JVRP(135) = dARP(84)/dV(55)
  JVRP(135) = V(58)
! JVRP(136) = dARP(84)/dV(58)
  JVRP(136) = V(55)
! JVRP(137) = dARP(85)/dV(45)
  JVRP(137) = V(58)
! JVRP(138) = dARP(85)/dV(58)
  JVRP(138) = V(45)
! JVRP(139) = dARP(86)/dV(35)
  JVRP(139) = V(58)
! JVRP(140) = dARP(86)/dV(58)
  JVRP(140) = V(35)
! JVRP(141) = dARP(87)/dV(36)
  JVRP(141) = V(58)
! JVRP(142) = dARP(87)/dV(58)
  JVRP(142) = V(36)
! JVRP(143) = dARP(88)/dV(57)
  JVRP(143) = V(58)
! JVRP(144) = dARP(88)/dV(58)
  JVRP(144) = V(57)
! JVRP(145) = dARP(89)/dV(50)
  JVRP(145) = V(58)
! JVRP(146) = dARP(89)/dV(58)
  JVRP(146) = V(50)
! JVRP(147) = dARP(90)/dV(38)
  JVRP(147) = V(58)
! JVRP(148) = dARP(90)/dV(58)
  JVRP(148) = V(38)
! JVRP(149) = dARP(91)/dV(43)
  JVRP(149) = V(54)
! JVRP(150) = dARP(91)/dV(54)
  JVRP(150) = V(43)
! JVRP(151) = dARP(92)/dV(48)
  JVRP(151) = V(54)
! JVRP(152) = dARP(92)/dV(54)
  JVRP(152) = V(48)
! JVRP(153) = dARP(93)/dV(31)
  JVRP(153) = V(54)
! JVRP(154) = dARP(93)/dV(54)
  JVRP(154) = V(31)
! JVRP(155) = dARP(94)/dV(34)
  JVRP(155) = V(54)
! JVRP(156) = dARP(94)/dV(54)
  JVRP(156) = V(34)
! JVRP(157) = dARP(95)/dV(30)
  JVRP(157) = V(54)
! JVRP(158) = dARP(95)/dV(54)
  JVRP(158) = V(30)
! JVRP(159) = dARP(96)/dV(22)
  JVRP(159) = V(54)
! JVRP(160) = dARP(96)/dV(54)
  JVRP(160) = V(22)
! JVRP(161) = dARP(97)/dV(24)
  JVRP(161) = V(54)
! JVRP(162) = dARP(97)/dV(54)
  JVRP(162) = V(24)
! JVRP(163) = dARP(98)/dV(28)
  JVRP(163) = V(54)
! JVRP(164) = dARP(98)/dV(54)
  JVRP(164) = V(28)
! JVRP(165) = dARP(99)/dV(29)
  JVRP(165) = V(54)
! JVRP(166) = dARP(99)/dV(54)
  JVRP(166) = V(29)
! JVRP(167) = dARP(100)/dV(27)
  JVRP(167) = V(54)
! JVRP(168) = dARP(100)/dV(54)
  JVRP(168) = V(27)
! JVRP(169) = dARP(101)/dV(24)
  JVRP(169) = V(46)
! JVRP(170) = dARP(101)/dV(46)
  JVRP(170) = V(24)
! JVRP(171) = dARP(102)/dV(28)
  JVRP(171) = V(46)
! JVRP(172) = dARP(102)/dV(46)
  JVRP(172) = V(28)
! JVRP(173) = dARP(103)/dV(29)
  JVRP(173) = V(46)
! JVRP(174) = dARP(103)/dV(46)
  JVRP(174) = V(29)
! JVRP(175) = dARP(104)/dV(27)
  JVRP(175) = V(46)
! JVRP(176) = dARP(104)/dV(46)
  JVRP(176) = V(27)
! JVRP(177) = dARP(105)/dV(51)
  JVRP(177) = V(52)
! JVRP(178) = dARP(105)/dV(52)
  JVRP(178) = V(51)
! JVRP(179) = dARP(106)/dV(51)
  JVRP(179) = V(57)
! JVRP(180) = dARP(106)/dV(57)
  JVRP(180) = V(51)
! JVRP(181) = dARP(107)/dV(51)
  JVRP(181) = V(56)
! JVRP(182) = dARP(107)/dV(56)
  JVRP(182) = V(51)
! JVRP(183) = dARP(108)/dV(41)
  JVRP(183) = V(51)
! JVRP(184) = dARP(108)/dV(51)
  JVRP(184) = V(41)
! JVRP(185) = dARP(109)/dV(44)
  JVRP(185) = V(51)
! JVRP(186) = dARP(109)/dV(51)
  JVRP(186) = V(44)
! JVRP(187) = dARP(110)/dV(40)
  JVRP(187) = V(51)
! JVRP(188) = dARP(110)/dV(51)
  JVRP(188) = V(40)
! JVRP(189) = dARP(111)/dV(37)
  JVRP(189) = V(51)
! JVRP(190) = dARP(111)/dV(51)
  JVRP(190) = V(37)
! JVRP(191) = dARP(112)/dV(49)
  JVRP(191) = V(51)
! JVRP(192) = dARP(112)/dV(51)
  JVRP(192) = V(49)
! JVRP(193) = dARP(113)/dV(50)
  JVRP(193) = V(51)
! JVRP(194) = dARP(113)/dV(51)
  JVRP(194) = V(50)
! JVRP(195) = dARP(114)/dV(51)
  JVRP(195) = V(55)
! JVRP(196) = dARP(114)/dV(55)
  JVRP(196) = V(51)
! JVRP(197) = dARP(115)/dV(35)
  JVRP(197) = V(51)
! JVRP(198) = dARP(115)/dV(51)
  JVRP(198) = V(35)
! JVRP(199) = dARP(116)/dV(36)
  JVRP(199) = V(51)
! JVRP(200) = dARP(116)/dV(51)
  JVRP(200) = V(36)
! JVRP(201) = dARP(117)/dV(45)
  JVRP(201) = V(51)
! JVRP(202) = dARP(117)/dV(51)
  JVRP(202) = V(45)
! JVRP(203) = dARP(118)/dV(38)
  JVRP(203) = V(51)
! JVRP(204) = dARP(118)/dV(51)
  JVRP(204) = V(38)
! JVRP(205) = dARP(119)/dV(52)
  JVRP(205) = 2*V(52)
! JVRP(206) = dARP(120)/dV(52)
  JVRP(206) = V(57)
! JVRP(207) = dARP(120)/dV(57)
  JVRP(207) = V(52)
! JVRP(208) = dARP(121)/dV(52)
  JVRP(208) = V(56)
! JVRP(209) = dARP(121)/dV(56)
  JVRP(209) = V(52)
! JVRP(210) = dARP(122)/dV(41)
  JVRP(210) = V(52)
! JVRP(211) = dARP(122)/dV(52)
  JVRP(211) = V(41)
! JVRP(212) = dARP(123)/dV(44)
  JVRP(212) = V(52)
! JVRP(213) = dARP(123)/dV(52)
  JVRP(213) = V(44)
! JVRP(214) = dARP(124)/dV(40)
  JVRP(214) = V(52)
! JVRP(215) = dARP(124)/dV(52)
  JVRP(215) = V(40)
! JVRP(216) = dARP(125)/dV(37)
  JVRP(216) = V(52)
! JVRP(217) = dARP(125)/dV(52)
  JVRP(217) = V(37)
! JVRP(218) = dARP(126)/dV(49)
  JVRP(218) = V(52)
! JVRP(219) = dARP(126)/dV(52)
  JVRP(219) = V(49)
! JVRP(220) = dARP(127)/dV(50)
  JVRP(220) = V(52)
! JVRP(221) = dARP(127)/dV(52)
  JVRP(221) = V(50)
! JVRP(222) = dARP(128)/dV(52)
  JVRP(222) = V(55)
! JVRP(223) = dARP(128)/dV(55)
  JVRP(223) = V(52)
! JVRP(224) = dARP(129)/dV(35)
  JVRP(224) = V(52)
! JVRP(225) = dARP(129)/dV(52)
  JVRP(225) = V(35)
! JVRP(226) = dARP(130)/dV(36)
  JVRP(226) = V(52)
! JVRP(227) = dARP(130)/dV(52)
  JVRP(227) = V(36)
! JVRP(228) = dARP(131)/dV(45)
  JVRP(228) = V(52)
! JVRP(229) = dARP(131)/dV(52)
  JVRP(229) = V(45)
! JVRP(230) = dARP(132)/dV(55)
  JVRP(230) = V(57)
! JVRP(231) = dARP(132)/dV(57)
  JVRP(231) = V(55)
! JVRP(232) = dARP(133)/dV(55)
  JVRP(232) = V(56)
! JVRP(233) = dARP(133)/dV(56)
  JVRP(233) = V(55)
! JVRP(234) = dARP(134)/dV(41)
  JVRP(234) = V(55)
! JVRP(235) = dARP(134)/dV(55)
  JVRP(235) = V(41)
! JVRP(236) = dARP(135)/dV(44)
  JVRP(236) = V(55)
! JVRP(237) = dARP(135)/dV(55)
  JVRP(237) = V(44)
! JVRP(238) = dARP(136)/dV(40)
  JVRP(238) = V(55)
! JVRP(239) = dARP(136)/dV(55)
  JVRP(239) = V(40)
! JVRP(240) = dARP(137)/dV(37)
  JVRP(240) = V(55)
! JVRP(241) = dARP(137)/dV(55)
  JVRP(241) = V(37)
! JVRP(242) = dARP(138)/dV(49)
  JVRP(242) = V(55)
! JVRP(243) = dARP(138)/dV(55)
  JVRP(243) = V(49)
! JVRP(244) = dARP(139)/dV(50)
  JVRP(244) = V(55)
! JVRP(245) = dARP(139)/dV(55)
  JVRP(245) = V(50)
! JVRP(246) = dARP(140)/dV(55)
  JVRP(246) = 2*V(55)
! JVRP(247) = dARP(141)/dV(35)
  JVRP(247) = V(55)
! JVRP(248) = dARP(141)/dV(55)
  JVRP(248) = V(35)
! JVRP(249) = dARP(142)/dV(36)
  JVRP(249) = V(55)
! JVRP(250) = dARP(142)/dV(55)
  JVRP(250) = V(36)
! JVRP(251) = dARP(143)/dV(45)
  JVRP(251) = V(55)
! JVRP(252) = dARP(143)/dV(55)
  JVRP(252) = V(45)
! JVRP(253) = dARP(144)/dV(39)
  JVRP(253) = V(51)
! JVRP(254) = dARP(144)/dV(51)
  JVRP(254) = V(39)
! JVRP(255) = dARP(145)/dV(39)
  JVRP(255) = V(52)
! JVRP(256) = dARP(145)/dV(52)
  JVRP(256) = V(39)
! JVRP(257) = dARP(146)/dV(39)
  JVRP(257) = V(55)
! JVRP(258) = dARP(146)/dV(55)
  JVRP(258) = V(39)
! JVRP(259) = dARP(147)/dV(39)
  JVRP(259) = 2*V(39)
! JVRP(260) = dARP(148)/dV(39)
  JVRP(260) = V(58)
! JVRP(261) = dARP(148)/dV(58)
  JVRP(261) = V(39)
! JVRP(262) = dARP(149)/dV(32)
  JVRP(262) = V(59)
! JVRP(263) = dARP(149)/dV(59)
  JVRP(263) = V(32)
! JVRP(264) = dARP(150)/dV(32)
  JVRP(264) = V(51)
! JVRP(265) = dARP(150)/dV(51)
  JVRP(265) = V(32)
! JVRP(266) = dARP(151)/dV(32)
  JVRP(266) = V(52)
! JVRP(267) = dARP(151)/dV(52)
  JVRP(267) = V(32)
! JVRP(268) = dARP(152)/dV(32)
  JVRP(268) = V(55)
! JVRP(269) = dARP(152)/dV(55)
  JVRP(269) = V(32)
! JVRP(270) = dARP(153)/dV(32)
  JVRP(270) = 2*V(32)
! JVRP(271) = dARP(154)/dV(38)
  JVRP(271) = V(52)
! JVRP(272) = dARP(154)/dV(52)
  JVRP(272) = V(38)
! JVRP(273) = dARP(155)/dV(38)
  JVRP(273) = V(55)
! JVRP(274) = dARP(155)/dV(55)
  JVRP(274) = V(38)
! JVRP(275) = dARP(156)/dV(38)
  JVRP(275) = 2*V(38)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE RADM2_Parameters
      USE RADM2_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE RADM2_Parameters
      USE RADM2_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE RADM2_Stoichiom

