! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADM2_LinearAlgebra.f90
! Time                 : Thu Oct  8 08:22:27 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADM2_18938_BOXMOX
! Equation file        : RADM2.kpp
! Output root filename : RADM2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADM2_LinearAlgebra

  USE RADM2_Parameters
  USE RADM2_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RADM2_Parameters
  USE RADM2_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RADM2_Parameters
!  USE RADM2_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RADM2_Parameters
!  USE RADM2_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RADM2_Parameters
!  USE RADM2_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(19) = X(19)-JVS(67)*X(7)
  X(22) = X(22)-JVS(80)*X(10)-JVS(81)*X(11)
  X(25) = X(25)-JVS(93)*X(15)-JVS(94)*X(22)
  X(26) = X(26)-JVS(105)*X(24)
  X(32) = X(32)-JVS(149)*X(22)
  X(33) = X(33)-JVS(157)*X(16)-JVS(158)*X(29)
  X(35) = X(35)-JVS(181)*X(10)
  X(36) = X(36)-JVS(188)*X(11)
  X(37) = X(37)-JVS(195)*X(27)-JVS(196)*X(28)
  X(38) = X(38)-JVS(205)*X(24)-JVS(206)*X(27)-JVS(207)*X(28)-JVS(208)*X(29)
  X(39) = X(39)-JVS(217)*X(8)-JVS(218)*X(9)-JVS(219)*X(22)-JVS(220)*X(23)
  X(40) = X(40)-JVS(230)*X(24)
  X(41) = X(41)-JVS(239)*X(8)
  X(42) = X(42)-JVS(246)*X(32)-JVS(247)*X(35)-JVS(248)*X(36)-JVS(249)*X(37)-JVS(250)*X(39)-JVS(251)*X(40)-JVS(252)*X(41)
  X(43) = X(43)-JVS(268)*X(16)-JVS(269)*X(21)-JVS(270)*X(23)-JVS(271)*X(24)-JVS(272)*X(27)-JVS(273)*X(28)-JVS(274)*X(29)&
            &-JVS(275)*X(31)-JVS(276)*X(32)-JVS(277)*X(35)-JVS(278)*X(36)-JVS(279)*X(37)-JVS(280)*X(38)-JVS(281)*X(39)&
            &-JVS(282)*X(40)-JVS(283)*X(41)
  X(44) = X(44)-JVS(299)*X(9)
  X(45) = X(45)-JVS(306)*X(12)-JVS(307)*X(22)-JVS(308)*X(30)-JVS(309)*X(35)-JVS(310)*X(36)
  X(46) = X(46)-JVS(319)*X(19)-JVS(320)*X(24)-JVS(321)*X(27)-JVS(322)*X(28)-JVS(323)*X(29)
  X(47) = X(47)-JVS(330)*X(32)-JVS(331)*X(38)-JVS(332)*X(41)-JVS(333)*X(44)-JVS(334)*X(46)
  X(48) = X(48)-JVS(344)*X(16)-JVS(345)*X(27)-JVS(346)*X(28)-JVS(347)*X(29)-JVS(348)*X(37)-JVS(349)*X(38)-JVS(350)*X(40)&
            &-JVS(351)*X(41)-JVS(352)*X(42)-JVS(353)*X(44)-JVS(354)*X(45)-JVS(355)*X(46)-JVS(356)*X(47)
  X(49) = X(49)-JVS(369)*X(29)-JVS(370)*X(46)
  X(50) = X(50)-JVS(379)*X(33)-JVS(380)*X(41)-JVS(381)*X(44)-JVS(382)*X(46)-JVS(383)*X(47)-JVS(384)*X(49)
  X(51) = X(51)-JVS(394)*X(5)-JVS(395)*X(10)-JVS(396)*X(11)-JVS(397)*X(14)-JVS(398)*X(16)-JVS(399)*X(20)-JVS(400)*X(21)&
            &-JVS(401)*X(22)-JVS(402)*X(24)-JVS(403)*X(26)-JVS(404)*X(27)-JVS(405)*X(28)-JVS(406)*X(29)-JVS(407)*X(30)&
            &-JVS(408)*X(31)-JVS(409)*X(32)-JVS(410)*X(34)-JVS(411)*X(35)-JVS(412)*X(36)-JVS(413)*X(37)-JVS(414)*X(38)&
            &-JVS(415)*X(39)-JVS(416)*X(40)-JVS(417)*X(41)-JVS(418)*X(42)-JVS(419)*X(43)-JVS(420)*X(44)-JVS(421)*X(45)&
            &-JVS(422)*X(46)-JVS(423)*X(47)-JVS(424)*X(48)-JVS(425)*X(49)-JVS(426)*X(50)
  X(52) = X(52)-JVS(436)*X(17)-JVS(437)*X(18)-JVS(438)*X(21)-JVS(439)*X(27)-JVS(440)*X(28)-JVS(441)*X(29)-JVS(442)*X(32)&
            &-JVS(443)*X(35)-JVS(444)*X(36)-JVS(445)*X(37)-JVS(446)*X(38)-JVS(447)*X(39)-JVS(448)*X(40)-JVS(449)*X(41)&
            &-JVS(450)*X(44)-JVS(451)*X(45)-JVS(452)*X(46)-JVS(453)*X(48)-JVS(454)*X(49)-JVS(455)*X(50)-JVS(456)*X(51)
  X(53) = X(53)-JVS(465)*X(5)-JVS(466)*X(6)-JVS(467)*X(7)-JVS(468)*X(8)-JVS(469)*X(9)-JVS(470)*X(10)-JVS(471)*X(11)&
            &-JVS(472)*X(13)-JVS(473)*X(14)-JVS(474)*X(16)-JVS(475)*X(17)-JVS(476)*X(18)-JVS(477)*X(20)-JVS(478)*X(21)&
            &-JVS(479)*X(22)-JVS(480)*X(23)-JVS(481)*X(24)-JVS(482)*X(25)-JVS(483)*X(26)-JVS(484)*X(27)-JVS(485)*X(28)&
            &-JVS(486)*X(29)-JVS(487)*X(30)-JVS(488)*X(31)-JVS(489)*X(33)-JVS(490)*X(34)-JVS(491)*X(35)-JVS(492)*X(36)&
            &-JVS(493)*X(41)-JVS(494)*X(42)-JVS(495)*X(43)-JVS(496)*X(44)-JVS(497)*X(45)-JVS(498)*X(46)-JVS(499)*X(47)&
            &-JVS(500)*X(48)-JVS(501)*X(49)-JVS(502)*X(50)-JVS(503)*X(51)-JVS(504)*X(52)
  X(54) = X(54)-JVS(512)*X(15)-JVS(513)*X(20)-JVS(514)*X(22)-JVS(515)*X(23)-JVS(516)*X(24)-JVS(517)*X(25)-JVS(518)*X(27)&
            &-JVS(519)*X(28)-JVS(520)*X(29)-JVS(521)*X(30)-JVS(522)*X(31)-JVS(523)*X(34)-JVS(524)*X(35)-JVS(525)*X(36)&
            &-JVS(526)*X(43)-JVS(527)*X(44)-JVS(528)*X(45)-JVS(529)*X(46)-JVS(530)*X(48)-JVS(531)*X(49)-JVS(532)*X(50)&
            &-JVS(533)*X(51)-JVS(534)*X(52)-JVS(535)*X(53)
  X(55) = X(55)-JVS(542)*X(18)-JVS(543)*X(23)-JVS(544)*X(32)-JVS(545)*X(33)-JVS(546)*X(34)-JVS(547)*X(35)-JVS(548)*X(36)&
            &-JVS(549)*X(37)-JVS(550)*X(38)-JVS(551)*X(39)-JVS(552)*X(40)-JVS(553)*X(41)-JVS(554)*X(44)-JVS(555)*X(45)&
            &-JVS(556)*X(46)-JVS(557)*X(47)-JVS(558)*X(48)-JVS(559)*X(49)-JVS(560)*X(50)-JVS(561)*X(51)-JVS(562)*X(52)&
            &-JVS(563)*X(53)-JVS(564)*X(54)
  X(56) = X(56)-JVS(570)*X(16)-JVS(571)*X(42)-JVS(572)*X(44)-JVS(573)*X(45)-JVS(574)*X(46)-JVS(575)*X(47)-JVS(576)*X(49)&
            &-JVS(577)*X(50)-JVS(578)*X(51)-JVS(579)*X(52)-JVS(580)*X(53)-JVS(581)*X(54)-JVS(582)*X(55)
  X(57) = X(57)-JVS(587)*X(6)-JVS(588)*X(33)-JVS(589)*X(41)-JVS(590)*X(44)-JVS(591)*X(46)-JVS(592)*X(47)-JVS(593)*X(49)&
            &-JVS(594)*X(51)-JVS(595)*X(52)-JVS(596)*X(53)-JVS(597)*X(54)-JVS(598)*X(55)-JVS(599)*X(56)
  X(58) = X(58)-JVS(603)*X(13)-JVS(604)*X(19)-JVS(605)*X(35)-JVS(606)*X(36)-JVS(607)*X(37)-JVS(608)*X(38)-JVS(609)*X(39)&
            &-JVS(610)*X(40)-JVS(611)*X(41)-JVS(612)*X(44)-JVS(613)*X(45)-JVS(614)*X(46)-JVS(615)*X(49)-JVS(616)*X(50)&
            &-JVS(617)*X(51)-JVS(618)*X(52)-JVS(619)*X(53)-JVS(620)*X(54)-JVS(621)*X(55)-JVS(622)*X(56)-JVS(623)*X(57)
  X(59) = X(59)-JVS(626)*X(12)-JVS(627)*X(15)-JVS(628)*X(19)-JVS(629)*X(20)-JVS(630)*X(23)-JVS(631)*X(25)-JVS(632)*X(30)&
            &-JVS(633)*X(31)-JVS(634)*X(32)-JVS(635)*X(34)-JVS(636)*X(35)-JVS(637)*X(36)-JVS(638)*X(37)-JVS(639)*X(38)&
            &-JVS(640)*X(39)-JVS(641)*X(40)-JVS(642)*X(41)-JVS(643)*X(43)-JVS(644)*X(44)-JVS(645)*X(45)-JVS(646)*X(46)&
            &-JVS(647)*X(47)-JVS(648)*X(48)-JVS(649)*X(49)-JVS(650)*X(50)-JVS(651)*X(51)-JVS(652)*X(52)-JVS(653)*X(53)&
            &-JVS(654)*X(54)-JVS(655)*X(55)-JVS(656)*X(56)-JVS(657)*X(57)-JVS(658)*X(58)
  X(59) = X(59)/JVS(659)
  X(58) = (X(58)-JVS(625)*X(59))/(JVS(624))
  X(57) = (X(57)-JVS(601)*X(58)-JVS(602)*X(59))/(JVS(600))
  X(56) = (X(56)-JVS(584)*X(57)-JVS(585)*X(58)-JVS(586)*X(59))/(JVS(583))
  X(55) = (X(55)-JVS(566)*X(56)-JVS(567)*X(57)-JVS(568)*X(58)-JVS(569)*X(59))/(JVS(565))
  X(54) = (X(54)-JVS(537)*X(55)-JVS(538)*X(56)-JVS(539)*X(57)-JVS(540)*X(58)-JVS(541)*X(59))/(JVS(536))
  X(53) = (X(53)-JVS(506)*X(54)-JVS(507)*X(55)-JVS(508)*X(56)-JVS(509)*X(57)-JVS(510)*X(58)-JVS(511)*X(59))/(JVS(505))
  X(52) = (X(52)-JVS(458)*X(53)-JVS(459)*X(54)-JVS(460)*X(55)-JVS(461)*X(56)-JVS(462)*X(57)-JVS(463)*X(58)-JVS(464)&
            &*X(59))/(JVS(457))
  X(51) = (X(51)-JVS(428)*X(52)-JVS(429)*X(53)-JVS(430)*X(54)-JVS(431)*X(55)-JVS(432)*X(56)-JVS(433)*X(57)-JVS(434)&
            &*X(58)-JVS(435)*X(59))/(JVS(427))
  X(50) = (X(50)-JVS(386)*X(51)-JVS(387)*X(52)-JVS(388)*X(53)-JVS(389)*X(54)-JVS(390)*X(55)-JVS(391)*X(56)-JVS(392)&
            &*X(58)-JVS(393)*X(59))/(JVS(385))
  X(49) = (X(49)-JVS(372)*X(51)-JVS(373)*X(52)-JVS(374)*X(53)-JVS(375)*X(54)-JVS(376)*X(55)-JVS(377)*X(58)-JVS(378)&
            &*X(59))/(JVS(371))
  X(48) = (X(48)-JVS(358)*X(49)-JVS(359)*X(50)-JVS(360)*X(51)-JVS(361)*X(52)-JVS(362)*X(53)-JVS(363)*X(54)-JVS(364)&
            &*X(55)-JVS(365)*X(56)-JVS(366)*X(57)-JVS(367)*X(58)-JVS(368)*X(59))/(JVS(357))
  X(47) = (X(47)-JVS(336)*X(51)-JVS(337)*X(52)-JVS(338)*X(53)-JVS(339)*X(54)-JVS(340)*X(55)-JVS(341)*X(56)-JVS(342)&
            &*X(58)-JVS(343)*X(59))/(JVS(335))
  X(46) = (X(46)-JVS(325)*X(51)-JVS(326)*X(53)-JVS(327)*X(54)-JVS(328)*X(58)-JVS(329)*X(59))/(JVS(324))
  X(45) = (X(45)-JVS(312)*X(51)-JVS(313)*X(52)-JVS(314)*X(53)-JVS(315)*X(54)-JVS(316)*X(55)-JVS(317)*X(58)-JVS(318)&
            &*X(59))/(JVS(311))
  X(44) = (X(44)-JVS(301)*X(51)-JVS(302)*X(52)-JVS(303)*X(53)-JVS(304)*X(55)-JVS(305)*X(58))/(JVS(300))
  X(43) = (X(43)-JVS(285)*X(44)-JVS(286)*X(45)-JVS(287)*X(46)-JVS(288)*X(49)-JVS(289)*X(50)-JVS(290)*X(51)-JVS(291)&
            &*X(52)-JVS(292)*X(53)-JVS(293)*X(54)-JVS(294)*X(55)-JVS(295)*X(56)-JVS(296)*X(57)-JVS(297)*X(58)-JVS(298)&
            &*X(59))/(JVS(284))
  X(42) = (X(42)-JVS(254)*X(44)-JVS(255)*X(45)-JVS(256)*X(46)-JVS(257)*X(49)-JVS(258)*X(50)-JVS(259)*X(51)-JVS(260)&
            &*X(52)-JVS(261)*X(53)-JVS(262)*X(54)-JVS(263)*X(55)-JVS(264)*X(56)-JVS(265)*X(57)-JVS(266)*X(58)-JVS(267)&
            &*X(59))/(JVS(253))
  X(41) = (X(41)-JVS(241)*X(51)-JVS(242)*X(52)-JVS(243)*X(53)-JVS(244)*X(55)-JVS(245)*X(58))/(JVS(240))
  X(40) = (X(40)-JVS(232)*X(46)-JVS(233)*X(51)-JVS(234)*X(52)-JVS(235)*X(53)-JVS(236)*X(54)-JVS(237)*X(55)-JVS(238)&
            &*X(58))/(JVS(231))
  X(39) = (X(39)-JVS(222)*X(45)-JVS(223)*X(51)-JVS(224)*X(52)-JVS(225)*X(53)-JVS(226)*X(54)-JVS(227)*X(55)-JVS(228)&
            &*X(58)-JVS(229)*X(59))/(JVS(221))
  X(38) = (X(38)-JVS(210)*X(46)-JVS(211)*X(51)-JVS(212)*X(52)-JVS(213)*X(53)-JVS(214)*X(54)-JVS(215)*X(55)-JVS(216)&
            &*X(58))/(JVS(209))
  X(37) = (X(37)-JVS(198)*X(46)-JVS(199)*X(51)-JVS(200)*X(52)-JVS(201)*X(53)-JVS(202)*X(54)-JVS(203)*X(55)-JVS(204)&
            &*X(58))/(JVS(197))
  X(36) = (X(36)-JVS(190)*X(51)-JVS(191)*X(52)-JVS(192)*X(53)-JVS(193)*X(55)-JVS(194)*X(58))/(JVS(189))
  X(35) = (X(35)-JVS(183)*X(51)-JVS(184)*X(52)-JVS(185)*X(53)-JVS(186)*X(55)-JVS(187)*X(58))/(JVS(182))
  X(34) = (X(34)-JVS(172)*X(35)-JVS(173)*X(36)-JVS(174)*X(45)-JVS(175)*X(50)-JVS(176)*X(52)-JVS(177)*X(53)-JVS(178)&
            &*X(54)-JVS(179)*X(55)-JVS(180)*X(58))/(JVS(171))
  X(33) = (X(33)-JVS(160)*X(41)-JVS(161)*X(44)-JVS(162)*X(46)-JVS(163)*X(47)-JVS(164)*X(49)-JVS(165)*X(52)-JVS(166)&
            &*X(53)-JVS(167)*X(54)-JVS(168)*X(55)-JVS(169)*X(56)-JVS(170)*X(58))/(JVS(159))
  X(32) = (X(32)-JVS(151)*X(51)-JVS(152)*X(52)-JVS(153)*X(53)-JVS(154)*X(54)-JVS(155)*X(55)-JVS(156)*X(59))/(JVS(150))
  X(31) = (X(31)-JVS(142)*X(35)-JVS(143)*X(45)-JVS(144)*X(52)-JVS(145)*X(53)-JVS(146)*X(54)-JVS(147)*X(55)-JVS(148)&
            &*X(58))/(JVS(141))
  X(30) = (X(30)-JVS(134)*X(35)-JVS(135)*X(36)-JVS(136)*X(52)-JVS(137)*X(53)-JVS(138)*X(54)-JVS(139)*X(55)-JVS(140)&
            &*X(58))/(JVS(133))
  X(29) = (X(29)-JVS(130)*X(46)-JVS(131)*X(53)-JVS(132)*X(54))/(JVS(129))
  X(28) = (X(28)-JVS(126)*X(46)-JVS(127)*X(53)-JVS(128)*X(54))/(JVS(125))
  X(27) = (X(27)-JVS(122)*X(46)-JVS(123)*X(53)-JVS(124)*X(54))/(JVS(121))
  X(26) = (X(26)-JVS(107)*X(27)-JVS(108)*X(28)-JVS(109)*X(29)-JVS(110)*X(31)-JVS(111)*X(34)-JVS(112)*X(43)-JVS(113)&
            &*X(45)-JVS(114)*X(46)-JVS(115)*X(48)-JVS(116)*X(52)-JVS(117)*X(53)-JVS(118)*X(54)-JVS(119)*X(55)-JVS(120)&
            &*X(58))/(JVS(106))
  X(25) = (X(25)-JVS(96)*X(30)-JVS(97)*X(31)-JVS(98)*X(34)-JVS(99)*X(43)-JVS(100)*X(48)-JVS(101)*X(51)-JVS(102)*X(53)&
            &-JVS(103)*X(54)-JVS(104)*X(59))/(JVS(95))
  X(24) = (X(24)-JVS(90)*X(46)-JVS(91)*X(53)-JVS(92)*X(54))/(JVS(89))
  X(23) = (X(23)-JVS(86)*X(53)-JVS(87)*X(55)-JVS(88)*X(59))/(JVS(85))
  X(22) = (X(22)-JVS(83)*X(53)-JVS(84)*X(54))/(JVS(82))
  X(21) = (X(21)-JVS(77)*X(51)-JVS(78)*X(52)-JVS(79)*X(53))/(JVS(76))
  X(20) = (X(20)-JVS(73)*X(51)-JVS(74)*X(53)-JVS(75)*X(59))/(JVS(72))
  X(19) = (X(19)-JVS(69)*X(46)-JVS(70)*X(54)-JVS(71)*X(59))/(JVS(68))
  X(18) = (X(18)-JVS(64)*X(51)-JVS(65)*X(53)-JVS(66)*X(55))/(JVS(63))
  X(17) = (X(17)-JVS(59)*X(28)-JVS(60)*X(29)-JVS(61)*X(46)-JVS(62)*X(53))/(JVS(58))
  X(16) = (X(16)-JVS(57)*X(53))/(JVS(56))
  X(15) = (X(15)-JVS(54)*X(54)-JVS(55)*X(59))/(JVS(53))
  X(14) = (X(14)-JVS(51)*X(51)-JVS(52)*X(53))/(JVS(50))
  X(13) = (X(13)-JVS(48)*X(53)-JVS(49)*X(58))/(JVS(47))
  X(12) = (X(12)-JVS(45)*X(45)-JVS(46)*X(59))/(JVS(44))
  X(11) = (X(11)-JVS(43)*X(53))/(JVS(42))
  X(10) = (X(10)-JVS(41)*X(53))/(JVS(40))
  X(9) = (X(9)-JVS(39)*X(53))/(JVS(38))
  X(8) = (X(8)-JVS(37)*X(53))/(JVS(36))
  X(7) = (X(7)-JVS(35)*X(46))/(JVS(34))
  X(6) = (X(6)-JVS(33)*X(53))/(JVS(32))
  X(5) = (X(5)-JVS(31)*X(53))/(JVS(30))
  X(4) = (X(4)-JVS(28)*X(26)-JVS(29)*X(53))/(JVS(27))
  X(3) = (X(3)-JVS(11)*X(27)-JVS(12)*X(28)-JVS(13)*X(29)-JVS(14)*X(37)-JVS(15)*X(38)-JVS(16)*X(40)-JVS(17)*X(41)-JVS(18)&
           &*X(44)-JVS(19)*X(45)-JVS(20)*X(46)-JVS(21)*X(49)-JVS(22)*X(50)-JVS(23)*X(52)-JVS(24)*X(55)-JVS(25)*X(56)-JVS(26)&
           &*X(57))/(JVS(10))
  X(2) = (X(2)-JVS(5)*X(24)-JVS(6)*X(27)-JVS(7)*X(28)-JVS(8)*X(29)-JVS(9)*X(46))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(5)-JVS(3)*X(53))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(10)
  XX(4) = X(4)/JVS(27)
  XX(5) = (X(5)-JVS(2)*XX(1))/(JVS(30))
  XX(6) = X(6)/JVS(32)
  XX(7) = X(7)/JVS(34)
  XX(8) = X(8)/JVS(36)
  XX(9) = X(9)/JVS(38)
  XX(10) = X(10)/JVS(40)
  XX(11) = X(11)/JVS(42)
  XX(12) = X(12)/JVS(44)
  XX(13) = X(13)/JVS(47)
  XX(14) = X(14)/JVS(50)
  XX(15) = X(15)/JVS(53)
  XX(16) = X(16)/JVS(56)
  XX(17) = X(17)/JVS(58)
  XX(18) = X(18)/JVS(63)
  XX(19) = X(19)/JVS(68)
  XX(20) = X(20)/JVS(72)
  XX(21) = X(21)/JVS(76)
  XX(22) = X(22)/JVS(82)
  XX(23) = X(23)/JVS(85)
  XX(24) = (X(24)-JVS(5)*XX(2))/(JVS(89))
  XX(25) = X(25)/JVS(95)
  XX(26) = (X(26)-JVS(28)*XX(4))/(JVS(106))
  XX(27) = (X(27)-JVS(6)*XX(2)-JVS(11)*XX(3)-JVS(107)*XX(26))/(JVS(121))
  XX(28) = (X(28)-JVS(7)*XX(2)-JVS(12)*XX(3)-JVS(59)*XX(17)-JVS(108)*XX(26))/(JVS(125))
  XX(29) = (X(29)-JVS(8)*XX(2)-JVS(13)*XX(3)-JVS(60)*XX(17)-JVS(109)*XX(26))/(JVS(129))
  XX(30) = (X(30)-JVS(96)*XX(25))/(JVS(133))
  XX(31) = (X(31)-JVS(97)*XX(25)-JVS(110)*XX(26))/(JVS(141))
  XX(32) = X(32)/JVS(150)
  XX(33) = X(33)/JVS(159)
  XX(34) = (X(34)-JVS(98)*XX(25)-JVS(111)*XX(26))/(JVS(171))
  XX(35) = (X(35)-JVS(134)*XX(30)-JVS(142)*XX(31)-JVS(172)*XX(34))/(JVS(182))
  XX(36) = (X(36)-JVS(135)*XX(30)-JVS(173)*XX(34))/(JVS(189))
  XX(37) = (X(37)-JVS(14)*XX(3))/(JVS(197))
  XX(38) = (X(38)-JVS(15)*XX(3))/(JVS(209))
  XX(39) = X(39)/JVS(221)
  XX(40) = (X(40)-JVS(16)*XX(3))/(JVS(231))
  XX(41) = (X(41)-JVS(17)*XX(3)-JVS(160)*XX(33))/(JVS(240))
  XX(42) = X(42)/JVS(253)
  XX(43) = (X(43)-JVS(99)*XX(25)-JVS(112)*XX(26))/(JVS(284))
  XX(44) = (X(44)-JVS(18)*XX(3)-JVS(161)*XX(33)-JVS(254)*XX(42)-JVS(285)*XX(43))/(JVS(300))
  XX(45) = (X(45)-JVS(19)*XX(3)-JVS(45)*XX(12)-JVS(113)*XX(26)-JVS(143)*XX(31)-JVS(174)*XX(34)-JVS(222)*XX(39)-JVS(255)&
             &*XX(42)-JVS(286)*XX(43))/(JVS(311))
  XX(46) = (X(46)-JVS(9)*XX(2)-JVS(20)*XX(3)-JVS(35)*XX(7)-JVS(61)*XX(17)-JVS(69)*XX(19)-JVS(90)*XX(24)-JVS(114)*XX(26)&
             &-JVS(122)*XX(27)-JVS(126)*XX(28)-JVS(130)*XX(29)-JVS(162)*XX(33)-JVS(198)*XX(37)-JVS(210)*XX(38)-JVS(232)&
             &*XX(40)-JVS(256)*XX(42)-JVS(287)*XX(43))/(JVS(324))
  XX(47) = (X(47)-JVS(163)*XX(33))/(JVS(335))
  XX(48) = (X(48)-JVS(100)*XX(25)-JVS(115)*XX(26))/(JVS(357))
  XX(49) = (X(49)-JVS(21)*XX(3)-JVS(164)*XX(33)-JVS(257)*XX(42)-JVS(288)*XX(43)-JVS(358)*XX(48))/(JVS(371))
  XX(50) = (X(50)-JVS(22)*XX(3)-JVS(175)*XX(34)-JVS(258)*XX(42)-JVS(289)*XX(43)-JVS(359)*XX(48))/(JVS(385))
  XX(51) = (X(51)-JVS(51)*XX(14)-JVS(64)*XX(18)-JVS(73)*XX(20)-JVS(77)*XX(21)-JVS(101)*XX(25)-JVS(151)*XX(32)-JVS(183)&
             &*XX(35)-JVS(190)*XX(36)-JVS(199)*XX(37)-JVS(211)*XX(38)-JVS(223)*XX(39)-JVS(233)*XX(40)-JVS(241)*XX(41)&
             &-JVS(259)*XX(42)-JVS(290)*XX(43)-JVS(301)*XX(44)-JVS(312)*XX(45)-JVS(325)*XX(46)-JVS(336)*XX(47)-JVS(360)&
             &*XX(48)-JVS(372)*XX(49)-JVS(386)*XX(50))/(JVS(427))
  XX(52) = (X(52)-JVS(23)*XX(3)-JVS(78)*XX(21)-JVS(116)*XX(26)-JVS(136)*XX(30)-JVS(144)*XX(31)-JVS(152)*XX(32)-JVS(165)&
             &*XX(33)-JVS(176)*XX(34)-JVS(184)*XX(35)-JVS(191)*XX(36)-JVS(200)*XX(37)-JVS(212)*XX(38)-JVS(224)*XX(39)&
             &-JVS(234)*XX(40)-JVS(242)*XX(41)-JVS(260)*XX(42)-JVS(291)*XX(43)-JVS(302)*XX(44)-JVS(313)*XX(45)-JVS(337)&
             &*XX(47)-JVS(361)*XX(48)-JVS(373)*XX(49)-JVS(387)*XX(50)-JVS(428)*XX(51))/(JVS(457))
  XX(53) = (X(53)-JVS(3)*XX(1)-JVS(29)*XX(4)-JVS(31)*XX(5)-JVS(33)*XX(6)-JVS(37)*XX(8)-JVS(39)*XX(9)-JVS(41)*XX(10)&
             &-JVS(43)*XX(11)-JVS(48)*XX(13)-JVS(52)*XX(14)-JVS(57)*XX(16)-JVS(62)*XX(17)-JVS(65)*XX(18)-JVS(74)*XX(20)&
             &-JVS(79)*XX(21)-JVS(83)*XX(22)-JVS(86)*XX(23)-JVS(91)*XX(24)-JVS(102)*XX(25)-JVS(117)*XX(26)-JVS(123)*XX(27)&
             &-JVS(127)*XX(28)-JVS(131)*XX(29)-JVS(137)*XX(30)-JVS(145)*XX(31)-JVS(153)*XX(32)-JVS(166)*XX(33)-JVS(177)&
             &*XX(34)-JVS(185)*XX(35)-JVS(192)*XX(36)-JVS(201)*XX(37)-JVS(213)*XX(38)-JVS(225)*XX(39)-JVS(235)*XX(40)&
             &-JVS(243)*XX(41)-JVS(261)*XX(42)-JVS(292)*XX(43)-JVS(303)*XX(44)-JVS(314)*XX(45)-JVS(326)*XX(46)-JVS(338)&
             &*XX(47)-JVS(362)*XX(48)-JVS(374)*XX(49)-JVS(388)*XX(50)-JVS(429)*XX(51)-JVS(458)*XX(52))/(JVS(505))
  XX(54) = (X(54)-JVS(54)*XX(15)-JVS(70)*XX(19)-JVS(84)*XX(22)-JVS(92)*XX(24)-JVS(103)*XX(25)-JVS(118)*XX(26)-JVS(124)&
             &*XX(27)-JVS(128)*XX(28)-JVS(132)*XX(29)-JVS(138)*XX(30)-JVS(146)*XX(31)-JVS(154)*XX(32)-JVS(167)*XX(33)&
             &-JVS(178)*XX(34)-JVS(202)*XX(37)-JVS(214)*XX(38)-JVS(226)*XX(39)-JVS(236)*XX(40)-JVS(262)*XX(42)-JVS(293)&
             &*XX(43)-JVS(315)*XX(45)-JVS(327)*XX(46)-JVS(339)*XX(47)-JVS(363)*XX(48)-JVS(375)*XX(49)-JVS(389)*XX(50)&
             &-JVS(430)*XX(51)-JVS(459)*XX(52)-JVS(506)*XX(53))/(JVS(536))
  XX(55) = (X(55)-JVS(24)*XX(3)-JVS(66)*XX(18)-JVS(87)*XX(23)-JVS(119)*XX(26)-JVS(139)*XX(30)-JVS(147)*XX(31)-JVS(155)&
             &*XX(32)-JVS(168)*XX(33)-JVS(179)*XX(34)-JVS(186)*XX(35)-JVS(193)*XX(36)-JVS(203)*XX(37)-JVS(215)*XX(38)&
             &-JVS(227)*XX(39)-JVS(237)*XX(40)-JVS(244)*XX(41)-JVS(263)*XX(42)-JVS(294)*XX(43)-JVS(304)*XX(44)-JVS(316)&
             &*XX(45)-JVS(340)*XX(47)-JVS(364)*XX(48)-JVS(376)*XX(49)-JVS(390)*XX(50)-JVS(431)*XX(51)-JVS(460)*XX(52)&
             &-JVS(507)*XX(53)-JVS(537)*XX(54))/(JVS(565))
  XX(56) = (X(56)-JVS(25)*XX(3)-JVS(169)*XX(33)-JVS(264)*XX(42)-JVS(295)*XX(43)-JVS(341)*XX(47)-JVS(365)*XX(48)-JVS(391)&
             &*XX(50)-JVS(432)*XX(51)-JVS(461)*XX(52)-JVS(508)*XX(53)-JVS(538)*XX(54)-JVS(566)*XX(55))/(JVS(583))
  XX(57) = (X(57)-JVS(26)*XX(3)-JVS(265)*XX(42)-JVS(296)*XX(43)-JVS(366)*XX(48)-JVS(433)*XX(51)-JVS(462)*XX(52)-JVS(509)&
             &*XX(53)-JVS(539)*XX(54)-JVS(567)*XX(55)-JVS(584)*XX(56))/(JVS(600))
  XX(58) = (X(58)-JVS(49)*XX(13)-JVS(120)*XX(26)-JVS(140)*XX(30)-JVS(148)*XX(31)-JVS(170)*XX(33)-JVS(180)*XX(34)&
             &-JVS(187)*XX(35)-JVS(194)*XX(36)-JVS(204)*XX(37)-JVS(216)*XX(38)-JVS(228)*XX(39)-JVS(238)*XX(40)-JVS(245)&
             &*XX(41)-JVS(266)*XX(42)-JVS(297)*XX(43)-JVS(305)*XX(44)-JVS(317)*XX(45)-JVS(328)*XX(46)-JVS(342)*XX(47)&
             &-JVS(367)*XX(48)-JVS(377)*XX(49)-JVS(392)*XX(50)-JVS(434)*XX(51)-JVS(463)*XX(52)-JVS(510)*XX(53)-JVS(540)&
             &*XX(54)-JVS(568)*XX(55)-JVS(585)*XX(56)-JVS(601)*XX(57))/(JVS(624))
  XX(59) = (X(59)-JVS(46)*XX(12)-JVS(55)*XX(15)-JVS(71)*XX(19)-JVS(75)*XX(20)-JVS(88)*XX(23)-JVS(104)*XX(25)-JVS(156)&
             &*XX(32)-JVS(229)*XX(39)-JVS(267)*XX(42)-JVS(298)*XX(43)-JVS(318)*XX(45)-JVS(329)*XX(46)-JVS(343)*XX(47)&
             &-JVS(368)*XX(48)-JVS(378)*XX(49)-JVS(393)*XX(50)-JVS(435)*XX(51)-JVS(464)*XX(52)-JVS(511)*XX(53)-JVS(541)&
             &*XX(54)-JVS(569)*XX(55)-JVS(586)*XX(56)-JVS(602)*XX(57)-JVS(625)*XX(58))/(JVS(659))
  XX(59) = XX(59)
  XX(58) = XX(58)-JVS(658)*XX(59)
  XX(57) = XX(57)-JVS(623)*XX(58)-JVS(657)*XX(59)
  XX(56) = XX(56)-JVS(599)*XX(57)-JVS(622)*XX(58)-JVS(656)*XX(59)
  XX(55) = XX(55)-JVS(582)*XX(56)-JVS(598)*XX(57)-JVS(621)*XX(58)-JVS(655)*XX(59)
  XX(54) = XX(54)-JVS(564)*XX(55)-JVS(581)*XX(56)-JVS(597)*XX(57)-JVS(620)*XX(58)-JVS(654)*XX(59)
  XX(53) = XX(53)-JVS(535)*XX(54)-JVS(563)*XX(55)-JVS(580)*XX(56)-JVS(596)*XX(57)-JVS(619)*XX(58)-JVS(653)*XX(59)
  XX(52) = XX(52)-JVS(504)*XX(53)-JVS(534)*XX(54)-JVS(562)*XX(55)-JVS(579)*XX(56)-JVS(595)*XX(57)-JVS(618)*XX(58)&
             &-JVS(652)*XX(59)
  XX(51) = XX(51)-JVS(456)*XX(52)-JVS(503)*XX(53)-JVS(533)*XX(54)-JVS(561)*XX(55)-JVS(578)*XX(56)-JVS(594)*XX(57)&
             &-JVS(617)*XX(58)-JVS(651)*XX(59)
  XX(50) = XX(50)-JVS(426)*XX(51)-JVS(455)*XX(52)-JVS(502)*XX(53)-JVS(532)*XX(54)-JVS(560)*XX(55)-JVS(577)*XX(56)&
             &-JVS(616)*XX(58)-JVS(650)*XX(59)
  XX(49) = XX(49)-JVS(384)*XX(50)-JVS(425)*XX(51)-JVS(454)*XX(52)-JVS(501)*XX(53)-JVS(531)*XX(54)-JVS(559)*XX(55)&
             &-JVS(576)*XX(56)-JVS(593)*XX(57)-JVS(615)*XX(58)-JVS(649)*XX(59)
  XX(48) = XX(48)-JVS(424)*XX(51)-JVS(453)*XX(52)-JVS(500)*XX(53)-JVS(530)*XX(54)-JVS(558)*XX(55)-JVS(648)*XX(59)
  XX(47) = XX(47)-JVS(356)*XX(48)-JVS(383)*XX(50)-JVS(423)*XX(51)-JVS(499)*XX(53)-JVS(557)*XX(55)-JVS(575)*XX(56)&
             &-JVS(592)*XX(57)-JVS(647)*XX(59)
  XX(46) = XX(46)-JVS(334)*XX(47)-JVS(355)*XX(48)-JVS(370)*XX(49)-JVS(382)*XX(50)-JVS(422)*XX(51)-JVS(452)*XX(52)&
             &-JVS(498)*XX(53)-JVS(529)*XX(54)-JVS(556)*XX(55)-JVS(574)*XX(56)-JVS(591)*XX(57)-JVS(614)*XX(58)-JVS(646)&
             &*XX(59)
  XX(45) = XX(45)-JVS(354)*XX(48)-JVS(421)*XX(51)-JVS(451)*XX(52)-JVS(497)*XX(53)-JVS(528)*XX(54)-JVS(555)*XX(55)&
             &-JVS(573)*XX(56)-JVS(613)*XX(58)-JVS(645)*XX(59)
  XX(44) = XX(44)-JVS(333)*XX(47)-JVS(353)*XX(48)-JVS(381)*XX(50)-JVS(420)*XX(51)-JVS(450)*XX(52)-JVS(496)*XX(53)&
             &-JVS(527)*XX(54)-JVS(554)*XX(55)-JVS(572)*XX(56)-JVS(590)*XX(57)-JVS(612)*XX(58)-JVS(644)*XX(59)
  XX(43) = XX(43)-JVS(419)*XX(51)-JVS(495)*XX(53)-JVS(526)*XX(54)-JVS(643)*XX(59)
  XX(42) = XX(42)-JVS(352)*XX(48)-JVS(418)*XX(51)-JVS(494)*XX(53)-JVS(571)*XX(56)
  XX(41) = XX(41)-JVS(252)*XX(42)-JVS(283)*XX(43)-JVS(332)*XX(47)-JVS(351)*XX(48)-JVS(380)*XX(50)-JVS(417)*XX(51)&
             &-JVS(449)*XX(52)-JVS(493)*XX(53)-JVS(553)*XX(55)-JVS(589)*XX(57)-JVS(611)*XX(58)-JVS(642)*XX(59)
  XX(40) = XX(40)-JVS(251)*XX(42)-JVS(282)*XX(43)-JVS(350)*XX(48)-JVS(416)*XX(51)-JVS(448)*XX(52)-JVS(552)*XX(55)&
             &-JVS(610)*XX(58)-JVS(641)*XX(59)
  XX(39) = XX(39)-JVS(250)*XX(42)-JVS(281)*XX(43)-JVS(415)*XX(51)-JVS(447)*XX(52)-JVS(551)*XX(55)-JVS(609)*XX(58)&
             &-JVS(640)*XX(59)
  XX(38) = XX(38)-JVS(280)*XX(43)-JVS(331)*XX(47)-JVS(349)*XX(48)-JVS(414)*XX(51)-JVS(446)*XX(52)-JVS(550)*XX(55)&
             &-JVS(608)*XX(58)-JVS(639)*XX(59)
  XX(37) = XX(37)-JVS(249)*XX(42)-JVS(279)*XX(43)-JVS(348)*XX(48)-JVS(413)*XX(51)-JVS(445)*XX(52)-JVS(549)*XX(55)&
             &-JVS(607)*XX(58)-JVS(638)*XX(59)
  XX(36) = XX(36)-JVS(248)*XX(42)-JVS(278)*XX(43)-JVS(310)*XX(45)-JVS(412)*XX(51)-JVS(444)*XX(52)-JVS(492)*XX(53)&
             &-JVS(525)*XX(54)-JVS(548)*XX(55)-JVS(606)*XX(58)-JVS(637)*XX(59)
  XX(35) = XX(35)-JVS(247)*XX(42)-JVS(277)*XX(43)-JVS(309)*XX(45)-JVS(411)*XX(51)-JVS(443)*XX(52)-JVS(491)*XX(53)&
             &-JVS(524)*XX(54)-JVS(547)*XX(55)-JVS(605)*XX(58)-JVS(636)*XX(59)
  XX(34) = XX(34)-JVS(410)*XX(51)-JVS(490)*XX(53)-JVS(523)*XX(54)-JVS(546)*XX(55)-JVS(635)*XX(59)
  XX(33) = XX(33)-JVS(379)*XX(50)-JVS(489)*XX(53)-JVS(545)*XX(55)-JVS(588)*XX(57)
  XX(32) = XX(32)-JVS(246)*XX(42)-JVS(276)*XX(43)-JVS(330)*XX(47)-JVS(409)*XX(51)-JVS(442)*XX(52)-JVS(544)*XX(55)&
             &-JVS(634)*XX(59)
  XX(31) = XX(31)-JVS(275)*XX(43)-JVS(408)*XX(51)-JVS(488)*XX(53)-JVS(522)*XX(54)-JVS(633)*XX(59)
  XX(30) = XX(30)-JVS(308)*XX(45)-JVS(407)*XX(51)-JVS(487)*XX(53)-JVS(521)*XX(54)-JVS(632)*XX(59)
  XX(29) = XX(29)-JVS(158)*XX(33)-JVS(208)*XX(38)-JVS(274)*XX(43)-JVS(323)*XX(46)-JVS(347)*XX(48)-JVS(369)*XX(49)&
             &-JVS(406)*XX(51)-JVS(441)*XX(52)-JVS(486)*XX(53)-JVS(520)*XX(54)
  XX(28) = XX(28)-JVS(196)*XX(37)-JVS(207)*XX(38)-JVS(273)*XX(43)-JVS(322)*XX(46)-JVS(346)*XX(48)-JVS(405)*XX(51)&
             &-JVS(440)*XX(52)-JVS(485)*XX(53)-JVS(519)*XX(54)
  XX(27) = XX(27)-JVS(195)*XX(37)-JVS(206)*XX(38)-JVS(272)*XX(43)-JVS(321)*XX(46)-JVS(345)*XX(48)-JVS(404)*XX(51)&
             &-JVS(439)*XX(52)-JVS(484)*XX(53)-JVS(518)*XX(54)
  XX(26) = XX(26)-JVS(403)*XX(51)-JVS(483)*XX(53)
  XX(25) = XX(25)-JVS(482)*XX(53)-JVS(517)*XX(54)-JVS(631)*XX(59)
  XX(24) = XX(24)-JVS(105)*XX(26)-JVS(205)*XX(38)-JVS(230)*XX(40)-JVS(271)*XX(43)-JVS(320)*XX(46)-JVS(402)*XX(51)&
             &-JVS(481)*XX(53)-JVS(516)*XX(54)
  XX(23) = XX(23)-JVS(220)*XX(39)-JVS(270)*XX(43)-JVS(480)*XX(53)-JVS(515)*XX(54)-JVS(543)*XX(55)-JVS(630)*XX(59)
  XX(22) = XX(22)-JVS(94)*XX(25)-JVS(149)*XX(32)-JVS(219)*XX(39)-JVS(307)*XX(45)-JVS(401)*XX(51)-JVS(479)*XX(53)&
             &-JVS(514)*XX(54)
  XX(21) = XX(21)-JVS(269)*XX(43)-JVS(400)*XX(51)-JVS(438)*XX(52)-JVS(478)*XX(53)
  XX(20) = XX(20)-JVS(399)*XX(51)-JVS(477)*XX(53)-JVS(513)*XX(54)-JVS(629)*XX(59)
  XX(19) = XX(19)-JVS(319)*XX(46)-JVS(604)*XX(58)-JVS(628)*XX(59)
  XX(18) = XX(18)-JVS(437)*XX(52)-JVS(476)*XX(53)-JVS(542)*XX(55)
  XX(17) = XX(17)-JVS(436)*XX(52)-JVS(475)*XX(53)
  XX(16) = XX(16)-JVS(157)*XX(33)-JVS(268)*XX(43)-JVS(344)*XX(48)-JVS(398)*XX(51)-JVS(474)*XX(53)-JVS(570)*XX(56)
  XX(15) = XX(15)-JVS(93)*XX(25)-JVS(512)*XX(54)-JVS(627)*XX(59)
  XX(14) = XX(14)-JVS(397)*XX(51)-JVS(473)*XX(53)
  XX(13) = XX(13)-JVS(472)*XX(53)-JVS(603)*XX(58)
  XX(12) = XX(12)-JVS(306)*XX(45)-JVS(626)*XX(59)
  XX(11) = XX(11)-JVS(81)*XX(22)-JVS(188)*XX(36)-JVS(396)*XX(51)-JVS(471)*XX(53)
  XX(10) = XX(10)-JVS(80)*XX(22)-JVS(181)*XX(35)-JVS(395)*XX(51)-JVS(470)*XX(53)
  XX(9) = XX(9)-JVS(218)*XX(39)-JVS(299)*XX(44)-JVS(469)*XX(53)
  XX(8) = XX(8)-JVS(217)*XX(39)-JVS(239)*XX(41)-JVS(468)*XX(53)
  XX(7) = XX(7)-JVS(67)*XX(19)-JVS(467)*XX(53)
  XX(6) = XX(6)-JVS(466)*XX(53)-JVS(587)*XX(57)
  XX(5) = XX(5)-JVS(394)*XX(51)-JVS(465)*XX(53)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE RADM2_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE RADM2_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE RADM2_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE RADM2_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADM2_LinearAlgebra

