! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADM2_Jacobian.f90
! Time                 : Thu Oct  8 08:22:27 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADM2_18938_BOXMOX
! Equation file        : RADM2.kpp
! Output root filename : RADM2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADM2_Jacobian

  USE RADM2_Parameters
  USE RADM2_JacobianSP

  USE RADM2_Global

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(280)

! B(1) = dA(1)/dV(59)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(46)
  B(2) = RCT(2)
! B(3) = dA(3)/dV(46)
  B(3) = RCT(3)
! B(4) = dA(4)/dV(13)
  B(4) = RCT(4)
! B(5) = dA(5)/dV(25)
  B(5) = RCT(5)
! B(6) = dA(6)/dV(20)
  B(6) = RCT(6)
! B(7) = dA(7)/dV(54)
  B(7) = RCT(7)
! B(8) = dA(8)/dV(54)
  B(8) = RCT(8)
! B(9) = dA(9)/dV(14)
  B(9) = RCT(9)
! B(10) = dA(10)/dV(43)
  B(10) = RCT(10)
! B(11) = dA(11)/dV(43)
  B(11) = RCT(11)
! B(12) = dA(12)/dV(48)
  B(12) = RCT(12)
! B(13) = dA(13)/dV(21)
  B(13) = RCT(13)
! B(14) = dA(14)/dV(42)
  B(14) = RCT(14)
! B(15) = dA(15)/dV(18)
  B(15) = RCT(15)
! B(16) = dA(16)/dV(33)
  B(16) = RCT(16)
! B(17) = dA(17)/dV(31)
  B(17) = RCT(17)
! B(18) = dA(18)/dV(31)
  B(18) = RCT(18)
! B(19) = dA(19)/dV(34)
  B(19) = RCT(19)
! B(20) = dA(20)/dV(30)
  B(20) = RCT(20)
! B(21) = dA(21)/dV(47)
  B(21) = RCT(21)
! B(22) = dA(22)/dV(19)
  B(22) = RCT(22)*F(2)
! B(24) = dA(23)/dV(19)
  B(24) = RCT(23)*V(59)
! B(25) = dA(23)/dV(59)
  B(25) = RCT(23)*V(19)
! B(26) = dA(24)/dV(7)
  B(26) = RCT(24)*F(2)
! B(28) = dA(25)/dV(7)
  B(28) = RCT(25)*F(1)
! B(30) = dA(26)/dV(46)
  B(30) = RCT(26)*V(58)
! B(31) = dA(26)/dV(58)
  B(31) = RCT(26)*V(46)
! B(32) = dA(27)/dV(46)
  B(32) = RCT(27)*V(53)
! B(33) = dA(27)/dV(53)
  B(33) = RCT(27)*V(46)
! B(34) = dA(28)/dV(46)
  B(34) = RCT(28)*V(51)
! B(35) = dA(28)/dV(51)
  B(35) = RCT(28)*V(46)
! B(36) = dA(29)/dV(51)
  B(36) = RCT(29)*V(58)
! B(37) = dA(29)/dV(58)
  B(37) = RCT(29)*V(51)
! B(38) = dA(30)/dV(51)
  B(38) = RCT(30)*V(59)
! B(39) = dA(30)/dV(59)
  B(39) = RCT(30)*V(51)
! B(40) = dA(31)/dV(20)
  B(40) = RCT(31)
! B(41) = dA(32)/dV(51)
  B(41) = RCT(32)*2*V(51)
! B(42) = dA(33)/dV(51)
  B(42) = RCT(33)*2*V(51)*F(1)
! B(44) = dA(34)/dV(14)
  B(44) = RCT(34)*V(53)
! B(45) = dA(34)/dV(53)
  B(45) = RCT(34)*V(14)
! B(46) = dA(35)/dV(53)
  B(46) = RCT(35)*V(58)
! B(47) = dA(35)/dV(58)
  B(47) = RCT(35)*V(53)
! B(48) = dA(36)/dV(58)
  B(48) = RCT(36)*2*V(58)*F(2)
! B(50) = dA(37)/dV(46)
  B(50) = RCT(37)*V(59)
! B(51) = dA(37)/dV(59)
  B(51) = RCT(37)*V(46)
! B(52) = dA(38)/dV(54)
  B(52) = RCT(38)*V(58)
! B(53) = dA(38)/dV(58)
  B(53) = RCT(38)*V(54)
! B(54) = dA(39)/dV(54)
  B(54) = RCT(39)*V(59)
! B(55) = dA(39)/dV(59)
  B(55) = RCT(39)*V(54)
! B(56) = dA(40)/dV(51)
  B(56) = RCT(40)*V(54)
! B(57) = dA(40)/dV(54)
  B(57) = RCT(40)*V(51)
! B(58) = dA(41)/dV(54)
  B(58) = RCT(41)*V(59)
! B(59) = dA(41)/dV(59)
  B(59) = RCT(41)*V(54)
! B(60) = dA(42)/dV(15)
  B(60) = RCT(42)
! B(61) = dA(43)/dV(15)
  B(61) = RCT(43)
! B(62) = dA(44)/dV(53)
  B(62) = RCT(44)*V(59)
! B(63) = dA(44)/dV(59)
  B(63) = RCT(44)*V(53)
! B(64) = dA(45)/dV(25)
  B(64) = RCT(45)*V(53)
! B(65) = dA(45)/dV(53)
  B(65) = RCT(45)*V(25)
! B(66) = dA(46)/dV(20)
  B(66) = RCT(46)*V(53)
! B(67) = dA(46)/dV(53)
  B(67) = RCT(46)*V(20)
! B(68) = dA(47)/dV(51)
  B(68) = RCT(47)*V(53)
! B(69) = dA(47)/dV(53)
  B(69) = RCT(47)*V(51)
! B(70) = dA(48)/dV(5)
  B(70) = RCT(48)*V(53)
! B(71) = dA(48)/dV(53)
  B(71) = RCT(48)*V(5)
! B(72) = dA(49)/dV(26)
  B(72) = RCT(49)*V(53)
! B(73) = dA(49)/dV(53)
  B(73) = RCT(49)*V(26)
! B(74) = dA(50)/dV(17)
  B(74) = RCT(50)*V(53)
! B(75) = dA(50)/dV(53)
  B(75) = RCT(50)*V(17)
! B(76) = dA(51)/dV(6)
  B(76) = RCT(51)*V(53)
! B(77) = dA(51)/dV(53)
  B(77) = RCT(51)*V(6)
! B(78) = dA(52)/dV(16)
  B(78) = RCT(52)*V(53)
! B(79) = dA(52)/dV(53)
  B(79) = RCT(52)*V(16)
! B(80) = dA(53)/dV(8)
  B(80) = RCT(53)*V(53)
! B(81) = dA(53)/dV(53)
  B(81) = RCT(53)*V(8)
! B(82) = dA(54)/dV(9)
  B(82) = RCT(54)*V(53)
! B(83) = dA(54)/dV(53)
  B(83) = RCT(54)*V(9)
! B(84) = dA(55)/dV(24)
  B(84) = RCT(55)*V(53)
! B(85) = dA(55)/dV(53)
  B(85) = RCT(55)*V(24)
! B(86) = dA(56)/dV(28)
  B(86) = RCT(56)*V(53)
! B(87) = dA(56)/dV(53)
  B(87) = RCT(56)*V(28)
! B(88) = dA(57)/dV(29)
  B(88) = RCT(57)*V(53)
! B(89) = dA(57)/dV(53)
  B(89) = RCT(57)*V(29)
! B(90) = dA(58)/dV(10)
  B(90) = RCT(58)*V(53)
! B(91) = dA(58)/dV(53)
  B(91) = RCT(58)*V(10)
! B(92) = dA(59)/dV(11)
  B(92) = RCT(59)*V(53)
! B(93) = dA(59)/dV(53)
  B(93) = RCT(59)*V(11)
! B(94) = dA(60)/dV(22)
  B(94) = RCT(60)*V(53)
! B(95) = dA(60)/dV(53)
  B(95) = RCT(60)*V(22)
! B(96) = dA(61)/dV(43)
  B(96) = RCT(61)*V(53)
! B(97) = dA(61)/dV(53)
  B(97) = RCT(61)*V(43)
! B(98) = dA(62)/dV(48)
  B(98) = RCT(62)*V(53)
! B(99) = dA(62)/dV(53)
  B(99) = RCT(62)*V(48)
! B(100) = dA(63)/dV(33)
  B(100) = RCT(63)*V(53)
! B(101) = dA(63)/dV(53)
  B(101) = RCT(63)*V(33)
! B(102) = dA(64)/dV(31)
  B(102) = RCT(64)*V(53)
! B(103) = dA(64)/dV(53)
  B(103) = RCT(64)*V(31)
! B(104) = dA(65)/dV(34)
  B(104) = RCT(65)*V(53)
! B(105) = dA(65)/dV(53)
  B(105) = RCT(65)*V(34)
! B(106) = dA(66)/dV(30)
  B(106) = RCT(66)*V(53)
! B(107) = dA(66)/dV(53)
  B(107) = RCT(66)*V(30)
! B(108) = dA(67)/dV(21)
  B(108) = RCT(67)*V(53)
! B(109) = dA(67)/dV(53)
  B(109) = RCT(67)*V(21)
! B(110) = dA(68)/dV(42)
  B(110) = RCT(68)*V(53)
! B(111) = dA(68)/dV(53)
  B(111) = RCT(68)*V(42)
! B(112) = dA(69)/dV(18)
  B(112) = RCT(69)*V(53)
! B(113) = dA(69)/dV(53)
  B(113) = RCT(69)*V(18)
! B(114) = dA(70)/dV(23)
  B(114) = RCT(70)*V(53)
! B(115) = dA(70)/dV(53)
  B(115) = RCT(70)*V(23)
! B(116) = dA(71)/dV(47)
  B(116) = RCT(71)*V(53)
! B(117) = dA(71)/dV(53)
  B(117) = RCT(71)*V(47)
! B(118) = dA(72)/dV(27)
  B(118) = RCT(72)*V(53)
! B(119) = dA(72)/dV(53)
  B(119) = RCT(72)*V(27)
! B(120) = dA(73)/dV(55)
  B(120) = RCT(73)*V(59)
! B(121) = dA(73)/dV(59)
  B(121) = RCT(73)*V(55)
! B(122) = dA(74)/dV(23)
  B(122) = RCT(74)
! B(123) = dA(75)/dV(45)
  B(123) = RCT(75)*V(59)
! B(124) = dA(75)/dV(59)
  B(124) = RCT(75)*V(45)
! B(125) = dA(76)/dV(12)
  B(125) = RCT(76)
! B(126) = dA(77)/dV(52)
  B(126) = RCT(77)*V(58)
! B(127) = dA(77)/dV(58)
  B(127) = RCT(77)*V(52)
! B(128) = dA(78)/dV(56)
  B(128) = RCT(78)*V(58)
! B(129) = dA(78)/dV(58)
  B(129) = RCT(78)*V(56)
! B(130) = dA(79)/dV(41)
  B(130) = RCT(79)*V(58)
! B(131) = dA(79)/dV(58)
  B(131) = RCT(79)*V(41)
! B(132) = dA(80)/dV(44)
  B(132) = RCT(80)*V(58)
! B(133) = dA(80)/dV(58)
  B(133) = RCT(80)*V(44)
! B(134) = dA(81)/dV(40)
  B(134) = RCT(81)*V(58)
! B(135) = dA(81)/dV(58)
  B(135) = RCT(81)*V(40)
! B(136) = dA(82)/dV(37)
  B(136) = RCT(82)*V(58)
! B(137) = dA(82)/dV(58)
  B(137) = RCT(82)*V(37)
! B(138) = dA(83)/dV(49)
  B(138) = RCT(83)*V(58)
! B(139) = dA(83)/dV(58)
  B(139) = RCT(83)*V(49)
! B(140) = dA(84)/dV(55)
  B(140) = RCT(84)*V(58)
! B(141) = dA(84)/dV(58)
  B(141) = RCT(84)*V(55)
! B(142) = dA(85)/dV(45)
  B(142) = RCT(85)*V(58)
! B(143) = dA(85)/dV(58)
  B(143) = RCT(85)*V(45)
! B(144) = dA(86)/dV(35)
  B(144) = RCT(86)*V(58)
! B(145) = dA(86)/dV(58)
  B(145) = RCT(86)*V(35)
! B(146) = dA(87)/dV(36)
  B(146) = RCT(87)*V(58)
! B(147) = dA(87)/dV(58)
  B(147) = RCT(87)*V(36)
! B(148) = dA(88)/dV(57)
  B(148) = RCT(88)*V(58)
! B(149) = dA(88)/dV(58)
  B(149) = RCT(88)*V(57)
! B(150) = dA(89)/dV(50)
  B(150) = RCT(89)*V(58)
! B(151) = dA(89)/dV(58)
  B(151) = RCT(89)*V(50)
! B(152) = dA(90)/dV(38)
  B(152) = RCT(90)*V(58)
! B(153) = dA(90)/dV(58)
  B(153) = RCT(90)*V(38)
! B(154) = dA(91)/dV(43)
  B(154) = RCT(91)*V(54)
! B(155) = dA(91)/dV(54)
  B(155) = RCT(91)*V(43)
! B(156) = dA(92)/dV(48)
  B(156) = RCT(92)*V(54)
! B(157) = dA(92)/dV(54)
  B(157) = RCT(92)*V(48)
! B(158) = dA(93)/dV(31)
  B(158) = RCT(93)*V(54)
! B(159) = dA(93)/dV(54)
  B(159) = RCT(93)*V(31)
! B(160) = dA(94)/dV(34)
  B(160) = RCT(94)*V(54)
! B(161) = dA(94)/dV(54)
  B(161) = RCT(94)*V(34)
! B(162) = dA(95)/dV(30)
  B(162) = RCT(95)*V(54)
! B(163) = dA(95)/dV(54)
  B(163) = RCT(95)*V(30)
! B(164) = dA(96)/dV(22)
  B(164) = RCT(96)*V(54)
! B(165) = dA(96)/dV(54)
  B(165) = RCT(96)*V(22)
! B(166) = dA(97)/dV(24)
  B(166) = RCT(97)*V(54)
! B(167) = dA(97)/dV(54)
  B(167) = RCT(97)*V(24)
! B(168) = dA(98)/dV(28)
  B(168) = RCT(98)*V(54)
! B(169) = dA(98)/dV(54)
  B(169) = RCT(98)*V(28)
! B(170) = dA(99)/dV(29)
  B(170) = RCT(99)*V(54)
! B(171) = dA(99)/dV(54)
  B(171) = RCT(99)*V(29)
! B(172) = dA(100)/dV(27)
  B(172) = RCT(100)*V(54)
! B(173) = dA(100)/dV(54)
  B(173) = RCT(100)*V(27)
! B(174) = dA(101)/dV(24)
  B(174) = RCT(101)*V(46)
! B(175) = dA(101)/dV(46)
  B(175) = RCT(101)*V(24)
! B(176) = dA(102)/dV(28)
  B(176) = RCT(102)*V(46)
! B(177) = dA(102)/dV(46)
  B(177) = RCT(102)*V(28)
! B(178) = dA(103)/dV(29)
  B(178) = RCT(103)*V(46)
! B(179) = dA(103)/dV(46)
  B(179) = RCT(103)*V(29)
! B(180) = dA(104)/dV(27)
  B(180) = RCT(104)*V(46)
! B(181) = dA(104)/dV(46)
  B(181) = RCT(104)*V(27)
! B(182) = dA(105)/dV(51)
  B(182) = RCT(105)*V(52)
! B(183) = dA(105)/dV(52)
  B(183) = RCT(105)*V(51)
! B(184) = dA(106)/dV(51)
  B(184) = RCT(106)*V(57)
! B(185) = dA(106)/dV(57)
  B(185) = RCT(106)*V(51)
! B(186) = dA(107)/dV(51)
  B(186) = RCT(107)*V(56)
! B(187) = dA(107)/dV(56)
  B(187) = RCT(107)*V(51)
! B(188) = dA(108)/dV(41)
  B(188) = RCT(108)*V(51)
! B(189) = dA(108)/dV(51)
  B(189) = RCT(108)*V(41)
! B(190) = dA(109)/dV(44)
  B(190) = RCT(109)*V(51)
! B(191) = dA(109)/dV(51)
  B(191) = RCT(109)*V(44)
! B(192) = dA(110)/dV(40)
  B(192) = RCT(110)*V(51)
! B(193) = dA(110)/dV(51)
  B(193) = RCT(110)*V(40)
! B(194) = dA(111)/dV(37)
  B(194) = RCT(111)*V(51)
! B(195) = dA(111)/dV(51)
  B(195) = RCT(111)*V(37)
! B(196) = dA(112)/dV(49)
  B(196) = RCT(112)*V(51)
! B(197) = dA(112)/dV(51)
  B(197) = RCT(112)*V(49)
! B(198) = dA(113)/dV(50)
  B(198) = RCT(113)*V(51)
! B(199) = dA(113)/dV(51)
  B(199) = RCT(113)*V(50)
! B(200) = dA(114)/dV(51)
  B(200) = RCT(114)*V(55)
! B(201) = dA(114)/dV(55)
  B(201) = RCT(114)*V(51)
! B(202) = dA(115)/dV(35)
  B(202) = RCT(115)*V(51)
! B(203) = dA(115)/dV(51)
  B(203) = RCT(115)*V(35)
! B(204) = dA(116)/dV(36)
  B(204) = RCT(116)*V(51)
! B(205) = dA(116)/dV(51)
  B(205) = RCT(116)*V(36)
! B(206) = dA(117)/dV(45)
  B(206) = RCT(117)*V(51)
! B(207) = dA(117)/dV(51)
  B(207) = RCT(117)*V(45)
! B(208) = dA(118)/dV(38)
  B(208) = RCT(118)*V(51)
! B(209) = dA(118)/dV(51)
  B(209) = RCT(118)*V(38)
! B(210) = dA(119)/dV(52)
  B(210) = RCT(119)*2*V(52)
! B(211) = dA(120)/dV(52)
  B(211) = RCT(120)*V(57)
! B(212) = dA(120)/dV(57)
  B(212) = RCT(120)*V(52)
! B(213) = dA(121)/dV(52)
  B(213) = RCT(121)*V(56)
! B(214) = dA(121)/dV(56)
  B(214) = RCT(121)*V(52)
! B(215) = dA(122)/dV(41)
  B(215) = RCT(122)*V(52)
! B(216) = dA(122)/dV(52)
  B(216) = RCT(122)*V(41)
! B(217) = dA(123)/dV(44)
  B(217) = RCT(123)*V(52)
! B(218) = dA(123)/dV(52)
  B(218) = RCT(123)*V(44)
! B(219) = dA(124)/dV(40)
  B(219) = RCT(124)*V(52)
! B(220) = dA(124)/dV(52)
  B(220) = RCT(124)*V(40)
! B(221) = dA(125)/dV(37)
  B(221) = RCT(125)*V(52)
! B(222) = dA(125)/dV(52)
  B(222) = RCT(125)*V(37)
! B(223) = dA(126)/dV(49)
  B(223) = RCT(126)*V(52)
! B(224) = dA(126)/dV(52)
  B(224) = RCT(126)*V(49)
! B(225) = dA(127)/dV(50)
  B(225) = RCT(127)*V(52)
! B(226) = dA(127)/dV(52)
  B(226) = RCT(127)*V(50)
! B(227) = dA(128)/dV(52)
  B(227) = RCT(128)*V(55)
! B(228) = dA(128)/dV(55)
  B(228) = RCT(128)*V(52)
! B(229) = dA(129)/dV(35)
  B(229) = RCT(129)*V(52)
! B(230) = dA(129)/dV(52)
  B(230) = RCT(129)*V(35)
! B(231) = dA(130)/dV(36)
  B(231) = RCT(130)*V(52)
! B(232) = dA(130)/dV(52)
  B(232) = RCT(130)*V(36)
! B(233) = dA(131)/dV(45)
  B(233) = RCT(131)*V(52)
! B(234) = dA(131)/dV(52)
  B(234) = RCT(131)*V(45)
! B(235) = dA(132)/dV(55)
  B(235) = RCT(132)*V(57)
! B(236) = dA(132)/dV(57)
  B(236) = RCT(132)*V(55)
! B(237) = dA(133)/dV(55)
  B(237) = RCT(133)*V(56)
! B(238) = dA(133)/dV(56)
  B(238) = RCT(133)*V(55)
! B(239) = dA(134)/dV(41)
  B(239) = RCT(134)*V(55)
! B(240) = dA(134)/dV(55)
  B(240) = RCT(134)*V(41)
! B(241) = dA(135)/dV(44)
  B(241) = RCT(135)*V(55)
! B(242) = dA(135)/dV(55)
  B(242) = RCT(135)*V(44)
! B(243) = dA(136)/dV(40)
  B(243) = RCT(136)*V(55)
! B(244) = dA(136)/dV(55)
  B(244) = RCT(136)*V(40)
! B(245) = dA(137)/dV(37)
  B(245) = RCT(137)*V(55)
! B(246) = dA(137)/dV(55)
  B(246) = RCT(137)*V(37)
! B(247) = dA(138)/dV(49)
  B(247) = RCT(138)*V(55)
! B(248) = dA(138)/dV(55)
  B(248) = RCT(138)*V(49)
! B(249) = dA(139)/dV(50)
  B(249) = RCT(139)*V(55)
! B(250) = dA(139)/dV(55)
  B(250) = RCT(139)*V(50)
! B(251) = dA(140)/dV(55)
  B(251) = RCT(140)*2*V(55)
! B(252) = dA(141)/dV(35)
  B(252) = RCT(141)*V(55)
! B(253) = dA(141)/dV(55)
  B(253) = RCT(141)*V(35)
! B(254) = dA(142)/dV(36)
  B(254) = RCT(142)*V(55)
! B(255) = dA(142)/dV(55)
  B(255) = RCT(142)*V(36)
! B(256) = dA(143)/dV(45)
  B(256) = RCT(143)*V(55)
! B(257) = dA(143)/dV(55)
  B(257) = RCT(143)*V(45)
! B(258) = dA(144)/dV(39)
  B(258) = RCT(144)*V(51)
! B(259) = dA(144)/dV(51)
  B(259) = RCT(144)*V(39)
! B(260) = dA(145)/dV(39)
  B(260) = RCT(145)*V(52)
! B(261) = dA(145)/dV(52)
  B(261) = RCT(145)*V(39)
! B(262) = dA(146)/dV(39)
  B(262) = RCT(146)*V(55)
! B(263) = dA(146)/dV(55)
  B(263) = RCT(146)*V(39)
! B(264) = dA(147)/dV(39)
  B(264) = RCT(147)*2*V(39)
! B(265) = dA(148)/dV(39)
  B(265) = RCT(148)*V(58)
! B(266) = dA(148)/dV(58)
  B(266) = RCT(148)*V(39)
! B(267) = dA(149)/dV(32)
  B(267) = RCT(149)*V(59)
! B(268) = dA(149)/dV(59)
  B(268) = RCT(149)*V(32)
! B(269) = dA(150)/dV(32)
  B(269) = RCT(150)*V(51)
! B(270) = dA(150)/dV(51)
  B(270) = RCT(150)*V(32)
! B(271) = dA(151)/dV(32)
  B(271) = RCT(151)*V(52)
! B(272) = dA(151)/dV(52)
  B(272) = RCT(151)*V(32)
! B(273) = dA(152)/dV(32)
  B(273) = RCT(152)*V(55)
! B(274) = dA(152)/dV(55)
  B(274) = RCT(152)*V(32)
! B(275) = dA(153)/dV(32)
  B(275) = RCT(153)*2*V(32)
! B(276) = dA(154)/dV(38)
  B(276) = RCT(154)*V(52)
! B(277) = dA(154)/dV(52)
  B(277) = RCT(154)*V(38)
! B(278) = dA(155)/dV(38)
  B(278) = RCT(155)*V(55)
! B(279) = dA(155)/dV(55)
  B(279) = RCT(155)*V(38)
! B(280) = dA(156)/dV(38)
  B(280) = RCT(156)*2*V(38)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = 0
! JVS(2) = Jac_FULL(1,5)
  JVS(2) = B(70)
! JVS(3) = Jac_FULL(1,53)
  JVS(3) = B(71)
! JVS(4) = Jac_FULL(2,2)
  JVS(4) = 0
! JVS(5) = Jac_FULL(2,24)
  JVS(5) = 0.4*B(174)
! JVS(6) = Jac_FULL(2,27)
  JVS(6) = 0.2*B(180)
! JVS(7) = Jac_FULL(2,28)
  JVS(7) = 0.2*B(176)
! JVS(8) = Jac_FULL(2,29)
  JVS(8) = 0.06*B(178)
! JVS(9) = Jac_FULL(2,46)
  JVS(9) = 0.4*B(175)+0.2*B(177)+0.06*B(179)+0.2*B(181)
! JVS(10) = Jac_FULL(3,3)
  JVS(10) = 0
! JVS(11) = Jac_FULL(3,27)
  JVS(11) = 0.2*B(180)
! JVS(12) = Jac_FULL(3,28)
  JVS(12) = 0.2*B(176)
! JVS(13) = Jac_FULL(3,29)
  JVS(13) = 0.29*B(178)
! JVS(14) = Jac_FULL(3,37)
  JVS(14) = 0.5*B(245)
! JVS(15) = Jac_FULL(3,38)
  JVS(15) = 0.5*B(278)
! JVS(16) = Jac_FULL(3,40)
  JVS(16) = 0.5*B(243)
! JVS(17) = Jac_FULL(3,41)
  JVS(17) = 0.5*B(239)
! JVS(18) = Jac_FULL(3,44)
  JVS(18) = 0.5*B(241)
! JVS(19) = Jac_FULL(3,45)
  JVS(19) = 0.5*B(233)
! JVS(20) = Jac_FULL(3,46)
  JVS(20) = 0.2*B(177)+0.29*B(179)+0.2*B(181)
! JVS(21) = Jac_FULL(3,49)
  JVS(21) = 0.5*B(247)
! JVS(22) = Jac_FULL(3,50)
  JVS(22) = 0.5*B(249)
! JVS(23) = Jac_FULL(3,52)
  JVS(23) = 0.5*B(227)+0.5*B(234)
! JVS(24) = Jac_FULL(3,55)
  JVS(24) = 0.5*B(228)+0.5*B(235)+0.5*B(237)+0.5*B(240)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)+0.5&
              &*B(279)
! JVS(25) = Jac_FULL(3,56)
  JVS(25) = 0.5*B(238)
! JVS(26) = Jac_FULL(3,57)
  JVS(26) = 0.5*B(236)
! JVS(27) = Jac_FULL(4,4)
  JVS(27) = 0
! JVS(28) = Jac_FULL(4,26)
  JVS(28) = B(72)
! JVS(29) = Jac_FULL(4,53)
  JVS(29) = B(73)
! JVS(30) = Jac_FULL(5,5)
  JVS(30) = -B(70)
! JVS(31) = Jac_FULL(5,53)
  JVS(31) = -B(71)
! JVS(32) = Jac_FULL(6,6)
  JVS(32) = -B(76)
! JVS(33) = Jac_FULL(6,53)
  JVS(33) = -B(77)
! JVS(34) = Jac_FULL(7,7)
  JVS(34) = -B(26)-B(28)
! JVS(35) = Jac_FULL(7,46)
  JVS(35) = B(2)
! JVS(36) = Jac_FULL(8,8)
  JVS(36) = -B(80)
! JVS(37) = Jac_FULL(8,53)
  JVS(37) = -B(81)
! JVS(38) = Jac_FULL(9,9)
  JVS(38) = -B(82)
! JVS(39) = Jac_FULL(9,53)
  JVS(39) = -B(83)
! JVS(40) = Jac_FULL(10,10)
  JVS(40) = -B(90)
! JVS(41) = Jac_FULL(10,53)
  JVS(41) = -B(91)
! JVS(42) = Jac_FULL(11,11)
  JVS(42) = -B(92)
! JVS(43) = Jac_FULL(11,53)
  JVS(43) = -B(93)
! JVS(44) = Jac_FULL(12,12)
  JVS(44) = -B(125)
! JVS(45) = Jac_FULL(12,45)
  JVS(45) = B(123)
! JVS(46) = Jac_FULL(12,59)
  JVS(46) = B(124)
! JVS(47) = Jac_FULL(13,13)
  JVS(47) = -B(4)
! JVS(48) = Jac_FULL(13,53)
  JVS(48) = B(46)
! JVS(49) = Jac_FULL(13,58)
  JVS(49) = B(47)
! JVS(50) = Jac_FULL(14,14)
  JVS(50) = -B(9)-B(44)
! JVS(51) = Jac_FULL(14,51)
  JVS(51) = B(41)+B(42)
! JVS(52) = Jac_FULL(14,53)
  JVS(52) = -B(45)
! JVS(53) = Jac_FULL(15,15)
  JVS(53) = -B(60)-B(61)
! JVS(54) = Jac_FULL(15,54)
  JVS(54) = B(58)
! JVS(55) = Jac_FULL(15,59)
  JVS(55) = B(59)
! JVS(56) = Jac_FULL(16,16)
  JVS(56) = -B(78)
! JVS(57) = Jac_FULL(16,53)
  JVS(57) = -B(79)
! JVS(58) = Jac_FULL(17,17)
  JVS(58) = -B(74)
! JVS(59) = Jac_FULL(17,28)
  JVS(59) = 0.06*B(176)
! JVS(60) = Jac_FULL(17,29)
  JVS(60) = 0.09*B(178)
! JVS(61) = Jac_FULL(17,46)
  JVS(61) = 0.06*B(177)+0.09*B(179)
! JVS(62) = Jac_FULL(17,53)
  JVS(62) = -B(75)
! JVS(63) = Jac_FULL(18,18)
  JVS(63) = -B(15)-B(112)
! JVS(64) = Jac_FULL(18,51)
  JVS(64) = B(200)
! JVS(65) = Jac_FULL(18,53)
  JVS(65) = -B(113)
! JVS(66) = Jac_FULL(18,55)
  JVS(66) = B(201)
! JVS(67) = Jac_FULL(19,7)
  JVS(67) = B(26)
! JVS(68) = Jac_FULL(19,19)
  JVS(68) = -B(22)-B(24)
! JVS(69) = Jac_FULL(19,46)
  JVS(69) = B(3)
! JVS(70) = Jac_FULL(19,54)
  JVS(70) = B(8)
! JVS(71) = Jac_FULL(19,59)
  JVS(71) = B(1)-B(25)
! JVS(72) = Jac_FULL(20,20)
  JVS(72) = -B(6)-B(40)-B(66)
! JVS(73) = Jac_FULL(20,51)
  JVS(73) = B(38)
! JVS(74) = Jac_FULL(20,53)
  JVS(74) = -B(67)
! JVS(75) = Jac_FULL(20,59)
  JVS(75) = B(39)
! JVS(76) = Jac_FULL(21,21)
  JVS(76) = -B(13)-B(108)
! JVS(77) = Jac_FULL(21,51)
  JVS(77) = B(182)
! JVS(78) = Jac_FULL(21,52)
  JVS(78) = B(183)
! JVS(79) = Jac_FULL(21,53)
  JVS(79) = -B(109)
! JVS(80) = Jac_FULL(22,10)
  JVS(80) = 0.25*B(90)
! JVS(81) = Jac_FULL(22,11)
  JVS(81) = 0.17*B(92)
! JVS(82) = Jac_FULL(22,22)
  JVS(82) = -B(94)-0.5*B(164)
! JVS(83) = Jac_FULL(22,53)
  JVS(83) = 0.25*B(91)+0.17*B(93)-B(95)
! JVS(84) = Jac_FULL(22,54)
  JVS(84) = -0.5*B(165)
! JVS(85) = Jac_FULL(23,23)
  JVS(85) = -B(114)-B(122)
! JVS(86) = Jac_FULL(23,53)
  JVS(86) = -B(115)
! JVS(87) = Jac_FULL(23,55)
  JVS(87) = B(120)
! JVS(88) = Jac_FULL(23,59)
  JVS(88) = B(121)
! JVS(89) = Jac_FULL(24,24)
  JVS(89) = -B(84)-B(166)-B(174)
! JVS(90) = Jac_FULL(24,46)
  JVS(90) = -B(175)
! JVS(91) = Jac_FULL(24,53)
  JVS(91) = -B(85)
! JVS(92) = Jac_FULL(24,54)
  JVS(92) = -B(167)
! JVS(93) = Jac_FULL(25,15)
  JVS(93) = 2*B(61)
! JVS(94) = Jac_FULL(25,22)
  JVS(94) = B(164)
! JVS(95) = Jac_FULL(25,25)
  JVS(95) = -B(5)-B(64)
! JVS(96) = Jac_FULL(25,30)
  JVS(96) = B(162)
! JVS(97) = Jac_FULL(25,31)
  JVS(97) = B(158)
! JVS(98) = Jac_FULL(25,34)
  JVS(98) = B(160)
! JVS(99) = Jac_FULL(25,43)
  JVS(99) = B(154)
! JVS(100) = Jac_FULL(25,48)
  JVS(100) = B(156)
! JVS(101) = Jac_FULL(25,51)
  JVS(101) = B(56)
! JVS(102) = Jac_FULL(25,53)
  JVS(102) = B(62)-B(65)
! JVS(103) = Jac_FULL(25,54)
  JVS(103) = B(57)+B(155)+B(157)+B(159)+B(161)+B(163)+B(165)
! JVS(104) = Jac_FULL(25,59)
  JVS(104) = B(63)
! JVS(105) = Jac_FULL(26,24)
  JVS(105) = 0.42*B(174)
! JVS(106) = Jac_FULL(26,26)
  JVS(106) = -B(72)
! JVS(107) = Jac_FULL(26,27)
  JVS(107) = 0.33*B(180)
! JVS(108) = Jac_FULL(26,28)
  JVS(108) = 0.33*B(176)
! JVS(109) = Jac_FULL(26,29)
  JVS(109) = 0.23*B(178)
! JVS(110) = Jac_FULL(26,31)
  JVS(110) = 1.87*B(17)+1.55*B(18)+2*B(102)+2*B(158)
! JVS(111) = Jac_FULL(26,34)
  JVS(111) = B(19)+B(104)+B(160)
! JVS(112) = Jac_FULL(26,43)
  JVS(112) = B(10)+B(11)+B(96)+B(154)
! JVS(113) = Jac_FULL(26,45)
  JVS(113) = 0.95*B(142)+0.475*B(233)+0.95*B(256)
! JVS(114) = Jac_FULL(26,46)
  JVS(114) = 0.42*B(175)+0.33*B(177)+0.23*B(179)+0.33*B(181)
! JVS(115) = Jac_FULL(26,48)
  JVS(115) = B(12)
! JVS(116) = Jac_FULL(26,52)
  JVS(116) = 0.475*B(234)
! JVS(117) = Jac_FULL(26,53)
  JVS(117) = -B(73)+B(97)+2*B(103)+B(105)
! JVS(118) = Jac_FULL(26,54)
  JVS(118) = B(155)+2*B(159)+B(161)
! JVS(119) = Jac_FULL(26,55)
  JVS(119) = 0.95*B(257)
! JVS(120) = Jac_FULL(26,58)
  JVS(120) = 0.95*B(143)
! JVS(121) = Jac_FULL(27,27)
  JVS(121) = -B(118)-B(172)-B(180)
! JVS(122) = Jac_FULL(27,46)
  JVS(122) = -B(181)
! JVS(123) = Jac_FULL(27,53)
  JVS(123) = -B(119)
! JVS(124) = Jac_FULL(27,54)
  JVS(124) = -B(173)
! JVS(125) = Jac_FULL(28,28)
  JVS(125) = -B(86)-B(168)-B(176)
! JVS(126) = Jac_FULL(28,46)
  JVS(126) = -B(177)
! JVS(127) = Jac_FULL(28,53)
  JVS(127) = -B(87)
! JVS(128) = Jac_FULL(28,54)
  JVS(128) = -B(169)
! JVS(129) = Jac_FULL(29,29)
  JVS(129) = -B(88)-B(170)-B(178)
! JVS(130) = Jac_FULL(29,46)
  JVS(130) = -B(179)
! JVS(131) = Jac_FULL(29,53)
  JVS(131) = -B(89)
! JVS(132) = Jac_FULL(29,54)
  JVS(132) = -B(171)
! JVS(133) = Jac_FULL(30,30)
  JVS(133) = -B(20)-B(106)-B(162)
! JVS(134) = Jac_FULL(30,35)
  JVS(134) = 0.7*B(144)+0.7*B(229)+B(252)
! JVS(135) = Jac_FULL(30,36)
  JVS(135) = 0.806*B(146)+0.806*B(231)+B(254)
! JVS(136) = Jac_FULL(30,52)
  JVS(136) = 0.7*B(230)+0.806*B(232)
! JVS(137) = Jac_FULL(30,53)
  JVS(137) = -B(107)
! JVS(138) = Jac_FULL(30,54)
  JVS(138) = -B(163)
! JVS(139) = Jac_FULL(30,55)
  JVS(139) = B(253)+B(255)
! JVS(140) = Jac_FULL(30,58)
  JVS(140) = 0.7*B(145)+0.806*B(147)
! JVS(141) = Jac_FULL(31,31)
  JVS(141) = -B(17)-B(18)-B(102)-B(158)
! JVS(142) = Jac_FULL(31,35)
  JVS(142) = 0.16*B(144)+0.16*B(229)+0.2*B(252)
! JVS(143) = Jac_FULL(31,45)
  JVS(143) = 0.89*B(142)+0.445*B(233)+0.89*B(256)
! JVS(144) = Jac_FULL(31,52)
  JVS(144) = 0.16*B(230)+0.445*B(234)
! JVS(145) = Jac_FULL(31,53)
  JVS(145) = -B(103)
! JVS(146) = Jac_FULL(31,54)
  JVS(146) = -B(159)
! JVS(147) = Jac_FULL(31,55)
  JVS(147) = 0.2*B(253)+0.89*B(257)
! JVS(148) = Jac_FULL(31,58)
  JVS(148) = 0.89*B(143)+0.16*B(145)
! JVS(149) = Jac_FULL(32,22)
  JVS(149) = B(164)
! JVS(150) = Jac_FULL(32,32)
  JVS(150) = -B(267)-B(269)-B(271)-B(273)-2*B(275)
! JVS(151) = Jac_FULL(32,51)
  JVS(151) = -B(270)
! JVS(152) = Jac_FULL(32,52)
  JVS(152) = -B(272)
! JVS(153) = Jac_FULL(32,53)
  JVS(153) = 0
! JVS(154) = Jac_FULL(32,54)
  JVS(154) = B(165)
! JVS(155) = Jac_FULL(32,55)
  JVS(155) = -B(274)
! JVS(156) = Jac_FULL(32,59)
  JVS(156) = -B(268)
! JVS(157) = Jac_FULL(33,16)
  JVS(157) = 0.025*B(78)
! JVS(158) = Jac_FULL(33,29)
  JVS(158) = 0.1*B(178)
! JVS(159) = Jac_FULL(33,33)
  JVS(159) = -B(16)-B(100)
! JVS(160) = Jac_FULL(33,41)
  JVS(160) = 0.69*B(130)+0.75*B(215)+0.86*B(239)
! JVS(161) = Jac_FULL(33,44)
  JVS(161) = 1.06*B(132)+1.39*B(217)+0.9*B(241)
! JVS(162) = Jac_FULL(33,46)
  JVS(162) = 0.1*B(179)
! JVS(163) = Jac_FULL(33,47)
  JVS(163) = 0.8*B(21)
! JVS(164) = Jac_FULL(33,49)
  JVS(164) = 0.1*B(138)+0.55*B(223)+0.55*B(247)
! JVS(165) = Jac_FULL(33,52)
  JVS(165) = 0.6*B(213)+0.75*B(216)+1.39*B(218)+0.55*B(224)
! JVS(166) = Jac_FULL(33,53)
  JVS(166) = 0.025*B(79)-B(101)
! JVS(167) = Jac_FULL(33,54)
  JVS(167) = 0
! JVS(168) = Jac_FULL(33,55)
  JVS(168) = 0.8*B(237)+0.86*B(240)+0.9*B(242)+0.55*B(248)
! JVS(169) = Jac_FULL(33,56)
  JVS(169) = 0.25*B(128)+0.6*B(214)+0.8*B(238)
! JVS(170) = Jac_FULL(33,58)
  JVS(170) = 0.25*B(129)+0.69*B(131)+1.06*B(133)+0.1*B(139)
! JVS(171) = Jac_FULL(34,34)
  JVS(171) = -B(19)-B(104)-B(160)
! JVS(172) = Jac_FULL(34,35)
  JVS(172) = 0.17*B(144)+0.17*B(229)+0.8*B(252)
! JVS(173) = Jac_FULL(34,36)
  JVS(173) = 0.45*B(146)+0.45*B(231)+B(254)
! JVS(174) = Jac_FULL(34,45)
  JVS(174) = 0.11*B(142)+0.055*B(233)+0.11*B(256)
! JVS(175) = Jac_FULL(34,50)
  JVS(175) = B(150)+0.75*B(225)+B(249)
! JVS(176) = Jac_FULL(34,52)
  JVS(176) = 0.75*B(226)+0.17*B(230)+0.45*B(232)+0.055*B(234)
! JVS(177) = Jac_FULL(34,53)
  JVS(177) = -B(105)
! JVS(178) = Jac_FULL(34,54)
  JVS(178) = -B(161)
! JVS(179) = Jac_FULL(34,55)
  JVS(179) = B(250)+0.8*B(253)+B(255)+0.11*B(257)
! JVS(180) = Jac_FULL(34,58)
  JVS(180) = 0.11*B(143)+0.17*B(145)+0.45*B(147)+B(151)
! JVS(181) = Jac_FULL(35,10)
  JVS(181) = 0.75*B(90)
! JVS(182) = Jac_FULL(35,35)
  JVS(182) = -B(144)-B(202)-B(229)-B(252)
! JVS(183) = Jac_FULL(35,51)
  JVS(183) = -B(203)
! JVS(184) = Jac_FULL(35,52)
  JVS(184) = -B(230)
! JVS(185) = Jac_FULL(35,53)
  JVS(185) = 0.75*B(91)
! JVS(186) = Jac_FULL(35,55)
  JVS(186) = -B(253)
! JVS(187) = Jac_FULL(35,58)
  JVS(187) = -B(145)
! JVS(188) = Jac_FULL(36,11)
  JVS(188) = 0.83*B(92)
! JVS(189) = Jac_FULL(36,36)
  JVS(189) = -B(146)-B(204)-B(231)-B(254)
! JVS(190) = Jac_FULL(36,51)
  JVS(190) = -B(205)
! JVS(191) = Jac_FULL(36,52)
  JVS(191) = -B(232)
! JVS(192) = Jac_FULL(36,53)
  JVS(192) = 0.83*B(93)
! JVS(193) = Jac_FULL(36,55)
  JVS(193) = -B(255)
! JVS(194) = Jac_FULL(36,58)
  JVS(194) = -B(147)
! JVS(195) = Jac_FULL(37,27)
  JVS(195) = B(118)
! JVS(196) = Jac_FULL(37,28)
  JVS(196) = B(86)
! JVS(197) = Jac_FULL(37,37)
  JVS(197) = -B(136)-B(194)-B(221)-B(245)
! JVS(198) = Jac_FULL(37,46)
  JVS(198) = 0
! JVS(199) = Jac_FULL(37,51)
  JVS(199) = -B(195)
! JVS(200) = Jac_FULL(37,52)
  JVS(200) = -B(222)
! JVS(201) = Jac_FULL(37,53)
  JVS(201) = B(87)+B(119)
! JVS(202) = Jac_FULL(37,54)
  JVS(202) = 0
! JVS(203) = Jac_FULL(37,55)
  JVS(203) = -B(246)
! JVS(204) = Jac_FULL(37,58)
  JVS(204) = -B(137)
! JVS(205) = Jac_FULL(38,24)
  JVS(205) = B(166)
! JVS(206) = Jac_FULL(38,27)
  JVS(206) = B(172)
! JVS(207) = Jac_FULL(38,28)
  JVS(207) = B(168)
! JVS(208) = Jac_FULL(38,29)
  JVS(208) = B(170)
! JVS(209) = Jac_FULL(38,38)
  JVS(209) = -B(152)-B(208)-B(276)-B(278)-2*B(280)
! JVS(210) = Jac_FULL(38,46)
  JVS(210) = 0
! JVS(211) = Jac_FULL(38,51)
  JVS(211) = -B(209)
! JVS(212) = Jac_FULL(38,52)
  JVS(212) = -B(277)
! JVS(213) = Jac_FULL(38,53)
  JVS(213) = 0
! JVS(214) = Jac_FULL(38,54)
  JVS(214) = B(167)+B(169)+B(171)+B(173)
! JVS(215) = Jac_FULL(38,55)
  JVS(215) = -B(279)
! JVS(216) = Jac_FULL(38,58)
  JVS(216) = -B(153)
! JVS(217) = Jac_FULL(39,8)
  JVS(217) = 0.25*B(80)
! JVS(218) = Jac_FULL(39,9)
  JVS(218) = 0.75*B(82)
! JVS(219) = Jac_FULL(39,22)
  JVS(219) = 0.9*B(94)
! JVS(220) = Jac_FULL(39,23)
  JVS(220) = B(114)
! JVS(221) = Jac_FULL(39,39)
  JVS(221) = -B(258)-B(260)-B(262)-2*B(264)-B(265)
! JVS(222) = Jac_FULL(39,45)
  JVS(222) = 2*B(142)+B(233)+2*B(256)
! JVS(223) = Jac_FULL(39,51)
  JVS(223) = -B(259)
! JVS(224) = Jac_FULL(39,52)
  JVS(224) = B(234)-B(261)
! JVS(225) = Jac_FULL(39,53)
  JVS(225) = 0.25*B(81)+0.75*B(83)+0.9*B(95)+B(115)
! JVS(226) = Jac_FULL(39,54)
  JVS(226) = 0
! JVS(227) = Jac_FULL(39,55)
  JVS(227) = 2*B(257)-B(263)
! JVS(228) = Jac_FULL(39,58)
  JVS(228) = 2*B(143)-B(266)
! JVS(229) = Jac_FULL(39,59)
  JVS(229) = 0
! JVS(230) = Jac_FULL(40,24)
  JVS(230) = B(84)
! JVS(231) = Jac_FULL(40,40)
  JVS(231) = -B(134)-B(192)-B(219)-B(243)
! JVS(232) = Jac_FULL(40,46)
  JVS(232) = 0
! JVS(233) = Jac_FULL(40,51)
  JVS(233) = -B(193)
! JVS(234) = Jac_FULL(40,52)
  JVS(234) = -B(220)
! JVS(235) = Jac_FULL(40,53)
  JVS(235) = B(85)
! JVS(236) = Jac_FULL(40,54)
  JVS(236) = 0
! JVS(237) = Jac_FULL(40,55)
  JVS(237) = -B(244)
! JVS(238) = Jac_FULL(40,58)
  JVS(238) = -B(135)
! JVS(239) = Jac_FULL(41,8)
  JVS(239) = B(80)
! JVS(240) = Jac_FULL(41,41)
  JVS(240) = -B(130)-B(188)-B(215)-B(239)
! JVS(241) = Jac_FULL(41,51)
  JVS(241) = -B(189)
! JVS(242) = Jac_FULL(41,52)
  JVS(242) = -B(216)
! JVS(243) = Jac_FULL(41,53)
  JVS(243) = B(81)
! JVS(244) = Jac_FULL(41,55)
  JVS(244) = -B(240)
! JVS(245) = Jac_FULL(41,58)
  JVS(245) = -B(131)
! JVS(246) = Jac_FULL(42,32)
  JVS(246) = B(269)
! JVS(247) = Jac_FULL(42,35)
  JVS(247) = B(202)
! JVS(248) = Jac_FULL(42,36)
  JVS(248) = B(204)
! JVS(249) = Jac_FULL(42,37)
  JVS(249) = B(194)
! JVS(250) = Jac_FULL(42,39)
  JVS(250) = B(258)
! JVS(251) = Jac_FULL(42,40)
  JVS(251) = B(192)
! JVS(252) = Jac_FULL(42,41)
  JVS(252) = B(188)
! JVS(253) = Jac_FULL(42,42)
  JVS(253) = -B(14)-B(110)
! JVS(254) = Jac_FULL(42,44)
  JVS(254) = B(190)
! JVS(255) = Jac_FULL(42,45)
  JVS(255) = B(206)
! JVS(256) = Jac_FULL(42,46)
  JVS(256) = 0
! JVS(257) = Jac_FULL(42,49)
  JVS(257) = B(196)
! JVS(258) = Jac_FULL(42,50)
  JVS(258) = B(198)
! JVS(259) = Jac_FULL(42,51)
  JVS(259) = B(184)+B(186)+B(189)+B(191)+B(193)+B(195)+B(197)+B(199)+B(203)+B(205)+B(207)+B(259)+B(270)
! JVS(260) = Jac_FULL(42,52)
  JVS(260) = 0
! JVS(261) = Jac_FULL(42,53)
  JVS(261) = -B(111)
! JVS(262) = Jac_FULL(42,54)
  JVS(262) = 0
! JVS(263) = Jac_FULL(42,55)
  JVS(263) = 0
! JVS(264) = Jac_FULL(42,56)
  JVS(264) = B(187)
! JVS(265) = Jac_FULL(42,57)
  JVS(265) = B(185)
! JVS(266) = Jac_FULL(42,58)
  JVS(266) = 0
! JVS(267) = Jac_FULL(42,59)
  JVS(267) = 0
! JVS(268) = Jac_FULL(43,16)
  JVS(268) = 0.009*B(78)
! JVS(269) = Jac_FULL(43,21)
  JVS(269) = B(13)+0.5*B(108)
! JVS(270) = Jac_FULL(43,23)
  JVS(270) = B(114)
! JVS(271) = Jac_FULL(43,24)
  JVS(271) = B(174)
! JVS(272) = Jac_FULL(43,27)
  JVS(272) = 0.53*B(180)
! JVS(273) = Jac_FULL(43,28)
  JVS(273) = 0.53*B(176)
! JVS(274) = Jac_FULL(43,29)
  JVS(274) = 0.18*B(178)
! JVS(275) = Jac_FULL(43,31)
  JVS(275) = 0.13*B(17)+0.45*B(18)
! JVS(276) = Jac_FULL(43,32)
  JVS(276) = B(271)
! JVS(277) = Jac_FULL(43,35)
  JVS(277) = B(229)
! JVS(278) = Jac_FULL(43,36)
  JVS(278) = B(231)
! JVS(279) = Jac_FULL(43,37)
  JVS(279) = B(136)+1.25*B(221)+0.5*B(245)
! JVS(280) = Jac_FULL(43,38)
  JVS(280) = B(152)+1.75*B(276)+B(278)+2*B(280)
! JVS(281) = Jac_FULL(43,39)
  JVS(281) = B(260)
! JVS(282) = Jac_FULL(43,40)
  JVS(282) = 1.6*B(134)+1.55*B(219)+0.8*B(243)
! JVS(283) = Jac_FULL(43,41)
  JVS(283) = 0.77*B(215)
! JVS(284) = Jac_FULL(43,43)
  JVS(284) = -B(10)-B(11)-B(96)-B(154)
! JVS(285) = Jac_FULL(43,44)
  JVS(285) = 0.04*B(132)+0.8*B(217)
! JVS(286) = Jac_FULL(43,45)
  JVS(286) = 0.5*B(233)
! JVS(287) = Jac_FULL(43,46)
  JVS(287) = B(175)+0.53*B(177)+0.18*B(179)+0.53*B(181)
! JVS(288) = Jac_FULL(43,49)
  JVS(288) = 0.28*B(138)+0.89*B(223)+0.14*B(247)
! JVS(289) = Jac_FULL(43,50)
  JVS(289) = 0.75*B(225)
! JVS(290) = Jac_FULL(43,51)
  JVS(290) = 0
! JVS(291) = Jac_FULL(43,52)
  JVS(291) = B(126)+1.5*B(210)+0.75*B(211)+0.75*B(213)+0.77*B(216)+0.8*B(218)+1.55*B(220)+1.25*B(222)+0.89*B(224)+0.75&
               &*B(226)+B(227)+B(230)+B(232)+0.5*B(234)+B(261)+B(272)+1.75*B(277)
! JVS(292) = Jac_FULL(43,53)
  JVS(292) = 0.009*B(79)-B(97)+0.5*B(109)+B(115)
! JVS(293) = Jac_FULL(43,54)
  JVS(293) = -B(155)
! JVS(294) = Jac_FULL(43,55)
  JVS(294) = B(228)+0.8*B(244)+0.5*B(246)+0.14*B(248)+B(279)
! JVS(295) = Jac_FULL(43,56)
  JVS(295) = 0.09*B(128)+0.75*B(214)
! JVS(296) = Jac_FULL(43,57)
  JVS(296) = 0.75*B(212)
! JVS(297) = Jac_FULL(43,58)
  JVS(297) = B(127)+0.09*B(129)+0.04*B(133)+1.6*B(135)+B(137)+0.28*B(139)+B(153)
! JVS(298) = Jac_FULL(43,59)
  JVS(298) = 0
! JVS(299) = Jac_FULL(44,9)
  JVS(299) = B(82)
! JVS(300) = Jac_FULL(44,44)
  JVS(300) = -B(132)-B(190)-B(217)-B(241)
! JVS(301) = Jac_FULL(44,51)
  JVS(301) = -B(191)
! JVS(302) = Jac_FULL(44,52)
  JVS(302) = -B(218)
! JVS(303) = Jac_FULL(44,53)
  JVS(303) = B(83)
! JVS(304) = Jac_FULL(44,55)
  JVS(304) = -B(242)
! JVS(305) = Jac_FULL(44,58)
  JVS(305) = -B(133)
! JVS(306) = Jac_FULL(45,12)
  JVS(306) = B(125)
! JVS(307) = Jac_FULL(45,22)
  JVS(307) = 0.9*B(94)
! JVS(308) = Jac_FULL(45,30)
  JVS(308) = B(20)+B(106)+B(162)
! JVS(309) = Jac_FULL(45,35)
  JVS(309) = 0
! JVS(310) = Jac_FULL(45,36)
  JVS(310) = 0
! JVS(311) = Jac_FULL(45,45)
  JVS(311) = -B(123)-B(142)-B(206)-B(233)-B(256)
! JVS(312) = Jac_FULL(45,51)
  JVS(312) = -B(207)
! JVS(313) = Jac_FULL(45,52)
  JVS(313) = -B(234)
! JVS(314) = Jac_FULL(45,53)
  JVS(314) = 0.9*B(95)+B(107)
! JVS(315) = Jac_FULL(45,54)
  JVS(315) = B(163)
! JVS(316) = Jac_FULL(45,55)
  JVS(316) = -B(257)
! JVS(317) = Jac_FULL(45,58)
  JVS(317) = -B(143)
! JVS(318) = Jac_FULL(45,59)
  JVS(318) = -B(124)
! JVS(319) = Jac_FULL(46,19)
  JVS(319) = B(22)
! JVS(320) = Jac_FULL(46,24)
  JVS(320) = -B(174)
! JVS(321) = Jac_FULL(46,27)
  JVS(321) = -B(180)
! JVS(322) = Jac_FULL(46,28)
  JVS(322) = -B(176)
! JVS(323) = Jac_FULL(46,29)
  JVS(323) = -B(178)
! JVS(324) = Jac_FULL(46,46)
  JVS(324) = -B(2)-B(3)-B(30)-B(32)-B(34)-B(50)-B(175)-B(177)-B(179)-B(181)
! JVS(325) = Jac_FULL(46,51)
  JVS(325) = -B(35)
! JVS(326) = Jac_FULL(46,53)
  JVS(326) = -B(33)
! JVS(327) = Jac_FULL(46,54)
  JVS(327) = 0
! JVS(328) = Jac_FULL(46,58)
  JVS(328) = -B(31)
! JVS(329) = Jac_FULL(46,59)
  JVS(329) = -B(51)
! JVS(330) = Jac_FULL(47,32)
  JVS(330) = B(267)
! JVS(331) = Jac_FULL(47,38)
  JVS(331) = B(208)
! JVS(332) = Jac_FULL(47,41)
  JVS(332) = 0.08*B(130)
! JVS(333) = Jac_FULL(47,44)
  JVS(333) = 0.24*B(132)
! JVS(334) = Jac_FULL(47,46)
  JVS(334) = 0
! JVS(335) = Jac_FULL(47,47)
  JVS(335) = -B(21)-B(116)
! JVS(336) = Jac_FULL(47,51)
  JVS(336) = B(209)
! JVS(337) = Jac_FULL(47,52)
  JVS(337) = 0
! JVS(338) = Jac_FULL(47,53)
  JVS(338) = -B(117)
! JVS(339) = Jac_FULL(47,54)
  JVS(339) = 0
! JVS(340) = Jac_FULL(47,55)
  JVS(340) = 0
! JVS(341) = Jac_FULL(47,56)
  JVS(341) = 0.036*B(128)
! JVS(342) = Jac_FULL(47,58)
  JVS(342) = 0.036*B(129)+0.08*B(131)+0.24*B(133)
! JVS(343) = Jac_FULL(47,59)
  JVS(343) = B(268)
! JVS(344) = Jac_FULL(48,16)
  JVS(344) = 0.075*B(78)
! JVS(345) = Jac_FULL(48,27)
  JVS(345) = 0.5*B(180)
! JVS(346) = Jac_FULL(48,28)
  JVS(346) = 0.5*B(176)
! JVS(347) = Jac_FULL(48,29)
  JVS(347) = 0.72*B(178)
! JVS(348) = Jac_FULL(48,37)
  JVS(348) = B(136)+0.75*B(221)+B(245)
! JVS(349) = Jac_FULL(48,38)
  JVS(349) = B(152)+B(276)+B(278)+2*B(280)
! JVS(350) = Jac_FULL(48,40)
  JVS(350) = 0.2*B(134)+0.35*B(219)+0.6*B(243)
! JVS(351) = Jac_FULL(48,41)
  JVS(351) = 0.38*B(130)+0.41*B(215)+0.14*B(239)
! JVS(352) = Jac_FULL(48,42)
  JVS(352) = B(14)+0.5*B(110)
! JVS(353) = Jac_FULL(48,44)
  JVS(353) = 0.35*B(132)+0.46*B(217)+0.1*B(241)
! JVS(354) = Jac_FULL(48,45)
  JVS(354) = 0
! JVS(355) = Jac_FULL(48,46)
  JVS(355) = 0.5*B(177)+0.72*B(179)+0.5*B(181)
! JVS(356) = Jac_FULL(48,47)
  JVS(356) = 0.2*B(21)
! JVS(357) = Jac_FULL(48,48)
  JVS(357) = -B(12)-B(98)-B(156)
! JVS(358) = Jac_FULL(48,49)
  JVS(358) = 1.45*B(138)+0.725*B(223)+0.725*B(247)
! JVS(359) = Jac_FULL(48,50)
  JVS(359) = 0
! JVS(360) = Jac_FULL(48,51)
  JVS(360) = 0
! JVS(361) = Jac_FULL(48,52)
  JVS(361) = 0.75*B(211)+0.15*B(213)+0.41*B(216)+0.46*B(218)+0.35*B(220)+0.75*B(222)+0.725*B(224)+B(277)
! JVS(362) = Jac_FULL(48,53)
  JVS(362) = 0.075*B(79)-B(99)+0.5*B(111)
! JVS(363) = Jac_FULL(48,54)
  JVS(363) = -B(157)
! JVS(364) = Jac_FULL(48,55)
  JVS(364) = B(235)+0.2*B(237)+0.14*B(240)+0.1*B(242)+0.6*B(244)+B(246)+0.725*B(248)+B(279)
! JVS(365) = Jac_FULL(48,56)
  JVS(365) = 0.75*B(128)+0.15*B(214)+0.2*B(238)
! JVS(366) = Jac_FULL(48,57)
  JVS(366) = B(148)+0.75*B(212)+B(236)
! JVS(367) = Jac_FULL(48,58)
  JVS(367) = 0.75*B(129)+0.38*B(131)+0.35*B(133)+0.2*B(135)+B(137)+1.45*B(139)+B(149)+B(153)
! JVS(368) = Jac_FULL(48,59)
  JVS(368) = 0
! JVS(369) = Jac_FULL(49,29)
  JVS(369) = B(88)
! JVS(370) = Jac_FULL(49,46)
  JVS(370) = 0
! JVS(371) = Jac_FULL(49,49)
  JVS(371) = -B(138)-B(196)-B(223)-B(247)
! JVS(372) = Jac_FULL(49,51)
  JVS(372) = -B(197)
! JVS(373) = Jac_FULL(49,52)
  JVS(373) = -B(224)
! JVS(374) = Jac_FULL(49,53)
  JVS(374) = B(89)
! JVS(375) = Jac_FULL(49,54)
  JVS(375) = 0
! JVS(376) = Jac_FULL(49,55)
  JVS(376) = -B(248)
! JVS(377) = Jac_FULL(49,58)
  JVS(377) = -B(139)
! JVS(378) = Jac_FULL(49,59)
  JVS(378) = 0
! JVS(379) = Jac_FULL(50,33)
  JVS(379) = B(100)
! JVS(380) = Jac_FULL(50,41)
  JVS(380) = 0
! JVS(381) = Jac_FULL(50,44)
  JVS(381) = 0
! JVS(382) = Jac_FULL(50,46)
  JVS(382) = 0
! JVS(383) = Jac_FULL(50,47)
  JVS(383) = 0
! JVS(384) = Jac_FULL(50,49)
  JVS(384) = 0
! JVS(385) = Jac_FULL(50,50)
  JVS(385) = -B(150)-B(198)-B(225)-B(249)
! JVS(386) = Jac_FULL(50,51)
  JVS(386) = -B(199)
! JVS(387) = Jac_FULL(50,52)
  JVS(387) = -B(226)
! JVS(388) = Jac_FULL(50,53)
  JVS(388) = B(101)
! JVS(389) = Jac_FULL(50,54)
  JVS(389) = 0
! JVS(390) = Jac_FULL(50,55)
  JVS(390) = -B(250)
! JVS(391) = Jac_FULL(50,56)
  JVS(391) = 0
! JVS(392) = Jac_FULL(50,58)
  JVS(392) = -B(151)
! JVS(393) = Jac_FULL(50,59)
  JVS(393) = 0
! JVS(394) = Jac_FULL(51,5)
  JVS(394) = B(70)
! JVS(395) = Jac_FULL(51,10)
  JVS(395) = 0.25*B(90)
! JVS(396) = Jac_FULL(51,11)
  JVS(396) = 0.17*B(92)
! JVS(397) = Jac_FULL(51,14)
  JVS(397) = B(44)
! JVS(398) = Jac_FULL(51,16)
  JVS(398) = 0.17*B(78)
! JVS(399) = Jac_FULL(51,20)
  JVS(399) = 0.65*B(6)+B(40)
! JVS(400) = Jac_FULL(51,21)
  JVS(400) = B(13)
! JVS(401) = Jac_FULL(51,22)
  JVS(401) = 0.1*B(94)
! JVS(402) = Jac_FULL(51,24)
  JVS(402) = 0.12*B(174)
! JVS(403) = Jac_FULL(51,26)
  JVS(403) = B(72)
! JVS(404) = Jac_FULL(51,27)
  JVS(404) = 0.23*B(180)
! JVS(405) = Jac_FULL(51,28)
  JVS(405) = 0.23*B(176)
! JVS(406) = Jac_FULL(51,29)
  JVS(406) = 0.26*B(178)
! JVS(407) = Jac_FULL(51,30)
  JVS(407) = B(20)
! JVS(408) = Jac_FULL(51,31)
  JVS(408) = 0.8*B(18)+B(102)+B(158)
! JVS(409) = Jac_FULL(51,32)
  JVS(409) = -B(269)+B(271)
! JVS(410) = Jac_FULL(51,34)
  JVS(410) = B(19)
! JVS(411) = Jac_FULL(51,35)
  JVS(411) = B(144)-B(202)+2*B(229)+B(252)
! JVS(412) = Jac_FULL(51,36)
  JVS(412) = B(146)-B(204)+2*B(231)+B(254)
! JVS(413) = Jac_FULL(51,37)
  JVS(413) = B(136)-B(194)+B(221)+0.5*B(245)
! JVS(414) = Jac_FULL(51,38)
  JVS(414) = -B(208)+0.5*B(276)
! JVS(415) = Jac_FULL(51,39)
  JVS(415) = -B(258)+B(260)
! JVS(416) = Jac_FULL(51,40)
  JVS(416) = B(134)-B(192)+B(219)+0.5*B(243)
! JVS(417) = Jac_FULL(51,41)
  JVS(417) = 0.92*B(130)-B(188)+B(215)+0.5*B(239)
! JVS(418) = Jac_FULL(51,42)
  JVS(418) = B(14)
! JVS(419) = Jac_FULL(51,43)
  JVS(419) = 2*B(11)+B(96)+B(154)
! JVS(420) = Jac_FULL(51,44)
  JVS(420) = 0.76*B(132)-B(190)+B(217)+0.5*B(241)
! JVS(421) = Jac_FULL(51,45)
  JVS(421) = 0.92*B(142)-B(206)+0.46*B(233)+0.92*B(256)
! JVS(422) = Jac_FULL(51,46)
  JVS(422) = B(32)-B(34)+0.12*B(175)+0.23*B(177)+0.26*B(179)+0.23*B(181)
! JVS(423) = Jac_FULL(51,47)
  JVS(423) = B(21)
! JVS(424) = Jac_FULL(51,48)
  JVS(424) = B(12)
! JVS(425) = Jac_FULL(51,49)
  JVS(425) = B(138)-B(196)+B(223)+0.5*B(247)
! JVS(426) = Jac_FULL(51,50)
  JVS(426) = B(150)-B(198)+B(225)+0.5*B(249)
! JVS(427) = Jac_FULL(51,51)
  JVS(427) = -B(35)-B(36)-B(38)-2*B(41)-2*B(42)-B(56)-B(68)-B(182)-B(184)-B(186)-B(189)-B(191)-B(193)-B(195)-B(197)&
               &-B(199)-B(200)-B(203)-B(205)-B(207)-B(209)-B(259)-B(270)
! JVS(428) = Jac_FULL(51,52)
  JVS(428) = B(126)-B(183)+B(210)+B(211)+B(213)+B(216)+B(218)+B(220)+B(222)+B(224)+B(226)+0.5*B(227)+2*B(230)+2*B(232)&
               &+0.46*B(234)+B(261)+B(272)+0.5*B(277)
! JVS(429) = Jac_FULL(51,53)
  JVS(429) = B(33)+B(45)-B(69)+B(71)+B(73)+0.17*B(79)+0.25*B(91)+0.17*B(93)+0.1*B(95)+B(97)+B(103)
! JVS(430) = Jac_FULL(51,54)
  JVS(430) = -B(57)+B(155)+B(159)
! JVS(431) = Jac_FULL(51,55)
  JVS(431) = -B(201)+0.5*B(228)+0.5*B(235)+0.5*B(237)+0.5*B(240)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)&
               &+B(253)+B(255)+0.92*B(257)
! JVS(432) = Jac_FULL(51,56)
  JVS(432) = 0.964*B(128)-B(187)+B(214)+0.5*B(238)
! JVS(433) = Jac_FULL(51,57)
  JVS(433) = B(148)-B(185)+B(212)+0.5*B(236)
! JVS(434) = Jac_FULL(51,58)
  JVS(434) = -B(37)+B(127)+0.964*B(129)+0.92*B(131)+0.76*B(133)+B(135)+B(137)+B(139)+0.92*B(143)+B(145)+B(147)+B(149)&
               &+B(151)
! JVS(435) = Jac_FULL(51,59)
  JVS(435) = -B(39)
! JVS(436) = Jac_FULL(52,17)
  JVS(436) = B(74)
! JVS(437) = Jac_FULL(52,18)
  JVS(437) = B(15)
! JVS(438) = Jac_FULL(52,21)
  JVS(438) = 0.5*B(108)
! JVS(439) = Jac_FULL(52,27)
  JVS(439) = 0.22*B(180)
! JVS(440) = Jac_FULL(52,28)
  JVS(440) = 0.22*B(176)
! JVS(441) = Jac_FULL(52,29)
  JVS(441) = 0.31*B(178)
! JVS(442) = Jac_FULL(52,32)
  JVS(442) = -B(271)+B(273)
! JVS(443) = Jac_FULL(52,35)
  JVS(443) = -B(229)+B(252)
! JVS(444) = Jac_FULL(52,36)
  JVS(444) = -B(231)+B(254)
! JVS(445) = Jac_FULL(52,37)
  JVS(445) = -B(221)+0.5*B(245)
! JVS(446) = Jac_FULL(52,38)
  JVS(446) = -B(276)+0.5*B(278)
! JVS(447) = Jac_FULL(52,39)
  JVS(447) = -B(260)+B(262)
! JVS(448) = Jac_FULL(52,40)
  JVS(448) = -B(219)+0.5*B(243)
! JVS(449) = Jac_FULL(52,41)
  JVS(449) = -B(215)+0.5*B(239)
! JVS(450) = Jac_FULL(52,44)
  JVS(450) = -B(217)+0.5*B(241)
! JVS(451) = Jac_FULL(52,45)
  JVS(451) = -B(233)+B(256)
! JVS(452) = Jac_FULL(52,46)
  JVS(452) = 0.22*B(177)+0.31*B(179)+0.22*B(181)
! JVS(453) = Jac_FULL(52,48)
  JVS(453) = B(12)
! JVS(454) = Jac_FULL(52,49)
  JVS(454) = -B(223)+0.5*B(247)
! JVS(455) = Jac_FULL(52,50)
  JVS(455) = -B(225)+0.5*B(249)
! JVS(456) = Jac_FULL(52,51)
  JVS(456) = -B(182)
! JVS(457) = Jac_FULL(52,52)
  JVS(457) = -B(126)-B(183)-2*B(210)-B(211)-B(213)-B(216)-B(218)-B(220)-B(222)-B(224)-B(226)-0.5*B(227)-B(230)-B(232)&
               &-B(234)-B(261)-B(272)-B(277)
! JVS(458) = Jac_FULL(52,53)
  JVS(458) = B(75)+0.5*B(109)
! JVS(459) = Jac_FULL(52,54)
  JVS(459) = 0
! JVS(460) = Jac_FULL(52,55)
  JVS(460) = B(140)-0.5*B(228)+0.5*B(235)+0.5*B(237)+0.5*B(240)+0.5*B(242)+0.5*B(244)+0.5*B(246)+0.5*B(248)+0.5*B(250)+2&
               &*B(251)+B(253)+B(255)+B(257)+B(263)+B(274)+0.5*B(279)
! JVS(461) = Jac_FULL(52,56)
  JVS(461) = -B(214)+0.5*B(238)
! JVS(462) = Jac_FULL(52,57)
  JVS(462) = -B(212)+0.5*B(236)
! JVS(463) = Jac_FULL(52,58)
  JVS(463) = -B(127)+B(141)
! JVS(464) = Jac_FULL(52,59)
  JVS(464) = 0
! JVS(465) = Jac_FULL(53,5)
  JVS(465) = -B(70)
! JVS(466) = Jac_FULL(53,6)
  JVS(466) = -B(76)
! JVS(467) = Jac_FULL(53,7)
  JVS(467) = 2*B(28)
! JVS(468) = Jac_FULL(53,8)
  JVS(468) = -B(80)
! JVS(469) = Jac_FULL(53,9)
  JVS(469) = -B(82)
! JVS(470) = Jac_FULL(53,10)
  JVS(470) = -B(90)
! JVS(471) = Jac_FULL(53,11)
  JVS(471) = -B(92)
! JVS(472) = Jac_FULL(53,13)
  JVS(472) = B(4)
! JVS(473) = Jac_FULL(53,14)
  JVS(473) = 2*B(9)-B(44)
! JVS(474) = Jac_FULL(53,16)
  JVS(474) = -B(78)
! JVS(475) = Jac_FULL(53,17)
  JVS(475) = -B(74)
! JVS(476) = Jac_FULL(53,18)
  JVS(476) = B(15)-B(112)
! JVS(477) = Jac_FULL(53,20)
  JVS(477) = 0.35*B(6)-B(66)
! JVS(478) = Jac_FULL(53,21)
  JVS(478) = B(13)-0.5*B(108)
! JVS(479) = Jac_FULL(53,22)
  JVS(479) = -1.9*B(94)
! JVS(480) = Jac_FULL(53,23)
  JVS(480) = -B(114)
! JVS(481) = Jac_FULL(53,24)
  JVS(481) = -B(84)
! JVS(482) = Jac_FULL(53,25)
  JVS(482) = B(5)-B(64)
! JVS(483) = Jac_FULL(53,26)
  JVS(483) = -B(72)
! JVS(484) = Jac_FULL(53,27)
  JVS(484) = -B(118)+0.1*B(180)
! JVS(485) = Jac_FULL(53,28)
  JVS(485) = -B(86)+0.1*B(176)
! JVS(486) = Jac_FULL(53,29)
  JVS(486) = -B(88)+0.14*B(178)
! JVS(487) = Jac_FULL(53,30)
  JVS(487) = -B(106)
! JVS(488) = Jac_FULL(53,31)
  JVS(488) = -B(102)
! JVS(489) = Jac_FULL(53,33)
  JVS(489) = -B(100)
! JVS(490) = Jac_FULL(53,34)
  JVS(490) = -B(104)
! JVS(491) = Jac_FULL(53,35)
  JVS(491) = 0
! JVS(492) = Jac_FULL(53,36)
  JVS(492) = 0
! JVS(493) = Jac_FULL(53,41)
  JVS(493) = 0
! JVS(494) = Jac_FULL(53,42)
  JVS(494) = B(14)-0.5*B(110)
! JVS(495) = Jac_FULL(53,43)
  JVS(495) = -B(96)
! JVS(496) = Jac_FULL(53,44)
  JVS(496) = 0
! JVS(497) = Jac_FULL(53,45)
  JVS(497) = 0
! JVS(498) = Jac_FULL(53,46)
  JVS(498) = -B(32)+B(34)+0.1*B(177)+0.14*B(179)+0.1*B(181)
! JVS(499) = Jac_FULL(53,47)
  JVS(499) = -B(116)
! JVS(500) = Jac_FULL(53,48)
  JVS(500) = -B(98)
! JVS(501) = Jac_FULL(53,49)
  JVS(501) = 0
! JVS(502) = Jac_FULL(53,50)
  JVS(502) = 0
! JVS(503) = Jac_FULL(53,51)
  JVS(503) = B(35)+B(36)-B(68)
! JVS(504) = Jac_FULL(53,52)
  JVS(504) = 0
! JVS(505) = Jac_FULL(53,53)
  JVS(505) = -B(33)-B(45)-B(46)-B(62)-B(65)-B(67)-B(69)-B(71)-B(73)-B(75)-B(77)-B(79)-B(81)-B(83)-B(85)-B(87)-B(89)&
               &-B(91)-B(93)-1.9*B(95)-B(97)-B(99)-B(101)-B(103)-B(105)-B(107)-0.5*B(109)-0.5*B(111)-B(113)-B(115)-B(117)&
               &-B(119)
! JVS(506) = Jac_FULL(53,54)
  JVS(506) = 0
! JVS(507) = Jac_FULL(53,55)
  JVS(507) = 0
! JVS(508) = Jac_FULL(53,56)
  JVS(508) = 0
! JVS(509) = Jac_FULL(53,57)
  JVS(509) = 0
! JVS(510) = Jac_FULL(53,58)
  JVS(510) = B(37)-B(47)
! JVS(511) = Jac_FULL(53,59)
  JVS(511) = -B(63)
! JVS(512) = Jac_FULL(54,15)
  JVS(512) = B(60)
! JVS(513) = Jac_FULL(54,20)
  JVS(513) = 0.35*B(6)
! JVS(514) = Jac_FULL(54,22)
  JVS(514) = -B(164)
! JVS(515) = Jac_FULL(54,23)
  JVS(515) = B(114)
! JVS(516) = Jac_FULL(54,24)
  JVS(516) = -B(166)
! JVS(517) = Jac_FULL(54,25)
  JVS(517) = B(64)
! JVS(518) = Jac_FULL(54,27)
  JVS(518) = -B(172)
! JVS(519) = Jac_FULL(54,28)
  JVS(519) = -B(168)
! JVS(520) = Jac_FULL(54,29)
  JVS(520) = -B(170)
! JVS(521) = Jac_FULL(54,30)
  JVS(521) = -B(162)
! JVS(522) = Jac_FULL(54,31)
  JVS(522) = -B(158)
! JVS(523) = Jac_FULL(54,34)
  JVS(523) = -B(160)
! JVS(524) = Jac_FULL(54,35)
  JVS(524) = 0
! JVS(525) = Jac_FULL(54,36)
  JVS(525) = 0
! JVS(526) = Jac_FULL(54,43)
  JVS(526) = -B(154)
! JVS(527) = Jac_FULL(54,44)
  JVS(527) = 0
! JVS(528) = Jac_FULL(54,45)
  JVS(528) = 0
! JVS(529) = Jac_FULL(54,46)
  JVS(529) = B(50)
! JVS(530) = Jac_FULL(54,48)
  JVS(530) = -B(156)
! JVS(531) = Jac_FULL(54,49)
  JVS(531) = 0
! JVS(532) = Jac_FULL(54,50)
  JVS(532) = 0
! JVS(533) = Jac_FULL(54,51)
  JVS(533) = -B(56)
! JVS(534) = Jac_FULL(54,52)
  JVS(534) = 0
! JVS(535) = Jac_FULL(54,53)
  JVS(535) = B(65)+B(115)
! JVS(536) = Jac_FULL(54,54)
  JVS(536) = -B(7)-B(8)-B(52)-B(54)-B(57)-B(58)-B(155)-B(157)-B(159)-B(161)-B(163)-B(165)-B(167)-B(169)-B(171)-B(173)
! JVS(537) = Jac_FULL(54,55)
  JVS(537) = 0
! JVS(538) = Jac_FULL(54,56)
  JVS(538) = 0
! JVS(539) = Jac_FULL(54,57)
  JVS(539) = 0
! JVS(540) = Jac_FULL(54,58)
  JVS(540) = -B(53)
! JVS(541) = Jac_FULL(54,59)
  JVS(541) = B(51)-B(55)-B(59)
! JVS(542) = Jac_FULL(55,18)
  JVS(542) = B(112)
! JVS(543) = Jac_FULL(55,23)
  JVS(543) = B(122)
! JVS(544) = Jac_FULL(55,32)
  JVS(544) = -B(273)
! JVS(545) = Jac_FULL(55,33)
  JVS(545) = B(16)
! JVS(546) = Jac_FULL(55,34)
  JVS(546) = B(19)+B(104)+B(160)
! JVS(547) = Jac_FULL(55,35)
  JVS(547) = -B(252)
! JVS(548) = Jac_FULL(55,36)
  JVS(548) = -B(254)
! JVS(549) = Jac_FULL(55,37)
  JVS(549) = -B(245)
! JVS(550) = Jac_FULL(55,38)
  JVS(550) = -B(278)
! JVS(551) = Jac_FULL(55,39)
  JVS(551) = -B(262)
! JVS(552) = Jac_FULL(55,40)
  JVS(552) = -B(243)
! JVS(553) = Jac_FULL(55,41)
  JVS(553) = -B(239)
! JVS(554) = Jac_FULL(55,44)
  JVS(554) = -B(241)
! JVS(555) = Jac_FULL(55,45)
  JVS(555) = 0.05*B(142)+0.025*B(233)-0.95*B(256)
! JVS(556) = Jac_FULL(55,46)
  JVS(556) = 0
! JVS(557) = Jac_FULL(55,47)
  JVS(557) = 0
! JVS(558) = Jac_FULL(55,48)
  JVS(558) = B(98)+B(156)
! JVS(559) = Jac_FULL(55,49)
  JVS(559) = -B(247)
! JVS(560) = Jac_FULL(55,50)
  JVS(560) = -B(249)
! JVS(561) = Jac_FULL(55,51)
  JVS(561) = -B(200)
! JVS(562) = Jac_FULL(55,52)
  JVS(562) = -B(227)+0.025*B(234)
! JVS(563) = Jac_FULL(55,53)
  JVS(563) = B(99)+B(105)+B(113)
! JVS(564) = Jac_FULL(55,54)
  JVS(564) = B(157)+B(161)
! JVS(565) = Jac_FULL(55,55)
  JVS(565) = -B(120)-B(140)-B(201)-B(228)-B(235)-B(237)-B(240)-B(242)-B(244)-B(246)-B(248)-B(250)-2*B(251)-B(253)-B(255)&
               &-0.95*B(257)-B(263)-B(274)-B(279)
! JVS(566) = Jac_FULL(55,56)
  JVS(566) = -B(238)
! JVS(567) = Jac_FULL(55,57)
  JVS(567) = -B(236)
! JVS(568) = Jac_FULL(55,58)
  JVS(568) = -B(141)+0.05*B(143)
! JVS(569) = Jac_FULL(55,59)
  JVS(569) = -B(121)
! JVS(570) = Jac_FULL(56,16)
  JVS(570) = 0.83*B(78)
! JVS(571) = Jac_FULL(56,42)
  JVS(571) = 0.5*B(110)
! JVS(572) = Jac_FULL(56,44)
  JVS(572) = 0
! JVS(573) = Jac_FULL(56,45)
  JVS(573) = 0
! JVS(574) = Jac_FULL(56,46)
  JVS(574) = 0
! JVS(575) = Jac_FULL(56,47)
  JVS(575) = B(116)
! JVS(576) = Jac_FULL(56,49)
  JVS(576) = 0
! JVS(577) = Jac_FULL(56,50)
  JVS(577) = 0
! JVS(578) = Jac_FULL(56,51)
  JVS(578) = -B(186)
! JVS(579) = Jac_FULL(56,52)
  JVS(579) = -B(213)
! JVS(580) = Jac_FULL(56,53)
  JVS(580) = 0.83*B(79)+0.5*B(111)+B(117)
! JVS(581) = Jac_FULL(56,54)
  JVS(581) = 0
! JVS(582) = Jac_FULL(56,55)
  JVS(582) = -B(237)
! JVS(583) = Jac_FULL(56,56)
  JVS(583) = -B(128)-B(187)-B(214)-B(238)
! JVS(584) = Jac_FULL(56,57)
  JVS(584) = 0
! JVS(585) = Jac_FULL(56,58)
  JVS(585) = -B(129)
! JVS(586) = Jac_FULL(56,59)
  JVS(586) = 0
! JVS(587) = Jac_FULL(57,6)
  JVS(587) = B(76)
! JVS(588) = Jac_FULL(57,33)
  JVS(588) = B(16)
! JVS(589) = Jac_FULL(57,41)
  JVS(589) = 0
! JVS(590) = Jac_FULL(57,44)
  JVS(590) = 0
! JVS(591) = Jac_FULL(57,46)
  JVS(591) = 0
! JVS(592) = Jac_FULL(57,47)
  JVS(592) = 0
! JVS(593) = Jac_FULL(57,49)
  JVS(593) = 0
! JVS(594) = Jac_FULL(57,51)
  JVS(594) = -B(184)
! JVS(595) = Jac_FULL(57,52)
  JVS(595) = -B(211)
! JVS(596) = Jac_FULL(57,53)
  JVS(596) = B(77)
! JVS(597) = Jac_FULL(57,54)
  JVS(597) = 0
! JVS(598) = Jac_FULL(57,55)
  JVS(598) = -B(235)
! JVS(599) = Jac_FULL(57,56)
  JVS(599) = 0
! JVS(600) = Jac_FULL(57,57)
  JVS(600) = -B(148)-B(185)-B(212)-B(236)
! JVS(601) = Jac_FULL(57,58)
  JVS(601) = -B(149)
! JVS(602) = Jac_FULL(57,59)
  JVS(602) = 0
! JVS(603) = Jac_FULL(58,13)
  JVS(603) = B(4)
! JVS(604) = Jac_FULL(58,19)
  JVS(604) = B(24)
! JVS(605) = Jac_FULL(58,35)
  JVS(605) = -B(144)
! JVS(606) = Jac_FULL(58,36)
  JVS(606) = -B(146)
! JVS(607) = Jac_FULL(58,37)
  JVS(607) = -B(136)
! JVS(608) = Jac_FULL(58,38)
  JVS(608) = -B(152)
! JVS(609) = Jac_FULL(58,39)
  JVS(609) = -B(265)
! JVS(610) = Jac_FULL(58,40)
  JVS(610) = -B(134)
! JVS(611) = Jac_FULL(58,41)
  JVS(611) = -B(130)
! JVS(612) = Jac_FULL(58,44)
  JVS(612) = -B(132)
! JVS(613) = Jac_FULL(58,45)
  JVS(613) = -B(142)
! JVS(614) = Jac_FULL(58,46)
  JVS(614) = -B(30)
! JVS(615) = Jac_FULL(58,49)
  JVS(615) = -B(138)
! JVS(616) = Jac_FULL(58,50)
  JVS(616) = -B(150)
! JVS(617) = Jac_FULL(58,51)
  JVS(617) = -B(36)
! JVS(618) = Jac_FULL(58,52)
  JVS(618) = -B(126)
! JVS(619) = Jac_FULL(58,53)
  JVS(619) = -B(46)
! JVS(620) = Jac_FULL(58,54)
  JVS(620) = B(7)-B(52)+B(54)
! JVS(621) = Jac_FULL(58,55)
  JVS(621) = -B(140)
! JVS(622) = Jac_FULL(58,56)
  JVS(622) = -B(128)
! JVS(623) = Jac_FULL(58,57)
  JVS(623) = -B(148)
! JVS(624) = Jac_FULL(58,58)
  JVS(624) = -B(31)-B(37)-B(47)-2*B(48)-B(53)-B(127)-B(129)-B(131)-B(133)-B(135)-B(137)-B(139)-B(141)-B(143)-B(145)&
               &-B(147)-B(149)-B(151)-B(153)-B(266)
! JVS(625) = Jac_FULL(58,59)
  JVS(625) = B(1)+B(25)+B(55)
! JVS(626) = Jac_FULL(59,12)
  JVS(626) = B(125)
! JVS(627) = Jac_FULL(59,15)
  JVS(627) = B(60)
! JVS(628) = Jac_FULL(59,19)
  JVS(628) = -B(24)
! JVS(629) = Jac_FULL(59,20)
  JVS(629) = 0.65*B(6)+B(40)+B(66)
! JVS(630) = Jac_FULL(59,23)
  JVS(630) = B(122)
! JVS(631) = Jac_FULL(59,25)
  JVS(631) = B(5)
! JVS(632) = Jac_FULL(59,30)
  JVS(632) = 0
! JVS(633) = Jac_FULL(59,31)
  JVS(633) = 0
! JVS(634) = Jac_FULL(59,32)
  JVS(634) = -B(267)
! JVS(635) = Jac_FULL(59,34)
  JVS(635) = 0
! JVS(636) = Jac_FULL(59,35)
  JVS(636) = B(144)
! JVS(637) = Jac_FULL(59,36)
  JVS(637) = B(146)
! JVS(638) = Jac_FULL(59,37)
  JVS(638) = B(136)
! JVS(639) = Jac_FULL(59,38)
  JVS(639) = 2*B(152)+B(276)+B(278)+2*B(280)
! JVS(640) = Jac_FULL(59,39)
  JVS(640) = B(265)
! JVS(641) = Jac_FULL(59,40)
  JVS(641) = B(134)
! JVS(642) = Jac_FULL(59,41)
  JVS(642) = 0.92*B(130)
! JVS(643) = Jac_FULL(59,43)
  JVS(643) = 0
! JVS(644) = Jac_FULL(59,44)
  JVS(644) = 0.76*B(132)
! JVS(645) = Jac_FULL(59,45)
  JVS(645) = -B(123)+B(142)
! JVS(646) = Jac_FULL(59,46)
  JVS(646) = B(30)-B(50)
! JVS(647) = Jac_FULL(59,47)
  JVS(647) = B(21)+B(116)
! JVS(648) = Jac_FULL(59,48)
  JVS(648) = 0
! JVS(649) = Jac_FULL(59,49)
  JVS(649) = B(138)
! JVS(650) = Jac_FULL(59,50)
  JVS(650) = B(150)
! JVS(651) = Jac_FULL(59,51)
  JVS(651) = B(36)-B(38)
! JVS(652) = Jac_FULL(59,52)
  JVS(652) = B(126)+B(277)
! JVS(653) = Jac_FULL(59,53)
  JVS(653) = -B(62)+B(67)+B(117)
! JVS(654) = Jac_FULL(59,54)
  JVS(654) = B(8)+2*B(52)-B(58)
! JVS(655) = Jac_FULL(59,55)
  JVS(655) = -B(120)+B(140)+B(279)
! JVS(656) = Jac_FULL(59,56)
  JVS(656) = 0.964*B(128)
! JVS(657) = Jac_FULL(59,57)
  JVS(657) = B(148)
! JVS(658) = Jac_FULL(59,58)
  JVS(658) = B(31)+B(37)+2*B(48)+2*B(53)+B(127)+0.964*B(129)+0.92*B(131)+0.76*B(133)+B(135)+B(137)+B(139)+B(141)+B(143)&
               &+B(145)+B(147)+B(149)+B(151)+2*B(153)+B(266)
! JVS(659) = Jac_FULL(59,59)
  JVS(659) = -B(1)-B(25)-B(39)-B(51)-B(59)-B(63)-B(121)-B(124)-B(268)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)+JVS(2)*UV(5)+JVS(3)*UV(53)
  JUV(2) = JVS(4)*UV(2)+JVS(5)*UV(24)+JVS(6)*UV(27)+JVS(7)*UV(28)+JVS(8)*UV(29)+JVS(9)*UV(46)
  JUV(3) = JVS(10)*UV(3)+JVS(11)*UV(27)+JVS(12)*UV(28)+JVS(13)*UV(29)+JVS(14)*UV(37)+JVS(15)*UV(38)+JVS(16)*UV(40)&
             &+JVS(17)*UV(41)+JVS(18)*UV(44)+JVS(19)*UV(45)+JVS(20)*UV(46)+JVS(21)*UV(49)+JVS(22)*UV(50)+JVS(23)*UV(52)&
             &+JVS(24)*UV(55)+JVS(25)*UV(56)+JVS(26)*UV(57)
  JUV(4) = JVS(27)*UV(4)+JVS(28)*UV(26)+JVS(29)*UV(53)
  JUV(5) = JVS(30)*UV(5)+JVS(31)*UV(53)
  JUV(6) = JVS(32)*UV(6)+JVS(33)*UV(53)
  JUV(7) = JVS(34)*UV(7)+JVS(35)*UV(46)
  JUV(8) = JVS(36)*UV(8)+JVS(37)*UV(53)
  JUV(9) = JVS(38)*UV(9)+JVS(39)*UV(53)
  JUV(10) = JVS(40)*UV(10)+JVS(41)*UV(53)
  JUV(11) = JVS(42)*UV(11)+JVS(43)*UV(53)
  JUV(12) = JVS(44)*UV(12)+JVS(45)*UV(45)+JVS(46)*UV(59)
  JUV(13) = JVS(47)*UV(13)+JVS(48)*UV(53)+JVS(49)*UV(58)
  JUV(14) = JVS(50)*UV(14)+JVS(51)*UV(51)+JVS(52)*UV(53)
  JUV(15) = JVS(53)*UV(15)+JVS(54)*UV(54)+JVS(55)*UV(59)
  JUV(16) = JVS(56)*UV(16)+JVS(57)*UV(53)
  JUV(17) = JVS(58)*UV(17)+JVS(59)*UV(28)+JVS(60)*UV(29)+JVS(61)*UV(46)+JVS(62)*UV(53)
  JUV(18) = JVS(63)*UV(18)+JVS(64)*UV(51)+JVS(65)*UV(53)+JVS(66)*UV(55)
  JUV(19) = JVS(67)*UV(7)+JVS(68)*UV(19)+JVS(69)*UV(46)+JVS(70)*UV(54)+JVS(71)*UV(59)
  JUV(20) = JVS(72)*UV(20)+JVS(73)*UV(51)+JVS(74)*UV(53)+JVS(75)*UV(59)
  JUV(21) = JVS(76)*UV(21)+JVS(77)*UV(51)+JVS(78)*UV(52)+JVS(79)*UV(53)
  JUV(22) = JVS(80)*UV(10)+JVS(81)*UV(11)+JVS(82)*UV(22)+JVS(83)*UV(53)+JVS(84)*UV(54)
  JUV(23) = JVS(85)*UV(23)+JVS(86)*UV(53)+JVS(87)*UV(55)+JVS(88)*UV(59)
  JUV(24) = JVS(89)*UV(24)+JVS(90)*UV(46)+JVS(91)*UV(53)+JVS(92)*UV(54)
  JUV(25) = JVS(93)*UV(15)+JVS(94)*UV(22)+JVS(95)*UV(25)+JVS(96)*UV(30)+JVS(97)*UV(31)+JVS(98)*UV(34)+JVS(99)*UV(43)&
              &+JVS(100)*UV(48)+JVS(101)*UV(51)+JVS(102)*UV(53)+JVS(103)*UV(54)+JVS(104)*UV(59)
  JUV(26) = JVS(105)*UV(24)+JVS(106)*UV(26)+JVS(107)*UV(27)+JVS(108)*UV(28)+JVS(109)*UV(29)+JVS(110)*UV(31)+JVS(111)&
              &*UV(34)+JVS(112)*UV(43)+JVS(113)*UV(45)+JVS(114)*UV(46)+JVS(115)*UV(48)+JVS(116)*UV(52)+JVS(117)*UV(53)&
              &+JVS(118)*UV(54)+JVS(119)*UV(55)+JVS(120)*UV(58)
  JUV(27) = JVS(121)*UV(27)+JVS(122)*UV(46)+JVS(123)*UV(53)+JVS(124)*UV(54)
  JUV(28) = JVS(125)*UV(28)+JVS(126)*UV(46)+JVS(127)*UV(53)+JVS(128)*UV(54)
  JUV(29) = JVS(129)*UV(29)+JVS(130)*UV(46)+JVS(131)*UV(53)+JVS(132)*UV(54)
  JUV(30) = JVS(133)*UV(30)+JVS(134)*UV(35)+JVS(135)*UV(36)+JVS(136)*UV(52)+JVS(137)*UV(53)+JVS(138)*UV(54)+JVS(139)&
              &*UV(55)+JVS(140)*UV(58)
  JUV(31) = JVS(141)*UV(31)+JVS(142)*UV(35)+JVS(143)*UV(45)+JVS(144)*UV(52)+JVS(145)*UV(53)+JVS(146)*UV(54)+JVS(147)&
              &*UV(55)+JVS(148)*UV(58)
  JUV(32) = JVS(149)*UV(22)+JVS(150)*UV(32)+JVS(151)*UV(51)+JVS(152)*UV(52)+JVS(154)*UV(54)+JVS(155)*UV(55)+JVS(156)&
              &*UV(59)
  JUV(33) = JVS(157)*UV(16)+JVS(158)*UV(29)+JVS(159)*UV(33)+JVS(160)*UV(41)+JVS(161)*UV(44)+JVS(162)*UV(46)+JVS(163)&
              &*UV(47)+JVS(164)*UV(49)+JVS(165)*UV(52)+JVS(166)*UV(53)+JVS(168)*UV(55)+JVS(169)*UV(56)+JVS(170)*UV(58)
  JUV(34) = JVS(171)*UV(34)+JVS(172)*UV(35)+JVS(173)*UV(36)+JVS(174)*UV(45)+JVS(175)*UV(50)+JVS(176)*UV(52)+JVS(177)&
              &*UV(53)+JVS(178)*UV(54)+JVS(179)*UV(55)+JVS(180)*UV(58)
  JUV(35) = JVS(181)*UV(10)+JVS(182)*UV(35)+JVS(183)*UV(51)+JVS(184)*UV(52)+JVS(185)*UV(53)+JVS(186)*UV(55)+JVS(187)&
              &*UV(58)
  JUV(36) = JVS(188)*UV(11)+JVS(189)*UV(36)+JVS(190)*UV(51)+JVS(191)*UV(52)+JVS(192)*UV(53)+JVS(193)*UV(55)+JVS(194)&
              &*UV(58)
  JUV(37) = JVS(195)*UV(27)+JVS(196)*UV(28)+JVS(197)*UV(37)+JVS(199)*UV(51)+JVS(200)*UV(52)+JVS(201)*UV(53)+JVS(203)&
              &*UV(55)+JVS(204)*UV(58)
  JUV(38) = JVS(205)*UV(24)+JVS(206)*UV(27)+JVS(207)*UV(28)+JVS(208)*UV(29)+JVS(209)*UV(38)+JVS(211)*UV(51)+JVS(212)&
              &*UV(52)+JVS(214)*UV(54)+JVS(215)*UV(55)+JVS(216)*UV(58)
  JUV(39) = JVS(217)*UV(8)+JVS(218)*UV(9)+JVS(219)*UV(22)+JVS(220)*UV(23)+JVS(221)*UV(39)+JVS(222)*UV(45)+JVS(223)&
              &*UV(51)+JVS(224)*UV(52)+JVS(225)*UV(53)+JVS(227)*UV(55)+JVS(228)*UV(58)
  JUV(40) = JVS(230)*UV(24)+JVS(231)*UV(40)+JVS(233)*UV(51)+JVS(234)*UV(52)+JVS(235)*UV(53)+JVS(237)*UV(55)+JVS(238)&
              &*UV(58)
  JUV(41) = JVS(239)*UV(8)+JVS(240)*UV(41)+JVS(241)*UV(51)+JVS(242)*UV(52)+JVS(243)*UV(53)+JVS(244)*UV(55)+JVS(245)&
              &*UV(58)
  JUV(42) = JVS(246)*UV(32)+JVS(247)*UV(35)+JVS(248)*UV(36)+JVS(249)*UV(37)+JVS(250)*UV(39)+JVS(251)*UV(40)+JVS(252)&
              &*UV(41)+JVS(253)*UV(42)+JVS(254)*UV(44)+JVS(255)*UV(45)+JVS(257)*UV(49)+JVS(258)*UV(50)+JVS(259)*UV(51)&
              &+JVS(261)*UV(53)+JVS(264)*UV(56)+JVS(265)*UV(57)
  JUV(43) = JVS(268)*UV(16)+JVS(269)*UV(21)+JVS(270)*UV(23)+JVS(271)*UV(24)+JVS(272)*UV(27)+JVS(273)*UV(28)+JVS(274)&
              &*UV(29)+JVS(275)*UV(31)+JVS(276)*UV(32)+JVS(277)*UV(35)+JVS(278)*UV(36)+JVS(279)*UV(37)+JVS(280)*UV(38)&
              &+JVS(281)*UV(39)+JVS(282)*UV(40)+JVS(283)*UV(41)+JVS(284)*UV(43)+JVS(285)*UV(44)+JVS(286)*UV(45)+JVS(287)&
              &*UV(46)+JVS(288)*UV(49)+JVS(289)*UV(50)+JVS(291)*UV(52)+JVS(292)*UV(53)+JVS(293)*UV(54)+JVS(294)*UV(55)&
              &+JVS(295)*UV(56)+JVS(296)*UV(57)+JVS(297)*UV(58)
  JUV(44) = JVS(299)*UV(9)+JVS(300)*UV(44)+JVS(301)*UV(51)+JVS(302)*UV(52)+JVS(303)*UV(53)+JVS(304)*UV(55)+JVS(305)&
              &*UV(58)
  JUV(45) = JVS(306)*UV(12)+JVS(307)*UV(22)+JVS(308)*UV(30)+JVS(311)*UV(45)+JVS(312)*UV(51)+JVS(313)*UV(52)+JVS(314)&
              &*UV(53)+JVS(315)*UV(54)+JVS(316)*UV(55)+JVS(317)*UV(58)+JVS(318)*UV(59)
  JUV(46) = JVS(319)*UV(19)+JVS(320)*UV(24)+JVS(321)*UV(27)+JVS(322)*UV(28)+JVS(323)*UV(29)+JVS(324)*UV(46)+JVS(325)&
              &*UV(51)+JVS(326)*UV(53)+JVS(328)*UV(58)+JVS(329)*UV(59)
  JUV(47) = JVS(330)*UV(32)+JVS(331)*UV(38)+JVS(332)*UV(41)+JVS(333)*UV(44)+JVS(335)*UV(47)+JVS(336)*UV(51)+JVS(338)&
              &*UV(53)+JVS(341)*UV(56)+JVS(342)*UV(58)+JVS(343)*UV(59)
  JUV(48) = JVS(344)*UV(16)+JVS(345)*UV(27)+JVS(346)*UV(28)+JVS(347)*UV(29)+JVS(348)*UV(37)+JVS(349)*UV(38)+JVS(350)&
              &*UV(40)+JVS(351)*UV(41)+JVS(352)*UV(42)+JVS(353)*UV(44)+JVS(355)*UV(46)+JVS(356)*UV(47)+JVS(357)*UV(48)&
              &+JVS(358)*UV(49)+JVS(361)*UV(52)+JVS(362)*UV(53)+JVS(363)*UV(54)+JVS(364)*UV(55)+JVS(365)*UV(56)+JVS(366)&
              &*UV(57)+JVS(367)*UV(58)
  JUV(49) = JVS(369)*UV(29)+JVS(371)*UV(49)+JVS(372)*UV(51)+JVS(373)*UV(52)+JVS(374)*UV(53)+JVS(376)*UV(55)+JVS(377)&
              &*UV(58)
  JUV(50) = JVS(379)*UV(33)+JVS(385)*UV(50)+JVS(386)*UV(51)+JVS(387)*UV(52)+JVS(388)*UV(53)+JVS(390)*UV(55)+JVS(392)&
              &*UV(58)
  JUV(51) = JVS(394)*UV(5)+JVS(395)*UV(10)+JVS(396)*UV(11)+JVS(397)*UV(14)+JVS(398)*UV(16)+JVS(399)*UV(20)+JVS(400)&
              &*UV(21)+JVS(401)*UV(22)+JVS(402)*UV(24)+JVS(403)*UV(26)+JVS(404)*UV(27)+JVS(405)*UV(28)+JVS(406)*UV(29)&
              &+JVS(407)*UV(30)+JVS(408)*UV(31)+JVS(409)*UV(32)+JVS(410)*UV(34)+JVS(411)*UV(35)+JVS(412)*UV(36)+JVS(413)&
              &*UV(37)+JVS(414)*UV(38)+JVS(415)*UV(39)+JVS(416)*UV(40)+JVS(417)*UV(41)+JVS(418)*UV(42)+JVS(419)*UV(43)&
              &+JVS(420)*UV(44)+JVS(421)*UV(45)+JVS(422)*UV(46)+JVS(423)*UV(47)+JVS(424)*UV(48)+JVS(425)*UV(49)+JVS(426)&
              &*UV(50)+JVS(427)*UV(51)+JVS(428)*UV(52)+JVS(429)*UV(53)+JVS(430)*UV(54)+JVS(431)*UV(55)+JVS(432)*UV(56)&
              &+JVS(433)*UV(57)+JVS(434)*UV(58)+JVS(435)*UV(59)
  JUV(52) = JVS(436)*UV(17)+JVS(437)*UV(18)+JVS(438)*UV(21)+JVS(439)*UV(27)+JVS(440)*UV(28)+JVS(441)*UV(29)+JVS(442)&
              &*UV(32)+JVS(443)*UV(35)+JVS(444)*UV(36)+JVS(445)*UV(37)+JVS(446)*UV(38)+JVS(447)*UV(39)+JVS(448)*UV(40)&
              &+JVS(449)*UV(41)+JVS(450)*UV(44)+JVS(451)*UV(45)+JVS(452)*UV(46)+JVS(453)*UV(48)+JVS(454)*UV(49)+JVS(455)&
              &*UV(50)+JVS(456)*UV(51)+JVS(457)*UV(52)+JVS(458)*UV(53)+JVS(460)*UV(55)+JVS(461)*UV(56)+JVS(462)*UV(57)&
              &+JVS(463)*UV(58)
  JUV(53) = JVS(465)*UV(5)+JVS(466)*UV(6)+JVS(467)*UV(7)+JVS(468)*UV(8)+JVS(469)*UV(9)+JVS(470)*UV(10)+JVS(471)*UV(11)&
              &+JVS(472)*UV(13)+JVS(473)*UV(14)+JVS(474)*UV(16)+JVS(475)*UV(17)+JVS(476)*UV(18)+JVS(477)*UV(20)+JVS(478)&
              &*UV(21)+JVS(479)*UV(22)+JVS(480)*UV(23)+JVS(481)*UV(24)+JVS(482)*UV(25)+JVS(483)*UV(26)+JVS(484)*UV(27)&
              &+JVS(485)*UV(28)+JVS(486)*UV(29)+JVS(487)*UV(30)+JVS(488)*UV(31)+JVS(489)*UV(33)+JVS(490)*UV(34)+JVS(494)&
              &*UV(42)+JVS(495)*UV(43)+JVS(498)*UV(46)+JVS(499)*UV(47)+JVS(500)*UV(48)+JVS(503)*UV(51)+JVS(505)*UV(53)&
              &+JVS(510)*UV(58)+JVS(511)*UV(59)
  JUV(54) = JVS(512)*UV(15)+JVS(513)*UV(20)+JVS(514)*UV(22)+JVS(515)*UV(23)+JVS(516)*UV(24)+JVS(517)*UV(25)+JVS(518)&
              &*UV(27)+JVS(519)*UV(28)+JVS(520)*UV(29)+JVS(521)*UV(30)+JVS(522)*UV(31)+JVS(523)*UV(34)+JVS(526)*UV(43)&
              &+JVS(529)*UV(46)+JVS(530)*UV(48)+JVS(533)*UV(51)+JVS(535)*UV(53)+JVS(536)*UV(54)+JVS(540)*UV(58)+JVS(541)&
              &*UV(59)
  JUV(55) = JVS(542)*UV(18)+JVS(543)*UV(23)+JVS(544)*UV(32)+JVS(545)*UV(33)+JVS(546)*UV(34)+JVS(547)*UV(35)+JVS(548)&
              &*UV(36)+JVS(549)*UV(37)+JVS(550)*UV(38)+JVS(551)*UV(39)+JVS(552)*UV(40)+JVS(553)*UV(41)+JVS(554)*UV(44)&
              &+JVS(555)*UV(45)+JVS(558)*UV(48)+JVS(559)*UV(49)+JVS(560)*UV(50)+JVS(561)*UV(51)+JVS(562)*UV(52)+JVS(563)&
              &*UV(53)+JVS(564)*UV(54)+JVS(565)*UV(55)+JVS(566)*UV(56)+JVS(567)*UV(57)+JVS(568)*UV(58)+JVS(569)*UV(59)
  JUV(56) = JVS(570)*UV(16)+JVS(571)*UV(42)+JVS(575)*UV(47)+JVS(578)*UV(51)+JVS(579)*UV(52)+JVS(580)*UV(53)+JVS(582)&
              &*UV(55)+JVS(583)*UV(56)+JVS(585)*UV(58)
  JUV(57) = JVS(587)*UV(6)+JVS(588)*UV(33)+JVS(594)*UV(51)+JVS(595)*UV(52)+JVS(596)*UV(53)+JVS(598)*UV(55)+JVS(600)&
              &*UV(57)+JVS(601)*UV(58)
  JUV(58) = JVS(603)*UV(13)+JVS(604)*UV(19)+JVS(605)*UV(35)+JVS(606)*UV(36)+JVS(607)*UV(37)+JVS(608)*UV(38)+JVS(609)&
              &*UV(39)+JVS(610)*UV(40)+JVS(611)*UV(41)+JVS(612)*UV(44)+JVS(613)*UV(45)+JVS(614)*UV(46)+JVS(615)*UV(49)&
              &+JVS(616)*UV(50)+JVS(617)*UV(51)+JVS(618)*UV(52)+JVS(619)*UV(53)+JVS(620)*UV(54)+JVS(621)*UV(55)+JVS(622)&
              &*UV(56)+JVS(623)*UV(57)+JVS(624)*UV(58)+JVS(625)*UV(59)
  JUV(59) = JVS(626)*UV(12)+JVS(627)*UV(15)+JVS(628)*UV(19)+JVS(629)*UV(20)+JVS(630)*UV(23)+JVS(631)*UV(25)+JVS(634)&
              &*UV(32)+JVS(636)*UV(35)+JVS(637)*UV(36)+JVS(638)*UV(37)+JVS(639)*UV(38)+JVS(640)*UV(39)+JVS(641)*UV(40)&
              &+JVS(642)*UV(41)+JVS(644)*UV(44)+JVS(645)*UV(45)+JVS(646)*UV(46)+JVS(647)*UV(47)+JVS(649)*UV(49)+JVS(650)&
              &*UV(50)+JVS(651)*UV(51)+JVS(652)*UV(52)+JVS(653)*UV(53)+JVS(654)*UV(54)+JVS(655)*UV(55)+JVS(656)*UV(56)&
              &+JVS(657)*UV(57)+JVS(658)*UV(58)+JVS(659)*UV(59)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)
  JTUV(2) = JVS(4)*UV(2)
  JTUV(3) = JVS(10)*UV(3)
  JTUV(4) = JVS(27)*UV(4)
  JTUV(5) = JVS(2)*UV(1)+JVS(30)*UV(5)+JVS(394)*UV(51)+JVS(465)*UV(53)
  JTUV(6) = JVS(32)*UV(6)+JVS(466)*UV(53)+JVS(587)*UV(57)
  JTUV(7) = JVS(34)*UV(7)+JVS(67)*UV(19)+JVS(467)*UV(53)
  JTUV(8) = JVS(36)*UV(8)+JVS(217)*UV(39)+JVS(239)*UV(41)+JVS(468)*UV(53)
  JTUV(9) = JVS(38)*UV(9)+JVS(218)*UV(39)+JVS(299)*UV(44)+JVS(469)*UV(53)
  JTUV(10) = JVS(40)*UV(10)+JVS(80)*UV(22)+JVS(181)*UV(35)+JVS(395)*UV(51)+JVS(470)*UV(53)
  JTUV(11) = JVS(42)*UV(11)+JVS(81)*UV(22)+JVS(188)*UV(36)+JVS(396)*UV(51)+JVS(471)*UV(53)
  JTUV(12) = JVS(44)*UV(12)+JVS(306)*UV(45)+JVS(626)*UV(59)
  JTUV(13) = JVS(47)*UV(13)+JVS(472)*UV(53)+JVS(603)*UV(58)
  JTUV(14) = JVS(50)*UV(14)+JVS(397)*UV(51)+JVS(473)*UV(53)
  JTUV(15) = JVS(53)*UV(15)+JVS(93)*UV(25)+JVS(512)*UV(54)+JVS(627)*UV(59)
  JTUV(16) = JVS(56)*UV(16)+JVS(157)*UV(33)+JVS(268)*UV(43)+JVS(344)*UV(48)+JVS(398)*UV(51)+JVS(474)*UV(53)+JVS(570)&
               &*UV(56)
  JTUV(17) = JVS(58)*UV(17)+JVS(436)*UV(52)+JVS(475)*UV(53)
  JTUV(18) = JVS(63)*UV(18)+JVS(437)*UV(52)+JVS(476)*UV(53)+JVS(542)*UV(55)
  JTUV(19) = JVS(68)*UV(19)+JVS(319)*UV(46)+JVS(604)*UV(58)+JVS(628)*UV(59)
  JTUV(20) = JVS(72)*UV(20)+JVS(399)*UV(51)+JVS(477)*UV(53)+JVS(513)*UV(54)+JVS(629)*UV(59)
  JTUV(21) = JVS(76)*UV(21)+JVS(269)*UV(43)+JVS(400)*UV(51)+JVS(438)*UV(52)+JVS(478)*UV(53)
  JTUV(22) = JVS(82)*UV(22)+JVS(94)*UV(25)+JVS(149)*UV(32)+JVS(219)*UV(39)+JVS(307)*UV(45)+JVS(401)*UV(51)+JVS(479)&
               &*UV(53)+JVS(514)*UV(54)
  JTUV(23) = JVS(85)*UV(23)+JVS(220)*UV(39)+JVS(270)*UV(43)+JVS(480)*UV(53)+JVS(515)*UV(54)+JVS(543)*UV(55)+JVS(630)&
               &*UV(59)
  JTUV(24) = JVS(5)*UV(2)+JVS(89)*UV(24)+JVS(105)*UV(26)+JVS(205)*UV(38)+JVS(230)*UV(40)+JVS(271)*UV(43)+JVS(320)*UV(46)&
               &+JVS(402)*UV(51)+JVS(481)*UV(53)+JVS(516)*UV(54)
  JTUV(25) = JVS(95)*UV(25)+JVS(482)*UV(53)+JVS(517)*UV(54)+JVS(631)*UV(59)
  JTUV(26) = JVS(28)*UV(4)+JVS(106)*UV(26)+JVS(403)*UV(51)+JVS(483)*UV(53)
  JTUV(27) = JVS(6)*UV(2)+JVS(11)*UV(3)+JVS(107)*UV(26)+JVS(121)*UV(27)+JVS(195)*UV(37)+JVS(206)*UV(38)+JVS(272)*UV(43)&
               &+JVS(321)*UV(46)+JVS(345)*UV(48)+JVS(404)*UV(51)+JVS(439)*UV(52)+JVS(484)*UV(53)+JVS(518)*UV(54)
  JTUV(28) = JVS(7)*UV(2)+JVS(12)*UV(3)+JVS(59)*UV(17)+JVS(108)*UV(26)+JVS(125)*UV(28)+JVS(196)*UV(37)+JVS(207)*UV(38)&
               &+JVS(273)*UV(43)+JVS(322)*UV(46)+JVS(346)*UV(48)+JVS(405)*UV(51)+JVS(440)*UV(52)+JVS(485)*UV(53)+JVS(519)&
               &*UV(54)
  JTUV(29) = JVS(8)*UV(2)+JVS(13)*UV(3)+JVS(60)*UV(17)+JVS(109)*UV(26)+JVS(129)*UV(29)+JVS(158)*UV(33)+JVS(208)*UV(38)&
               &+JVS(274)*UV(43)+JVS(323)*UV(46)+JVS(347)*UV(48)+JVS(369)*UV(49)+JVS(406)*UV(51)+JVS(441)*UV(52)+JVS(486)&
               &*UV(53)+JVS(520)*UV(54)
  JTUV(30) = JVS(96)*UV(25)+JVS(133)*UV(30)+JVS(308)*UV(45)+JVS(407)*UV(51)+JVS(487)*UV(53)+JVS(521)*UV(54)
  JTUV(31) = JVS(97)*UV(25)+JVS(110)*UV(26)+JVS(141)*UV(31)+JVS(275)*UV(43)+JVS(408)*UV(51)+JVS(488)*UV(53)+JVS(522)&
               &*UV(54)
  JTUV(32) = JVS(150)*UV(32)+JVS(246)*UV(42)+JVS(276)*UV(43)+JVS(330)*UV(47)+JVS(409)*UV(51)+JVS(442)*UV(52)+JVS(544)&
               &*UV(55)+JVS(634)*UV(59)
  JTUV(33) = JVS(159)*UV(33)+JVS(379)*UV(50)+JVS(489)*UV(53)+JVS(545)*UV(55)+JVS(588)*UV(57)
  JTUV(34) = JVS(98)*UV(25)+JVS(111)*UV(26)+JVS(171)*UV(34)+JVS(410)*UV(51)+JVS(490)*UV(53)+JVS(523)*UV(54)+JVS(546)&
               &*UV(55)
  JTUV(35) = JVS(134)*UV(30)+JVS(142)*UV(31)+JVS(172)*UV(34)+JVS(182)*UV(35)+JVS(247)*UV(42)+JVS(277)*UV(43)+JVS(411)&
               &*UV(51)+JVS(443)*UV(52)+JVS(547)*UV(55)+JVS(605)*UV(58)+JVS(636)*UV(59)
  JTUV(36) = JVS(135)*UV(30)+JVS(173)*UV(34)+JVS(189)*UV(36)+JVS(248)*UV(42)+JVS(278)*UV(43)+JVS(412)*UV(51)+JVS(444)&
               &*UV(52)+JVS(548)*UV(55)+JVS(606)*UV(58)+JVS(637)*UV(59)
  JTUV(37) = JVS(14)*UV(3)+JVS(197)*UV(37)+JVS(249)*UV(42)+JVS(279)*UV(43)+JVS(348)*UV(48)+JVS(413)*UV(51)+JVS(445)&
               &*UV(52)+JVS(549)*UV(55)+JVS(607)*UV(58)+JVS(638)*UV(59)
  JTUV(38) = JVS(15)*UV(3)+JVS(209)*UV(38)+JVS(280)*UV(43)+JVS(331)*UV(47)+JVS(349)*UV(48)+JVS(414)*UV(51)+JVS(446)&
               &*UV(52)+JVS(550)*UV(55)+JVS(608)*UV(58)+JVS(639)*UV(59)
  JTUV(39) = JVS(221)*UV(39)+JVS(250)*UV(42)+JVS(281)*UV(43)+JVS(415)*UV(51)+JVS(447)*UV(52)+JVS(551)*UV(55)+JVS(609)&
               &*UV(58)+JVS(640)*UV(59)
  JTUV(40) = JVS(16)*UV(3)+JVS(231)*UV(40)+JVS(251)*UV(42)+JVS(282)*UV(43)+JVS(350)*UV(48)+JVS(416)*UV(51)+JVS(448)&
               &*UV(52)+JVS(552)*UV(55)+JVS(610)*UV(58)+JVS(641)*UV(59)
  JTUV(41) = JVS(17)*UV(3)+JVS(160)*UV(33)+JVS(240)*UV(41)+JVS(252)*UV(42)+JVS(283)*UV(43)+JVS(332)*UV(47)+JVS(351)&
               &*UV(48)+JVS(417)*UV(51)+JVS(449)*UV(52)+JVS(553)*UV(55)+JVS(611)*UV(58)+JVS(642)*UV(59)
  JTUV(42) = JVS(253)*UV(42)+JVS(352)*UV(48)+JVS(418)*UV(51)+JVS(494)*UV(53)+JVS(571)*UV(56)
  JTUV(43) = JVS(99)*UV(25)+JVS(112)*UV(26)+JVS(284)*UV(43)+JVS(419)*UV(51)+JVS(495)*UV(53)+JVS(526)*UV(54)
  JTUV(44) = JVS(18)*UV(3)+JVS(161)*UV(33)+JVS(254)*UV(42)+JVS(285)*UV(43)+JVS(300)*UV(44)+JVS(333)*UV(47)+JVS(353)&
               &*UV(48)+JVS(420)*UV(51)+JVS(450)*UV(52)+JVS(554)*UV(55)+JVS(612)*UV(58)+JVS(644)*UV(59)
  JTUV(45) = JVS(19)*UV(3)+JVS(45)*UV(12)+JVS(113)*UV(26)+JVS(143)*UV(31)+JVS(174)*UV(34)+JVS(222)*UV(39)+JVS(255)&
               &*UV(42)+JVS(286)*UV(43)+JVS(311)*UV(45)+JVS(421)*UV(51)+JVS(451)*UV(52)+JVS(555)*UV(55)+JVS(613)*UV(58)&
               &+JVS(645)*UV(59)
  JTUV(46) = JVS(9)*UV(2)+JVS(20)*UV(3)+JVS(35)*UV(7)+JVS(61)*UV(17)+JVS(69)*UV(19)+JVS(90)*UV(24)+JVS(114)*UV(26)&
               &+JVS(122)*UV(27)+JVS(126)*UV(28)+JVS(130)*UV(29)+JVS(162)*UV(33)+JVS(287)*UV(43)+JVS(324)*UV(46)+JVS(355)&
               &*UV(48)+JVS(422)*UV(51)+JVS(452)*UV(52)+JVS(498)*UV(53)+JVS(529)*UV(54)+JVS(614)*UV(58)+JVS(646)*UV(59)
  JTUV(47) = JVS(163)*UV(33)+JVS(335)*UV(47)+JVS(356)*UV(48)+JVS(423)*UV(51)+JVS(499)*UV(53)+JVS(575)*UV(56)+JVS(647)&
               &*UV(59)
  JTUV(48) = JVS(100)*UV(25)+JVS(115)*UV(26)+JVS(357)*UV(48)+JVS(424)*UV(51)+JVS(453)*UV(52)+JVS(500)*UV(53)+JVS(530)&
               &*UV(54)+JVS(558)*UV(55)
  JTUV(49) = JVS(21)*UV(3)+JVS(164)*UV(33)+JVS(257)*UV(42)+JVS(288)*UV(43)+JVS(358)*UV(48)+JVS(371)*UV(49)+JVS(425)&
               &*UV(51)+JVS(454)*UV(52)+JVS(559)*UV(55)+JVS(615)*UV(58)+JVS(649)*UV(59)
  JTUV(50) = JVS(22)*UV(3)+JVS(175)*UV(34)+JVS(258)*UV(42)+JVS(289)*UV(43)+JVS(385)*UV(50)+JVS(426)*UV(51)+JVS(455)&
               &*UV(52)+JVS(560)*UV(55)+JVS(616)*UV(58)+JVS(650)*UV(59)
  JTUV(51) = JVS(51)*UV(14)+JVS(64)*UV(18)+JVS(73)*UV(20)+JVS(77)*UV(21)+JVS(101)*UV(25)+JVS(151)*UV(32)+JVS(183)*UV(35)&
               &+JVS(190)*UV(36)+JVS(199)*UV(37)+JVS(211)*UV(38)+JVS(223)*UV(39)+JVS(233)*UV(40)+JVS(241)*UV(41)+JVS(259)&
               &*UV(42)+JVS(301)*UV(44)+JVS(312)*UV(45)+JVS(325)*UV(46)+JVS(336)*UV(47)+JVS(372)*UV(49)+JVS(386)*UV(50)&
               &+JVS(427)*UV(51)+JVS(456)*UV(52)+JVS(503)*UV(53)+JVS(533)*UV(54)+JVS(561)*UV(55)+JVS(578)*UV(56)+JVS(594)&
               &*UV(57)+JVS(617)*UV(58)+JVS(651)*UV(59)
  JTUV(52) = JVS(23)*UV(3)+JVS(78)*UV(21)+JVS(116)*UV(26)+JVS(136)*UV(30)+JVS(144)*UV(31)+JVS(152)*UV(32)+JVS(165)&
               &*UV(33)+JVS(176)*UV(34)+JVS(184)*UV(35)+JVS(191)*UV(36)+JVS(200)*UV(37)+JVS(212)*UV(38)+JVS(224)*UV(39)&
               &+JVS(234)*UV(40)+JVS(242)*UV(41)+JVS(291)*UV(43)+JVS(302)*UV(44)+JVS(313)*UV(45)+JVS(361)*UV(48)+JVS(373)&
               &*UV(49)+JVS(387)*UV(50)+JVS(428)*UV(51)+JVS(457)*UV(52)+JVS(562)*UV(55)+JVS(579)*UV(56)+JVS(595)*UV(57)&
               &+JVS(618)*UV(58)+JVS(652)*UV(59)
  JTUV(53) = JVS(3)*UV(1)+JVS(29)*UV(4)+JVS(31)*UV(5)+JVS(33)*UV(6)+JVS(37)*UV(8)+JVS(39)*UV(9)+JVS(41)*UV(10)+JVS(43)&
               &*UV(11)+JVS(48)*UV(13)+JVS(52)*UV(14)+JVS(57)*UV(16)+JVS(62)*UV(17)+JVS(65)*UV(18)+JVS(74)*UV(20)+JVS(79)&
               &*UV(21)+JVS(83)*UV(22)+JVS(86)*UV(23)+JVS(91)*UV(24)+JVS(102)*UV(25)+JVS(117)*UV(26)+JVS(123)*UV(27)&
               &+JVS(127)*UV(28)+JVS(131)*UV(29)+JVS(137)*UV(30)+JVS(145)*UV(31)+JVS(166)*UV(33)+JVS(177)*UV(34)+JVS(185)&
               &*UV(35)+JVS(192)*UV(36)+JVS(201)*UV(37)+JVS(225)*UV(39)+JVS(235)*UV(40)+JVS(243)*UV(41)+JVS(261)*UV(42)&
               &+JVS(292)*UV(43)+JVS(303)*UV(44)+JVS(314)*UV(45)+JVS(326)*UV(46)+JVS(338)*UV(47)+JVS(362)*UV(48)+JVS(374)&
               &*UV(49)+JVS(388)*UV(50)+JVS(429)*UV(51)+JVS(458)*UV(52)+JVS(505)*UV(53)+JVS(535)*UV(54)+JVS(563)*UV(55)&
               &+JVS(580)*UV(56)+JVS(596)*UV(57)+JVS(619)*UV(58)+JVS(653)*UV(59)
  JTUV(54) = JVS(54)*UV(15)+JVS(70)*UV(19)+JVS(84)*UV(22)+JVS(92)*UV(24)+JVS(103)*UV(25)+JVS(118)*UV(26)+JVS(124)*UV(27)&
               &+JVS(128)*UV(28)+JVS(132)*UV(29)+JVS(138)*UV(30)+JVS(146)*UV(31)+JVS(154)*UV(32)+JVS(178)*UV(34)+JVS(214)&
               &*UV(38)+JVS(293)*UV(43)+JVS(315)*UV(45)+JVS(363)*UV(48)+JVS(430)*UV(51)+JVS(536)*UV(54)+JVS(564)*UV(55)&
               &+JVS(620)*UV(58)+JVS(654)*UV(59)
  JTUV(55) = JVS(24)*UV(3)+JVS(66)*UV(18)+JVS(87)*UV(23)+JVS(119)*UV(26)+JVS(139)*UV(30)+JVS(147)*UV(31)+JVS(155)*UV(32)&
               &+JVS(168)*UV(33)+JVS(179)*UV(34)+JVS(186)*UV(35)+JVS(193)*UV(36)+JVS(203)*UV(37)+JVS(215)*UV(38)+JVS(227)&
               &*UV(39)+JVS(237)*UV(40)+JVS(244)*UV(41)+JVS(294)*UV(43)+JVS(304)*UV(44)+JVS(316)*UV(45)+JVS(364)*UV(48)&
               &+JVS(376)*UV(49)+JVS(390)*UV(50)+JVS(431)*UV(51)+JVS(460)*UV(52)+JVS(565)*UV(55)+JVS(582)*UV(56)+JVS(598)&
               &*UV(57)+JVS(621)*UV(58)+JVS(655)*UV(59)
  JTUV(56) = JVS(25)*UV(3)+JVS(169)*UV(33)+JVS(264)*UV(42)+JVS(295)*UV(43)+JVS(341)*UV(47)+JVS(365)*UV(48)+JVS(432)&
               &*UV(51)+JVS(461)*UV(52)+JVS(566)*UV(55)+JVS(583)*UV(56)+JVS(622)*UV(58)+JVS(656)*UV(59)
  JTUV(57) = JVS(26)*UV(3)+JVS(265)*UV(42)+JVS(296)*UV(43)+JVS(366)*UV(48)+JVS(433)*UV(51)+JVS(462)*UV(52)+JVS(567)&
               &*UV(55)+JVS(600)*UV(57)+JVS(623)*UV(58)+JVS(657)*UV(59)
  JTUV(58) = JVS(49)*UV(13)+JVS(120)*UV(26)+JVS(140)*UV(30)+JVS(148)*UV(31)+JVS(170)*UV(33)+JVS(180)*UV(34)+JVS(187)&
               &*UV(35)+JVS(194)*UV(36)+JVS(204)*UV(37)+JVS(216)*UV(38)+JVS(228)*UV(39)+JVS(238)*UV(40)+JVS(245)*UV(41)&
               &+JVS(297)*UV(43)+JVS(305)*UV(44)+JVS(317)*UV(45)+JVS(328)*UV(46)+JVS(342)*UV(47)+JVS(367)*UV(48)+JVS(377)&
               &*UV(49)+JVS(392)*UV(50)+JVS(434)*UV(51)+JVS(463)*UV(52)+JVS(510)*UV(53)+JVS(540)*UV(54)+JVS(568)*UV(55)&
               &+JVS(585)*UV(56)+JVS(601)*UV(57)+JVS(624)*UV(58)+JVS(658)*UV(59)
  JTUV(59) = JVS(46)*UV(12)+JVS(55)*UV(15)+JVS(71)*UV(19)+JVS(75)*UV(20)+JVS(88)*UV(23)+JVS(104)*UV(25)+JVS(156)*UV(32)&
               &+JVS(318)*UV(45)+JVS(329)*UV(46)+JVS(343)*UV(47)+JVS(435)*UV(51)+JVS(511)*UV(53)+JVS(541)*UV(54)+JVS(569)&
               &*UV(55)+JVS(625)*UV(58)+JVS(659)*UV(59)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADM2_Jacobian

